/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.prompts.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.INotifyListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.prompts.IDataProviderListener;
import com.sas.etl.models.prompts.impl.DISPromptLogFactory;
import com.sas.etl.models.prompts.impl.DefaultLogicalServer;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.iom.SAS.IWorkspace;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.models.SASLibraryLocation;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.BaseDataSourceColumn;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.valueprovider.dynamic.DataProvider;
import com.sas.prompts.valueprovider.dynamic.DataProviderUtil;
import com.sas.prompts.valueprovider.dynamic.PromptDataProviderInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.ColumnAttributes;
import com.sas.services.information.metadata.ColumnInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.services.information.metadata.OMRPhysicalTable;
import com.sas.services.information.metadata.OMRProperty;
import com.sas.services.information.metadata.OMRPropertySet;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PhysicalTableAttributes;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.PropertySetInterface;
import com.sas.services.information.metadata.RelationalSchemaInterface;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceAdapterSupport;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.swing.visuals.IFileValidator;
import com.sas.text.SASFormat;
import com.sas.util.FileValidatorInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;

public class PromptDataProvider
extends DataProvider
implements INotifyListener {
    private Map m_mapURLTables;
    private Map m_mapModelSources;
    private Map m_mapModelTargets;
    private LogicalServerInterface m_defaultLogicalServer;
    private IModel m_model;
    private RepositoryInterface m_repository;
    private Map m_smartTables;
    ChildServerInterface m_childServer;
    List m_listeners;
    private Map m_columnMap;
    private List m_wsAppServers;
    private CommonLoggerInterface m_logger;

    public PromptDataProvider(IModel model) throws RemoteException, ServerConnectionException, ServiceException, MdException {
        this(model, null, null);
    }

    public PromptDataProvider(IModel model, IDataObject[] sources, IDataObject[] targets) throws RemoteException, ServerConnectionException, ServiceException, MdException {
        super(Workspace.getWorkspace().getUserContext());
        this.m_model = model;
        this.m_defaultLogicalServer = new DefaultLogicalServer();
        this.m_wsAppServers = new ArrayList();
        this.m_mapURLTables = new HashMap();
        this.m_mapModelSources = new HashMap();
        this.m_mapModelTargets = new HashMap();
        this.m_smartTables = new HashMap();
        this.m_columnMap = new HashMap();
        ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
        this.m_childServer = server.newChild(true);
        this.m_repository = this.m_childServer.getFoundationRepository();
        this.m_listeners = new ArrayList();
        if (sources != null) {
            this.addDataSources(sources);
        }
        if (targets != null) {
            this.addDataTargets(targets);
        }
    }

    public void setModel(IModel model) {
        this.m_model = model;
    }

    public void addListeners(IDataProviderListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeListener(IDataProviderListener listener) {
        this.m_listeners.remove(listener);
    }

    public void fireDataProviderChanged() {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ((IDataProviderListener)this.m_listeners.get(i)).onDataProviderChanged();
        }
    }

    @Override
    public void notify(NotifyEvent ev) {
        try {
            if (ev.getSource() instanceof IPhysicalTable) {
                IPhysicalTable table = (IPhysicalTable)ev.getSource();
                ModelEvent modelEvent = ev.getModelEvent();
                if (modelEvent != null) {
                    String type = modelEvent.getType();
                    boolean changed = false;
                    if ("Object:NameChanged".equals(type) || "IComplexPersistableObject:FolderChanged".equals(type)) {
                        PhysicalTableInterface metaIntr = (PhysicalTableInterface)this.m_smartTables.get(table);
                        this.fixPhysicalTableAttrs(metaIntr, table);
                        Iterator iter = this.m_mapURLTables.keySet().iterator();
                        String url = null;
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            if (this.m_mapURLTables.get(key) != table) continue;
                            url = key;
                            break;
                        }
                        if (url != null) {
                            this.m_mapURLTables.remove(url);
                            this.removeDataSourceFromCache(url);
                            this.addDataSourceToCache((MetadataInterface)metaIntr, table);
                        }
                        changed = true;
                    } else if ("PhysicalTable:SASTableNameChanged".equals(type)) {
                        this.fixPhysicalTableAttrs(this.getPhysicalTable(table.getSBIPUrl()), table);
                        changed = true;
                    } else if ("Table:CaseChanged".equals(type) || "Table:SpecialCharsChanged".equals(type)) {
                        PhysicalTableInterface pt = this.getPhysicalTable(table.getSBIPUrl());
                        this.fixPhysicalTableQuoting(pt, table);
                        changed = true;
                    } else if ("Table:ColumnAdded".equals(type)) {
                        PhysicalTableInterface pt = this.getPhysicalTable(table.getSBIPUrl());
                        IColumn column = (IColumn)modelEvent.getData();
                        this.addPhysicalTableColumn(pt, table, column, table.indexOfColumn(column));
                        changed = true;
                    } else if ("Table:ColumnMoved".equals(type)) {
                        PhysicalTableInterface pt = this.getPhysicalTable(table.getSBIPUrl());
                        this.movePhysicalTableColumn(pt, table, (IColumn)modelEvent.getData());
                        changed = true;
                    } else if ("Table:ColumnRemoved".equals(type)) {
                        PhysicalTableInterface pt = this.getPhysicalTable(table.getSBIPUrl());
                        this.removePhysicalTableColumn(pt, table, (IColumn)modelEvent.getData());
                        changed = true;
                    } else if ("PhysicalTable:LibraryChanged".equals(type)) {
                        PhysicalTableInterface pt = this.getPhysicalTable(table.getSBIPUrl());
                        this.fixPhysicalTableLibrary(pt, table);
                        changed = true;
                    }
                    if (changed) {
                        this.fireDataProviderChanged();
                    }
                }
            } else if (ev.getSource() instanceof IColumn) {
                String type;
                IColumn column = (IColumn)ev.getSource();
                ModelEvent modelEvent = ev.getModelEvent();
                ColumnInterface columnInterface = (ColumnInterface)this.m_columnMap.get(column);
                if (modelEvent != null && columnInterface != null && ("Object:NameChanged".equals(type = modelEvent.getType()) || "Column:LengthChanged".equals(type) || "Column:FormatChanged".equals(type) || "Column:TypeChanged".equals(type) || "Column:InformatChanged".equals(type) || "Object:DescriptionChanged".equals(type))) {
                    this.fixColumnAttributes(columnInterface, column);
                    this.fireDataProviderChanged();
                }
            }
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
    }

    public String getName() {
        if (this.m_childServer instanceof OMIServer) {
            try {
                return ((OMIServer)this.m_childServer).getObjectStore().getStoreName();
            }
            catch (RemoteException e) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
            }
        }
        return "";
    }

    public void addDataSources(IDataObject[] sources) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        if (sources != null && sources.length > 0) {
            for (int i = 0; i < sources.length; ++i) {
                this.addDataSource(sources[i]);
            }
        }
    }

    public void addDataSource(IDataObject source) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        if (source != null && source instanceof IPhysicalTable && !this.isSourceTableUsed((IPhysicalTable)source)) {
            IPhysicalTable table = (IPhysicalTable)source;
            table.addNotifyListener(this);
            DataSourceInterface ds = this.makeTableDataSource(table);
            if (ds != null) {
                this.m_mapModelSources.put(table.getID(), table);
            }
            this.fireDataProviderChanged();
            if (this.m_model.isUndoSupported()) {
                this.m_model.undoableEditHappened(new AddDataSourceUndoable(source));
            }
        }
    }

    public void removeDataSource(IDataObject source) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        if (source != null && source instanceof IPhysicalTable) {
            IPhysicalTable table = (IPhysicalTable)source;
            table.removeNotifyListener(this);
            DataSourceInterface ds = this.makeTableDataSource(table);
            if (ds != null) {
                this.m_mapModelSources.remove(table.getID());
                this.removeDataSourceFromCache(table);
            }
            this.fireDataProviderChanged();
            if (this.m_model.isUndoSupported()) {
                this.m_model.undoableEditHappened(new RemoveDataSourceUndoable(source));
            }
        }
    }

    public void removeDataSources(IDataObject[] sources) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        if (sources != null) {
            for (int i = 0; i < sources.length; ++i) {
                this.removeDataSource(sources[i]);
            }
        }
    }

    public void clearDataSources() throws RemoteException, ServiceException, MdException, ServerConnectionException {
        this.removeDataSources(this.m_mapModelSources.values().toArray(new IDataObject[this.m_mapModelSources.size()]));
    }

    public void addDataTarget(IDataObject target) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        if (target != null && target instanceof IPhysicalTable && !this.isTargetTableUsed((IPhysicalTable)target)) {
            IPhysicalTable table = (IPhysicalTable)target;
            table.addNotifyListener(this);
            DataSourceInterface ds = this.makeTableDataSource(table);
            if (ds != null) {
                this.m_mapModelTargets.put(table.getID(), table);
            }
            this.fireDataProviderChanged();
            if (this.m_model.isUndoSupported()) {
                this.m_model.undoableEditHappened(new AddDataTargetUndoable(target));
            }
        }
    }

    public void removeDataTarget(IDataObject target) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        if (target != null && target instanceof IPhysicalTable) {
            IPhysicalTable table = (IPhysicalTable)target;
            table.removeNotifyListener(this);
            DataSourceInterface ds = this.makeTableDataSource(table);
            if (ds != null) {
                this.m_mapModelTargets.remove(table.getID());
                this.removeDataSourceFromCache(table);
            }
            this.fireDataProviderChanged();
            if (this.m_model.isUndoSupported()) {
                this.m_model.undoableEditHappened(new RemoveDataTargetUndoable(target));
            }
        }
    }

    public void removeDataTargets(IDataObject[] targets) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                this.removeDataTarget(targets[i]);
            }
        }
    }

    public void clearDataTargets() throws RemoteException, ServiceException, MdException, ServerConnectionException {
        this.removeDataTargets(this.m_mapModelTargets.values().toArray(new IDataObject[this.m_mapModelTargets.size()]));
    }

    public void updateIDs(Map mapIDs) {
        Set sourceKeySet = this.m_mapModelSources.keySet();
        for (Object key : sourceKeySet) {
            Object newId = mapIDs.get(key);
            if (newId == null) continue;
            Object val = this.m_mapModelSources.get(key);
            this.m_mapModelSources.remove(key);
            this.m_mapModelSources.put(newId, val);
        }
        Set targetKeySet = this.m_mapModelTargets.keySet();
        for (Object key : targetKeySet) {
            Object newId = mapIDs.get(key);
            if (newId == null) continue;
            Object val = this.m_mapModelTargets.get(key);
            this.m_mapModelTargets.remove(key);
            this.m_mapModelTargets.put(newId, val);
        }
    }

    public Map getSourceTableMap() {
        return new HashMap(this.m_mapModelSources);
    }

    public Map getTargetTableMap() {
        return new HashMap(this.m_mapModelTargets);
    }

    public DataSourceInterface[] getPromptDataSources() throws MdException {
        ArrayList<BaseDataSource> sources = new ArrayList<BaseDataSource>();
        for (IPhysicalTable table : this.m_mapModelSources.values()) {
            sources.add(new BaseDataSource(1L, table.getSBIPUrl()));
        }
        return sources.toArray(new DataSourceInterface[sources.size()]);
    }

    public DataSourceInterface getPromptDataSource(IPhysicalTable table) throws MdException {
        if (table != null) {
            DataSourceInterface[] dss = this.getPromptDataSources();
            for (int i = 0; i < dss.length; ++i) {
                if (!dss[i].getDataSourceLocation().equals(table.getSBIPUrl())) continue;
                return dss[i];
            }
        }
        return null;
    }

    public DataSourceInterface[] getPromptDataTargets() throws MdException {
        ArrayList<BaseDataSource> targets = new ArrayList<BaseDataSource>();
        for (IPhysicalTable table : this.m_mapModelTargets.values()) {
            targets.add(new BaseDataSource(1L, table.getSBIPUrl()));
        }
        return targets.toArray(new DataSourceInterface[targets.size()]);
    }

    public DataSourceInterface getPromptDataTarget(IPhysicalTable table) throws MdException {
        if (table != null) {
            DataSourceInterface[] dss = this.getPromptDataTargets();
            for (int i = 0; i < dss.length; ++i) {
                if (!dss[i].getDataSourceLocation().equals(table.getSBIPUrl())) continue;
                return dss[i];
            }
        }
        return null;
    }

    public void addDataTargets(IDataObject[] targets) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        if (targets != null && targets.length > 0) {
            for (int i = 0; i < targets.length; ++i) {
                this.addDataTarget(targets[i]);
            }
        }
    }

    private LogicalServerInterface getDefaultServer() throws ServerConnectionException, MdException, ServiceException, RemoteException, WsAppServerFailException {
        LogicalServerInterface defaultServer = null;
        WsAppServer appServer = WsAppServer.createDefaultAppServer();
        if (appServer != null) {
            defaultServer = appServer.getLogicalServer();
            appServer.dispose();
        }
        return defaultServer;
    }

    public PhysicalTableInterface getPhysicalTable(String sbipURL) throws ServerConnectionException {
        PhysicalTableInterface physicalTable = null;
        if (this.getUserContext() != null && sbipURL != null && sbipURL.length() > 0) {
            try {
                PhysicalTableInterface pt = this.getPhysicalTableFromCache(sbipURL);
                if (pt != null) {
                    return pt;
                }
                PathUrl url = this.newPathUrl(sbipURL);
                ModelLogger.getDefaultLogger().debug((Object)"PromptDataProvider:getPhysicalTable() attempting to getObjectByPath for:", sbipURL);
                MetadataInterface o = this.m_childServer.getObjectByPath(url);
                if (o instanceof PhysicalTableInterface) {
                    physicalTable = (PhysicalTableInterface)o;
                    IPhysicalTable modelPT = (IPhysicalTable)this.getModelObject(sbipURL);
                    this.addDataSourceToCache((MetadataInterface)physicalTable, modelPT);
                }
            }
            catch (RemoteException re) {
                ModelLogger.getDefaultLogger().error((Object)re.getLocalizedMessage(), (Throwable)re);
                throw new ServerConnectionException((Throwable)re, re.getLocalizedMessage());
            }
            catch (MdException re) {
                ModelLogger.getDefaultLogger().error((Object)re.getLocalizedMessage(), (Throwable)re);
                throw new ServerConnectionException((Throwable)re, re.getLocalizedMessage());
            }
            catch (ServiceException re) {
                ModelLogger.getDefaultLogger().error((Object)re.getLocalizedMessage(), (Throwable)re);
                throw new ServerConnectionException((Throwable)re, re.getLocalizedMessage());
            }
        }
        return physicalTable;
    }

    private PhysicalTableInterface getPhysicalTableFromCache(String sbipUrl) {
        IPhysicalTable pTable = (IPhysicalTable)this.m_mapURLTables.get(sbipUrl);
        if (pTable != null) {
            return (PhysicalTableInterface)this.m_smartTables.get(pTable);
        }
        return null;
    }

    public IWorkspace getIWorkspace(String logicalServerName) throws ServerConnectionException {
        IWorkspace iWorkspace = null;
        try {
            List served;
            if (logicalServerName != null && logicalServerName.equals(DefaultLogicalServer.DEFAULT_SERVER_NAME)) {
                logicalServerName = this.getDefaultServer().getName();
            }
            LogicalServerInterface logicalServer = null;
            List servers = this.getLogicalServers();
            for (int i = 0; i < servers.size(); ++i) {
                LogicalServerInterface server = (LogicalServerInterface)servers.get(i);
                if (!server.getName().equals(logicalServerName)) continue;
                logicalServer = server;
                break;
            }
            if (logicalServer != null && (served = logicalServer.getServed()) != null && !served.isEmpty()) {
                ServerContextInterface sc = (ServerContextInterface)served.get(0);
                WsAppServer wsServer = this.findAppServer(sc);
                if (wsServer == null) {
                    wsServer = WsAppServer.createAppServer((ServerContextInterface)sc);
                    this.m_wsAppServers.add(wsServer);
                }
                wsServer.open();
                return wsServer.getWorkspace();
            }
        }
        catch (RemoteException e) {
            throw new ServerConnectionException((Throwable)e, e.getLocalizedMessage());
        }
        catch (MdException e) {
            throw new ServerConnectionException((Throwable)e, e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            throw new ServerConnectionException((Throwable)e, e.getLocalizedMessage());
        }
        catch (WsAppServerFailException e) {
            throw new ServerConnectionException((Throwable)e, e.getLocalizedMessage());
        }
        return iWorkspace;
    }

    protected WsAppServer findAppServer(ServerContextInterface serverContext) throws RemoteException, ServiceException {
        if (this.m_wsAppServers == null || this.m_wsAppServers.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.m_wsAppServers.size(); ++i) {
            WsAppServer appServer = (WsAppServer)this.m_wsAppServers.get(i);
            if (!appServer.getServerFQID().equals(serverContext.getIdentifier())) continue;
            return appServer;
        }
        return null;
    }

    public LogicalServerInterface getLogicalServerForLibrary(SASLibraryInterface library) throws ServerConnectionException {
        LogicalServerInterface server = super.getLogicalServerForLibrary(library);
        try {
            if (server == null && library.getWorkspaceServers().isEmpty()) {
                return this.getDefaultServer();
            }
        }
        catch (RemoteException re) {
            this.getLogger().error(re.getLocalizedMessage(), (Throwable)re);
            throw new ServerConnectionException((Throwable)re, re.getLocalizedMessage());
        }
        catch (ServiceException ex) {
            this.getLogger().error(ex.getLocalizedMessage(), (Throwable)ex);
            throw new ServerConnectionException((Throwable)ex, ex.getLocalizedMessage());
        }
        catch (MdException ex) {
            this.getLogger().error(ex.getLocalizedMessage(), (Throwable)ex);
            throw new ServerConnectionException((Throwable)ex, ex.getLocalizedMessage());
        }
        catch (WsAppServerFailException ex) {
            this.getLogger().error(ex.getLocalizedMessage(), (Throwable)ex);
            throw new ServerConnectionException((Throwable)ex, ex.getLocalizedMessage());
        }
        return server;
    }

    public List getLogicalServers() throws ServerConnectionException {
        List servers = super.getLogicalServers();
        if (!servers.contains(this.m_defaultLogicalServer)) {
            servers.add(0, this.m_defaultLogicalServer);
        }
        return servers;
    }

    public CommonLoggerInterface getLogger(UserContextInterface userContext) {
        if (null == this.m_logger) {
            this.m_logger = DISPromptLogFactory.getInstance().makeNewLoggerInstance(this.getClass().getName());
        }
        return this.m_logger;
    }

    protected DataSourceInterface makeTableDataSource(IPhysicalTable table) throws RemoteException, ServiceException, MdException {
        BaseDataSource ds = null;
        this.createOMRTable(this.m_repository, table);
        ds = new BaseDataSource(1L, table.getSBIPUrl());
        return ds;
    }

    public void addDataSourceToCache(MetadataInterface meta, IPhysicalTable table) throws MdException {
        String url = table.getSBIPUrl();
        if (url != null) {
            super.addDataSourceToCache(url, (Object)meta);
            this.m_mapURLTables.put(url, table);
            this.m_smartTables.put(table, meta);
        }
    }

    public void removeDataSourceFromCache(IPhysicalTable table) throws MdException {
        super.removeDataSourceFromCache(table.getSBIPUrl());
        this.m_smartTables.remove(table);
        this.m_mapURLTables.remove(table.getSBIPUrl());
    }

    public IPhysicalTable getTable(String url) throws MdException, RemoteException {
        IPhysicalTable table = (IPhysicalTable)this.m_mapURLTables.get(url);
        if (table == null) {
            table = (IPhysicalTable)PromptUtils.getObjectByURL(Workspace.getWorkspace().getUserContext(), this.m_model, url);
        }
        return table;
    }

    public IOMRPersistable getModelObject(String url) throws MdException, RemoteException {
        return PromptUtils.getObjectByURL(Workspace.getWorkspace().getUserContext(), this.m_model, url);
    }

    public DataSourceColumnInterface getDataSourceColumnFromString(String columnName, boolean sources) throws RemoteException, MdException, ServiceException {
        block5: {
            block4: {
                if (!sources || this.m_mapModelSources == null) break block4;
                ArrayList lstSources = new ArrayList(this.m_mapModelSources.values());
                int size = lstSources.size();
                for (int i = 0; i < size; ++i) {
                    IPhysicalTable table = (IPhysicalTable)lstSources.get(i);
                    IColumn[] cols = table.getColumns();
                    for (int j = 0; j < cols.length; ++j) {
                        if (!columnName.equalsIgnoreCase(cols[j].getName())) continue;
                        return this.makeDataSourceColumnInterface(cols[j]);
                    }
                }
                break block5;
            }
            if (this.m_mapModelTargets == null) break block5;
            ArrayList lstTargets = new ArrayList(this.m_mapModelTargets.values());
            int size = lstTargets.size();
            for (int i = 0; i < size; ++i) {
                IPhysicalTable table = (IPhysicalTable)lstTargets.get(i);
                IColumn[] cols = table.getColumns();
                for (int j = 0; j < cols.length; ++j) {
                    if (!columnName.equalsIgnoreCase(cols[j].getName())) continue;
                    return this.makeDataSourceColumnInterface(cols[j]);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SASLibraryLocation getPromptLibraryFromLibrary(ILibrary lib) throws MdException, ServiceException, RemoteException {
        SASLibraryLocation libLocation = null;
        if (lib == null) {
            return libLocation;
        }
        ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
        ChildServerInterface transaction = server.newChild(true);
        try {
            PathUrl t;
            MetadataInterface mInterface = transaction.fetch(lib.getID() + "/" + lib.getOMRType(), true);
            if (mInterface != null && (t = mInterface.getPathUrl()) != null) {
                String url = t.getAbsolutePath();
                libLocation = new SASLibraryLocation(url, lib.getLibref());
            }
        }
        finally {
            transaction.destroy();
        }
        return libLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceInterface getDataSourceFromString(String librefSASTableName) throws MdException, ServiceException, RemoteException {
        BaseDataSource ds;
        block7: {
            ds = null;
            String[] strTablePath = librefSASTableName.split("\\.");
            MdObjectStore store = Workspace.getWorkspace().getMdObjectFactory().createObjectStore(null, "PromptDataProvider: findTable");
            try {
                PhysicalTable pt = PromptDataProvider.findTable(strTablePath, store);
                if (pt == null) break block7;
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                ChildServerInterface transaction = server.newChild(true);
                try {
                    PathUrl url;
                    MetadataInterface metadata = transaction.fetch(pt.getFQID() + "/" + pt.getCMetadataType());
                    if (metadata != null && (url = metadata.getPathUrl()) != null) {
                        ds = new BaseDataSource();
                        ds.setDataSourceLocation(url.getAbsolutePath());
                        ds.setDataSourceType(1L);
                    }
                }
                finally {
                    transaction.destroy();
                }
            }
            finally {
                store.dispose();
            }
        }
        return ds;
    }

    public void close() throws ServerConnectionException {
        super.close();
        for (int i = 0; i < this.m_wsAppServers.size(); ++i) {
            ((WsAppServer)this.m_wsAppServers.get(i)).dispose();
        }
        if (this.m_childServer != null) {
            try {
                this.m_childServer.rollback();
                this.m_childServer = null;
            }
            catch (RemoteException e) {
                throw new ServerConnectionException((Throwable)e, e.getLocalizedMessage());
            }
            catch (ServiceException e) {
                throw new ServerConnectionException((Throwable)e, e.getLocalizedMessage());
            }
        }
    }

    public FileValidatorInterface getFileValidator(String logicalServerName) {
        return new cFileValidator((PromptDataProviderInterface)this, logicalServerName);
    }

    private static PhysicalTable findTable(String[] strTablePath, MdObjectStore store) throws MdException, RemoteException, ServiceException {
        if (strTablePath.length == 0) {
            return null;
        }
        StringBuffer sbOptions = new StringBuffer(100);
        String strLibraryName = strTablePath[0];
        String strSchemaName = null;
        String strTableName = strTablePath[strTablePath.length - 1];
        if (strTablePath.length == 3) {
            strSchemaName = strTablePath[1];
        }
        sbOptions.append("<XMLSelect search=\"");
        PromptDataProvider.generateXMLTableSelect(strLibraryName, strSchemaName, strTableName, sbOptions, true);
        sbOptions.append("\"/>");
        sbOptions.append("<Templates>");
        sbOptions.append("<PhysicalTable SASTableName=\"\"></PhysicalTable>");
        sbOptions.append("</Templates>");
        int fOptions = 8596;
        boolean fserver = store.isGoToServerForMetadata();
        store.setGoToServerForMetadata(true);
        List lTables = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, PromptDataProvider.getRepositoryId(), "PhysicalTable", fOptions, sbOptions.toString());
        store.setGoToServerForMetadata(fserver);
        if (!lTables.isEmpty()) {
            return (PhysicalTable)lTables.get(0);
        }
        return null;
    }

    private static void generateXMLTableSelect(String strLibraryName, String strSchemaName, String tableName, StringBuffer sbSelect, boolean justTable) throws MdException, RemoteException {
        sbSelect.append("PhysicalTable");
        sbSelect.append("[@SASTableName='");
        sbSelect.append(Workspace.getMdFactory().getOMIUtil().cleanStringForXML(tableName));
        sbSelect.append("']");
        if (justTable) {
            sbSelect.append("[");
        } else {
            sbSelect.append("/");
        }
        sbSelect.append("TablePackage/");
        if (strSchemaName != null) {
            PromptDataProvider.generateXMLSchemaSelect(strLibraryName, strSchemaName, sbSelect);
        } else {
            PromptDataProvider.generateXMLLibrarySelect(strLibraryName, sbSelect);
        }
        if (justTable) {
            sbSelect.append("]");
        }
    }

    private static void generateXMLLibrarySelect(String strLibraryName, StringBuffer sbSelect) throws MdException, RemoteException {
        sbSelect.append("SASLibrary");
        sbSelect.append("[@LibRef='");
        sbSelect.append(Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strLibraryName));
        sbSelect.append("']");
    }

    private static void generateXMLSchemaSelect(String strLibraryName, String strSchemaName, StringBuffer sbSelect) throws MdException, RemoteException {
        sbSelect.append("DatabaseSchema");
        sbSelect.append("[@SchemaName='");
        sbSelect.append(Workspace.getMdFactory().getOMIUtil().cleanStringForXML(strSchemaName));
        sbSelect.append("']");
        sbSelect.append("/UsedByPackages/");
        PromptDataProvider.generateXMLLibrarySelect(strLibraryName, sbSelect);
    }

    public IColumn getColumn(DataSourceColumnInterface dsc) throws MdException, RemoteException, ServiceException {
        IColumn col = null;
        IPhysicalTable dataTable = this.getTable(dsc.getDataSource().getDataSourceLocation());
        if (dataTable != null) {
            IColumn[] cols = dataTable.getColumns();
            for (int i = 0; i < cols.length; ++i) {
                IColumn t = cols[i];
                if (!PromptUtils.getValidOMRObjectName(t.getName()).equals(PromptUtils.getValidOMRObjectName(dsc.getColumnName()))) continue;
                col = t;
                break;
            }
        }
        return col;
    }

    public ILibrary getLibrary(SASLibraryLocationInterface lc) throws RemoteException, MdException {
        ILibrary lib = null;
        if (lc != null) {
            lib = (ILibrary)PromptUtils.getObjectByURL(Workspace.getWorkspace().getUserContext(), this.m_model, lc.getSASLibraryLocation());
        }
        return lib;
    }

    private void fixPhysicalTableQuoting(PhysicalTableInterface omrTable, IPhysicalTable local) throws RemoteException, MdException, ServiceException {
        if (omrTable != null && WsMetadataUtil.isNewObject((String)omrTable.getReposId())) {
            OMRPropertySet dbmsNamesSet = null;
            List propertySets = omrTable.getPropertySets();
            for (int i = 0; i < propertySets.size(); ++i) {
                PropertySetInterface pSet;
                Object obj = propertySets.get(i);
                if (!(obj instanceof PropertySetInterface) || !"DBMSNames".equals((pSet = (PropertySetInterface)obj).getSetRole())) continue;
                dbmsNamesSet = pSet;
                break;
            }
            if (dbmsNamesSet == null) {
                dbmsNamesSet = new OMRPropertySet(omrTable.getRepository(), "DBMSNames", null);
                dbmsNamesSet.setSetRole("DBMSNames");
                omrTable.addPropertySet((PropertySetInterface)dbmsNamesSet);
            }
            OMRProperty caseProperty = null;
            PropertyInterface specCharProperty = null;
            List properties = dbmsNamesSet.getObjectProperties();
            for (int i = 0; i < properties.size(); ++i) {
                Object obj = properties.get(i);
                if (!(obj instanceof PropertyInterface)) continue;
                PropertyInterface prop = (PropertyInterface)obj;
                if ("Case".equals(prop.getKey())) {
                    caseProperty = prop;
                    continue;
                }
                if (!"SpecChar".equals(prop.getKey())) continue;
                specCharProperty = prop;
            }
            if (caseProperty == null) {
                caseProperty = new OMRProperty(omrTable.getRepository(), "Case", "Case", local.isCaseSensitive() ? "Y" : "N", "String");
                dbmsNamesSet.addObjectProperty((PropertyInterface)caseProperty);
            } else {
                caseProperty.setValue(local.isCaseSensitive() ? "Y" : "N");
            }
            if (specCharProperty == null) {
                specCharProperty = new OMRProperty(omrTable.getRepository(), "SpecChar", "SpecChar", local.isSpecialCharacters() ? "Y" : "N", "String");
                dbmsNamesSet.addObjectProperty(specCharProperty);
            } else {
                specCharProperty.setValue(local.isSpecialCharacters() ? "Y" : "N");
            }
        }
    }

    private void fixPhysicalTableAttrs(PhysicalTableInterface omrTable, IPhysicalTable local) throws RemoteException, MdException, ServiceException {
        if (omrTable != null && WsMetadataUtil.isNewObject((String)omrTable.getReposId())) {
            omrTable.setName(PromptUtils.getValidOMRObjectName(local.getName()));
            PhysicalTableAttributes attrs = new PhysicalTableAttributes(local.isCompressed(), local.isEncrypted(), local.isDBMSView(), "", local.getSASTableName(), local.isView() ? "VIEW" : "DATA");
            omrTable.setPhysicalTableAttributes(attrs);
        }
    }

    private void addPhysicalTableColumn(PhysicalTableInterface omrTable, IPhysicalTable local, IColumn column, int iColumn) throws RemoteException, MdException, ServiceException {
        if (omrTable != null && WsMetadataUtil.isNewObject((String)omrTable.getReposId())) {
            ColumnInterface omrColumn = (ColumnInterface)this.m_columnMap.get(column);
            if (omrColumn == null) {
                omrColumn = this.createOMRColumn(omrTable.getRepository(), column);
                this.m_columnMap.put(column, omrColumn);
                column.addNotifyListener(this);
            }
            omrTable.addColumnAt(omrColumn, iColumn);
        }
    }

    private void removePhysicalTableColumn(PhysicalTableInterface omrTable, IPhysicalTable local, IColumn column) throws RemoteException, MdException, ServiceException {
        if (omrTable != null && WsMetadataUtil.isNewObject((String)omrTable.getReposId())) {
            ColumnInterface omrColumn = (ColumnInterface)this.m_columnMap.get(column);
            if (omrColumn != null) {
                omrTable.removeColumn(omrColumn);
                this.m_columnMap.remove(column);
            }
            column.removeNotifyListener(this);
        }
    }

    private void movePhysicalTableColumn(PhysicalTableInterface omrTable, IPhysicalTable local, IColumn column) throws RemoteException, MdException, ServiceException {
        if (omrTable != null && WsMetadataUtil.isNewObject((String)omrTable.getReposId())) {
            ColumnInterface omrColumn = (ColumnInterface)this.m_columnMap.get(column);
            omrTable.removeColumn(omrColumn);
            this.addPhysicalTableColumn(omrTable, local, column, local.indexOfColumn(column));
        }
    }

    private void fixPhysicalTableLibrary(PhysicalTableInterface omrTable, IPhysicalTable local) throws RemoteException, MdException, ServiceException {
        if (omrTable != null && WsMetadataUtil.isNewObject((String)omrTable.getReposId())) {
            ServerInterface server;
            MetadataInterface mi;
            IPersistableObject relationalSchema = local.getDatabaseSchema();
            if (relationalSchema == null) {
                relationalSchema = local.getLibrary();
            }
            if (relationalSchema != null && (mi = (server = omrTable.getRepository().getServer()).fetch(relationalSchema.getID() + "/" + relationalSchema.getOMRType())) instanceof RelationalSchemaInterface) {
                omrTable.setSchema((RelationalSchemaInterface)mi);
            }
        }
    }

    private PhysicalTableInterface createOMRTable(RepositoryInterface repository, IPhysicalTable local) throws RemoteException, MdException, ServiceException {
        PhysicalTableInterface omrTable = (PhysicalTableInterface)this.m_smartTables.get(local);
        if (omrTable == null) {
            omrTable = new OMRPhysicalTable(repository, PromptUtils.getValidOMRObjectName(local.getName()), null);
            omrTable.setTableName(local.getSASTableName());
            this.fixPhysicalTableAttrs(omrTable, local);
            IColumn[] columns = local.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                this.addPhysicalTableColumn(omrTable, local, columns[i], i);
            }
            this.fixPhysicalTableQuoting(omrTable, local);
            this.fixPhysicalTableLibrary(omrTable, local);
            this.addDataSourceToCache((MetadataInterface)omrTable, local);
        }
        return omrTable;
    }

    private boolean isSourceTableUsed(IPhysicalTable sourceTable) {
        return this.m_mapModelSources.get(sourceTable.getID()) != null;
    }

    private boolean isTargetTableUsed(IPhysicalTable targetTable) {
        return this.m_mapModelTargets.get(targetTable.getID()) != null;
    }

    private static String getRepositoryId() throws MdException, RemoteException, ServiceException {
        String reposName = Workspace.getWorkspace().getUserContext().getAuthRepositoryName();
        if (reposName.indexOf(".") > -1) {
            reposName = reposName.substring(reposName.indexOf(".") + 1);
        }
        String repositoryId = "";
        for (CMetadata repos : Workspace.getMdFactory().getOMIUtil().getRepositories()) {
            if (!repos.getName().equals(reposName)) continue;
            repositoryId = repos.getFQID();
            break;
        }
        return repositoryId;
    }

    public void setThresholdMap(Map userMap) {
        Integer datasourceThreshold;
        HashMap<String, Integer> threshold = this.getThresholdMap();
        if (threshold == null) {
            threshold = new HashMap<String, Integer>();
        }
        threshold.put(DataProviderUtil.RELATIONAL_LIST_THRESHOLD, (datasourceThreshold = Workspace.getWorkspace().getPromptThreshold()) != null ? datasourceThreshold : 10000);
        super.setThresholdMap(threshold);
    }

    private void fixColumnAttributes(ColumnInterface omrColumn, IColumn local) throws RemoteException, ServiceException, MdException {
        if (omrColumn != null && WsMetadataUtil.isNewObject((String)omrColumn.getReposId())) {
            omrColumn.setName(local.getName());
            omrColumn.setDescription(local.getDescription());
            ColumnAttributes attrs = new ColumnAttributes(local.getDescription(), local.getSortOrder(), local.isNullable(), false, local.getLength(), "", local.getType() == 0 ? "C" : "N", local.getName(), "", "", 0.0, 0.0, 0.0, 0, 0, local.getInformat(), local.getFormat(), local.getLength(), local.getType(), local.getName());
            omrColumn.setColumnAttributes(attrs);
        }
    }

    private ColumnInterface createOMRColumn(RepositoryInterface repository, IColumn local) throws RemoteException, ServiceException, MdException {
        String columnName = PromptUtils.getValidOMRObjectName(local.getName());
        OMRColumn omrColumn = new OMRColumn(repository, columnName, null);
        this.fixColumnAttributes((ColumnInterface)omrColumn, local);
        return omrColumn;
    }

    protected DataSourceColumnInterface makeDataSourceColumnInterface(IColumn col) throws MdException, ServiceException, RemoteException {
        BaseDataSourceColumn bdsc = null;
        if (col != null && col.getTable() instanceof IPhysicalTable) {
            bdsc = new BaseDataSourceColumn();
            bdsc.setDataSource(this.makeTableDataSource((IPhysicalTable)col.getTable()));
            bdsc.setColumnName(col.getName());
            long columnType = -1L;
            if (col.getType() == 0) {
                columnType = 1L;
            } else {
                String format = col.getFormat();
                SASFormat sasFormat = null;
                if (format != null && format.length() > 0) {
                    sasFormat = SASFormat.getInstance((String)format);
                }
                columnType = sasFormat != null && sasFormat.isDateFormat() ? 4L : (sasFormat != null && sasFormat.isTimeFormat() ? 8L : (sasFormat != null && sasFormat.isDateTimeFormat() ? 16L : 2L));
            }
            bdsc.setColumnType(columnType);
            bdsc.setColumnLabel(col.getDescription());
        }
        return bdsc;
    }

    private class RemoveDataTargetUndoable
    extends AbstractUndoableEdit {
        private IDataObject m_newValue;

        public RemoveDataTargetUndoable(IDataObject newValue) {
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            try {
                PromptDataProvider.this.addDataTarget(this.m_newValue);
            }
            catch (RemoteException ex) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)ex);
            }
            catch (ServiceException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
            }
            catch (ServerConnectionException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
            }
            catch (MdException ex) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
            }
        }

        @Override
        public void redo() {
            super.redo();
            try {
                PromptDataProvider.this.removeDataTarget(this.m_newValue);
            }
            catch (RemoteException ex) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)ex);
            }
            catch (ServiceException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
            }
            catch (ServerConnectionException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
            }
            catch (MdException ex) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
            }
        }

        @Override
        public void die() {
            this.m_newValue = null;
        }
    }

    private class AddDataTargetUndoable
    extends AbstractUndoableEdit {
        private IDataObject m_newValue;

        public AddDataTargetUndoable(IDataObject newValue) {
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            try {
                PromptDataProvider.this.removeDataTarget(this.m_newValue);
            }
            catch (RemoteException ex) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)ex);
            }
            catch (ServiceException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
            }
            catch (ServerConnectionException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
            }
            catch (MdException ex) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
            }
        }

        @Override
        public void redo() {
            super.redo();
            try {
                PromptDataProvider.this.addDataTarget(this.m_newValue);
            }
            catch (RemoteException ex) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)ex);
            }
            catch (ServiceException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
            }
            catch (ServerConnectionException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
            }
            catch (MdException ex) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
            }
        }

        @Override
        public void die() {
            this.m_newValue = null;
        }
    }

    private class RemoveDataSourceUndoable
    extends AbstractUndoableEdit {
        private IDataObject m_newValue;

        public RemoveDataSourceUndoable(IDataObject newValue) {
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            try {
                PromptDataProvider.this.addDataSource(this.m_newValue);
            }
            catch (RemoteException ex) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)ex);
            }
            catch (ServiceException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
            }
            catch (ServerConnectionException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
            }
            catch (MdException ex) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
            }
        }

        @Override
        public void redo() {
            super.redo();
            try {
                PromptDataProvider.this.removeDataSource(this.m_newValue);
            }
            catch (RemoteException ex) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)ex);
            }
            catch (ServiceException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
            }
            catch (ServerConnectionException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
            }
            catch (MdException ex) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
            }
        }

        @Override
        public void die() {
            this.m_newValue = null;
        }
    }

    private class AddDataSourceUndoable
    extends AbstractUndoableEdit {
        private IDataObject m_newValue;

        public AddDataSourceUndoable(IDataObject newValue) {
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            try {
                PromptDataProvider.this.removeDataSource(this.m_newValue);
            }
            catch (RemoteException ex) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)ex);
            }
            catch (ServiceException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
            }
            catch (ServerConnectionException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
            }
            catch (MdException ex) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
            }
        }

        @Override
        public void redo() {
            super.redo();
            try {
                PromptDataProvider.this.addDataSource(this.m_newValue);
            }
            catch (RemoteException ex) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)ex);
            }
            catch (ServiceException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
            }
            catch (ServerConnectionException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
            }
            catch (MdException ex) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
            }
        }

        @Override
        public void die() {
            this.m_newValue = null;
        }
    }

    private class cFileValidator
    extends IFileValidator {
        private IWorkspace workspace;
        private boolean attemptedWorkspaceFetch;

        public cFileValidator(PromptDataProviderInterface dp, String logicalServerName) {
            super(dp, logicalServerName);
        }

        public boolean isFileExisiting(String path) {
            if (this.getWorkspace() != null) {
                return DataSourceUtil.isExistingFile((IWorkspace)this.workspace, (String)path);
            }
            return true;
        }

        public String getFileType(String path) {
            if (this.getWorkspace() != null) {
                return IFileServiceAdapterSupport.getFileType((IWorkspace)this.workspace, null, null, (String)path);
            }
            return null;
        }

        private IWorkspace getWorkspace() {
            if (this.workspace != null) {
                return this.workspace;
            }
            if (this.attemptedWorkspaceFetch) {
                return this.workspace;
            }
            this.attemptedWorkspaceFetch = true;
            if (this.workspace == null && this.logicalServerName != null && this.dataProvider != null) {
                try {
                    this.workspace = this.dataProvider.getIWorkspace(this.logicalServerName);
                }
                catch (ServerConnectionException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                }
            }
            return this.workspace;
        }
    }
}

