/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.prompts.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptModelCollection;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class BasePromptModelCollection
implements IPromptModelCollection {
    private List m_lModels = new ArrayList();
    private List m_lHelpTopics = new ArrayList();
    private List m_lTitles = new ArrayList();

    @Override
    public void addModel(IPromptModel model, String helpTopic, String title) {
        this.insertModel(this.m_lModels.size(), model, helpTopic, title);
    }

    @Override
    public void insertModel(int index, IPromptModel model, String helpTopic, String title) {
        this.m_lModels.add(index, model);
        if (helpTopic == null) {
            helpTopic = "";
        }
        this.m_lHelpTopics.add(index, helpTopic);
        if (title == null) {
            title = "";
        }
        this.m_lTitles.add(index, title);
    }

    @Override
    public IPromptModel[] getModels() {
        return this.m_lModels.toArray(new IPromptModel[this.m_lModels.size()]);
    }

    protected List getModelsList() {
        return this.m_lModels;
    }

    @Override
    public String[] getHelpTopics() {
        return this.m_lHelpTopics.toArray(new String[this.m_lHelpTopics.size()]);
    }

    public List<String> getHelpTopicsList() {
        return this.m_lHelpTopics;
    }

    @Override
    public boolean isChanged() {
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            if (!models[i].isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getTitles() {
        return this.m_lTitles.toArray(new String[this.m_lTitles.size()]);
    }

    @Override
    public int size() {
        return this.getModels().length;
    }

    @Override
    public void setSaveValuesAsStrings(boolean saveAsStrings) {
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            models[i].setSaveValuesAsStrings(saveAsStrings);
        }
    }

    @Override
    public void swapValuesToDefaultValues() {
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            models[i].swapValuesToDefaultValues();
        }
    }

    @Override
    public void setOwner(IObject newOwner) {
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            models[i].setOwner(newOwner);
        }
    }

    public void setModel(IModel model) {
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            models[i].setModel(model);
        }
    }

    @Override
    public IPromptDefinitionValue[] getPromptDefinitionsWithUserInfo(String key, String value) {
        ArrayList<IPromptDefinitionValue> defs = new ArrayList<IPromptDefinitionValue>();
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            IPromptDefinitionValue[] matches = models[i].getPromptDefinitionsWithUserInfo(key, value);
            if (matches == null) continue;
            defs.addAll(Arrays.asList(matches));
        }
        return defs.toArray(new IPromptDefinitionValue[defs.size()]);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            models[i].loadFromOMR(omr);
        }
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            models[i].saveToOMR(omr);
        }
    }

    @Override
    public void updateIDs(Map mapIDs) {
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            models[i].updateIDs(mapIDs);
        }
    }

    @Override
    public StringBuffer getOptionsString(ICodeSegment codeSegment) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        return this.getOptionsString(codeSegment, null);
    }

    @Override
    public StringBuffer getOptionsString(ICodeSegment codeSegment, String optionRole) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        StringBuffer optionsString = new StringBuffer();
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            optionsString.append(models[i].getOptionsString(codeSegment, optionRole));
        }
        return optionsString;
    }

    @Override
    public StringBuffer getOptionsString(IPromptDefinitionValue[] definitions, ICodeSegment codeSegment, String optionRole) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        StringBuffer optionsString = new StringBuffer();
        for (int i = 0; i < definitions.length; ++i) {
            optionsString.append(definitions[i].getModel().getOptionsString(codeSegment, optionRole, false, false, false, true, new IPromptDefinitionValue[]{definitions[i]}));
        }
        return optionsString;
    }

    @Override
    public void dispose() {
        IPromptModel[] models = this.getModels();
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                models[i].dispose();
            }
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws RemoteException, MdException {
        IPromptModel[] models = this.getModels();
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                models[i].deleteFromOMR(omr);
            }
        }
    }

    protected IPromptModelCollection copyObject(IObject newOwner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new BasePromptModelCollection();
    }

    @Override
    public void revertDefaults() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServiceException, MdException, ServerConnectionException, RemoteException {
        IPromptModel[] models = this.getModels();
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                models[i].revertDefaults();
            }
        }
    }

    @Override
    public IPromptModelCollection copy(IObject newOwner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        IPromptModelCollection newCollection = this.copyObject(newOwner);
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            IPromptModel old = models[i];
            newCollection.addModel(old.copy(newOwner), (String)this.m_lHelpTopics.get(i), (String)this.m_lTitles.get(i));
        }
        return newCollection;
    }

    @Override
    public void addChangeListener(IPromptValueChangeListener list) {
        IPromptModel[] models = this.getModels();
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                models[i].addChangeListener(list);
            }
        }
    }

    @Override
    public void removeChangeListener(IPromptValueChangeListener list) {
        IPromptModel[] models = this.getModels();
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                models[i].removeChangeListener(list);
            }
        }
    }

    public IPromptDefinitionValue findDefinition(String optionName) {
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            IPromptDefinitionValue definition = models[i].getPromptDefinitionValue(optionName);
            if (definition == null) continue;
            return definition;
        }
        return null;
    }

    public IPromptDefinitionValue[] getDefinitions() {
        ArrayList<IPromptDefinitionValue> definitions = new ArrayList<IPromptDefinitionValue>();
        IPromptModel[] models = this.getModels();
        for (int i = 0; i < models.length; ++i) {
            definitions.addAll(Arrays.asList(models[i].getPromptDefinitionValues()));
        }
        return definitions.toArray(new IPromptDefinitionValue[definitions.size()]);
    }

    @Override
    public void setOptionValue(String optionName, Object value) throws MdException, RemoteException, IllegalStateException, ServiceException, ServerConnectionException {
        IPromptDefinitionValue definition = this.findDefinition(optionName);
        this.setOptionValue(definition, value);
    }

    @Override
    public void setOptionValue(IPromptDefinitionValue definition, Object value) throws MdException, RemoteException, IllegalStateException, ServiceException, ServerConnectionException {
        if (definition != null) {
            definition.setValue(value);
        }
    }

    @Override
    public void addChangeListeners(List listeners) {
        IPromptModel[] models = this.getModels();
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                models[i].addChangeListeners(listeners);
            }
        }
    }

    @Override
    public List getChangeListeners() {
        ArrayList listeners = new ArrayList();
        IPromptModel[] models = this.getModels();
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                listeners.addAll(models[i].getChangeListeners());
            }
        }
        return listeners;
    }

    @Override
    public void removeChangeListeners(List listeners) {
        IPromptModel[] models = this.getModels();
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                models[i].removeChangeListeners(listeners);
            }
        }
    }
}

