/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.prompts.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.INotifyListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IDataProviderListener;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BasePromptDefinitionValue;
import com.sas.etl.models.prompts.impl.BasePromptModelListener;
import com.sas.etl.models.prompts.impl.BasePromptValueChangedListener;
import com.sas.etl.models.prompts.impl.PromptDataProvider;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.etl.models.prompts.impl.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.workspace.Workspace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class BasePromptModel
implements IPromptModel,
IDataProviderListener,
INotifyListener {
    private PromptGroupInterface m_promptGroup;
    private PromptValuesInterface m_promptValues;
    protected IObject m_owner;
    private List m_promptDefinitions;
    private boolean m_usePropertySet;
    private String m_propertySetRole;
    protected IModel m_model;
    private boolean m_saveValuesAsStrings;
    private PromptDataProvider m_dataProvider;
    private IPromptValueChangeListener m_valueChangeListener;
    private Map m_mapProperties;
    private Map m_mapPropertySets;
    private List m_sourceTables;
    private List m_targetTables;
    private IModelListener m_modelListener;
    private boolean m_bIsChanged;
    private boolean m_bFixDefinitionsForSourceTargets;
    private List m_lstnPromptValueChanged;
    protected static final int USE_PROPERTIES_DIRECTLY = 1;
    protected static final int USE_PROPERTYSET_PROPERTIES = 2;
    protected static final int USE_PROPERTYSET_SETPROPERTIES = 0;
    private int m_intSaveLocation;
    private static HashMap PROMPT_GROUP_STATIC = new HashMap();

    public BasePromptModel(IModel model, IObject owner, PromptGroupInterface promptGroup) {
        this(model, owner, promptGroup, false);
    }

    public BasePromptModel(IModel model, IObject owner, PromptGroupInterface promptGroup, boolean bFixDefinitionsForSourceTargets) {
        this.setModel(model);
        this.setOwner(owner);
        try {
            this.initialize(bFixDefinitionsForSourceTargets, new IDataObject[0], new IDataObject[0], promptGroup);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
        if (this.m_owner != null) {
            this.m_owner.addNotifyListener(this);
        }
        this.setChanged(false);
    }

    public BasePromptModel(IModel model, IObject owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, RemoteException, MdException, ServerConnectionException, ServiceException {
        this(model, owner, null, null);
    }

    public BasePromptModel(IModel model, IObject owner, IDataObject[] sources, IDataObject[] targets) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        this.setModel(model);
        this.setOwner(owner);
        this.initialize(true, sources, targets, this.getPromptGroupInstance());
        this.updateModelValues();
        this.m_modelListener = this.createModelListener();
        if (this.m_modelListener != null && this.m_model != null) {
            this.m_model.addModelListener(this.m_modelListener);
        }
        this.setChanged(false);
    }

    protected PromptGroupInterface getPromptGroupInstance() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        String cName = this.getClass().getName();
        PromptGroupInterface group = null;
        if (PROMPT_GROUP_STATIC.containsKey(cName)) {
            group = (PromptGroupInterface)PROMPT_GROUP_STATIC.get(cName);
        } else {
            group = this.getPromptGroup();
            PROMPT_GROUP_STATIC.put(cName, group);
        }
        return PromptUtils.copyPromptGroup(Workspace.getWorkspace().getUserContext(), group);
    }

    protected void initialize(boolean bFixDefinitionsForSourceTargets, IDataObject[] sources, IDataObject[] targets, PromptGroupInterface promptGroup) throws ServiceException, RemoteException, MdException, ServerConnectionException {
        this.m_lstnPromptValueChanged = new ArrayList();
        this.setFixDefinitionsEnabled(bFixDefinitionsForSourceTargets);
        this.m_intSaveLocation = 2;
        this.m_saveValuesAsStrings = false;
        this.m_promptDefinitions = new ArrayList();
        this.setSourceTables(sources);
        this.setTargetTables(targets);
        this.m_dataProvider = this.createDataProvider();
        this.m_mapProperties = new HashMap();
        this.m_mapPropertySets = new HashMap();
        this.m_propertySetRole = "MACROOPTIONS";
        this.m_usePropertySet = true;
        this.setPromptGroup(promptGroup);
    }

    @Override
    public void notify(NotifyEvent ev) {
        ModelEvent mdlEvent = ev.getModelEvent();
        if (mdlEvent != null && "Object:NameChanged".equals(mdlEvent.getType()) && this.m_dataProvider != null) {
            try {
                this.printDebugMessage(this.m_dataProvider);
            }
            catch (ServiceException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
            }
            catch (RemoteException ex) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)ex);
            }
            catch (ServerConnectionException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
            }
            catch (MdException ex) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
            }
        }
    }

    @Override
    public void revertDefaults() {
        IPromptDefinitionValue[] vals = this.getPromptDefinitionValues();
        for (int i = 0; i < vals.length; ++i) {
            vals[i].revertDefault();
        }
    }

    @Override
    public void swapValuesToDefaultValues() {
        boolean old = this.isListeningForChanges();
        this.setListeningForChanges(false);
        IPromptDefinitionValue[] vals = this.getPromptDefinitionValues();
        for (int i = 0; i < vals.length; ++i) {
            vals[i].swapValuesToDefaultValues();
        }
        this.setListeningForChanges(old);
    }

    public boolean isFixDefinitionsEnabled() {
        return this.m_bFixDefinitionsForSourceTargets;
    }

    public void setFixDefinitionsEnabled(boolean bFixDefinitionsForSourceTargets) {
        this.m_bFixDefinitionsForSourceTargets = bFixDefinitionsForSourceTargets;
    }

    @Override
    public void removeOption(String optionName) {
        this.removeOption(optionName, this.m_promptGroup);
    }

    @Override
    public void removeOption(String optionName, PromptGroupInterface promptGroup) {
        PromptDefinitionInterface def;
        if (promptGroup != null && (def = promptGroup.getPromptDefinition(optionName, true)) != null) {
            PromptGroupInterface subgrp;
            IPromptDefinitionValue defValue;
            if (this.m_promptGroup == promptGroup && (defValue = this.getPromptDefinitionValue(def)) != null) {
                this.removePromptDefinition(defValue);
            }
            if ((subgrp = promptGroup.findPromptSubgroup(def)) != null) {
                subgrp.removePromptDefinition(def);
            }
        }
    }

    @Override
    public void debugPromptXML() {
        try {
            ModelLogger.getDefaultLogger().debug((Object)("PromptXML...\n" + PromptUtils.getXMLForObject((PersistenceInterface)this.getPromptGroup(), null)));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (BackingStoreException backingStoreException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Override
    public void updateModelValues() throws RemoteException, MdException, ServerConnectionException, ServiceException {
        this.setListeningForChanges(false);
        try {
            this.setValuesFromModel();
        }
        finally {
            this.setListeningForChanges(true);
        }
    }

    protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
    }

    protected IModelListener createModelListener() {
        return new BasePromptModelListener(this.getOwner(), this);
    }

    @Override
    public void setListeningForChanges(boolean isListening) {
        if (this.m_valueChangeListener != null) {
            this.m_valueChangeListener.setListeningForChanges(isListening);
        }
    }

    @Override
    public boolean isListeningForChanges() {
        if (this.m_valueChangeListener != null) {
            return this.m_valueChangeListener.isListeningForChanges();
        }
        return false;
    }

    protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
        return new PromptGroup();
    }

    @Override
    public PromptGroupInterface getPromptGroupObject() {
        return this.m_promptGroup;
    }

    @Override
    public boolean isComplete() {
        PromptValuesInterface pValues = this.getPromptValues();
        if (pValues != null) {
            Map dupMacroNames = PromptUtils.getDuplicateMacrosByName(pValues);
            List nvld = PromptUtil.getRequiredPromptsWithoutValues((PromptValuesInterface)pValues);
            return nvld.isEmpty() && dupMacroNames.isEmpty();
        }
        return true;
    }

    private String getDefinitionLabelForMessage(PromptDefinitionInterface defInterface) {
        String label = defInterface.getPromptLabel(Locale.getDefault());
        if (label.length() > 0 && label.charAt(label.length() - 1) == ':') {
            return label.substring(0, label.length() - 1);
        }
        return label;
    }

    @Override
    public List getReasonsIncomplete() {
        ArrayList<CharSequence> lReasons = new ArrayList<CharSequence>();
        PromptValuesInterface pValues = this.getPromptValues();
        if (pValues != null) {
            List nvld = PromptUtil.getRequiredPromptsWithoutValues((PromptValuesInterface)pValues);
            int size = nvld.size();
            for (int i = 0; i < size; ++i) {
                PromptDefinitionInterface defInterface = (PromptDefinitionInterface)nvld.get(i);
                lReasons.add(MessageFormat.format(RB.getStringResource("BasePromptModel.RequiredPromptNotComplete.msg.txt"), this.getDefinitionLabelForMessage(defInterface)));
            }
            StringBuffer dups = PromptUtils.getDuplicateMacroNameList(pValues.getPromptGroup());
            if (dups != null && dups.length() > 0) {
                lReasons.add(dups);
            }
        }
        return lReasons;
    }

    public PromptGroupInterface combinePromptGroups(PromptGroupInterface pg1, PromptGroupInterface pg2) {
        return PromptUtils.combinePromptGroups(pg1, pg2);
    }

    protected IPromptValueChangeListener createChangeListener() {
        return new BasePromptValueChangedListener(this.m_owner, this);
    }

    private void setSourceTables(IDataObject[] sources) {
        this.m_sourceTables = sources != null ? Arrays.asList(sources) : new ArrayList();
    }

    private void setTargetTables(IDataObject[] targets) {
        this.m_targetTables = targets != null ? Arrays.asList(targets) : new ArrayList();
    }

    @Override
    public void fixDefinitions() throws RemoteException, ServiceException, MdException, ServerConnectionException {
        IPromptDefinitionValue[] defs = this.getPromptDefinitionValues();
        if (defs != null && this.isFixDefinitionsEnabled()) {
            for (int i = 0; i < defs.length; ++i) {
                this.fixDefinition(defs[i]);
            }
        }
    }

    public void fixDefinition(IPromptDefinitionValue definition) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        if (definition != null && this.isFixDefinitionsEnabled()) {
            PromptDataProvider prov = this.getDataProvider();
            DataSourceInterface[] sources = prov != null ? prov.getPromptDataSources() : null;
            DataSourceInterface[] targets = prov != null ? prov.getPromptDataTargets() : null;
            definition.fixDefinition(sources, targets, this.getDataProvider());
        }
    }

    @Override
    public void setPromptGroup(PromptGroupInterface group) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        this.m_promptGroup = group != null ? group : PromptUtils.createPromptGroup();
        this.setupPromptValues();
    }

    private void setupPromptValues() throws RemoteException, ServiceException, MdException, ServerConnectionException {
        if (this.m_promptValues != null && this.m_valueChangeListener != null) {
            this.m_promptValues.removePromptValueChangeListener((PromptValueChangeListener)this.m_valueChangeListener);
            this.m_valueChangeListener = null;
        }
        if (this.m_valueChangeListener == null) {
            this.m_valueChangeListener = this.createChangeListener();
        }
        IPromptDefinitionValue[] old = this.getPromptDefinitionValues();
        for (int i = 0; i < old.length; ++i) {
            this.removePromptDefinition(old[i]);
        }
        if (this.m_promptGroup != null) {
            this.m_promptValues = new PromptValues(this.m_promptGroup);
            List defs = PromptUtil.getOrderToSetPromptValues((PromptGroupInterface)this.m_promptGroup);
            int size = defs.size();
            for (int i = 0; i < size; ++i) {
                PromptDefinitionInterface prompt = (PromptDefinitionInterface)defs.get(i);
                this.addPromptDefinition(this.createPromptDefinition(prompt));
            }
        } else {
            this.m_promptValues = new PromptValues();
        }
        this.fixDefinitions();
    }

    @Override
    public void addChangeListener(IPromptValueChangeListener list) {
        this.m_lstnPromptValueChanged.add(list);
        IPromptDefinitionValue[] definitions = this.getPromptDefinitionValues();
        for (int i = 0; i < definitions.length; ++i) {
            definitions[i].addChangeListener(list);
        }
    }

    @Override
    public void removeChangeListener(IPromptValueChangeListener list) {
        this.m_lstnPromptValueChanged.remove(list);
        IPromptDefinitionValue[] definitions = this.getPromptDefinitionValues();
        for (int i = 0; i < definitions.length; ++i) {
            definitions[i].removeChangeListener(list);
        }
    }

    @Override
    public List getChangeListeners() {
        return new ArrayList(this.m_lstnPromptValueChanged);
    }

    @Override
    public void addChangeListeners(List listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.addChangeListener((IPromptValueChangeListener)listeners.get(i));
        }
    }

    @Override
    public void removeChangeListeners(List listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.removeChangeListener((IPromptValueChangeListener)listeners.get(i));
        }
    }

    protected IPromptDefinitionValue createPromptDefinition(PromptDefinitionInterface prompt) {
        return new BasePromptDefinitionValue(this, prompt, this.m_promptValues);
    }

    @Override
    public boolean containsPromptDefinition(IPromptDefinitionValue defValue) {
        return this.getPromptDefinitionValuesList().contains(defValue);
    }

    @Override
    public void addPromptDefinition(IPromptDefinitionValue def) {
        if (this.m_promptDefinitions.contains(def)) {
            return;
        }
        def.addChangeListener(this.m_valueChangeListener);
        this.m_promptDefinitions.add(def);
    }

    @Override
    public void showAllDefinitions() {
        IPromptDefinitionValue[] defValues = this.getPromptDefinitionValues();
        for (int i = 0; i < defValues.length; ++i) {
            this.setPromptDefinitionHidden(defValues[i], false);
        }
    }

    @Override
    public void setPromptDefinitionsHidden(IPromptDefinitionValue[] defValues, boolean hide) {
        if (defValues != null) {
            for (int i = 0; i < defValues.length; ++i) {
                this.setPromptDefinitionHidden(defValues[i], hide);
            }
        }
    }

    @Override
    public void setPromptDefinitionHidden(IPromptDefinitionValue defValue, boolean hide) {
        if (this.containsPromptDefinition(defValue)) {
            defValue.setHidden(hide);
        }
    }

    public void removePromptDefinitions(IPromptDefinitionValue[] defValues) {
        if (defValues != null) {
            for (int i = 0; i < defValues.length; ++i) {
                this.removePromptDefinition(defValues[i]);
            }
        }
    }

    @Override
    public void removePromptDefinition(IPromptDefinitionValue defValue) {
        if (this.containsPromptDefinition(defValue)) {
            this.m_promptDefinitions.remove(defValue);
            defValue.removeChangeListener(this.m_valueChangeListener);
            PromptGroupInterface subgrp = this.getPromptGroupObject().findPromptSubgroup(defValue.getDefinition());
            if (subgrp != null) {
                subgrp.removePromptDefinition(defValue.getDefinition());
            }
        }
    }

    public IPromptDefinitionValue[] getPromptDefinitionsToCodeGen() {
        return this.getPromptDefinitionValues();
    }

    public IPromptDefinitionValue[] getPromptDefinitionsToPersist() {
        return this.getPromptDefinitionValues();
    }

    @Override
    public IPromptDefinitionValue[] getPromptDefinitionValues() {
        return this.m_promptDefinitions.toArray(new IPromptDefinitionValue[this.m_promptDefinitions.size()]);
    }

    @Override
    public IPromptDefinitionValue[] getPromptDefinitionsWithUserInfo(String key, String value) {
        return this.getPromptDefinitionsWithUserInfo(this.getPromptDefinitionValues(), key, value);
    }

    @Override
    public IPromptDefinitionValue[] getPromptDefinitionsWithUserInfo(IPromptDefinitionValue[] defs, String key, String value) {
        ArrayList<IPromptDefinitionValue> matches = new ArrayList<IPromptDefinitionValue>();
        if (defs != null) {
            for (int i = 0; i < defs.length; ++i) {
                if (!defs[i].isUserInfoValueEqual(key, value)) continue;
                matches.add(defs[i]);
            }
        }
        return matches.toArray(new IPromptDefinitionValue[matches.size()]);
    }

    protected List getPromptDefinitionValuesList() {
        return this.m_promptDefinitions;
    }

    @Override
    public void setModel(IModel model) {
        this.m_model = model;
    }

    @Override
    public IModel getModel() {
        return this.m_model;
    }

    @Override
    public void setUsePropertySet(boolean usePropertySet) {
        this.m_usePropertySet = usePropertySet;
    }

    public boolean isUsePropertySet() {
        return this.m_usePropertySet;
    }

    @Override
    public void setSetRole(String role) {
        this.m_propertySetRole = role;
    }

    public String getSetRole() {
        return this.m_propertySetRole;
    }

    @Override
    public void setSaveValuesAsStrings(boolean useStrings) {
        this.m_saveValuesAsStrings = useStrings;
    }

    @Override
    public boolean isSavingValuesAsStrings() {
        return this.m_saveValuesAsStrings;
    }

    @Override
    public final PromptDataProvider getDataProvider() throws ServiceException, RemoteException, MdException, ServerConnectionException {
        if (this.m_dataProvider == null) {
            this.m_dataProvider = this.createDataProvider();
        }
        return this.m_dataProvider;
    }

    public PromptDataProvider createDataProvider() throws ServiceException, RemoteException, MdException, ServerConnectionException {
        PromptDataProvider prov = new PromptDataProvider(this.getModel(), this.m_sourceTables.toArray(new IDataObject[this.m_sourceTables.size()]), this.m_targetTables.toArray(new IDataObject[this.m_targetTables.size()]));
        prov.addListeners(this);
        this.printDebugMessage(prov);
        return prov;
    }

    private void printDebugMessage(PromptDataProvider prov) throws ServiceException, RemoteException, MdException, ServerConnectionException {
        IObject owner = this.getOwner();
        if (prov != null && owner != null) {
            ModelLogger.getDefaultLogger().debug((Object)("PromptDataProvider belongs to " + owner.getName() + "(" + owner.getClass() + "): " + prov.getName()));
        }
    }

    @Override
    public void onDataProviderChanged() {
        try {
            this.fixDefinitions();
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
    }

    @Override
    public void setOwner(IObject owner) {
        this.m_owner = owner;
    }

    @Override
    public IObject getOwner() {
        return this.m_owner;
    }

    @Override
    public PromptValuesInterface getPromptValues() {
        return this.m_promptValues;
    }

    public void setPromptValues(PromptValuesInterface promptValues) {
        this.m_promptValues = promptValues;
    }

    public PromptGroupInterface createPromptGroup(URL promptGroupURL) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
        PromptGroupInterface newGroup = null;
        if (promptGroupURL != null) {
            newGroup = PromptUtils.getPromptGroupFromFile(Workspace.getWorkspace().getUserContext(), promptGroupURL);
        }
        if (newGroup == null) {
            newGroup = PromptUtils.createPromptGroup();
        }
        return newGroup;
    }

    @Override
    public void updateIDs(Map mapIDs) {
        this.updatePropertyAndPropertySetIDs(mapIDs);
        try {
            PromptDataProvider provider = this.getDataProvider();
            if (provider != null) {
                provider.updateIDs(mapIDs);
            }
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().debug((Object)"Exception", (Throwable)e);
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().debug((Object)"Exception", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().debug((Object)"Exception", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().debug((Object)"Exception", (Throwable)e);
        }
    }

    protected void updatePropertyAndPropertySetIDs(Map mapIDs) {
        Collection values = this.m_mapProperties.values();
        PropertyTracker[] aTrackers = new PropertyTracker[values.size()];
        values.toArray(aTrackers);
        for (int iTracker = 0; iTracker < aTrackers.length; ++iTracker) {
            PropertyTracker tracker = aTrackers[iTracker];
            tracker.m_sFQID = this.updateSubordinateID(tracker.m_sFQID, mapIDs);
            tracker.m_sHolderFQID = this.updateSubordinateID(tracker.m_sHolderFQID, mapIDs);
        }
        Set setEntries = this.m_mapPropertySets.entrySet();
        Map.Entry[] aEntries = new Map.Entry[setEntries.size()];
        setEntries.toArray(aEntries);
        for (int iEntry = 0; iEntry < aEntries.length; ++iEntry) {
            String sValue = (String)aEntries[iEntry].getValue();
            sValue = this.updateSubordinateID(sValue, mapIDs);
            aEntries[iEntry].setValue(sValue);
        }
    }

    protected final String updateSubordinateID(String sSubordinateID, Map mapIDs) {
        if (sSubordinateID != null && this.getModel().isNewObjectID(sSubordinateID)) {
            return (String)mapIDs.get(sSubordinateID);
        }
        return sSubordinateID;
    }

    protected void deletePropertiesAndPropertySetsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Collection values = this.m_mapProperties.values();
        PropertyTracker[] aTrackers = new PropertyTracker[values.size()];
        values.toArray(aTrackers);
        for (int iTracker = 0; iTracker < aTrackers.length; ++iTracker) {
            this.deleteProperty(omr, aTrackers[iTracker]);
        }
        values = this.m_mapPropertySets.values();
        String[] aIDs = new String[values.size()];
        values.toArray(aIDs);
        for (int iID = 0; iID < aIDs.length; ++iID) {
            omr.deleteOMRObject(aIDs[iID], "PropertySet");
        }
    }

    private void deleteProperty(OMRAdapter omr, PropertyTracker tracker) throws MdException, RemoteException {
        if (tracker != null) {
            omr.deleteOMRObject(tracker.m_sFQID, "Property");
            if (tracker.m_sHolderFQID != null) {
                omr.deleteOMRObject(tracker.m_sHolderFQID, "Transformation");
            }
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        this.deletePropertiesAndPropertySetsFromOMR(omr);
    }

    private PropertySet acquirePropertySet(OMRAdapter omr, Root mdoAnchor, String sSetRole) throws MdException, RemoteException {
        PropertySet mdoSet = this.findPropertySet(omr, sSetRole);
        if (mdoSet == null) {
            String sId = this.getModel().createIDForNewObject(this.getOwner().getID());
            this.m_mapPropertySets.put(sSetRole, sId);
            mdoSet = (PropertySet)omr.acquireOMRObject(sId, "PropertySet");
        }
        mdoSet.setName(sSetRole);
        mdoSet.setSetRole(sSetRole);
        if (!mdoAnchor.getPropertySets(false).contains((Object)mdoSet)) {
            mdoAnchor.getPropertySets(false).add((Object)mdoSet);
        }
        return mdoSet;
    }

    protected Property acquireProperty(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sName, String sPropertyName, String sPropertyRole, int eSQLType, boolean useValueOnly, String delimiter, int fFlags) throws MdException, RemoteException {
        Property mdoProperty = this.findProperty(omr, sName, fFlags);
        if (mdoProperty == null) {
            String sID = this.getModel().createIDForNewObject(this.getOwner().getID());
            mdoProperty = (Property)omr.acquireOMRObject(sID, "Property");
            this.m_mapProperties.put(sSetRole + sPropertyName, new PropertyTracker(sID));
        }
        mdoProperty.setName(sName);
        mdoProperty.setPropertyName(sPropertyName);
        mdoProperty.setPropertyRole(sPropertyRole);
        mdoProperty.setSQLType(eSQLType);
        mdoProperty.setUseValueOnly(useValueOnly ? 1 : 0);
        mdoProperty.setDelimiter(useValueOnly ? "" : "=");
        if ((fFlags & 1) != 0) {
            if (!mdoAnchor.getProperties(false).contains((Object)mdoProperty)) {
                mdoAnchor.getProperties(false).add((Object)mdoProperty);
            }
        } else {
            PropertySet mdoSet = this.acquirePropertySet(omr, mdoAnchor, sSetRole);
            if ((fFlags & 2) != 0) {
                if (!mdoSet.getProperties(false).contains((Object)mdoProperty)) {
                    mdoSet.getProperties(false).add((Object)mdoProperty);
                }
            } else if (!mdoSet.getSetProperties(false).contains((Object)mdoProperty)) {
                mdoSet.getSetProperties(false).add((Object)mdoProperty);
            }
        }
        return mdoProperty;
    }

    @Override
    public void setChanged(boolean changed) {
        this.m_bIsChanged = changed;
    }

    @Override
    public boolean isChanged() {
        return this.m_bIsChanged || this.getModel() != null && this.getModel().isCopyPaste();
    }

    @Override
    public IPromptModel copy(IObject newOwner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        IPromptModel newModel = this.copyObject(newOwner);
        newModel.setPromptGroup(PromptUtils.copyPromptGroup(Workspace.getWorkspace().getUserContext(), this.getPromptGroupObject()));
        newModel.setSaveValuesAsStrings(this.m_saveValuesAsStrings);
        newModel.setSetRole(this.m_propertySetRole);
        newModel.setUsePropertySet(this.m_usePropertySet);
        newModel.setListeningForChanges(false);
        IPromptDefinitionValue[] defs = this.getPromptDefinitionValues();
        for (int i = 0; i < defs.length; ++i) {
            newModel.setOptionValue(defs[i].getName(), defs[i].getValue());
        }
        newModel.setListeningForChanges(true);
        return newModel;
    }

    protected IPromptModel copyObject(IObject newOwner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new BasePromptModel(newOwner.getModel(), newOwner, this.m_sourceTables.toArray(new IDataObject[this.m_sourceTables.size()]), this.m_targetTables.toArray(new IDataObject[this.m_targetTables.size()]));
    }

    protected void loadDefinition(OMRAdapter omr, IPromptDefinitionValue definitionValue) throws MdException, RemoteException {
        Property property = this.findProperty(omr, definitionValue.getName(), this.getSaveLocationFlag());
        if (property != null) {
            definitionValue.loadFromOMR(omr, property);
        } else {
            definitionValue.clearValue();
        }
    }

    protected void loadDefinitions(OMRAdapter omr, IPromptDefinitionValue[] definitionValues) throws MdException, RemoteException {
        if (definitionValues != null) {
            for (int i = 0; i < definitionValues.length; ++i) {
                this.loadDefinition(omr, definitionValues[i]);
            }
        }
    }

    protected void loadDefinitions(OMRAdapter omr) throws MdException, RemoteException {
        IPromptDefinitionValue[] definitionValues = this.getPromptDefinitionsToPersist();
        this.loadDefinitions(omr, definitionValues);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        boolean isListening = this.isListeningForChanges();
        this.setListeningForChanges(false);
        this.m_mapPropertySets.clear();
        this.m_mapProperties.clear();
        this.loadDefinitions(omr);
        this.setListeningForChanges(isListening);
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        this.saveDefinitions(omr, this.getPromptDefinitionsToPersist());
        this.setChanged(false);
    }

    protected int getSaveLocationFlag() {
        return this.m_intSaveLocation;
    }

    public void setSaveLocationFlag(int flag) {
        this.m_intSaveLocation = flag;
    }

    protected void saveDefinitions(OMRAdapter omr, IPromptDefinitionValue[] definitionValues) throws MdException, RemoteException {
        if (definitionValues != null) {
            for (int i = 0; i < definitionValues.length; ++i) {
                this.saveDefinition(omr, definitionValues[i], this.getSaveLocationFlag());
            }
        }
    }

    protected void saveDefinition(OMRAdapter omr, IPromptDefinitionValue definitionValue, int flags) throws MdException, RemoteException {
        Root mdOwner = omr.acquireOMRObject((IOMRPersistable)((Object)this.getOwner()));
        if (definitionValue.isValueSet()) {
            Property property = this.acquireProperty(omr, mdOwner, this.m_usePropertySet ? this.getSetRole() : "", definitionValue.getName(), definitionValue.getName(), definitionValue.getRole(), definitionValue.getSQLType(), definitionValue.isUseValueOnly(), definitionValue.getDelimiter(), flags);
            definitionValue.saveToOMR(omr, property);
        } else {
            Property property = this.findProperty(omr, definitionValue.getName(), flags);
            if (property != null) {
                this.deleteProperty(omr, definitionValue, property);
            }
        }
    }

    protected void deleteProperty(OMRAdapter omr, IPromptDefinitionValue definitionValue, Property mdoProperty) throws MdException, RemoteException {
        int fFlags;
        Root mdOwner = omr.acquireOMRObject((IOMRPersistable)((Object)this.getOwner()));
        String trackerName = this.getPropertyTrackerName(definitionValue.getName());
        PropertyTracker tracker = (PropertyTracker)this.m_mapProperties.get(trackerName);
        if (tracker != null) {
            this.m_mapProperties.remove(trackerName);
        }
        if (((fFlags = this.getSaveLocationFlag()) & 1) != 0) {
            if (!mdOwner.getProperties(false).contains((Object)mdoProperty)) {
                mdOwner.getProperties(false).remove((Object)mdoProperty);
            }
        } else {
            PropertySet mdoSet = this.findPropertySet(omr, this.getSetRole());
            if (mdoSet != null) {
                if ((fFlags & 2) != 0) {
                    if (!mdoSet.getProperties(false).contains((Object)mdoProperty)) {
                        mdoSet.getProperties(false).remove((Object)mdoProperty);
                    }
                } else if (!mdoSet.getSetProperties(false).contains((Object)mdoProperty)) {
                    mdoSet.getSetProperties(false).remove((Object)mdoProperty);
                }
            }
        }
        this.deleteProperty(omr, tracker);
    }

    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap, boolean caseSensitive) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        PromptDataProvider provider = this.getDataProvider();
        if (provider != null) {
            provider.addDataSource(newTable);
        }
        this.fixDefinitions();
        IPromptDefinitionValue[] vals = this.getPromptDefinitionValues();
        for (int i = 0; i < vals.length; ++i) {
            vals[i].replaceSourceTable(oldTable, newTable, columnsMap, caseSensitive);
        }
        if (provider != null) {
            provider.removeDataSource(oldTable);
        }
        this.fixDefinitions();
    }

    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, boolean caseSensitive) throws RemoteException, ServiceException, MdException, ServerConnectionException {
        PromptDataProvider provider = this.getDataProvider();
        if (provider != null) {
            provider.addDataTarget(newTable);
        }
        this.fixDefinitions();
        IPromptDefinitionValue[] vals = this.getPromptDefinitionValues();
        for (int i = 0; i < vals.length; ++i) {
            vals[i].replaceTargetTable(oldTable, newTable, columnsMap, caseSensitive);
        }
        if (provider != null) {
            provider.removeDataTarget(oldTable);
        }
        this.fixDefinitions();
    }

    @Override
    public final List getDefinitionsToRefresh() {
        ArrayList<PromptDefinitionInterface> defs = new ArrayList<PromptDefinitionInterface>();
        IPromptDefinitionValue[] definitions = this.getPromptDefinitionValues();
        for (int i = 0; i < definitions.length; ++i) {
            IPromptDefinitionValue defValue = definitions[i];
            if (!defValue.isRefreshNeeded()) continue;
            defs.add(defValue.getDefinition());
        }
        return defs;
    }

    @Override
    public void setOptionDefaultValue(String optionName, Object defaultValue) throws RemoteException, ServerConnectionException, ServiceException, MdException {
        this.setOptionDefaultValue(this.getPromptDefinitionValue(optionName), defaultValue);
    }

    @Override
    public void setOptionDefaultValue(IPromptDefinitionValue option, Object defaultValue) throws RemoteException, ServerConnectionException, ServiceException, MdException {
        if (option != null) {
            option.setDefaultValue(defaultValue);
        }
    }

    @Override
    public void clearOptionDefaultValue(String optionName) {
        this.clearOptionDefaultValue(this.getPromptDefinitionValue(optionName));
    }

    @Override
    public void clearOptionDefaultValue(IPromptDefinitionValue option) {
        if (option != null) {
            option.clearDefaultValue();
        }
    }

    @Override
    public final void setOptionValue(String optionName, Object value) throws RemoteException, MdException, ServiceException, ServerConnectionException {
        this.setOptionValue(this.getPromptDefinitionValue(optionName), value);
    }

    @Override
    public final void setOptionValue(IPromptDefinitionValue option, Object value) throws RemoteException, MdException, ServiceException, ServerConnectionException {
        if (option != null) {
            option.setValue(value);
        }
    }

    @Override
    public final Object getOptionValue(String optionName) {
        return this.getOptionValue(this.getPromptDefinitionValue(optionName));
    }

    @Override
    public final Object getOptionValue(IPromptDefinitionValue option) {
        Object value = null;
        if (option != null) {
            value = option.getValue();
        }
        return value;
    }

    @Override
    public IPromptDefinitionValue getPromptDefinitionValue(String optionName) {
        return this.getPromptDefinitionValue(this.getPromptDefinitionValues(), optionName);
    }

    @Override
    public IPromptDefinitionValue getPromptDefinitionValue(IPromptDefinitionValue[] definitions, String optionName) {
        if (definitions != null) {
            for (int i = 0; i < definitions.length; ++i) {
                IPromptDefinitionValue defValue = definitions[i];
                String promptName = defValue.getName();
                if (promptName == null || !optionName.equalsIgnoreCase(promptName)) continue;
                return defValue;
            }
        }
        return null;
    }

    @Override
    public StringBuffer getOptionsString(ICodeSegment codeSegment) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        return this.getOptionsString(codeSegment, null);
    }

    @Override
    public StringBuffer getOptionsString(ICodeSegment codeSegment, String role) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        return this.getOptionsString(codeSegment, role, false, false);
    }

    @Override
    public StringBuffer getOptionsString(ICodeSegment codeSegment, boolean useLetStatement, boolean genBlankValues) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        return this.getOptionsString(codeSegment, null, useLetStatement, genBlankValues);
    }

    @Override
    public StringBuffer getOptionsString(ICodeSegment codeSegment, boolean useLetStatement, boolean genBlankValues, boolean genPercentLocalStatements) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        return this.getOptionsString(codeSegment, null, useLetStatement, genBlankValues, genPercentLocalStatements);
    }

    @Override
    public StringBuffer getOptionsString(ICodeSegment codeSegment, String role, boolean useLetStatement, boolean genBlankValues) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        return this.getOptionsString(codeSegment, role, useLetStatement, genBlankValues, false);
    }

    @Override
    public StringBuffer getOptionsString(ICodeSegment codeSegment, String role, boolean useLetStatement, boolean genBlankValues, boolean genPercentLocalStatements) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        return this.getOptionsString(codeSegment, role, useLetStatement, genBlankValues, false, true);
    }

    @Override
    public StringBuffer getOptionsString(ICodeSegment codeSegment, String role, boolean useLetStatement, boolean genBlankValues, boolean genPercentLocalStatements, boolean bUseEscapeQuotes) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        return this.getOptionsString(codeSegment, role, useLetStatement, genBlankValues, genPercentLocalStatements, bUseEscapeQuotes, this.getPromptDefinitionsToCodeGen());
    }

    @Override
    public StringBuffer getOptionsString(ICodeSegment codeSegment, String role, boolean useLetStatement, boolean genBlankValues, boolean genPercentLocalStatements, boolean bUseEscapeQuotes, IPromptDefinitionValue[] definitionValues) throws RemoteException, MdException, ServerConnectionException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, CodegenException, ServerException {
        StringBuffer buffer = new StringBuffer();
        if (definitionValues != null) {
            for (int i = 0; i < definitionValues.length; ++i) {
                StringBuffer strValue;
                IPromptDefinitionValue defValue = definitionValues[i];
                if (role != null && !role.equalsIgnoreCase(defValue.getRole()) || !genBlankValues && !defValue.isValueSet() || (strValue = defValue.getOptionNameAndValue(codeSegment, useLetStatement, genBlankValues, genPercentLocalStatements, bUseEscapeQuotes)) == null || strValue.length() <= 0) continue;
                buffer.append(strValue);
                if (useLetStatement) continue;
                buffer.append("\n");
            }
            if (!useLetStatement && buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
        }
        return buffer;
    }

    @Override
    public Map<String, String> getMacroNamesAndValues(ICodeSegment codeSegment, String role, boolean useLetStatement, boolean genBlankValues, boolean genPercentLocalStatements, boolean bUseEscapeQuotes) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, ServerConnectionException, ServerException {
        return this.getMacroNamesAndValues(codeSegment, role, useLetStatement, genBlankValues, genPercentLocalStatements, bUseEscapeQuotes, this.getPromptDefinitionsToCodeGen());
    }

    @Override
    public Map<String, String> getMacroNamesAndValues(ICodeSegment codeSegment, String role, boolean useLetStatement, boolean genBlankValues, boolean genPercentLocalStatements, boolean bUseEscapeQuotes, IPromptDefinitionValue[] definitionValues) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, ServerConnectionException, ServerException {
        HashMap<String, String> prompts = new HashMap<String, String>();
        if (definitionValues != null) {
            for (int i = 0; i < definitionValues.length; ++i) {
                Map<String, String> strValue;
                IPromptDefinitionValue defValue = definitionValues[i];
                if (role != null && !role.equalsIgnoreCase(defValue.getRole()) || !genBlankValues && !defValue.isValueSet() || (strValue = defValue.getMacroNamesAndValues(codeSegment, useLetStatement, genBlankValues, genPercentLocalStatements, bUseEscapeQuotes)) == null || strValue.size() <= 0) continue;
                prompts.putAll(strValue);
            }
        }
        return prompts;
    }

    @Override
    public IPromptDefinitionValue getPromptDefinitionValue(PromptDefinitionInterface definition) {
        IPromptDefinitionValue[] definitions = this.getPromptDefinitionValues();
        if (definitions != null) {
            for (int i = 0; i < definitions.length; ++i) {
                IPromptDefinitionValue defValue = definitions[i];
                if (defValue.getDefinition() != definition) continue;
                return defValue;
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        IPromptDefinitionValue[] promptDefinitions;
        if (this.m_dataProvider != null) {
            try {
                ModelLogger.getDefaultLogger().debug((Object)("PromptDataProvider disposed for " + (this.m_owner != null ? this.m_owner.getName() : "Unknown") + ": " + this.m_dataProvider.getName()));
                this.m_dataProvider.close();
            }
            catch (ServerConnectionException serverConnectionException) {
                // empty catch block
            }
            this.m_dataProvider = null;
        }
        if (this.m_modelListener != null) {
            this.m_model.removeModelListener(this.m_modelListener);
        }
        if (this.m_valueChangeListener != null) {
            this.m_promptValues.removePromptValueChangeListener((PromptValueChangeListener)this.m_valueChangeListener);
        }
        if ((promptDefinitions = this.getPromptDefinitionValues()) != null) {
            for (int i = 0; i < promptDefinitions.length; ++i) {
                promptDefinitions[i].dispose();
            }
        }
    }

    @Override
    public boolean isPromptValuesValid() {
        return this.getInvalidPrompts().isEmpty();
    }

    @Override
    public List getInvalidPrompts() {
        ArrayList<PromptDefinitionInterface> invalidPrompts = new ArrayList<PromptDefinitionInterface>();
        List defs = PromptUtil.getVisualOrderOfDefinitions((PromptValuesInterface)this.m_promptValues, (boolean)false);
        int size = defs.size();
        for (int i = 0; i < size; ++i) {
            PromptDefinitionInterface def = (PromptDefinitionInterface)defs.get(i);
            if (this.m_promptValues.isPromptValueValid(def) && (!def.isRequired() || this.m_promptValues.isPromptValueAvailable(def))) continue;
            invalidPrompts.add(def);
        }
        return invalidPrompts;
    }

    private String getPropertyTrackerName(String propertyName) {
        return this.m_usePropertySet ? this.m_propertySetRole + propertyName : propertyName;
    }

    protected Property findProperty(OMRAdapter omr, String sName, int fFlags) throws MdException, RemoteException {
        AssociationList lProperties;
        String trackerName = this.getPropertyTrackerName(sName);
        PropertyTracker tracker = (PropertyTracker)this.m_mapProperties.get(trackerName);
        if (tracker != null && StringUtils.isNotEmpty((String)tracker.m_sFQID)) {
            return (Property)omr.acquireOMRObject(tracker.m_sFQID, "Property");
        }
        Root mdoAnchor = omr.acquireOMRObject((IOMRPersistable)((Object)this.getOwner()));
        if (mdoAnchor == null) {
            return null;
        }
        if ((fFlags & 1) != 0) {
            lProperties = mdoAnchor.getProperties();
        } else {
            PropertySet mdoSet = this.findPropertySet(omr, this.getSetRole());
            if (mdoSet == null) {
                return null;
            }
            lProperties = (fFlags & 2) != 0 ? mdoSet.getProperties() : mdoSet.getSetProperties();
        }
        for (int iProperty = 0; iProperty < lProperties.size(); ++iProperty) {
            Property mdoProperty = (Property)lProperties.get(iProperty);
            if (mdoProperty == null || !mdoProperty.getPropertyName().equalsIgnoreCase(sName)) continue;
            this.m_mapProperties.put(this.getSetRole() + sName, new PropertyTracker(mdoProperty.getFQID()));
            return mdoProperty;
        }
        return null;
    }

    private PropertySet findPropertySet(OMRAdapter omr, String sSetRole) throws MdException, RemoteException {
        String sSetID = (String)this.m_mapPropertySets.get(sSetRole);
        if (sSetID != null) {
            return (PropertySet)omr.acquireOMRObject(sSetID, "PropertySet");
        }
        PropertySet set = null;
        AssociationList lSets = omr.acquireOMRObject((IOMRPersistable)((Object)this.m_owner)).getPropertySets();
        for (int iSet = 0; iSet < lSets.size(); ++iSet) {
            PropertySet mdoSet = (PropertySet)lSets.get(iSet);
            if (!mdoSet.getSetRole().equalsIgnoreCase(sSetRole)) continue;
            this.m_mapPropertySets.put(mdoSet.getSetRole(), mdoSet.getFQID());
            set = mdoSet;
        }
        return set;
    }

    private static class PropertyTracker {
        String m_sFQID;
        String m_sHolderFQID;

        PropertyTracker(String sFQID) {
            this.m_sFQID = sFQID;
        }
    }
}

