/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.prompts.impl;

import com.sas.datatypes.DataTypeInterface;
import com.sas.etl.models.IGenericObject;
import com.sas.etl.models.INotifyListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ICube;
import com.sas.etl.models.data.IFile;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.PromptDataProvider;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.BaseDataSourceColumn;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptDefinitionReference;
import com.sas.prompts.PromptValueChangeEvent;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.BaseFileDefinition;
import com.sas.prompts.definitions.DataSourceColumnDefinition;
import com.sas.prompts.definitions.DataSourceColumnDefinitionInterface;
import com.sas.prompts.definitions.DataSourceDefinition;
import com.sas.prompts.definitions.DataSourceDefinitionInterface;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SASLibraryDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.groups.ModalGroupInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.util.UserInfoInterface;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import com.sas.util.macrovar.MutableMacroVariableListOptionInterface;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.ParserConfigurationException;

public class BasePromptDefinitionValue
implements IPromptDefinitionValue,
INotifyListener {
    private PromptDefinitionInterface m_definition;
    private String m_delimiter;
    private int m_useValueOnly;
    private String m_propertyRole;
    private IPromptModel m_model = null;
    private PromptValues m_promptValues;
    private PromptDefinitionInterface m_hiddenDefinition;
    private PromptValueChangeListener m_promptValueChangeListener;
    private Object m_defaultObject;
    private Object m_modelValue;
    private Object m_originalDefault;
    private boolean m_bEnableEvents;
    private boolean m_bCodeGenEnabled;
    private boolean generateLibnames = true;
    private List m_lstListeners = new ArrayList();

    public BasePromptDefinitionValue(IPromptModel model, PromptDefinitionInterface def, PromptValuesInterface promptValues) {
        this.m_model = model;
        this.m_definition = def;
        this.m_bEnableEvents = true;
        this.m_promptValues = (PromptValues)promptValues;
        UserInfoInterface userInfo = this.m_definition.getUserInfo();
        String oDelim = userInfo.get("Delimiter");
        String oUseValue = userInfo.get("UseValueOnly");
        String oPropertyRole = userInfo.get("PropertyRole");
        this.m_bCodeGenEnabled = true;
        this.m_delimiter = oDelim != null ? oDelim.toString() : "=";
        this.m_useValueOnly = oUseValue != null ? Integer.parseInt(oUseValue.toString()) : 0;
        this.m_propertyRole = oPropertyRole != null ? oPropertyRole.toString() : "";
        this.createListeners();
        if (this.isDefaultValueSet()) {
            try {
                Object defaultValue = this.getModelObjectValue(this.m_definition.getDefaultValue());
                this.setDefaultModelObject(defaultValue);
                this.m_modelValue = this.m_defaultObject;
                this.m_originalDefault = defaultValue;
            }
            catch (RemoteException ex) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)ex);
            }
            catch (ServerConnectionException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)ex);
            }
            catch (ServiceException ex) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)ex);
            }
            catch (MdException ex) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)ex);
            }
        }
    }

    @Override
    public void setGenerateLibnames(boolean value) {
        this.generateLibnames = value;
    }

    @Override
    public boolean getGenerateLibnames() {
        return this.generateLibnames;
    }

    @Override
    public void addChangeListener(IPromptValueChangeListener list) {
        if (this.m_lstListeners.contains(list)) {
            return;
        }
        this.m_lstListeners.add(list);
    }

    @Override
    public void removeChangeListener(IPromptValueChangeListener list) {
        if (!this.m_lstListeners.contains(list)) {
            return;
        }
        this.m_lstListeners.remove(list);
    }

    @Override
    public void setEnableEvents(boolean bEnableEvents) {
        this.m_bEnableEvents = bEnableEvents;
    }

    @Override
    public boolean isEventsEnabled() {
        return this.m_bEnableEvents;
    }

    private void fireChangeEvent(Object oldValue, Object newValue) {
        if (!this.isEventsEnabled()) {
            return;
        }
        for (int i = 0; i < this.m_lstListeners.size(); ++i) {
            ((IPromptValueChangeListener)this.m_lstListeners.get(i)).promptValueChanged((PromptValueChangeEventInterface)new PromptValueChangeEvent(this.m_definition, oldValue, newValue));
        }
    }

    protected PromptValuesInterface getPromptValues() {
        return this.m_promptValues;
    }

    private void createListeners() {
        this.m_promptValueChangeListener = new cPromptValueChangeListener();
        this.m_promptValues.addPromptValueChangeListener(this.m_promptValueChangeListener);
    }

    private void setDefaultModelObject(Object defaultValue) {
        this.removeNotifyListener(this.getDefaultModelObjectList());
        this.m_defaultObject = defaultValue;
        this.addNotifyListener(this.getModelValueList(this.m_defaultObject));
    }

    @Override
    public void revertDefault() {
        if (this.m_originalDefault != null) {
            try {
                this.setDefaultValue(this.m_originalDefault);
            }
            catch (RemoteException e) {
                ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
            }
            catch (ServerConnectionException e) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
            }
            catch (ServiceException e) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
            }
            catch (MdException e) {
                ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
            }
        }
    }

    private List getDefaultModelObjectList() {
        return this.getModelValueList(this.m_defaultObject);
    }

    @Override
    public UserInfoInterface getUserInfoMap() {
        return this.getDefinition().getUserInfo();
    }

    @Override
    public String getUserInfoValue(String key) {
        return this.getUserInfoMap().get(key);
    }

    @Override
    public boolean isUserInfoValueEqual(String key, String value) {
        return value.equals(this.getUserInfoValue(key));
    }

    public boolean isValueQuoted() {
        return this.isUserInfoValueEqual("QuoteValue", "Yes");
    }

    @Override
    public void dispose() {
        if (this.m_promptValueChangeListener != null) {
            this.m_promptValues.removePromptValueChangeListener(this.m_promptValueChangeListener);
        }
        this.removeNotifyListener(this.getDefaultModelObjectList());
        this.removeNotifyListener(this.getModelValueList());
    }

    @Override
    public void notify(NotifyEvent ev) {
        block15: {
            Object source = ev.getSource();
            try {
                List defaultList = this.getDefaultModelObjectList();
                if (defaultList.contains(source)) {
                    if (0 == ev.getType() && defaultList.contains(source)) {
                        defaultList.remove(source);
                    }
                    if (defaultList.size() > 1) {
                        this.setDefaultValue(defaultList);
                    } else if (defaultList.size() == 1) {
                        this.setDefaultValue(defaultList.get(0));
                    } else {
                        this.clearDefaultValue();
                    }
                }
                List currentValues = this.getModelValueList();
                ModelEvent mdEvent = ev.getModelEvent();
                if (currentValues != null && currentValues.contains(source)) {
                    List newValues = null;
                    boolean isList = this.m_definition instanceof SelectableDefinitionInterface;
                    if (!this.isValueValid(source)) {
                        currentValues.remove(source);
                        newValues = !isList ? (!currentValues.isEmpty() ? currentValues.get(0) : null) : currentValues;
                        if (newValues == null || isList && currentValues.isEmpty()) {
                            this.m_promptValues.clearPromptValue(this.m_definition);
                        } else {
                            this.setValue(newValues);
                        }
                    } else if (mdEvent != null && ("IComplexPersistableObject:FolderChanged".equals(mdEvent.getType()) || "Object:NameChanged".equals(mdEvent.getType()))) {
                        newValues = !isList ? (!currentValues.isEmpty() ? currentValues.get(0) : null) : currentValues;
                        this.setValue(newValues);
                    }
                    break block15;
                }
                if (currentValues == null || !(source instanceof IPhysicalTable) || !(this.m_definition instanceof DataSourceColumnDefinitionInterface)) break block15;
                IPhysicalTable table = (IPhysicalTable)source;
                for (int i = 0; i < currentValues.size(); ++i) {
                    if (!table.containsColumn((IColumn)currentValues.get(i))) continue;
                    this.setValue(currentValues);
                    break;
                }
            }
            catch (Exception e) {
                ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isUseValueOnly() {
        return this.m_useValueOnly == 1;
    }

    @Override
    public StringBuffer getOptionNameAndValue(ICodeSegment codeSegment) throws MdException, RemoteException, BadLibraryDefinitionException, ServiceException, BadServerDefinitionException, ServerConnectionException, CodegenException, ServerException {
        return this.getOptionNameAndValue(codeSegment, false, false, false, true);
    }

    @Override
    public StringBuffer getOptionNameAndValue(ICodeSegment codeSegment, boolean useLetStatement, boolean genBlankValues, boolean genPercentLocalStatements) throws MdException, RemoteException, BadLibraryDefinitionException, ServiceException, BadServerDefinitionException, ServerConnectionException, CodegenException, ServerException {
        return this.getOptionNameAndValue(codeSegment, useLetStatement, genBlankValues, genPercentLocalStatements, true);
    }

    @Override
    public StringBuffer getOptionNameAndValue(ICodeSegment codeSegment, boolean useLetStatement, boolean genBlankValues, boolean genPercentLocalStatements, boolean bUseEscapeQuotes) throws MdException, RemoteException, BadLibraryDefinitionException, ServiceException, BadServerDefinitionException, ServerConnectionException, CodegenException, ServerException {
        StringBuffer sb = new StringBuffer();
        StringBuffer val = this.getCodegenStringForValue(codeSegment, useLetStatement, genBlankValues, genPercentLocalStatements, bUseEscapeQuotes);
        if (val != null && val.length() > 0) {
            sb.append(val);
            if (!useLetStatement) {
                sb.append(" ");
            }
        }
        return sb;
    }

    private String getColumnDefinitionLocationKeyValue() {
        DataSourceColumnDefinition dsc;
        UserInfoInterface map;
        String value = null;
        if (this.m_definition instanceof DataSourceColumnDefinition && (map = (dsc = (DataSourceColumnDefinition)this.m_definition).getUserInfo()).contains("TableSelect")) {
            return map.get("TableSelect");
        }
        return value;
    }

    private boolean isSourceTargetColumnDefinition() {
        if (this.m_definition instanceof DataSourceColumnDefinitionInterface) {
            String location = this.getColumnDefinitionLocationKeyValue();
            return "Sources".equals(location) || "Targets".equals(location);
        }
        return false;
    }

    private boolean isSourceColumnDefinition() {
        if (this.isSourceTargetColumnDefinition()) {
            String location = this.getColumnDefinitionLocationKeyValue();
            return "Sources".equals(location);
        }
        return false;
    }

    private boolean isTargetColumnDefinition() {
        if (this.isSourceTargetColumnDefinition()) {
            String location = this.getColumnDefinitionLocationKeyValue();
            return "Targets".equals(location);
        }
        return false;
    }

    @Override
    public void fixDefinition(DataSourceInterface[] sources, DataSourceInterface[] targets, PromptDataProvider provider) throws MdException, RemoteException, ServerConnectionException, ServiceException {
        if (this.m_definition instanceof DataSourceColumnDefinitionInterface) {
            if (this.isSourceTargetColumnDefinition() && this.m_model.getDataProvider() != null) {
                DataSourceColumnDefinition dsc = (DataSourceColumnDefinition)this.m_definition;
                dsc.setAllowMultipleDataSources(true);
                Object defaultValue = null;
                if (dsc.isDefaultValueSet()) {
                    defaultValue = dsc.getDefaultValue();
                }
                if (sources != null && this.isSourceColumnDefinition()) {
                    if (sources.length == 0) {
                        this.disablePrompt();
                        dsc.setDataSources(null);
                    } else {
                        this.enablePrompt();
                        dsc.setDataSources(new ArrayList<DataSourceInterface>(Arrays.asList(sources)));
                    }
                    if (defaultValue != null && defaultValue instanceof BaseDataSourceColumn && sources.length > 0) {
                        BaseDataSourceColumn defaultCol = (BaseDataSourceColumn)defaultValue;
                        defaultCol.setDataSource(sources[0]);
                        IColumn metaColumn = provider.getColumn((DataSourceColumnInterface)defaultCol);
                        defaultCol = (BaseDataSourceColumn)provider.makeDataSourceColumnInterface(metaColumn);
                        dsc.setDefaultValue((Object)defaultCol);
                        if (this.isColumnValid(metaColumn) && !this.isValueSetNotIncludingDefault()) {
                            this.m_promptValues.clearPromptValue((PromptDefinitionInterface)dsc);
                        }
                    }
                } else if (targets != null && this.isTargetColumnDefinition()) {
                    if (targets.length == 0) {
                        this.disablePrompt();
                        dsc.setDataSources(null);
                    } else {
                        this.enablePrompt();
                        dsc.setDataSources(new ArrayList<DataSourceInterface>(Arrays.asList(targets)));
                    }
                    if (defaultValue != null && defaultValue instanceof BaseDataSourceColumn && targets.length > 0) {
                        BaseDataSourceColumn defaultCol = (BaseDataSourceColumn)defaultValue;
                        defaultCol.setDataSource(targets[0]);
                        IColumn metaColumn = provider.getColumn((DataSourceColumnInterface)defaultCol);
                        defaultCol = (BaseDataSourceColumn)provider.makeDataSourceColumnInterface(metaColumn);
                        dsc.setDefaultValue((Object)defaultCol);
                        if (this.isColumnValid(metaColumn) && !this.isValueSetNotIncludingDefault()) {
                            this.m_promptValues.clearPromptValue((PromptDefinitionInterface)dsc);
                        }
                    }
                }
                this.validateColumns();
            }
        } else if (this.m_definition instanceof TextDefinitionInterface) {
            UserInfoInterface info = this.m_definition.getUserInfo();
            TextDefinition def = (TextDefinition)this.m_definition;
            if (info.contains("Boolean Type")) {
                def.setValueProvider(PromptUtils.getValueProviderForBooleanDefinition(def));
            }
        }
    }

    private String createHiddenPromptName(int offset) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long time = System.currentTimeMillis() / 100L + (long)(offset * 10);
        boolean done = false;
        StringBuffer base36 = new StringBuffer("");
        do {
            int remainder = (int)(time % 36L);
            base36.insert(0, cArray[remainder]);
            if ((time /= 36L) != 0L) continue;
            done = true;
        } while (!done);
        return base36.insert(0, 'W').substring(0);
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        if (bEnabled) {
            this.enablePrompt();
        } else {
            this.disablePrompt();
        }
    }

    private void disablePrompt() {
        PromptDefinitionInterface def = this.m_definition;
        if (this.m_hiddenDefinition == null) {
            this.m_hiddenDefinition = new DataSourceDefinition(def.getPromptName() + "_" + this.createHiddenPromptName(10));
            ((DataSourceDefinition)this.m_hiddenDefinition).setHidden(true);
            PromptGroupInterface grp = this.m_model.getPromptGroupObject();
            PromptGroupInterface subGrp = grp.findPromptSubgroup(def);
            subGrp.addPromptDefinition(this.m_hiddenDefinition, subGrp.getPromptDefinitions(false).size());
        }
        ArrayList<PromptDefinitionInterface> collection = new ArrayList<PromptDefinitionInterface>(this.m_definition.getAdditionalCascadeDependencies());
        collection.add(this.m_hiddenDefinition);
        ((PromptDefinition)def).setAdditionalCascadeDependencies(collection);
    }

    private void enablePrompt() {
        if (this.m_hiddenDefinition != null) {
            PromptDefinitionInterface def = this.m_definition;
            PromptGroupInterface grp = this.m_model.getPromptGroupObject();
            grp.findPromptSubgroup(def).removePromptDefinition(this.m_hiddenDefinition);
            ArrayList deps = new ArrayList(def.getAdditionalCascadeDependencies());
            deps.remove(this.m_hiddenDefinition);
            ((PromptDefinition)def).setAdditionalCascadeDependencies(deps);
            this.m_hiddenDefinition = null;
        }
    }

    private void validateColumns() {
        try {
            Object value = this.getValue();
            if (value instanceof List) {
                if (!this.isColumnListValid((List)value)) {
                    ArrayList correctValues = new ArrayList();
                    List promptList = (List)value;
                    for (int i = 0; i < promptList.size(); ++i) {
                        if (!(promptList.get(i) instanceof IColumn) || !this.isColumnValid((IColumn)promptList.get(i))) continue;
                        correctValues.add(promptList.get(i));
                    }
                    this.setPromptValue(correctValues);
                }
            } else if (value instanceof IColumn && !this.isColumnValid((IColumn)value)) {
                this.m_promptValues.clearPromptValue(this.m_definition);
            }
        }
        catch (Exception e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
    }

    private boolean isColumnValid(IColumn column) throws ServerConnectionException, RemoteException, ServiceException, MdException {
        boolean isValid = false;
        if (column != null && this.isSourceTargetColumnDefinition() && this.m_model.getDataProvider() != null) {
            IPhysicalTable dTable;
            Map tableMap;
            PromptDataProvider provider = this.m_model.getDataProvider();
            Map map = tableMap = this.isSourceColumnDefinition() ? provider.getSourceTableMap() : provider.getTargetTableMap();
            if (tableMap != null && (dTable = (IPhysicalTable)tableMap.get(column.getTable().getID())) != null) {
                IColumn[] cols = dTable.getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    IColumn tcol = cols[i];
                    if (tcol != column) continue;
                    return true;
                }
            }
        }
        return isValid;
    }

    private boolean isColumnListValid(List values) throws ServerConnectionException, RemoteException, ServiceException, MdException {
        boolean valid = true;
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                Object val = values.get(i);
                if (val instanceof IColumn) {
                    if (this.isColumnValid((IColumn)val)) continue;
                    return false;
                }
                if (val instanceof IColumn) {
                    if (this.isColumnValid((IColumn)val)) continue;
                    return false;
                }
                return false;
            }
        }
        return valid;
    }

    @Override
    public PromptDefinitionInterface getDefinition() {
        return this.m_definition;
    }

    @Override
    public String getDelimiter() {
        return this.m_delimiter;
    }

    @Override
    public String getRole() {
        return this.m_propertyRole;
    }

    @Override
    public int getSQLType() {
        return this.m_definition.getPromptDataType().getSQLType();
    }

    @Override
    public boolean isDefaultValueSet() {
        return this.m_definition.isDefaultValueSet();
    }

    @Override
    public Object getDefaultValue() {
        return this.m_defaultObject;
    }

    protected Object getPromptValue() throws PromptValueNotFoundException {
        return this.m_promptValues.getPromptValue(this.m_definition);
    }

    private void setPromptValue(Object value) throws InvalidPromptValueException {
        if (!this.isFixed()) {
            this.m_promptValues.setPromptValue(this.m_definition, value);
        }
    }

    @Override
    public boolean isValueValid(Object value) {
        boolean valid = false;
        try {
            Object newPromptValue = this.getOMRValueFromModelObject(value);
            valid = this.m_definition.isPromptValueValid(newPromptValue);
            if (valid && this.isSourceTargetColumnDefinition()) {
                if (value instanceof IColumn) {
                    return this.isColumnValid((IColumn)value);
                }
                if (value instanceof List) {
                    return this.isColumnListValid((List)value);
                }
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (MdException mdException) {
        }
        catch (ServiceException serviceException) {
        }
        catch (ServerConnectionException serverConnectionException) {
            // empty catch block
        }
        return valid;
    }

    @Override
    public boolean isFixed() {
        return this.m_definition.isFixed();
    }

    @Override
    public void setFixed(boolean bFixed) {
        ((PromptDefinition)this.m_definition).setFixed(bFixed);
    }

    @Override
    public boolean isValueSetNotIncludingDefault() {
        return this.m_promptValues.isPromptValueSet(this.m_definition);
    }

    @Override
    public boolean isValueSet() {
        boolean isSet;
        block6: {
            isSet = false;
            if (this.m_promptValues.isPromptValueSet(this.m_definition)) {
                if (this.m_definition.isDefaultValueSet()) {
                    Object defaultValue = this.m_definition.getDefaultValue();
                    try {
                        if (defaultValue.equals(this.getPromptValue())) {
                            isSet = false;
                            break block6;
                        }
                        isSet = true;
                    }
                    catch (PromptValueNotFoundException promptValueNotFoundException) {}
                } else {
                    isSet = true;
                }
            }
        }
        return isSet;
    }

    @Override
    public boolean isValueAvailable() {
        return this.m_promptValues.isPromptValueAvailable(this.m_definition);
    }

    @Override
    public String getName() {
        return this.m_definition.getPromptName();
    }

    @Override
    public IObject getOwner() {
        return this.m_model.getOwner();
    }

    private String getMacroBaseName() {
        return this.m_definition.getPromptName().trim();
    }

    @Override
    public String getPromptLabel() {
        return this.m_definition.getPromptLabel(Locale.getDefault());
    }

    @Override
    public String getDescription() {
        return this.m_definition.getPromptDescription(Locale.getDefault());
    }

    @Override
    public void saveToOMR(OMRAdapter omr, Property property) throws MdException, RemoteException {
        Object value = null;
        try {
            value = this.m_promptValues.getPromptValue(this.m_definition);
        }
        catch (PromptValueNotFoundException promptValueNotFoundException) {
            // empty catch block
        }
        String promptName = this.getName();
        property.setName(this.m_definition.getPromptLabel(Locale.getDefault()));
        property.setPropertyName(promptName);
        property.setPropertyRole(this.m_propertyRole);
        property.setDelimiter(this.m_delimiter);
        property.setUseValueOnly(this.m_useValueOnly);
        property.setSQLType(this.m_definition.getPromptDataType().getSQLType());
        PromptDefinitionReference defReference = new PromptDefinitionReference(this.m_definition, value);
        String saveValue = "";
        try {
            StringBuffer xml = PromptUtils.getXMLForObject((PersistenceInterface)defReference, null);
            boolean saveAsString = this.m_model.isSavingValuesAsStrings();
            if (xml != null && !saveAsString) {
                saveValue = xml.toString();
            } else if (saveAsString) {
                saveValue = this.m_definition.getPromptDataType().getPersistanceString(value);
            }
        }
        catch (ParserConfigurationException exc) {
            throw new MdException((Throwable)exc);
        }
        catch (BackingStoreException exc) {
            throw new MdException((Throwable)exc);
        }
        property.setDefaultValue(saveValue);
        if (this.isMetadataDefinition()) {
            List valueList = this.getModelValueList();
            this.saveObjectListPropertyToOMR(omr, valueList.toArray(new IPersistableObject[valueList.size()]), property);
        }
    }

    private PromptDefinitionReference getPromptDefinitionReferenceFromOMRLink(OMRAdapter omr, Property property, int sqlType) throws MdException, RemoteException, ServiceException, ServerConnectionException {
        Object val;
        Object propertyValue = this.getSpecificOptionObjectValue(omr, property, this.m_definition.getPromptDataType().getSQLType());
        if (propertyValue != null && (val = this.getOMRValueFromModelObject(propertyValue)) != null) {
            propertyValue = val;
        }
        return new PromptDefinitionReference(this.m_definition, propertyValue);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr, Property property) throws MdException, RemoteException {
        block10: {
            try {
                DataSourceInterface[] sources = null;
                DataSourceInterface[] targets = null;
                if (this.m_model.getDataProvider() != null) {
                    sources = this.m_model.getDataProvider().getPromptDataSources();
                    targets = this.m_model.getDataProvider().getPromptDataTargets();
                }
                this.fixDefinition(sources, targets, this.m_model.getDataProvider());
                if (property == null || this.isFixed()) break block10;
                String propertyDefaultValue = property.getDefaultValue();
                PromptDefinitionReference defRef = null;
                try {
                    defRef = !this.isMetadataDefinition() ? (PromptDefinitionReference)PromptUtils.getObjectForXML(Workspace.getWorkspace().getUserContext(), propertyDefaultValue) : this.getPromptDefinitionReferenceFromOMRLink(omr, property, this.m_definition.getPromptDataType().getSQLType());
                }
                catch (Exception exc) {
                    defRef = this.getPromptDefinitionReferenceFromOMRLink(omr, property, this.m_definition.getPromptDataType().getSQLType());
                }
                if (defRef != null) {
                    Object val = defRef.getValue();
                    if (this.m_definition instanceof DataSourceColumnDefinitionInterface) {
                        val = this.getValidColumnList(val);
                    }
                    try {
                        this.setPromptValue(val);
                    }
                    catch (InvalidPromptValueException exc) {
                        this.m_promptValues.clearPromptValue(this.m_definition);
                    }
                }
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
            catch (ServerConnectionException e) {
                throw new MdException((Throwable)e);
            }
        }
    }

    private void saveObjectListPropertyToOMR(OMRAdapter omr, IPersistableObject[] aObjects, Property mdoProperty) throws MdException, RemoteException {
        Transformation mdoTransform = null;
        for (int i = 0; i < mdoProperty.getSpecTargetTransformations().size(); ++i) {
            if (!((Root)mdoProperty.getSpecTargetTransformations().get(i)).getCMetadataType().equals("Transformation")) continue;
            mdoTransform = (Transformation)mdoProperty.getSpecTargetTransformations().get(i);
        }
        if (mdoTransform == null) {
            String sId = this.m_model.getModel().createIDForNewObject(this.m_model.getOwner().getID());
            mdoTransform = (Transformation)omr.acquireOMRObject(sId, "Transformation");
            mdoTransform.setName(this.getName());
            mdoTransform.setTransformRole(this.getName());
            mdoProperty.getSpecTargetTransformations().add((Object)mdoTransform);
        }
        AssociationList lObjects = mdoTransform.getSourceSpecifications();
        lObjects.clear();
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            IPersistableObject iPersistObj = aObjects[iObject];
            Root obj = omr.acquireOMRObject(iPersistObj);
            obj = (Root)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)obj, null, null, "", 8);
            lObjects.add(obj);
        }
    }

    private Object getSpecificOptionObjectValue(OMRAdapter omr, Property prop, int sqlType) throws MdException, RemoteException {
        ArrayList object = null;
        if (prop != null) {
            if (this.isMetadataDefinition()) {
                List objs = this.getPropertyMetadataObjects(omr, prop);
                if (prop.getSQLType() != sqlType) {
                    if (objs == null || objs.isEmpty()) {
                        object = this.getSpecificOptionValue(prop);
                    } else if (this.m_definition instanceof SelectableDefinitionInterface && ((SelectableDefinitionInterface)this.m_definition).getMaximumValueCount() > 0 && objs.size() > ((SelectableDefinitionInterface)this.m_definition).getMaximumValueCount()) {
                        SelectableDefinitionInterface def = (SelectableDefinitionInterface)this.m_definition;
                        ArrayList newList = new ArrayList();
                        for (int i = 0; i < def.getMaximumValueCount(); ++i) {
                            newList.add(objs.get(i));
                        }
                        object = newList;
                    } else {
                        object = objs;
                    }
                } else {
                    object = objs;
                }
            } else {
                object = this.getSpecificOptionValue(prop);
            }
        }
        return object;
    }

    private String getSpecificOptionValue(Property iProp) throws MdException, RemoteException {
        String returnValue = "";
        if (iProp != null) {
            returnValue = this.getDefaultValue(iProp);
        }
        return returnValue;
    }

    private String getDefaultValue(Property iProp) throws RemoteException {
        String returnValue = "";
        String propertyDefaultValue = iProp.getDefaultValue();
        PromptDefinitionReference defReference = null;
        try {
            defReference = (PromptDefinitionReference)PromptUtils.getObjectForXML(Workspace.getWorkspace().getUserContext(), propertyDefaultValue);
            Object value = defReference.getValue();
            if (value != null) {
                returnValue = value.toString();
            }
        }
        catch (Exception exc) {
            returnValue = propertyDefaultValue.trim();
        }
        return returnValue;
    }

    private List getPropertyMetadataObjects(OMRAdapter omr, Property iProp) throws MdException, RemoteException {
        ArrayList<IOMRPersistable> metaList = new ArrayList<IOMRPersistable>();
        if (iProp != null) {
            AssociationList specTargets = iProp.getSpecTargetTransformations();
            int specSize = specTargets.size();
            for (int i = 0; i < specSize; ++i) {
                if (!((Root)specTargets.get(i)).getCMetadataType().equals("Transformation")) continue;
                Transformation trans = (Transformation)specTargets.get(i);
                AssociationList sourceSpecs = trans.getSourceSpecifications();
                int size = sourceSpecs.size();
                for (int j = 0; j < size; ++j) {
                    IOMRPersistable modelObj = omr.acquireObject((Root)sourceSpecs.get(j));
                    metaList.add(modelObj);
                }
            }
        }
        return metaList;
    }

    private boolean isMetadataDefinition() {
        boolean bMetadata = false;
        if (this.m_definition instanceof SASLibraryDefinitionInterface) {
            bMetadata = true;
        } else if (this.m_definition instanceof DataSourceColumnDefinitionInterface) {
            bMetadata = true;
        } else if (this.m_definition instanceof DataSourceDefinitionInterface) {
            bMetadata = true;
        } else if (this.m_definition instanceof OLAPMemberNameDefinitionInterface) {
            bMetadata = true;
        }
        return bMetadata;
    }

    private List getValidColumnList(Object value) throws MdException, RemoteException, ServiceException, ServerConnectionException {
        DataSourceColumnInterface dsc;
        ArrayList<DataSourceColumnInterface> returnList = new ArrayList<DataSourceColumnInterface>();
        ArrayList<DataSourceColumnInterface> colList = new ArrayList<DataSourceColumnInterface>();
        PromptDataProvider provider = this.m_model.getDataProvider();
        if (value instanceof List) {
            List valList = (List)value;
            for (int i = 0; i < valList.size(); ++i) {
                DataSourceColumnInterface dsc2;
                Object val = valList.get(i);
                if (!(val instanceof DataSourceColumnInterface) || (dsc2 = (DataSourceColumnInterface)val) == null) continue;
                colList.add(dsc2);
            }
        } else if (value instanceof DataSourceColumnInterface) {
            dsc = (DataSourceColumnInterface)value;
            if (dsc != null) {
                colList.add(dsc);
            }
        } else if (value instanceof String && provider != null && (dsc = provider.getDataSourceColumnFromString(value.toString(), this.isSourceColumnDefinition())) != null) {
            colList.add(dsc);
        }
        if (this.isSourceTargetColumnDefinition() && provider != null) {
            for (int i = 0; i < colList.size(); ++i) {
                DataSourceColumnInterface dsc3 = (DataSourceColumnInterface)colList.get(i);
                if (!this.isColumnValid(provider.getColumn(dsc3))) continue;
                returnList.add(dsc3);
            }
        } else {
            returnList = colList;
        }
        if (returnList.isEmpty()) {
            returnList = null;
        }
        return returnList;
    }

    private Object getModelObjectValue(Object promptValue) throws MdException, RemoteException, ServerConnectionException, ServiceException {
        if (promptValue instanceof List) {
            ArrayList<Object> newValues = new ArrayList<Object>();
            List lstValues = (List)promptValue;
            for (int i = 0; i < lstValues.size(); ++i) {
                Object lstObject = this.getModelObjectValue(lstValues.get(i));
                if (lstObject == null) continue;
                newValues.add(lstObject);
            }
            return newValues;
        }
        if (promptValue instanceof DataSourceInterface && this.m_model.getDataProvider() != null) {
            DataSourceInterface ds = (DataSourceInterface)promptValue;
            IOMRPersistable obj = null;
            obj = 1L == ds.getDataSourceType() ? this.m_model.getDataProvider().getTable(ds.getDataSourceLocation()) : this.m_model.getDataProvider().getModelObject(ds.getDataSourceLocation());
            return obj;
        }
        if (promptValue instanceof DataSourceColumnInterface && this.m_model.getDataProvider() != null) {
            return this.m_model.getDataProvider().getColumn((DataSourceColumnInterface)promptValue);
        }
        if (promptValue instanceof SASLibraryLocationInterface && this.m_model.getDataProvider() != null) {
            SASLibraryLocationInterface lc = (SASLibraryLocationInterface)promptValue;
            return this.m_model.getDataProvider().getLibrary(lc);
        }
        return promptValue;
    }

    public Object getOMRValueFromModelObject(Object propertyValue) throws MdException, RemoteException, ServerConnectionException, ServiceException {
        Object value = null;
        if (propertyValue instanceof List || propertyValue instanceof Object[]) {
            List<Object> propList = null;
            propList = propertyValue instanceof List ? (List<Object>)propertyValue : Arrays.asList((Object[])propertyValue);
            ArrayList<Object> lstValues = new ArrayList<Object>();
            for (int i = 0; i < propList.size(); ++i) {
                Object newVal = this.getOMRValueFromModelObject(propList.get(i));
                if (newVal == null) continue;
                lstValues.add(newVal);
            }
            value = lstValues;
        } else if (propertyValue instanceof IPhysicalTable && this.m_model.getDataProvider() != null) {
            value = this.m_model.getDataProvider().makeTableDataSource((IPhysicalTable)propertyValue);
        } else if (propertyValue instanceof IColumn && this.m_model.getDataProvider() != null) {
            value = this.m_model.getDataProvider().makeDataSourceColumnInterface((IColumn)propertyValue);
        } else if (propertyValue instanceof ILibrary && this.m_model.getDataProvider() != null) {
            value = this.m_model.getDataProvider().getPromptLibraryFromLibrary((ILibrary)propertyValue);
        } else if (propertyValue instanceof IGenericObject) {
            IGenericObject obj = (IGenericObject)propertyValue;
            value = this.m_definition.getPromptDataType().coerceValue((Object)obj.getSBIPUrl(), Locale.getDefault());
            if (value instanceof BaseDataSource) {
                BaseDataSource ds = (BaseDataSource)value;
                if ("InformationMap.OLAP".equals(obj.getPublicType())) {
                    ds.setDataSourceType(8L);
                } else if ("Cube".equals(obj.getPublicType())) {
                    ds.setDataSourceType(2L);
                } else if ("InformationMap.Relational".equals(obj.getPublicType())) {
                    ds.setDataSourceType(4L);
                }
            }
        } else if (propertyValue instanceof ICube) {
            ICube obj = (ICube)propertyValue;
            value = this.m_definition.getPromptDataType().coerceValue((Object)obj.getSBIPUrl(), Locale.getDefault());
            if (value instanceof BaseDataSource) {
                BaseDataSource ds = (BaseDataSource)value;
                if ("Cube".equals(obj.getPublicType())) {
                    ds.setDataSourceType(2L);
                }
            }
        } else if (propertyValue instanceof String && this.m_definition instanceof DataSourceColumnDefinitionInterface && this.m_model.getDataProvider() != null) {
            String location = this.getColumnDefinitionLocationKeyValue();
            boolean checkSources = false;
            if (location != null) {
                checkSources = location.equals("Sources");
            }
            value = this.m_model.getDataProvider().getDataSourceColumnFromString((String)propertyValue, checkSources);
        } else if (propertyValue instanceof String && this.m_definition instanceof DataSourceDefinitionInterface && this.m_model.getDataProvider() != null) {
            value = this.m_model.getDataProvider().getDataSourceFromString((String)propertyValue);
        } else if (propertyValue != null) {
            if (propertyValue instanceof String && this.m_definition instanceof BaseFileDefinition) {
                propertyValue = "null @@ " + propertyValue + " @@ " + Boolean.toString(((BaseFileDefinition)this.m_definition).getFileSelectionMode() == 2);
            }
            if ((value = this.m_definition.getPromptDataType().coerceValue(propertyValue, Locale.getDefault())) instanceof List && !((List)value).isEmpty()) {
                value = ((List)value).get(0);
            }
        }
        return value;
    }

    @Override
    public boolean isCodeGenerationEnabled() {
        return this.m_bCodeGenEnabled;
    }

    @Override
    public void setCodeGenerationEnabled(boolean enabled) {
        this.m_bCodeGenEnabled = enabled;
    }

    public StringBuffer getCodegenStringForValue(ICodeSegment codeSegment, boolean useLetStatement, boolean generateBlankValues, boolean genPercentLocalStatements, boolean bUseEscapeQuotes) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, ServerConnectionException, ServerException {
        Map map;
        StringBuffer sb = new StringBuffer();
        if (!this.isCodeGenerationEnabled()) {
            return sb;
        }
        IColumn[] value = this.getValue();
        DataTypeInterface dt = this.m_definition.getPromptDataType();
        if (this.m_definition instanceof SASLibraryDefinitionInterface) {
            if (value instanceof ILibrary) {
                ILibrary lib = (ILibrary)value;
                if (!this.getGenerateLibnames()) {
                    IFile file;
                    IFile[] files = lib.getFiles();
                    if (null != files && files.length > 0 && null != (file = files[0])) {
                        sb.append("filename ").append(lib.getLibref()).append(" \"").append(file.getFileName()).append("\";\n");
                    }
                } else {
                    sb.append(lib.getAccessPath(codeSegment.getCodeGenerationEnvironment()));
                }
            }
            if (useLetStatement) {
                sb.append(PromptUtils.getExplicitSQLMacroCode(codeSegment, this.getMacroBaseName(), (ILibrary)value));
            }
            map = dt.getMacroVariableValues((MacroVariableOptionInterface)this.m_definition, value != null && this.m_model.getDataProvider() != null ? this.m_model.getDataProvider().getPromptLibraryFromLibrary((ILibrary)value) : null, Locale.getDefault());
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String macName = it.next().toString().trim();
                Object val = map.get(macName);
                String macValue = "";
                if (val != null) {
                    macValue = val.toString();
                }
                sb.append(this.makeNameValueStatement(macName, macValue, useLetStatement, generateBlankValues, genPercentLocalStatements, bUseEscapeQuotes));
            }
        } else if (this.m_definition instanceof DataSourceDefinitionInterface) {
            if (((DataSourceDefinitionInterface)this.m_definition).isDataSourceTypeAllowed(1L) && (value instanceof IPhysicalTable || value == null)) {
                IPhysicalTable table = (IPhysicalTable)value;
                if (table != null) {
                    sb.append(table.getAccessPath(codeSegment.getCodeGenerationEnvironment(), null));
                }
                if (!useLetStatement && table != null) {
                    sb.append(this.makeNameValueStatement(this.getMacroBaseName(), table.getFullNameQuotedAsNeeded(codeSegment), useLetStatement, generateBlankValues, genPercentLocalStatements, bUseEscapeQuotes));
                } else {
                    sb.append(PromptUtils.getTablePercentLetStatements(codeSegment, this.getName(), table, false, null, null, false));
                }
            } else {
                Object promptValue = null;
                try {
                    promptValue = this.getPromptValue();
                }
                catch (PromptValueNotFoundException it) {
                    // empty catch block
                }
                Map map2 = dt.getMacroVariableValues((MacroVariableOptionInterface)this.m_definition, promptValue, Locale.getDefault());
                Iterator it = map2.keySet().iterator();
                while (it.hasNext()) {
                    String macName = it.next().toString().trim();
                    Object val = map2.get(macName);
                    String macValue = "";
                    if (val != null) {
                        macValue = val.toString();
                    }
                    sb.append(this.makeNameValueStatement(macName, macValue, useLetStatement, generateBlankValues, genPercentLocalStatements, bUseEscapeQuotes));
                }
            }
        } else if (this.m_definition instanceof DataSourceColumnDefinitionInterface) {
            String delim;
            String val;
            UserInfoInterface info = this.m_definition.getUserInfo();
            if (value instanceof List) {
                List lstValue = (List)value;
                value = lstValue.toArray(new IColumn[lstValue.size()]);
            }
            boolean emitSQL = false;
            if (info.contains("EmitSQL") && (val = info.get("EmitSQL")).equals("Yes")) {
                emitSQL = true;
            }
            boolean isList = this.m_definition instanceof SelectableDefinitionInterface;
            if (value instanceof IColumn) {
                value = new IColumn[]{(IColumn)value};
            }
            IColumn[] colList = new IColumn[]{};
            boolean needQuotes = codeSegment.isQuoting();
            String string = delim = emitSQL ? "," : " ";
            if (value instanceof IColumn[]) {
                colList = value;
            }
            sb.append(this.makeNameValueStatement(this.getMacroBaseName(), codeSegment.makeColumnListWithTableNames(Arrays.asList(colList), false, "", false, delim, "", needQuotes, "", emitSQL), useLetStatement, generateBlankValues, genPercentLocalStatements, bUseEscapeQuotes));
            if (isList && useLetStatement) {
                sb.append("%let ").append(this.getMacroBaseName()).append("_count = ").append(colList.length).append(";\n");
                sb.append("%let ").append(this.getMacroBaseName()).append("0 = ").append(colList.length).append(";\n");
                for (int i = 0; i < colList.length; ++i) {
                    sb.append("%let ").append(this.getMacroBaseName()).append(i + 1).append(" = ").append(colList[i].getColumnName(needQuotes)).append(";\n");
                }
            }
        } else {
            map = dt.getMacroVariableValues((MacroVariableOptionInterface)this.m_definition, (Object)value, Locale.getDefault());
            boolean bGenFirstListItem = false;
            if (this.m_definition instanceof MutableMacroVariableListOptionInterface && value instanceof List && ((List)value).size() == 1) {
                bGenFirstListItem = true;
            }
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String macName = it.next().toString().trim();
                if (bGenFirstListItem && (this.m_definition.getMacroVariableBaseName() + "1").equals(macName)) {
                    bGenFirstListItem = false;
                }
                Object val = map.get(macName);
                String macValue = "";
                if (val != null) {
                    macValue = val.toString();
                }
                sb.append(this.makeNameValueStatement(macName, macValue, useLetStatement, generateBlankValues, genPercentLocalStatements, bUseEscapeQuotes));
            }
            if (bGenFirstListItem) {
                String macValue = "";
                Object firstValue = map.get(this.m_definition.getMacroVariableBaseName());
                if (firstValue != null) {
                    macValue = firstValue.toString();
                }
                sb.append(this.makeNameValueStatement(this.m_definition.getMacroVariableBaseName() + "1", macValue, useLetStatement, generateBlankValues, genPercentLocalStatements, bUseEscapeQuotes));
            }
        }
        if (value == null && !(map = dt.getMacroVariableValues((MacroVariableOptionInterface)this.m_definition, (Object)value, Locale.getDefault())).containsKey(this.m_definition.getMacroVariableBaseName())) {
            sb.append(this.makeNameValueStatement(this.m_definition.getMacroVariableBaseName(), "", useLetStatement, generateBlankValues, genPercentLocalStatements, bUseEscapeQuotes));
        }
        StringBuffer retValue = new StringBuffer();
        retValue.append(sb);
        return retValue;
    }

    @Override
    public Map<String, String> getMacroNamesAndValues(ICodeSegment codeSegment, boolean useLetStatement, boolean generateBlankValues, boolean genPercentLocalStatements, boolean bUseEscapeQuotes) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServiceException, ServerConnectionException, ServerException {
        Map map;
        HashMap<String, String> namesAndValues = new HashMap<String, String>();
        IColumn[] value = this.getValue();
        DataTypeInterface dt = this.m_definition.getPromptDataType();
        if (this.m_definition instanceof SASLibraryDefinitionInterface) {
            if (useLetStatement) {
                namesAndValues.putAll(PromptUtils.getExplicitSQLMacroCodeMap(codeSegment, this.getMacroBaseName(), (ILibrary)value));
            }
            map = dt.getMacroVariableValues((MacroVariableOptionInterface)this.m_definition, value != null && this.m_model.getDataProvider() != null ? this.m_model.getDataProvider().getPromptLibraryFromLibrary((ILibrary)value) : null, Locale.getDefault());
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String macName = it.next().toString().trim();
                Object val = map.get(macName);
                String macValue = "";
                if (val != null) {
                    macValue = val.toString();
                }
                namesAndValues.put(macName, macValue);
            }
        } else if (this.m_definition instanceof DataSourceDefinitionInterface) {
            if (((DataSourceDefinitionInterface)this.m_definition).isDataSourceTypeAllowed(1L) && (value instanceof IPhysicalTable || value == null)) {
                IPhysicalTable table = (IPhysicalTable)value;
                if (!useLetStatement && table != null) {
                    namesAndValues.put(this.getMacroBaseName(), table.getFullNameQuotedAsNeeded(codeSegment));
                } else {
                    namesAndValues.putAll(PromptUtils.getTablePercentLetStatementsMap(codeSegment, this.getName(), table, false, null, null, false, true));
                }
            } else {
                Object promptValue = null;
                try {
                    promptValue = this.getPromptValue();
                }
                catch (PromptValueNotFoundException it) {
                    // empty catch block
                }
                Map map2 = dt.getMacroVariableValues((MacroVariableOptionInterface)this.m_definition, promptValue, Locale.getDefault());
                Iterator it = map2.keySet().iterator();
                while (it.hasNext()) {
                    String macName = it.next().toString().trim();
                    Object val = map2.get(macName);
                    String macValue = "";
                    if (val != null) {
                        macValue = val.toString();
                    }
                    namesAndValues.put(macName, macValue);
                }
            }
        } else if (this.m_definition instanceof DataSourceColumnDefinitionInterface) {
            String delim;
            String val;
            UserInfoInterface info = this.m_definition.getUserInfo();
            if (value instanceof List) {
                List lstValue = (List)value;
                value = lstValue.toArray(new IColumn[lstValue.size()]);
            }
            boolean emitSQL = false;
            if (info.contains("EmitSQL") && (val = info.get("EmitSQL")).equals("Yes")) {
                emitSQL = true;
            }
            boolean isList = this.m_definition instanceof SelectableDefinitionInterface;
            if (value instanceof IColumn) {
                value = new IColumn[]{(IColumn)value};
            }
            IColumn[] colList = new IColumn[]{};
            boolean needQuotes = codeSegment.isQuoting();
            String string = delim = emitSQL ? "," : " ";
            if (value instanceof IColumn[]) {
                colList = value;
            }
            namesAndValues.put(this.getMacroBaseName(), codeSegment.makeColumnList(Arrays.asList(colList), false, "", false, delim, "", needQuotes, "", emitSQL));
            if (isList && useLetStatement) {
                namesAndValues.put(this.getMacroBaseName() + "_count", Integer.toString(colList.length));
                namesAndValues.put(this.getMacroBaseName() + "0", Integer.toString(colList.length));
                for (int i = 0; i < colList.length; ++i) {
                    namesAndValues.put(this.getMacroBaseName() + Integer.toString(i + 1), colList[i].getColumnName(needQuotes));
                }
            }
        } else {
            map = dt.getMacroVariableValues((MacroVariableOptionInterface)this.m_definition, (Object)value, Locale.getDefault());
            boolean bGenFirstListItem = false;
            if (this.m_definition instanceof MutableMacroVariableListOptionInterface && value instanceof List && ((List)value).size() == 1) {
                bGenFirstListItem = true;
            }
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String macName = it.next().toString().trim();
                if (bGenFirstListItem && (this.m_definition.getMacroVariableBaseName() + "1").equals(macName)) {
                    bGenFirstListItem = false;
                }
                Object val = map.get(macName);
                String macValue = "";
                if (val != null) {
                    macValue = val.toString();
                }
                namesAndValues.put(macName, macValue);
            }
            if (bGenFirstListItem) {
                String macValue = "";
                Object firstValue = map.get(this.m_definition.getMacroVariableBaseName());
                if (firstValue != null) {
                    macValue = firstValue.toString();
                }
                namesAndValues.put(this.m_definition.getMacroVariableBaseName() + "1", macValue);
            }
        }
        if (value == null && !(map = dt.getMacroVariableValues((MacroVariableOptionInterface)this.m_definition, (Object)value, Locale.getDefault())).containsKey(this.m_definition.getMacroVariableBaseName())) {
            namesAndValues.put(this.m_definition.getMacroVariableBaseName(), "");
        }
        return namesAndValues;
    }

    @Override
    public void setValue(Object newValue) throws MdException, RemoteException, IllegalStateException, ServiceException, ServerConnectionException {
        Object newPromptValue = this.getOMRValueFromModelObject(newValue);
        Object oldPromptValue = null;
        try {
            oldPromptValue = this.getPromptValue();
        }
        catch (PromptValueNotFoundException promptValueNotFoundException) {
            // empty catch block
        }
        if (this.isValueValid(newValue) && newPromptValue != oldPromptValue) {
            try {
                this.setPromptValue(newPromptValue);
            }
            catch (InvalidPromptValueException invalidPromptValueException) {
                // empty catch block
            }
        }
    }

    @Override
    public IPromptModel getModel() {
        return this.m_model;
    }

    @Override
    public Object getValue() {
        if (this.isValueSetNotIncludingDefault()) {
            return this.m_modelValue;
        }
        if (this.isDefaultValueSet()) {
            return this.m_defaultObject;
        }
        return null;
    }

    protected boolean isValueWrappedInParenthesis() {
        return this.isUserInfoValueEqual("UseParenthesisInValue", "Yes");
    }

    private StringBuffer makeNameValueStatement(String macroName, String macroValue, boolean useLetStatement, boolean generateBlankValues, boolean genPercentLocalStatement, boolean bUseEscapeQuoting) {
        StringBuffer retValue = new StringBuffer();
        if (generateBlankValues && macroValue == null) {
            macroValue = "";
        }
        if (macroValue != null) {
            boolean escapeQuotes;
            if (!generateBlankValues && macroValue.length() == 0) {
                return retValue;
            }
            boolean bl = escapeQuotes = macroValue.length() != 0 && useLetStatement && !this.isMetadataDefinition() && bUseEscapeQuoting;
            if (useLetStatement) {
                if (genPercentLocalStatement) {
                    retValue.append("%local ").append(macroName).append(";\n");
                }
                retValue.append("%let ");
            }
            if (this.m_useValueOnly == 0) {
                retValue.append(macroName).append(" ");
                if (this.m_delimiter != null) {
                    retValue.append(this.m_delimiter);
                }
                retValue.append(" ");
                if (escapeQuotes) {
                    retValue.append("%nrquote(");
                    SASCodeGeneration sasGen = new SASCodeGeneration();
                    macroValue = sasGen.escapeMacroValue(macroValue);
                } else if (this.isValueWrappedInParenthesis()) {
                    retValue.append("(");
                }
                if (this.isValueQuoted()) {
                    retValue.append("'");
                }
                retValue.append(macroValue);
                if (this.isValueQuoted()) {
                    retValue.append("'");
                }
                if (escapeQuotes) {
                    retValue.append(")");
                } else if (this.isValueWrappedInParenthesis()) {
                    retValue.append(")");
                }
            } else {
                retValue.append(macroValue);
            }
            if (useLetStatement) {
                retValue.append(";\n");
            }
        }
        return retValue;
    }

    @Override
    public String toString() {
        return this.m_definition.getPromptName();
    }

    @Override
    public boolean isRequired() {
        return this.m_definition.isRequired();
    }

    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap, boolean caseSensitive) throws RemoteException, ServiceException, ServerConnectionException, MdException {
        if (this.isSourceColumnDefinition() && this.isValueSetNotIncludingDefault()) {
            this.replaceColumnValues(oldTable, newTable, columnsMap, caseSensitive);
        }
    }

    private void replaceColumnValues(ITable oldTable, ITable newTable, Map columnsMap, boolean caseSensitive) throws ServiceException, RemoteException, ServerConnectionException, MdException {
        Object val = this.getValue();
        if (val instanceof IColumn) {
            IColumn oldColumn = (IColumn)val;
            if (columnsMap != null && columnsMap.get(oldColumn) != null) {
                this.setValue(columnsMap.get(oldColumn));
            } else {
                IColumn[] newColumns = newTable.getColumns();
                for (int i = 0; i < newColumns.length; ++i) {
                    if (oldColumn.getTable() != oldTable || !oldColumn.equalsName(newColumns[i], caseSensitive) || !this.isValueValid(newColumns[i])) continue;
                    this.setValue(newColumns[i]);
                    break;
                }
            }
        } else if (val instanceof IColumn[] || val instanceof List) {
            IColumn[] oldValues = null;
            oldValues = val instanceof IColumn[] ? (IColumn[])val : ((List)val).toArray(new IColumn[((List)val).size()]);
            ArrayList<IColumn> newList = new ArrayList<IColumn>();
            for (int i = 0; i < oldValues.length; ++i) {
                IColumn oldColumn;
                IColumn newColumn = oldColumn = oldValues[i];
                if (columnsMap != null && columnsMap.get(oldColumn) != null) {
                    newColumn = (IColumn)columnsMap.get(oldColumn);
                } else {
                    IColumn[] newColumns = newTable.getColumns();
                    for (int j = 0; j < newColumns.length; ++j) {
                        if (oldColumn.getTable() != oldTable || !oldColumn.equalsName(newColumns[j], caseSensitive) || !this.isValueValid(newColumns[j])) continue;
                        newColumn = newColumns[j];
                        break;
                    }
                }
                newList.add(newColumn);
            }
            this.setValue(newList);
        }
    }

    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, boolean caseSensitive) throws RemoteException, ServiceException, ServerConnectionException, MdException {
        if (this.isTargetColumnDefinition() && this.isValueSetNotIncludingDefault()) {
            this.replaceColumnValues(oldTable, newTable, columnsMap, caseSensitive);
        }
    }

    @Override
    public boolean isRefreshNeeded() {
        boolean refresh = false;
        if (this.m_definition instanceof DataSourceColumnDefinitionInterface) {
            refresh = true;
        }
        return refresh;
    }

    @Override
    public void setDefaultValue(Object value) throws RemoteException, ServerConnectionException, ServiceException, MdException {
        if (this.isValueValid(value)) {
            Object defaultValue = this.getOMRValueFromModelObject(value);
            ((PromptDefinition)this.m_definition).setDefaultValue(defaultValue);
            this.setDefaultModelObject(value);
        }
    }

    @Override
    public void clearDefaultValue() {
        this.setDefaultModelObject(null);
        this.m_definition.clearDefaultValue();
        this.fireModelChangeEvent();
    }

    @Override
    public void clearValue() {
        if (!this.isFixed()) {
            this.m_promptValues.clearPromptValue(this.m_definition);
        }
    }

    private void fireModelChangeEvent() {
        this.m_model.getModel().fireModelEvent(this.m_model.getOwner(), "IPromptDefinitionValue:PromptDefinitionChanged", this);
        this.m_model.getOwner().setChanged(true);
    }

    private void setModelValue(Object newValue) throws MdException, RemoteException, ServiceException, ServerConnectionException {
        this.removeNotifyListener(this.getModelValueList());
        Object oldModelValue = this.m_modelValue;
        Object newModelValue = this.getModelObjectValue(newValue);
        List newListValues = this.getModelValueList(newModelValue);
        this.addNotifyListener(newListValues);
        this.m_modelValue = newModelValue;
        this.fireChangeEvent(oldModelValue, newModelValue);
    }

    private List getModelValueList() {
        return this.getModelValueList(this.m_modelValue);
    }

    private List getModelValueList(Object value) {
        List<Object> retValue = new ArrayList();
        if (!(value instanceof List) && value != null) {
            retValue = new ArrayList();
            retValue.add(value);
        } else if (value instanceof List) {
            retValue = (List)value;
        }
        return retValue;
    }

    private void removeNotifyListener(List objectList) {
        if (objectList != null) {
            int size = objectList.size();
            for (int i = 0; i < size; ++i) {
                if (!(objectList.get(i) instanceof IObject)) continue;
                ((IObject)objectList.get(i)).removeNotifyListener(this);
            }
        }
    }

    private void addNotifyListener(List objectList) {
        if (objectList != null) {
            int size = objectList.size();
            for (int i = 0; i < size; ++i) {
                Object obj = objectList.get(i);
                if (!(obj instanceof IObject)) continue;
                ((IObject)obj).addNotifyListener(this);
                if (!(obj instanceof IColumn)) continue;
                ((IColumn)obj).getTable().addNotifyListener(this);
            }
        }
    }

    @Override
    public void swapValuesToDefaultValues() {
        try {
            if (this.isValueSetNotIncludingDefault()) {
                this.setDefaultValue(this.getValue());
                this.clearValue();
            }
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
    }

    @Override
    public void setHidden(boolean hide) {
        PromptGroupInterface pGroup = this.m_model.getPromptGroupObject().findPromptSubgroup(this.m_definition);
        if (pGroup instanceof ModalGroupInterface) {
            ((ModalGroupInterface)pGroup).setPromptGroupHidden(hide);
        }
        ((PromptDefinition)this.m_definition).setHidden(hide);
    }

    @Override
    public boolean isHidden() {
        return ((PromptDefinition)this.m_definition).isHidden();
    }

    private class cPromptValueChangeListener
    implements PromptValueChangeListener {
        public void promptValueChanged(PromptValueChangeEventInterface event) {
            if (event.getPromptDefinition() == BasePromptDefinitionValue.this.getDefinition()) {
                try {
                    BasePromptDefinitionValue.this.setModelValue(event.getNewValue());
                }
                catch (Exception e) {
                    ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
                }
            }
        }
    }
}

