/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IConnection;
import com.sas.etl.models.other.IGridServer;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.other.impl.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServiceType;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BaseServer
extends AbstractPersistableObject
implements IServer {
    private String m_productName;
    private String m_classIdentifier;
    private int m_major;
    private int m_minor;
    private String m_softwareVersion;
    private String m_vendor;
    private String m_omrType;
    private String m_installationLocation;
    private boolean m_bisLicensed;
    private String m_platform;
    private String m_productIdentifier;
    private String m_specVendor;
    private String m_specVersion;
    private String m_vendorIdentifier;
    private List m_subComponents = new ArrayList();
    private List m_clientConnections = new ArrayList();
    private IServer m_serverParent;
    private IServer m_serverContext;
    private String m_sServiceType = "";

    public BaseServer(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getServiceType() {
        return this.m_sServiceType;
    }

    @Override
    public void setServiceType(String serviceType) {
        if (serviceType == null) {
            throw new IllegalArgumentException("null is not valid for service type");
        }
        if (this.m_sServiceType.equals(serviceType)) {
            return;
        }
        this.m_sServiceType = serviceType;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        DeployedComponent mdoSC = (DeployedComponent)omr.acquireOMRObject(this);
        this.m_omrType = mdoSC.getCMetadataType();
        this.m_classIdentifier = mdoSC.getClassIdentifier();
        this.m_installationLocation = mdoSC.getInstallationLocation();
        this.m_bisLicensed = mdoSC.getIsLicensed() == 1;
        this.m_major = mdoSC.getMajor();
        this.m_minor = mdoSC.getMinor();
        this.m_platform = mdoSC.getPlatform();
        this.m_productIdentifier = mdoSC.getProductIdentifier();
        this.m_productName = mdoSC.getProductName();
        this.m_softwareVersion = mdoSC.getSoftwareVersion();
        this.m_specVendor = mdoSC.getSpecVendor();
        this.m_specVersion = mdoSC.getSpecVersion();
        this.m_vendor = mdoSC.getVendor();
        this.m_vendorIdentifier = mdoSC.getVendorIdentifier();
        this.m_omrType = mdoSC.getCMetadataType();
        AssociationList sT = mdoSC.getServiceTypes();
        if (!sT.isEmpty()) {
            this.setServiceType(((ServiceType)sT.get(0)).getName());
        } else {
            this.setServiceType("");
        }
        this.m_subComponents.clear();
        AssociationList usingComponents = mdoSC.getUsingComponents();
        int size = usingComponents.size();
        for (int i = 0; i < size; ++i) {
            DeployedComponent comp = (DeployedComponent)usingComponents.get(i);
            if (!(comp instanceof ServerComponent)) continue;
            IServer obj = (IServer)this.getModel().getObject(comp.getFQID());
            if (obj == null) {
                obj = (IServer)this.getModel().getObjectFactory().createObjectFromOMRObject((Root)comp);
                this.addSubComponent(obj);
                obj.loadFromOMR(omr);
                continue;
            }
            this.addSubComponent(obj);
        }
        this.loadClientConnections(omr);
        this.setChanged(false);
    }

    public void addSubComponent(IServer subComponent) {
        if (this.m_subComponents.contains(subComponent)) {
            return;
        }
        this.m_subComponents.add(subComponent);
        subComponent.setServerParent(this);
        subComponent.setServerContext(this.getServerContext());
    }

    @Override
    public IServer getServerContext() {
        if ("ServerContext".equals(this.getOMRType())) {
            return this;
        }
        return this.m_serverContext;
    }

    @Override
    public void setServerContext(IServer serverContext) {
        if (this.m_serverContext == serverContext) {
            return;
        }
        this.m_serverContext = serverContext;
    }

    @Override
    public IServer getServerParent() {
        return this.m_serverParent;
    }

    @Override
    public void setServerParent(IServer serverParent) {
        if (this.m_serverParent == serverParent) {
            return;
        }
        this.m_serverParent = serverParent;
    }

    @Override
    public void addClientConnection(IConnection connection) {
        if (this.m_clientConnections.contains(connection)) {
            return;
        }
        connection.setServer(this);
        this.m_clientConnections.add(connection);
    }

    public void clearClientConnections() {
        this.m_clientConnections.clear();
    }

    protected void loadClientConnections(OMRAdapter omr) throws MdException, RemoteException {
        DeployedComponent mdoSC = (DeployedComponent)omr.acquireOMRObject(this);
        this.clearClientConnections();
        AssociationList sourceConnections = mdoSC.getSourceConnections();
        int scSize = sourceConnections.size();
        for (int i = 0; i < scSize; ++i) {
            Connection comp = (Connection)sourceConnections.get(i);
            this.addClientConnection((IConnection)omr.acquireObject((Root)comp));
        }
    }

    protected IServer getConnectLogicalServer() {
        if (this.m_omrType.equals("ServerContext")) {
            IServer[] subs = this.getSubComponents();
            for (int i = 0; i < subs.length; ++i) {
                if (!subs[i].getClassIdentifier().equals("028e4060-d545-11d5-880d-aa0004006d06")) continue;
                return subs[i];
            }
        }
        return null;
    }

    protected IServer getConnectServerComponent() {
        IServer ls = this;
        if ("ServerContext".equals(this.m_omrType) && (ls = this.getConnectLogicalServer()) != null && "LogicalServer".equals(ls.getOMRType())) {
            IServer[] subs = ls.getSubComponents();
            for (int i = 0; i < subs.length; ++i) {
                if (!"028e4060-d545-11d5-880d-aa0004006d06".equals(subs[i].getClassIdentifier())) continue;
                return subs[i];
            }
        }
        return ls;
    }

    @Override
    public IServer getGridLogicalServer() {
        if ("ServerContext".equals(this.m_omrType)) {
            IServer[] subs = this.getSubComponents();
            for (int i = 0; i < subs.length; ++i) {
                if (!"D7E796B4-654C-4ab3-B690-657EE79309FB".equals(subs[i].getClassIdentifier())) continue;
                return subs[i];
            }
        }
        return null;
    }

    @Override
    public IGridServer getGridServer() {
        IServer[] srvs;
        IServer gridLogicalServer = this.getGridLogicalServer();
        if (gridLogicalServer != null && (srvs = gridLogicalServer.getSubComponents()).length > 0 && srvs[0] instanceof IGridServer) {
            return (IGridServer)srvs[0];
        }
        return null;
    }

    @Override
    public IConnection getConnection() {
        IConnection[] conns = this.getClientConnections();
        if (conns.length > 0) {
            return conns[0];
        }
        return null;
    }

    @Override
    public ISASClientConnection getConnectClient() {
        IConnection[] clients;
        IServer connLS = this.getConnectServerComponent();
        if (connLS != null && (clients = connLS.getClientConnections()).length > 0 && clients[0] instanceof ISASClientConnection) {
            return (ISASClientConnection)clients[0];
        }
        return null;
    }

    @Override
    public IConnection[] getClientConnections() {
        return this.m_clientConnections.toArray(new IConnection[this.m_clientConnections.size()]);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        DeployedComponent mdoSC = (DeployedComponent)omr.acquireOMRObject(this.getID(), this.getOMRType());
        mdoSC.setProductName(this.getProductName());
        mdoSC.setPlatform(this.getPlatform());
        mdoSC.setProductIdentifier(this.getProductIdentifier());
        mdoSC.setMajor(this.getMajor());
        mdoSC.setMinor(this.getMinor());
        mdoSC.setSoftwareVersion(this.getSoftwareVersion());
        mdoSC.setSpecVendor(this.getSpecVendor());
        mdoSC.setSpecVersion(this.getSpecVersion());
        mdoSC.setVendor(this.getVendor());
        mdoSC.setVendorIdentifier(this.getVendorIdentifier());
        mdoSC.setClassIdentifier(this.getClassIdentifier());
        mdoSC.setInstallationLocation(this.getInstallationLocation());
        mdoSC.setIsLicensed(this.isLicensed() ? 1 : 0);
        AssociationList sT = mdoSC.getServiceTypes();
        String serviceType = this.getServiceType();
        if (serviceType.length() > 0) {
            ServiceType mdoST = null;
            if (!sT.isEmpty()) {
                mdoST = (ServiceType)sT.get(0);
            } else {
                mdoST = (ServiceType)omr.acquireOMRObject(this.createIDForNewObject(), "ServiceType");
                sT.add(mdoST);
            }
            mdoST.setName(serviceType);
        }
        this.saveClientConnections(omr);
        this.setChanged(false);
    }

    protected void saveClientConnections(OMRAdapter omr) throws RemoteException, MdException {
        DeployedComponent mdoSC = (DeployedComponent)omr.acquireOMRObject(this);
        AssociationList sourceConnections = mdoSC.getSourceConnections();
        sourceConnections.clear();
        IConnection[] connections = this.getClientConnections();
        for (int i = 0; i < connections.length; ++i) {
            connections[i].saveToOMR(omr);
            sourceConnections.add(omr.acquireOMRObject(connections[i]));
        }
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List<String> lAssociations = (ArrayList<String>)map.get("ServerComponent");
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            map.put("ServerComponent", lAssociations);
        }
        lAssociations.add("SourceConnections");
        lAssociations.add("UsingComponents");
        lAssociations.add("Properties");
        lAssociations.add("PropertySets");
        lAssociations = (List)map.get("LogicalServer");
        if (lAssociations == null) {
            lAssociations = new ArrayList();
            map.put("LogicalServer", lAssociations);
        }
        lAssociations.add("SourceConnections");
        lAssociations.add("UsingComponents");
        lAssociations.add("Properties");
        lAssociations.add("PropertySets");
        lAssociations = (List)map.get("ServerContext");
        if (lAssociations == null) {
            lAssociations = new ArrayList();
            map.put("ServerContext", lAssociations);
        }
        lAssociations.add("SourceConnections");
        lAssociations.add("UsingComponents");
        lAssociations.add("Properties");
        lAssociations.add("PropertySets");
        return map;
    }

    @Override
    public IServer[] getSubComponents() {
        return this.m_subComponents.toArray(new IServer[this.m_subComponents.size()]);
    }

    public void setSubComponents(List subComponents) {
        this.m_subComponents = subComponents;
    }

    @Override
    public String getOMRType() {
        if (this.m_omrType == null) {
            return "ServerContext";
        }
        return this.m_omrType;
    }

    @Override
    public void setOMRType(String omrType) {
        this.m_omrType = omrType;
    }

    @Override
    public String getClassIdentifier() {
        return this.m_classIdentifier;
    }

    @Override
    public void setClassIdentifier(String identifier) {
        this.m_classIdentifier = identifier;
    }

    @Override
    public int getMajor() {
        return this.m_major;
    }

    @Override
    public void setMajor(int major) {
        this.m_major = major;
    }

    @Override
    public int getMinor() {
        return this.m_minor;
    }

    @Override
    public void setMinor(int minor) {
        this.m_minor = minor;
    }

    @Override
    public String getProductName() {
        return this.m_productName;
    }

    @Override
    public void setProductName(String productName) {
        this.m_productName = productName;
    }

    @Override
    public String getSoftwareVersion() {
        return this.m_softwareVersion;
    }

    @Override
    public void setSoftwareVersion(String softwareVersion) {
        this.m_softwareVersion = softwareVersion;
    }

    @Override
    public String getVendor() {
        return this.m_vendor;
    }

    @Override
    public void setVendor(String vendor) {
        this.m_vendor = vendor;
    }

    @Override
    public String getInstallationLocation() {
        return this.m_installationLocation;
    }

    public void setInstallationLocation(String location) {
        this.m_installationLocation = location;
    }

    @Override
    public boolean isLicensed() {
        return this.m_bisLicensed;
    }

    public void setIsLicensed(boolean licensed) {
        this.m_bisLicensed = licensed;
    }

    @Override
    public String getPlatform() {
        return this.m_platform;
    }

    public void setPlatform(String platform) {
        this.m_platform = platform;
    }

    @Override
    public String getProductIdentifier() {
        return this.m_productIdentifier;
    }

    public void setProductIdentifier(String identifier) {
        this.m_productIdentifier = identifier;
    }

    @Override
    public String getSpecVendor() {
        return this.m_specVendor;
    }

    public void setSpecVendor(String vendor) {
        this.m_specVendor = vendor;
    }

    @Override
    public String getSpecVersion() {
        return this.m_specVersion;
    }

    public void setSpecVersion(String version) {
        this.m_specVersion = version;
    }

    @Override
    public String getVendorIdentifier() {
        return this.m_vendorIdentifier;
    }

    public void setVendorIdentifier(String identifier) {
        this.m_vendorIdentifier = identifier;
    }

    @Override
    public String getServerOptions(boolean useAuthDomain, boolean encodePasswords) throws BadServerDefinitionException {
        return this.getServerOptions(useAuthDomain, encodePasswords, "");
    }

    @Override
    public String getServerOptions(boolean useAuthDomain, boolean encodePasswords, String filename) throws BadServerDefinitionException {
        return this.getServerOptions(useAuthDomain, encodePasswords, "", false);
    }

    @Override
    public String getServerOptions(boolean useAuthDomain, boolean encodePasswords, String filename, boolean includeEngine) throws BadServerDefinitionException {
        return "";
    }

    @Override
    public String getHost() {
        String hostname = "";
        IConnection connection = this.getConnection();
        if (connection != null) {
            hostname = connection.getHostName();
        }
        return hostname;
    }

    @Override
    public int getPort() {
        int port = 0;
        IConnection connection = this.getConnection();
        if (connection != null) {
            port = connection.getPort();
        }
        return port;
    }

    @Override
    public String getUserIdPasswordString(boolean useAuthDomain, String userLabel, String passwordLabel) throws BadServerDefinitionException {
        IConnection connection = this.getConnection();
        if (connection == null) {
            throw new BadServerDefinitionException(MessageFormat.format(RB.getStringResource("BaseServer.NoClientConnection.msg.txt"), this.getName()));
        }
        StringBuffer options = new StringBuffer();
        options.append(connection.getUserIdPasswordString(useAuthDomain, true, userLabel, passwordLabel)).append("\n");
        return options.toString();
    }
}

