/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodeSegment;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.other.impl.BaseConnection;
import com.sas.etl.models.other.impl.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASFileRef;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.LibraryUtil;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseSASClientConnection
extends BaseConnection
implements ISASClientConnection {
    private static final String TCP = "TCP";
    private static final String TELNET = "TELNET";
    private String m_hostAddress = "";
    private String m_fileRef = "";
    private String m_scriptFile = "";
    private IServer m_oldServer;

    public BaseSASClientConnection(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getHostAddress() {
        return this.m_hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        if (this.m_hostAddress.equals(hostAddress)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new HostAddressUndoable(this.m_hostAddress, hostAddress));
        }
        this.m_hostAddress = hostAddress;
        this.fireModelChangedEvent("ISASClientConnection:HostAddressChanged", null);
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List<String> lAssociations = (ArrayList<String>)map.get("SASClientConnection");
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            map.put("SASClientConnection", lAssociations);
        }
        lAssociations.add("ScriptFiles");
        lAssociations.add("Domain");
        lAssociations.add("Properties");
        lAssociations.add("PropertySets");
        lAssociations = (List)map.get("TCPIPConnection");
        if (lAssociations == null) {
            lAssociations = new ArrayList();
            map.put("TCPIPConnection", lAssociations);
        }
        lAssociations.add("Domain");
        return map;
    }

    @Override
    public String getOMRType() {
        return "SASClientConnection";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.setChanged(false);
    }

    @Override
    public String getScriptFile() {
        return this.m_scriptFile;
    }

    public void setScriptFile(String scriptFile) {
        if (this.m_scriptFile.equals(scriptFile)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new ScriptFileUndoable(this.m_scriptFile, scriptFile));
        }
        this.m_scriptFile = scriptFile;
        this.fireModelChangedEvent("ISASClientConnection:ScriptFileChanged", null);
    }

    @Override
    public String getSignonOptions() {
        return this.processProperties(Arrays.asList(this.getOptions()));
    }

    @Override
    public String getFileRef() {
        return this.m_fileRef;
    }

    public void setFileRef(String fileRef) {
        if (this.m_fileRef.equals(fileRef)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new FileRefUndoable(this.m_fileRef, fileRef));
        }
        this.m_fileRef = fileRef;
        this.fireModelChangedEvent("ISASClientConnection:FileRefChanged", null);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IProperty prop;
        String service;
        String serverName;
        super.loadFromOMR(omr);
        SASClientConnection mdoSC = (SASClientConnection)omr.acquireOMRObject(this);
        this.setService(mdoSC.getService());
        if (mdoSC.getPort() > 0) {
            this.setPort(mdoSC.getPort());
        } else {
            IProperty portProperty = this.getProperty("PORT");
            if (portProperty != null) {
                try {
                    Integer port = Integer.valueOf(portProperty.getDefaultValue());
                    if (port != null) {
                        this.setPort(port);
                    }
                }
                catch (NumberFormatException port) {
                    // empty catch block
                }
            }
        }
        AssociationList scriptFiles = mdoSC.getScriptFiles();
        if (!scriptFiles.isEmpty()) {
            File iScript = (File)scriptFiles.get(0);
            SASFileRef fileRef = null;
            String sAccessMethod = "";
            String sPath = "";
            String sOptions = "";
            if (iScript != null) {
                AssociationList fileRefs = iScript.getFileRefs();
                if (iScript.getFileName().length() > 0) {
                    sPath = "\"" + iScript.getFileName() + "\" ";
                }
                if (fileRefs.size() > 0) {
                    fileRef = (SASFileRef)fileRefs.get(0);
                    this.setFileRef(fileRef.getFileref() + " ");
                    sAccessMethod = fileRef.getAccessMethod() + " ";
                    sOptions = this.processProperties((List<IProperty>)fileRef.getProperties());
                } else {
                    this.m_fileRef = "RLINK ";
                    this.setFileRef("RLINK ");
                }
            }
            this.setScriptFile("filename " + this.m_fileRef + sAccessMethod + sPath + sOptions);
        }
        if ((serverName = mdoSC.getServerShortName()) == null || serverName.length() == 0) {
            String id = mdoSC.getId();
            if (id.indexOf(46) > -1) {
                this.setHostName(id.substring(id.indexOf(46) + 1));
            }
        } else {
            this.setHostName(serverName);
        }
        this.setHostAddress(mdoSC.getRemoteAddress());
        String commProtocol = this.getCommunicationProtocol();
        if (!TCP.equalsIgnoreCase(commProtocol) && !TELNET.equalsIgnoreCase(commProtocol)) {
            this.setHostName("&" + this.getHostName());
        }
        if ((service = this.getService()) == null) {
            service = "";
        }
        this.setService(service);
        if ("CASPROTOCOL".equals(mdoSC.getApplicationProtocol()) && (prop = this.getProperty("SERVER")) != null) {
            this.setHostName(prop.getDefaultValue());
        }
        this.setChanged(false);
    }

    private String processProperties(List<IProperty> lProps) {
        String retStr = "";
        for (IProperty iProp : lProps) {
            if (iProp.getPropertyName().equalsIgnoreCase("PROMPT") || iProp.getPropertyName().equalsIgnoreCase("NOPROMPT")) continue;
            if (iProp.getUseValueOnly()) {
                retStr = retStr + iProp.getDefaultValue() + " ";
                continue;
            }
            if (iProp.getDefaultValue() == null || iProp.getDefaultValue().length() == 0) continue;
            retStr = retStr + " " + iProp.getPropertyName() + iProp.getDelimiter() + iProp.getDefaultValue() + " ";
        }
        return retStr;
    }

    @Override
    public ICodeSegment genAccessCode(ICodeSegment codeSegment) throws BadServerDefinitionException {
        return codeSegment.addSourceCode(this.getAccessCode(codeSegment.getCodeGenerationEnvironment()));
    }

    @Override
    public StringBuffer getAccessCode(ICodeGenerationEnvironment environment) throws BadServerDefinitionException {
        String fileRef;
        String comamid;
        CodeSegment codeSegment = new CodeSegment(environment, this);
        if (this.getHostName() == null || this.getHostName().length() == 0) {
            throw new BadServerDefinitionException(MessageFormat.format(RB.getStringResource("BaseSASClientConnection.BadHostName.txt"), this.getName()));
        }
        boolean scripted = false;
        String scriptFile = this.getScriptFile();
        if (scriptFile != null && scriptFile.length() > 0) {
            scripted = true;
        }
        if ((comamid = this.getCommunicationProtocol()) != null && comamid != "") {
            codeSegment.addSourceCode("options comamid=" + comamid + ";\n");
        }
        codeSegment.addSourceCode("%let ").addSourceCode(this.getHostName()).addSourceCode(" = ").addSourceCode(this.getHostAddress());
        int port = this.getPort();
        if (!scripted) {
            String service = this.getService();
            if (service != null && service.length() > 0) {
                codeSegment.addSourceCode(" ").addSourceCode(service);
            } else if (port > 0) {
                codeSegment.addSourceCode(" ").addSourceCode(Integer.toString(port));
            }
        }
        codeSegment.addSourceCode(";\n");
        if (scripted) {
            codeSegment.addSourceCode(this.getScriptFile()).addSourceCode(";\n");
        }
        codeSegment.addSourceCode("data _null_; \n");
        codeSegment.indent().addSourceCode("signon ").addSourceCode(this.getHostName()).addSourceCode(" ").addSourceCode(this.getSignonOptions()).unIndent();
        String userId = this.getUserid();
        String password = this.getPassword();
        if (!scripted) {
            if (!LibraryUtil.isApplicationUsingAuthDomainForPasswords()) {
                if (userId != null && userId.length() > 0) {
                    String tmpPwString;
                    try {
                        tmpPwString = SasPasswordString.encode((String)"sas002", (String)password);
                    }
                    catch (SasPasswordEncodingException e) {
                        tmpPwString = password;
                    }
                    codeSegment.addSourceCode(" user=\"").addSourceCode(userId).addSourceCode("\" password=\"").addSourceCode(tmpPwString).addSourceCode("\"");
                }
            } else {
                codeSegment.addSourceCode(" AuthDomain=\"").addSourceCode(this.getAuthDomain()).addSourceCode("\"");
            }
        }
        if ((fileRef = this.getFileRef()) != null && fileRef.length() > 0) {
            codeSegment.addSourceCode(" script=").addSourceCode(fileRef.trim());
        } else {
            codeSegment.addSourceCode(" noscript");
        }
        codeSegment.addSourceCode(";\n");
        codeSegment.addSourceCode("run; \n");
        return codeSegment.getGeneratedCode();
    }

    @Override
    public ICodeSegment genEndSubmit(ICodeSegment codeSegment) {
        return this.genEndSubmit(codeSegment, false);
    }

    @Override
    public ICodeSegment genEndSubmit(ICodeSegment codeSegment, boolean isRCSetSYSCCEnabled) {
        codeSegment.addSourceCode("endrsubmit; /* " + this.getName() + " */  \n\n");
        if (isRCSetSYSCCEnabled) {
            codeSegment.genRCSetCall("&di_syscc", true);
        }
        ICodeGenerationEnvironment enviroment = codeSegment.getCodeGenerationEnvironment();
        enviroment.setCurrentServer(this.m_oldServer);
        enviroment.removeRemoteSession();
        return codeSegment;
    }

    @Override
    public ICodeSegment genStartSubmit(String additionalRsubmitOptions, ICodeSegment codeSegment, boolean generateStatusMacros, boolean generatePerformanceStats, boolean generatePerformanceTableStats) {
        ICodeGenerationEnvironment enviroment = codeSegment.getCodeGenerationEnvironment();
        codeSegment.addSourceCode("rsubmit ").addSourceCode(this.getHostName());
        if (additionalRsubmitOptions != null && additionalRsubmitOptions.length() > 0) {
            codeSegment.addSourceCode(" ").addSourceCode(additionalRsubmitOptions);
        }
        codeSegment.addSourceCode(" ; /* ").addSourceCode(this.getName()).addSourceCode(" */ \n");
        if (enviroment == null || !enviroment.isOnRemoteSubmitCache(this)) {
            if (generateStatusMacros) {
                codeSegment.indent().genRCSetMacro().unIndent();
            }
            if (generatePerformanceStats || generatePerformanceTableStats) {
                codeSegment.indent().genInitPerformanceStatistics(this.getServer().getServerContext(), generatePerformanceTableStats).unIndent();
            }
            enviroment.addToRemoteSubmitCache(this);
        }
        this.m_oldServer = enviroment.getCurrentServer();
        enviroment.addRemoteSession(this.getServer());
        enviroment.setCurrentServer(this.getServer());
        return codeSegment;
    }

    private class FileRefUndoable
    extends AbstractUndoableEdit {
        private String m_FileRefOld;
        private String m_FileRefNew;

        public FileRefUndoable(String FileRefOld, String FileRefNew) {
            this.m_FileRefOld = FileRefOld;
            this.m_FileRefNew = FileRefNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseSASClientConnection.this.setFileRef(this.m_FileRefOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseSASClientConnection.this.setFileRef(this.m_FileRefNew);
        }
    }

    private class HostAddressUndoable
    extends AbstractUndoableEdit {
        private String m_HostAddressOld;
        private String m_HostAddressNew;

        public HostAddressUndoable(String HostAddressOld, String HostAddressNew) {
            this.m_HostAddressOld = HostAddressOld;
            this.m_HostAddressNew = HostAddressNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseSASClientConnection.this.setHostAddress(this.m_HostAddressOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseSASClientConnection.this.setHostAddress(this.m_HostAddressNew);
        }
    }

    private class ScriptFileUndoable
    extends AbstractUndoableEdit {
        private String m_ScriptFileOld;
        private String m_ScriptFileNew;

        public ScriptFileUndoable(String ScriptFileOld, String ScriptFileNew) {
            this.m_ScriptFileOld = ScriptFileOld;
            this.m_ScriptFileNew = ScriptFileNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseSASClientConnection.this.setScriptFile(this.m_ScriptFileOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseSASClientConnection.this.setScriptFile(this.m_ScriptFileNew);
        }
    }
}

