/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseProperty
extends AbstractPersistableObject
implements IProperty {
    private String m_sDefaultValue = "";
    private String m_sDelimiter = "=";
    private String m_sPropertyName = "";
    private String m_sPropertyRole = "";
    private boolean m_bUseValueOnly = false;
    private ITextOperand m_oTextOperand = null;
    private boolean m_bTranslateName = true;

    public BaseProperty(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getDefaultValue() {
        return this.m_sDefaultValue;
    }

    @Override
    public String getDelimiter() {
        return this.m_sDelimiter;
    }

    @Override
    public String getPropertyName() {
        return this.m_sPropertyName;
    }

    @Override
    public boolean isTranslateName() {
        return this.m_bTranslateName;
    }

    @Override
    public void setTranslateName(boolean bTranslate) {
        this.m_bTranslateName = bTranslate;
    }

    @Override
    public String getPropertyRole() {
        return this.m_sPropertyRole;
    }

    @Override
    public boolean getUseValueOnly() {
        return this.m_bUseValueOnly;
    }

    @Override
    public void setExpression(ITextOperand oValue) {
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetExpressionUndoable(this.m_oTextOperand, oValue));
            }
            this.m_oTextOperand = oValue;
            this.fireModelChangedEvent("Property:ExpressionChanged", null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public ITextOperand getExpression() {
        return this.m_oTextOperand;
    }

    @Override
    public void setDefaultValue(String sValue) {
        if (sValue == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (sValue.equals(this.m_sDefaultValue)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDefaultValueUndoable(this.m_sDefaultValue, sValue));
        }
        this.m_sDefaultValue = sValue;
        this.fireModelChangedEvent("Property:DefaultValue", null);
    }

    @Override
    public void setDelimiter(String sValue) {
        if (sValue == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (sValue.equals(this.m_sDelimiter)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDelimiterUndoable(this.m_sDelimiter, sValue));
        }
        this.m_sDelimiter = sValue;
        this.fireModelChangedEvent("Property:Delimiter", null);
    }

    @Override
    public void setPropertyName(String sValue) {
        if (sValue == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (sValue.equals(this.m_sPropertyName)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPropertyNameUndoable(this.m_sPropertyName, sValue));
        }
        this.m_sPropertyName = sValue;
        this.fireModelChangedEvent("Property:PropertyName", null);
    }

    @Override
    public void setPropertyRole(String sValue) {
        if (sValue == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (sValue.equals(this.m_sPropertyRole)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPropertyRoleUndoable(this.m_sPropertyRole, sValue));
        }
        this.m_sPropertyRole = sValue;
        this.fireModelChangedEvent("Property:PropertyRole", null);
    }

    @Override
    public void setUseValueOnly(boolean bValue) {
        if (bValue == this.m_bUseValueOnly) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseValueOnlyUndoable(this.m_bUseValueOnly, bValue));
        }
        this.m_bUseValueOnly = bValue;
        this.fireModelChangedEvent("Property:UseValueOnly", null);
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_oTextOperand != null && this.m_oTextOperand.isChanged();
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Property mdoProperty = (Property)omr.acquireOMRObject(this);
        this.setDefaultValue(mdoProperty.getDefaultValue());
        this.setPropertyRole(mdoProperty.getPropertyRole());
        this.setPropertyName(mdoProperty.getPropertyName());
        this.setDelimiter(mdoProperty.getDelimiter());
        int iUseValueOnly = mdoProperty.getUseValueOnly();
        if (iUseValueOnly == 0) {
            this.setUseValueOnly(false);
        } else {
            this.setUseValueOnly(true);
        }
        if (mdoProperty.getPropertyName().equalsIgnoreCase("Value") && mdoProperty.getPropertyRole().equalsIgnoreCase("parameter") && mdoProperty.getSpecTargetTransformations().size() > 0) {
            FeatureMap fm = (FeatureMap)mdoProperty.getSpecTargetTransformations().get(0);
            ITextOperand oOperand = this.getModel().getObjectFactory().createTextOperand(fm.getFQID());
            omr.populateFor(oOperand);
            oOperand.loadFromOMR(omr);
            this.m_oTextOperand = oOperand;
        }
        this.setChanged(false);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get("Property");
        lAssociations.add("Properties");
        lAssociations.add("PropertySets");
        lAssociations.add("CustomAssociations");
        return map;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Property mdoProperty = (Property)omr.acquireOMRObject(this);
        mdoProperty.setDefaultValue(this.m_sDefaultValue);
        mdoProperty.setPropertyRole(this.m_sPropertyRole);
        mdoProperty.setPropertyName(this.m_sPropertyName);
        if (this.m_bUseValueOnly) {
            mdoProperty.setUseValueOnly(1);
        } else {
            mdoProperty.setUseValueOnlyState(0);
        }
        if (this.m_oTextOperand != null) {
            FeatureMap fm = (FeatureMap)omr.acquireOMRObject(this.m_oTextOperand);
            mdoProperty.getSpecTargetTransformations().clear();
            mdoProperty.getSpecTargetTransformations().add((Object)fm);
            this.m_oTextOperand.saveToOMR(omr);
        }
    }

    @Override
    public String getOMRType() {
        return "Property";
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_oTextOperand != null) {
            this.m_oTextOperand.updateIDs(mapIDs);
        }
    }

    @Override
    public void copy(IProperty property) {
        this.startCompoundUndoable();
        try {
            property.setName(this.getName());
            property.setDefaultValue(this.getDefaultValue());
            property.setDelimiter(this.getDelimiter());
            property.setDescription(this.getDescription());
            property.setPropertyName(this.getPropertyName());
            property.setPropertyRole(this.getPropertyRole());
            property.setUseValueOnly(this.getUseValueOnly());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private class SetUseValueOnlyUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetUseValueOnlyUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseProperty.this.setUseValueOnly(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseProperty.this.setUseValueOnly(this.m_newValue);
        }
    }

    private class SetPropertyRoleUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetPropertyRoleUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseProperty.this.setPropertyRole(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseProperty.this.setPropertyRole(this.m_newValue);
        }
    }

    private class SetPropertyNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetPropertyNameUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseProperty.this.setPropertyName(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseProperty.this.setPropertyName(this.m_newValue);
        }
    }

    private class SetDelimiterUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetDelimiterUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseProperty.this.setDelimiter(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseProperty.this.setDelimiter(this.m_newValue);
        }
    }

    private class SetExpressionUndoable
    extends AbstractUndoableEdit {
        private ITextOperand m_oldValue;
        private ITextOperand m_newValue;

        public SetExpressionUndoable(ITextOperand oldValue, ITextOperand newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseProperty.this.setExpression(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseProperty.this.setExpression(this.m_newValue);
        }
    }

    private class SetDefaultValueUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetDefaultValueUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseProperty.this.setDefaultValue(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseProperty.this.setDefaultValue(this.m_newValue);
        }
    }
}

