/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IHTTPTCPIPConnection;
import com.sas.etl.models.other.impl.BaseTCPIPConnection;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseHTTPTCPIPConnection
extends BaseTCPIPConnection
implements IHTTPTCPIPConnection {
    private static final String PROXY_URL_PROPERTY_NAME = "ProxyURL";
    private String m_httpServerProxy = "";

    public BaseHTTPTCPIPConnection(String sID, IModel model) {
        super(sID, model);
    }

    public void setHTTPServerProxy(String serverProxy) {
        if (this.m_httpServerProxy.equals(serverProxy)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new HTTPServerProxyUndoable(this.m_httpServerProxy, serverProxy));
        }
        this.m_httpServerProxy = serverProxy;
        this.fireModelChangedEvent("IHTTPTCPIPConnection:HTTPServerProxyChanged", null);
    }

    @Override
    public String getHTTPServerProxy() {
        return this.m_httpServerProxy;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setHTTPServerProxy(this.loadPropertyFromOMR(omr, "", PROXY_URL_PROPERTY_NAME, "", 1));
        this.setChanged(false);
    }

    private class HTTPServerProxyUndoable
    extends AbstractUndoableEdit {
        private String m_HTTPServerProxyOld;
        private String m_HTTPServerProxyNew;

        public HTTPServerProxyUndoable(String HTTPServerProxyOld, String HTTPServerProxyNew) {
            this.m_HTTPServerProxyOld = HTTPServerProxyOld;
            this.m_HTTPServerProxyNew = HTTPServerProxyNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseHTTPTCPIPConnection.this.setHTTPServerProxy(this.m_HTTPServerProxyOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseHTTPTCPIPConnection.this.setHTTPServerProxy(this.m_HTTPServerProxyNew);
        }
    }
}

