/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IConnection;
import com.sas.etl.models.other.IFTPServer;
import com.sas.etl.models.other.ITCPIPConnection;
import com.sas.etl.models.other.impl.BaseServer;
import com.sas.etl.models.other.impl.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import java.rmi.RemoteException;
import java.text.MessageFormat;

public class BaseFTPServer
extends BaseServer
implements IFTPServer {
    public BaseFTPServer(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getOMRType() {
        return "ServerComponent";
    }

    @Override
    public String getProductName() {
        return "Ftp Server";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    protected void loadClientConnections(OMRAdapter omr) throws MdException, RemoteException {
        ServerComponent mdoSC = (ServerComponent)omr.acquireOMRObject(this);
        this.clearClientConnections();
        AssociationList sourceConnections = mdoSC.getSourceConnections();
        if (!sourceConnections.isEmpty()) {
            TCPIPConnection comp = (TCPIPConnection)sourceConnections.get(0);
            ITCPIPConnection connection = (ITCPIPConnection)omr.acquireObject((Root)comp);
            this.addClientConnection(connection);
        }
    }

    @Override
    public String getServerOptions(boolean useAuthDomain, boolean encodePasswords, String fileName) throws BadServerDefinitionException {
        return this.getServerOptions(useAuthDomain, encodePasswords, fileName, true);
    }

    @Override
    public String getServerOptions(boolean useAuthDomain, boolean encodePasswords, String filename, boolean includeEngine) throws BadServerDefinitionException {
        IConnection connection = this.getConnection();
        if (connection == null) {
            throw new BadServerDefinitionException(MessageFormat.format(RB.getStringResource("BaseServer.NoClientConnection.msg.txt"), this.getName()));
        }
        StringBuffer options = new StringBuffer();
        if (includeEngine) {
            options.append("ftp");
        }
        options.append(" host='").append(connection.getHostName()).append("' port=").append(connection.getPort());
        options.append(connection.getUserIdPasswordString(useAuthDomain, encodePasswords));
        return options.toString();
    }

    @Override
    public String getAccessMethodNickName() {
        return "FTP";
    }

    @Override
    public String getAccessMethodFilePath(String filename) throws BadServerDefinitionException {
        return filename;
    }

    @Override
    public String getDirectoryListingOption() {
        return "dir";
    }
}

