/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IExtendedAttribute;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseExtendedAttribute
extends AbstractPersistableObject
implements IExtendedAttribute {
    private String m_sValue = "";

    public BaseExtendedAttribute(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getValue() {
        return this.m_sValue;
    }

    @Override
    public void setValue(String sValue) {
        if (sValue == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (sValue.equals(this.m_sValue)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetValueUndoable(this.m_sValue, sValue));
        }
        this.m_sValue = sValue;
        this.fireModelChangedEvent("ExtendedAttribute:Value", null);
    }

    @Override
    public void copy(IExtendedAttribute attr) {
        this.startCompoundUndoable();
        try {
            attr.setName(this.getName());
            attr.setDescription(this.getDescription());
            attr.setValue(this.getValue());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Extension mdoEA = (Extension)omr.acquireOMRObject(this);
        this.setValue(mdoEA.getValue());
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Extension mdoEA = (Extension)omr.acquireOMRObject(this);
        mdoEA.setValue(this.m_sValue);
    }

    @Override
    public String getOMRType() {
        return "Extension";
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    private class SetValueUndoable
    extends AbstractUndoableEdit {
        private String m_oldValue;
        private String m_newValue;

        public SetValueUndoable(String oldValue, String newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            BaseExtendedAttribute.this.setValue(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            BaseExtendedAttribute.this.setValue(this.m_newValue);
        }
    }
}

