/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.other.IConnection;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.Workspace;
import com.sas.workspace.connection.ConnectionManager;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseConnection
extends AbstractPersistableObject
implements IConnection {
    private String m_applicationProtocol = "";
    private String m_authenticationType = "";
    private String m_communicationProtocol = "";
    private String m_userid = "";
    private String m_password = "";
    private String m_hostName = "";
    private int m_port = -1;
    private String m_service = "";
    private IServer m_server;
    private String m_authDomain;
    private List m_options = new ArrayList();
    private Map<String, List<IProperty>> m_propertySetProperties = new HashMap<String, List<IProperty>>();

    public BaseConnection(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void setServer(IServer server) {
        if (this.m_server == server) {
            return;
        }
        this.m_server = server;
    }

    @Override
    public IServer getServer() {
        return this.m_server;
    }

    @Override
    public String getUserid() {
        return this.m_userid;
    }

    public void setUserId(String userid) {
        if (this.m_userid.equals(userid)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new UserIdUndoable(this.m_userid, userid));
        }
        this.m_userid = userid;
        this.fireModelChangedEvent("IConnection:UserIDChanged", null);
    }

    @Override
    public String getPassword() {
        return this.m_password;
    }

    @Override
    public String getAuthDomain() {
        return this.m_authDomain;
    }

    public void setAuthDomain(String domain) {
        if (ObjectComparator.isEqual(this.m_authDomain, domain)) {
            return;
        }
        this.m_authDomain = domain;
    }

    public void setPassword(String password) {
        if (this.m_password.equals(password)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new PasswordUndoable(this.m_password, password));
        }
        this.m_password = password;
        this.fireModelChangedEvent("IConnection:PasswordChanged", null);
    }

    @Override
    public String getEncodedPassword() {
        String password = this.getPassword();
        try {
            password = SasPasswordString.encode((String)"sas002", (String)password);
        }
        catch (SasPasswordEncodingException sasPasswordEncodingException) {
            // empty catch block
        }
        return password;
    }

    @Override
    public String getApplicationProtocol() {
        return this.m_applicationProtocol;
    }

    @Override
    public void setApplicationProtocol(String applicationProtocol) {
        if (this.m_applicationProtocol.equals(applicationProtocol)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new ApplicationProtocolUndoable(this.m_applicationProtocol, applicationProtocol));
        }
        this.m_applicationProtocol = applicationProtocol;
        this.fireModelChangedEvent("IConnection:ApplicationProtocolChanged", null);
    }

    @Override
    public String getAuthenticationType() {
        return this.m_authenticationType;
    }

    @Override
    public void setAuthenticationType(String authenticationType) {
        if (this.m_authenticationType.equals(authenticationType)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AuthenticationTypeUndoable(this.m_authenticationType, authenticationType));
        }
        this.m_authenticationType = authenticationType;
        this.fireModelChangedEvent("IConnection:AuthenticationTypeChanged", null);
    }

    @Override
    public String getCommunicationProtocol() {
        return this.m_communicationProtocol;
    }

    @Override
    public void setCommunicationProtocol(String communicationProtocol) {
        if (this.m_communicationProtocol.equals(communicationProtocol)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new CommunicationProtocolUndoable(this.m_communicationProtocol, communicationProtocol));
        }
        this.m_communicationProtocol = communicationProtocol;
        this.fireModelChangedEvent("IConnection:CommunicationProtocolChanged", null);
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        if (port == this.m_port) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new PortUndoable(this.m_port, port));
        }
        this.m_port = port;
        this.fireModelChangedEvent("IConnection:PortChanged", null);
    }

    @Override
    public String getHostName() {
        return this.m_hostName;
    }

    @Override
    public void setHostName(String hostName) {
        if (this.m_hostName.equals(hostName)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new HostNameUndoable(this.m_hostName, hostName));
        }
        this.m_hostName = hostName;
        this.fireModelChangedEvent("IConnection:HostNameChanged", null);
    }

    @Override
    public String getService() {
        return this.m_service;
    }

    public void setService(String service) {
        if (this.m_service.equals(service)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new ServiceUndoable(this.m_service, service));
        }
        this.m_service = service;
        this.fireModelChangedEvent("IConnection:ServiceChanged", null);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Connection mdoSC = (Connection)omr.acquireOMRObject(this);
        mdoSC.setCommunicationProtocol(this.getCommunicationProtocol());
        mdoSC.setAuthenticationType(this.getAuthenticationType());
        mdoSC.setApplicationProtocol(this.getApplicationProtocol());
        this.setChanged(false);
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "Connection";
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Connection mdoSC = (Connection)omr.acquireOMRObject(this);
        this.m_applicationProtocol = mdoSC.getApplicationProtocol();
        this.m_authenticationType = mdoSC.getAuthenticationType();
        this.m_communicationProtocol = mdoSC.getCommunicationProtocol();
        AuthenticationDomain dom = mdoSC.getDomain();
        if (dom != null) {
            ConnectionManager cManager = Workspace.getWorkspace().getConnectionManager();
            PasswordAuthentication pw = cManager.getLogin(dom.getName());
            if (pw != null) {
                this.setUserId(pw.getUserName());
                this.setPassword(new String(pw.getPassword()));
            }
            this.setAuthDomain(dom.getName());
        }
        this.m_options.clear();
        AssociationList connectionOptions = mdoSC.getProperties();
        int sizeCOptions = connectionOptions.size();
        for (int i = 0; i < sizeCOptions; ++i) {
            Property prop = (Property)connectionOptions.get(i);
            IPersistableObject p = (IPersistableObject)omr.acquireObject((Root)prop);
            this.m_options.add(p);
        }
        this.m_propertySetProperties.clear();
        AssociationList propertySets = mdoSC.getPropertySets();
        for (PropertySet pSet : propertySets.toArray(new PropertySet[propertySets.size()])) {
            String name = pSet.getPropertySetName();
            ArrayList<IProperty> lst = new ArrayList<IProperty>();
            for (Property prop : (Property[])pSet.getSetProperties().toArray((Object[])new Property[pSet.getSetProperties().size()])) {
                IProperty p = (IProperty)omr.acquireObject((Root)prop);
                lst.add(p);
            }
            this.m_propertySetProperties.put(name, lst);
        }
    }

    @Override
    public IProperty findPropertyInPropertySet(String propertySetName, String propertyName) {
        if (!this.m_propertySetProperties.containsKey(propertySetName)) {
            return null;
        }
        List<IProperty> lst = this.m_propertySetProperties.get(propertySetName);
        for (IProperty property : lst) {
            if (!property.getPropertyName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    @Override
    public IProperty[] getPropertiesInPropertySet(String propertySetName) {
        if (!this.m_propertySetProperties.containsKey(propertySetName)) {
            return null;
        }
        List<IProperty> lst = this.m_propertySetProperties.get(propertySetName);
        if (lst == null) {
            return null;
        }
        return lst.toArray(new IProperty[lst.size()]);
    }

    @Override
    public List getOptionsList() {
        return this.m_options;
    }

    @Override
    public IProperty[] getOptions() {
        return this.getOptionsList().toArray(new IProperty[this.getOptionsList().size()]);
    }

    @Override
    public IProperty getProperty(String propertyName) {
        IProperty[] props = this.getOptions();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getPropertyName().equals(propertyName)) continue;
            return props[i];
        }
        return null;
    }

    protected boolean isEncodingPasswords() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("Workspace.EncodePasswords", false);
    }

    @Override
    public String getUserIdPasswordString(boolean useAuthDomain, boolean encodePasswords) {
        return this.getUserIdPasswordString(useAuthDomain, encodePasswords, "user", "pass");
    }

    @Override
    public String getUserIdPasswordString(boolean useAuthDomain, boolean encodePasswords, String userLabel, String passwordLabel) {
        String sAuthType = this.getAuthenticationType();
        if (sAuthType != null && sAuthType.equalsIgnoreCase("none")) {
            return "";
        }
        StringBuffer options = new StringBuffer();
        if (!useAuthDomain) {
            String userid = this.getUserid();
            if (userid.length() > 0) {
                options.append(" ").append(userLabel).append("='").append(this.getUserid()).append("' ").append(passwordLabel).append("='").append(encodePasswords ? this.getEncodedPassword() : this.getPassword()).append("'");
            }
        } else {
            String authDomain = this.getAuthDomain();
            if (authDomain != null && authDomain.length() > 0) {
                options.append(" AuthDomain=\"").append(authDomain).append("\"");
            }
        }
        return options.toString();
    }

    private class PortUndoable
    extends AbstractUndoableEdit {
        private int m_PortOld;
        private int m_PortNew;

        public PortUndoable(int PortOld, int PortNew) {
            this.m_PortOld = PortOld;
            this.m_PortNew = PortNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseConnection.this.setPort(this.m_PortOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseConnection.this.setPort(this.m_PortNew);
        }
    }

    private class ServiceUndoable
    extends AbstractUndoableEdit {
        private String m_ServiceOld;
        private String m_ServiceNew;

        public ServiceUndoable(String ServiceOld, String ServiceNew) {
            this.m_ServiceOld = ServiceOld;
            this.m_ServiceNew = ServiceNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseConnection.this.setService(this.m_ServiceOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseConnection.this.setService(this.m_ServiceNew);
        }
    }

    private class HostNameUndoable
    extends AbstractUndoableEdit {
        private String m_HostNameOld;
        private String m_HostNameNew;

        public HostNameUndoable(String HostNameOld, String HostNameNew) {
            this.m_HostNameOld = HostNameOld;
            this.m_HostNameNew = HostNameNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseConnection.this.setHostName(this.m_HostNameOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseConnection.this.setHostName(this.m_HostNameNew);
        }
    }

    private class AuthenticationTypeUndoable
    extends AbstractUndoableEdit {
        private String m_AuthenticationTypeOld;
        private String m_AuthenticationTypeNew;

        public AuthenticationTypeUndoable(String AuthenticationTypeOld, String AuthenticationTypeNew) {
            this.m_AuthenticationTypeOld = AuthenticationTypeOld;
            this.m_AuthenticationTypeNew = AuthenticationTypeNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseConnection.this.setAuthenticationType(this.m_AuthenticationTypeOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseConnection.this.setAuthenticationType(this.m_AuthenticationTypeNew);
        }
    }

    private class CommunicationProtocolUndoable
    extends AbstractUndoableEdit {
        private String m_CommunicationProtocolOld;
        private String m_CommunicationProtocolNew;

        public CommunicationProtocolUndoable(String CommunicationProtocolOld, String CommunicationProtocolNew) {
            this.m_CommunicationProtocolOld = CommunicationProtocolOld;
            this.m_CommunicationProtocolNew = CommunicationProtocolNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseConnection.this.setCommunicationProtocol(this.m_CommunicationProtocolOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseConnection.this.setCommunicationProtocol(this.m_CommunicationProtocolNew);
        }
    }

    private class ApplicationProtocolUndoable
    extends AbstractUndoableEdit {
        private String m_ApplicationProtocolOld;
        private String m_ApplicationProtocolNew;

        public ApplicationProtocolUndoable(String ApplicationProtocolOld, String ApplicationProtocolNew) {
            this.m_ApplicationProtocolOld = ApplicationProtocolOld;
            this.m_ApplicationProtocolNew = ApplicationProtocolNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseConnection.this.setApplicationProtocol(this.m_ApplicationProtocolOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseConnection.this.setApplicationProtocol(this.m_ApplicationProtocolNew);
        }
    }

    private class PasswordUndoable
    extends AbstractUndoableEdit {
        private String m_PasswordOld;
        private String m_PasswordNew;

        public PasswordUndoable(String PasswordOld, String PasswordNew) {
            this.m_PasswordOld = PasswordOld;
            this.m_PasswordNew = PasswordNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseConnection.this.setPassword(this.m_PasswordOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseConnection.this.setPassword(this.m_PasswordNew);
        }
    }

    private class UserIdUndoable
    extends AbstractUndoableEdit {
        private String m_UserIdOld;
        private String m_UserIdNew;

        public UserIdUndoable(String UserIdOld, String UserIdNew) {
            this.m_UserIdOld = UserIdOld;
            this.m_UserIdNew = UserIdNew;
        }

        @Override
        public void undo() {
            super.undo();
            BaseConnection.this.setUserId(this.m_UserIdOld);
        }

        @Override
        public void redo() {
            super.redo();
            BaseConnection.this.setUserId(this.m_UserIdNew);
        }
    }
}

