/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.impl.AbstractConditionAction;
import com.sas.metadata.remote.Action;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import java.rmi.RemoteException;

public class BaseConditionActionTemplate
extends AbstractConditionAction {
    public BaseConditionActionTemplate(String sID, IModel model, String sType) {
        super(sID, model, sType);
    }

    public BaseConditionActionTemplate(String sID, IModel model, String sType, IConditionActionSet owningSet) {
        this(sID, model, sType);
        this.setConditionActionSet(owningSet);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Action mdoAction = (Action)omr.acquireOMRObject(this);
        this.setActionType(mdoAction.getActionType());
        this.setInstanceVersion(mdoAction.getInstanceVersion());
        this.setUniqueIdentifier(mdoAction.getUniqueIdentifier());
        AssociationList sets = mdoAction.getPropertySets();
        for (int i = 0; i < sets.size(); ++i) {
            PropertySet set = (PropertySet)sets.get(i);
            if (!set.getSetRole().equalsIgnoreCase("ActionOptions")) continue;
            AssociationList properties = set.getSetProperties();
            for (int j = 0; j < set.getSetProperties().size(); ++j) {
                Property property = (Property)properties.get(j);
                IProperty oProperty = this.getModel().getObjectFactory().createActionProperty(property.getId());
                oProperty.setName(property.getName());
                oProperty.setDefaultValue(property.getDefaultValue());
                oProperty.setDescription(property.getDesc());
                oProperty.setPropertyName(property.getPropertyName());
                oProperty.setPropertyRole(property.getPropertyRole());
                oProperty.setDelimiter(property.getDelimiter());
                oProperty.setUseValueOnly(property.getUseValueOnly() != 1);
                this.m_actionProperties.add(oProperty);
            }
            break;
        }
        if (this.getUniqueIdentifier().equals("DIS_SENDEVENT")) {
            this.loadEventPropertyTemplateFromOMR(omr);
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.saveToOMR(omr);
        this.setChanged(false);
    }
}

