/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.impl.AbstractConditionAction;
import com.sas.metadata.remote.Action;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ConditionActionSet;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import java.rmi.RemoteException;
import java.util.List;

public class BaseConditionActionInstance
extends AbstractConditionAction {
    private static final String ACTION_OPTIONS_PROPERTYSET_NAME = "ActionOptions";

    public BaseConditionActionInstance(String sID, IModel model, String sType, IConditionActionSet owningSet) {
        super(sID, model, sType);
        this.m_owningSet = owningSet;
    }

    public BaseConditionActionInstance(String sID, IModel model, IConditionAction templateAction, String sContainerID) {
        super(sID, model);
        this.m_sActionType = templateAction.getActionType();
        this.m_iInstanceVersion = templateAction.getInstanceVersion();
        this.m_sUniqueIdentifier = templateAction.getUniqueIdentifier();
        List templateProperties = templateAction.getActionPropertiesList();
        for (int i = 0; i < templateProperties.size(); ++i) {
            IProperty templateProperty = (IProperty)templateProperties.get(i);
            IProperty newProperty = model.getObjectFactory().createNewActionProperty(model.createIDForNewObject(sContainerID));
            newProperty.setTranslateName(templateProperty.isTranslateName());
            newProperty.setName(templateProperty.getName());
            newProperty.setDefaultValue(templateProperty.getDefaultValue());
            newProperty.setDescription(templateProperty.getDescription());
            newProperty.setDelimiter(templateProperty.getDelimiter());
            newProperty.setPropertyName(templateProperty.getPropertyName());
            newProperty.setPropertyRole(templateProperty.getPropertyRole());
            newProperty.setUseValueOnly(templateProperty.getUseValueOnly());
            this.m_actionProperties.add(newProperty);
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Action mdoAction = (Action)omr.acquireOMRObject(this);
        if (mdoAction.getActionType() != null && mdoAction.getActionType().length() > 0) {
            this.setActionType(mdoAction.getActionType());
        }
        this.setInstanceVersion(mdoAction.getInstanceVersion());
        if (mdoAction.getUniqueIdentifier() != null && mdoAction.getUniqueIdentifier().length() > 0) {
            this.setUniqueIdentifier(mdoAction.getUniqueIdentifier());
        }
        boolean bIsSetTargetColToValueAction = false;
        if (mdoAction.getUniqueIdentifier().equalsIgnoreCase("DIS_SETTARGETCOL")) {
            bIsSetTargetColToValueAction = true;
        }
        this.m_actionProperties.clear();
        AssociationList sets = mdoAction.getPropertySets();
        for (int i = 0; i < sets.size(); ++i) {
            PropertySet set = (PropertySet)sets.get(i);
            if (!set.getSetRole().equalsIgnoreCase(ACTION_OPTIONS_PROPERTYSET_NAME)) continue;
            AssociationList properties = set.getSetProperties();
            for (int j = 0; j < set.getSetProperties().size(); ++j) {
                Property property = (Property)properties.get(j);
                IProperty oProperty = this.getModel().getObjectFactory().createActionProperty(property.getId());
                omr.populateFor(oProperty);
                oProperty.loadFromOMR(omr);
                if (this.getUniqueIdentifier().equals("DIS_SENDEVENT")) {
                    oProperty.setTranslateName(false);
                }
                this.m_actionProperties.add(oProperty);
            }
            break;
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.saveToOMR(omr);
        Action mdo = (Action)omr.acquireOMRObject(this);
        mdo.setActionType(this.getActionType());
        mdo.setInstanceVersion(this.m_iInstanceVersion);
        mdo.setUniqueIdentifier(this.getUniqueIdentifier());
        mdo.setPublicType(this.getPublicType());
        mdo.setUsageVersion(1000000.0);
        ConditionActionSet owningSet = (ConditionActionSet)omr.acquireOMRObject(this.m_owningSet);
        mdo.getConditionActionSets().removeAllElements();
        mdo.getConditionActionSets().add((Object)owningSet);
        PropertySet mdoPropertySet = this.findPropertySet(omr, omr.acquireOMRObject(this), ACTION_OPTIONS_PROPERTYSET_NAME, 0);
        if (mdoPropertySet == null) {
            mdoPropertySet = this.acquirePropertySet(omr, omr.acquireOMRObject(this), ACTION_OPTIONS_PROPERTYSET_NAME);
        }
        for (int j = 0; j < this.m_actionProperties.size(); ++j) {
            IProperty property = (IProperty)this.m_actionProperties.get(j);
            Property mdoProperty = (Property)omr.acquireOMRObject(property);
            if (mdoProperty.getAssociatedPropertySets().size() == 0) {
                mdoPropertySet.getSetProperties().add((Object)mdoProperty);
            }
            property.saveToOMR(omr);
        }
        this.setChanged(false);
    }
}

