/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.impl.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Transformation;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;

public abstract class AbstractConditionAction
extends AbstractPersistableObject
implements IConditionAction {
    public static final String ACTIONOPTIONVALUE_CHANGED = "BaseConditionAction:ActionValueChanged";
    private static final String LISTENER_TYPE_HTTP = "HTTP";
    private static final String EVENT_NAME = "evntname=";
    private List m_lEvents;
    private String m_sHostName;
    private int m_iPort;
    protected String m_sActionType = "";
    protected String m_sUniqueIdentifier = "";
    protected int m_iInstanceVersion = 1;
    protected ITextOperand m_oSetTargetColumnToValueOperand;
    protected IConditionActionSet m_owningSet;
    protected List m_actionProperties;

    public AbstractConditionAction(String sID, IModel model) {
        super(sID, model);
        this.m_actionProperties = new ArrayList();
        this.m_lEvents = new ArrayList();
        this.setName(this.getName());
    }

    public AbstractConditionAction(String sID, IModel model, String sType) {
        super(sID, model);
        this.m_sActionType = sType;
        this.setUniqueIdentifier(sType);
        this.m_actionProperties = new ArrayList();
        this.m_lEvents = new ArrayList();
        this.setName(this.getName());
    }

    public AbstractConditionAction(String sID, IModel model, String sType, IConditionActionSet owningSet) {
        this(sID, model, sType);
        this.setConditionActionSet(owningSet);
    }

    @Override
    public String getName() {
        String sName = RB.getStringResource("NoNameYet.txt");
        if (this.m_sUniqueIdentifier == null || this.m_sUniqueIdentifier.length() == 0) {
            return sName;
        }
        try {
            sName = RB.getStringResource(this.m_sUniqueIdentifier + ".Name.txt");
        }
        catch (MissingResourceException ex) {
            sName = RB.getStringResource("NoNameYet.txt");
        }
        return sName;
    }

    public String getDesc() {
        String sDesc = "";
        try {
            sDesc = RB.getStringResource(this.m_sUniqueIdentifier + ".Description.txt");
        }
        catch (MissingResourceException ex) {
            sDesc = "";
        }
        return sDesc;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "Action";
    }

    public String getPublicType() {
        return "Embedded:Action";
    }

    public UsageVersion getArchitectureVersionNumber() {
        return new UsageVersion(1, 0);
    }

    protected void loadEventPropertyTemplateFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        SoftwareComponent oSoftware = null;
        ServiceComponent oService = null;
        PropertySet oListenerType = null;
        String sOptions = "<XMLSELECT Search=\"SoftwareComponent[@Name='Remote Services']\"/><TEMPLATES><SoftwareComponent Id=\"\" Name=\"\" Desc=\"\"/></TEMPLATES>";
        List objects = omr.getOMRFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)omr.getOMRStore(), Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), "SoftwareComponent", 8588, sOptions);
        if (objects.isEmpty()) {
            return;
        }
        oSoftware = (SoftwareComponent)objects.get(0);
        sOptions = "<XMLSELECT Search=\"ServiceComponent[@Name='Event Broker Service']\"/><TEMPLATES><ServiceComponent Id=\"\" Name=\"\" Desc=\"\"><InitProcesses><Transformation><TransformationSources/></Transformation></InitProcesses><RegisteredEvents/></ServiceComponent></TEMPLATES>";
        objects.clear();
        objects = omr.getOMRFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)omr.getOMRStore(), Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), "ServiceComponent", 8588, sOptions);
        if (objects.isEmpty()) {
            return;
        }
        oService = (ServiceComponent)objects.get(0);
        AssociationList lInitProcesses = oService.getInitProcesses();
        for (int iInitProcess = 0; iInitProcess < lInitProcesses.size(); ++iInitProcess) {
            Transformation oProcess = (Transformation)lInitProcesses.get(iInitProcess);
            AssociationList lTransformationSources = oProcess.getTransformationSources();
            for (int iTransformation = 0; iTransformation < lTransformationSources.size(); ++iTransformation) {
                PropertySet oPropertySet = (PropertySet)lTransformationSources.get(iTransformation);
                if (!oPropertySet.getSetRole().equals(LISTENER_TYPE_HTTP)) continue;
                oListenerType = oPropertySet;
                TCPIPConnection oListenerOwner = (TCPIPConnection)oPropertySet.getOwningObject();
                this.setHostName(oListenerOwner.getHostName());
                this.setPort(oListenerOwner.getPort());
            }
        }
        AssociationList lRegisteredEvents = oService.getRegisteredEvents();
        for (int iEvent = 0; iEvent < lRegisteredEvents.size(); ++iEvent) {
            Event event = (Event)lRegisteredEvents.get(iEvent);
            IProperty oEventProperty = this.getModel().getObjectFactory().createNewActionProperty(event.getId());
            omr.populateFor(oEventProperty);
            oEventProperty.loadFromOMR(omr);
            oEventProperty.setPropertyName(event.getName());
            oEventProperty.setName(event.getName());
            oEventProperty.setDescription(event.getDesc());
            oEventProperty.setDefaultValue(EVENT_NAME + event.getName());
            oEventProperty.setTranslateName(false);
            this.getEventPropertyTemplatesList().add(oEventProperty);
        }
        for (int iProperty = 0; iProperty < this.getActionPropertiesList().size(); ++iProperty) {
            IProperty property = (IProperty)this.getActionPropertiesList().get(iProperty);
            if (oSoftware != null && property.getPropertyRole().equals("SoftwareComponent")) {
                property.setPropertyName(oSoftware.getName());
                property.setName(oSoftware.getName());
                property.setDescription(oSoftware.getDesc());
                property.setDefaultValue(oSoftware.getName());
                property.setTranslateName(false);
                continue;
            }
            if (oService != null && property.getPropertyRole().equals("ServiceComponent")) {
                property.setPropertyName(oService.getName());
                property.setName(oService.getName());
                property.setDescription(oService.getDesc());
                property.setDefaultValue(oService.getName());
                property.setTranslateName(false);
                continue;
            }
            if (oListenerType != null && property.getPropertyRole().equals("ListenerType")) {
                property.setPropertyName(oListenerType.getSetRole());
                property.setName(oListenerType.getSetRole());
                property.setDescription(oListenerType.getSetRole());
                property.setDefaultValue(oListenerType.getSetRole());
                property.setTranslateName(false);
                continue;
            }
            if (!property.getPropertyRole().equals("Event")) continue;
            property.setTranslateName(false);
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.saveToOMR(omr);
        this.setChanged(false);
    }

    @Override
    public String getPropertyValueByPropertyName(String sPropertyName) {
        for (int i = 0; i < this.m_actionProperties.size(); ++i) {
            IProperty oProperty = (IProperty)this.m_actionProperties.get(i);
            if (!oProperty.getPropertyName().equalsIgnoreCase(sPropertyName)) continue;
            return oProperty.getDefaultValue();
        }
        return " ";
    }

    @Override
    public String getUniqueIdentifier() {
        return this.m_sUniqueIdentifier;
    }

    @Override
    public void setUniqueIdentifier(String sValue) {
        if (sValue == null || sValue.length() == 0) {
            throw new IllegalArgumentException("Value may not be null or empty");
        }
        if (sValue.equals(this.m_sUniqueIdentifier)) {
            return;
        }
        this.m_sUniqueIdentifier = sValue;
    }

    protected void setInstanceVersion(int iVersion) {
        if (iVersion == 0) {
            throw new IllegalArgumentException("Value may not be 0");
        }
        if (iVersion == this.m_iInstanceVersion) {
            return;
        }
        this.m_iInstanceVersion = iVersion;
    }

    @Override
    public void setConditionActionSet(IConditionActionSet set) {
        this.m_owningSet = set;
    }

    @Override
    public IConditionActionSet getConditionActionSet() {
        return this.m_owningSet;
    }

    @Override
    public void setActionType(String sValue) {
        if (sValue == null || sValue.length() == 0) {
            throw new IllegalArgumentException("Value may not be null or empty");
        }
        if (sValue.equals(this.m_sActionType)) {
            return;
        }
        this.m_sActionType = sValue;
    }

    @Override
    public IProperty[] getActionProperties() {
        if (this.m_actionProperties.size() == 0) {
            return null;
        }
        return this.m_actionProperties.toArray(new IProperty[this.m_actionProperties.size()]);
    }

    @Override
    public List getActionPropertiesList() {
        return this.m_actionProperties;
    }

    @Override
    public IProperty getActionProperty(int index) {
        if (index >= this.m_actionProperties.size()) {
            Workspace.getDefaultLogger().debug((Object)"Index out of bounds trying to retreive property");
            return null;
        }
        return (IProperty)this.m_actionProperties.get(index);
    }

    @Override
    public IProperty getActionProperty(String sPropertyName) {
        for (int i = 0; i < this.m_actionProperties.size(); ++i) {
            IProperty oProperty = (IProperty)this.m_actionProperties.get(i);
            if (!oProperty.getPropertyName().equalsIgnoreCase(sPropertyName)) continue;
            return oProperty;
        }
        return null;
    }

    @Override
    public String getActionType() {
        return this.m_sActionType;
    }

    @Override
    public int getPropertyCount() {
        return this.m_actionProperties.size();
    }

    @Override
    public StringBuffer getActionMacroCall(boolean bUseNLSFormat, ICodeSegment codeSegment) {
        return this.getActionMacroCall(bUseNLSFormat, codeSegment, null, null);
    }

    @Override
    public StringBuffer getActionMacroCall(boolean bUseNLSFormat, ICodeSegment codeSegment, ITable table, ILibrary library) {
        StringBuffer sbActionOptions = new StringBuffer();
        if (!this.getUniqueIdentifier().equalsIgnoreCase("DIS_SENDEVENT")) {
            String sLibref = "libref = ";
            String sAddress = "address = ";
            String sFileName = "filename = ";
            String sDataSet = "dataset = ";
            String sReturnCode = "returnCode = ";
            for (int iAction = 0; iAction < this.m_actionProperties.size(); ++iAction) {
                IProperty oActionOption = (IProperty)this.m_actionProperties.get(iAction);
                String sPropertyName = oActionOption.getPropertyName();
                if (sbActionOptions.length() > 0) {
                    sbActionOptions.append("    ");
                }
                String actionValue = "";
                boolean addStr = codeSegment.isEscapedMacroValue(oActionOption.getDefaultValue());
                if (addStr) {
                    actionValue = "%str(";
                    actionValue = actionValue + codeSegment.getEscapedMacroValue(oActionOption.getDefaultValue());
                    actionValue = actionValue + ")";
                } else {
                    actionValue = oActionOption.getDefaultValue();
                }
                if (sPropertyName.equals("Libref")) {
                    sbActionOptions.append(sLibref).append(actionValue);
                } else if (sPropertyName.equals("Address") && !sPropertyName.equalsIgnoreCase("Email_Address")) {
                    sbActionOptions.append(sAddress).append(actionValue);
                } else if (sPropertyName.equals("Path_and_Filename")) {
                    sbActionOptions.append(sFileName).append(actionValue);
                } else if (sPropertyName.equals("Dataset")) {
                    sbActionOptions.append(sDataSet).append(actionValue);
                } else if (sPropertyName.equals("ReturnCode")) {
                    sbActionOptions.append(sReturnCode).append(actionValue);
                } else if (sPropertyName.equals("Table_Name")) {
                    sbActionOptions.append(sFileName).append(actionValue);
                } else if (sPropertyName.equals("Custom")) {
                    sbActionOptions.append(oActionOption.getDefaultValue());
                } else {
                    sbActionOptions.append(sPropertyName).append(" = ").append(actionValue);
                }
                if (iAction == this.m_actionProperties.size() - 1) continue;
                sbActionOptions.append(", \n");
            }
        }
        if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_SEND_EMAIL")) {
            return this.getSendEmailActionMacroCall(bUseNLSFormat, codeSegment, sbActionOptions);
        }
        if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_SENDTEXTFILE")) {
            return this.getSendTextFileActionMacroCall(bUseNLSFormat, codeSegment, sbActionOptions);
        }
        if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_SENDDATASET")) {
            return this.getSendDatasetActionMacroCall(bUseNLSFormat, codeSegment, sbActionOptions);
        }
        if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CUSTOM")) {
            return this.getCustomActionMacroCall(codeSegment, sbActionOptions);
        }
        if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_SENDJOBSTATUS")) {
            return this.getJobStatusActionMacroCall(bUseNLSFormat, codeSegment, sbActionOptions);
        }
        if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_SENDEVENT")) {
            String strTableName = null;
            if (table != null) {
                strTableName = table.getTableName(false);
            }
            String strLibref = null;
            if (library != null) {
                strLibref = library.getLibref();
            }
            return this.getEventActionMacroCall(bUseNLSFormat, codeSegment, sbActionOptions, strTableName, strLibref);
        }
        if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_ABORT") || this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_ABORTALL") || this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_ABORTAFTERLOOP")) {
            return this.getAbortActionMacroCall(codeSegment, sbActionOptions);
        }
        return new StringBuffer();
    }

    public StringBuffer getSendEmailActionMacroCall(boolean bUseNLSFormat, ICodeSegment codeSegment, StringBuffer sbActionOptions) {
        String dateFormat = codeSegment.getDateTimeFormat(bUseNLSFormat);
        StringBuffer code = new StringBuffer();
        String indent = "   ";
        String indent2 = indent + indent;
        code.append("%macro etls_sendEmail(address=, message=); \n\n").append(indent).append("filename sendMail email \"&address\" subject='ETL Process Status'; \n\n").append(codeSegment.getNoSyntaxCheck(indent)).append("\n").append(indent).append("data _null_; \n").append(indent2).append("file sendMail; \n").append(indent2).append("dttm = put(datetime(),").append(dateFormat).append("); \n").append(indent2).append("put dttm \"&message.\"; \n").append(indent).append("run; \n\n").append(codeSegment.getResetSyntaxCheck(indent)).append("%mend etls_sendEmail; \n").append("%etls_sendEmail \n").append("   (").append(sbActionOptions).append("); \n");
        return code;
    }

    public StringBuffer getSendTextFileActionMacroCall(boolean bUseNLSFormat, ICodeSegment codeSegment, StringBuffer sbActionOptions) {
        String dateFormat = codeSegment.getDateTimeFormat(bUseNLSFormat);
        StringBuffer code = new StringBuffer();
        String indent = "   ";
        String indent2 = indent + indent;
        code.append("%macro etls_sendFile(directory=, filename=, message=); \n\n").append(indent).append("filename sendfile \"&directory.&filename\"; \n\n").append(codeSegment.getNoSyntaxCheck(indent)).append("\n").append(indent).append("data _null_; \n").append(indent2).append("file sendFile; \n").append(indent2).append("dttm = put(datetime(),").append(dateFormat).append("); \n").append(indent2).append("put dttm \"&message.\"; \n").append(indent).append("run; \n\n").append(codeSegment.getResetSyntaxCheck(indent)).append("%mend etls_sendFile; \n").append("%etls_sendFile \n").append("   (").append(sbActionOptions).append("); \n");
        return code;
    }

    public StringBuffer getSendDatasetActionMacroCall(boolean bUseNLSFormat, ICodeSegment codeSegment, StringBuffer sbActionOptions) {
        String dateFormat = codeSegment.getDateTimeFormat(bUseNLSFormat);
        StringBuffer code = new StringBuffer();
        String indent = "   ";
        String indent2 = indent + indent;
        code.append("%macro etls_sendData(libref=, dataset=, message=); \n\n").append(codeSegment.getNoSyntaxCheck(indent)).append("\n").append(indent).append("data work.etls_tempData; \n").append(indent2).append("length message $80; \n").append(indent2).append("message = \"&message.\"; \n").append(indent2).append("datetime = put(datetime(),").append(dateFormat).append("); \n").append(indent).append("run; \n\n").append(codeSegment.getObsMaxSet(indent)).append("\n").append(indent).append("proc append base=&libref..&dataset. data=work.etls_tempData force;").append(indent).append("run; \n\n").append(codeSegment.getResetObs(indent)).append("\n").append(indent).append("proc datasets lib = work nolist; \n").append(indent2).append("delete etls_tempData; \n").append(indent).append("quit;\n\n").append(codeSegment.getResetSyntaxCheck(indent)).append("%mend etls_sendData; \n").append("%etls_sendData \n").append("   (").append(sbActionOptions).append("); \n\n");
        return code;
    }

    public StringBuffer getCustomActionMacroCall(ICodeSegment codeSegment, StringBuffer sbActionOptions) {
        StringBuffer code = new StringBuffer();
        if (sbActionOptions != null) {
            code.append(sbActionOptions);
        }
        code.append("\n");
        return code;
    }

    @Override
    public int getInstanceVersion() {
        return this.m_iInstanceVersion;
    }

    public StringBuffer getJobStatusActionMacroCall(boolean bUseNLSFormat, ICodeSegment codeSegment, StringBuffer sbActionOptions) {
        String sUserColumnName = this.m_owningSet.getUserProperty("StatusTableUserColumn");
        if (sUserColumnName == null || sUserColumnName.isEmpty()) {
            sUserColumnName = "user";
        }
        String dtFormat = null;
        dtFormat = bUseNLSFormat ? codeSegment.getDateTimeFormat(bUseNLSFormat, "") : codeSegment.getDateTimeFormat(bUseNLSFormat, "18");
        StringBuffer code = new StringBuffer();
        String indent = "   ";
        String indent2 = indent + indent;
        String indent3 = indent2 + indent;
        code.append("%macro etls_sendJobStatus(libref=, dataset=, metauser=); \n\n").append(codeSegment.getNoSyntaxCheck(indent)).append("\n").append(indent).append("%local dsid etls_etvarnum etls_stvarnum etls_stfmt etls_etfmt; \n").append(indent).append("%let dsid=%sysfunc(open(&libref..&dataset,i)); \n").append(indent).append("%if &dsid %then \n").append(indent).append("%do; \n").append(indent2).append("%let etls_stvarnum=%sysfunc(varnum(&dsid,STTIME)); \n").append(indent2).append("%if (&etls_stvarnum gt 0) %then \n").append(indent3).append("%let etls_stfmt=%sysfunc(varfmt(&dsid,&etls_stvarnum)); \n\n").append(indent2).append("%let etls_etvarnum=%sysfunc(varnum(&dsid,ENDTIME)); \n").append(indent2).append("%if (&etls_etvarnum gt 0) %then \n").append(indent3).append("%let etls_etfmt=%sysfunc(varfmt(&dsid,&etls_etvarnum)); \n\n").append(indent2).append("%let rc=%sysfunc(close(&dsid)); \n").append(indent).append("%end; \n\n").append(indent).append("%if (\"&etls_stfmt\" eq \"\") %then \n ").append(indent2).append("%let etls_stfmt = ").append(dtFormat).append("; \n").append(indent).append("%if (\"&etls_etfmt\" eq \"\") %then \n").append(indent2).append("%let etls_etfmt = ").append(dtFormat).append("; \n\n").append(indent).append("data work.etls_tempData; \n\n").append(indent2).append("attrib ").append(sUserColumnName).append(" length = $32 \n").append(indent2).append("            label = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.UserID.label.txt")).append("\"; \n").append(indent2).append("attrib rbefore length = 8 \n").append(indent2).append("               label = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.RBefore.label.txt")).append("\"; \n").append(indent2).append("attrib rafter length = 8 \n").append(indent2).append("            label = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.RAfter.label.txt")).append("\"; \n").append(indent2).append("attrib etl_table length = $32 \n").append(indent2).append("             label = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.TableName.label.txt")).append("\"; \n").append(indent2).append("attrib lib length = $32 \n").append(indent2).append("           label = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.Library.label.txt")).append("\"; \n").append(indent2).append("attrib jobname length = $80 \n").append(indent2).append("               label = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.JobName.label.txt")).append("\"; \n").append(indent2).append("attrib jobstat length = $80 \n").append(indent2).append("            label = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.JobStatus.label.txt")).append("\"; \n").append(indent2).append("attrib job_rc length = 8 \n").append(indent2).append("              label = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.JobReturnCode.label.txt")).append("\"; \n").append(indent2).append("attrib sttime length = 8 format = &etls_stfmt. \n").append(indent2).append("              label = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.JobStartTime.label.txt")).append("\"; \n").append(indent2).append("attrib endtime length = 8 format = &etls_etfmt. \n").append(indent2).append("               label = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.JobEndTime.label.txt")).append("\"; \n\n").append(indent2).append(sUserColumnName).append(" = \"&sysuserid\"; \n").append(indent2).append("rbefore = &etls_recordsBefore; \n").append(indent2).append("rafter = &etls_recordsAfter; \n").append(indent2).append("etl_table = \"&etls_table\"; \n").append(indent2).append("lib = \"&etls_lib\"; \n").append(indent2).append("jobname = \"&etls_jobName\"; \n").append(indent2).append("job_rc = &job_rc; \n\n").append(indent2).append("if job_rc = 0 then \n").append(indent2).append(indent).append("jobstat = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.Successful.txt")).append("\"; \n").append(indent2).append("else if job_rc = 4 then \n").append(indent2).append(indent).append("jobstat = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.Warning.txt")).append("\"; \n").append(indent2).append("else if job_rc > 4 then \n").append(indent2).append(indent).append("jobstat = \"").append(RB.getStringResource("AbstractConditionAction.JobStatus.Error.txt")).append("\"; \n\n").append(indent2).append("sttime = \"&etls_startTime\"dt; \n").append(indent2).append("endtime = \"&etls_endTime\"dt; \n\n").append(indent).append("run; \n\n").append(codeSegment.getObsMaxSet(indent)).append("\n").append(indent).append("proc append base=&libref..&dataset data=work.etls_tempData force; \n").append(indent).append("run; \n\n").append(codeSegment.getResetObs(indent)).append("\n").append(indent).append("proc datasets lib = work nolist; \n").append(indent2).append("delete etls_tempData; \n").append(indent).append("quit;\n\n").append(codeSegment.getResetSyntaxCheck(indent)).append("%mend etls_sendJobStatus; \n").append("%etls_sendJobStatus \n").append("   (").append(sbActionOptions).append("); \n\n");
        return code;
    }

    public StringBuffer getEventActionMacroCall(boolean bUseNLSFormat, ICodeSegment codeSegment, StringBuffer sbActionOptions, String sTableName, String sLibname) {
        String dateFormat = codeSegment.getDateTimeFormat(bUseNLSFormat);
        String sDate = "";
        List properties = this.getActionPropertiesList();
        IProperty foundProperty = null;
        for (int i = 0; i < properties.size(); ++i) {
            IProperty property = (IProperty)properties.get(i);
            if (property.getDefaultValue().indexOf("evntname") <= -1) continue;
            foundProperty = property;
            break;
        }
        IConditionActionSet owningSet = this.getConditionActionSet();
        IConditionActionSet templateSet = owningSet.getOwningConditionActionSet();
        List lTemplateActions = templateSet.getActionList();
        IConditionAction templateAction = null;
        for (int i = 0; i < lTemplateActions.size(); ++i) {
            IConditionAction action = (IConditionAction)lTemplateActions.get(i);
            if (!action.getUniqueIdentifier().equalsIgnoreCase("DIS_SENDEVENT")) continue;
            templateAction = action;
            break;
        }
        String sHost = "";
        String sPort = "";
        if (templateAction != null) {
            sHost = templateAction.getHostName();
            sPort = String.valueOf(templateAction.getPort());
        }
        if (foundProperty != null) {
            sbActionOptions.append(foundProperty.getDefaultValue());
        }
        String sEventServer = "%let etls_eventserver = http://" + sHost + ":" + sPort + ";\n";
        sbActionOptions.append(", \n").append("sentby = etlprocess, \n").append("eventserver = &etls_eventserver");
        if (sTableName != null) {
            sbActionOptions.append(", \n").append("props=dataset lib repos chgdate , \n").append("vals=");
            sbActionOptions.append(sTableName + "##");
            sbActionOptions.append(sLibname + "##");
            sbActionOptions.append("FOUNDATION##");
            sbActionOptions.append("&etls_chgdate.##");
            sDate = "%let etls_chgdate = %sysfunc(datetime()," + dateFormat + ");\n";
        } else {
            sbActionOptions.append(", props= ,\n  vals=");
        }
        StringBuffer code = new StringBuffer(sDate + sEventServer + "%sendEvnt(" + sbActionOptions + "); \n");
        return code;
    }

    public StringBuffer getAbortActionMacroCall(ICodeSegment codeSegment, StringBuffer sbActionOptions) {
        int index = sbActionOptions.indexOf("=");
        String returnCode = sbActionOptions.substring(index + 1);
        String abortCode = codeSegment.getAbortJobCode(returnCode);
        return new StringBuffer(abortCode);
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        for (int iOption = 0; iOption < this.m_actionProperties.size(); ++iOption) {
            IProperty property = (IProperty)this.m_actionProperties.get(iOption);
            if (!property.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        for (int t = 0; t < this.m_actionProperties.size(); ++t) {
            IProperty property = (IProperty)this.m_actionProperties.get(t);
            property.updateIDs(mapIDs);
        }
    }

    @Override
    public String getHostName() {
        return this.m_sHostName;
    }

    protected void setHostName(String hostName) {
        this.m_sHostName = hostName;
    }

    @Override
    public int getPort() {
        return this.m_iPort;
    }

    protected void setPort(int port) {
        this.m_iPort = port;
    }

    @Override
    public List getEventPropertyTemplatesList() {
        return this.m_lEvents;
    }

    @Override
    public IProperty[] getEventPropertyTemplates() {
        return this.m_lEvents.toArray(new IProperty[this.m_lEvents.size()]);
    }
}

