/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.waitforcompletion.mapping.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.waitforcompletion.IWaitForCompletionColumn;
import com.sas.etl.models.data.waitforcompletion.IWaitForCompletionTable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.transforms.waitforcompletion.mapping.IWaitForCompletionMapping;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;

public class WaitForCompletionMapping
extends BaseMapping
implements IWaitForCompletionMapping {
    private IWaitForCompletionTable m_edmFlowTable;
    private List<IWaitForCompletionColumn> m_WaitForCompletionColumns = new ArrayList<IWaitForCompletionColumn>();

    public WaitForCompletionMapping(String sID, IModel model) {
        super(sID, model);
        this.setType("WaitForCompletion");
    }

    @Override
    public String getType() {
        return "WaitForCompletion";
    }

    @Override
    public boolean isOrdinary() {
        return false;
    }

    @Override
    public IColumn[] getTargets() {
        return new IColumn[0];
    }

    @Override
    public int getTargetCount() {
        return this.m_WaitForCompletionColumns.size();
    }

    @Override
    public void addTarget(IColumn column) {
    }

    @Override
    public void addTarget(int iTarget, IColumn column) {
    }

    @Override
    public void addTargetWaitForCompletionColumn(IWaitForCompletionColumn column) {
        this.addTargetWaitForCompletionColumn(this.m_WaitForCompletionColumns.size(), column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTargetWaitForCompletionColumn(int iTarget, IWaitForCompletionColumn column) {
        this.startCompoundUndoable();
        try {
            this.m_WaitForCompletionColumns.add(iTarget, column);
            this.fireModelChangedEvent("Mapping:TargetColumnAdded", column);
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new AddTargetUndoable(iTarget, column));
            }
            if (this.isAutoType()) {
                this.updateType();
            }
            String expText = "";
            ITextExpression expression = (ITextExpression)this.getExpression();
            if (expression == null) {
                expression = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
                this.setExpression(expression);
                expText = this.getColumnExpression(column);
            } else {
                expText = expText + "::" + this.getColumnExpression(column);
            }
            expression.setText(expText, new IObject[0]);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private String getColumnExpression(IWaitForCompletionColumn column) {
        return column.getTable().getID() + '.' + column.getID();
    }

    @Override
    public void clearTargets() {
        IWaitForCompletionColumn[] targets = this.getTargetsOfWaitForCompletionColumn();
        this.startCompoundUndoable();
        try {
            for (int i = 0; i < targets.length; ++i) {
                this.removeTargetWaitForCompletionColumn(targets[i]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void replaceTargetColumn(IColumn oldColumn, IColumn newColumn) {
    }

    @Override
    public void removeTarget(IColumn column) {
    }

    @Override
    protected boolean isSourceAndTargetComplete() {
        return this.getSourceCount() == 1 && this.getTargetCount() == 1;
    }

    @Override
    protected boolean isExpressionNeeded() {
        return false;
    }

    @Override
    public boolean containsInTargets(IColumn column) {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public List<String> getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        return lReasons;
    }

    @Override
    public String getWarning() {
        IWaitForCompletionColumn edmColumn = this.getTargetOfWaitForCompletionColumn();
        IColumn sourceColumn = this.getSource();
        return null;
    }

    @Override
    public boolean hasWarnings() {
        return this.getWarning() != null;
    }

    @Override
    public List getWarnings() {
        ArrayList<String> lst = new ArrayList<String>();
        String warn = this.getWarning();
        if (warn != null) {
            lst.add(warn);
        }
        return lst;
    }

    @Override
    public boolean isDead() {
        return this.getSourceCount() == 0 || this.getTargetsOfWaitForCompletionColumn().length == 0;
    }

    @Override
    protected void saveTargetsToOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
    }

    @Override
    public void setWaitForCompletionTable(IWaitForCompletionTable table) {
        if (this.m_edmFlowTable == table) {
            return;
        }
        this.m_edmFlowTable = table;
        this.loadWaitForCompletionColumns();
    }

    private IWaitForCompletionColumn findWFCColumn(String text) {
        if (this.m_edmFlowTable != null && text != null && text.length() > 0) {
            for (IWaitForCompletionColumn c : this.m_edmFlowTable.getColumns()) {
                if (!ObjectComparator.isEqual(this.getColumnExpression(c), text)) continue;
                return c;
            }
        }
        return null;
    }

    private void loadWaitForCompletionColumns() {
        for (IWaitForCompletionColumn c : this.getTargetsOfWaitForCompletionColumn()) {
            this.removeTargetWaitForCompletionColumn(c);
        }
        ITextExpression expression = (ITextExpression)this.getExpression();
        if (expression != null) {
            String[] columnSplit;
            String expText = expression.getTokenizedText();
            for (String c : columnSplit = expText.split("::")) {
                IWaitForCompletionColumn column = this.findWFCColumn(c);
                if (column == null) continue;
                this.addTargetWaitForCompletionColumn(column);
            }
        }
    }

    @Override
    protected void loadExpressionFromOMR(OMRAdapter omr, FeatureMap mdoFM) throws RemoteException, MdException {
        super.loadExpressionFromOMR(omr, mdoFM);
        this.loadWaitForCompletionColumns();
    }

    @Override
    public void dump(PrintStream strm) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getID());
        sb.append(":");
        sb.append("ONETOONE".equals(this.getType()) ? "1to1" : ("DERIVED".equals(this.getType()) ? "Derived" : this.getType()));
        sb.append(":");
        for (int iSource = 0; iSource < this.getSourceCount(); ++iSource) {
            IColumn source = this.getSources()[iSource];
            sb.append(source + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("->");
        for (int iTarget = 0; iTarget < this.m_WaitForCompletionColumns.size(); ++iTarget) {
            IWaitForCompletionColumn target = this.m_WaitForCompletionColumns.get(iTarget);
            sb.append(target.getName() + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        strm.println(sb.toString());
    }

    @Override
    public boolean isMappingNeeded(boolean quoting, ITable sourceTable) {
        return true;
    }

    @Override
    public boolean isMappingRename(boolean quoting, ITable sourceTable) {
        return false;
    }

    @Override
    public IColumn getSource() {
        return this.getSourceCount() > 0 ? this.getSources()[0] : null;
    }

    @Override
    public IWaitForCompletionColumn getTargetOfWaitForCompletionColumn() {
        return !this.m_WaitForCompletionColumns.isEmpty() ? this.m_WaitForCompletionColumns.get(0) : null;
    }

    @Override
    public IWaitForCompletionColumn[] getTargetsOfWaitForCompletionColumn() {
        return this.m_WaitForCompletionColumns.toArray(new IWaitForCompletionColumn[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTargetWaitForCompletionColumn(IWaitForCompletionColumn column) {
        block9: {
            if (!this.m_WaitForCompletionColumns.contains(column)) {
                return;
            }
            this.startCompoundUndoable();
            try {
                ITextExpression expression;
                int iTarget = this.m_WaitForCompletionColumns.indexOf(column);
                this.m_WaitForCompletionColumns.remove(iTarget);
                this.fireModelChangedEvent("Mapping:TargetColumnRemoved", column);
                if (this.isUndoSupported()) {
                    this.undoableEditHappened(new RemoveTargetUndoable(iTarget, column));
                }
                if (this.isAutoType()) {
                    this.updateType();
                }
                if ((expression = (ITextExpression)this.getExpression()) == null) break block9;
                String expText = this.getColumnExpression(column);
                try {
                    String existingText = expression.getText(null, false);
                    existingText = existingText.replaceAll(expText + "::", "");
                    if (existingText == null || existingText.length() == 0 || ObjectComparator.isEqual(existingText, "::")) {
                        this.setExpression(null);
                        break block9;
                    }
                    expression.setText(existingText, new IObject[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    @Override
    public boolean containsInTargets(IWaitForCompletionColumn column) {
        return this.m_WaitForCompletionColumns.contains(column);
    }

    @Override
    public int indexInTargets(IWaitForCompletionColumn column) {
        return this.m_WaitForCompletionColumns.indexOf(column);
    }

    private class RemoveTargetUndoable
    extends AbstractUndoableEdit {
        private int m_iTarget;
        private IWaitForCompletionColumn m_column;

        public RemoveTargetUndoable(int iTarget, IWaitForCompletionColumn column) {
            this.m_iTarget = iTarget;
            this.m_column = column;
        }

        @Override
        public void undo() {
            super.undo();
            WaitForCompletionMapping.this.addTargetWaitForCompletionColumn(this.m_iTarget, this.m_column);
        }

        @Override
        public void redo() {
            super.redo();
            WaitForCompletionMapping.this.removeTargetWaitForCompletionColumn(this.m_column);
        }

        @Override
        public void die() {
            super.die();
            this.m_column = null;
        }
    }

    private class AddTargetUndoable
    extends AbstractUndoableEdit {
        private int m_iTarget;
        private IWaitForCompletionColumn m_column;

        public AddTargetUndoable(int iTarget, IWaitForCompletionColumn column) {
            this.m_iTarget = iTarget;
            this.m_column = column;
        }

        @Override
        public void undo() {
            super.undo();
            WaitForCompletionMapping.this.removeTargetWaitForCompletionColumn(this.m_column);
        }

        @Override
        public void redo() {
            super.redo();
            WaitForCompletionMapping.this.addTargetWaitForCompletionColumn(this.m_iTarget, this.m_column);
        }

        @Override
        public void die() {
            super.die();
            this.m_column = null;
        }
    }
}

