/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.tablemaintenance;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.tablemaintenance.RB;
import com.sas.etl.models.job.transforms.tablemaintenance.TableStatement;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TableMaintenanceTransformModel
extends AbstractDataTransform {
    protected static final String PROPERTYSET_NAME = "STATEMENT_OPTIONS";
    private static final String PROPERTY_NAME_ADDITIONAL_PROC_OPTIONS = "AdditionalProcOptions";
    public static final String TRANSFORMATION_CLASS = "com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenance";
    public static final String TRANSFORMATION_ROLE = "com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenance";
    private static final String ARM_DISPLAY_NAME = "TableMaintenance";
    public static final String STATEMENT_ADDED = "stmt_added";
    public static final String STATEMENT_REMOVED = "stmt_removed";
    public static final String STATEMENT_MOVED = "stmt_moved";
    private StatementList m_statements = new StatementList(this);

    public TableMaintenanceTransformModel(String sID, IModel model) {
        super(sID, model);
        try {
            IPromptModel transformOptionModel = this.getOptionModel();
            IPromptDefinitionValue pdv = transformOptionModel.getPromptDefinitionValue("GENERATEFORMATSINFORMATS");
            if (pdv != null) {
                pdv.setHidden(true);
            }
            if ((pdv = transformOptionModel.getPromptDefinitionValue("SYSLAST")) != null) {
                pdv.setHidden(true);
            }
            if ((pdv = transformOptionModel.getPromptDefinitionValue("GenerateIndexesOnTargets")) != null) {
                pdv.setHidden(true);
            }
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)e);
        }
        catch (ServerConnectionException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
        }
        catch (ServiceException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            ModelLogger.getDefaultLogger().error((Object)"FileNotFoundException", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            ModelLogger.getDefaultLogger().error((Object)"ParserConfigurationException", (Throwable)e);
        }
        catch (SAXException e) {
            ModelLogger.getDefaultLogger().error((Object)"SAXException", (Throwable)e);
        }
        catch (IOException e) {
            ModelLogger.getDefaultLogger().error((Object)"ServIOExceptioniceException", (Throwable)e);
        }
    }

    public IPhysicalTable[] getAllPhysicalTables() {
        ArrayList<ITable> tables = new ArrayList<ITable>();
        ITable[] sources = this.getSourceTables();
        for (int i = 0; i < sources.length; ++i) {
            if (!(sources[i] instanceof IPhysicalTable)) continue;
            tables.add(sources[i]);
        }
        ITable[] targets = this.getTargetTables();
        for (int i = 0; i < targets.length; ++i) {
            if (!(targets[i] instanceof IPhysicalTable)) continue;
            tables.add(targets[i]);
        }
        return tables.toArray(new IPhysicalTable[tables.size()]);
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("TableMaintenanceTransform.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("TableMaintenanceTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenance";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenance";
    }

    public static String getTransformTypeID() {
        return "com.sas.etl.models.job.transforms.tablemaintenance.TableMaintenance";
    }

    @Override
    protected int getMaximumDataTargetCount() {
        return Integer.MAX_VALUE;
    }

    public TableStatement[] getStatements() {
        return (TableStatement[])this.m_statements.toArray(new TableStatement[this.m_statements.size()]);
    }

    public List getStatementList() {
        return this.m_statements;
    }

    @Override
    public void notify(NotifyEvent ev) {
        super.notify(ev);
    }

    @Override
    protected void preRemoveDataTarget(IDataObject target) {
        super.preRemoveDataTarget(target);
        for (TableStatement statement : this.getStatements()) {
            if (statement.getTargetTable() != target) continue;
            statement.setTargetTable(null);
        }
    }

    public void fireChange(String sType, Object data) {
        this.fireModelChangedEvent(sType, data);
    }

    public void addStatement(TableStatement statement) {
        if (this.m_statements.contains(statement)) {
            return;
        }
        this.removeFromDeletedObjects(statement);
        this.m_statements.add(statement);
    }

    @Override
    protected boolean doesNoSourcesMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    public String getNewStatementName() {
        int count = this.getStatements().length + 1;
        String name = MessageFormat.format(RB.getStringResource("TableStatement.DefaultName.txt"), count);
        while (!this.isNameUnique(name)) {
            name = MessageFormat.format(RB.getStringResource("TableStatement.DefaultName.txt"), ++count);
        }
        return name;
    }

    private boolean isNameUnique(String name) {
        for (TableStatement statement : this.getStatements()) {
            if (!name.equals(statement.getName())) continue;
            return false;
        }
        return true;
    }

    public ClassifierMap getCM(OMRAdapter omr) throws MdException, RemoteException {
        return this.getClassifierMapObject(omr);
    }

    public void removeStatement(TableStatement statement) {
        if (!this.m_statements.contains(statement)) {
            return;
        }
        this.addToDeletedObjects(statement);
        this.m_statements.remove(statement);
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.areStatementsComplete();
    }

    public boolean areStatementsComplete() {
        for (TableStatement statement : this.getStatements()) {
            if (statement.getTargetTable() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (!this.areStatementsComplete()) {
            lReasons.add(RB.getStringResource("TableMaintenanceTransformModel.ReasonIncomplete.NoTargetTable.txt"));
        }
        return lReasons;
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean validate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment, validate);
        for (TableStatement statement : this.getStatements()) {
            IDBMSType dbType;
            IPhysicalTable table;
            if (statement.getPassThru()) {
                codeSegment.addSourceCode("proc sql;\n").indent();
                table = statement.getTargetTable();
                dbType = table.getDBMSType();
                dbType.genConnect(codeSegment, table);
                statement.getGeneratedCode(codeSegment, table, this);
                dbType.genDisconnect(codeSegment, table);
                codeSegment.unIndent().addSourceCode("quit;\n\n");
                continue;
            }
            codeSegment.addSourceCode("proc sql;\n").indent();
            table = statement.getTargetTable();
            dbType = table.getDBMSType();
            statement.getGeneratedCode(codeSegment, table, this);
            codeSegment.unIndent().addSourceCode("quit;\n\n");
        }
        return codeSegment;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.m_statements.saveToOMR(omr, (List)this.getClassifierMapObject(omr).getFeatureMaps());
        AssociationList lFMs = this.getClassifierMapObject(omr).getFeatureMaps(false);
        for (TableStatement statement : this.getStatements()) {
            Root mdoMapping = omr.acquireOMRObject(statement);
            if (lFMs.contains(mdoMapping)) continue;
            lFMs.add(mdoMapping);
        }
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        this.m_statements.loadFromOMR(omr, (List)this.getClassifierMapObject(omr).getFeatureMaps());
        for (TableStatement statement : this.getStatements()) {
            statement.setTransformModel(this);
        }
        this.setChanged(false);
    }

    @Override
    protected void loadMappingsFromOMR(OMRAdapter omr, ClassifierMap mdoCM) throws MdException, RemoteException {
        AssociationList lFMs = mdoCM.getFeatureMaps();
        for (int iFM = 0; iFM < lFMs.size(); ++iFM) {
            FeatureMap mdoFM = (FeatureMap)lFMs.get(iFM);
            if ("Create".equals(mdoFM.getTransformRole()) || "Alter".equals(mdoFM.getTransformRole())) continue;
            IMapping mapping = this.createMapping(omr, mdoFM);
            if (mapping.isDead()) {
                this.addToDeletedObjects(mapping);
                continue;
            }
            this.addMapping(mapping);
        }
    }

    private class StatementList
    extends ModelList {
        private IFilter m_addFilter;

        public StatementList(AbstractPersistableObject owner) {
            super(owner, new String[]{TableMaintenanceTransformModel.STATEMENT_ADDED, TableMaintenanceTransformModel.STATEMENT_REMOVED, TableMaintenanceTransformModel.STATEMENT_MOVED}, 2);
            this.m_addFilter = new ListFilter();
            this.setAssociationItemFilter(new LoadFilter());
        }

        @Override
        protected IPersistableObject createObjectFromOMRObject(OMRAdapter omr, Root mdoObject) throws MdException, RemoteException {
            return new TableStatement(mdoObject.getFQID(), TableMaintenanceTransformModel.this.getModel());
        }

        @Override
        public void add(int iObj, Object obj) {
            if (!this.m_addFilter.pass(obj)) {
                return;
            }
            super.add(iObj, obj);
        }

        private class LoadFilter
        implements IFilter {
            private LoadFilter() {
            }

            @Override
            public boolean pass(Object obj) {
                if (!(obj instanceof FeatureMap)) {
                    return false;
                }
                FeatureMap mapping = (FeatureMap)obj;
                try {
                    if ("Create".equals(mapping.getTransformRole()) || "Alter".equals(mapping.getTransformRole())) {
                        return true;
                    }
                }
                catch (RemoteException e) {
                    ModelLogger.getDefaultLogger().debug((Object)e);
                }
                return false;
            }
        }

        private class ListFilter
        implements IFilter {
            private ListFilter() {
            }

            @Override
            public boolean pass(Object obj) {
                return obj instanceof TableStatement;
            }
        }
    }
}

