/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IObject;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IFromContainer;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import javax.swing.undo.AbstractUndoableEdit;

public class SetSQLSourceParentHelper {
    private ISQLSource m_secondary;
    private IClause m_primary;
    private boolean m_bInSet;
    private boolean m_bSetDone;

    public SetSQLSourceParentHelper(ISQLSource secondary) {
        this.m_secondary = secondary;
    }

    public void set(IClause primary) {
        if (this.m_primary == primary) {
            return;
        }
        if (!this.m_bInSet) {
            this.m_bInSet = true;
            this.m_secondary.getModel().startCompoundUndoable();
            try {
                this.m_bSetDone = false;
                if (this.m_primary != null) {
                    this.removeFrom(this.m_primary);
                }
                if (primary != null) {
                    this.m_bSetDone = false;
                    this.addTo(primary);
                }
            }
            finally {
                this.m_secondary.getModel().endCompoundUndoable();
                this.m_bInSet = false;
            }
        }
        if (this.m_bSetDone) {
            return;
        }
        this.setImpl(primary);
        this.m_bSetDone = true;
    }

    private void setImpl(IClause primary) {
        if (this.m_secondary.getModel().isUndoSupported()) {
            this.m_secondary.getModel().undoableEditHappened(new SetPrimaryUndoable(this.m_primary, primary));
        }
        this.m_primary = primary;
    }

    public IObject get() {
        return this.m_primary;
    }

    public void addTo(IClause primary) {
        if (primary instanceof IFromContainer) {
            ((IFromContainer)((Object)primary)).setSourceOfFrom(this.m_secondary);
        }
        primary.addSQLSource(this.m_secondary);
    }

    public void removeFrom(IClause primary) {
        primary.removeSQLSource(this.m_secondary);
    }

    private class SetPrimaryUndoable
    extends AbstractUndoableEdit {
        private IClause m_oldPrimary;
        private IClause m_newPrimary;

        public SetPrimaryUndoable(IClause oldPrimary, IClause newPrimary) {
            this.m_oldPrimary = oldPrimary;
            this.m_newPrimary = newPrimary;
        }

        @Override
        public void undo() {
            super.undo();
            SetSQLSourceParentHelper.this.setImpl(this.m_oldPrimary);
        }

        @Override
        public void redo() {
            super.redo();
            SetSQLSourceParentHelper.this.setImpl(this.m_newPrimary);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldPrimary = null;
            this.m_newPrimary = null;
        }
    }
}

