/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.impl.BaseTextExpression;
import com.sas.etl.models.job.transforms.sql.IAliasColumn;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.ISubqueryTargetTable;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Variable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLTextExpression
extends BaseTextExpression {
    private static final String EXPRESSION_CUSTOMLIST_NAME = "SQLExpressionColumnTable";
    private IQuery m_query;

    public SQLTextExpression(String sID, IModel model, IQuery query) {
        super(sID, model);
        this.m_query = query;
    }

    @Override
    protected void saveSubstituteVariablesToOMR(OMRAdapter omr, AbstractTransformation mdoAnchor) throws MdException, RemoteException {
        List lOldSubstituteVariablesIDs = this.m_lSubstituteVariablesIDs;
        this.m_lSubstituteVariablesIDs = new ArrayList(1);
        AssociationList lSubVars = mdoAnchor.getSubstitutionVariables(false);
        lSubVars.clear();
        Map tokenObjects = this.getTokenObjects();
        Iterator iterKeys = tokenObjects.keySet().iterator();
        int index = 0;
        while (iterKeys.hasNext()) {
            String marker = (String)iterKeys.next();
            IOMRPersistable object = (IOMRPersistable)tokenObjects.get(marker);
            Root mdoObject = null;
            if (object != null) {
                mdoObject = omr.acquireOMRObject(object);
            }
            String sVariableID = lOldSubstituteVariablesIDs.isEmpty() ? this.createIDForNewObject() : (String)lOldSubstituteVariablesIDs.remove(0);
            this.m_lSubstituteVariablesIDs.add(sVariableID);
            Variable mdoVar = (Variable)omr.acquireOMRObject(sVariableID, "Variable");
            mdoVar.getCustomAssociations(false).clear();
            String sName = "Missing";
            if (object != null) {
                sName = ((IObject)((Object)object)).getName();
            }
            mdoVar.setName(marker + " - " + sName);
            mdoVar.setMarker(marker);
            if (this.m_sVariableValueType == null || this.m_sVariableValueType.length() == 0) {
                this.m_sVariableValueType = this.isUseSQLSyntax() ? "long name" : "short name";
            }
            mdoVar.setValueType(this.m_sVariableValueType);
            if (mdoObject != null) {
                mdoVar.setAssociatedObject(mdoObject);
            } else {
                mdoVar.getAssociatedObjects().clear();
            }
            lSubVars.add(mdoVar);
            if (object == null) {
                mdoVar.getCustomAssociations(false).clear();
                this.deleteCustomListsFromOMR(omr);
                continue;
            }
            if (!(object instanceof IAliasColumn)) continue;
            IPersistableObject[] aTables = new ITable[1];
            ITable table = ((IAliasColumn)object).getTable();
            if (!(table instanceof ISourceTable)) continue;
            aTables[0] = table;
            this.saveCustomListToOMR(omr, (Root)mdoVar, EXPRESSION_CUSTOMLIST_NAME + new Integer(index).toString(), aTables);
            ++index;
        }
        while (!lOldSubstituteVariablesIDs.isEmpty()) {
            omr.deleteOMRObject((String)lOldSubstituteVariablesIDs.remove(0), "Variable");
        }
    }

    @Override
    protected void loadSubstituteVariablesFromOMR(OMRAdapter omr, AbstractTransformation mdoAnchor) throws MdException, RemoteException {
        this.m_lSubstituteVariablesIDs.clear();
        this.m_hmTokenizedVarObjects.clear();
        ArrayList<IOMRPersistable> lObjects = new ArrayList<IOMRPersistable>();
        AssociationList lVariables = mdoAnchor.getSubstitutionVariables();
        for (int i = 0; i < lVariables.size(); ++i) {
            Variable mdoVariable = (Variable)lVariables.get(i);
            this.m_lSubstituteVariablesIDs.add(mdoVariable.getFQID());
            this.m_sVariableValueType = mdoVariable.getValueType();
            String marker = mdoVariable.getMarker();
            Root assocObject = mdoVariable.getAssociatedObject();
            if (assocObject == null) {
                this.m_hmTokenizedVarObjects.put(marker, null);
                continue;
            }
            IOMRPersistable modelObject = null;
            if (assocObject instanceof Column) {
                ITable table;
                Column mdoColumn = (Column)assocObject;
                DataTable mdoTable = mdoColumn.getTable();
                if (mdoTable instanceof QueryTable && !((table = (ITable)omr.acquireObject((Root)mdoTable)) instanceof ISubqueryTargetTable)) {
                    IColumn[] aColumns = table.getColumns();
                    String sName = mdoColumn.getSASColumnName();
                    for (int index = 0; index < aColumns.length; ++index) {
                        if (!sName.equalsIgnoreCase(aColumns[index].getColumnName(false))) continue;
                        modelObject = aColumns[index];
                        break;
                    }
                    this.m_bChangedDuringLoad = true;
                }
                if (modelObject == null) {
                    modelObject = omr.acquireObject(assocObject);
                }
                IPersistableObject[] alTables = this.loadCustomListFromOMR(omr, (Root)mdoVariable, EXPRESSION_CUSTOMLIST_NAME + new Integer(i).toString());
                if (!(modelObject instanceof IAliasColumn)) {
                    IAliasColumn aliasColumn;
                    IPersistableObject table2;
                    if (alTables.length > 0) {
                        table2 = alTables[0];
                        if (table2 instanceof IAliasTable) {
                            IColumn[] columns = ((IAliasTable)table2).getColumns();
                            if (columns.length > 0) {
                                IAliasColumn aliasColumn2 = ((IAliasTable)table2).findAlaisedColumnContainingColumn((IColumn)modelObject);
                                if (aliasColumn2 != null) {
                                    modelObject = aliasColumn2;
                                }
                            } else {
                                this.m_bChangedDuringLoad = true;
                                table2 = ((IColumn)modelObject).getTable();
                                if (table2 instanceof ISubqueryTargetTable) {
                                    IAliasTable aliasTable;
                                    IAliasColumn aliasColumn3;
                                    IQuery subquery = ((ISubqueryTargetTable)table2).getParentQuery();
                                    if (subquery != null && (aliasColumn3 = (aliasTable = ((ISubquery)subquery).getAliasTable()).findAlaisedColumnContainingColumn((IColumn)modelObject)) != null) {
                                        modelObject = aliasColumn3;
                                    }
                                } else {
                                    table2 = ((IColumn)modelObject).getTable();
                                    ISourceTable[] alSrcTbls = this.m_query.findQuerySourceTables((ITable)table2);
                                    if (alSrcTbls.length > 0 && (aliasColumn = alSrcTbls[0].findAlaisedColumnContainingColumn((IColumn)modelObject)) != null) {
                                        modelObject = aliasColumn;
                                    }
                                }
                            }
                        }
                    } else if (this.m_query != null) {
                        table2 = ((IColumn)modelObject).getTable();
                        if (table2 instanceof ISubqueryTargetTable) {
                            IAliasTable aliasTable;
                            IQuery subquery = ((ISubqueryTargetTable)table2).getParentQuery();
                            if (subquery != null && (aliasColumn = (aliasTable = ((ISubquery)subquery).getAliasTable()).findAlaisedColumnContainingColumn((IColumn)modelObject)) != null) {
                                modelObject = aliasColumn;
                            }
                        } else {
                            IAliasColumn aliasColumn4;
                            ISourceTable[] alSrcTbls = this.m_query.findQuerySourceTables((ITable)table2);
                            if (alSrcTbls.length > 0 && (aliasColumn4 = alSrcTbls[0].findAlaisedColumnContainingColumn((IColumn)modelObject)) != null) {
                                modelObject = aliasColumn4;
                            }
                        }
                        this.m_bChangedDuringLoad = true;
                    }
                }
            }
            if (modelObject != null) {
                this.m_hmTokenizedVarObjects.put(marker, modelObject);
                lObjects.add(modelObject);
                ((IObject)((Object)modelObject)).addNotifyListener(this);
                continue;
            }
            this.m_hmTokenizedVarObjects.put(marker, null);
        }
        this.m_lObjects = lObjects.toArray(new IObject[lObjects.size()]);
    }

    @Override
    protected String getSubstitutionText(IServer currentServer, Object object, boolean useQuotes, boolean usePassthru) {
        String text = "";
        if (object != null) {
            if (object instanceof IColumn) {
                IColumn col = (IColumn)object;
                if (col.getTable() == null) {
                    return "";
                }
                text = this.isUseSQLSyntax() ? (col instanceof IAliasColumn ? ((IAliasColumn)col).getFullColumnName(useQuotes, usePassthru, this.m_query) : (this.m_query.getTargetTable() == col.getTable() || this.isColumnNameOnly(col) ? col.getColumnName(useQuotes, usePassthru) : col.getFullColumnName(useQuotes, usePassthru))) : col.getColumnName(useQuotes, usePassthru);
            } else if (object instanceof ITable) {
                ITable table = (ITable)object;
                if (table instanceof IPhysicalTable) {
                    if (this.isUseSQLSyntax()) {
                        try {
                            text = table.getFullNameQuotedAsNeeded(currentServer, useQuotes, usePassthru);
                        }
                        catch (BadLibraryDefinitionException e) {
                            ModelLogger.getDefaultLogger().error((Object)"BadlibraryDefinitionException", (Throwable)e);
                        }
                    } else {
                        text = ((IPhysicalTable)table).getTableName(useQuotes, usePassthru);
                    }
                } else if (table instanceof IExternalTable) {
                    String extName = table.getName();
                    text = !useQuotes ? extName : "\"" + extName + "\"n";
                }
            }
        }
        return text;
    }

    private boolean isColumnNameOnly(IColumn col) {
        IPhysicalTable targetTable;
        boolean isOnly = false;
        String upateTRANSFORMATION_CLASS = "com.sas.wadmin.transforms.sql.update.SQLUpdate";
        if (this.m_query != null && this.m_query.getTransformModel() != null && upateTRANSFORMATION_CLASS == this.m_query.getTransformModel().getType() && this.m_query.getTransformModel().getDataTargets() != null && this.m_query.getTransformModel().getDataTargets().length > 0 && (targetTable = (IPhysicalTable)this.m_query.getTransformModel().getDataTargets()[0]) == col.getTable() && targetTable.getLibrary() != null && targetTable.getLibrary().getDBMSType().getDBMSTypeID() == 1) {
            isOnly = true;
        }
        return isOnly;
    }
}

