/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DBMSTypeFactory;
import com.sas.etl.models.data.dbmstypes.HADOOPType;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.SASHDATType;
import com.sas.etl.models.data.dbmstypes.SASIOIMPType;
import com.sas.etl.models.data.dbmstypes.SASIOLAType;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.data.impl.TableUtil;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingRule;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLSetOperatorsTransform;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISetOperator;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.impl.AbstractSQLTransform;
import com.sas.etl.models.job.transforms.sql.impl.BaseQuery;
import com.sas.etl.models.job.transforms.sql.impl.ClauseType;
import com.sas.etl.models.job.transforms.sql.impl.RB;
import com.sas.etl.models.job.transforms.sql.impl.SelectResultsContainer;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ICondition;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SQLSetOperatorsTransformModel
extends AbstractSQLTransform
implements ISQLSetOperatorsTransform {
    private static final String TRANSFORMATION_CLASS = "job.transforms.SQLSetOperatorsTransformModel";
    private static final String TRANSFORMATION_ROLE = "job.transforms.SQLSetOperatorsTransformModel";
    private static final String ARM_DISPLAY_NAME = "SQLSetOperators";
    private ModelList m_lSetOperators;
    private static final String PROPERTY_NAME_PASSTHRU = "PASSTHRU";
    private static final String PROPERTY_NAME_TARGET_PASSTHRU = "TARGETPASSTHRU";
    private static final String PROPERTY_NAME_SQL_OPTIONS = "ADDITIONALSQLOPTIONS";
    private static final String PROPERTY_NAME_BUFFER_SIZE = "buffersize";
    private static final String PROPERTY_NAME_INOBS = "inobs";
    private static final String PROPERTY_NAME_OUTOBS = "outobs";
    private static final String PROPERTY_NAME_THREADS = "threads";
    private static final String PROPERTY_NAME_SPDS_OPTIONS = "AdditionalSPDSOptions";
    private static final String PROPERTY_NAME_PRETARGETPASSTHRUACTION = "preTargetPassthruAction";
    private static final String PROPERTY_NAME_DEBUG = "DEBUG";
    private static final String OPTIONS_TRUE = "YES";
    private static final String OPTIONS_FALSE = "NO";
    private static final boolean DEFAULT_TARGET_PASSTHRU = true;
    private static final boolean DEFAULT_MAGIC = false;
    private boolean m_bTargetIsPassThru;
    private String m_sPreTargetPassThruAction;
    private String m_sSQLOptions;
    private boolean m_bSuggestSortMergeJoin;
    private String m_sBufferSize;
    private String m_sMaxInputRows;
    private String m_sMaxOutputRows;
    private String m_sThreads;
    private String m_sSPDSParallelJoin;
    private String m_sSPDSOptions;
    private String m_sCreateDescription;
    private boolean m_bIsDebug;
    private boolean m_bSPDSTables;
    private boolean m_bTargetPassThruEnabled;
    private boolean m_bIsReplacingSourceTable;
    private boolean m_bIsLoading;

    public SQLSetOperatorsTransformModel(String sid, IModel model) {
        super(sid, model);
        this.createConditionActionSetTemplates();
        this.m_lSetOperators = new ModelList(this, new String[]{"SQLSetOperatorsTransformModel:SetOperatorAdded", "SQLSetOperatorsTransformModel:SetOperatorRemoved", "SQLSetOperatorsTransformModel:SetOperatorMoved"}, 3, ISetOperator.class);
        this.m_bSuggestSortMergeJoin = false;
        this.m_bTargetIsPassThru = true;
        this.m_sBufferSize = "";
        this.m_sMaxInputRows = "";
        this.m_sMaxOutputRows = "";
        this.m_sSPDSOptions = "";
        this.m_sSQLOptions = "";
        this.m_sCreateDescription = "";
        this.m_sSPDSParallelJoin = "systemdefault";
        this.m_sPreTargetPassThruAction = "delete";
        this.m_sThreads = "systemdefault";
        this.m_bSPDSTables = false;
        this.m_bTargetPassThruEnabled = false;
        this.setPassThruEnabled(false);
        this.setDBMSType(DBMSTypeFactory.getDefaultType());
        this.m_bIsReplacingSourceTable = false;
        this.m_bIsLoading = false;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_lSetOperators.isChanged();
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && (this.isUsingUserWrittenCode() || this.m_lSetOperators.isComplete());
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (!this.isUsingUserWrittenCode() && !this.m_lSetOperators.isComplete()) {
            lReasons.addAll(this.m_lSetOperators.getReasonsIncomplete());
        }
        return lReasons;
    }

    public ISetOperator createNewSetOperator() {
        ISetOperator operator = this.getModel().getObjectFactory().createNewSQLSetOperator(this.getID());
        operator.setOwner(this);
        return operator;
    }

    public ISetOperator createNewSetOperatorAndAddToList(IQuery query) {
        ISetOperator oSetOperator = this.createNewSetOperator();
        this.m_lSetOperators.add(oSetOperator);
        int index = this.m_lSetOperators.indexOf(oSetOperator);
        if (index > 0) {
            ISetOperator prevOperator = (ISetOperator)this.m_lSetOperators.get(index - 1);
            oSetOperator.setFirstQuery(prevOperator.getSecondQuery());
            oSetOperator.setSecondQuery(query);
        } else {
            oSetOperator.setFirstQuery(query);
        }
        return oSetOperator;
    }

    public IQuery createNewQuery() {
        IQuery query = this.getModel().getObjectFactory().createNewSQLQuery(this.getID());
        query.setTransformModel(this);
        query.setSelectResults(new SelectResultsContainer(query.getID(), this.getModel(), query));
        if (this.getTargetTables().length > 0) {
            query.setTargetTable(this.getTargetTables()[0]);
        }
        return query;
    }

    public IQuery createNewQuery(ITable table) {
        IQuery query = this.createNewQuery();
        query.setSourceOfFrom(query.addQuerySourceTable(table));
        return query;
    }

    public void addQueryToASetOperator(IQuery query) {
        boolean wasAdded = false;
        for (int i = 0; i < this.m_lSetOperators.size(); ++i) {
            ISetOperator oSetOperator = (ISetOperator)this.m_lSetOperators.get(i);
            if (oSetOperator.getFirstQuery() == null) {
                oSetOperator.setFirstQuery(query);
                wasAdded = true;
                break;
            }
            if (oSetOperator.getSecondQuery() != null) continue;
            oSetOperator.setSecondQuery(query);
            wasAdded = true;
            break;
        }
        if (!wasAdded) {
            this.createNewSetOperatorAndAddToList(query);
        }
    }

    @Override
    public ISetOperator[] getSetOperatorObjects() {
        return (ISetOperator[])this.m_lSetOperators.toArray(new ISetOperator[this.m_lSetOperators.size()]);
    }

    @Override
    public List getSetOperatorsList() {
        return this.m_lSetOperators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveUp(IQuery query, ISetOperator operator) {
        this.startCompoundUndoable();
        try {
            IQuery firstQuery = operator.getFirstQuery();
            operator.setFirstQuery(query);
            operator.setSecondQuery(firstQuery);
            int index = this.m_lSetOperators.indexOf(operator);
            if (index - 1 > -1) {
                ISetOperator prevOperator = (ISetOperator)this.m_lSetOperators.get(index - 1);
                prevOperator.setSecondQuery(query);
            }
            if (index + 1 <= this.m_lSetOperators.size() - 1) {
                ISetOperator nextOperator = (ISetOperator)this.m_lSetOperators.get(index + 1);
                nextOperator.setFirstQuery(firstQuery);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveDown(IQuery query, ISetOperator operator) {
        this.startCompoundUndoable();
        try {
            IQuery secondQuery = operator.getSecondQuery();
            operator.setFirstQuery(secondQuery);
            operator.setSecondQuery(query);
            int index = this.m_lSetOperators.indexOf(operator);
            if (index + 1 <= this.m_lSetOperators.size() - 1) {
                ISetOperator nextOperator = (ISetOperator)this.m_lSetOperators.get(index + 1);
                nextOperator.setFirstQuery(query);
            }
            if (index - 1 > -1) {
                ISetOperator prevOperator = (ISetOperator)this.m_lSetOperators.get(index - 1);
                prevOperator.setSecondQuery(secondQuery);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addDataSource(int iSource, IDataObject source) {
        if (!this.containsInDataSources(source) && source != null) {
            super.addDataSource(iSource, source);
        }
    }

    @Override
    protected void preAddDataSource(IDataObject source) {
        super.preAddDataSource(source);
        if (this.m_bIsLoading) {
            return;
        }
        if (!this.m_bIsReplacingSourceTable) {
            this.addQueryToASetOperator(this.createNewQuery((ITable)source));
        }
    }

    @Override
    protected void postAddDataSource(IDataObject source) {
        super.postAddDataSource(source);
        this.updateSourceTableTypesAttributes();
        this.updateDBMSType();
    }

    @Override
    protected void postAddDataTarget(IDataObject target) {
        super.postAddDataTarget(target);
        List<IQuery> queries = this.getAllQueries();
        for (int i = 0; i < queries.size(); ++i) {
            IQuery query = queries.get(i);
            query.setTargetTable((ITable)target);
        }
        this.updateTargetTableTypesAttributes();
    }

    @Override
    protected void preRemoveDataSource(IDataObject source) {
        super.preRemoveDataSource(source);
        this.updateSourceTableTypesAttributes();
        if (!this.m_bIsReplacingSourceTable) {
            List<IQuery> lQueries = this.findQueriesContainingSourceTable(source);
            for (int i = 0; i < lQueries.size(); ++i) {
                this.removeQuery(lQueries.get(i));
            }
            this.cleanUpSetOperators();
        }
    }

    @Override
    protected void postRemoveDataSource(IDataObject source) {
        super.postRemoveDataSource(source);
        this.updateSourceTableTypesAttributes();
        this.updateDBMSType();
    }

    @Override
    public void removeDataSource(IDataObject source) {
        if (source instanceof ISourceTable) {
            source = ((ISourceTable)source).getAliasedTable();
        }
        super.removeDataSource(source);
    }

    @Override
    public void removeConnectedSource(IDataObject source) {
        if (source instanceof ISourceTable) {
            source = ((ISourceTable)source).getAliasedTable();
        }
        super.removeConnectedSource(source);
    }

    @Override
    protected void postRemoveDataTarget(IDataObject target) {
        super.postRemoveDataTarget(target);
        List<IQuery> queries = this.getAllQueries();
        for (int i = 0; i < queries.size(); ++i) {
            IQuery query = queries.get(i);
            query.setTargetTable(null);
        }
        this.updateTargetTableTypesAttributes();
    }

    @Override
    public void notify(NotifyEvent ev) {
        Object obj = ev.getSource();
        ModelEvent mdEv = ev.getModelEvent();
        if (mdEv != null) {
            String sType = mdEv.getType();
            if (obj instanceof IPhysicalTable && "PhysicalTable:LibraryChanged".equals(sType)) {
                List<ISourceTable> srcs = this.getSourceTablesContainingTable((IPhysicalTable)obj);
                for (int i = 0; i < srcs.size(); ++i) {
                    if (srcs.get(i).isMoveTableToUploadLibrary()) continue;
                    this.updateSourceTableTypesAttributes();
                    this.updateDBMSType();
                }
                if (obj == this.getDataTarget()) {
                    this.updateTargetTableTypesAttributes();
                }
            }
        }
        super.notify(ev);
    }

    private void cleanUpSetOperators() {
        for (int i = this.m_lSetOperators.size() - 1; i >= 0; --i) {
            ISetOperator operator = (ISetOperator)this.m_lSetOperators.get(i);
            if (operator.getFirstQuery() != null || operator.getSecondQuery() != null) continue;
            this.m_lSetOperators.remove(operator);
        }
    }

    private void removeQuery(IQuery query) {
        boolean breorder = false;
        for (int i = 0; i < this.m_lSetOperators.size(); ++i) {
            ISetOperator operator = (ISetOperator)this.m_lSetOperators.get(i);
            if (operator.getFirstQuery() == query && i == 0) {
                operator.setFirstQuery(null);
                breorder = true;
                break;
            }
            if (operator.getSecondQuery() != query) continue;
            operator.setSecondQuery(null);
            if (i + 1 > this.m_lSetOperators.size() - 1) continue;
            ISetOperator nextOperator = (ISetOperator)this.m_lSetOperators.get(i + 1);
            IQuery firstQuery = operator.getFirstQuery();
            operator.setFirstQuery(null);
            nextOperator.setFirstQuery(firstQuery);
        }
    }

    @Override
    public void addToTransformsDeletedObjects(IPersistableObject obj) {
        this.addToDeletedObjects(obj);
    }

    @Override
    public void removeFromTransformsDeletedObjects(IPersistableObject obj) {
        this.removeFromDeletedObjects(obj);
    }

    private List<ISourceTable> getSourceTablesContainingTable(IPhysicalTable table) {
        ArrayList<ISourceTable> lSources = new ArrayList<ISourceTable>();
        List<IQuery> lQueries = this.findQueriesContainingSourceTable(table);
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            if (query.getQuerySourceTableCount() <= 0) continue;
            lSources.add(query.getQueryOnlySourceTables()[0]);
        }
        return lSources;
    }

    private List<IQuery> findQueriesContainingSourceTable(IDataObject source) {
        ArrayList<IQuery> lQueries = new ArrayList<IQuery>();
        for (int i = 0; i < this.m_lSetOperators.size(); ++i) {
            ISetOperator operator = (ISetOperator)this.m_lSetOperators.get(i);
            if (operator.getFirstQueryTable() != null && operator.getFirstQueryTable().containsAliasedTable((ITable)source)) {
                lQueries.add(operator.getFirstQuery());
            }
            if (operator.getSecondQueryTable() == null || !operator.getSecondQueryTable().containsAliasedTable((ITable)source)) continue;
            lQueries.add(operator.getSecondQuery());
        }
        return lQueries;
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        super.addDefaultSettings();
        this.addNewWorkTable();
    }

    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            IWorkTable workTable = super.addNewWorkTable();
            workTable.setView(true);
            IWorkTable iWorkTable = workTable;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public static String getTransformTypeID() {
        return "job.transforms.SQLSetOperatorsTransformModel";
    }

    @Override
    protected String getTransformClass() {
        return "job.transforms.SQLSetOperatorsTransformModel";
    }

    @Override
    protected String getTransformRole() {
        return "job.transforms.SQLSetOperatorsTransformModel";
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("SQLSetOperatorsTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("SQLSetOperatorsTransformModel.Name.txt");
    }

    @Override
    protected int getMaximumDataSourceCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        mdoCM.setTransformRole(ARM_DISPLAY_NAME);
        AssociationList tranSrcs = mdoCM.getTransformationSources(false);
        tranSrcs.clear();
        this.m_lSetOperators.saveToOMR(omr, (List)tranSrcs);
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_PASSTHRU, this.isPassThru());
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_TARGET_PASSTHRU, this.isTargetPassThru());
        this.saveStringOptionToOMR(omr, PROPERTY_NAME_BUFFER_SIZE, this.getBufferSize());
        this.saveStringOptionToOMR(omr, PROPERTY_NAME_INOBS, this.getMaxInputRows());
        this.saveStringOptionToOMR(omr, PROPERTY_NAME_OUTOBS, this.getMaxOutputRows());
        this.saveStringOptionToOMR(omr, PROPERTY_NAME_PRETARGETPASSTHRUACTION, this.getPreTargetPassThruAction());
        this.saveStringOptionToOMR(omr, PROPERTY_NAME_SPDS_OPTIONS, this.getSPDSOptions());
        this.saveStringOptionToOMR(omr, PROPERTY_NAME_SQL_OPTIONS, this.getSQLOptions());
        this.saveStringOptionToOMR(omr, PROPERTY_NAME_THREADS, this.getThreads());
        this.saveBooleanOptionToOMR(omr, PROPERTY_NAME_DEBUG, this.isDebug());
        this.setChanged(false);
    }

    @Override
    protected void saveMappingsToOMR(OMRAdapter omr, ClassifierMap mdoCM, ITable tblTarget) throws MdException, RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        this.m_bIsLoading = true;
        try {
            super.loadFromOMR(omr);
            this.m_lSetOperators.clear();
            TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
            AssociationList lTransforms = mdoStep.getTransformations();
            ClassifierMap mdoCM = null;
            if (!lTransforms.isEmpty()) {
                mdoCM = (ClassifierMap)lTransforms.get(0);
                Iterator lTranSrcs = mdoCM.getTransformationSources();
                this.m_lSetOperators.loadFromOMR(omr, (List)((Object)lTranSrcs));
                this.updateSourceTableTypesAttributes();
                this.updateTargetTableTypesAttributes();
                this.updateDBMSType();
            }
            for (Object operator : this.m_lSetOperators) {
                if (!(operator instanceof ISetOperator)) continue;
                ((ISetOperator)operator).setOwner(this);
            }
            List<IQuery> lQueries = this.getAllQueries();
            for (int i = 0; i < lQueries.size(); ++i) {
                IQuery query = lQueries.get(i);
                query.setTargetTable((ITable)this.getDataTarget());
                query.setTransformModel(this);
            }
            this.setPassThru(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_PASSTHRU, false));
            this.setTargetPassThru(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_TARGET_PASSTHRU, true));
            this.setBufferSize(this.loadStringOptionFromOMR(omr, PROPERTY_NAME_BUFFER_SIZE, ""));
            this.setMaxInputRows(this.loadStringOptionFromOMR(omr, PROPERTY_NAME_INOBS, ""));
            this.setMaxOutputRows(this.loadStringOptionFromOMR(omr, PROPERTY_NAME_OUTOBS, ""));
            this.setPreTargetPassThruAction(this.loadStringOptionFromOMR(omr, PROPERTY_NAME_PRETARGETPASSTHRUACTION, "delete"));
            this.setSPDSOptions(this.loadStringOptionFromOMR(omr, PROPERTY_NAME_SPDS_OPTIONS, ""));
            this.setSQLOptions(this.loadStringOptionFromOMR(omr, PROPERTY_NAME_SQL_OPTIONS, ""));
            this.setThreads(this.loadStringOptionFromOMR(omr, PROPERTY_NAME_THREADS, "systemdefault"));
            this.setIsDebug(this.loadBooleanOptionFromOMR(omr, PROPERTY_NAME_DEBUG, false));
            if (this.isOperatorsOutOfOrder()) {
                this.reOrderSetOperators();
            }
            this.setChanged(false);
        }
        finally {
            this.m_bIsLoading = false;
        }
    }

    private boolean isOperatorsOutOfOrder() {
        if (this.m_lSetOperators.size() > 1) {
            IQuery firstQuery = null;
            for (int i = 0; i < this.m_lSetOperators.size(); ++i) {
                ISetOperator nextOperator;
                IQuery nextFirstQuery;
                ISetOperator setOperator = (ISetOperator)this.m_lSetOperators.get(i);
                if (i == 0) {
                    firstQuery = setOperator.getFirstQuery();
                }
                IQuery secondQuery = setOperator.getSecondQuery();
                if (i + 1 > this.m_lSetOperators.size() - 1 || (nextFirstQuery = (nextOperator = (ISetOperator)this.m_lSetOperators.get(i + 1)).getFirstQuery()) == secondQuery && (nextFirstQuery == null || firstQuery != nextFirstQuery)) continue;
                return true;
            }
        }
        return false;
    }

    private void reOrderSetOperators() {
        block10: {
            int i;
            ArrayList<ISetOperator> orderedList;
            block9: {
                ModelLogger.getDefaultLogger().debug((Object)"SQLSetOperatorsTransformModel:SetOperators order is invalid, reorder occuring");
                ArrayList<String> predecessorIDs = new ArrayList<String>();
                ArrayList<String> successorIDs = new ArrayList<String>();
                for (int i2 = 0; i2 < this.m_lSetOperators.size(); ++i2) {
                    ISetOperator operator = (ISetOperator)this.m_lSetOperators.get(i2);
                    if (operator.getFirstQuery() != null) {
                        predecessorIDs.add(operator.getFirstQuery().getID());
                    } else {
                        predecessorIDs.add("");
                    }
                    if (operator.getSecondQuery() != null) {
                        successorIDs.add(operator.getSecondQuery().getID());
                        continue;
                    }
                    successorIDs.add("");
                }
                orderedList = new ArrayList<ISetOperator>();
                ISetOperator firstOne = null;
                for (i = 0; i < predecessorIDs.size(); ++i) {
                    int index = successorIDs.indexOf(predecessorIDs.get(i));
                    if (index != -1) continue;
                    firstOne = (ISetOperator)this.m_lSetOperators.get(i);
                    break;
                }
                if (firstOne != null) {
                    orderedList.add(firstOne);
                    IQuery query = firstOne.getSecondQuery();
                    while (orderedList.size() < this.m_lSetOperators.size()) {
                        ISetOperator operator;
                        String successorID = "";
                        if (query == null) break;
                        successorID = query.getID();
                        int index = predecessorIDs.indexOf(successorID);
                        if (index <= -1 || orderedList.contains(operator = (ISetOperator)this.m_lSetOperators.get(index))) continue;
                        orderedList.add(operator);
                        query = operator.getSecondQuery();
                    }
                }
                if (orderedList.size() != this.m_lSetOperators.size()) break block9;
                this.m_lSetOperators.clear();
                for (i = 1; i < orderedList.size(); ++i) {
                    this.m_lSetOperators.add(orderedList.get(i));
                }
                break block10;
            }
            if (orderedList.size() <= 0) break block10;
            for (i = 0; i < orderedList.size(); ++i) {
                ISetOperator operator = (ISetOperator)orderedList.get(i);
                this.m_lSetOperators.remove(operator);
                this.m_lSetOperators.add(i, operator);
            }
        }
    }

    @Override
    public void delete() {
        this.m_lSetOperators.delete();
        super.delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        this.m_lSetOperators.deleteFromOMR(omr);
        super.deleteFromOMR(omr);
    }

    @Override
    public IColumn[] updateMappedColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget) {
        IQuery query = this.getQuery();
        if (query != null) {
            return query.getSelectResults().updateMappedColumnsToTargetTable(aSourceColumns, tblTarget);
        }
        return new IColumn[0];
    }

    @Override
    public IColumn[] updateMappedColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns) {
        ArrayList<IColumn> lColumns = new ArrayList<IColumn>();
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            IColumn[] columns = query.getSelectResults().updateMappedColumnsToSourceTable(tblSource, aTargetColumns);
            lColumns.addAll(Arrays.asList(columns));
        }
        return lColumns.toArray(new IColumn[lColumns.size()]);
    }

    @Override
    public void mapColumns() {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().mapColumns();
        }
    }

    @Override
    public void mapColumns(ITable tblSource, ITable tblTarget) {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().mapColumns(tblSource, tblTarget);
        }
    }

    @Override
    public void mapColumns(IColumn[] aSources, IColumn[] aTargets) {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().mapColumns(aSources, aTargets);
        }
    }

    @Override
    public void mapColumns(IMappingRule[] aRules) {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().mapColumns(aRules);
        }
    }

    @Override
    public void mapColumns(ITable tblSource, ITable tblTarget, IMappingRule[] aRules) {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().mapColumns(tblSource, tblTarget, aRules);
        }
    }

    @Override
    public void mapColumns(IColumn[] aSources, IColumn[] aTargets, IMappingRule[] aRules) {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().mapColumns(aSources, aTargets, aRules);
        }
    }

    @Override
    public void propagateColumnsToSourceTables() {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().propagateColumnsToSourceTables();
        }
    }

    @Override
    public void propagateColumnsToSourceTables(int eNonWorkTableHandling) {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().propagateColumnsToSourceTables(eNonWorkTableHandling);
        }
    }

    @Override
    public void propagateColumnsToSourceTables(ITable[] aSourceTables, ITable[] aTargetTables) {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().propagateColumnsToSourceTables(aSourceTables, aTargetTables);
        }
    }

    @Override
    public void propagateColumnsToSourceTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().propagateColumnsToSourceTables(aSourceTables, aTargetTables);
        }
    }

    @Override
    public void propagateColumnsToTargetTables() {
        IQuery query = this.getQuery();
        if (query != null) {
            query.getSelectResults().propagateColumnsToTargetTables();
        }
    }

    @Override
    public void propagateColumnsToTargetTables(int eNonWorkTableHandling) {
        IQuery query = this.getQuery();
        if (query != null) {
            query.getSelectResults().propagateColumnsToTargetTables(eNonWorkTableHandling);
        }
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables) {
        IQuery query = this.getQuery();
        if (query != null) {
            query.getSelectResults().propagateColumnsToTargetTables(aSourceTables, aTargetTables);
        }
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        IQuery query = this.getQuery();
        if (query != null) {
            query.getSelectResults().propagateColumnsToTargetTables(aSourceTables, aTargetTables, eNonWorkTableHandling);
        }
    }

    @Override
    public IColumn[] propagateColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns) {
        ArrayList<IColumn> lColumns = new ArrayList<IColumn>();
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            IColumn[] columns = query.getSelectResults().propagateColumnsToSourceTable(tblSource, aTargetColumns);
            lColumns.addAll(Arrays.asList(columns));
        }
        return lColumns.toArray(new IColumn[lColumns.size()]);
    }

    @Override
    public IColumn[] propagateColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns, int eNonWorkTableHandling) {
        ArrayList<IColumn> lColumns = new ArrayList<IColumn>();
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            IColumn[] columns = query.getSelectResults().propagateColumnsToSourceTable(tblSource, aTargetColumns, eNonWorkTableHandling);
            lColumns.addAll(Arrays.asList(columns));
        }
        return lColumns.toArray(new IColumn[lColumns.size()]);
    }

    @Override
    public IColumn[] propagateColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget) {
        IQuery query = this.getQuery();
        if (query != null) {
            return query.getSelectResults().propagateColumnsToTargetTable(aSourceColumns, tblTarget);
        }
        return new IColumn[0];
    }

    @Override
    public IColumn[] propagateColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget, int eNonWorkTableHandling) {
        IQuery query = this.getQuery();
        if (query != null) {
            return query.getSelectResults().propagateColumnsToTargetTable(aSourceColumns, tblTarget, eNonWorkTableHandling);
        }
        return new IColumn[0];
    }

    @Override
    public void replaceSourceColumns(IColumn[] aOldColumns, IColumn[] aNewColumns) {
        if (aOldColumns.length > 0) {
            ITable table = aOldColumns[0].getTable();
            if (table instanceof ISourceTable) {
                table = ((ISourceTable)table).getAliasedTable();
            }
            List<IQuery> lQueries = this.findQueriesContainingSourceTable(table);
            for (int i = 0; i < lQueries.size(); ++i) {
                IQuery query = lQueries.get(i);
                query.getSelectResults().replaceSourceColumns(aOldColumns, aNewColumns);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            this.m_bIsReplacingSourceTable = true;
            super.replaceSourceTable(oldTable, newTable, columnsMap);
            List<IQuery> aQueries = this.findQueriesContainingSourceTable(oldTable);
            for (int i = 0; i < aQueries.size(); ++i) {
                IQuery query = aQueries.get(i);
                ISourceTable[] sources = query.getQuerySourceTables();
                if (sources.length <= 0) continue;
                ISourceTable newSource = this.getModel().getObjectFactory().createNewSQLSourceTable(this.getID());
                newSource.setAliasedTable(newTable);
                query.replaceTableColumns(sources[0], newSource);
                query.removeQuerySourceTable(sources[0]);
                query.addQuerySourceTable(newSource);
                query.setSourceOfFrom(newSource);
            }
        }
        finally {
            this.endCompoundUndoable();
            this.m_bIsReplacingSourceTable = false;
        }
    }

    @Override
    protected void replaceSourceMappings(ITable oldTable, ITable newTable, Map columnsMap) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            super.replaceTargetTable(oldTable, newTable, columnsMap);
            List<IQuery> aQueries = this.getAllQueries();
            for (int i = 0; i < aQueries.size(); ++i) {
                IQuery query = aQueries.get(i);
                query.setTargetTable(newTable);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceTargetMappings(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            List<IQuery> lQueries = this.getAllQueries();
            for (int i = 0; i < lQueries.size(); ++i) {
                IMapping mapping;
                int iMap;
                IQuery query = lQueries.get(i);
                ArrayList<IMapping> lChangedMappings = new ArrayList<IMapping>();
                IMapping[] aMappings = query.getSelectResults().getMappings();
                IColumn[] aNewColumns = newTable.getColumns();
                for (iMap = 0; iMap < aMappings.length; ++iMap) {
                    mapping = aMappings[iMap];
                    IColumn[] aColumns = mapping.getTargets();
                    block5: for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                        IColumn column = aColumns[iColumn];
                        if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                            mapping.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                            lChangedMappings.add(mapping);
                            continue;
                        }
                        if (!oldTable.containsColumn(column)) {
                            lChangedMappings.add(mapping);
                            continue;
                        }
                        boolean bCaseSenistive = this.isQuotingNeeded() || newTable.isQuoted();
                        for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                            IColumn newColumn = aNewColumns[iNewColumn];
                            if (!column.equalsName(newColumn, bCaseSenistive) || column.getLength() < newColumn.getLength() || column.getType() != newColumn.getType()) continue;
                            mapping.replaceTargetColumn(column, newColumn);
                            lChangedMappings.add(mapping);
                            continue block5;
                        }
                    }
                }
                for (iMap = 0; iMap < aMappings.length; ++iMap) {
                    mapping = aMappings[iMap];
                    if (lChangedMappings.indexOf(mapping) != -1 || mapping.getType() != "ONETOONE") continue;
                    this.removeMapping(mapping);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void replaceTargetColumns(IColumn[] aOldColumns, IColumn[] aNewColumns) {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().replaceTargetColumns(aOldColumns, aNewColumns);
        }
    }

    @Override
    public void removeSourceTableFromMappings(ITable tbl) {
        if (tbl instanceof ISourceTable) {
            tbl = ((ISourceTable)tbl).getAliasedTable();
        }
        List<IQuery> lQueries = this.findQueriesContainingSourceTable(tbl);
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().removeSourceTableFromMappings(tbl);
        }
    }

    @Override
    public void removeSourceColumnFromMappings(IColumn column) {
        if (column != null) {
            ITable table = column.getTable();
            if (table instanceof ISourceTable) {
                table = ((ISourceTable)table).getAliasedTable();
            }
            List<IQuery> lQueries = this.findQueriesContainingSourceTable(table);
            for (int i = 0; i < lQueries.size(); ++i) {
                IQuery query = lQueries.get(i);
                query.getSelectResults().removeSourceColumnFromMappings(column);
            }
        }
    }

    @Override
    public void removeTargetTableFromMappings(ITable tbl) {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().removeTargetTableFromMappings(tbl);
        }
    }

    @Override
    public void removeTargetColumnFromMappings(IColumn column) {
        List<IQuery> lQueries = this.getAllQueries();
        for (int i = 0; i < lQueries.size(); ++i) {
            IQuery query = lQueries.get(i);
            query.getSelectResults().removeTargetColumnFromMappings(column);
        }
    }

    @Override
    public List getMappingsList() {
        if (this.getQuery() != null) {
            return this.getQuery().getSelectResults().getMappingsList();
        }
        return new ArrayList();
    }

    @Override
    public IMapping addMapping(IColumn[] aSources, IColumn[] aTargets) {
        if (this.getQuery() != null) {
            return this.getQuery().getSelectResults().addMapping(aSources, aTargets);
        }
        return null;
    }

    @Override
    public IMapping addMapping(IColumn[] aSourceColumns, IColumn[] aTargetColumns, String sType, IExpression oExpression) {
        if (this.getQuery() != null) {
            return this.getQuery().getSelectResults().addMapping(aSourceColumns, aTargetColumns, sType, oExpression);
        }
        return null;
    }

    @Override
    public void addMapping(IMapping mapping) {
        if (this.getQuery() != null) {
            this.getQuery().getSelectResults().addMapping(mapping);
        }
    }

    @Override
    public void addMapping(int iMapping, IMapping mapping) {
        if (this.getQuery() != null) {
            this.getQuery().getSelectResults().addMapping(iMapping, mapping);
        }
    }

    @Override
    public void removeMapping(IMapping mapping) {
        if (this.getQuery() != null) {
            this.getQuery().getSelectResults().removeMapping(mapping);
        }
    }

    @Override
    public boolean containsMapping(IMapping mapping) {
        if (this.getQuery() != null) {
            return this.getQuery().getSelectResults().containsMapping(mapping);
        }
        return false;
    }

    @Override
    public IColumn[] getColumnsExcludedFromMapping() {
        if (this.getQuery() != null) {
            return this.getQuery().getSelectResults().getColumnsExcludedFromMapping();
        }
        return new IColumn[0];
    }

    @Override
    public List getListOfColumnsExcludedFromMapping() {
        if (this.getQuery() != null) {
            return this.getQuery().getSelectResults().getListOfColumnsExcludedFromMapping();
        }
        return new ArrayList();
    }

    @Override
    public IColumn[] getColumnsExcludedFromPropagation() {
        if (this.getQuery() != null) {
            return this.getQuery().getSelectResults().getColumnsExcludedFromPropagation();
        }
        return new IColumn[0];
    }

    @Override
    public List getListOfColumnsExcludedFromPropagation() {
        if (this.getQuery() != null) {
            return this.getQuery().getSelectResults().getListOfColumnsExcludedFromPropagation();
        }
        return new ArrayList();
    }

    @Override
    public void connectDataSource(IDataObject table, int portIndex) {
    }

    @Override
    public void disconnectDataSource(IDataObject table, int portIndex) {
    }

    @Override
    public ISourceTable[] getAllQuerySourceTables() {
        ArrayList<ISourceTable> lAllQuerySources = new ArrayList<ISourceTable>();
        if (this.m_lSetOperators != null) {
            for (int i = 0; i < this.m_lSetOperators.size(); ++i) {
                ISourceTable table;
                ISetOperator setOperator = (ISetOperator)this.m_lSetOperators.get(i);
                if (setOperator.getFirstQueryTable() != null && !lAllQuerySources.contains(table = setOperator.getFirstQueryTable())) {
                    lAllQuerySources.add(table);
                }
                if (setOperator.getSecondQueryTable() == null || lAllQuerySources.contains(table = setOperator.getSecondQueryTable())) continue;
                lAllQuerySources.add(table);
            }
        }
        return lAllQuerySources.toArray(new ISourceTable[lAllQuerySources.size()]);
    }

    private List<IQuery> getAllQueries() {
        ArrayList<IQuery> lQueries = new ArrayList<IQuery>();
        for (int i = 0; i < this.m_lSetOperators.size(); ++i) {
            IQuery query;
            ISetOperator setOperator = (ISetOperator)this.m_lSetOperators.get(i);
            if (setOperator.getFirstQueryTable() != null && !lQueries.contains(query = setOperator.getFirstQuery())) {
                lQueries.add(query);
            }
            if (setOperator.getSecondQueryTable() == null || lQueries.contains(query = setOperator.getSecondQuery())) continue;
            lQueries.add(query);
        }
        return lQueries;
    }

    @Override
    public void setCreateDescription(String sCreateDescripion) {
        if (this.m_sCreateDescription.equals(sCreateDescripion)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCreateDescriptionUndoable(this.m_sCreateDescription, sCreateDescripion));
        }
        this.m_sCreateDescription = sCreateDescripion;
        this.fireModelChangedEvent("SQLJoinTransformMOdel:CreateDescriptionChanged", null);
    }

    @Override
    public String getCreateDescription() {
        return this.m_sCreateDescription;
    }

    @Override
    public void setSQLOptions(String sOptions) {
        if (this.m_sSQLOptions.equals(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSQLOptionsUndoable(this.m_sSQLOptions, sOptions));
        }
        this.m_sSQLOptions = sOptions;
        this.fireModelChangedEvent("SQLJoinTransformModel:SqlOptionsChanged", null);
    }

    @Override
    public String getSQLOptions() {
        return this.m_sSQLOptions;
    }

    @Override
    public void setTargetPassThru(boolean bTargetPassThru) {
        if (this.m_bTargetIsPassThru == bTargetPassThru) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTargetPassThruUndoable(this.m_bTargetIsPassThru, bTargetPassThru));
        }
        this.m_bTargetIsPassThru = bTargetPassThru;
        this.fireModelChangedEvent("SQLJoinTransformModel:TargetPassThroughChanged", null);
        this.updateTargetTableTypesAttributes();
    }

    @Override
    public boolean isTargetPassThru() {
        return this.m_bTargetIsPassThru;
    }

    public boolean isValidAsSourceTable(IDataObject source) {
        if (source == null) {
            return false;
        }
        IDBMSType dbmsType = ((IPhysicalTable)source).getDBMSType();
        boolean isDisallowedType = dbmsType instanceof SASHDATType || dbmsType instanceof SASIOLAType;
        return source instanceof IPhysicalTable && !isDisallowedType;
    }

    @Override
    public void setPreTargetPassThruAction(String sPreTargetPassThruAction) {
        if (this.m_sPreTargetPassThruAction.equals(sPreTargetPassThruAction)) {
            return;
        }
        if (!Arrays.asList(PRETARGET_PASSTHRU_VALUES).contains(sPreTargetPassThruAction)) {
            ModelLogger.getDefaultLogger().debug((Object)("Invalid value has been given, " + sPreTargetPassThruAction + ", forcing the value to be the default."));
            if (this.m_sPreTargetPassThruAction.equalsIgnoreCase("delete")) {
                return;
            }
            sPreTargetPassThruAction = "delete";
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPreTargetPassThruActionUndoable(this.m_sPreTargetPassThruAction, sPreTargetPassThruAction));
        }
        this.m_sPreTargetPassThruAction = sPreTargetPassThruAction;
        this.fireModelChangedEvent("SQLJoinTransformModel:TargetPassThroughActionChanged", null);
    }

    @Override
    public String getPreTargetPassThruAction() {
        return this.m_sPreTargetPassThruAction;
    }

    @Override
    public void setSuggestSortMergeJoin(boolean bSuggestSortMerge) {
        if (this.m_bSuggestSortMergeJoin == bSuggestSortMerge) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSuggestSortMergeJoinUndoable(this.m_bSuggestSortMergeJoin, bSuggestSortMerge));
        }
        this.m_bSuggestSortMergeJoin = bSuggestSortMerge;
        this.fireModelChangedEvent("SQLJoinTransformModel:SuggestSortMergeChanged", null);
    }

    @Override
    public boolean isSuggestSortMergeJoin() {
        return this.m_bSuggestSortMergeJoin;
    }

    @Override
    public boolean isValidateAvailable() {
        return true;
    }

    @Override
    public boolean isDebug() {
        return this.m_bIsDebug;
    }

    @Override
    public void setIsDebug(boolean bDebug) {
        if (this.m_bIsDebug == bDebug) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDebugUndoable(this.m_bIsDebug, bDebug));
        }
        this.m_bIsDebug = bDebug;
        this.fireModelChangedEvent("SQLJoinTransformModel:DebugChanged", null);
    }

    @Override
    public void setBufferSize(String sBufferSize) {
        if (this.m_sBufferSize.equals(sBufferSize)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetBufferSizeUndoable(this.m_sBufferSize, sBufferSize));
        }
        this.m_sBufferSize = sBufferSize;
        this.fireModelChangedEvent("SQLJoinTransformModel:BufferSizeChanged", null);
    }

    @Override
    public String getBufferSize() {
        return this.m_sBufferSize;
    }

    @Override
    public void setMaxInputRows(String sMaxInputRows) {
        if (this.m_sMaxInputRows.equals(sMaxInputRows)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMaxInputRowsUndoable(this.m_sMaxInputRows, sMaxInputRows));
        }
        this.m_sMaxInputRows = sMaxInputRows;
        this.fireModelChangedEvent("SQLJoinTransformModel:InObsChanged", null);
    }

    @Override
    public String getMaxInputRows() {
        return this.m_sMaxInputRows;
    }

    @Override
    public void setMaxOutputRows(String sMaxOutputRows) {
        if (this.m_sMaxOutputRows.equals(sMaxOutputRows)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMaxOutputRowsUndoable(this.m_sMaxOutputRows, sMaxOutputRows));
        }
        this.m_sMaxOutputRows = sMaxOutputRows;
        this.fireModelChangedEvent("SQLJoinTransformModel:OutobsChanged", null);
    }

    @Override
    public String getMaxOutputRows() {
        return this.m_sMaxOutputRows;
    }

    @Override
    public void setThreads(String sThreads) {
        if (this.m_sThreads.equals(sThreads)) {
            return;
        }
        if (!Arrays.asList(THREAD_VALUES).contains(sThreads)) {
            ModelLogger.getDefaultLogger().debug((Object)("An invalid value has been given, " + sThreads + ", forcing the value to be the default."));
            if (this.m_sThreads.equalsIgnoreCase("systemdefault")) {
                return;
            }
            sThreads = "systemdefault";
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetThreadsUndoable(this.m_sThreads, sThreads));
        }
        this.m_sThreads = sThreads;
        this.fireModelChangedEvent("SQLJoinTransformModel:ThreadsChanged", null);
    }

    @Override
    public String getThreads() {
        return this.m_sThreads;
    }

    @Override
    public void setSPDSParallelJoin(String sSPDSParallelJoin) {
        if (this.m_sSPDSParallelJoin.equals(sSPDSParallelJoin)) {
            return;
        }
        if (!Arrays.asList(SPDS_PARALLEL_VALUES).contains(sSPDSParallelJoin)) {
            ModelLogger.getDefaultLogger().debug((Object)("Invalid value has been given, " + sSPDSParallelJoin + ", forcing the value to be the default."));
            if (this.m_sSPDSParallelJoin.equalsIgnoreCase("systemdefault")) {
                return;
            }
            sSPDSParallelJoin = "systemdefault";
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSPDSParallelJoinUndoable(this.m_sSPDSParallelJoin, sSPDSParallelJoin));
        }
        this.m_sSPDSParallelJoin = sSPDSParallelJoin;
        this.fireModelChangedEvent("SQLJoinTransformModel:SpdsParallelJoinChanged", null);
    }

    @Override
    public String getSPDSParallelJoin() {
        return this.m_sSPDSParallelJoin;
    }

    @Override
    public void setSPDSOptions(String sSPDSOptions) {
        if (this.m_sSPDSOptions.equalsIgnoreCase(sSPDSOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSPDSOptionsUndoable(this.m_sSPDSOptions, sSPDSOptions));
        }
        this.m_sSPDSOptions = sSPDSOptions;
        this.fireModelChangedEvent("SQLJoinTransformModel:AdditionalSpdsOptionsChanged", null);
    }

    @Override
    public String getSPDSOptions() {
        return this.m_sSPDSOptions;
    }

    @Override
    public void setAutoJoinEnabled(boolean bAutoJoin) {
    }

    @Override
    public boolean isAutoJoinEnabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSourceTablesPassthruSupported() {
        try {
            ISourceTable[] sourceTables = this.getAllQuerySourceTables();
            for (int i = 0; i < sourceTables.length; ++i) {
                ISourceTable table = sourceTables[i];
                if (!table.isMoveTableToUploadLibrary()) continue;
                table.moveTable();
            }
            IPhysicalTable[] srcTables = new IPhysicalTable[sourceTables.length];
            boolean passthru = true;
            for (int i = 0; i < sourceTables.length; ++i) {
                ISourceTable table = sourceTables[i];
                if (!table.isPassThruSupported()) {
                    passthru = false;
                    continue;
                }
                srcTables[i] = (IPhysicalTable)table.getAliasedTable();
            }
            if (passthru) {
                try {
                    passthru = TableUtil.hasEqualDeployedComponents(this.getExecutionServer(), srcTables);
                }
                catch (BadLibraryDefinitionException e) {
                    ModelLogger.getDefaultLogger().debug((Object)"BadLibraryDefinitionException", (Throwable)e);
                }
            }
            boolean bl = passthru;
            return bl;
        }
        finally {
            this.fixMovedTables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateSourceTableTypesAttributes() {
        try {
            ISourceTable[] sourceTables = this.getAllQuerySourceTables();
            for (int i = 0; i < sourceTables.length; ++i) {
                ISourceTable table = sourceTables[i];
                if (!table.isMoveTableToUploadLibrary()) continue;
                table.moveTable();
            }
            IPhysicalTable[] srcTables = new IPhysicalTable[sourceTables.length];
            boolean spds = true;
            boolean passthru = true;
            for (int i = 0; i < sourceTables.length; ++i) {
                ISourceTable table = sourceTables[i];
                if (!table.isSPDSTable()) {
                    spds = false;
                }
                if (!table.isPassThruSupported()) {
                    passthru = false;
                    continue;
                }
                srcTables[i] = (IPhysicalTable)table.getAliasedTable();
            }
            if (passthru) {
                try {
                    passthru = TableUtil.hasEqualDeployedComponents(this.getExecutionServer(), srcTables);
                }
                catch (BadLibraryDefinitionException e) {
                    ModelLogger.getDefaultLogger().debug((Object)"BadLibraryDefinitionException", (Throwable)e);
                }
            }
            this.setSPDSTables(spds);
            this.setPassThruEnabled(passthru);
            this.updateTargetTableTypesAttributes();
        }
        finally {
            this.fixMovedTables();
        }
    }

    @Override
    protected void updateTargetTableTypesAttributes() {
        this.updateTargetTableTypesAttributes(this.isSourceTablesPassthruSupported());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void updateTargetTableTypesAttributes(boolean sourceTablesSupportPassthru) {
        targets = this.getDataTargets();
        targetPassThru = sourceTablesSupportPassthru;
        if (targetPassThru) {
            if (targets.length > 0 && targets[0] instanceof IPhysicalTable) {
                try {
                    targetTable = (IPhysicalTable)targets[0];
                    v0 = targetPassThru = targetPassThru != false && targetTable.getDBMSType().isPassThroughSupported() != false;
                    if (!targetPassThru) ** GOTO lbl32
                    sourceTables = this.getAllQuerySourceTables();
                    for (i = 0; i < sourceTables.length; ++i) {
                        table = sourceTables[i];
                        if (!table.isMoveTableToUploadLibrary()) continue;
                        table.moveTable();
                    }
                    allTables = new IPhysicalTable[sourceTables.length + targets.length];
                    for (i = 0; i < sourceTables.length; ++i) {
                        table = sourceTables[i];
                        allTables[i] = (IPhysicalTable)table.getAliasedTable();
                    }
                    allTables[allTables.length - 1] = targetTable;
                    try {
                        targetPassThru = TableUtil.hasEqualDeployedComponents(this.getExecutionServer(), allTables);
                    }
                    catch (BadLibraryDefinitionException e) {
                        ModelLogger.getDefaultLogger().debug((Object)"BadLibraryDefinitionException", (Throwable)e);
                    }
                }
                finally {
                    this.fixMovedTables();
                }
            } else {
                targetPassThru = false;
            }
        }
lbl32:
        // 6 sources

        this.setTargetPassThruEnabled(targetPassThru);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateDBMSType() {
        if (this.isPassThruEnabled() && this.isPassThru()) {
            ISourceTable[] srcs = this.getAllQuerySourceTables();
            ISourceTable sourceTable = null;
            for (int i = 0; i < srcs.length; ++i) {
                IPhysicalTable table = (IPhysicalTable)srcs[i].getAliasedTable();
                if (table == null) continue;
                sourceTable = srcs[i];
                break;
            }
            if (sourceTable != null) {
                try {
                    if (sourceTable.isMoveTableToUploadLibrary()) {
                        sourceTable.moveTable();
                    }
                    this.setDBMSType(((IPhysicalTable)sourceTable.getAliasedTable()).getDBMSType());
                }
                finally {
                    this.fixMovedTables();
                }
            } else {
                this.setDBMSType(DBMSTypeFactory.getDefaultType());
            }
        } else {
            this.setDBMSType(DBMSTypeFactory.getDefaultType());
        }
    }

    @Override
    public boolean isTargetPassThruEnabled() {
        return this.m_bTargetPassThruEnabled;
    }

    private void setTargetPassThruEnabled(boolean targetPassThruEnabled) {
        if (this.m_bTargetPassThruEnabled == targetPassThruEnabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTargetPassThruEnabledUndoable(this.m_bTargetPassThruEnabled, targetPassThruEnabled));
        }
        this.m_bTargetPassThruEnabled = targetPassThruEnabled;
        this.fireModelChangedEvent("SQLJoinTransformModel:TargetPassThruChanged", null);
    }

    private void fixMovedTables() {
        ISourceTable[] srcs = this.getAllQuerySourceTables();
        for (int i = 0; i < srcs.length; ++i) {
            ISourceTable table = srcs[i];
            if (!table.isMoved()) continue;
            table.resetAttributes();
        }
    }

    @Override
    public boolean isSPDSQuery() {
        return this.m_bSPDSTables;
    }

    private void setSPDSTables(boolean spdsTables) {
        if (this.m_bSPDSTables == spdsTables) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSPDSTablesUndoable(this.m_bSPDSTables, spdsTables));
        }
        this.m_bSPDSTables = spdsTables;
        this.fireModelChangedEvent("SQLJoinTransformModel:SPDSSourceTablesChanged", null);
    }

    @Override
    public ITransformTableOptions[] getTableOptionObjects() {
        ITransformTableOptions options;
        ArrayList<ITransformTableOptions> lTableOptions = new ArrayList<ITransformTableOptions>();
        for (ISourceTable source : this.getAllQuerySourceTables()) {
            lTableOptions.add(source.getTransformSourceTableOption());
        }
        IPhysicalTable target = (IPhysicalTable)this.getDataTarget();
        if (target != null && (options = this.getTableOptionObject(target, false, super.getTableOptionObjects())) != null) {
            lTableOptions.add(options);
        }
        return lTableOptions.toArray(new ITransformTableOptions[lTableOptions.size()]);
    }

    @Override
    public IQuery getQuery() {
        if (this.m_lSetOperators.size() > 0) {
            return ((ISetOperator)this.m_lSetOperators.get(0)).getFirstQuery();
        }
        return null;
    }

    @Override
    public IDataObject getDataTarget() {
        if (this.getDataTargetsCount() > 0) {
            return this.getDataTargets()[0];
        }
        return null;
    }

    @Override
    public IClause addClause(ClauseType type) {
        return this.getQuery().addClause(type);
    }

    @Override
    public void removeClause(IClause clause) {
        this.getQuery().removeClause(clause);
    }

    @Override
    public IClause getClause(ClauseType type) {
        return this.getQuery().getClause(type);
    }

    @Override
    public IClause[] getClauses() {
        ArrayList lClauses = new ArrayList();
        return lClauses.toArray(new IClause[lClauses.size()]);
    }

    @Override
    public void removeSQLSource(ISQLSource source) {
    }

    @Override
    public void addSQLSource(ISQLSource source) {
    }

    @Override
    public void setParentQuery(IQuery query) {
    }

    @Override
    public IQuery getParentQuery() {
        return this.getQuery();
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.FROM;
    }

    @Override
    protected String getDefaultDBIDirectExecValue() {
        return "DBIDIRECTEXEC";
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        cSetOperatorsOptionModel model = new cSetOperatorsOptionModel(this);
        IPromptDefinitionValue dbiDefinition = model.getPromptDefinitionValue("OPTION_DBI_DIRECT_EXEC");
        if (dbiDefinition != null) {
            dbiDefinition.setHidden(false);
            dbiDefinition.setDefaultValue(this.getDefaultDBIDirectExecValue());
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean validateCode) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment, validateCode);
        IPhysicalTable target = (IPhysicalTable)this.getDataTarget();
        ISourceTable[] sourceTables = this.getAllQuerySourceTables();
        ArrayList<ISourceTable> movedSourceTables = new ArrayList<ISourceTable>();
        if (!validateCode) {
            for (int i = 0; i < sourceTables.length; ++i) {
                ISourceTable table = sourceTables[i];
                if (!table.isMoveTableToUploadLibrary()) continue;
                table.moveTableToUploadLibrary(codeSegment);
                movedSourceTables.add(table);
            }
        }
        boolean passthru = this.isPassThru();
        boolean targetPassthru = this.m_bTargetIsPassThru;
        try {
            int i;
            String desc;
            boolean useCreateSyntax;
            boolean hasSPDSOptions;
            boolean isDebug = this.isDebug();
            if (passthru) {
                this.setPassThru(this.isPassThruEnabled());
            }
            if (targetPassthru) {
                this.m_bTargetIsPassThru = this.isPassThru() && this.m_bTargetPassThruEnabled;
            }
            boolean targetIsView = target.isView();
            if (!validateCode && this.m_bTargetIsPassThru && !targetIsView) {
                codeSegment.addSourceCode("%macro etls_prepareTarget();\n").indent();
                if ("delete".equals(this.m_sPreTargetPassThruAction)) {
                    this.genTableDelete(codeSegment, target);
                    target.getDBMSType().create(codeSegment, target, false, false, false, false, "", null);
                    codeSegment.addSourceCode("%let etls_tableExist = 0;\n\n");
                } else {
                    target.genTableExist(codeSegment);
                    target.getDBMSType().create(codeSegment, target, true, false, false, false, "", this);
                    codeSegment.addSourceCode("%else; \n").addSourceCode("%do;\n").indent();
                    if (!(target.getDBMSType() instanceof HADOOPType) && !(target.getDBMSType() instanceof SASHDATType)) {
                        target.getDBMSType().deleteAllRows(codeSegment, target, true);
                    }
                    codeSegment.unIndent().addSourceCode("%end;\n\n");
                }
                codeSegment.unIndent().addSourceCode("%mend etls_prepareTarget;\n").addSourceCode("%etls_prepareTarget;\n\n");
            }
            if (!(this.m_bTargetIsPassThru && !targetIsView || validateCode)) {
                this.genTableDelete(codeSegment, target);
            }
            boolean bl = hasSPDSOptions = isDebug || !"".equals(this.m_sSPDSOptions) || !"".equals(this.m_sMaxInputRows) || !"".equals(this.m_sMaxOutputRows);
            if (isDebug) {
                codeSegment.addSourceCode("%let etls_sasTrace = %sysfunc(getoption(sastrace));\n").addSourceCode("%let etls_fullSTimer = %sysfunc(getoption(fullstimer));\n").addSourceCode("%let etls_sqlIpTrace = %sysfunc(getoption(sql_ip_trace));\n").genDebugOptionCode();
            }
            if (!validateCode) {
                if (!this.isPassThru() && this.m_bSPDSTables && hasSPDSOptions) {
                    codeSegment.addSourceCode("%let spdssqlr = ");
                    if (isDebug) {
                        codeSegment.addSourceCode(" _method");
                    }
                    if (!"".equals(this.m_sMaxInputRows)) {
                        codeSegment.addSourceCode(" inobs = ").addSourceCode(this.m_sMaxInputRows);
                    }
                    if (!"".equals(this.m_sMaxOutputRows)) {
                        codeSegment.addSourceCode(" outobs = ").addSourceCode(this.m_sMaxOutputRows);
                    }
                    if (this.m_bSuggestSortMergeJoin) {
                        codeSegment.addSourceCode(" magic = 102");
                    }
                    if (!"".equals(this.m_sSPDSOptions)) {
                        codeSegment.addSourceCode("\n").indent().addSourceCode(this.m_sSPDSOptions).addSourceCode("\n").unIndent();
                    }
                    codeSegment.addSourceCode(";\n\n");
                } else if (!this.isPassThru() && this.m_bSPDSTables && !hasSPDSOptions) {
                    codeSegment.addSourceCode("%let spdssqlr = ;\n\n");
                }
            }
            codeSegment.addSourceCode("proc sql");
            if (validateCode) {
                codeSegment.addSourceCode(" noexec");
            }
            if (isDebug) {
                codeSegment.addSourceCode(" _method");
            }
            if (!"".equals(this.m_sBufferSize.trim())) {
                codeSegment.addSourceCode(" buffersize = ").addSourceCode(this.m_sBufferSize);
            }
            if (!"".equals(this.m_sMaxInputRows)) {
                codeSegment.addSourceCode(" inobs = ").addSourceCode(this.m_sMaxInputRows);
            }
            if (!"".equals(this.m_sMaxOutputRows)) {
                codeSegment.addSourceCode(" outobs = ").addSourceCode(this.m_sMaxOutputRows);
            }
            if (!"systemdefault".equalsIgnoreCase(this.m_sThreads)) {
                codeSegment.addSourceCode(" ").addSourceCode(this.m_sThreads);
            }
            if (this.m_sSQLOptions.trim().length() > 0) {
                codeSegment.addSourceCode("\n").indent().addSourceCode(this.m_sSQLOptions).addSourceCode("\n").unIndent();
            }
            codeSegment.addSourceCode(";\n").indent();
            IPhysicalTable sourceTable = (IPhysicalTable)this.getDataSources()[0];
            if (this.isPassThru() && sourceTable != null) {
                sourceTable.getDBMSType().genConnect(codeSegment, sourceTable);
            }
            if (sourceTable != null && !this.isPassThru() && this.m_bSPDSTables && hasSPDSOptions) {
                sourceTable.getDBMSType().genExecuteBegin(codeSegment, sourceTable, "");
                codeSegment.addSourceCode("reset\n").indent();
                if (isDebug) {
                    codeSegment.addSourceCode(" _method\n");
                }
                if (!"".equals(this.m_sMaxInputRows)) {
                    codeSegment.addSourceCode(" inobs = ").addSourceCode(this.m_sMaxInputRows).addSourceCode("\n");
                }
                if (!"".equals(this.m_sMaxOutputRows)) {
                    codeSegment.addSourceCode(" outobs = ").addSourceCode(this.m_sMaxOutputRows).addSourceCode("\n");
                }
                if (!"".equals(this.m_sSPDSOptions)) {
                    codeSegment.addSourceCode(" ").addSourceCode(this.m_sSPDSOptions).addSourceCode("\n");
                }
                if (this.m_bSuggestSortMergeJoin) {
                    codeSegment.addSourceCode(" magic = 102\n");
                }
                codeSegment.unIndent();
                sourceTable.getDBMSType().genExecuteEnd(codeSegment, sourceTable, "");
            }
            boolean bl2 = useCreateSyntax = !this.m_bTargetIsPassThru || target.isView();
            if (this.m_bTargetIsPassThru) {
                sourceTable.getDBMSType().genExecuteBegin(codeSegment, sourceTable, "");
            }
            if ((desc = this.getCreateDescription()).length() > 0) {
                codeSegment.addCommentLine(desc);
            }
            if (useCreateSyntax) {
                codeSegment.addSourceCode("create").addSourceCode(target.isView() ? " view " : " table ");
            } else if (target.getDBMSType() instanceof HADOOPType || target.getDBMSType() instanceof SASHDATType || target.getDBMSType() instanceof SASIOIMPType) {
                if (this.m_bTargetIsPassThru && (target.getDBMSType() instanceof HADOOPType || target.getDBMSType() instanceof SASHDATType)) {
                    codeSegment.addSourceCode("insert overwrite table ");
                } else {
                    codeSegment.addSourceCode("insert into table ");
                }
            } else {
                codeSegment.addSourceCode("insert into ");
            }
            String targetName = !validateCode ? target.getFullNameQuotedAsNeeded(codeSegment, this.m_bTargetIsPassThru) : target.getLibref(codeSegment.getCurrentServer()) + "." + codeSegment.getUniqueWorkTableName();
            codeSegment.addSourceCode(targetName);
            if (this.getQuery() != null) {
                IPromptDefinitionValue definition;
                PhysicalTablePromptModelCollection optionModel;
                StringBuffer targetOptions = this.getQuery().getTargetTableOptions();
                ITransformTableOptions targetOptionModel = this.getTableOptionObject(target, false);
                String targetDataOptions = targetOptionModel.getTableOptions(false, "", targetOptions.toString(), codeSegment.getCurrentServer());
                if (!this.m_bTargetIsPassThru && targetOptions != null && targetDataOptions.length() > 0) {
                    codeSegment.addSourceCode("\n").addSourceCode("(").indent().addSourceCode("\n").addSourceCode(targetDataOptions).unIndent().addSourceCode("\n").addSourceCode(")");
                } else if (this.m_bTargetIsPassThru && (optionModel = targetOptionModel.getOptionModel()) != null && (definition = optionModel.findDefinition("AdditionalOptions")) != null) {
                    try {
                        codeSegment.addSourceCode(optionModel.getOptionsString(new IPromptDefinitionValue[]{definition}, null, null));
                    }
                    catch (ServerConnectionException e) {
                        throw new ServerException(e);
                    }
                    catch (ServiceException e) {
                        throw new ServerException(e);
                    }
                }
            }
            if (useCreateSyntax) {
                codeSegment.addSourceCode(" as");
            }
            codeSegment.addSourceCode("\n");
            for (i = 0; i < this.m_lSetOperators.size(); ++i) {
                ISetOperator oSetOperator = (ISetOperator)this.m_lSetOperators.get(i);
                boolean isFirstSetOperator = false;
                if (i == 0) {
                    isFirstSetOperator = true;
                    if (this.isPassThru() && !this.m_bTargetIsPassThru) {
                        sourceTable.getDBMSType().genBeginSelectAllFromConnect(codeSegment, sourceTable, ((BaseQuery)oSetOperator.getFirstQuery()).getSelectResultsForPassthru(codeSegment));
                    }
                }
                boolean doesNextOneHaveParenthesis = false;
                if (i + 1 <= this.m_lSetOperators.size() - 1) {
                    doesNextOneHaveParenthesis = ((ISetOperator)this.m_lSetOperators.get(i + 1)).hasParenthesis();
                }
                oSetOperator.getGeneratedCode(codeSegment, this.isPassThru(), isFirstSetOperator, doesNextOneHaveParenthesis, this.m_lSetOperators.size() == 1);
            }
            if (this.isPassThru() && !this.m_bTargetIsPassThru) {
                codeSegment.unIndent();
                sourceTable.getDBMSType().genEndSelectAllFromConnect(codeSegment, sourceTable);
            }
            if (this.isPassThru() && this.m_bTargetIsPassThru && sourceTable != null) {
                codeSegment.addSourceCode("\n");
                sourceTable.getDBMSType().genExecuteEnd(codeSegment, sourceTable, "");
            }
            if (this.isPassThru() && sourceTable != null) {
                sourceTable.getDBMSType().genExecuteCommit(codeSegment, sourceTable, "");
                sourceTable.getDBMSType().genDisconnect(codeSegment, sourceTable);
            }
            if (!this.isPassThru()) {
                codeSegment.addSourceCode(";\n");
            }
            codeSegment.unIndent().addSourceCode("quit;\n\n");
            codeSegment.genPushDownMacroCode();
            if (isDebug) {
                codeSegment.addSourceCode("options sql_ip_trace = &etls_sqlIpTrace sastrace = \"&etls_sasTrace\" &etls_fullSTimer ; \n\n");
            }
            codeSegment.genRCSetCall("&sqlrc");
            for (i = 0; i < movedSourceTables.size(); ++i) {
                ISourceTable table = (ISourceTable)movedSourceTables.get(i);
                table.genCleanUpMovedTableCode(codeSegment);
            }
            if (this.isGenerateIndexesOnTargetTables() && !validateCode) {
                IDBMSType targetType = target.getDBMSType();
                if ("delete".equals(this.m_sPreTargetPassThruAction) && !target.isView() && (targetType.hasConstraints(target) || targetType.hasIndexes(target))) {
                    codeSegment.addSourceCode("%macro etls_completeTarget();\n").indent();
                    targetType.createConstraints(codeSegment, target);
                    codeSegment.unIndent().addSourceCode("%mend etls_completeTarget;\n").addSourceCode("%etls_completeTarget;\n\n");
                }
            }
            if (!validateCode) {
                this.genCodeConditionCheck(codeSegment);
            }
        }
        finally {
            this.setPassThru(passthru);
            this.m_bTargetIsPassThru = targetPassthru;
            this.fixMovedTables();
        }
        return codeSegment;
    }

    protected void genCodeConditionCheck(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IConditionActionSet[] conditionActions = this.getConditionActionSets();
        if (conditionActions.length == 0) {
            return;
        }
        codeSegment.addCommentLine(RB.getStringResource("SQLJoinTransformModel.RCCheck.msg.txt"));
        codeSegment.addSourceCode("%macro etls_sqlRcCheck; \n").indent();
        for (int iEvent = 0; iEvent < conditionActions.length; ++iEvent) {
            IConditionActionSet lEvent = conditionActions[iEvent];
            String eventRole = lEvent.getUniqueIdentifier();
            if (!"DIS_SETSUCCESS".equals(eventRole) && !"DIS_SETWARN".equals(eventRole) && !"DIS_SETERROR".equals(eventRole)) continue;
            ICondition lEventCondition = lEvent.getCondition();
            codeSegment.addSourceCode(lEventCondition.getConditionMacroCall("trans_rc") + "\n");
            codeSegment.addSourceCode("%do; \n").indent();
            IConditionAction[] actions = lEvent.getActions();
            for (int iAction = 0; iAction < actions.length; ++iAction) {
                codeSegment.addSourceCode(actions[iAction].getActionMacroCall(this.getJob().isUsingNLSDateFormat(), codeSegment));
            }
            codeSegment.unIndent().addSourceCode("%end; \n\n");
        }
        codeSegment.unIndent().addSourceCode("%mend etls_sqlRcCheck; \n").addSourceCode("%etls_sqlRcCheck; \n\n");
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
    }

    private class SetTargetPassThruEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldTargetPassThruEnabled;
        private boolean m_newTargetPassThruEnabled;

        public SetTargetPassThruEnabledUndoable(boolean oldTargetPassThruEnabled, boolean newTargetPassThruEnabled) {
            this.m_oldTargetPassThruEnabled = oldTargetPassThruEnabled;
            this.m_newTargetPassThruEnabled = newTargetPassThruEnabled;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setTargetPassThruEnabled(this.m_oldTargetPassThruEnabled);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setTargetPassThruEnabled(this.m_newTargetPassThruEnabled);
        }
    }

    private class SetSPDSTablesUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldSPDSTables;
        private boolean m_newSPDSTables;

        public SetSPDSTablesUndoable(boolean oldSPDSTables, boolean newSPDSTables) {
            this.m_oldSPDSTables = oldSPDSTables;
            this.m_newSPDSTables = newSPDSTables;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setSPDSTables(this.m_oldSPDSTables);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setSPDSTables(this.m_newSPDSTables);
        }
    }

    private class SetDebugUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldDebug;
        private boolean m_newDebug;

        public SetDebugUndoable(boolean oldDebug, boolean newDebug) {
            this.m_oldDebug = oldDebug;
            this.m_newDebug = newDebug;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setIsDebug(this.m_oldDebug);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setIsDebug(this.m_newDebug);
        }
    }

    private class SetSPDSOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldSPDSOptions;
        private String m_newSPDSOptions;

        public SetSPDSOptionsUndoable(String oldSPDSOptions, String newSPDSOptions) {
            this.m_oldSPDSOptions = oldSPDSOptions;
            this.m_newSPDSOptions = newSPDSOptions;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setSPDSOptions(this.m_oldSPDSOptions);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setSPDSOptions(this.m_newSPDSOptions);
        }
    }

    private class SetSPDSParallelJoinUndoable
    extends AbstractUndoableEdit {
        private String m_oldSPDSParallelJoin;
        private String m_newSPDSParallelJoin;

        public SetSPDSParallelJoinUndoable(String oldSPDSParallelJoin, String newSPDSParallelJoin) {
            this.m_oldSPDSParallelJoin = oldSPDSParallelJoin;
            this.m_newSPDSParallelJoin = newSPDSParallelJoin;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setSPDSParallelJoin(this.m_oldSPDSParallelJoin);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setSPDSParallelJoin(this.m_newSPDSParallelJoin);
        }
    }

    private class SetThreadsUndoable
    extends AbstractUndoableEdit {
        private String m_oldThreads;
        private String m_newThreads;

        public SetThreadsUndoable(String oldThreads, String newThreads) {
            this.m_oldThreads = oldThreads;
            this.m_newThreads = newThreads;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setThreads(this.m_oldThreads);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setThreads(this.m_newThreads);
        }
    }

    private class SetMaxOutputRowsUndoable
    extends AbstractUndoableEdit {
        private String m_oldOutObs;
        private String m_newOutObs;

        public SetMaxOutputRowsUndoable(String oldOutObs, String newOutObs) {
            this.m_oldOutObs = oldOutObs;
            this.m_newOutObs = newOutObs;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setMaxOutputRows(this.m_oldOutObs);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setMaxOutputRows(this.m_newOutObs);
        }
    }

    private class SetMaxInputRowsUndoable
    extends AbstractUndoableEdit {
        private String m_oldInObs;
        private String m_newInObs;

        public SetMaxInputRowsUndoable(String oldInObs, String newInObs) {
            this.m_oldInObs = oldInObs;
            this.m_newInObs = newInObs;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setMaxInputRows(this.m_oldInObs);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setMaxInputRows(this.m_newInObs);
        }
    }

    private class SetBufferSizeUndoable
    extends AbstractUndoableEdit {
        private String m_oldBufferSize;
        private String m_newBufferSize;

        public SetBufferSizeUndoable(String oldBufferSize, String newBufferSize) {
            this.m_oldBufferSize = oldBufferSize;
            this.m_newBufferSize = newBufferSize;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setBufferSize(this.m_oldBufferSize);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setBufferSize(this.m_newBufferSize);
        }
    }

    private class SetSuggestSortMergeJoinUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldSuggestSortMergeJoin;
        private boolean m_newSuggestSortMergeJoin;

        public SetSuggestSortMergeJoinUndoable(boolean oldSuggestSortMergeJoin, boolean newSuggestSortMergeJoin) {
            this.m_oldSuggestSortMergeJoin = oldSuggestSortMergeJoin;
            this.m_newSuggestSortMergeJoin = newSuggestSortMergeJoin;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setSuggestSortMergeJoin(this.m_oldSuggestSortMergeJoin);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setSuggestSortMergeJoin(this.m_newSuggestSortMergeJoin);
        }
    }

    private class SetPreTargetPassThruActionUndoable
    extends AbstractUndoableEdit {
        private String m_oldTargetPassThruAction;
        private String m_newTargetPassThruAction;

        public SetPreTargetPassThruActionUndoable(String oldTargetPassThruAction, String newTargetPassThruAction) {
            this.m_oldTargetPassThruAction = oldTargetPassThruAction;
            this.m_newTargetPassThruAction = newTargetPassThruAction;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setPreTargetPassThruAction(this.m_oldTargetPassThruAction);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setPreTargetPassThruAction(this.m_newTargetPassThruAction);
        }
    }

    private class SetTargetPassThruUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldTargetPassThru;
        private boolean m_newTargetPassThru;

        public SetTargetPassThruUndoable(boolean oldTargetPassThru, boolean newTargetPassThru) {
            this.m_oldTargetPassThru = oldTargetPassThru;
            this.m_newTargetPassThru = newTargetPassThru;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setTargetPassThru(this.m_oldTargetPassThru);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setTargetPassThru(this.m_newTargetPassThru);
        }
    }

    private class SetSQLOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldSQLOptions;
        private String m_newSQLOptions;

        public SetSQLOptionsUndoable(String oldSQLOptions, String newSQLOptions) {
            this.m_oldSQLOptions = oldSQLOptions;
            this.m_newSQLOptions = newSQLOptions;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setSQLOptions(this.m_oldSQLOptions);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setSQLOptions(this.m_newSQLOptions);
        }
    }

    private class SetCreateDescriptionUndoable
    extends AbstractUndoableEdit {
        private String m_oldCreateDescription;
        private String m_newCreateDescription;

        public SetCreateDescriptionUndoable(String oldCreateDescription, String newCreateDescription) {
            this.m_oldCreateDescription = oldCreateDescription;
            this.m_newCreateDescription = newCreateDescription;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSetOperatorsTransformModel.this.setCreateDescription(this.m_oldCreateDescription);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSetOperatorsTransformModel.this.setCreateDescription(this.m_newCreateDescription);
        }
    }

    protected class cSetOperatorsOptionModel
    extends BaseDataTransformPromptModel {
        public cSetOperatorsOptionModel(SQLSetOperatorsTransformModel model) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model.getModel(), model);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cSetOperatorsOptionModel.class.getResource("res/Options_SQLSetOperators_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
            SQLSetOperatorsTransformModel transform = (SQLSetOperatorsTransformModel)this.getOwner();
            this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_PASSTHRU, (Object)(transform.isPassThru() ? SQLSetOperatorsTransformModel.OPTIONS_TRUE : SQLSetOperatorsTransformModel.OPTIONS_FALSE));
            this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_TARGET_PASSTHRU, (Object)(transform.isTargetPassThru() ? SQLSetOperatorsTransformModel.OPTIONS_TRUE : SQLSetOperatorsTransformModel.OPTIONS_FALSE));
            this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_SQL_OPTIONS, (Object)transform.getSQLOptions());
            this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_BUFFER_SIZE, (Object)transform.getBufferSize());
            this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_INOBS, (Object)transform.getMaxInputRows());
            this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_OUTOBS, (Object)transform.getMaxOutputRows());
            this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_THREADS, (Object)transform.getThreads());
            this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_SPDS_OPTIONS, (Object)transform.getSPDSOptions());
            this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_PRETARGETPASSTHRUACTION, (Object)transform.getPreTargetPassThruAction());
            this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_DEBUG, (Object)(transform.isDebug() ? SQLSetOperatorsTransformModel.OPTIONS_TRUE : SQLSetOperatorsTransformModel.OPTIONS_FALSE));
        }

        @Override
        protected IModelListener createModelListener() {
            return new cSetOperatorsModelChangeListener();
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new SetOperatorsTransformValueChangedListener((SQLSetOperatorsTransformModel)this.getOwner(), this);
        }

        private class SetOperatorsTransformValueChangedListener
        extends BaseDataTransformValueChangedListener {
            public SetOperatorsTransformValueChangedListener(SQLSetOperatorsTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (optionName.equals(SQLSetOperatorsTransformModel.PROPERTY_NAME_BUFFER_SIZE)) {
                        SQLSetOperatorsTransformModel.this.setBufferSize(value.toString());
                    } else if (optionName.equals(SQLSetOperatorsTransformModel.PROPERTY_NAME_INOBS)) {
                        SQLSetOperatorsTransformModel.this.setMaxInputRows(value.toString());
                    } else if (optionName.equals(SQLSetOperatorsTransformModel.PROPERTY_NAME_OUTOBS)) {
                        SQLSetOperatorsTransformModel.this.setMaxOutputRows(value.toString());
                    } else if (optionName.equals(SQLSetOperatorsTransformModel.PROPERTY_NAME_PASSTHRU)) {
                        SQLSetOperatorsTransformModel.this.setPassThru(value.equals(SQLSetOperatorsTransformModel.OPTIONS_TRUE));
                    } else if (optionName.equals(SQLSetOperatorsTransformModel.PROPERTY_NAME_PRETARGETPASSTHRUACTION)) {
                        SQLSetOperatorsTransformModel.this.setPreTargetPassThruAction(value.toString());
                    } else if (optionName.equals(SQLSetOperatorsTransformModel.PROPERTY_NAME_SPDS_OPTIONS)) {
                        SQLSetOperatorsTransformModel.this.setSPDSOptions(value.toString());
                    } else if (optionName.equals(SQLSetOperatorsTransformModel.PROPERTY_NAME_SQL_OPTIONS)) {
                        SQLSetOperatorsTransformModel.this.setSQLOptions(value.toString());
                    } else if (optionName.equals(SQLSetOperatorsTransformModel.PROPERTY_NAME_TARGET_PASSTHRU)) {
                        SQLSetOperatorsTransformModel.this.setTargetPassThru(value.equals(SQLSetOperatorsTransformModel.OPTIONS_TRUE));
                    } else if (optionName.equals(SQLSetOperatorsTransformModel.PROPERTY_NAME_THREADS)) {
                        SQLSetOperatorsTransformModel.this.setThreads(value.toString());
                    } else if (optionName.equals(SQLSetOperatorsTransformModel.PROPERTY_NAME_DEBUG)) {
                        SQLSetOperatorsTransformModel.this.setIsDebug(value.equals(SQLSetOperatorsTransformModel.OPTIONS_TRUE));
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                    SQLSetOperatorsTransformModel.this.getPromptModel().setListeningForChanges(true);
                    cSetOperatorsOptionModel.this.setChanged(true);
                }
            }
        }

        private class cSetOperatorsModelChangeListener
        extends BaseDataTransformModelListener {
            public cSetOperatorsModelChangeListener() {
                super(cSetOperatorsOptionModel.this.getOwner(), cSetOperatorsOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals("SQLJoinTransformModel:PassThroughChanged")) {
                        cSetOperatorsOptionModel.this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_PASSTHRU, (Object)(SQLSetOperatorsTransformModel.this.isPassThru() ? SQLSetOperatorsTransformModel.OPTIONS_TRUE : SQLSetOperatorsTransformModel.OPTIONS_FALSE));
                    } else if (type.equals("SQLJoinTransformModel:TargetPassThroughChanged")) {
                        cSetOperatorsOptionModel.this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_TARGET_PASSTHRU, (Object)(SQLSetOperatorsTransformModel.this.isTargetPassThru() ? SQLSetOperatorsTransformModel.OPTIONS_TRUE : SQLSetOperatorsTransformModel.OPTIONS_FALSE));
                    } else if (type.equals("SQLJoinTransformModel:SqlOptionsChanged")) {
                        cSetOperatorsOptionModel.this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_SQL_OPTIONS, (Object)SQLSetOperatorsTransformModel.this.getSQLOptions());
                    } else if (type.equals("SQLJoinTransformModel:BufferSizeChanged")) {
                        cSetOperatorsOptionModel.this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_BUFFER_SIZE, (Object)SQLSetOperatorsTransformModel.this.getBufferSize());
                    } else if (type.equals("SQLJoinTransformModel:InObsChanged")) {
                        cSetOperatorsOptionModel.this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_INOBS, (Object)SQLSetOperatorsTransformModel.this.getMaxInputRows());
                    } else if (type.equals("SQLJoinTransformModel:OutobsChanged")) {
                        cSetOperatorsOptionModel.this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_OUTOBS, (Object)SQLSetOperatorsTransformModel.this.getMaxOutputRows());
                    } else if (type.equals("SQLJoinTransformModel:ThreadsChanged")) {
                        cSetOperatorsOptionModel.this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_THREADS, (Object)SQLSetOperatorsTransformModel.this.getThreads());
                    } else if (type.equals("SQLJoinTransformModel:AdditionalSpdsOptionsChanged")) {
                        cSetOperatorsOptionModel.this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_SPDS_OPTIONS, (Object)SQLSetOperatorsTransformModel.this.getSPDSOptions());
                    } else if (type.equals("SQLJoinTransformModel:TargetPassThroughActionChanged")) {
                        cSetOperatorsOptionModel.this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_PRETARGETPASSTHRUACTION, (Object)SQLSetOperatorsTransformModel.this.getPreTargetPassThruAction());
                    } else if (type.equals("SQLJoinTransformModel:DebugChanged")) {
                        cSetOperatorsOptionModel.this.setOptionValue(SQLSetOperatorsTransformModel.PROPERTY_NAME_DEBUG, (Object)(SQLSetOperatorsTransformModel.this.isDebug() ? SQLSetOperatorsTransformModel.OPTIONS_TRUE : SQLSetOperatorsTransformModel.OPTIONS_FALSE));
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }
    }
}

