/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.impl.BaseBooleanExpression;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLBooleanExpressionContainer;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.Variable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class BooleanExpression
extends BaseBooleanExpression {
    protected static final int SUBQUERY_ADDED_TO_EXPRESSION = 31;
    protected static final int SUBQUERY_REMOVED_FROM_EXPRESSION = 32;
    private ISQLBooleanExpressionContainer m_parent;

    public BooleanExpression(String sID, IModel model, ISQLBooleanExpressionContainer parent) {
        super(sID, model);
        this.m_parent = parent;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete();
    }

    @Override
    public void setLeftOperand(IExpression operand) {
        IExpression leftOperand = this.getLeftOperand();
        if (leftOperand == operand) {
            return;
        }
        super.setLeftOperand(operand);
        if (leftOperand instanceof ISubquery) {
            this.fireModelChangedEvent("BooleanExpression.SubqueryRemoved", leftOperand);
            this.fireNotifyEvent(32);
        }
        if (operand instanceof ISubquery) {
            this.fireNotifyEvent(31);
        }
    }

    @Override
    public void setRightOperand(IExpression operand) {
        IExpression rightOperand = this.getRightOperand();
        if (rightOperand == operand) {
            return;
        }
        super.setRightOperand(operand);
        if (rightOperand instanceof ISubquery) {
            this.fireModelChangedEvent("BooleanExpression.SubqueryRemoved", rightOperand);
            this.fireNotifyEvent(32);
        }
        if (operand instanceof ISubquery) {
            this.fireNotifyEvent(31);
        }
    }

    @Override
    protected void saveLeftAndRightOperandsToOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        ITable target;
        String sVariableID;
        IExpression rightOperand;
        Root mdoLeftOperand = null;
        Root mdoRightOperand = null;
        IExpression leftOperand = this.getLeftOperand();
        if (leftOperand != null) {
            leftOperand.saveToOMR(omr);
            mdoLeftOperand = omr.acquireOMRObject(leftOperand);
        }
        if ((rightOperand = this.getRightOperand()) != null) {
            rightOperand.saveToOMR(omr);
            mdoRightOperand = omr.acquireOMRObject(rightOperand);
        }
        List lOldSubstituteVariablesIDs = this.m_lSubstituteVariablesIDs;
        this.m_lSubstituteVariablesIDs = new ArrayList(2);
        AssociationList lSubVars = mdoFM.getSubstitutionVariables(false);
        lSubVars.clear();
        if (mdoLeftOperand != null) {
            sVariableID = lOldSubstituteVariablesIDs.isEmpty() ? this.createIDForNewObject() : (String)lOldSubstituteVariablesIDs.remove(0);
            this.m_lSubstituteVariablesIDs.add(sVariableID);
            Variable mdoLeftVar = (Variable)omr.acquireOMRObject(sVariableID, "Variable");
            mdoLeftVar.setName("LeftOperand");
            mdoLeftVar.setMarker("[1]");
            if (leftOperand instanceof ISubquery) {
                target = ((ISubquery)leftOperand).getTargetTable();
                mdoLeftOperand = omr.acquireOMRObject(target);
            }
            mdoLeftVar.setAssociatedObject(mdoLeftOperand);
            mdoLeftVar.setValueType(leftOperand.getExpressionType());
            lSubVars.add(mdoLeftVar);
        }
        if (mdoRightOperand != null) {
            sVariableID = lOldSubstituteVariablesIDs.isEmpty() ? this.createIDForNewObject() : (String)lOldSubstituteVariablesIDs.remove(0);
            this.m_lSubstituteVariablesIDs.add(sVariableID);
            Variable mdoRightVar = (Variable)omr.acquireOMRObject(sVariableID, "Variable");
            mdoRightVar.setName("RightOperand");
            mdoRightVar.setMarker("[2]");
            if (rightOperand instanceof ISubquery) {
                target = ((ISubquery)rightOperand).getTargetTable();
                mdoRightOperand = omr.acquireOMRObject(target);
            }
            mdoRightVar.setAssociatedObject(mdoRightOperand);
            mdoRightVar.setValueType(rightOperand.getExpressionType());
            lSubVars.add(mdoRightVar);
        }
        while (!lOldSubstituteVariablesIDs.isEmpty()) {
            omr.deleteOMRObject((String)lOldSubstituteVariablesIDs.remove(0), "Variable");
        }
    }

    @Override
    protected void loadLeftAndRightOperandsFromOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        IExpression operand;
        this.m_lSubstituteVariablesIDs.clear();
        AssociationList lVariables = mdoFM.getSubstitutionVariables();
        Root mdoLeftOperand = null;
        Root mdoRightOperand = null;
        for (int i = 0; i < lVariables.size(); ++i) {
            Variable mdoVariable = (Variable)lVariables.get(i);
            this.m_lSubstituteVariablesIDs.add(mdoVariable.getFQID());
            String marker = mdoVariable.getMarker();
            if (marker.equalsIgnoreCase("[1]")) {
                mdoLeftOperand = mdoVariable.getAssociatedObject();
                continue;
            }
            if (!marker.equalsIgnoreCase("[2]")) continue;
            mdoRightOperand = mdoVariable.getAssociatedObject();
        }
        if (mdoLeftOperand != null) {
            String sType = mdoLeftOperand.getCMetadataType();
            if (sType.equalsIgnoreCase("QueryTable")) {
                this.setLeftOperand(this.createNewSubquery(omr, (QueryTable)mdoLeftOperand));
            } else if (sType.equalsIgnoreCase("FeatureMap")) {
                operand = this.createNewTextOperand(omr, mdoLeftOperand);
                this.setLeftOperand(operand);
            } else if (sType.equalsIgnoreCase("ClassifierMap") && ((ClassifierMap)mdoLeftOperand).getTransformRole().equalsIgnoreCase("CaseStatement")) {
                operand = this.createNewCaseStatement(omr, mdoLeftOperand);
                this.setLeftOperand(operand);
            } else {
                operand = (IExpression)omr.acquireObject(mdoLeftOperand);
                this.setLeftOperand(operand);
            }
        }
        if (mdoRightOperand != null) {
            String sType = mdoRightOperand.getCMetadataType();
            if (sType.equalsIgnoreCase("QueryTable")) {
                this.setRightOperand(this.createNewSubquery(omr, (QueryTable)mdoRightOperand));
            } else if (sType.equalsIgnoreCase("FeatureMap")) {
                operand = this.createNewTextOperand(omr, mdoRightOperand);
                this.setRightOperand(operand);
            } else if (sType.equalsIgnoreCase("ClassifierMap") && ((ClassifierMap)mdoRightOperand).getTransformRole().equalsIgnoreCase("CaseStatement")) {
                operand = this.createNewCaseStatement(omr, mdoRightOperand);
                this.setRightOperand(operand);
            } else {
                operand = (IExpression)omr.acquireObject(mdoRightOperand);
                this.setRightOperand(operand);
            }
        }
    }

    protected ITextOperand createNewTextOperand(OMRAdapter omr, Root mdo) throws MdException, RemoteException {
        ITextOperand operand = (ITextOperand)this.getModel().getObject(mdo.getFQID());
        if (operand == null) {
            IQuery parent = this.m_parent.getParentQuery();
            operand = this.getModel().getObjectFactory().createSQLTextOperand(mdo.getFQID(), parent);
            operand.loadFromOMR(omr);
        }
        return operand;
    }

    protected ICaseStatement createNewCaseStatement(OMRAdapter omr, Root mdo) throws MdException, RemoteException {
        ICaseStatement expression = (ICaseStatement)this.getModel().getObject(mdo.getFQID());
        if (expression == null) {
            expression = this.getModel().getObjectFactory().createSQLCaseStatement(mdo.getFQID(), this.m_parent.getParentQuery());
            expression.loadFromOMR(omr);
        }
        return expression;
    }

    protected ISubquery createNewSubquery(OMRAdapter omr, QueryTable mdoQueryTable) throws MdException, RemoteException {
        ISubquery subquery = null;
        AssociationList lTargetCMs = mdoQueryTable.getTargetClassifierMaps();
        for (int i = 0; i < lTargetCMs.size(); ++i) {
            Select mdoSelect;
            String sRole;
            Root mdoObject = (Root)lTargetCMs.get(i);
            String sMetadataType = mdoObject.getCMetadataType();
            if (!sMetadataType.equalsIgnoreCase("Select") || !(sRole = (mdoSelect = (Select)mdoObject).getTransformRole()).equalsIgnoreCase("SUBQUERY") || (subquery = (ISubquery)this.getModel().getObject(mdoSelect.getFQID())) != null) continue;
            subquery = this.getModel().getObjectFactory().createSQLSubquery(mdoSelect.getFQID());
            IQuery parent = this.m_parent.getParentQuery();
            subquery.setParentQuery(parent);
            ISQLTransform model = parent.getTransformModel();
            subquery.setTransformModel(model);
            subquery.loadFromOMR(omr);
        }
        return subquery;
    }
}

