/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.impl.AbstractTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.transforms.sql.IAliasColumn;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.impl.AliasColumn;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.Root;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class AliasTable
extends AbstractTable
implements IAliasTable {
    protected static final String ALIAS_TRANSFORM_ROLE = "TableAlias";
    public static final String QUERY_TABLE_ROLE = "Alias";
    private String m_sAliasName;
    private ITable m_table;
    private String m_sRole;
    private String m_sClassifierMapID;
    private String m_sRoleID;
    private List m_lBadColumnIDs;
    private boolean m_bChangedDuringLoad;

    public AliasTable(String sID, IModel model) {
        super(sID, model);
        this.m_lColumns = new ArrayList();
        this.m_sAliasName = "";
        this.m_sRole = QUERY_TABLE_ROLE;
        this.m_lBadColumnIDs = new ArrayList();
        this.m_bChangedDuringLoad = false;
    }

    @Override
    public String getDefaultName() {
        return ALIAS_TRANSFORM_ROLE;
    }

    @Override
    public void notify(NotifyEvent ev) {
        ModelEvent mdev;
        IObject object = (IObject)ev.getSource();
        int iType = ev.getType();
        if (object == this.m_table && iType == 1 && (mdev = ev.getModelEvent()) != null) {
            String sType = mdev.getType();
            if (sType.equals("Table:ColumnAdded") || sType.equals("Table:ColumnRemoved")) {
                this.syncAliasTableColumns();
            }
            if (!sType.equals("Objecty:ResponsiblePartyAdded") && !sType.equals("Objecty:ResponsiblePartyRemoved")) {
                this.fireModelChangedEvent("SQLAlias:DataTableChanged", null);
            }
            if (sType.equals("Object:NameChanged")) {
                this.updateName();
            }
            if (sType.equals("PhysicalTable:SASTableNameChanged")) {
                this.setAliasName(this.m_table.getTableName(false));
            }
        }
        if (object instanceof IColumn) {
            ModelEvent modelEvent;
            AliasColumn aliasedColumn;
            if (iType == 0) {
                this.syncAliasTableColumns();
            } else if (!(object instanceof IAliasColumn) && (aliasedColumn = (AliasColumn)this.findAlaisedColumnContainingColumn((IColumn)object)) != null && (modelEvent = ev.getModelEvent()) != null) {
                String sType = modelEvent.getType();
                aliasedColumn.fireSpecialModelChangedEvent(sType);
            }
        }
        super.notify(ev);
    }

    @Override
    public String getDescription() {
        if (this.m_table != null) {
            return this.m_table.getDescription();
        }
        return super.getDescription();
    }

    @Override
    public boolean isAliased() {
        return this.m_sAliasName != null && !"".equals(this.m_sAliasName);
    }

    @Override
    public boolean isQuoted() {
        if (this.m_table != null) {
            return this.m_table.isQuoted();
        }
        return super.isQuoted();
    }

    @Override
    public void setView(boolean bView) {
        if (this.m_table != null) {
            this.m_table.setView(bView);
        } else {
            super.setView(bView);
        }
    }

    @Override
    public boolean isView() {
        if (this.m_table != null) {
            return this.m_table.isView();
        }
        return super.isView();
    }

    @Override
    public void addColumn(int iColumn, IColumn column) {
        if (this.m_table == null) {
            return;
        }
        if (column instanceof IAliasColumn) {
            IColumn col = ((IAliasColumn)column).getAliasedColumn();
            if (col != null && !this.m_table.containsColumn(col)) {
                this.m_table.addColumn(iColumn, col);
            }
        } else {
            this.m_table.addColumn(iColumn, column);
        }
    }

    @Override
    public void removeColumn(IColumn column) {
        if (this.m_table == null) {
            return;
        }
        if (column instanceof IAliasColumn) {
            IColumn col = ((IAliasColumn)column).getAliasedColumn();
            if (col != null) {
                this.m_table.removeColumn(col);
            }
        } else {
            this.m_table.removeColumn(column);
        }
    }

    @Override
    public void moveColumn(IColumn column, int iTo) {
        this.m_table.moveColumn(column, iTo);
    }

    @Override
    public void setRole(String sRole) {
        this.m_sRole = sRole;
    }

    @Override
    public String getRole() {
        return this.m_sRole;
    }

    @Override
    public void setAliasName(String sName) {
        if (this.m_sAliasName.equals(sName)) {
            return;
        }
        if (sName == null) {
            sName = "";
        }
        this.getModel().startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetAliasNameUndoable(this.m_sAliasName, sName));
            }
            this.m_sAliasName = sName;
            this.fireModelChangedEvent("SQLAlias:AliasChanged", null);
            this.updateName();
        }
        finally {
            this.getModel().endCompoundUndoable();
        }
    }

    @Override
    public String getAliasName() {
        return this.m_sAliasName;
    }

    @Override
    public void setAliasedTable(ITable table) {
        if (this.m_table == table) {
            return;
        }
        this.getModel().startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetAliasedTableUndoable(this.m_table, table));
            }
            if (this.m_table != null) {
                this.m_table.removeNotifyListener(this);
            }
            this.m_table = table;
            if (this.m_table != null) {
                this.m_table.addNotifyListener(this);
            }
            this.updateName();
            this.loadAliasTableColumns();
            this.fireModelChangedEvent("SQLAlias:DataTableChanged", null);
        }
        finally {
            this.getModel().endCompoundUndoable();
        }
    }

    private void updateName() {
        String sName = this.getName();
        if (this.m_table != null) {
            sName = this.m_table.getName();
        }
        String tableName = this.getTableName(false);
        sName = sName + " (" + tableName + ")";
        this.setName(sName);
    }

    @Override
    public ITable getAliasedTable() {
        return this.m_table;
    }

    @Override
    public boolean containsAliasedTable(ITable table) {
        return table == this.m_table;
    }

    @Override
    public boolean containsAliasedColumn(IColumn column) {
        IColumn[] cols = this.getColumns();
        for (int index = 0; index < cols.length; ++index) {
            IColumn col = ((IAliasColumn)cols[index]).getAliasedColumn();
            if (col != column) continue;
            return true;
        }
        return false;
    }

    @Override
    public IAliasColumn findAlaisedColumnContainingColumn(IColumn column) {
        IAliasColumn aliasColumn;
        IColumn col;
        ITable table = column.getTable();
        if (table == null) {
            return null;
        }
        int iLoc = table.indexOfColumn(column);
        if (iLoc > -1 && iLoc < this.m_lColumns.size() && (col = (aliasColumn = (IAliasColumn)this.m_lColumns.get(iLoc)).getAliasedColumn()) == column) {
            return aliasColumn;
        }
        IColumn[] cols = this.getColumns();
        for (int index = 0; index < cols.length; ++index) {
            IAliasColumn aliasColumn2 = (IAliasColumn)cols[index];
            IColumn col2 = aliasColumn2.getAliasedColumn();
            if (col2 != column) continue;
            return aliasColumn2;
        }
        return null;
    }

    private void loadAliasTableColumns() {
        if (this.m_lColumns.size() > 0) {
            for (int index = 0; index < this.m_lColumns.size(); ++index) {
                IAliasColumn aliasColumn = (IAliasColumn)this.m_lColumns.get(index);
                this.m_lColumns.remove(aliasColumn);
                aliasColumn.removeNotifyListener(this);
                IColumn realColumn = aliasColumn.getAliasedColumn();
                realColumn.removeNotifyListener(this);
                aliasColumn.setTable(null);
                this.addToDeletedObjects(aliasColumn);
                this.fireModelChangedEvent("Table:ColumnRemoved", aliasColumn);
            }
        }
        if (this.m_table != null) {
            IColumn[] aColumns = this.m_table.getColumns();
            for (int iCol = 0; iCol < aColumns.length; ++iCol) {
                IAliasColumn aliasCol = this.getModel().getObjectFactory().createNewSQLAliasColumn(this.getID(), aColumns[iCol]);
                aliasCol.setAliasedColumn(aColumns[iCol]);
                aliasCol.setTable(this);
                aColumns[iCol].addNotifyListener(this);
                aliasCol.addNotifyListener(this);
                this.m_lColumns.add(aliasCol);
                this.fireModelChangedEvent("Table:ColumnAdded", aliasCol);
            }
        }
    }

    private void syncAliasTableColumns() {
        if (this.m_table != null) {
            ArrayList lOldColumns = new ArrayList();
            lOldColumns.addAll(this.m_lColumns);
            IColumn[] aMasterColumns = this.m_table.getColumns();
            for (int i = 0; i < aMasterColumns.length; ++i) {
                IColumn realColumn = aMasterColumns[i];
                IAliasColumn aliasColumn = this.findAlaisedColumnContainingColumn(realColumn);
                if (aliasColumn == null) {
                    IColumn aliasCol = null;
                    List lDeletedObjects = this.getDeletedObjects();
                    for (int index = 0; index < lDeletedObjects.size(); ++index) {
                        IColumn column;
                        IObject object = (IObject)lDeletedObjects.get(index);
                        if (!(object instanceof IAliasColumn) || (column = ((IAliasColumn)object).getAliasedColumn()) != realColumn) continue;
                        aliasCol = (IAliasColumn)object;
                        this.removeFromDeletedObjects(aliasCol);
                        break;
                    }
                    if (aliasCol == null) {
                        aliasCol = this.getModel().getObjectFactory().createNewSQLAliasColumn(this.getID(), realColumn);
                        aliasCol.setAliasedColumn(realColumn);
                    }
                    aliasCol.setTable(this);
                    realColumn.addNotifyListener(this);
                    aliasCol.addNotifyListener(this);
                    this.m_lColumns.add(i, aliasCol);
                    this.fireModelChangedEvent("Table:ColumnAdded", aliasCol);
                    continue;
                }
                int index = this.m_lColumns.indexOf(aliasColumn);
                lOldColumns.remove(aliasColumn);
                if (index == i) continue;
                this.m_lColumns.remove(aliasColumn);
                this.m_lColumns.add(i, aliasColumn);
                this.fireModelChangedEvent("Table:ColumnMoved", aliasColumn);
            }
            for (int index = 0; index < lOldColumns.size(); ++index) {
                IAliasColumn aliasColumn = (IAliasColumn)lOldColumns.get(index);
                this.m_lColumns.remove(aliasColumn);
                aliasColumn.removeNotifyListener(this);
                IColumn realColumn = aliasColumn.getAliasedColumn();
                realColumn.removeNotifyListener(this);
                aliasColumn.setTable(null);
                this.addToDeletedObjects(aliasColumn);
                this.fireModelChangedEvent("Table:ColumnRemoved", aliasColumn);
            }
        }
    }

    @Override
    public String getFullNameQuotedAsNeeded(ICodeSegment codeSegment) throws BadLibraryDefinitionException {
        return this.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), codeSegment.isQuoting(), false);
    }

    @Override
    public String getFullNameQuotedAsNeeded(ICodeSegment codeSegment, boolean passthru) throws BadLibraryDefinitionException {
        return this.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), codeSegment.isQuoting(), passthru);
    }

    public String getFullNameQuotedAsNeeded(IServer currentServer, boolean environmentQuoting) throws BadLibraryDefinitionException {
        return this.getFullNameQuotedAsNeeded(currentServer, environmentQuoting, false, true, "");
    }

    @Override
    public String getFullNameQuotedAsNeeded(IServer currentServer, boolean environmentQuoting, boolean passthru) throws BadLibraryDefinitionException {
        return this.getFullNameQuotedAsNeeded(currentServer, environmentQuoting, passthru, true, "");
    }

    @Override
    public String getFullNameQuotedAsNeeded(IServer currentServer, boolean environmentQuoting, boolean passthru, boolean quotes, String prefix) throws BadLibraryDefinitionException {
        if (this.m_table != null) {
            return this.m_table.getFullNameQuotedAsNeeded(currentServer, environmentQuoting, passthru, quotes, prefix);
        }
        return "";
    }

    @Override
    public String getTableName() {
        ITable table = this.getAliasedTable();
        return super.getTableName(table != null ? table.isQuoted() : false, false);
    }

    @Override
    public String getTableName(boolean quotes, boolean passthru) {
        if (this.isAliased()) {
            return this.getAliasName();
        }
        if (this.m_table != null) {
            return this.m_table.getTableName(quotes, passthru);
        }
        return super.getTableName(quotes, passthru);
    }

    @Override
    public String getTableName(boolean quotes) {
        return this.getTableName(quotes, false);
    }

    @Override
    public ClassifierMap getClassifierMapObject(OMRAdapter omr) throws MdException, RemoteException {
        String sClassifierMapID = this.m_sClassifierMapID == null || this.m_sClassifierMapID.length() == 0 ? this.createIDForNewObject() : this.m_sClassifierMapID;
        return (ClassifierMap)omr.acquireOMRObject(sClassifierMapID, this.getClassifierMapOMRType());
    }

    protected String getClassifierMapOMRType() {
        return "ClassifierMap";
    }

    @Override
    public void setClassifierMapID(String sID) {
        this.m_sClassifierMapID = sID;
    }

    @Override
    public String getOMRType() {
        return "QueryTable";
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_table != null && this.m_table.isChanged();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        QueryTable mdoQueryTable = (QueryTable)omr.acquireOMRObject(this);
        mdoQueryTable.setTableName(this.m_sAliasName);
        if (this.m_sClassifierMapID == null || this.m_sClassifierMapID.length() == 0) {
            this.m_sClassifierMapID = this.createIDForNewObject();
        }
        ClassifierMap mdoClassifierMap = (ClassifierMap)omr.acquireOMRObject(this.m_sClassifierMapID, "ClassifierMap");
        mdoClassifierMap.setName(ALIAS_TRANSFORM_ROLE);
        mdoClassifierMap.setTransformRole(ALIAS_TRANSFORM_ROLE);
        AssociationList lClassifierSources = mdoClassifierMap.getClassifierSources(false);
        lClassifierSources.clear();
        if (this.m_table != null) {
            lClassifierSources.add(omr.acquireOMRObject(this.m_table));
        }
        AssociationList lClassifierTargets = mdoClassifierMap.getClassifierTargets(false);
        lClassifierTargets.clear();
        lClassifierTargets.add(mdoQueryTable);
        this.m_sRoleID = this.m_sRoleID == null || this.m_sRoleID.length() == 0 ? this.createIDForNewObject() : this.m_sRoleID;
        Role mdoRole = (Role)omr.acquireOMRObject(this.m_sRoleID, "Role");
        mdoRole.setContext(this.getRole());
        mdoRole.setObjectRole(this.getRole());
        mdoRole.setName(this.getRole());
        AssociationList lRoles = mdoQueryTable.getRoles(false);
        lRoles.clear();
        lRoles.add(mdoRole);
        mdoQueryTable.getColumns(false).clear();
        for (int iIds = 0; iIds < this.m_lBadColumnIDs.size(); ++iIds) {
            omr.deleteOMRObject((String)this.m_lBadColumnIDs.get(iIds), "Column");
        }
        this.setChanged(false);
    }

    @Override
    protected void saveColumns(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    protected void saveRoles(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    protected void loadQuotationSettings(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.m_bChangedDuringLoad = false;
        QueryTable mdoQueryTable = (QueryTable)omr.acquireOMRObject(this);
        this.setAliasName(mdoQueryTable.getTableName());
        AssociationList lRoles = mdoQueryTable.getRoles();
        if (!lRoles.isEmpty()) {
            Role mdoRole = (Role)lRoles.get(0);
            this.m_sRoleID = mdoRole.getFQID();
            this.m_sRole = mdoRole.getContext();
        }
        AssociationList lTargetMaps = mdoQueryTable.getTargetClassifierMaps();
        ClassifierMap mdoClassifierMap = null;
        if (!lTargetMaps.isEmpty()) {
            String sRole;
            for (int i = 0; i < lTargetMaps.size() && !(sRole = (mdoClassifierMap = (ClassifierMap)lTargetMaps.get(i)).getTransformRole()).equalsIgnoreCase(ALIAS_TRANSFORM_ROLE); ++i) {
            }
        }
        if (mdoClassifierMap != null) {
            this.m_sClassifierMapID = mdoClassifierMap.getFQID();
            AssociationList lClassifierSources = mdoClassifierMap.getClassifierSources();
            if (!lClassifierSources.isEmpty()) {
                Root dataTable = (Root)lClassifierSources.get(0);
                this.setAliasedTable((ITable)omr.acquireObject(dataTable));
            }
        }
        super.loadQuotationSettings(omr);
        this.loadBadAliasColumns(omr);
        this.setChanged(this.m_bChangedDuringLoad);
    }

    @Override
    protected void loadColumns(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    protected void loadRoles(OMRAdapter omr) throws MdException, RemoteException {
    }

    private void loadBadAliasColumns(OMRAdapter omr) throws MdException, RemoteException {
        QueryTable mdoQueryTable = (QueryTable)omr.acquireOMRObject(this);
        AssociationList lColumns = mdoQueryTable.getColumns();
        for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
            Column mdoColumn = (Column)lColumns.get(iColumn);
            this.m_lBadColumnIDs.add(mdoColumn.getFQID());
            this.m_bChangedDuringLoad = true;
        }
    }

    @Override
    public void delete() {
        this.fireNotifyEvent(0, null);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_sClassifierMapID != null && this.m_sClassifierMapID.length() > 0) {
            omr.deleteOMRObject(this.m_sClassifierMapID, "ClassifierMap");
        }
        if (this.m_sRoleID != null && this.m_sRoleID.length() > 0) {
            omr.deleteOMRObject(this.m_sRoleID, "Role");
        }
        for (int iIds = 0; iIds < this.m_lBadColumnIDs.size(); ++iIds) {
            omr.deleteOMRObject((String)this.m_lBadColumnIDs.get(iIds), "Column");
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_sClassifierMapID != null && this.m_sClassifierMapID.length() > 0) {
            this.m_sClassifierMapID = this.updateSubordinateID(this.m_sClassifierMapID, mapIDs);
        }
        if (this.m_sRoleID != null && this.m_sRoleID.length() > 0) {
            this.m_sRoleID = this.updateSubordinateID(this.m_sRoleID, mapIDs);
        }
    }

    @Override
    public String getPublicType() {
        return "";
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return new UsageVersion(1, 0);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            lAssociations.add("Roles");
            lAssociations.add("TargetClassifierMaps");
            map.put(this.getOMRType(), lAssociations);
        } else {
            lAssociations.add("Roles");
            lAssociations.add("TargetClassifierMaps");
        }
        return map;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    private class SetAliasedTableUndoable
    extends AbstractUndoableEdit {
        private ITable m_oldAliasedTable;
        private ITable m_newAliasedTable;

        public SetAliasedTableUndoable(ITable oldAliasedTable, ITable newAliasedTable) {
            this.m_oldAliasedTable = oldAliasedTable;
            this.m_newAliasedTable = newAliasedTable;
        }

        @Override
        public void undo() {
            super.undo();
            AliasTable.this.setAliasedTable(this.m_oldAliasedTable);
        }

        @Override
        public void redo() {
            super.redo();
            AliasTable.this.setAliasedTable(this.m_newAliasedTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldAliasedTable = null;
            this.m_newAliasedTable = null;
        }
    }

    private class SetAliasNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldAliasName;
        private String m_newAliasName;

        public SetAliasNameUndoable(String oldAliasName, String newAliasName) {
            this.m_oldAliasName = oldAliasName;
            this.m_newAliasName = newAliasName;
        }

        @Override
        public void undo() {
            super.undo();
            AliasTable.this.setAliasName(this.m_oldAliasName);
        }

        @Override
        public void redo() {
            super.redo();
            AliasTable.this.setAliasName(this.m_newAliasName);
        }
    }
}

