/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class AbstractSQLTransform
extends AbstractDataTransform {
    protected static final String AUTOMATIC_PASSTHRU = "DiagramPanel.AutomaticPassThru";
    protected static final boolean DEFAULT_PASSTHRU = false;
    private IDBMSType m_dbmsType;
    private boolean m_bPassThru;
    private boolean m_bPassThruEnabled;

    public AbstractSQLTransform(String id, IModel model) {
        super(id, model);
    }

    protected abstract void updateDBMSType();

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        super.addDefaultSettings();
        this.setPassThru(Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(AUTOMATIC_PASSTHRU, false));
    }

    public boolean isPassThruEnabled() {
        return this.m_bPassThruEnabled;
    }

    @Override
    public void notify(NotifyEvent ev) {
        String sType;
        if (null != ev && ev.getModelEvent() != null && "PhysicalTable:LibraryChanged".equalsIgnoreCase(sType = ev.getModelEvent().getType())) {
            this.updateSourceTableTypesAttributes();
            this.updateTargetTableTypesAttributes();
        }
    }

    protected void setPassThruEnabled(boolean enabled) {
        if (this.m_bPassThruEnabled == enabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPassThruEnabledUndoable(this.m_bPassThruEnabled, enabled));
        }
        this.m_bPassThruEnabled = enabled;
        this.fireModelChangedEvent("SQLJoinTransformModel:PassThruEnabledChanged", null);
        this.updateDBMSType();
    }

    protected void setDBMSType(IDBMSType dbmsType) {
        if (this.m_dbmsType == dbmsType) {
            return;
        }
        this.m_dbmsType = dbmsType;
        if (this.isPassThru() && this.isPassThruEnabled()) {
            this.setDBMSExecutionType(dbmsType.getDBMSTypeID());
            this.setDBMSExecutionTypeName(dbmsType.getDBMSTypeName());
            this.setExplicitOn(true);
        } else {
            this.setDBMSExecutionType(109);
            this.setDBMSExecutionTypeName("SAS");
            this.setExplicitOn(false);
        }
    }

    public IDBMSType getDBMSType() {
        return this.m_dbmsType;
    }

    protected void updateSourceTableTypesAttributes() {
    }

    protected void updateTargetTableTypesAttributes() {
    }

    public void setPassThru(boolean bPassThru) {
        if (this.m_bPassThru == bPassThru) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPassThruUndoable(this.m_bPassThru, bPassThru));
        }
        this.m_bPassThru = bPassThru;
        this.fireModelChangedEvent("SQLJoinTransformModel:PassThroughChanged", null);
        this.updateSourceTableTypesAttributes();
        this.updateTargetTableTypesAttributes();
        this.updateDBMSType();
    }

    public boolean isPassThru() {
        return this.m_bPassThru;
    }

    private class SetPassThruUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldPassThru;
        private boolean m_newPassThru;

        public SetPassThruUndoable(boolean oldPassThru, boolean newPassThru) {
            this.m_oldPassThru = oldPassThru;
            this.m_newPassThru = newPassThru;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSQLTransform.this.setPassThru(this.m_oldPassThru);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSQLTransform.this.setPassThru(this.m_newPassThru);
        }
    }

    private class SetPassThruEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldPassThruEnabled;
        private boolean m_newPassThruEnabled;

        public SetPassThruEnabledUndoable(boolean oldPassThruEnabled, boolean newPassThruEnabled) {
            this.m_oldPassThruEnabled = oldPassThruEnabled;
            this.m_newPassThruEnabled = newPassThruEnabled;
        }

        @Override
        public void undo() {
            super.undo();
            AbstractSQLTransform.this.setPassThruEnabled(this.m_oldPassThruEnabled);
        }

        @Override
        public void redo() {
            super.redo();
            AbstractSQLTransform.this.setPassThruEnabled(this.m_newPassThruEnabled);
        }
    }
}

