/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.splitter;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.transforms.splitter.IRowSelector;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.RowSelector;
import com.sas.metadata.remote.TextStore;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseRowSelector
extends AbstractPersistableObject
implements IRowSelector {
    private ITextExpression m_expression;
    private String m_sRowSelectorType = "All Rows";
    private ITable m_targetTable;
    private String m_sClassifierMapID;

    public BaseRowSelector(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    protected String getDefaultName() {
        return "Where Clause";
    }

    @Override
    public ITextExpression getExpression() {
        return this.m_expression;
    }

    @Override
    public void setExpression(ITextExpression expression) {
        if (this.m_expression == null ? expression == null : this.m_expression.equals(expression)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetExpressionUndoable(this.m_expression, expression));
        }
        if (this.m_expression != null) {
            this.addToDeletedObjects(this.m_expression);
        }
        if (expression != null) {
            this.removeFromDeletedObjects(expression);
        }
        this.m_expression = expression;
        this.fireModelChangedEvent("RowSelector:ExpressionChanged", expression);
    }

    @Override
    public ITextExpression createNewTextExpression() {
        ITextExpression exp = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
        this.setExpression(exp);
        return exp;
    }

    @Override
    public String getRowSelectorType() {
        if (this.m_sRowSelectorType == null || this.m_sRowSelectorType.length() == 0) {
            this.m_sRowSelectorType = "All Rows";
        }
        return this.m_sRowSelectorType;
    }

    @Override
    public void setRowSelectorType(String sRowType) {
        if (this.m_sRowSelectorType.equals(sRowType)) {
            return;
        }
        if (!(sRowType.equals("All Rows") || sRowType.equals("Row Selection Conditions") || sRowType.equals("User Defined Statements") || sRowType.equals("1"))) {
            throw new IllegalArgumentException("Incorrect Row Selector Type: " + sRowType);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRowSelectorTypeUndoable(this.m_sRowSelectorType, sRowType));
        }
        this.m_sRowSelectorType = sRowType;
        this.fireModelChangedEvent("RowSelector:RowSelectionTypeChanged", sRowType);
    }

    @Override
    public ITable getTable() {
        return this.m_targetTable;
    }

    @Override
    public void setTable(ITable table) {
        if (this.m_targetTable == table) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTableUndoable(this.m_targetTable, table));
        }
        this.m_targetTable = table;
        this.fireModelChangedEvent("RowSelector:TableChanged", table);
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        return this.m_expression != null && this.m_expression.isChanged();
    }

    @Override
    public boolean containsTable(ITable table) {
        if (this.m_targetTable == null) {
            return false;
        }
        return table.getID().equalsIgnoreCase(this.m_targetTable.getID());
    }

    @Override
    public void setClassifierMapID(String sClassifierID) {
        this.m_sClassifierMapID = sClassifierID;
    }

    @Override
    public String getClassifierMapID() {
        return this.m_sClassifierMapID;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        RowSelector mdoRS = (RowSelector)omr.acquireOMRObject(this);
        mdoRS.setRowsSelected(this.getRowSelectorType());
        ClassifierMap cM = (ClassifierMap)omr.acquireOMRObject(this.m_sClassifierMapID, "ClassifierMap");
        if (this.m_expression != null) {
            this.m_expression.setSubstituteVariablesAnchor((AbstractTransformation)cM);
            this.m_expression.setSourceCodeAnchor(mdoRS);
            this.m_expression.setTextStoreRole("Where Source");
            this.m_expression.saveToOMR(omr);
        }
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        RowSelector mdoRS = (RowSelector)omr.acquireOMRObject(this);
        this.setRowSelectorType(mdoRS.getRowsSelected());
        ClassifierMap mdoCM = mdoRS.getOwningClassifierMap();
        this.m_sClassifierMapID = mdoCM.getFQID();
        TextStore mdoTS = (TextStore)mdoRS.getSourceCode();
        if (mdoTS != null) {
            if (this.m_expression != null) {
                this.m_expression.setSubstituteVariablesAnchor((AbstractTransformation)mdoCM);
            } else {
                this.m_expression = this.getModel().getObjectFactory().createTextExpression(mdoTS.getFQID());
            }
            this.m_expression.setSubstituteVariablesAnchor((AbstractTransformation)mdoCM);
            this.m_expression.setSourceCodeAnchor(mdoRS);
            this.m_expression.setUseSQLSyntax(false);
            this.m_expression.loadFromOMR(omr);
        }
        this.setChanged(false);
    }

    @Override
    public String getOMRType() {
        return "RowSelector";
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_sClassifierMapID != null && this.m_sClassifierMapID.length() > 0) {
            this.m_sClassifierMapID = this.updateSubordinateID(this.m_sClassifierMapID, mapIDs);
        }
        if (this.m_expression != null) {
            this.m_expression.updateIDs(mapIDs);
        }
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get("RowSelector");
        lAssociations.add("SourceCode");
        lAssociations.add("OwningClassifierMap");
        return map;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public void dump(PrintStream strm) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getID()).append(":").append(this.getName()).append(":").append(this.getDescription()).append(":").append(this.m_sRowSelectorType);
        strm.println(sb.toString());
        this.m_expression.dump(strm);
    }

    private class SetTableUndoable
    extends AbstractUndoableEdit {
        private ITable m_oldTable;
        private ITable m_newTable;

        public SetTableUndoable(ITable oldTable, ITable newTable) {
            this.m_oldTable = oldTable;
            this.m_newTable = newTable;
        }

        @Override
        public void undo() {
            super.undo();
            BaseRowSelector.this.setTable(this.m_oldTable);
        }

        @Override
        public void redo() {
            super.redo();
            BaseRowSelector.this.setTable(this.m_newTable);
        }
    }

    private class SetExpressionUndoable
    extends AbstractUndoableEdit {
        private ITextExpression m_oldExpression;
        private ITextExpression m_newExpression;

        public SetExpressionUndoable(ITextExpression oldExpression, ITextExpression newExpression) {
            this.m_oldExpression = oldExpression;
            this.m_newExpression = newExpression;
        }

        @Override
        public void undo() {
            super.undo();
            BaseRowSelector.this.setExpression(this.m_oldExpression);
        }

        @Override
        public void redo() {
            super.redo();
            BaseRowSelector.this.setExpression(this.m_newExpression);
        }
    }

    private class SetRowSelectorTypeUndoable
    extends AbstractUndoableEdit {
        private String m_oldRowSelectorType;
        private String m_newRowSelectorType;

        public SetRowSelectorTypeUndoable(String oldRowSelectorType, String newRowSelectorType) {
            this.m_oldRowSelectorType = oldRowSelectorType;
            this.m_newRowSelectorType = newRowSelectorType;
        }

        @Override
        public void undo() {
            super.undo();
            BaseRowSelector.this.setRowSelectorType(this.m_oldRowSelectorType);
        }

        @Override
        public void redo() {
            super.redo();
            BaseRowSelector.this.setRowSelectorType(this.m_newRowSelectorType);
        }
    }
}

