/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.scd.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IFile;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DB2UNXPCType;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.data.dbmstypes.HADOOPType;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.ODBCSQLSVRPCType;
import com.sas.etl.models.data.dbmstypes.ODBCSQLSVRType;
import com.sas.etl.models.data.dbmstypes.SASHDATType;
import com.sas.etl.models.data.dbmstypes.SASIOHNAType;
import com.sas.etl.models.data.dbmstypes.SASIOHWQType;
import com.sas.etl.models.data.dbmstypes.SASIOIMPType;
import com.sas.etl.models.data.dbmstypes.SASIOLAType;
import com.sas.etl.models.data.dbmstypes.SASIOMGOType;
import com.sas.etl.models.data.dbmstypes.SASIOPIType;
import com.sas.etl.models.data.dbmstypes.SPARKType;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.UserWrittenCodeContainer;
import com.sas.etl.models.job.transforms.scd.ISCDType2TransformModel;
import com.sas.etl.models.job.transforms.scd.impl.AbstractSCDTransformModel;
import com.sas.etl.models.job.transforms.scd.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TransformationStep;
import com.sas.text.SASFormat;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class SCDType2TransformModel
extends AbstractSCDTransformModel
implements ISCDType2TransformModel {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.scd.SCDType2";
    private static final String TRANSFORMATION_ROLE = "ETLS_SCD2Loader";
    private static final String ARM_DISPLAY_NAME = "SCD2Loader";
    private static final String DIGEST_TRANSFORMROLE = "SCD2_DIGESTVARS";
    private static final String VERSION_TRANSFORMROLE = "SCD2_Version";
    private static final String MAXKEY_TRANSFORMROLE = "SCD2_MaxKeyGenerator";
    private static final String NEW_RECORD_GENKEY_TRANSFORMROLE = "SCD2_NewSurrogateKey";
    private static final String CHANGED_RECORD_GENKEY_TRANSFORMROLE = "SCD2_ChangeSurrogateKey";
    private static final String CURRENT_INDICATOR_TRANSFORMROLE = "SCD2_CurrentIndicator";
    private static final String TYPE1_COLUMNS_TRANSFORMROLE = "SCD2_Type1Columns";
    private static final String BUSINESS_KEYS_CUSTOM_LIST_NAME = "SCD2_BusinessKeys";
    public static final String GENERATED_KEY_CUSTOM_LIST_NAME = "SCD2_GeneratedKey";
    private static final String VERSION_MAP_NAME = "SCD Type 2 Version Method";
    private static final String VERSION_MAP_DESC = "Feature map used to identify the column that will be used in the SCD 2 as the version method field.";
    private static final String CURRENT_INDICATOR_MAP_NAME = "SCD Type 2 Current Indicator Method";
    private static final String CURRENT_INDICATOR_MAP_DESC = "Feature map is used to identify the column that will be used in the SCD 2 as the current indicator method field.";
    private static final String DIGEST_MAP_NAME = "SCD2 Type 2 Digest Columns";
    private static final String DIGEST_MAP_DESC = "Contains Slowly Changing Dimension Type 2 Digest Columns";
    private static final String MAXKEY_GENERATOR_MAP_NAME = "SCD Type 2 Max Key Generator";
    private static final String MAXKEY_GENERATOR_MAP_DESC = "Feature map used to identify how to generate the max key.";
    private static final String NEW_RECORD_GENKEY_MAP_NAME = "SCD Type 2 New Generated Key";
    private static final String NEW_RECORD_GENKEY_MAP_DESC = "Feature map used to identify the key calculation to use for a new record.";
    private static final String CHANGED_RECORD_GENKEY_MAP_NAME = "SCD Type 2 Changed Generated Key";
    private static final String CHANGED_RECORD_GENKEY_MAP_DESC = "Feature map used to identify the key calculation to use for an existing record that has changed.";
    private static final String TYPE1_COLUMNS_MAP_NAME = "SCD Type 1 Columns";
    private static final String TYPE1_COLUMNS_MAP_DESC = "Feature map used to identify SCD Type 1 Columns";
    private static final String MAXKEY_GENERATOR_PROPERTYSET_ROLE = "SCD2_MaxKeyGenerator";
    private static final String MAXKEY_UPDATE_PROPERTY_NAME = "MaxKeyUpdate";
    private static final String MAXKEY_NEXTKEY_VALUE_PROPERTY_NAME = "NextKeyValue";
    private static final String MAXKEY_ROW_SELECTOR_EXPRESSION_TEXTROLE = "SCD2_FeatureMap";
    private static final String RETAINEDKEY_PROPERTYSET_ROLE = "SCD2_RETAINEDKEY";
    private static final String RETAINEDKEY_PROPERTY = "RetainedKey";
    private static final String UNIQUERETAINEDKEYPROPERTY = "UniqueRetainedKey";
    private List m_mlDigestColumns = new ModelList(this, new String[]{"SCDType2TransformModel:DigestVarAdded", "SCDType2TransformModel:DigestVarRemoved", "SCDType2TransformModel:DigestVarMoved"}, 0, IColumn.class);
    private IColumn m_versionColumn;
    private IColumn m_currentIndicatorColumn;
    private IColumn m_generatedKeyColumn;
    private ITextExpression m_newRecordGenKeyExpression;
    private ITextExpression m_changedRecordGenKeyExpression;
    private boolean m_bGenerateMaxKeyCode = true;
    private boolean m_bUpdateTableWithMaxKey = false;
    private boolean m_bNextKeyValueInGenKey = false;
    private ITextExpression m_maxKeyRowSelectorExpression;
    private IColumn m_maxKeyColumn;
    private IUserWrittenCodeContainer m_maxKeyUserWrittenCodeContainer;
    private boolean m_bGenerateRetainedKey = false;
    private boolean m_bGenerateUniqueRetainedKey = false;
    private boolean m_bCurrentIndicatorTracking;
    private boolean m_bVersionNumberTracking;
    private List m_mlType1Columns = new ModelList(this, new String[]{"SCDType2TransformModel:Type1ColumnAdded", "SCDType2TransformModel:Type1ColumnRemoved", "SCDType2TransformModel:Type1ColumnMoved"}, 0, IColumn.class);
    private static final String DEFAULT_GENKEY_EXP = "sum(NewMaxKey, 1)";
    private static final String WORKSORTEDXREF = "work.etls_sortedxref";
    private static final String WORKSOURCENAME = "work.etls_source";

    public SCDType2TransformModel(String sID, IModel model) {
        super(sID, model);
        this.setChangedRecordGenKeyExpression(this.createDefaultGenKeyExpression());
        this.setNewRecordGenKeyExpression(this.createDefaultGenKeyExpression());
        this.m_maxKeyUserWrittenCodeContainer = this.getModel().getObjectFactory().createUserWrittenHelper(this);
        this.m_maxKeyUserWrittenCodeContainer.setContainerOMRType("FeatureMap");
        this.m_maxKeyUserWrittenCodeContainer.setActiveFlagLocation(2);
        this.m_maxKeyUserWrittenCodeContainer.createUserWrittenSourceCodeText();
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("SCDType2TransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("SCDType2TransformModel.Name.txt");
    }

    @Override
    protected void postAddDataTarget(IDataObject target) {
        super.postAddDataTarget(target);
        IColumn[] aCols = ((ITable)target).getColumns();
        for (int index = 0; index < aCols.length; ++index) {
            IColumn col = aCols[index];
            String sName = col.getColumnName(false);
            if (!sName.equalsIgnoreCase("PROCESSED_DTTM")) continue;
            this.setLoadTimeColumn(col);
        }
    }

    @Override
    protected void preRemoveDataTarget(IDataObject target) {
        super.preRemoveDataTarget(target);
        this.setVersionColumn(null);
        this.setCurrentIndicatorColumn(null);
        this.setMaxKeyColumn(null);
        this.setLoadTimeColumn(null);
        this.setGenerateKeyColumn(null);
        this.m_mlDigestColumns.clear();
        this.m_mlType1Columns.clear();
    }

    @Override
    public void notify(NotifyEvent ev) {
        IObject source = (IObject)ev.getSource();
        if (ev.getType() == 0) {
            if (source instanceof IColumn) {
                IColumn column = (IColumn)ev.getSource();
                if (this.m_currentIndicatorColumn == column) {
                    this.setCurrentIndicatorColumn(null);
                }
                if (this.m_versionColumn == column) {
                    this.setVersionColumn(null);
                }
                if (this.m_maxKeyColumn == column) {
                    this.setMaxKeyColumn(null);
                }
                if (this.m_mlDigestColumns.contains(column)) {
                    this.removeBusinessKeyColumn(column);
                }
                if (this.m_mlType1Columns.contains(column)) {
                    this.removeType1Column(column);
                }
            } else if (source instanceof IDataObject) {
                IDataObject dataObject = (IDataObject)source;
                if (this.getDataTargetList().contains(dataObject)) {
                    this.setCurrentIndicatorColumn(null);
                    this.setVersionColumn(null);
                    this.setMaxKeyColumn(null);
                    this.m_mlDigestColumns.clear();
                    this.m_mlType1Columns.clear();
                }
            }
        }
        if (ev.getType() == 1 && (source == this.m_changedRecordGenKeyExpression || source == this.m_maxKeyRowSelectorExpression || source == this.m_newRecordGenKeyExpression)) {
            this.fireModelChangedEvent("SCDTransfromModel:TranformChanged", source);
        }
        super.notify(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            ITable maxKeyTable;
            IColumn oldCIColumn = this.m_currentIndicatorColumn;
            IColumn oldVersionColumn = this.m_versionColumn;
            IColumn oldGeneratedKey = this.m_generatedKeyColumn;
            IColumn oldMaxKeyColumn = this.m_maxKeyColumn;
            ArrayList lOldType1Cols = new ArrayList();
            for (int iT1Col = 0; iT1Col < this.m_mlType1Columns.size(); ++iT1Col) {
                lOldType1Cols.add(this.m_mlType1Columns.get(iT1Col));
            }
            ArrayList lOldDigestCols = new ArrayList();
            for (int iDigestCol = 0; iDigestCol < this.m_mlDigestColumns.size(); ++iDigestCol) {
                lOldDigestCols.add(this.m_mlDigestColumns.get(iDigestCol));
            }
            if (this.m_newRecordGenKeyExpression != null) {
                this.m_newRecordGenKeyExpression.replaceTableColumns(oldTable, newTable);
            }
            if (this.m_changedRecordGenKeyExpression != null) {
                this.m_changedRecordGenKeyExpression.replaceTableColumns(oldTable, newTable);
            }
            if (this.m_maxKeyRowSelectorExpression != null) {
                this.m_maxKeyRowSelectorExpression.replaceTableColumns(oldTable, newTable);
            }
            super.replaceTargetTable(oldTable, newTable, columnsMap, portIndexes);
            boolean bCaseSensitive = this.isQuotingNeeded() || newTable.isQuoted();
            IColumn[] newColumns = newTable.getColumns();
            block5: for (int iCol = 0; iCol < newColumns.length; ++iCol) {
                IColumn newColumn = newColumns[iCol];
                if (oldCIColumn != null && newColumn.equalsName(oldCIColumn, bCaseSensitive) && newColumn.getType() == oldCIColumn.getType()) {
                    this.setCurrentIndicatorColumn(newColumn);
                }
                if (oldVersionColumn != null && newColumn.equalsName(oldVersionColumn, bCaseSensitive) && newColumn.getType() == oldVersionColumn.getType()) {
                    this.setVersionColumn(newColumn);
                }
                if (oldGeneratedKey != null && newColumn.equalsName(oldGeneratedKey, bCaseSensitive) && newColumn.getType() == oldGeneratedKey.getType()) {
                    this.setGenerateKeyColumn(newColumn);
                }
                for (int iT1Col = 0; iT1Col < lOldType1Cols.size(); ++iT1Col) {
                    IColumn oldT1Column = (IColumn)lOldType1Cols.get(iT1Col);
                    if (!newColumn.equalsName(oldT1Column, bCaseSensitive) || newColumn.getType() != oldT1Column.getType()) continue;
                    this.addType1Column(newColumn);
                    break;
                }
                for (int iDigestCol = 0; iDigestCol < lOldDigestCols.size(); ++iDigestCol) {
                    IColumn oldDigestCol = (IColumn)lOldDigestCols.get(iDigestCol);
                    if (!newColumn.equalsName(oldDigestCol, bCaseSensitive) || newColumn.getType() != oldDigestCol.getType()) continue;
                    this.addDigestVar(newColumn);
                    continue block5;
                }
            }
            if (oldMaxKeyColumn != null && (maxKeyTable = oldMaxKeyColumn.getTable()) != oldTable) {
                this.setMaxKeyColumn(oldMaxKeyColumn);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.isTrackChangesByCurrIndComplete() && this.isTrackChangesByVersNumComplete() && this.isType1ColumnsComplete() && this.isGeneratedKeyComplete() && this.isMaxKeyComplete() && this.isValidAsTargetTable();
    }

    public boolean isValidAsTargetTable() {
        IPhysicalTable target = (IPhysicalTable)this.getDataTarget();
        boolean bValidTargetTypes = true;
        IDBMSType oDBMSType = target.getDBMSType();
        if (oDBMSType instanceof SASIOPIType || oDBMSType instanceof SASIOHWQType || oDBMSType instanceof SASHDATType || oDBMSType instanceof SASIOLAType || oDBMSType instanceof SASIOIMPType || oDBMSType instanceof HADOOPType || oDBMSType instanceof SPARKType || oDBMSType instanceof SASIOMGOType) {
            bValidTargetTypes = false;
        }
        return bValidTargetTypes;
    }

    protected boolean isType1ColumnsComplete() {
        for (int index = 0; index < this.m_mlType1Columns.size(); ++index) {
            IColumn column = (IColumn)this.m_mlType1Columns.get(index);
            if (column == this.m_versionColumn && this.isTrackChangesByVersionNumber()) {
                return false;
            }
            if (column == this.m_currentIndicatorColumn && this.isTrackChangesByCurrentIndicator()) {
                return false;
            }
            if (column == this.getFromDateColumn() && this.isTrackChangesByDates()) {
                return false;
            }
            if (column == this.getToDateColumn() && this.isTrackChangesByDates()) {
                return false;
            }
            if (column == this.getLoadTimeColumn()) {
                return false;
            }
            IColumn[] busCols = this.getBusinessKeyColumns();
            for (int index2 = 0; index2 < busCols.length; ++index2) {
                if (column != busCols[index2]) continue;
                return false;
            }
            IColumn[] digestCols = this.getDigestVars();
            for (int index2 = 0; index2 < digestCols.length; ++index2) {
                if (column != digestCols[index2]) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isTrackChangesByCurrIndComplete() {
        return !this.isTrackChangesByCurrentIndicator() || this.m_currentIndicatorColumn != null;
    }

    protected boolean isTrackChangesByVersNumComplete() {
        return !this.isTrackChangesByVersionNumber() || this.m_versionColumn != null;
    }

    protected boolean isGeneratedKeyComplete() {
        if ((this.isTrackChangesByCurrentIndicator() || this.isTrackChangesByVersionNumber()) && !this.isTrackChangesByDates()) {
            return this.m_generatedKeyColumn != null;
        }
        return true;
    }

    protected boolean isMaxKeyComplete() {
        if (this.isGenerateMaxKeyCode()) {
            if (this.m_maxKeyColumn != null) {
                ITable table = this.m_maxKeyColumn.getTable();
                if (table == null) {
                    return false;
                }
                if (this.m_maxKeyRowSelectorExpression != null) {
                    return table.isComplete() && this.m_maxKeyRowSelectorExpression.isComplete();
                }
                return table.isComplete();
            }
        } else {
            return this.m_maxKeyUserWrittenCodeContainer.isComplete();
        }
        return true;
    }

    @Override
    protected boolean isLoadTimeColumnValid() {
        IColumn loadtime = this.getLoadTimeColumn();
        if (loadtime == null) {
            return true;
        }
        if (loadtime == this.m_generatedKeyColumn) {
            return false;
        }
        if (loadtime == this.m_versionColumn && this.isTrackChangesByVersionNumber()) {
            return false;
        }
        if (loadtime == this.m_currentIndicatorColumn && this.isTrackChangesByCurrentIndicator()) {
            return false;
        }
        if (loadtime == this.getFromDateColumn() && this.isTrackChangesByDates()) {
            return false;
        }
        if (loadtime == this.getToDateColumn() && this.isTrackChangesByDates()) {
            return false;
        }
        IColumn[] busCols = this.getBusinessKeyColumns();
        for (int index = 0; index < busCols.length; ++index) {
            if (loadtime != busCols[index]) continue;
            return false;
        }
        IColumn[] digestCols = this.getDigestVars();
        for (int index = 0; index < digestCols.length; ++index) {
            if (loadtime != digestCols[index]) continue;
            return false;
        }
        IColumn[] type1Cols = this.getType1Columns();
        for (int index = 0; index < type1Cols.length; ++index) {
            if (loadtime != type1Cols[index]) continue;
            return false;
        }
        return super.isLoadTimeColumnValid();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.getDataTarget() != null && !this.isValidAsTargetTable()) {
            lReasons.add(RB.getStringResource("SCDType2TransformModel.ReasonIncomplete.InvalidTargetTableType.txt"));
        }
        if (this.isTrackChangesByCurrentIndicator() && this.m_currentIndicatorColumn == null) {
            lReasons.add(RB.getStringResource("SCDType2TransformModel.ReasonIncomplete.NoCIColumn.txt"));
        }
        if (this.isTrackChangesByVersionNumber() && this.m_versionColumn == null) {
            lReasons.add(RB.getStringResource("SCDType2TransformModel.ReasonIncomplete.NoVerColumn.txt"));
        }
        if (!this.isType1ColumnsComplete()) {
            lReasons.add(RB.getStringResource("SCDType2TransformModel.ReasonIncomplete.InvalidType1Col.txt"));
        }
        if (!this.isLoadTimeColumnValid()) {
            lReasons.add(RB.getStringResource("SCDType2TransformModel.ReasonIncomplete.InvalidLoadtime.txt"));
        }
        if (this.getBusinessKeyColumnsList().size() == 0) {
            lReasons.add(RB.getStringResource("SCDType2TransformModel.ReasonIncomplete.NoBusKeyColumns.txt"));
        }
        if (!this.isBusinessKeyComplete()) {
            lReasons.add(RB.getStringResource("SCDType2TransformModel.ReasonIncomplete.InvalidBusKey.txt"));
        }
        if (!this.isGeneratedKeyComplete()) {
            lReasons.add(RB.getStringResource("SCDType2TransformModel.ReasonIncomplete.NoGeneratedKeyColumn.txt"));
        }
        if (!this.isMaxKeyComplete()) {
            ITable table = this.m_maxKeyColumn.getTable();
            if (table == null) {
                lReasons.add(RB.getStringResource("SCDType2TransformModel.ReasonIncomplete.MissingMaxKeyTable.txt"));
            } else {
                lReasons.addAll(table.getReasonsIncomplete());
            }
            if (this.m_maxKeyRowSelectorExpression != null && !this.m_maxKeyRowSelectorExpression.isComplete()) {
                lReasons.add(RB.getStringResource("SCDType2TransformModel.ResaonIncomplete.InvalidMaxKeyExpr.txt"));
            }
            if (this.m_maxKeyUserWrittenCodeContainer != null && this.m_maxKeyUserWrittenCodeContainer.isActive() && !this.m_maxKeyUserWrittenCodeContainer.isComplete()) {
                lReasons.addAll(this.m_maxKeyUserWrittenCodeContainer.getReasonsIncomplete());
            }
        }
        return lReasons;
    }

    public ITextExpression createDefaultGenKeyExpression() {
        ITextExpression expression = this.getObjectFactory().createNewTextExpression(this.getID());
        expression.setText(DEFAULT_GENKEY_EXP, new IColumn[0]);
        return expression;
    }

    @Override
    public void setTrackChangesByDates(boolean bValue) {
        if (this.isTrackChangesByDates() == bValue) {
            return;
        }
        this.getModel().startCompoundUndoable();
        try {
            super.setTrackChangesByDates(bValue);
            if (!bValue) {
                this.setGenerateRetainedKey(false);
                this.setGenerateUniqueRetainedKey(false);
            }
        }
        finally {
            this.getModel().endCompoundUndoable();
        }
    }

    @Override
    public boolean isTrackChangesByVersionNumber() {
        return this.m_bVersionNumberTracking;
    }

    @Override
    public void setTrackChangesByVersionNumber(boolean bOption) {
        if (this.m_bVersionNumberTracking == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTrackChangesByVersionNumberUndoable(this.m_bCurrentIndicatorTracking, bOption));
        }
        this.m_bVersionNumberTracking = bOption;
        this.fireModelChangedEvent("SCDType2TransformModel:VersionNumberTrackingChanged", null);
    }

    @Override
    public IColumn getVersionColumn() {
        return this.m_versionColumn;
    }

    @Override
    public void setVersionColumn(IColumn column) {
        if (this.m_versionColumn == column) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetVersionColumnUndoable(this.m_versionColumn, column));
        }
        this.m_versionColumn = column;
        this.fireModelChangedEvent("SCDType2TransformModel:VersionColumnChanged", this.m_versionColumn);
    }

    @Override
    public boolean isTrackChangesByCurrentIndicator() {
        return this.m_bCurrentIndicatorTracking;
    }

    @Override
    public void setTrackChangesByCurrentIndicator(boolean bOption) {
        if (this.m_bCurrentIndicatorTracking == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTrackChangesByCurrentIndicatorUndoable(this.m_bCurrentIndicatorTracking, bOption));
        }
        this.m_bCurrentIndicatorTracking = bOption;
        this.fireModelChangedEvent("SCDType2TransformModel:CurrentIndicatorTrackingChanged", null);
    }

    @Override
    public IColumn getCurrentIndicatorColumn() {
        return this.m_currentIndicatorColumn;
    }

    public String getCurrentIndicatorYesValue() {
        String currentIndicatorYesValue = "'Y'";
        if (this.getCurrentIndicatorColumn() != null) {
            if (this.getCurrentIndicatorColumn().getType() == 1) {
                currentIndicatorYesValue = "1";
                return currentIndicatorYesValue;
            }
            if (this.getCurrentIndicatorColumn().getType() == 0) {
                return currentIndicatorYesValue;
            }
        }
        return "";
    }

    public String getCurrentIndicatorNoValue() {
        String currentIndicatorYesValue = "'N'";
        if (this.getCurrentIndicatorColumn() != null) {
            if (this.getCurrentIndicatorColumn().getType() == 1) {
                currentIndicatorYesValue = "0";
                return currentIndicatorYesValue;
            }
            if (this.getCurrentIndicatorColumn().getType() == 0) {
                return currentIndicatorYesValue;
            }
        }
        return "";
    }

    @Override
    public void setCurrentIndicatorColumn(IColumn column) {
        if (this.m_currentIndicatorColumn != null && this.m_currentIndicatorColumn == column) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCurrentIndicatorColumnUndoable(this.m_currentIndicatorColumn, column));
        }
        this.m_currentIndicatorColumn = column;
        this.fireModelChangedEvent("SCDType2TransformModel:CurrentIndicatiorColumnChanged", this.m_currentIndicatorColumn);
    }

    @Override
    public IColumn getGenerateKeyColumn() {
        return this.m_generatedKeyColumn;
    }

    @Override
    public void setGenerateKeyColumn(IColumn column) {
        if (this.m_generatedKeyColumn == column) {
            return;
        }
        IColumn oldGeneratedKeyColumn = this.m_generatedKeyColumn;
        this.startCompoundUndoable();
        try {
            this.setGenerateKeyColumnImpl(column);
            if (this.m_generatedKeyColumn != null) {
                this.setChangedRecordGenKeyExpression(this.createDefaultGenKeyExpression());
                this.setNewRecordGenKeyExpression(this.createDefaultGenKeyExpression());
                if (oldGeneratedKeyColumn == this.getMaxKeyColumn()) {
                    this.setMaxKeyColumn(this.m_generatedKeyColumn);
                }
                this.m_maxKeyUserWrittenCodeContainer = this.getModel().getObjectFactory().createUserWrittenHelper(this);
                this.m_maxKeyUserWrittenCodeContainer.setContainerOMRType("FeatureMap");
                this.m_maxKeyUserWrittenCodeContainer.setActiveFlagLocation(2);
                this.m_maxKeyUserWrittenCodeContainer.createUserWrittenSourceCodeText();
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void setGenerateKeyColumnImpl(IColumn column) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetGeneratedKeyColumnUndoable(this.m_generatedKeyColumn, column));
        }
        this.m_generatedKeyColumn = column;
        this.fireModelChangedEvent("SCDType2TransformModel:GeneratedKeyColumnChanged", this.m_generatedKeyColumn);
    }

    @Override
    public boolean isGenerateMaxKeyCode() {
        return this.m_bGenerateMaxKeyCode;
    }

    @Override
    public void setGenerateMaxKeyCode(boolean bOption) {
        if (this.m_bGenerateMaxKeyCode == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetGenerateMaxKeyCodeUndoable(this.m_bGenerateMaxKeyCode, bOption));
        }
        this.m_bGenerateMaxKeyCode = bOption;
        this.fireModelChangedEvent("SCDTransformModel:GenerateMaxKeyCodeChanged", null);
    }

    @Override
    public boolean isNextKeyValueInGenKey() {
        return this.m_bNextKeyValueInGenKey;
    }

    @Override
    public void setNextKeyValueInGenKey(boolean bOption) {
        if (this.m_bNextKeyValueInGenKey == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNextKeyValueInGenKeyUndoable(this.m_bNextKeyValueInGenKey, bOption));
        }
        this.m_bNextKeyValueInGenKey = bOption;
        this.fireModelChangedEvent("SCDTransformModel:NextKeyInGenKeyChanged", null);
    }

    @Override
    public boolean isUpdateTableWithMaxKey() {
        return this.m_bUpdateTableWithMaxKey;
    }

    @Override
    public void setUpdateTableWithMaxKey(boolean bOption) {
        if (this.m_bUpdateTableWithMaxKey == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUpdateTableWithMaxKeyUndoable(this.m_bUpdateTableWithMaxKey, bOption));
        }
        this.m_bUpdateTableWithMaxKey = bOption;
        this.fireModelChangedEvent("SCDTransformModel:UpdateTableWithMaxKeyChanged", null);
    }

    @Override
    public boolean isUseMaxKeyUserWrittenCode() {
        return this.m_maxKeyUserWrittenCodeContainer.isActive();
    }

    public void setUseMaxKeyUserWrittenExpression(String expression) {
        this.m_maxKeyUserWrittenCodeContainer.setUserWrittenCode(expression);
    }

    @Override
    public void setUseMaxKeyUserWrittenCode(boolean bOption) {
        this.startCompoundUndoable();
        try {
            this.m_maxKeyUserWrittenCodeContainer.setIsActive(bOption);
            if (!bOption) {
                this.m_maxKeyUserWrittenCodeContainer.setUserWrittenCode("");
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IUserWrittenCodeContainer getMaxKeyUserWrittenCode() {
        return this.m_maxKeyUserWrittenCodeContainer;
    }

    @Override
    public void setMaxKeyUserWrittenCode(ICodeSource code) {
        if (this.m_maxKeyUserWrittenCodeContainer != null) {
            this.m_maxKeyUserWrittenCodeContainer.setUserWrittenSourceCode(code);
        }
    }

    @Override
    public boolean isGenerateRetainedKey() {
        return this.m_bGenerateRetainedKey;
    }

    @Override
    public void setGenerateRetainedKey(boolean bOption) {
        if (this.m_bGenerateRetainedKey == bOption) {
            return;
        }
        this.startCompoundUndoable();
        try {
            this.setGenerateRetainedKeyImpl(bOption);
            if (this.isGenerateRetainedKey()) {
                this.setChangedRecordGenKeyExpression(null);
            } else {
                this.setChangedRecordGenKeyExpression(this.createDefaultGenKeyExpression());
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void setGenerateRetainedKeyImpl(boolean bOption) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new GenerateRetainedKeyUndoable(this.m_bGenerateRetainedKey, bOption));
        }
        this.m_bGenerateRetainedKey = bOption;
        this.fireModelChangedEvent("SCDType2TransformModel:GenerateRetainedKeyChanged", null);
    }

    @Override
    public boolean isGenerateUniqueRetainedKey() {
        return this.m_bGenerateUniqueRetainedKey;
    }

    @Override
    public void setGenerateUniqueRetainedKey(boolean bOption) {
        if (this.m_bGenerateUniqueRetainedKey == bOption) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new GenerateUniqueRetainedKeyUndoable(this.m_bGenerateUniqueRetainedKey, bOption));
        }
        this.m_bGenerateUniqueRetainedKey = bOption;
        this.fireModelChangedEvent("SCDType2TransformModel:GenerateUniqueRetainedKeyChanged", null);
    }

    @Override
    public ITextExpression getChangedRecordGenKeyExpression() {
        return this.m_changedRecordGenKeyExpression;
    }

    @Override
    public void setChangedRecordGenKeyExpression(ITextExpression expression) {
        if (this.m_changedRecordGenKeyExpression != null && this.m_changedRecordGenKeyExpression.equals(expression)) {
            return;
        }
        if (this.m_changedRecordGenKeyExpression != null) {
            this.addToDeletedObjects(this.m_changedRecordGenKeyExpression);
            this.m_changedRecordGenKeyExpression.removeNotifyListener(this);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetChangedRecordGenKeyExpressionUndoable(this.m_changedRecordGenKeyExpression, expression));
        }
        if (expression != null) {
            this.removeFromDeletedObjects(expression);
        }
        this.m_changedRecordGenKeyExpression = expression;
        if (this.m_changedRecordGenKeyExpression != null) {
            this.m_changedRecordGenKeyExpression.addNotifyListener(this);
        }
        this.fireModelChangedEvent("SCDType2TransformModel:ChgRecGenKeyExpressionChanged", this.m_changedRecordGenKeyExpression);
    }

    @Override
    public ITextExpression getNewRecordGenKeyExpression() {
        return this.m_newRecordGenKeyExpression;
    }

    @Override
    public void setNewRecordGenKeyExpression(ITextExpression expression) {
        if (this.m_newRecordGenKeyExpression != null && this.m_newRecordGenKeyExpression.equals(expression)) {
            return;
        }
        if (this.m_newRecordGenKeyExpression != null) {
            this.addToDeletedObjects(this.m_newRecordGenKeyExpression);
            this.m_newRecordGenKeyExpression.removeNotifyListener(this);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetNewRecordGenKeyExpressionUndoable(this.m_newRecordGenKeyExpression, expression));
        }
        if (expression != null) {
            this.removeFromDeletedObjects(expression);
        }
        this.m_newRecordGenKeyExpression = expression;
        if (this.m_newRecordGenKeyExpression != null) {
            this.m_newRecordGenKeyExpression.addNotifyListener(this);
        }
        this.fireModelChangedEvent("SCDType2TransformModel:NewRecGenKeyExpressionChanged", this.m_newRecordGenKeyExpression);
    }

    @Override
    public String getNewRecordGenKeyExpressionText() {
        ITable[] targets = this.getTargetTables();
        if (targets == null || targets.length == 0) {
            return null;
        }
        try {
            if (this.m_newRecordGenKeyExpression != null) {
                return this.m_newRecordGenKeyExpression.getText(null, targets[0].isQuoted());
            }
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (CodegenException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadServerDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadLibraryDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (ServerException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNewRecordGenKeyExpressionText(String text) {
        ITable[] targets = this.getTargetTables();
        if (targets == null || targets.length == 0) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.m_newRecordGenKeyExpression == null) {
                ITextExpression expression = this.createNewTextExpression();
                this.setNewRecordGenKeyExpression(expression);
            }
            this.m_newRecordGenKeyExpression.setText(text, targets[0].getColumns());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public String getChangedRecordGenKeyExpressionText() {
        ITable[] targets = this.getTargetTables();
        if (targets == null || targets.length == 0) {
            return null;
        }
        try {
            if (this.m_changedRecordGenKeyExpression != null) {
                return this.m_changedRecordGenKeyExpression.getText(null, targets[0].isQuoted());
            }
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (CodegenException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadServerDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadLibraryDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (ServerException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChangedRecordGenKeyExpressionText(String text) {
        ITable[] targets = this.getTargetTables();
        if (targets == null || targets.length == 0) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.m_changedRecordGenKeyExpression == null) {
                ITextExpression expression = this.createNewTextExpression();
                this.setChangedRecordGenKeyExpression(expression);
            }
            this.m_changedRecordGenKeyExpression.setText(text, targets[0].getColumns());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public ITextExpression getMaxKeyRowSelectorExpression() {
        return this.m_maxKeyRowSelectorExpression;
    }

    @Override
    public void setMaxKeyRowSelectorExpression(ITextExpression expression) {
        if (this.m_maxKeyRowSelectorExpression != null && this.m_maxKeyRowSelectorExpression.equals(expression)) {
            return;
        }
        this.getModel().startCompoundUndoable();
        try {
            if (this.m_maxKeyRowSelectorExpression != null) {
                this.addToDeletedObjects(this.m_maxKeyRowSelectorExpression);
                this.m_maxKeyRowSelectorExpression.removeNotifyListener(this);
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetMaxKeyRowSelectorExpressionUndoable(this.m_maxKeyRowSelectorExpression, expression));
            }
            if (expression != null) {
                this.removeFromDeletedObjects(expression);
            }
            this.m_maxKeyRowSelectorExpression = expression;
            if (this.m_maxKeyRowSelectorExpression != null) {
                this.m_maxKeyRowSelectorExpression.addNotifyListener(this);
            }
            if (this.m_maxKeyRowSelectorExpression != null) {
                this.m_maxKeyRowSelectorExpression.setTextStoreRole(MAXKEY_ROW_SELECTOR_EXPRESSION_TEXTROLE);
            }
        }
        finally {
            this.getModel().endCompoundUndoable();
        }
        this.fireModelChangedEvent("SCDTransformModel:MaxkeyExpressionChanged", this.m_maxKeyRowSelectorExpression);
    }

    @Override
    public IColumn getMaxKeyColumn() {
        return this.m_maxKeyColumn;
    }

    @Override
    public void setMaxKeyColumn(IColumn column) {
        if (this.m_maxKeyColumn == column) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMaxKeyColumnUndoable(this.m_maxKeyColumn, column));
        }
        this.m_maxKeyColumn = column;
        this.fireModelChangedEvent("SCDTransformModel:MaxkeyColumnChanged", this.m_maxKeyColumn);
    }

    @Override
    public String getMaxKeyRowSelectorExpressionText() {
        ITable[] targets = this.getTargetTables();
        if (targets == null || targets.length == 0) {
            return null;
        }
        try {
            if (this.m_maxKeyRowSelectorExpression != null) {
                return this.m_maxKeyRowSelectorExpression.getText(null, targets[0].isQuoted());
            }
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (CodegenException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadServerDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (BadLibraryDefinitionException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        catch (ServerException e) {
            ModelLogger.getDefaultLogger().error((Object)"Exception", (Throwable)e);
        }
        return "";
    }

    @Override
    public void setMaxKeyRowSelectorExpressionText(String text) {
        this.startCompoundUndoable();
        try {
            if (this.m_maxKeyRowSelectorExpression == null) {
                ITextExpression expression = this.createNewTextExpression();
                this.setMaxKeyRowSelectorExpression(expression);
            }
            this.m_maxKeyRowSelectorExpression.setText(text, this.m_maxKeyColumn.getTable().getColumns());
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected ITextExpression createNewTextExpression() {
        return this.getModel().getObjectFactory().createNewTextExpression(this.getID());
    }

    @Override
    public void addDigestVar(IColumn column) {
        this.m_mlDigestColumns.add(this.m_mlDigestColumns.size(), column);
    }

    @Override
    public void addDigestVar(int index, IColumn column) {
        this.m_mlDigestColumns.add(index, column);
    }

    @Override
    public List getDigestVarsList() {
        return this.m_mlDigestColumns;
    }

    @Override
    public IColumn[] getDigestVars() {
        return this.m_mlDigestColumns.toArray(new IColumn[this.m_mlDigestColumns.size()]);
    }

    @Override
    public void removeDigestVar(IColumn column) {
        this.m_mlDigestColumns.remove(column);
    }

    @Override
    public void addType1Column(IColumn column) {
        this.m_mlType1Columns.add(this.m_mlType1Columns.size(), column);
    }

    @Override
    public void addType1Column(int index, IColumn column) {
        this.m_mlType1Columns.add(index, column);
    }

    @Override
    public List getType1ColumnsList() {
        return this.m_mlType1Columns;
    }

    @Override
    public IColumn[] getType1Columns() {
        return this.m_mlType1Columns.toArray(new IColumn[this.m_mlType1Columns.size()]);
    }

    @Override
    public void removeType1Column(IColumn column) {
        this.m_mlType1Columns.remove(column);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws RemoteException, MdException {
        IMapping versionMapping;
        IMapping type1ColumnsMapping;
        IMapping digestVarsMapping;
        super.loadFromOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        this.m_mlDigestColumns.clear();
        this.m_mlType1Columns.clear();
        IPersistableObject[] lGeneratedKey = this.loadCustomListFromOMR(omr, GENERATED_KEY_CUSTOM_LIST_NAME);
        if (lGeneratedKey.length > 0) {
            this.m_generatedKeyColumn = (IColumn)lGeneratedKey[0];
        }
        if (this.m_generatedKeyColumn != null) {
            IMapping maxKeyMapping;
            IMapping chgRecordKeyMapping;
            CustomAssociation mdoCA = this.findCustomList(omr, (Root)mdoStep, GENERATED_KEY_CUSTOM_LIST_NAME);
            String sRetainedKey = this.loadPropertyFromOMR(omr, (Root)mdoCA, RETAINEDKEY_PROPERTYSET_ROLE, RETAINEDKEY_PROPERTY, "N", 0);
            this.m_bGenerateRetainedKey = sRetainedKey.equalsIgnoreCase("Y");
            String sUniqueRetainedKey = this.loadPropertyFromOMR(omr, (Root)mdoCA, RETAINEDKEY_PROPERTYSET_ROLE, UNIQUERETAINEDKEYPROPERTY, "N", 0);
            this.m_bGenerateUniqueRetainedKey = sUniqueRetainedKey.equalsIgnoreCase("Y");
            IMapping newRecordKeyMapping = this.findTargetMapping(NEW_RECORD_GENKEY_TRANSFORMROLE);
            if (newRecordKeyMapping != null) {
                this.m_newRecordGenKeyExpression = (ITextExpression)newRecordKeyMapping.getExpression();
            }
            if (!this.isGenerateRetainedKey() && (chgRecordKeyMapping = this.findTargetMapping(CHANGED_RECORD_GENKEY_TRANSFORMROLE)) != null) {
                this.m_changedRecordGenKeyExpression = (ITextExpression)chgRecordKeyMapping.getExpression();
            }
            if ((maxKeyMapping = this.findTargetMapping("SCD2_MaxKeyGenerator")) != null) {
                String sUpdateTableWithMaxKey;
                FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(maxKeyMapping);
                if (maxKeyMapping.getTargetCount() > 0) {
                    this.m_maxKeyColumn = maxKeyMapping.getTargets()[0];
                    Column mdoCol = (Column)omr.acquireOMRObject(this.m_maxKeyColumn);
                    omr.acquireObject((Root)mdoCol.getTable());
                } else {
                    this.m_maxKeyColumn = this.m_generatedKeyColumn;
                }
                ITextExpression maxKeyRowSelectorExpression = (ITextExpression)maxKeyMapping.getExpression();
                if (maxKeyRowSelectorExpression != null) {
                    String sRole = maxKeyRowSelectorExpression.getTextStoreRole();
                    if (sRole.equalsIgnoreCase(MAXKEY_ROW_SELECTOR_EXPRESSION_TEXTROLE)) {
                        this.setMaxKeyRowSelectorExpression(maxKeyRowSelectorExpression);
                        this.setGenerateMaxKeyCode(true);
                    } else {
                        this.setGenerateMaxKeyCode(false);
                        this.m_maxKeyUserWrittenCodeContainer.setTextRole(maxKeyRowSelectorExpression.getTextStoreRole());
                        this.m_maxKeyUserWrittenCodeContainer.setName(maxKeyMapping.getName());
                        this.m_maxKeyUserWrittenCodeContainer.setActiveFlagLocation(2);
                        this.m_maxKeyUserWrittenCodeContainer.setContainer((AbstractTransformation)mdoFM);
                        this.m_maxKeyUserWrittenCodeContainer.setContainerRole("SCD2_MaxKeyGenerator");
                        this.m_maxKeyUserWrittenCodeContainer.loadFromOMR(omr);
                    }
                } else {
                    Text mdoFile = mdoFM.getSourceCode();
                    if (mdoFile != null && mdoFile.getCMetadataType().equalsIgnoreCase("File")) {
                        this.setGenerateMaxKeyCode(false);
                        maxKeyMapping.setExpression(null);
                        IFile file = (IFile)omr.acquireObject((Root)mdoFile);
                        this.m_maxKeyUserWrittenCodeContainer.setName(file.getName());
                        this.m_maxKeyUserWrittenCodeContainer.setActiveFlagLocation(2);
                        this.m_maxKeyUserWrittenCodeContainer.setContainer((AbstractTransformation)mdoFM);
                        this.m_maxKeyUserWrittenCodeContainer.setContainerRole("SCD2_MaxKeyGenerator");
                        this.m_maxKeyUserWrittenCodeContainer.loadFromOMR(omr);
                    }
                }
                String sNextKeyValueInGenKey = this.loadPropertyFromOMR(omr, (Root)mdoFM, "SCD2_MaxKeyGenerator", MAXKEY_NEXTKEY_VALUE_PROPERTY_NAME, "", 0);
                if (sNextKeyValueInGenKey != null) {
                    this.m_bNextKeyValueInGenKey = sNextKeyValueInGenKey.equalsIgnoreCase("Y");
                }
                if ((sUpdateTableWithMaxKey = this.loadPropertyFromOMR(omr, (Root)mdoFM, "SCD2_MaxKeyGenerator", MAXKEY_UPDATE_PROPERTY_NAME, "", 0)) != null) {
                    this.m_bUpdateTableWithMaxKey = sUpdateTableWithMaxKey.equalsIgnoreCase("Y");
                }
            } else {
                this.m_maxKeyColumn = this.m_generatedKeyColumn;
            }
        }
        if ((digestVarsMapping = this.findTargetMapping(DIGEST_TRANSFORMROLE)) != null) {
            IColumn[] lDigestVars = digestVarsMapping.getTargets();
            for (int i = 0; i < lDigestVars.length; ++i) {
                this.m_mlDigestColumns.add(lDigestVars[i]);
            }
        }
        if ((type1ColumnsMapping = this.findTargetMapping(TYPE1_COLUMNS_TRANSFORMROLE)) != null) {
            IColumn[] lType1Columns = type1ColumnsMapping.getTargets();
            for (int i = 0; i < lType1Columns.length; ++i) {
                this.m_mlType1Columns.add(lType1Columns[i]);
            }
        }
        if ((versionMapping = this.findTargetMapping(VERSION_TRANSFORMROLE)) != null) {
            if (versionMapping.getTargetCount() > 0) {
                this.m_versionColumn = versionMapping.getTargets()[0];
            }
            this.setTrackChangesByVersionNumber(true);
        } else {
            this.setTrackChangesByVersionNumber(false);
        }
        IMapping currentIndMapping = this.findTargetMapping(CURRENT_INDICATOR_TRANSFORMROLE);
        if (currentIndMapping != null) {
            if (currentIndMapping.getTargetCount() > 0) {
                this.m_currentIndicatorColumn = currentIndMapping.getTargets()[0];
            }
            this.setTrackChangesByCurrentIndicator(true);
        } else {
            this.setTrackChangesByCurrentIndicator(false);
        }
        if (!(this.isTrackChangesByDates() || this.isTrackChangesByCurrentIndicator() || this.isTrackChangesByVersionNumber())) {
            this.setTrackChangesByDates(true);
        }
        this.setChanged(false);
    }

    @Override
    protected void loadBusinessKeyColumns(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] lBusinessKeys = this.loadCustomListFromOMR(omr, BUSINESS_KEYS_CUSTOM_LIST_NAME);
        for (int i = 0; i < lBusinessKeys.length; ++i) {
            this.addBusinessKeyColumn((IColumn)lBusinessKeys[i]);
        }
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        this.cleanupMappings();
        super.saveToOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        mdoCM.setTransformRole(TRANSFORMATION_ROLE);
        IPersistableObject[] generatedKeyColumns = null;
        generatedKeyColumns = this.m_generatedKeyColumn != null ? new IColumn[]{this.m_generatedKeyColumn} : new IColumn[]{};
        this.saveCustomListToOMR(omr, GENERATED_KEY_CUSTOM_LIST_NAME, generatedKeyColumns);
        CustomAssociation mdoCA = this.findCustomList(omr, (Root)mdoStep, GENERATED_KEY_CUSTOM_LIST_NAME);
        this.savePropertyToOMR(omr, omr.acquireOMRObject(mdoCA.getFQID(), "CustomAssociation"), RETAINEDKEY_PROPERTYSET_ROLE, RETAINEDKEY_PROPERTY, RETAINEDKEY_PROPERTY, RETAINEDKEY_PROPERTY, this.m_bGenerateRetainedKey ? "Y" : "N", 12, 0);
        this.savePropertyToOMR(omr, omr.acquireOMRObject(mdoCA.getFQID(), "CustomAssociation"), RETAINEDKEY_PROPERTYSET_ROLE, UNIQUERETAINEDKEYPROPERTY, UNIQUERETAINEDKEYPROPERTY, UNIQUERETAINEDKEYPROPERTY, this.m_bGenerateUniqueRetainedKey ? "Y" : "N", 12, 0);
        this.setChanged(false);
    }

    @Override
    protected void saveBusinessKeyColumns(OMRAdapter omr) throws MdException, RemoteException {
        if (this.getBusinessKeyColumnsList().size() > 0) {
            this.saveCustomListToOMR(omr, BUSINESS_KEYS_CUSTOM_LIST_NAME, this.getBusinessKeyColumns());
        }
    }

    @Override
    protected void saveMappingsToOMR(OMRAdapter omr, ClassifierMap mdoCM, ITable tblTarget) throws MdException, RemoteException {
        if (this.m_mlDigestColumns.size() > 0) {
            this.addSCDMapping(DIGEST_TRANSFORMROLE, DIGEST_MAP_NAME, DIGEST_MAP_DESC, this.m_mlDigestColumns);
        }
        if (this.m_versionColumn != null && this.isTrackChangesByVersionNumber()) {
            this.addSCDMapping(VERSION_TRANSFORMROLE, VERSION_MAP_NAME, VERSION_MAP_DESC, this.m_versionColumn);
        }
        if (this.m_currentIndicatorColumn != null && this.isTrackChangesByCurrentIndicator()) {
            this.addSCDMapping(CURRENT_INDICATOR_TRANSFORMROLE, CURRENT_INDICATOR_MAP_NAME, CURRENT_INDICATOR_MAP_DESC, this.m_currentIndicatorColumn);
        }
        if (this.m_mlType1Columns.size() > 0) {
            this.addSCDMapping(TYPE1_COLUMNS_TRANSFORMROLE, TYPE1_COLUMNS_MAP_NAME, TYPE1_COLUMNS_MAP_DESC, this.m_mlType1Columns);
        }
        if (this.m_generatedKeyColumn != null) {
            if (this.m_newRecordGenKeyExpression != null) {
                this.addSCDMapping(NEW_RECORD_GENKEY_TRANSFORMROLE, NEW_RECORD_GENKEY_MAP_NAME, NEW_RECORD_GENKEY_MAP_DESC, this.m_generatedKeyColumn, this.m_newRecordGenKeyExpression);
            }
            if (this.m_changedRecordGenKeyExpression != null && !this.isGenerateRetainedKey()) {
                this.addSCDMapping(CHANGED_RECORD_GENKEY_TRANSFORMROLE, CHANGED_RECORD_GENKEY_MAP_NAME, CHANGED_RECORD_GENKEY_MAP_DESC, this.m_generatedKeyColumn, this.m_changedRecordGenKeyExpression);
            }
            if (this.isGenerateMaxKeyCode()) {
                if (this.m_maxKeyColumn != null && this.m_maxKeyColumn != this.m_generatedKeyColumn) {
                    IMapping mapping = this.addSCDMapping("SCD2_MaxKeyGenerator", MAXKEY_GENERATOR_MAP_NAME, MAXKEY_GENERATOR_MAP_DESC, this.m_maxKeyColumn, this.m_maxKeyRowSelectorExpression);
                    FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(mapping);
                    String maxKeyFlag = this.m_bNextKeyValueInGenKey ? "Y" : "N";
                    this.savePropertyToOMR(omr, (Root)mdoFM, "SCD2_MaxKeyGenerator", MAXKEY_NEXTKEY_VALUE_PROPERTY_NAME, MAXKEY_NEXTKEY_VALUE_PROPERTY_NAME, "", maxKeyFlag, 12, 0);
                    maxKeyFlag = this.m_bUpdateTableWithMaxKey ? "Y" : "N";
                    this.savePropertyToOMR(omr, (Root)mdoFM, "SCD2_MaxKeyGenerator", MAXKEY_UPDATE_PROPERTY_NAME, MAXKEY_UPDATE_PROPERTY_NAME, "", maxKeyFlag, 12, 0);
                }
            } else if (this.isUseMaxKeyUserWrittenCode()) {
                IMapping mapping = this.addSCDMapping("SCD2_MaxKeyGenerator", MAXKEY_GENERATOR_MAP_NAME, MAXKEY_GENERATOR_MAP_DESC);
                FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(mapping);
                this.m_maxKeyUserWrittenCodeContainer.setName(mapping.getName());
                this.m_maxKeyUserWrittenCodeContainer.setContainer((AbstractTransformation)mdoFM);
                this.m_maxKeyUserWrittenCodeContainer.setContainerRole("SCD2_MaxKeyGenerator");
                this.m_maxKeyUserWrittenCodeContainer.saveToOMR(omr);
            }
        }
        super.saveMappingsToOMR(omr, mdoCM, tblTarget);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_maxKeyUserWrittenCodeContainer != null) {
            ((UserWrittenCodeContainer)this.m_maxKeyUserWrittenCodeContainer).updateIds(mapIDs);
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        this.m_maxKeyUserWrittenCodeContainer.deleteFromOMR(omr);
        super.deleteFromOMR(omr);
    }

    private IMapping addSCDMapping(String sMapTransformRole, String sMapName, String sMapDesc, IColumn mapColumn, ITextExpression mapExpression) {
        IMapping mapping = this.findTargetMapping(sMapTransformRole);
        if (mapping == null) {
            mapping = this.createNewMapping();
            mapping.setName(sMapName);
            mapping.setDescription(sMapDesc);
            mapping.setType(sMapTransformRole);
            mapping.setExpression(mapExpression);
            mapping.addTarget(mapColumn);
            this.addMapping(mapping);
        } else {
            IColumn[] targets = mapping.getTargets();
            if (targets.length > 0) {
                mapping.removeTarget(targets[0]);
            }
            mapping.addTarget(mapColumn);
            mapping.setExpression(mapExpression);
        }
        return mapping;
    }

    private void addSCDMapping(String sMapTransformRole, String sMapName, String sMapDesc, List mapColumns) {
        IMapping mapping = this.findTargetMapping(sMapTransformRole);
        if (mapping == null) {
            mapping = this.createNewMapping();
            mapping.setName(sMapName);
            mapping.setDescription(sMapDesc);
            mapping.setType(sMapTransformRole);
            for (int i = 0; i < mapColumns.size(); ++i) {
                mapping.addTarget((IColumn)mapColumns.get(i));
            }
            this.addMapping(mapping);
        } else {
            IColumn[] targets = mapping.getTargets();
            for (int index = 0; index < targets.length; ++index) {
                mapping.removeTarget(targets[index]);
            }
            for (int i = 0; i < mapColumns.size(); ++i) {
                mapping.addTarget((IColumn)mapColumns.get(i));
            }
        }
    }

    private void addSCDMapping(String sMapTransformRole, String sMapName, String sMapDesc, IColumn mapColumn) {
        IMapping mapping = this.findTargetMapping(sMapTransformRole);
        if (mapping == null) {
            mapping = this.createNewMapping();
            mapping.setName(sMapName);
            mapping.setDescription(sMapDesc);
            mapping.setType(sMapTransformRole);
            mapping.addTarget(mapColumn);
            this.addMapping(mapping);
        } else {
            IColumn[] targets = mapping.getTargets();
            if (targets.length > 0) {
                mapping.replaceTargetColumn(targets[0], mapColumn);
            } else {
                mapping.addTarget(mapColumn);
            }
        }
    }

    private IMapping addSCDMapping(String sMapTransformRole, String sMapName, String sMapDesc) {
        IMapping mapping = this.findTargetMapping(sMapTransformRole);
        if (mapping == null) {
            mapping = this.createNewMapping();
            this.addMapping(mapping);
        } else {
            IColumn[] targets = mapping.getTargets();
            if (targets.length > 0) {
                mapping.clearTargets();
            }
        }
        mapping.setType(sMapTransformRole);
        mapping.setName(sMapName);
        mapping.setDescription(sMapDesc);
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IPhysicalTable sourceTable = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        String targetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
        ILibrary targetLibrary = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        IDBMSType targetTableDBMSType = targetTable.getDBMSType();
        codeSegment.addSourceCode("%macro etls_scdloader;\n\n").indent();
        String engine = targetLibrary.getEngine();
        boolean usePassThru = this.isSQLPassThruEnabled(targetLibrary);
        boolean useTempLibrary = this.useTempLibrary(codeSegment);
        ArrayList<IColumn> lSCDColumns = new ArrayList<IColumn>();
        boolean hasGeneratedKey = true;
        if (this.m_generatedKeyColumn == null) {
            hasGeneratedKey = false;
        } else {
            lSCDColumns.add(this.m_generatedKeyColumn);
        }
        if (this.isTrackChangesByDates()) {
            lSCDColumns.add(this.getFromDateColumn());
        }
        if (this.isTrackChangesByCurrentIndicator()) {
            lSCDColumns.add(this.m_currentIndicatorColumn);
        }
        if (this.isTrackChangesByVersionNumber()) {
            lSCDColumns.add(this.m_versionColumn);
        }
        IColumn codegenVersionCol = null;
        if (this.isTrackChangesByVersionNumber()) {
            codegenVersionCol = this.m_versionColumn;
        }
        IColumn codegenCurrentIndCol = null;
        if (this.isTrackChangesByCurrentIndicator()) {
            codegenCurrentIndCol = this.m_currentIndicatorColumn;
        }
        lSCDColumns.addAll(this.getBusinessKeyColumnsList());
        String byBusinessCols = codeSegment.makeColumnList(this.getBusinessKeyColumnsList(), false, "   ", false, " ", "", codeSegment.isQuoting(), "", false);
        String orderByBusinessCols = codeSegment.makeColumnList(this.getBusinessKeyColumnsList(), false, "   ", false, ", ", "B", codeSegment.isQuoting(), "", false);
        String strDigestValues = this.createDigestParameter(codeSegment);
        List l_type1ColumnsList = this.getType1ColumnsList();
        boolean genType1Digest = false;
        String strDigestValuesType1 = "";
        if (l_type1ColumnsList != null && l_type1ColumnsList.size() > 0) {
            genType1Digest = true;
            strDigestValuesType1 = this.createDigestType1(l_type1ColumnsList, null, codeSegment);
        }
        ArrayList<String> tempTblList = new ArrayList<String>();
        ArrayList<IColumn> lIndexColumns = new ArrayList<IColumn>();
        if (hasGeneratedKey) {
            lIndexColumns.add(this.m_generatedKeyColumn);
            if (this.isGenerateRetainedKey()) {
                lIndexColumns.add(this.getFromDateColumn());
            }
        } else {
            lIndexColumns.addAll(this.getBusinessKeyColumnsList());
            lIndexColumns.add(this.getFromDateColumn());
        }
        boolean wasAnIndexMatchFound = false;
        Object[] aCompareToIndexColumns = lIndexColumns.toArray(new IColumn[lIndexColumns.size()]);
        IIndex[] aIndexes = targetTable.getIndexes();
        for (int index = 0; index < aIndexes.length; ++index) {
            Object[] aIndexCols = aIndexes[index].getColumns();
            if (!Arrays.equals(aIndexCols, aCompareToIndexColumns)) continue;
            wasAnIndexMatchFound = true;
            break;
        }
        boolean bEventsEnabled = this.getModel().isModelEventsEnabled();
        boolean bUndoSupported = this.getModel().isUndoSupported();
        this.getModel().setModelEventsEnabled(false);
        this.getModel().setUndoSupported(false);
        boolean bTargetTableChanged = targetTable.isChanged();
        try {
            IIndex xRefIndex = null;
            if (!wasAnIndexMatchFound) {
                xRefIndex = this.getModel().getObjectFactory().createNewIndex(this.getID());
                xRefIndex.setUnique(true);
                for (int index = 0; index < lIndexColumns.size(); ++index) {
                    IColumn indexColumn = (IColumn)lIndexColumns.get(index);
                    xRefIndex.getColumnsList().add(indexColumn);
                }
                if (lIndexColumns.size() == 1 && targetTable.getDBMSType().isMatchingSimpleIndexNameRequired()) {
                    xRefIndex.setName(((IColumn)lIndexColumns.get(0)).getName());
                } else {
                    xRefIndex.setName("XRef" + codeSegment.getUniqueWorkTableName());
                }
                targetTable.getIndexesList().add(xRefIndex);
            }
            this.genCreateTargetTable(codeSegment);
            if (xRefIndex != null) {
                targetTable.getIndexesList().remove(xRefIndex);
                xRefIndex.getColumnsList().clear();
                xRefIndex.dispose();
            }
        }
        finally {
            targetTable.setChanged(bTargetTableChanged);
            this.getModel().setModelEventsEnabled(bEventsEnabled);
            this.getModel().setUndoSupported(bUndoSupported);
        }
        targetTable.getDBMSType().genCodeConditionCheck(codeSegment, "DIS_CTABLECREATED", this, targetTable);
        String sXRefTblName = this.getXrefTableName();
        IPhysicalTable xRefTable = null;
        String sXrefInputName = "";
        boolean isXrefPermanent = false;
        String sTargetEngine = "";
        sTargetEngine = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer()).getEngine();
        if (sXRefTblName.trim().length() > 0) {
            String selectList;
            isXrefPermanent = true;
            ArrayList<IColumn> lXrefColumns = new ArrayList<IColumn>();
            if (hasGeneratedKey) {
                lXrefColumns.add(this.m_generatedKeyColumn);
                if (this.isGenerateRetainedKey()) {
                    lXrefColumns.add(this.getFromDateColumn());
                }
            }
            lXrefColumns.addAll(this.getBusinessKeyColumnsList());
            if (this.isTrackChangesByVersionNumber()) {
                lXrefColumns.add(this.m_versionColumn);
            }
            boolean hasfromDate = SCDType2TransformModel.isFromDateColumnInList(lXrefColumns, this.getFromDateColumn());
            if (this.isTrackChangesByDates() && (!hasGeneratedKey || this.isGenerateRetainedKey()) && !hasfromDate) {
                lXrefColumns.add(this.getFromDateColumn());
            }
            xRefTable = this.genCreatePermanentXRefTable(codeSegment, lXrefColumns, lIndexColumns, true);
            sXRefTblName = xRefTable.getFullNameQuotedAsNeeded(codeSegment);
            if (this.isTrackChangesByDates()) {
                String t1Digest;
                selectList = codeSegment.makeColumnList(lXrefColumns, true, "   ", false, ",", "A", codeSegment.isQuoting(), " ", true);
                String fromDateName = this.getFromDateColumn().getColumnName(codeSegment);
                String toDateName = this.getToDateColumn().getColumnName(codeSegment);
                codeSegment.addCommentLine("Add date to the cross reference file for detecting history records").addSourceCode("proc sql;\n").indent();
                codeSegment.addSourceCode("create table ").addSourceCode(WORKSORTEDXREF);
                if (this.m_mlType1Columns.size() > 0 && this.getChangeDigestVersion().equalsIgnoreCase("V1_1")) {
                    codeSegment.addSourceCode(" ( drop = ETLS_STR )");
                }
                codeSegment.addSourceCode(" as\n").indent().addSourceCode("select ").addSourceCode(selectList).addSourceCode(",\n").indent().addSourceCode("A.DIGEST_VALUE,\n");
                if (hasGeneratedKey && !this.isGenerateRetainedKey()) {
                    codeSegment.addSourceCode("B.").addSourceCode(fromDateName).addSourceCode(",\n");
                }
                codeSegment.addSourceCode("B.").addSourceCode(toDateName);
                if (this.m_mlType1Columns.size() > 0 && this.getChangeDigestVersion().equalsIgnoreCase("V1_1")) {
                    t1Digest = this.createDigestType1(this.m_mlType1Columns, "B", codeSegment);
                    codeSegment.addSourceCode(",\n").addSourceCode("'\"' || ").addSourceCode(t1Digest).addSourceCode(" || '\"'").addSourceCode(" as ").addSourceCode("ETLS_STR").addSourceCode(",\n").addSourceCode("put(MD5(calculated ETLS_STR ), $hex32. ) as DIGEST_VALUE_TYPE1 format=$32.");
                } else if (this.m_mlType1Columns.size() > 0 && (this.getChangeDigestVersion().equalsIgnoreCase("V2_1") || this.getChangeDigestVersion().equalsIgnoreCase("V2_2"))) {
                    t1Digest = this.createDigestType1(this.m_mlType1Columns, "B", codeSegment);
                    t1Digest = t1Digest.replace(";", "");
                    codeSegment.addSourceCode(",\n");
                    codeSegment.addSourceCode(t1Digest).addSourceCode(" as DIGEST_VALUE_TYPE1 format=$32.");
                }
                codeSegment.addSourceCode("\n").unIndent().addSourceCode("from ").addSourceCode(sXRefTblName).addSourceCode(" A, ");
                String sTargetReadOptions = targetTable.getReadTableOptions(true);
                if (sTargetReadOptions.length() > 0) {
                    codeSegment.addSourceCode("\n");
                }
                codeSegment.addSourceCode(targetDSName).addSourceCode(" ").addSourceCode(sTargetReadOptions).addSourceCode(" B\n");
                if (hasGeneratedKey) {
                    codeSegment.addSourceCode("where ");
                    String genKeyName = this.m_generatedKeyColumn.getColumnName(codeSegment);
                    if (this.isGenerateRetainedKey()) {
                        codeSegment.addSourceCode("A.").addSourceCode(genKeyName).addSourceCode(" = B.").addSourceCode(genKeyName).addSourceCode("\n").indent().addSourceCode(" and A.").addSourceCode(fromDateName).addSourceCode(" = B.").addSourceCode(fromDateName);
                        if (!sTargetEngine.equals("BASE") || this.isUseIndexIfReadingSasds() && sTargetEngine.equals("BASE")) {
                            codeSegment.addSourceCode(" \n").unIndent().addSourceCode("order by ").addSourceCode(orderByBusinessCols).addSourceCode(" , ").addSourceCode(" A.").addSourceCode(fromDateName);
                        }
                    } else {
                        codeSegment.addSourceCode("A.").addSourceCode(genKeyName).addSourceCode(" = B.").addSourceCode(genKeyName);
                        if (!sTargetEngine.equals("BASE") || this.isUseIndexIfReadingSasds() && sTargetEngine.equals("BASE")) {
                            codeSegment.addSourceCode(" \n").unIndent().addSourceCode("order by ").addSourceCode(orderByBusinessCols).addSourceCode(" , ").addSourceCode(" B.").addSourceCode(fromDateName);
                        }
                    }
                } else {
                    String sbWhereClause = this.makeAnEqualJoinWhereClause(this.getBusinessKeyColumnsList(), false, "", "A", "B", codeSegment, false);
                    codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause).indent().addSourceCode("and A.").addSourceCode(fromDateName).addSourceCode(" = B.").addSourceCode(fromDateName);
                    if (!sTargetEngine.equals("BASE") || this.isUseIndexIfReadingSasds() && sTargetEngine.equals("BASE")) {
                        codeSegment.addSourceCode(" \n").unIndent().addSourceCode("order by ").addSourceCode(orderByBusinessCols).addSourceCode(" , ").addSourceCode(" A.").addSourceCode(fromDateName);
                    }
                }
                codeSegment.addSourceCode(";\n").unIndent().addSourceCode("quit;\n\n").genRCSetCall("&sqlrc");
                if (sTargetEngine.equals("BASE") && !this.isUseIndexIfReadingSasds()) {
                    codeSegment.addCommentLine("Sort the cross-reference table into business key order").addSourceCode("proc sort data=").addSourceCode(WORKSORTEDXREF).addSourceCode("\n").indent().addSourceCode("out=").addSourceCode(WORKSORTEDXREF).addSourceCode(";\n").addSourceCode("by ").addSourceCode(byBusinessCols).addSourceCode(" ").addSourceCode(this.getFromDateColumn().getColumnName(codeSegment)).addSourceCode(";\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
                }
                sXrefInputName = WORKSORTEDXREF;
            } else if (this.m_mlType1Columns.size() > 0) {
                String t1Digest;
                selectList = codeSegment.makeColumnList(lXrefColumns, true, "   ", false, ",", "A", codeSegment.isQuoting(), " ", true);
                codeSegment.addCommentLine("Add type 1 digest to the cross reference file for detecting history records").addSourceCode("proc sql;\n").indent();
                codeSegment.addSourceCode("create table ").addSourceCode(WORKSORTEDXREF);
                if (this.getChangeDigestVersion().equalsIgnoreCase("V1_1")) {
                    codeSegment.addSourceCode(" ( drop = ETLS_STR )");
                }
                codeSegment.addSourceCode(" as\n").indent().addSourceCode("select ").addSourceCode(selectList).addSourceCode(",\n").indent().addSourceCode("A.DIGEST_VALUE,\n");
                if (this.getChangeDigestVersion().equalsIgnoreCase("V1_1")) {
                    t1Digest = this.createDigestType1(this.m_mlType1Columns, "B", codeSegment);
                    codeSegment.addSourceCode("'\"' || ").addSourceCode(t1Digest).addSourceCode(" || '\"'").addSourceCode(" as ").addSourceCode("ETLS_STR").addSourceCode(",\n").addSourceCode("put(MD5(calculated ETLS_STR ), $hex32. ) as DIGEST_VALUE_TYPE1 format=$32.");
                } else if (this.getChangeDigestVersion().equalsIgnoreCase("V2_1") || this.getChangeDigestVersion().equalsIgnoreCase("V2_2")) {
                    t1Digest = this.createDigestType1(this.m_mlType1Columns, "B", codeSegment);
                    t1Digest = t1Digest.replace(";", "");
                    codeSegment.addSourceCode(t1Digest).addSourceCode(" as DIGEST_VALUE_TYPE1 format=$32.");
                }
                codeSegment.addSourceCode("\n").unIndent().addSourceCode("from ").addSourceCode(sXRefTblName).addSourceCode(" A, ").addSourceCode(targetDSName).addSourceCode(" B\n");
                codeSegment.addSourceCode("where ");
                String genKeyName = this.m_generatedKeyColumn.getColumnName(codeSegment);
                codeSegment.addSourceCode("A.").addSourceCode(genKeyName).addSourceCode(" = B.").addSourceCode(genKeyName);
                codeSegment.addSourceCode(" \n").unIndent().addSourceCode("order by ").addSourceCode(orderByBusinessCols);
                codeSegment.addSourceCode(";\n").unIndent().addSourceCode("quit;\n\n").genRCSetCall("&sqlrc");
                sXrefInputName = WORKSORTEDXREF;
            } else if (sTargetEngine.equals("BASE") && !this.isUseIndexIfReadingSasds()) {
                codeSegment.addCommentLine("Sort the cross-reference table into business key order").addSourceCode("proc sort data=").addSourceCode(sXRefTblName).addSourceCode("\n").indent().addSourceCode("out=").addSourceCode(WORKSORTEDXREF).addSourceCode(";\n").addSourceCode("by ").addSourceCode(byBusinessCols).addSourceCode(";\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
                sXrefInputName = WORKSORTEDXREF;
                tempTblList.add(WORKSORTEDXREF);
            } else {
                sXrefInputName = sXRefTblName;
            }
        } else {
            codeSegment.addSectionComment("Temporary cross reference table being used");
            ArrayList<IColumn> lKeyColumns = new ArrayList<IColumn>();
            if (hasGeneratedKey) {
                lKeyColumns.add(this.m_generatedKeyColumn);
            }
            sXrefInputName = this.genCreateTempXrefTable(targetDSName, this.getBusinessKeyColumnsList(), lKeyColumns, codegenCurrentIndCol, codegenVersionCol, this.isGenerateRetainedKey(), true, strDigestValues, WORKSORTEDXREF, codeSegment, sTargetEngine, strDigestValuesType1, this.getType1ColumnsList(), this.getDigestVarsList(), this.getCurrentIndicatorYesValue(), this.getCurrentIndicatorNoValue());
            tempTblList.add(sXrefInputName);
        }
        boolean isMappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), sourceTable, targetTable);
        String mappingStepOutputName = "";
        if (isMappingNeeded) {
            ITransformTableOptions sourceTableOptions = this.getTableOptionObject(sourceTable, true);
            String sSrcTableOptions = sourceTableOptions.getTableOptions(codeSegment.getCurrentServer());
            mappingStepOutputName = codeSegment.getUniqueWorkTableName(true, 0);
            this.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, mappingStepOutputName, sourceTable.getFullNameQuotedAsNeeded(codeSegment), sSrcTableOptions.length() > 0 ? "&etls_tableOptions" : "", null, true, true, false, null, null, false, null, null, null);
            codeSegment.addSourceCode("%let etls_lastTable = &SYSLAST; \n");
            codeSegment.addSourceCode("%let etls_tableOptions = ; \n\n");
        }
        codeSegment.genRCSetCall("&sqlrc");
        boolean bGenType1Digest = false;
        if (!strDigestValuesType1.equals("") && strDigestValuesType1.length() > 0) {
            bGenType1Digest = true;
        }
        String sourceTblName = isMappingNeeded ? "&syslast" : sourceTable.getFullNameQuotedAsNeeded(codeSegment);
        this.genDigestValue(strDigestValues, sourceTblName, WORKSOURCENAME, codeSegment, genType1Digest, strDigestValuesType1);
        if (this.isTrackChangesByDates()) {
            String sFromDateExpr = "";
            if (this.getFromDateExpression() != null) {
                sFromDateExpr = this.getFromDateExpression().getText(codeSegment.getCurrentServer(), codeSegment.isQuoting());
            }
            String sToDateExpr = "";
            if (this.getToDateExpression() != null) {
                sToDateExpr = this.getToDateExpression().getText(codeSegment.getCurrentServer(), codeSegment.isQuoting());
            }
            codeSegment.addCommentLine("Generate the from date expression");
            if (sFromDateExpr.length() == 0) {
                String sFormat = this.getFromDateColumn().getFormat();
                SASFormat sasFormat = null;
                if (sFormat != null && sFormat.length() > 0) {
                    sasFormat = SASFormat.getInstance((String)sFormat);
                }
                if (sasFormat != null && sasFormat.isDateFormat()) {
                    codeSegment.addSourceCode("%let ").addSourceCode("etls_begdate").addSourceCode(" = %sysfunc(date(), date9.); \n\n");
                } else {
                    codeSegment.addSourceCode("%let etls_begdate = %SYSFUNC(DATETIME()); \n\n");
                }
            } else if (sFromDateExpr.equalsIgnoreCase("DATE()") || sFromDateExpr.equalsIgnoreCase("TODAY()") || sFromDateExpr.equalsIgnoreCase("TIME()") || sFromDateExpr.equalsIgnoreCase("DATETIME()")) {
                codeSegment.addSourceCode("%let ").addSourceCode("etls_begdate").addSourceCode(" = ").addSourceCode("%SYSFUNC(" + sFromDateExpr + ")").addSourceCode(";\n");
            } else {
                codeSegment.addSourceCode("%let ").addSourceCode("etls_begdate").addSourceCode(" = ").addSourceCode(sFromDateExpr).addSourceCode(";\n");
            }
            codeSegment.addCommentLine("Generate the default to date expression");
            if (sToDateExpr.length() == 0) {
                this.genToDateExpression(codeSegment);
            } else {
                codeSegment.addSourceCode("%let ").addSourceCode("etls_enddate").addSourceCode(" = ").addSourceCode(sToDateExpr).addSourceCode(";\n\n");
            }
            String fromDateName = this.getFromDateColumn().getColumnName(codeSegment);
            String toDateName = this.getToDateColumn().getColumnName(codeSegment);
            SCDType2TransformModel.genDateFixerUpperCode(codeSegment, fromDateName, toDateName, this.getBusinessKeyColumnsList(), this.getDateFormatType(), this.isMultiUpdatesPerDayAllowed());
        }
        String sGenChgKeyExpr = "";
        String sGenNewKeyExpr = "";
        if (hasGeneratedKey) {
            codeSegment.addSectionComment("Generate the maximum generated key");
            if (this.m_maxKeyUserWrittenCodeContainer != null && this.isUseMaxKeyUserWrittenCode()) {
                codeSegment.addCommentLine("Start max key user written code").addSourceCode(this.m_maxKeyUserWrittenCodeContainer.getCode()).addSourceCode("\n").addCommentLine("End of max key user written code");
                this.genCheckForOldMaxKeyMacroUsed(codeSegment);
            } else if (this.isGenerateMaxKeyCode()) {
                if (this.m_maxKeyColumn != null) {
                    if (this.m_maxKeyColumn != this.m_generatedKeyColumn) {
                        codeSegment.addSectionComment("Use a lookup table to retrieve the maximum generated key");
                        IPhysicalTable maxKeyTable = (IPhysicalTable)this.m_maxKeyColumn.getTable();
                        if (maxKeyTable != targetTable) {
                            maxKeyTable.genAccessPath(codeSegment, null);
                            codeSegment.addCommentLine("Verify that the lookup table exists");
                            maxKeyTable.genTableExist(codeSegment);
                            codeSegment.addCommentLine("if table does not exist").addSourceCode("%if &etls_tableExist = 0 %then \n%do; ").indent().genPercentPutStatement("Generated key lookup table does not exist", "ERROR%QUOTE(:)").addSourceCode("%goto error;\n").unIndent().addSourceCode("%end;\n\n");
                            this.genGeneratedKeyMaxKey(this.m_maxKeyColumn, this.m_maxKeyRowSelectorExpression, this.isNextKeyValueInGenKey(), codeSegment);
                            if (this.m_bUpdateTableWithMaxKey) {
                                ILibrary mkLibrary = maxKeyTable.getCodeGenLibrary(codeSegment.getCurrentServer());
                                boolean usePassThruMK = this.isSQLPassThruEnabled(mkLibrary);
                                this.genUpdateMaxKeyLookupTable(this.getBusinessKeyColumnsList(), this.m_maxKeyColumn, this.m_maxKeyRowSelectorExpression, this.getFromDateColumn(), sXrefInputName, this.isGenerateRetainedKey(), true, strDigestValues, usePassThruMK, WORKSOURCENAME, codeSegment);
                            }
                        } else {
                            this.genGeneratedKeyMaxKey(this.m_generatedKeyColumn, null, false, codeSegment);
                        }
                    } else {
                        this.genGeneratedKeyMaxKey(this.m_maxKeyColumn, this.m_maxKeyRowSelectorExpression, this.isNextKeyValueInGenKey(), codeSegment);
                    }
                } else {
                    this.genGeneratedKeyMaxKey(this.m_generatedKeyColumn, null, false, codeSegment);
                }
            }
            sGenNewKeyExpr = this.m_newRecordGenKeyExpression != null ? this.m_newRecordGenKeyExpression.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting()) : DEFAULT_GENKEY_EXP;
            sGenChgKeyExpr = this.m_changedRecordGenKeyExpression != null ? this.m_changedRecordGenKeyExpression.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting()) : DEFAULT_GENKEY_EXP;
        }
        String strBusinessKey = codeSegment.makeColumnList(this.getBusinessKeyColumnsList(), " ", codeSegment.isQuoting());
        ArrayList<IColumn> lKeyColumns = new ArrayList<IColumn>();
        if (hasGeneratedKey) {
            lKeyColumns.add(this.m_generatedKeyColumn);
        }
        if (this.isTrackChangesByDates()) {
            codeSegment.addSectionComment("Slowly Changing Dimension Type 2 Beginning/End Date Method");
            this.genDateDataMergeStep(this.getBusinessKeyColumnsList(), codegenCurrentIndCol, codegenVersionCol, this.isGenerateRetainedKey(), this.isGenerateUniqueRetainedKey(), this.m_generatedKeyColumn, sGenChgKeyExpr, sGenNewKeyExpr, true, WORKSOURCENAME, sXrefInputName, this.m_mlType1Columns, codeSegment, this.getCurrentIndicatorYesValue(), this.getCurrentIndicatorNoValue());
            if (this.getJob().isSendJobStatusEnabled()) {
                codeSegment.genJobStatusUpdateBefore(targetTable);
            }
            this.genCheckUpdateTableStats("scdldout", this.isTrackChangesByDates(), this.isTrackChangesByCurrentIndicator(), this.isTrackChangesByVersionNumber(), this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0, codeSegment);
            this.genDateUpdateTargetTable(this.getBusinessKeyColumnsList(), usePassThru, useTempLibrary, this.m_generatedKeyColumn, this.isGenerateRetainedKey(), codegenCurrentIndCol, this.m_mlType1Columns, codeSegment, this.getCurrentIndicatorYesValue(), this.getCurrentIndicatorNoValue());
            if (isXrefPermanent) {
                this.genUpdateXrefTable(sTargetEngine, targetDSName, xRefTable, this.getBusinessKeyColumnsList(), codegenCurrentIndCol, codegenVersionCol, true, usePassThru, strDigestValues, lKeyColumns, codeSegment, this.getCurrentIndicatorYesValue(), this.getCurrentIndicatorNoValue());
            }
            codeSegment.addSourceCode("%let etls_lastTable = %nrquote(").addSourceCode(targetDSName).addSourceCode(");\n\n");
            targetTableDBMSType.genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, targetTable);
        }
        if (this.isTrackChangesByCurrentIndicator() && !this.isTrackChangesByDates()) {
            codeSegment.addCommentLine("Sort input source table by the business key").addSourceCode("proc sort data=").addSourceCode(WORKSOURCENAME).addSourceCode(";\n").indent().addSourceCode("by ").addSourceCode(strBusinessKey).addSourceCode(";\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
            codeSegment.addSectionComment("Slowly Changing Dimension Type 2 Current Indicator Method");
            this.genCurrIndDataMergeStep(this.getBusinessKeyColumnsList(), codegenCurrentIndCol, codegenVersionCol, this.getLoadTimeColumn(), this.getGenerateKeyColumn(), sGenChgKeyExpr, sGenNewKeyExpr, codeSegment.isQuoting(), WORKSOURCENAME, sXrefInputName, codeSegment);
            if (this.getJob().isSendJobStatusEnabled()) {
                codeSegment.genJobStatusUpdateBefore(targetTable);
            }
            this.genCheckUpdateTableStats("scdldout", this.isTrackChangesByDates(), this.isTrackChangesByCurrentIndicator(), this.isTrackChangesByVersionNumber(), this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0, codeSegment);
            this.genCurrIndUpdateTargetTable(usePassThru, useTempLibrary, targetTable, codeSegment);
            if (isXrefPermanent) {
                this.genUpdateXrefTable(sTargetEngine, targetDSName, xRefTable, this.getBusinessKeyColumnsList(), codegenCurrentIndCol, codegenVersionCol, true, usePassThru, strDigestValues, lKeyColumns, codeSegment, this.getCurrentIndicatorYesValue(), this.getCurrentIndicatorNoValue());
            }
            codeSegment.addSourceCode("%let etls_lastTable = %nrquote(").addSourceCode(targetDSName).addSourceCode(");\n\n");
            targetTableDBMSType.genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, targetTable);
        }
        if (this.isTrackChangesByVersionNumber() && !this.isTrackChangesByDates() && !this.isTrackChangesByCurrentIndicator()) {
            codeSegment.addCommentLine("Sort input source table by the business key").addSourceCode("proc sort data=").addSourceCode(WORKSOURCENAME).addSourceCode(";\n").indent().addSourceCode("by ").addSourceCode(strBusinessKey).addSourceCode(";\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
            codeSegment.addSectionComment("Slowly Changing Dimension Type 2 Version Number");
            this.genVersNumDataMergeStep(this.getBusinessKeyColumnsList(), this.getVersionColumn(), this.getLoadTimeColumn(), this.getGenerateKeyColumn(), sGenChgKeyExpr, sGenNewKeyExpr, codeSegment.isQuoting(), WORKSOURCENAME, sXrefInputName, this.getTempTableLibref(), codeSegment);
            if (this.getJob().isSendJobStatusEnabled()) {
                codeSegment.genJobStatusUpdateBefore(targetTable);
            }
            this.genCheckUpdateTableStats("scdldout", this.isTrackChangesByDates(), this.isTrackChangesByCurrentIndicator(), this.isTrackChangesByVersionNumber(), this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0, codeSegment);
            this.genVersNumUpdateTargetTable(usePassThru, useTempLibrary, targetTable, codeSegment);
            if (isXrefPermanent) {
                this.genUpdateXrefTable(sTargetEngine, targetDSName, xRefTable, this.getBusinessKeyColumnsList(), null, codegenVersionCol, true, usePassThru, strDigestValues, lKeyColumns, codeSegment, this.getCurrentIndicatorYesValue(), this.getCurrentIndicatorNoValue());
            }
            codeSegment.addSourceCode("%let etls_lastTable = %nrquote(").addSourceCode(targetDSName).addSourceCode(");\n\n");
            targetTableDBMSType.genCodeConditionCheck(codeSegment, "DIS_CDATAMODIFIED", this, targetTable);
        }
        tempTblList.add(WORKSOURCENAME);
        codeSegment.addSourceCode("%if &etls_debug lt 2 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(tempTblList).unIndent().addSourceCode("%end;\n\n");
        codeSegment.addSourceCode("%goto scdldout;\n").addSourceCode("%error:\n").indent().addSourceCode("%let sysrc = 9999;\n").genRCSetCall("&sysrc").unIndent().addSourceCode("%scdldout:\n");
        if (this.getJob().isSendJobStatusEnabled()) {
            codeSegment.indent().genJobStatusUpdateAfter(targetTable).unIndent();
        }
        codeSegment.unIndent().addSourceCode("%mend etls_scdloader;\n\n");
        codeSegment.addCommentLine("Execute the SCD Type 2 Loader").addSourceCode("%etls_scdloader;\n\n");
        targetTableDBMSType.genCodeConditionCheck(codeSegment, "DIS_CSUCCESSFUL", this, targetTable);
        targetTableDBMSType.genCodeConditionCheck(codeSegment, "DIS_CWARNINGS", this, targetTable);
        targetTableDBMSType.genCodeConditionCheck(codeSegment, "DIS_CERRORS", this, targetTable);
        if (isMappingNeeded && !targetTable.isView()) {
            codeSegment.genTableDelete(mappingStepOutputName);
        }
        return codeSegment;
    }

    public String createDigestParameter(ICodeSegment codeSegment) throws MdException, RemoteException {
        StringBuffer sbDigest;
        block19: {
            int maxLineLength;
            ArrayList<IColumn> lColumns;
            block20: {
                block18: {
                    IPhysicalTable table = (IPhysicalTable)this.getDataTargets()[0];
                    lColumns = new ArrayList<IColumn>();
                    if (this.m_mlDigestColumns.size() != 0) {
                        lColumns.addAll(this.m_mlDigestColumns);
                    } else {
                        IColumn[] aColumns = table.getColumns();
                        for (int i = 0; i < aColumns.length; ++i) {
                            lColumns.add(aColumns[i]);
                        }
                    }
                    if (this.m_generatedKeyColumn != null) {
                        lColumns.remove(this.m_generatedKeyColumn);
                    }
                    if (this.getFromDateColumn() != null) {
                        lColumns.remove(this.getFromDateColumn());
                    }
                    if (this.getToDateColumn() != null) {
                        lColumns.remove(this.getToDateColumn());
                    }
                    if (this.m_versionColumn != null && this.isTrackChangesByVersionNumber()) {
                        lColumns.remove(this.m_versionColumn);
                    }
                    if (this.m_currentIndicatorColumn != null && this.isTrackChangesByCurrentIndicator()) {
                        lColumns.remove(this.m_currentIndicatorColumn);
                    }
                    lColumns.removeAll(this.getBusinessKeyColumnsList());
                    if (this.m_mlType1Columns.size() > 0) {
                        lColumns.removeAll(this.m_mlType1Columns);
                    }
                    if (this.getLoadTimeColumn() != null) {
                        lColumns.remove(this.getLoadTimeColumn());
                    }
                    sbDigest = new StringBuffer();
                    if (!this.getChangeDigestVersion().equalsIgnoreCase("V1_1")) break block18;
                    maxLineLength = 60;
                    int nSize = lColumns.size();
                    for (int i = 0; i < nSize; ++i) {
                        IColumn col = (IColumn)lColumns.get(i);
                        String colName = col.getColumnName(codeSegment);
                        if (sbDigest.length() + colName.length() + 16 > maxLineLength) {
                            sbDigest.append("\n      ");
                            maxLineLength += 60;
                        }
                        if (sbDigest.length() == 0) {
                            sbDigest.append("KTRIM(KLEFT(").append(colName).append(")) ");
                            continue;
                        }
                        sbDigest.append("|| KTRIM(KLEFT(").append(colName).append(")) ");
                    }
                    break block19;
                }
                if (!this.getChangeDigestVersion().equalsIgnoreCase("V2_1")) break block20;
                sbDigest.append("put(md5(catq(' ', ");
                sbDigest.append(codeSegment.makeColumnList(lColumns, " ", codeSegment.isQuoting(), ",").trim());
                sbDigest.append(")), $hex32.);");
                break block19;
            }
            if (!this.getChangeDigestVersion().equalsIgnoreCase("V2_2")) break block19;
            maxLineLength = 60;
            for (int i = 0; i < lColumns.size(); ++i) {
                IColumn col = (IColumn)lColumns.get(i);
                String colName = col.getColumnName(codeSegment);
                if (sbDigest.length() + colName.length() + 16 > maxLineLength) {
                    sbDigest.append("\n      ");
                    maxLineLength += 60;
                }
                if (i == 0) {
                    sbDigest.append("put(md5(catq(' ', ");
                }
                if (col.getType() == 1) {
                    colName = "put(" + col.getColumnName(codeSegment) + ",ieee8.)";
                }
                if (i + 1 != lColumns.size()) {
                    sbDigest.append(colName + ',');
                    continue;
                }
                sbDigest.append(colName);
                sbDigest.append(")),$hex32.);");
            }
        }
        return sbDigest.toString();
    }

    public String createDigestType1(List lColumns, String sColumnAlias, ICodeSegment codeSegment) throws MdException, RemoteException {
        StringBuffer sbDigest;
        block12: {
            block13: {
                block11: {
                    sbDigest = new StringBuffer();
                    if (!this.getChangeDigestVersion().equalsIgnoreCase("V1_1")) break block11;
                    int maxLineLength = 60;
                    int nSize = lColumns.size();
                    for (int i = 0; i < nSize; ++i) {
                        int colType;
                        IColumn col = (IColumn)lColumns.get(i);
                        String colName = col.getColumnName(codeSegment);
                        if (sColumnAlias != null && sColumnAlias.length() > 0) {
                            colName = sColumnAlias + "." + colName;
                        }
                        if (sbDigest.length() + colName.length() + 16 > maxLineLength) {
                            sbDigest.append("\n      ");
                            maxLineLength += 60;
                        }
                        if ((colType = col.getType()) == 1) {
                            if (sbDigest.length() == 0) {
                                sbDigest.append("TRIM(LEFT(PUT(").append(colName).append(",best32.))) ");
                                continue;
                            }
                            sbDigest.append("|| ' ' || TRIM(LEFT(PUT(").append(colName).append(",best32.))) ");
                            continue;
                        }
                        if (sbDigest.length() == 0) {
                            sbDigest.append("KTRIM(KLEFT(").append(colName).append(")) ");
                            continue;
                        }
                        sbDigest.append("|| ' ' || KTRIM(KLEFT(").append(colName).append(")) ");
                    }
                    break block12;
                }
                if (!this.getChangeDigestVersion().equalsIgnoreCase("V2_1")) break block13;
                sbDigest.append("put(md5(catq(' ', ");
                sbDigest.append(codeSegment.makeColumnList(this.getType1ColumnsList(), " ", codeSegment.isQuoting(), ",").trim());
                sbDigest.append(")), $hex32.);");
                break block12;
            }
            if (!this.getChangeDigestVersion().equalsIgnoreCase("V2_2")) break block12;
            int maxLineLength = 60;
            for (int i = 0; i < lColumns.size(); ++i) {
                IColumn col = (IColumn)lColumns.get(i);
                String colName = col.getColumnName(codeSegment);
                if (sbDigest.length() + colName.length() + 16 > maxLineLength) {
                    sbDigest.append("\n      ");
                    maxLineLength += 60;
                }
                if (i == 0) {
                    sbDigest.append("put(md5(catq(' ', ");
                }
                if (col.getType() == 1) {
                    colName = "put(" + col.getColumnName(codeSegment) + ",ieee8.)";
                }
                if (i + 1 != lColumns.size()) {
                    sbDigest.append(colName + ',');
                    continue;
                }
                sbDigest.append(colName);
                sbDigest.append(")),$hex32.);");
            }
        }
        return sbDigest.toString();
    }

    protected void genCurrIndDataMergeStep(List busKeyColumns, IColumn currIndColumn, IColumn versionColumn, IColumn ldTimeColumn, IColumn generatedKeyColumn, String chgRcdExp, String newRcdExp, boolean needsQuotes, String sourceDSName, String xrefDSName, ICodeSegment codeSegment) throws MdException, RemoteException {
        String currIndName = currIndColumn.getColumnName(codeSegment);
        IColumn lastBusKeyColumn = (IColumn)busKeyColumns.get(busKeyColumns.size() - 1);
        String lastBusKey = lastBusKeyColumn.getColumnName(codeSegment);
        String strBusKeyColumns = codeSegment.makeColumnList(busKeyColumns, " ", needsQuotes);
        String ldTimeName = "";
        if (ldTimeColumn != null) {
            ldTimeName = ldTimeColumn.getColumnName(codeSegment);
        }
        String generatedKeyName = generatedKeyColumn.getColumnName(codeSegment);
        StringBuffer digestValueName = new StringBuffer();
        if (needsQuotes) {
            digestValueName.append("\"").append("DIGEST_VALUE").append("\"n");
        } else {
            digestValueName.append("DIGEST_VALUE");
        }
        ArrayList<String> dropList = new ArrayList<String>();
        StringBuffer retainClause = new StringBuffer();
        retainClause.append("NewMaxKey").append(" &etls_maxkey");
        ArrayList<String> lKeepType1 = new ArrayList<String>();
        lKeepType1.add("ETLS_KEY");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            lKeepType1.addAll(this.m_mlType1Columns);
            dropList.add("ETLS_TYPE1DIGEST");
            dropList.add("DIGEST_VALUE_TYPE1");
        }
        dropList.add("ETLS_STGDIGEST");
        dropList.add("DIGEST_VALUE");
        dropList.add("NewMaxKey");
        dropList.add("ETLS_KEY");
        if (versionColumn != null) {
            dropList.add("ETLS_NEWVERS");
            retainClause.append(" ").append("ETLS_NEWVERS");
        }
        ArrayList<String> keepList = new ArrayList<String>();
        keepList.add("ETLS_KEY");
        if (ldTimeColumn != null) {
            dropList.add("ETLS_LOADTIME");
            keepList.add("ETLS_LOADTIME");
            lKeepType1.add("ETLS_LOADTIME");
        }
        String dropClause = codeSegment.makeColumnList(dropList, "            ", needsQuotes);
        String keepClause = codeSegment.makeColumnList(keepList, "            ", needsQuotes);
        String sKeepType1Clause = codeSegment.makeColumnList(lKeepType1, "           ", codeSegment.isQuoting());
        codeSegment.addCommentLine("Data merge the cross-reference and source tables").addSourceCode("data ").addSourceCode("work.etls_newrcds").addSourceCode(" (drop = ").addSourceCode(dropClause).addSourceCode(")\n").indent().addSourceCode("work.etls_match").addSourceCode(" (drop = ").addSourceCode(dropClause).addSourceCode(")\n").addSourceCode("work.etls_close").addSourceCode(" (keep = ").addSourceCode(keepClause).addSourceCode(")\n");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.addSourceCode("work.etls_type1").addSourceCode("\n").indent().addSourceCode(" (keep = ").addSourceCode(sKeepType1Clause).addSourceCode(")\n").unIndent();
        }
        codeSegment.addSourceCode(";\n\n").addSourceCode("retain ").addSourceCode(retainClause).addSourceCode(";\n\n");
        codeSegment.addSourceCode("merge ").addSourceCode(sourceDSName).addSourceCode("(in=inSort ").addSourceCode("rename=(").addSourceCode(digestValueName).addSourceCode(" = ").addSourceCode("ETLS_STGDIGEST");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.addSourceCode(" ").addSourceCode("DIGEST_VALUE_TYPE1").addSourceCode(" = ").addSourceCode("ETLS_TYPE1DIGEST");
        }
        codeSegment.addSourceCode("))\n").indent().addSourceCode(xrefDSName).addSourceCode(" (in=inXref ").addSourceCode("rename=(").addSourceCode(generatedKeyName).addSourceCode(" = ").addSourceCode("ETLS_KEY").addSourceCode("\n").addSourceCode("));\n").unIndent().addSourceCode("by " + strBusKeyColumns + ";\n\n");
        String ldTimeFormat = "";
        String ldTimeInformat = "";
        if (ldTimeColumn != null) {
            codeSegment.addSourceCode("attrib ").addSourceCode("ETLS_LOADTIME").addSourceCode(" length=8");
            ldTimeFormat = ldTimeColumn.getFormat();
            if (ldTimeFormat.length() < 1) {
                ldTimeFormat = "datetime20.";
            }
            codeSegment.addSourceCode(" format = ").addSourceCode(ldTimeFormat);
            ldTimeInformat = ldTimeColumn.getInformat();
            if (ldTimeInformat.length() < 1) {
                ldTimeInformat = "datetime20.";
            }
            codeSegment.addSourceCode(" informat = ").addSourceCode(ldTimeInformat).addSourceCode(";\n\n");
        }
        codeSegment.addCommentLine("Process changes made to existing records").addSourceCode("if inSort and inXref then\n").addSourceCode("do;\n\n").indent();
        if (versionColumn != null) {
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"first.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if first.").addSourceCode(lastBusKey);
            }
            codeSegment.addSourceCode(" then\n").indent().addSourceCode("ETLS_NEWVERS").addSourceCode(" = ").addSourceCode(versionColumn.getColumnName(codeSegment)).addSourceCode(";\n\n").unIndent();
        }
        codeSegment.addSourceCode("if ").addSourceCode("ETLS_STGDIGEST").addSourceCode(" NE ").addSourceCode(digestValueName).addSourceCode(" then\ndo;\n\n").indent();
        if (needsQuotes) {
            codeSegment.addSourceCode("if \"last.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
        } else {
            codeSegment.addSourceCode("if last.").addSourceCode(lastBusKey);
        }
        codeSegment.addSourceCode(" then");
        codeSegment.newLine();
        codeSegment.indent();
        codeSegment.addSourceCode(currIndName).addSourceCode(" = " + this.getCurrentIndicatorYesValue() + ";");
        codeSegment.newLine();
        codeSegment.unIndent();
        codeSegment.addSourceCode("else");
        codeSegment.newLine();
        codeSegment.indent();
        codeSegment.addSourceCode(currIndName).addSourceCode(" = " + this.getCurrentIndicatorNoValue() + ";");
        codeSegment.newLine(2);
        codeSegment.unIndent();
        if (ldTimeName.length() > 0) {
            codeSegment.addSourceCode(ldTimeName).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n").addSourceCode("ETLS_LOADTIME").addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n\n");
        }
        codeSegment.addSourceCode("output ").addSourceCode("work.etls_close").addSourceCode(";\n\n").addSourceCode("NewMaxKey").addSourceCode(" = ").addSourceCode(chgRcdExp).addSourceCode(";\n").addSourceCode(generatedKeyName).addSourceCode(" = ").addSourceCode("NewMaxKey").addSourceCode(";\n\n");
        codeSegment.addCommentLine("Update the cross-reference variables to the new current values").addSourceCode(digestValueName).addSourceCode(" = ").addSourceCode("ETLS_STGDIGEST").addSourceCode(";\n");
        if (versionColumn != null) {
            this.genVersionIncrement(versionColumn, lastBusKeyColumn, lastBusKey, codeSegment);
        }
        codeSegment.addSourceCode("output ").addSourceCode("work.etls_match").addSourceCode(";\n");
        codeSegment.unIndent().addSourceCode("end;\n");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.addSourceCode("else do;\n\n").indent().addCommentLine("Output to the type 1 work table");
            codeSegment.addSourceCode("if ").addSourceCode("ETLS_TYPE1DIGEST").addSourceCode(" NE ").addSourceCode("DIGEST_VALUE_TYPE1").addSourceCode(" then\n").indent();
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"last.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if last.").addSourceCode(lastBusKey);
            }
            codeSegment.addSourceCode(" then\ndo;\n").indent();
            if (ldTimeName.length() > 0) {
                codeSegment.addSourceCode("ETLS_LOADTIME").addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n");
            }
            codeSegment.addSourceCode("output ").addSourceCode("work.etls_type1").addSourceCode(";\n").unIndent().addSourceCode("end;\n\n").unIndent(2).addSourceCode("end; ").addCommentLine("End of no changes in type 2 columns").addSourceCode("\n");
        }
        codeSegment.unIndent().addSourceCode("end; ").addCommentLine("End of inSort and inXref").addSourceCode("\n\n");
        codeSegment.addCommentLine("Process new records").addSourceCode("else if inSort and not inXref then \n").addSourceCode("do;\n\n").indent().addSourceCode("NewMaxKey").addSourceCode(" = ").addSourceCode(newRcdExp).addSourceCode(";\n").addSourceCode(generatedKeyName).addSourceCode(" = ").addSourceCode("NewMaxKey").addSourceCode(";\n\n");
        if (versionColumn != null) {
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"first.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if first.").addSourceCode(lastBusKey);
            }
            codeSegment.addSourceCode(" then \n").indent().addSourceCode("ETLS_NEWVERS").addSourceCode(" = 0;\n").unIndent();
            this.genVersionIncrement(versionColumn, lastBusKeyColumn, lastBusKey, codeSegment);
        }
        if (codeSegment.isQuoting()) {
            codeSegment.addSourceCode("if \"last.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
        } else {
            codeSegment.addSourceCode("if last.").addSourceCode(lastBusKey);
        }
        codeSegment.addSourceCode(" then");
        codeSegment.newLine();
        codeSegment.indent();
        codeSegment.addSourceCode(currIndName).addSourceCode(" = " + this.getCurrentIndicatorYesValue() + ";");
        codeSegment.newLine();
        codeSegment.unIndent();
        codeSegment.addSourceCode("else");
        codeSegment.newLine();
        codeSegment.indent();
        codeSegment.addSourceCode(currIndName).addSourceCode(" = " + this.getCurrentIndicatorNoValue() + ";");
        codeSegment.newLine(2);
        codeSegment.unIndent();
        if (ldTimeName.length() > 0) {
            codeSegment.addSourceCode(ldTimeName).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n\n");
        }
        codeSegment.addSourceCode("output ").addSourceCode("work.etls_newrcds").addSourceCode(";\n\n").unIndent().addSourceCode("end;\n\n");
        if (this.isCloseRecsNotInSource()) {
            codeSegment.addCommentLine("Close out any records that are in the xref table but not in the source.").addSourceCode("else if inXref and not inSort then\n").indent().addSourceCode("do;\n\n").indent();
            codeSegment.addSourceCode(currIndName).addSourceCode(" = " + this.getCurrentIndicatorNoValue() + ";");
            codeSegment.newLine(2);
            if (ldTimeName.length() > 0) {
                codeSegment.addSourceCode(ldTimeName).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n").addSourceCode("ETLS_LOADTIME").addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n\n");
            }
            codeSegment.addSourceCode("output ").addSourceCode("work.etls_close").addSourceCode(";\n\n").unIndent().addSourceCode("end;\n\n");
        }
        codeSegment.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        codeSegment.addCommentLine("Sort the output from the data merge step").addSourceCode("proc sort data=").addSourceCode("work.etls_close").addSourceCode(" nodupkey;\n").indent().addSourceCode("by ").addSourceCode("ETLS_KEY").addSourceCode(";\n").unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.addSourceCode("proc sort data=").addSourceCode("work.etls_type1").addSourceCode(" nodupkey;\n").indent().addSourceCode("by ").addSourceCode("ETLS_KEY").addSourceCode(";\n").unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
        }
        this.genSaveWorkTableToPermanentLibref(this.m_mlType1Columns, codeSegment);
        codeSegment.addCommentLine("Save record counts into macros").genGetNumRows("work.etls_close", null, "etls_updatecnt", true).genRCSetCall("&syserr").genGetNumRows("work.etls_match", null, "etls_matchcnt", true).genRCSetCall("&syserr").genGetNumRows("work.etls_newrcds", null, "etls_newcnt", true).genRCSetCall("&syserr");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.genGetNumRows("work.etls_type1", null, "etls_type1cnt", true).genRCSetCall("&syserr");
        }
    }

    protected void genCurrIndUpdateTargetTable(boolean usePassThru, boolean useTempLibrary, IPhysicalTable targetTable, ICodeSegment codeSegment) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServerException {
        codeSegment.addSectionComment("Update the target table");
        boolean needsQuotes = codeSegment.isQuoting();
        boolean DBMSTempLib = false;
        String targetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment, usePassThru);
        ILibrary library = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        ITransformTableOptions targetOptions = this.getTableOptionObject(targetTable, false);
        String sTargetOptions = targetOptions.getTableOptions(codeSegment.getCurrentServer());
        IDBMSType targetTableDBMSType = targetTable.getDBMSType();
        String currIndName = this.m_currentIndicatorColumn.getColumnName(codeSegment, usePassThru);
        String generatedKeyName = this.m_generatedKeyColumn.getColumnName(codeSegment, usePassThru);
        String ldTimeName = "";
        if (this.getLoadTimeColumn() != null) {
            ldTimeName = this.getLoadTimeColumn().getColumnName(codeSegment, usePassThru);
        }
        ArrayList<String> delWorkTableList = new ArrayList<String>();
        String engine = library.getEngine();
        if (targetTableDBMSType.getDBMSTypeName().equals("SAS") || targetTableDBMSType.getDBMSTypeName().equals("SAS SPDS") && this.getSPDSUpdateTechnique().equals("DataStepModify")) {
            if (this.isIndexAddedToUpdateTempTable()) {
                IWorkTable closeTable = this.createTempUpdateWorklTable("ETLS_CLOSE", new ArrayList(), true, false, new ArrayList());
                closeTable.getDBMSType().createIndexes2(codeSegment, closeTable, null, "");
                if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                    IWorkTable type1Table = this.createTempUpdateWorklTable("ETLS_TYPE1", new ArrayList(), true, false, this.m_mlType1Columns);
                    type1Table.getDBMSType().createIndexes2(codeSegment, type1Table, null, "");
                }
            }
            ArrayList<IColumn> keyColumns = new ArrayList<IColumn>();
            keyColumns.add(this.m_generatedKeyColumn);
            this.genUpdateUsingModify(keyColumns, generatedKeyName, null, null, currIndName, ldTimeName, targetDSName, false, false, this.m_mlType1Columns, codeSegment, this.getCurrentIndicatorYesValue(), this.getCurrentIndicatorNoValue());
            delWorkTableList.add("work.etls_newrcds");
            delWorkTableList.add("work.etls_match");
            delWorkTableList.add("work.etls_close");
            if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                delWorkTableList.add("work.etls_type1");
            }
            codeSegment.addCommentLine("Delete the work tables").addSourceCode("%if &etls_debug eq 0 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(delWorkTableList).unIndent().addSourceCode("%end;\n\n");
        } else {
            String strWorkNew = codeSegment.getUniqueWorkTableName();
            String strWorkMatch = codeSegment.getUniqueWorkTableName(20);
            String strWorkClose = codeSegment.getUniqueWorkTableName(60);
            String strWorkType1 = codeSegment.getUniqueWorkTableName(100);
            String delWorkNew = "";
            String delWorkMatch = "";
            String delWorkClose = "";
            String delWorkType1 = "";
            String dbmsCloseTblNameUnquoted = "";
            String dbmsMatchTblNameUnquoted = "";
            String dbmsNewRcdTblNameUnquoted = "";
            String dbmsType1TblNameUnique = "";
            ILibrary visualUploadLibrary = this.getUploadLibrary();
            ILibrary uploadLibrary = this.getRunTimeUploadLibrary(usePassThru, codeSegment, library);
            if (usePassThru) {
                if (useTempLibrary) {
                    this.genDBMSTempTableLibname(targetTable, codeSegment);
                    DBMSTempLib = true;
                }
                ArrayList<IColumn> keyColumns = new ArrayList<IColumn>();
                keyColumns.add(this.m_generatedKeyColumn);
                this.genDBMSTempCloseTable(strWorkClose, keyColumns, uploadLibrary, true, false, codeSegment);
                String dbmsTempClose = dbmsCloseTblNameUnquoted = strWorkClose;
                if (needsQuotes) {
                    dbmsTempClose = DBMSNamesUtil.getQuotedString(dbmsCloseTblNameUnquoted, true);
                }
                strWorkClose = dbmsTempClose;
                String delTemp = dbmsCloseTblNameUnquoted;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsCloseTblNameUnquoted, false);
                }
                delWorkClose = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                this.genDBMSTempMatchOrNewRecordsTable(strWorkMatch, true, uploadLibrary, codeSegment);
                String dbmsTempMatch = dbmsMatchTblNameUnquoted = strWorkMatch;
                if (needsQuotes) {
                    dbmsTempMatch = DBMSNamesUtil.getQuotedString(dbmsMatchTblNameUnquoted, true);
                }
                strWorkMatch = dbmsTempMatch;
                delTemp = dbmsMatchTblNameUnquoted;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsMatchTblNameUnquoted, false);
                }
                delWorkMatch = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                this.genDBMSTempMatchOrNewRecordsTable(strWorkNew, false, uploadLibrary, codeSegment);
                String dbmsTempNew = dbmsNewRcdTblNameUnquoted = strWorkNew;
                if (needsQuotes) {
                    dbmsTempNew = DBMSNamesUtil.getQuotedString(dbmsNewRcdTblNameUnquoted, true);
                }
                strWorkNew = dbmsTempNew;
                delTemp = dbmsNewRcdTblNameUnquoted;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsNewRcdTblNameUnquoted, false);
                }
                delWorkNew = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                    this.genDBMSTempType1Table(strWorkType1, keyColumns, uploadLibrary, true, false, this.m_mlType1Columns, codeSegment);
                    String dbmsTempType1 = dbmsType1TblNameUnique = strWorkType1;
                    if (needsQuotes) {
                        dbmsTempType1 = DBMSNamesUtil.getQuotedString(dbmsType1TblNameUnique, true);
                    }
                    strWorkType1 = dbmsTempType1;
                    delTemp = dbmsType1TblNameUnique;
                    if (needsQuotes) {
                        delTemp = DBMSNamesUtil.getQuotedString(dbmsType1TblNameUnique, false);
                    }
                    delWorkType1 = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                }
            } else {
                strWorkClose = "work.etls_close";
                strWorkMatch = "work.etls_match";
                strWorkNew = "work.etls_newrcds";
                if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                    strWorkType1 = "work.etls_type1";
                }
            }
            String tempGenKey = "";
            String tempLoadTime = "";
            if (needsQuotes) {
                tempGenKey = DBMSNamesUtil.getQuotedString("ETLS_KEY", usePassThru);
                tempLoadTime = DBMSNamesUtil.getQuotedString("ETLS_LOADTIME", usePassThru);
            } else {
                tempGenKey = "ETLS_KEY";
                tempLoadTime = "ETLS_LOADTIME";
            }
            String sTableAlias = targetTable.getTableName(codeSegment.isQuoting(), usePassThru);
            String sTableAliasPt = "";
            if (sTableAlias != null && sTableAlias.trim().length() > 0) {
                sTableAliasPt = sTableAlias + ".";
            }
            StringBuffer sbWhereClause = new StringBuffer();
            String schemaName = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
            if (usePassThru && targetTable.getDBMSType() instanceof DB2UNXPCType && schemaName != null && schemaName.trim().length() > 0) {
                sbWhereClause.append(tempGenKey).append(" = ").append(schemaName + ".").append(sTableAliasPt).append(generatedKeyName);
            } else {
                sbWhereClause.append(tempGenKey).append(" = ").append(generatedKeyName);
            }
            if (usePassThru) {
                codeSegment.addCommentLine("Update the target table using SQL pass-thru");
                strWorkNew = this.getTempTableName(usePassThru, useTempLibrary, targetTableDBMSType, dbmsNewRcdTblNameUnquoted);
                strWorkMatch = this.getTempTableName(usePassThru, useTempLibrary, targetTableDBMSType, dbmsMatchTblNameUnquoted);
                strWorkClose = this.getTempTableName(usePassThru, useTempLibrary, targetTableDBMSType, dbmsCloseTblNameUnquoted);
                strWorkType1 = this.getTempTableName(usePassThru, useTempLibrary, targetTableDBMSType, dbmsType1TblNameUnique);
            } else {
                codeSegment.addCommentLine("Update the target table");
            }
            if (needsQuotes && usePassThru) {
                strWorkNew = DBMSNamesUtil.getQuotedString(strWorkNew, true);
                strWorkMatch = DBMSNamesUtil.getQuotedString(strWorkMatch, true);
                strWorkClose = DBMSNamesUtil.getQuotedString(strWorkClose, true);
                strWorkType1 = DBMSNamesUtil.getQuotedString(strWorkType1, true);
            }
            if (engine.equalsIgnoreCase("NETEZZA") && usePassThru) {
                this.cgUpdateCurrentIndicatorNetezza(codeSegment, usePassThru, strWorkClose, strWorkType1, strWorkMatch, strWorkNew);
            } else {
                String schema;
                codeSegment.addSourceCode("proc sql ").addSourceCode(this.getSQLOptions()).addSourceCode(";\n").indent().addCommentLine("Close out existing records");
                String uploadSchema = "";
                if (usePassThru) {
                    IDBMSType targetTableType = targetTableDBMSType;
                    boolean bUseConnectUsing = this.isUseConnectUsingEnabled();
                    if (bUseConnectUsing) {
                        codeSegment.addSourceCode("connect using " + uploadLibrary.getLibref() + " as " + uploadLibrary.getEngine() + ";\n");
                    } else {
                        codeSegment.addSourceCode("connect to " + uploadLibrary.getEngine() + "\n").addSourceCode("( \n").indent();
                        codeSegment.addSourceCode(uploadLibrary.getConnectionOptions());
                        codeSegment.unIndent().addSourceCode("); \n");
                    }
                    if (targetTable.getDBMSType() instanceof ODBCSQLSVRType || targetTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                        codeSegment.newLine().addSourceCode("execute (begin transaction) by ODBC;").newLine(2);
                    }
                    codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent();
                    targetTableType.genExecuteBegin(codeSegment, targetTable, "");
                    if (visualUploadLibrary != null) {
                        uploadSchema = targetTable.getDBMSType().getDBMSTypeName().equals("SAS SPDS") ? uploadLibrary.getLibref() : uploadLibrary.getDatabaseSchema().getSchemaName();
                    }
                } else {
                    codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent();
                }
                codeSegment.indent().addSourceCode("update ").addSourceCode(targetDSName);
                if (sTargetOptions.length() > 0 && !usePassThru) {
                    codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
                }
                codeSegment.addSourceCode("\n").indent();
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode("from ");
                    if (usePassThru && visualUploadLibrary != null) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    }
                    codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
                }
                codeSegment.addSourceCode("set ");
                codeSegment.addSourceCode(currIndName).addSourceCode(" = " + this.getCurrentIndicatorNoValue());
                codeSegment.newLine();
                codeSegment.addSourceCode("where ");
                StringBuffer sbKeySelectClause = new StringBuffer();
                if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                    codeSegment.addSourceCode(sbWhereClause).addSourceCode(" \n").unIndent().unIndent();
                } else {
                    sbKeySelectClause.append(generatedKeyName).append(" = (\n").append(codeSegment.getIndentString());
                    sbKeySelectClause.append("select ").append(tempGenKey).append("\n").append(codeSegment.getIndentString()).append(codeSegment.getIndentString()).append("from ");
                    if (usePassThru && visualUploadLibrary != null) {
                        if (uploadSchema != null && uploadSchema.trim().length() > 0) {
                            sbKeySelectClause.append(uploadSchema).append(".");
                        }
                    } else if (usePassThru && useTempLibrary && targetTableDBMSType instanceof DB2UNXPCType) {
                        sbKeySelectClause.append("SESSION.");
                    } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                        String schema2 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema2).addSourceCode(".");
                    } else if (usePassThru && targetTableDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                        String schema3 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        codeSegment.addSourceCode(schema3).addSourceCode(".");
                    }
                    sbKeySelectClause.append(strWorkClose);
                    sbKeySelectClause.append("\n").append(codeSegment.getIndentString()).append(codeSegment.getIndentString());
                    sbKeySelectClause.append("where ").append(sbWhereClause.toString());
                    sbKeySelectClause.append(" )\n");
                    codeSegment.addSourceCode(sbKeySelectClause).unIndent();
                }
                if (usePassThru) {
                    targetTableDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode(";\n");
                    codeSegment.unIndent().genRCSetCall("&sqlrc");
                }
                if (ldTimeName.length() > 0) {
                    codeSegment.addCommentLine("Update the load time column");
                    if (usePassThru) {
                        targetTableDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                    }
                    codeSegment.addSourceCode("update ").addSourceCode(targetDSName);
                    if (sTargetOptions.length() > 0 && !usePassThru) {
                        codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
                    }
                    codeSegment.addSourceCode("\n").indent();
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode("from ");
                        if (usePassThru && visualUploadLibrary != null) {
                            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                        }
                        codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
                    }
                    codeSegment.addSourceCode("set ").addSourceCode(ldTimeName);
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(" = \n");
                    } else {
                        codeSegment.addSourceCode(" = (\n");
                    }
                    codeSegment.indent();
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(tempLoadTime).addSourceCode("\n");
                    } else {
                        codeSegment.addSourceCode("select ").addSourceCode(tempLoadTime).addSourceCode("\n").indent().addSourceCode("from ");
                        if (usePassThru && visualUploadLibrary != null) {
                            if (uploadSchema != null && uploadSchema.trim().length() > 0) {
                                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                            }
                        } else if (usePassThru && useTempLibrary && targetTableDBMSType instanceof DB2UNXPCType) {
                            codeSegment.addSourceCode("SESSION.");
                        } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                            String schema4 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema4).addSourceCode(".");
                        } else if (usePassThru && targetTableDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                            String schema5 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                            codeSegment.addSourceCode(schema5).addSourceCode(".");
                        }
                        codeSegment.addSourceCode(strWorkClose).addSourceCode("\n");
                    }
                    codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause);
                    if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                        codeSegment.addSourceCode(" \n").unIndent().unIndent();
                    } else {
                        codeSegment.addSourceCode(" )\n").unIndent().unIndent().addSourceCode("where ").addSourceCode(sbKeySelectClause).unIndent();
                    }
                    if (usePassThru) {
                        targetTableDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                    } else {
                        codeSegment.addSourceCode(";\n\n");
                        codeSegment.genRCSetCall("&sqlrc");
                    }
                }
                codeSegment.unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No target table update records were found. The target table was not modified.").addSourceCode("\n").unIndent().addSourceCode("%end;\n\n");
                if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                    codeSegment.addCommentLine("Update the the type 1 column").addSourceCode("%if &etls_type1cnt gt 0 %then\n%do;\n\n").indent();
                    for (int index = 0; index < this.m_mlType1Columns.size(); ++index) {
                        String schema6;
                        IColumn column = (IColumn)this.m_mlType1Columns.get(index);
                        String sColumnName = "";
                        if (usePassThru) {
                            targetTableDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                            sColumnName = column.getColumnName(needsQuotes, true);
                        } else {
                            sColumnName = column.getColumnName(codeSegment);
                        }
                        codeSegment.addSourceCode("update ").addSourceCode(targetDSName);
                        if (sTargetOptions.length() > 0 && !usePassThru) {
                            codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
                        }
                        codeSegment.addSourceCode("\n").indent();
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode("from ");
                            if (usePassThru && visualUploadLibrary != null) {
                                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                            }
                            codeSegment.addSourceCode(strWorkType1).addSourceCode("\n");
                        }
                        codeSegment.addSourceCode("set ").addSourceCode(sColumnName);
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode(" = \n");
                        } else {
                            codeSegment.addSourceCode(" = (\n");
                        }
                        codeSegment.indent();
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode(strWorkType1).addSourceCode(".").addSourceCode(sColumnName).addSourceCode("\n");
                        } else {
                            codeSegment.addSourceCode("select ").addSourceCode(sColumnName).addSourceCode("\n").indent().addSourceCode("from ");
                            if (usePassThru && visualUploadLibrary != null) {
                                if (uploadSchema != null && uploadSchema.trim().length() > 0) {
                                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                                }
                            } else if (usePassThru && useTempLibrary && targetTableDBMSType instanceof DB2UNXPCType) {
                                codeSegment.addSourceCode("SESSION.");
                            } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                                schema6 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema6).addSourceCode(".");
                            } else if (usePassThru && targetTableDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                                schema6 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema6).addSourceCode(".");
                            }
                            codeSegment.addSourceCode(strWorkType1).addSourceCode("\n");
                        }
                        codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause);
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode(" \n").unIndent().unIndent();
                        } else {
                            codeSegment.addSourceCode(" )\n").unIndent().unIndent();
                            codeSegment.addSourceCode("where exists ( select * \n").indent().indent().addSourceCode("from ");
                            if (usePassThru && visualUploadLibrary != null) {
                                if (uploadSchema != null && uploadSchema.trim().length() > 0) {
                                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                                }
                            } else if (usePassThru && useTempLibrary && targetTableDBMSType instanceof DB2UNXPCType) {
                                codeSegment.addSourceCode("SESSION.");
                            } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                                schema6 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema6).addSourceCode(".");
                            } else if (usePassThru && targetTableDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                                schema6 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema6).addSourceCode(".");
                            }
                            codeSegment.addSourceCode(strWorkType1).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClause).addSourceCode(")").unIndent().unIndent();
                        }
                        if (usePassThru) {
                            targetTableDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                            continue;
                        }
                        codeSegment.addSourceCode(";\n\n");
                        codeSegment.genRCSetCall("&sqlrc");
                    }
                    codeSegment.unIndent().unIndent().unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No target table type1 records were found. The target table was not modified.").addSourceCode("\n").unIndent().addSourceCode("%end;\n");
                }
                String selectList = codeSegment.makeColumnList(targetTable, true, "   ", usePassThru, ",", "", needsQuotes, "");
                String colList = codeSegment.makeColumnList(targetTable, false, "", usePassThru, ",", "", needsQuotes, "");
                codeSegment.addCommentLine("Insert the new matching records").addSourceCode("%if &etls_matchcnt gt 0 %then\n%do;\n\n").indent();
                if (usePassThru) {
                    targetTableDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                }
                codeSegment.addSourceCode("insert into ").addSourceCode(targetDSName).addSourceCode("\n").indent().addSourceCode("( ");
                if (sTargetOptions.length() > 0 && !usePassThru) {
                    codeSegment.addSourceCode("\n").addSourceCode(sTargetOptions).addSourceCode(", \n");
                }
                codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("Select ").addSourceCode(selectList).addSourceCode("\n").indent().addSourceCode("from ");
                if (usePassThru && visualUploadLibrary != null) {
                    if (uploadSchema != null && uploadSchema.trim().length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    }
                } else if (usePassThru && useTempLibrary && targetTableDBMSType instanceof DB2UNXPCType) {
                    codeSegment.addSourceCode("SESSION.");
                } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                    schema = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                } else if (usePassThru && targetTableDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                    schema = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkMatch).unIndent();
                if (usePassThru) {
                    targetTableDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode(";\n\n");
                    codeSegment.genRCSetCall("&sqlrc");
                }
                codeSegment.unIndent().addSourceCode("%end;\n\n");
                codeSegment.addCommentLine("Insert the new dimension records").addSourceCode("%if &etls_newcnt gt 0 %then\n%do;\n\n").indent();
                if (usePassThru) {
                    targetTableDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                }
                codeSegment.addSourceCode("insert into ").addSourceCode(targetDSName).addSourceCode("\n").indent().addSourceCode("( ");
                if (sTargetOptions.length() > 0 && !usePassThru) {
                    codeSegment.addSourceCode("\n").addSourceCode(sTargetOptions).addSourceCode(", \n");
                }
                codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("select ").addSourceCode(selectList).addSourceCode("\n").indent().addSourceCode("from ");
                if (usePassThru && visualUploadLibrary != null) {
                    if (uploadSchema != null && uploadSchema.trim().length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    }
                } else if (usePassThru && useTempLibrary && targetTableDBMSType instanceof DB2UNXPCType) {
                    codeSegment.addSourceCode("SESSION.");
                } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                    schema = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                } else if (usePassThru && targetTableDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                    schema = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkNew).unIndent();
                if (usePassThru) {
                    targetTableDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode(";\n\n");
                    codeSegment.genRCSetCall("&sqlrc");
                }
                codeSegment.unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No new dimensions were found. The target table was not modified.").addSourceCode("\n").unIndent().addSourceCode("%end;\n\n");
                if (usePassThru) {
                    if (targetTableDBMSType instanceof ODBCSQLSVRType || targetTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                        targetTableDBMSType.genExecuteCommit(codeSegment, targetTable, "execute (commit) by ODBC;");
                    } else {
                        targetTableDBMSType.genExecuteCommit(codeSegment, targetTable, "");
                    }
                    codeSegment.newLine();
                    targetTableDBMSType.genDisconnect(codeSegment, targetTable);
                }
                codeSegment.unIndent().addSourceCode("quit;\n\n");
            }
            if (usePassThru) {
                delWorkTableList.add(delWorkNew);
                delWorkTableList.add(delWorkMatch);
                delWorkTableList.add(delWorkClose);
                if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                    delWorkTableList.add(delWorkType1);
                }
                codeSegment.addCommentLine("Delete the work tables").genTableDelete(delWorkTableList);
                if (visualUploadLibrary == null && useTempLibrary) {
                    codeSegment.addCommentLine("Clear the temporary upload library").addSourceCode("libname ").addSourceCode("etlstmp").addSourceCode(" clear;\n\n");
                }
            }
            delWorkTableList.clear();
            delWorkTableList.add("work.etls_newrcds");
            delWorkTableList.add("work.etls_match");
            delWorkTableList.add("work.etls_close");
            if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                delWorkTableList.add("work.etls_type1");
            }
            codeSegment.addCommentLine("Delete the work tables").addSourceCode("%if &etls_debug eq 0 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(delWorkTableList).unIndent().addSourceCode("%end;\n\n");
        }
    }

    protected void genVersNumDataMergeStep(List busKeyColumns, IColumn versionColumn, IColumn ldTimeColumn, IColumn generatedKeyColumn, String chgRcdExp, String newRcdExp, boolean needsQuotes, String sourceDSName, String xrefDSName, String saveToLibRef, ICodeSegment codeSegment) throws MdException, RemoteException {
        IColumn lastBusKeyColumn = (IColumn)busKeyColumns.get(busKeyColumns.size() - 1);
        String lastBusKey = lastBusKeyColumn.getColumnName(codeSegment);
        String strBusKeyColumns = codeSegment.makeColumnList(busKeyColumns, " ", needsQuotes);
        String ldTimeName = "";
        if (ldTimeColumn != null) {
            ldTimeName = ldTimeColumn.getColumnName(codeSegment);
        }
        String generatedKeyName = generatedKeyColumn.getColumnName(codeSegment);
        StringBuffer digestValueName = new StringBuffer();
        if (needsQuotes) {
            digestValueName.append("\"").append("DIGEST_VALUE").append("\"n");
        } else {
            digestValueName.append("DIGEST_VALUE");
        }
        ArrayList<String> dropList = new ArrayList<String>();
        dropList.add("ETLS_STGDIGEST");
        dropList.add("DIGEST_VALUE");
        dropList.add("NewMaxKey");
        dropList.add("ETLS_NEWVERS");
        StringBuffer retainClause = new StringBuffer();
        retainClause.append("NewMaxKey").append(" &").append("etls_maxkey").append(" ").append("ETLS_NEWVERS");
        ArrayList<String> lKeepType1 = new ArrayList<String>();
        lKeepType1.add("ETLS_KEY");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            lKeepType1.addAll(this.m_mlType1Columns);
            dropList.add("ETLS_KEY");
            dropList.add("ETLS_TYPE1DIGEST");
            dropList.add("DIGEST_VALUE_TYPE1");
        }
        if (this.getLoadTimeColumn() != null && this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            lKeepType1.add("ETLS_LOADTIME");
            dropList.add("ETLS_LOADTIME");
        }
        String sKeepType1Clause = codeSegment.makeColumnList(lKeepType1, "           ", codeSegment.isQuoting());
        String dropClause = codeSegment.makeColumnList(dropList, "            ", needsQuotes);
        codeSegment.addCommentLine("Data merge the cross-reference and source tables").addSourceCode("data ").addSourceCode("work.etls_newrcds").addSourceCode(" (drop = ").addSourceCode(dropClause).addSourceCode(")\n").indent().addSourceCode("work.etls_match").addSourceCode(" (drop = ").addSourceCode(dropClause).addSourceCode(")\n");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.addSourceCode("work.etls_type1").addSourceCode("\n").indent().addSourceCode(" (keep = ").addSourceCode(sKeepType1Clause).addSourceCode(")\n").unIndent();
        }
        codeSegment.addSourceCode(";\n").addSourceCode("retain ").addSourceCode(retainClause).addSourceCode(";\n\n");
        codeSegment.addSourceCode("merge ").addSourceCode(sourceDSName).addSourceCode("(in=inSort ").addSourceCode("rename=(").addSourceCode(digestValueName).addSourceCode(" = ").addSourceCode("ETLS_STGDIGEST");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.addSourceCode(" ").addSourceCode("DIGEST_VALUE_TYPE1").addSourceCode(" = ").addSourceCode("ETLS_TYPE1DIGEST");
        }
        codeSegment.addSourceCode("))\n").indent().addSourceCode(xrefDSName).addSourceCode(" (in=inXref ");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.addSourceCode("rename=(").addSourceCode(generatedKeyName).addSourceCode(" = ").addSourceCode("ETLS_KEY").addSourceCode(")\n");
        }
        codeSegment.addSourceCode(");\n").unIndent().addSourceCode("by " + strBusKeyColumns + ";\n\n");
        String ldTimeFormat = "";
        String ldTimeInformat = "";
        if (ldTimeColumn != null) {
            ldTimeFormat = ldTimeColumn.getFormat();
            if (ldTimeFormat.length() < 1) {
                ldTimeFormat = "datetime20.";
            }
            if ((ldTimeInformat = ldTimeColumn.getInformat()).length() < 1) {
                ldTimeInformat = "datetime20.";
            }
        }
        codeSegment.addCommentLine("Process changes made to existing records").addSourceCode("if inSort and inXref then\n").addSourceCode("do;\n\n").indent();
        if (versionColumn != null) {
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"first.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if first.").addSourceCode(lastBusKey);
            }
            codeSegment.addSourceCode(" then\n").indent().addSourceCode("ETLS_NEWVERS").addSourceCode(" = ").addSourceCode(versionColumn.getColumnName(codeSegment)).addSourceCode(";\n\n").unIndent();
        }
        codeSegment.addSourceCode("if ").addSourceCode("ETLS_STGDIGEST").addSourceCode(" NE ").addSourceCode(digestValueName).addSourceCode(" then\ndo;\n\n").indent();
        if (ldTimeName.length() > 0) {
            codeSegment.addSourceCode(ldTimeName).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n\n");
        }
        codeSegment.addSourceCode("NewMaxKey").addSourceCode(" = ").addSourceCode(chgRcdExp).addSourceCode(";\n").addSourceCode(generatedKeyName).addSourceCode(" = ").addSourceCode("NewMaxKey").addSourceCode(";\n\n");
        codeSegment.addCommentLine("Overwrite the values to compare new records with from cross-reference ").addCommentLine("variable values to the new current values from source").addSourceCode(digestValueName).addSourceCode(" = ").addSourceCode("ETLS_STGDIGEST").addSourceCode(";\n");
        if (versionColumn != null) {
            this.genVersionIncrement(versionColumn, lastBusKeyColumn, lastBusKey, codeSegment);
        }
        codeSegment.addSourceCode("output ").addSourceCode("work.etls_match").addSourceCode(";\n\n");
        codeSegment.unIndent().addSourceCode("end;\n\n");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.addSourceCode("else do;\n\n").indent().addCommentLine("Output to the type 1 work table if there are type 1 column changes");
            codeSegment.addSourceCode("if ").addSourceCode("ETLS_TYPE1DIGEST").addSourceCode(" NE ").addSourceCode("DIGEST_VALUE_TYPE1").addSourceCode(" then\n").indent();
            if (codeSegment.isQuoting()) {
                codeSegment.addSourceCode("if \"last.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
            } else {
                codeSegment.addSourceCode("if last.").addSourceCode(lastBusKey);
            }
            codeSegment.addSourceCode(" then\ndo;\n").indent();
            if (ldTimeName.length() > 0) {
                codeSegment.addSourceCode("ETLS_LOADTIME").addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n");
            }
            codeSegment.addSourceCode("output ").addSourceCode("work.etls_type1").addSourceCode(";\n").unIndent().addSourceCode("end;\n\n").unIndent(2).addSourceCode("end; ").addCommentLine("End of no changes in type 2 columns").addSourceCode("\n");
        }
        codeSegment.unIndent().addSourceCode("end;").addCommentLine("End of inSort and inXref").addSourceCode("\n\n");
        codeSegment.addCommentLine("Process new records").addSourceCode("else if inSort and not inXref then \n").addSourceCode("do;\n\n").indent().addSourceCode("NewMaxKey").addSourceCode(" = ").addSourceCode(newRcdExp).addSourceCode(";\n").addSourceCode(generatedKeyName).addSourceCode(" = ").addSourceCode("NewMaxKey").addSourceCode(";\n\n");
        if (codeSegment.isQuoting()) {
            codeSegment.addSourceCode("if \"first.").addSourceCode(lastBusKeyColumn.getColumnName(false)).addSourceCode("\"n");
        } else {
            codeSegment.addSourceCode("if first.").addSourceCode(lastBusKey);
        }
        codeSegment.addSourceCode(" then \n").indent().addSourceCode("ETLS_NEWVERS").addSourceCode(" = 0;\n").unIndent();
        this.genVersionIncrement(this.getVersionColumn(), lastBusKeyColumn, lastBusKey, codeSegment);
        if (ldTimeName.length() > 0) {
            codeSegment.addSourceCode(ldTimeName).addSourceCode(" = input(\"&etls_loadtime\", ").addSourceCode("datetime20.").addSourceCode(");\n\n");
        }
        codeSegment.addSourceCode("output ").addSourceCode("work.etls_newrcds").addSourceCode(";\n\n").unIndent().addSourceCode("end;\n\n").unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.addCommentLine("Sort the output from the data merge step").addSourceCode("proc sort data=").addSourceCode("work.etls_type1").addSourceCode(" nodupkey;\n").indent().addSourceCode("by ").addSourceCode("ETLS_KEY").addSourceCode(";\n").unIndent().addSourceCode("run;\n").genRCSetCall("&syserr");
        }
        this.genSaveWorkTableToPermanentLibref(this.m_mlType1Columns, codeSegment, true);
        codeSegment.addCommentLine("Save record counts into macros").genGetNumRows("work.etls_match", null, "etls_matchcnt", true).genRCSetCall("&syserr").genGetNumRows("work.etls_newrcds", null, "etls_newcnt", true).genRCSetCall("&syserr");
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.genGetNumRows("work.etls_type1", null, "etls_type1cnt", true).genRCSetCall("&syserr");
        }
    }

    protected void genVersNumUpdateTargetTable(boolean usePassThru, boolean useTempLibrary, IPhysicalTable targetTable, ICodeSegment codeSegment) throws MdException, RemoteException, BadServerDefinitionException, CodegenException, ServerException, BadLibraryDefinitionException {
        codeSegment.addSectionComment("Start of target table update");
        boolean needsQuotes = codeSegment.isQuoting();
        boolean DBMSTempLib = false;
        String targetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment, usePassThru);
        ILibrary library = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        IDBMSType targetTableDBMSType = targetTable.getDBMSType();
        ITransformTableOptions targetOptions = this.getTableOptionObject(targetTable, false);
        String sTargetOptions = targetOptions.getTableOptions(codeSegment.getCurrentServer());
        String ldTimeName = "";
        if (this.getLoadTimeColumn() != null) {
            ldTimeName = this.getLoadTimeColumn().getColumnName(codeSegment, usePassThru);
        }
        ArrayList<String> delWorkTableList = new ArrayList<String>();
        String engine = library.getEngine();
        if (targetTableDBMSType.getDBMSTypeName().equals("SAS") || targetTableDBMSType.getDBMSTypeName().equals("SAS SPDS") && this.getSPDSUpdateTechnique().equals("DataStepModify")) {
            ArrayList<IColumn> keyColumns = new ArrayList<IColumn>();
            keyColumns.add(this.m_generatedKeyColumn);
            String genKeyName = this.m_generatedKeyColumn.getColumnName(codeSegment);
            this.genUpdateUsingModify(keyColumns, genKeyName, null, null, null, ldTimeName, targetDSName, false, true, this.m_mlType1Columns, codeSegment, this.getCurrentIndicatorYesValue(), this.getCurrentIndicatorNoValue());
            delWorkTableList.add("work.etls_newrcds");
            delWorkTableList.add("work.etls_match");
            if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                delWorkTableList.add("work.etls_type1");
            }
            codeSegment.addCommentLine("Delete the work tables").addSourceCode("%if &etls_debug eq 0 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(delWorkTableList).unIndent().addSourceCode("%end;\n\n");
        } else {
            String strWorkNew = codeSegment.getUniqueWorkTableName();
            String strWorkMatch = codeSegment.getUniqueWorkTableName(20);
            String strWorkType1 = codeSegment.getUniqueWorkTableName(100);
            String delWorkNew = "";
            String delWorkMatch = "";
            String delWorkType1 = "";
            String dbmsMatchTblNameUnquoted = "";
            String dbmstNewRcdTblNameUnquoted = "";
            String dbmsType1TblNameUnique = "";
            ILibrary visualUploadLibrary = this.getUploadLibrary();
            ILibrary uploadLibrary = this.getRunTimeUploadLibrary(usePassThru, codeSegment, library);
            if (usePassThru) {
                if (this.useTempLibrary(codeSegment)) {
                    this.genDBMSTempTableLibname(targetTable, codeSegment);
                    DBMSTempLib = true;
                } else {
                    uploadLibrary.genAccessPath(codeSegment);
                }
                this.genDBMSTempMatchOrNewRecordsTable(strWorkMatch, true, uploadLibrary, codeSegment);
                String dbmsTempMatch = dbmsMatchTblNameUnquoted = strWorkMatch;
                if (needsQuotes) {
                    dbmsTempMatch = DBMSNamesUtil.getQuotedString(dbmsMatchTblNameUnquoted, true);
                }
                strWorkMatch = dbmsTempMatch;
                String delTemp = dbmsMatchTblNameUnquoted;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmsMatchTblNameUnquoted, false);
                }
                delWorkMatch = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                this.genDBMSTempMatchOrNewRecordsTable(strWorkNew, false, uploadLibrary, codeSegment);
                String dbmsTempNew = dbmstNewRcdTblNameUnquoted = strWorkNew;
                if (needsQuotes) {
                    dbmsTempNew = DBMSNamesUtil.getQuotedString(dbmstNewRcdTblNameUnquoted, true);
                }
                strWorkNew = dbmsTempNew;
                delTemp = dbmstNewRcdTblNameUnquoted;
                if (needsQuotes) {
                    delTemp = DBMSNamesUtil.getQuotedString(dbmstNewRcdTblNameUnquoted, false);
                }
                delWorkNew = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                    ArrayList<IColumn> keyColumns = new ArrayList<IColumn>();
                    keyColumns.add(this.m_generatedKeyColumn);
                    this.genDBMSTempType1Table(strWorkType1, keyColumns, uploadLibrary, true, false, this.m_mlType1Columns, codeSegment);
                    String dbmsTempType1 = dbmsType1TblNameUnique = strWorkType1;
                    if (needsQuotes) {
                        dbmsTempType1 = DBMSNamesUtil.getQuotedString(dbmsType1TblNameUnique, true);
                    }
                    strWorkType1 = dbmsTempType1;
                    delTemp = dbmsType1TblNameUnique;
                    if (needsQuotes) {
                        delTemp = DBMSNamesUtil.getQuotedString(dbmsType1TblNameUnique, false);
                    }
                    delWorkType1 = visualUploadLibrary == null && useTempLibrary ? "etlstmp." + delTemp : uploadLibrary.getLibref() + "." + delTemp;
                }
            } else {
                strWorkMatch = "work.etls_match";
                strWorkNew = "work.etls_newrcds";
                if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                    strWorkType1 = "work.etls_type1";
                }
            }
            if (usePassThru) {
                codeSegment.addCommentLine("Update the target table using SQL pass-thru");
                strWorkNew = this.getTempTableName(usePassThru, useTempLibrary, targetTableDBMSType, dbmstNewRcdTblNameUnquoted);
                strWorkMatch = this.getTempTableName(usePassThru, useTempLibrary, targetTableDBMSType, dbmsMatchTblNameUnquoted);
                strWorkType1 = this.getTempTableName(usePassThru, useTempLibrary, targetTableDBMSType, dbmsType1TblNameUnique);
            } else {
                codeSegment.addCommentLine("Update the target table");
            }
            if (needsQuotes && usePassThru) {
                strWorkNew = DBMSNamesUtil.getQuotedString(strWorkNew, true);
                strWorkMatch = DBMSNamesUtil.getQuotedString(strWorkMatch, true);
                strWorkType1 = DBMSNamesUtil.getQuotedString(strWorkType1, true);
            }
            if (engine.equalsIgnoreCase("NETEZZA") && usePassThru) {
                this.cgUpdateVersionNumberNetezza(codeSegment, usePassThru, strWorkType1, strWorkMatch, strWorkNew);
            } else {
                String schema;
                codeSegment.addSourceCode("proc sql ").addSourceCode(this.getSQLOptions()).addSourceCode(";\n").indent();
                String uploadSchema = "";
                if (usePassThru) {
                    boolean bUseConnectUsing;
                    if (visualUploadLibrary != null) {
                        uploadSchema = targetTable.getDBMSType().getDBMSTypeName().equals("SAS SPDS") ? uploadLibrary.getLibref() : uploadLibrary.getDatabaseSchema().getSchemaName();
                    }
                    if (bUseConnectUsing = this.isUseConnectUsingEnabled()) {
                        codeSegment.addSourceCode("connect using " + uploadLibrary.getLibref() + " as " + uploadLibrary.getEngine() + ";\n");
                    } else {
                        codeSegment.addSourceCode("connect to " + uploadLibrary.getEngine() + "\n").addSourceCode("( \n").indent();
                        codeSegment.addSourceCode(uploadLibrary.getConnectionOptions());
                        codeSegment.unIndent().addSourceCode("); \n");
                    }
                    if (targetTable.getDBMSType() instanceof ODBCSQLSVRType || targetTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                        codeSegment.newLine().addSourceCode("execute (begin transaction) by ODBC;").newLine(2);
                    }
                    codeSegment.addSourceCode("%if &etls_matchcnt gt 0 %then\n%do;\n\n").indent();
                    targetTableDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode("%if &etls_matchcnt gt 0 %then\n%do;\n\n").indent();
                }
                String selectList = codeSegment.makeColumnList(targetTable, true, "   ", usePassThru, ",", "", needsQuotes, "");
                String colList = codeSegment.makeColumnList(targetTable, false, "", usePassThru, ",", "", needsQuotes, "");
                codeSegment.addCommentLine("Insert the new matching records").addSourceCode("insert into ").addSourceCode(targetDSName).addSourceCode("\n").indent().addSourceCode("( ");
                if (sTargetOptions.length() > 0 && !usePassThru) {
                    codeSegment.addSourceCode("\n").addSourceCode(sTargetOptions).addSourceCode(", \n");
                }
                codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("Select ").addSourceCode(selectList).addSourceCode("\n").indent().addSourceCode("from ");
                if (usePassThru && visualUploadLibrary != null) {
                    if (uploadSchema != null && uploadSchema.trim().length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    }
                } else if (usePassThru && useTempLibrary && targetTableDBMSType instanceof DB2UNXPCType) {
                    codeSegment.addSourceCode("SESSION.");
                } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                    schema = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                } else if (usePassThru && targetTableDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                    schema = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkMatch).unIndent(2);
                if (usePassThru) {
                    targetTableDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode(";\n\n");
                    codeSegment.genRCSetCall("&sqlrc");
                }
                codeSegment.unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("=No new dimensions were found. The target table was not modified.").unIndent().addSourceCode("%end;\n\n");
                codeSegment.addCommentLine("Insert the new dimension records").addSourceCode("%if &etls_newcnt gt 0 %then\n%do;\n\n").indent();
                if (usePassThru) {
                    targetTableDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                }
                codeSegment.addSourceCode("insert into ").addSourceCode(targetDSName).addSourceCode("\n").indent().addSourceCode("( ");
                if (sTargetOptions.length() > 0 && !usePassThru) {
                    codeSegment.addSourceCode("\n").addSourceCode(sTargetOptions).addSourceCode(", \n");
                }
                codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("select ").addSourceCode(selectList).addSourceCode("\n").indent().addSourceCode("from ");
                if (usePassThru && visualUploadLibrary != null) {
                    if (uploadSchema != null && uploadSchema.trim().length() > 0) {
                        codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                    }
                } else if (usePassThru && useTempLibrary && targetTableDBMSType instanceof DB2UNXPCType) {
                    codeSegment.addSourceCode("SESSION.");
                } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                    schema = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                } else if (usePassThru && targetTableDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                    schema = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                    codeSegment.addSourceCode(schema).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkNew).unIndent(2);
                if (usePassThru) {
                    targetTableDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                } else {
                    codeSegment.addSourceCode(";\n\n");
                    codeSegment.genRCSetCall("&sqlrc");
                }
                codeSegment.unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No new dimensions were found. The target table was not modified.").addSourceCode("\n").unIndent().addSourceCode("%end;\n\n");
                if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                    codeSegment.addCommentLine("Update the the type 1 column").addSourceCode("%if &etls_type1cnt gt 0 %then\n%do;\n\n").indent();
                    for (int index = 0; index < this.m_mlType1Columns.size(); ++index) {
                        String schema2;
                        IColumn column = (IColumn)this.m_mlType1Columns.get(index);
                        String sColumnName = "";
                        if (usePassThru) {
                            targetTableDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                            sColumnName = column.getColumnName(needsQuotes, true);
                        } else {
                            sColumnName = column.getColumnName(codeSegment);
                        }
                        String tempGenKey = "";
                        tempGenKey = needsQuotes ? DBMSNamesUtil.getQuotedString("ETLS_KEY", usePassThru) : "ETLS_KEY";
                        String generatedKeyName = this.m_generatedKeyColumn.getColumnName(codeSegment, usePassThru);
                        String sTableAlias = targetTable.getTableName(codeSegment.isQuoting(), usePassThru);
                        String sTableAliasPt = "";
                        if (sTableAlias != null && sTableAlias.trim().length() > 0) {
                            sTableAliasPt = sTableAlias + ".";
                        }
                        StringBuffer sbWhereClause = new StringBuffer();
                        String schemaName = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                        if (usePassThru && targetTable.getDBMSType() instanceof DB2UNXPCType && schemaName != null && schemaName.trim().length() > 0) {
                            sbWhereClause.append(tempGenKey).append(" = ").append(schemaName + ".").append(sTableAliasPt).append(generatedKeyName);
                        } else {
                            sbWhereClause.append(tempGenKey).append(" = ").append(generatedKeyName);
                        }
                        codeSegment.addSourceCode("update ").addSourceCode(targetDSName);
                        if (sTargetOptions.length() > 0 && !usePassThru) {
                            codeSegment.addSourceCode("\n(").addSourceCode(sTargetOptions).addSourceCode(")");
                        }
                        codeSegment.addSourceCode("\n").indent();
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode("from ");
                            if (usePassThru && visualUploadLibrary != null) {
                                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                            }
                            codeSegment.addSourceCode(strWorkType1).addSourceCode("\n");
                        }
                        codeSegment.addSourceCode("set ").addSourceCode(sColumnName);
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode(" = \n");
                        } else {
                            codeSegment.addSourceCode(" = (\n");
                        }
                        codeSegment.indent();
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode(strWorkType1).addSourceCode(".").addSourceCode(sColumnName).addSourceCode("\n");
                        } else {
                            codeSegment.addSourceCode("select ").addSourceCode(sColumnName).addSourceCode("\n").indent().addSourceCode("from ");
                            if (usePassThru && visualUploadLibrary != null) {
                                if (uploadSchema != null && uploadSchema.trim().length() > 0) {
                                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                                }
                            } else if (usePassThru && useTempLibrary && targetTableDBMSType instanceof DB2UNXPCType) {
                                codeSegment.addSourceCode("SESSION.");
                            } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                                schema2 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema2).addSourceCode(".");
                            } else if (usePassThru && targetTableDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                                schema2 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema2).addSourceCode(".");
                            }
                            codeSegment.addSourceCode(strWorkType1).addSourceCode("\n");
                        }
                        codeSegment.addSourceCode("where ").addSourceCode(sbWhereClause);
                        if (usePassThru && engine.equalsIgnoreCase("TERADATA")) {
                            codeSegment.addSourceCode(" \n").unIndent().unIndent();
                        } else {
                            codeSegment.addSourceCode(" )\n").unIndent().unIndent();
                            codeSegment.addSourceCode("where exists ( select 1 \n").indent().indent().addSourceCode("from ");
                            if (usePassThru && visualUploadLibrary != null) {
                                if (uploadSchema != null && uploadSchema.trim().length() > 0) {
                                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                                }
                            } else if (usePassThru && useTempLibrary && targetTableDBMSType instanceof DB2UNXPCType) {
                                codeSegment.addSourceCode("SESSION.");
                            } else if (usePassThru && engine.equalsIgnoreCase("POSTGRES") && !DBMSTempLib) {
                                schema2 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema2).addSourceCode(".");
                            } else if (usePassThru && targetTableDBMSType instanceof SASIOHNAType && !DBMSTempLib) {
                                schema2 = targetTableDBMSType.getSchemaName(codeSegment.getCurrentServer(), targetTable, true);
                                codeSegment.addSourceCode(schema2).addSourceCode(".");
                            }
                            codeSegment.addSourceCode(strWorkType1).addSourceCode("\n").addSourceCode("where ").addSourceCode(sbWhereClause).addSourceCode(")").unIndent().unIndent();
                        }
                        if (usePassThru) {
                            targetTableDBMSType.genExecuteEnd(codeSegment, targetTable, "");
                            continue;
                        }
                        codeSegment.addSourceCode(";\n\n");
                        codeSegment.genRCSetCall("&sqlrc");
                    }
                    codeSegment.unIndent().unIndent().unIndent().addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No target table type1 records were found. The target table was not modified.").addSourceCode("\n").unIndent().addSourceCode("%end;\n");
                }
                if (usePassThru) {
                    if (targetTable.getDBMSType() instanceof ODBCSQLSVRType || targetTable.getDBMSType() instanceof ODBCSQLSVRPCType) {
                        targetTableDBMSType.genExecuteCommit(codeSegment, targetTable, "execute (commit) by ODBC;");
                    } else {
                        targetTableDBMSType.genExecuteCommit(codeSegment, targetTable, "");
                    }
                    targetTableDBMSType.genDisconnect(codeSegment, targetTable);
                }
                codeSegment.unIndent().addSourceCode("quit;\n\n");
            }
            if (usePassThru) {
                delWorkTableList.add(delWorkNew);
                delWorkTableList.add(delWorkMatch);
                if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                    delWorkTableList.add(delWorkType1);
                }
                codeSegment.addCommentLine("Delete the work tables").genTableDelete(delWorkTableList);
                if (visualUploadLibrary == null && useTempLibrary) {
                    codeSegment.addCommentLine("Clear the temporary upload library").addSourceCode("libname ").addSourceCode("etlstmp").addSourceCode(" clear;\n\n");
                }
            }
            delWorkTableList.clear();
            delWorkTableList.add("work.etls_newrcds");
            delWorkTableList.add("work.etls_match");
            if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
                delWorkTableList.add("work.etls_type1");
            }
            codeSegment.addCommentLine("Delete the work tables").addSourceCode("%if &etls_debug eq 0 %then\n").addSourceCode("%do;\n\n").indent().genTableDelete(delWorkTableList).unIndent().addSourceCode("%end;\n\n");
        }
    }

    @Override
    protected void cleanupMappings() {
        IMapping maxKeyMapping;
        IMapping changedRecordMapping;
        String changedRecordExpression;
        IMapping newRecordMapping;
        String newRecordExpression;
        IMapping type1ColumnsMapping;
        IMapping digestColumnsMapping;
        IMapping versionNumberMapping;
        IMapping currentIndicatorMapping;
        super.cleanupMappings();
        if (!this.isTrackChangesByCurrentIndicator() && (currentIndicatorMapping = this.findTargetMapping(CURRENT_INDICATOR_TRANSFORMROLE)) != null) {
            this.removeMapping(currentIndicatorMapping);
        }
        if (!this.isTrackChangesByVersionNumber() && (versionNumberMapping = this.findTargetMapping(VERSION_TRANSFORMROLE)) != null) {
            this.removeMapping(versionNumberMapping);
        }
        if (this.m_mlDigestColumns.size() == 0 && (digestColumnsMapping = this.findTargetMapping(DIGEST_TRANSFORMROLE)) != null) {
            this.removeMapping(digestColumnsMapping);
        }
        if (this.m_mlType1Columns.size() == 0 && (type1ColumnsMapping = this.findTargetMapping(TYPE1_COLUMNS_TRANSFORMROLE)) != null) {
            this.removeMapping(type1ColumnsMapping);
        }
        if (((newRecordExpression = this.getNewRecordGenKeyExpressionText()) == null || newRecordExpression.length() == 0) && (newRecordMapping = this.findTargetMapping(NEW_RECORD_GENKEY_TRANSFORMROLE)) != null) {
            this.removeMapping(newRecordMapping);
        }
        if (((changedRecordExpression = this.getChangedRecordGenKeyExpressionText()) == null || changedRecordExpression.length() == 0) && (changedRecordMapping = this.findTargetMapping(CHANGED_RECORD_GENKEY_TRANSFORMROLE)) != null) {
            this.removeMapping(changedRecordMapping);
        }
        if (this.m_maxKeyColumn == this.m_generatedKeyColumn && !this.isUseMaxKeyUserWrittenCode() && (maxKeyMapping = this.findTargetMapping("SCD2_MaxKeyGenerator")) != null) {
            this.removeMapping(maxKeyMapping);
        }
    }

    protected ICodeSegment cgUpdateCurrentIndicatorNetezza(ICodeSegment codeSegment, boolean usePassThru, String strWorkClose, String strWorkType1, String strWorkMatch, String strWorkNew) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServerException {
        boolean bUseConnectUsing;
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        String sTargetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment, usePassThru);
        IDBMSType targetDBMSType = targetTable.getDBMSType();
        String tgtTableAlias = targetTable.getTableName(codeSegment.isQuoting(), usePassThru);
        boolean needsQuotes = codeSegment.isQuoting();
        ILibrary visualUploadLibrary = this.getUploadLibrary();
        ILibrary library = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        ILibrary uploadLibrary = this.getRunTimeUploadLibrary(usePassThru, codeSegment, library);
        ArrayList<IColumn> keyColumns = new ArrayList<IColumn>();
        keyColumns.add(this.m_generatedKeyColumn);
        String uploadSchema = "";
        String srcTableAlias = strWorkClose;
        String tempCloseDate = "";
        String tempFromDate = "";
        String tempGenKey = "";
        String tempLoadTime = "";
        if (codeSegment.isQuoting()) {
            tempGenKey = DBMSNamesUtil.getQuotedString("ETLS_KEY", usePassThru);
            tempCloseDate = DBMSNamesUtil.getQuotedString("ETLS_CLSDATE", usePassThru);
            tempFromDate = DBMSNamesUtil.getQuotedString("ETLS_FROMDATE", usePassThru);
            tempLoadTime = DBMSNamesUtil.getQuotedString("ETLS_LOADTIME", usePassThru);
        } else {
            tempGenKey = "ETLS_KEY";
            tempCloseDate = "ETLS_CLSDATE";
            tempFromDate = "ETLS_FROMDATE";
            tempLoadTime = "ETLS_LOADTIME";
        }
        String sLoadTimeColumnName = "";
        if (this.getLoadTimeColumn() != null) {
            sLoadTimeColumnName = this.getLoadTimeColumn().getColumnName(codeSegment, usePassThru);
        }
        String sGeneratedKeyColumnName = "";
        boolean hasGeneratedKey = false;
        if (this.m_generatedKeyColumn != null) {
            hasGeneratedKey = true;
            sGeneratedKeyColumnName = this.m_generatedKeyColumn.getColumnName(codeSegment, usePassThru);
        }
        StringBuffer sbWhereClause = new StringBuffer();
        if (hasGeneratedKey) {
            sbWhereClause.append(srcTableAlias).append(".").append(tempGenKey).append(" = ");
            sbWhereClause.append(tgtTableAlias).append(".").append(sGeneratedKeyColumnName);
        } else {
            sbWhereClause.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", "", tgtTableAlias, codeSegment, false));
        }
        codeSegment.addSourceCode("proc sql").space(1).addSourceCode(this.getSQLOptions()).addSourceCode(";");
        codeSegment.newLine(1);
        codeSegment.indent(1).addCommentLine("Close out existing records");
        if (visualUploadLibrary != null) {
            uploadSchema = uploadLibrary.getDatabaseSchema().getSchemaName();
            uploadSchema = DBMSNamesUtil.getQuotedName(uploadSchema, needsQuotes, needsQuotes, usePassThru);
        }
        if (bUseConnectUsing = this.isUseConnectUsingEnabled()) {
            codeSegment.addSourceCode("connect using " + uploadLibrary.getLibref() + " as " + uploadLibrary.getEngine() + ";\n");
        } else {
            codeSegment.addSourceCode("connect to").space(1).addSourceCode(uploadLibrary.getEngine());
            codeSegment.newLine(1);
            codeSegment.addSourceCode("(");
            codeSegment.newLine(1).indent(1);
            codeSegment.addSourceCode(uploadLibrary.getConnectionOptions());
            codeSegment.newLine(1).unIndent(1).addSourceCode(");");
            codeSegment.newLine(1);
        }
        codeSegment.addSourceCode("%if &etls_updatecnt gt 0 %then\n%do;\n\n").indent(1);
        targetTable.getDBMSType().genExecuteBegin(codeSegment, targetTable, "");
        codeSegment.indent(1).addSourceCode("update").space(1).addSourceCode(sTargetDSName).space(1).addSourceCode(tgtTableAlias);
        codeSegment.newLine(1).indent(1);
        codeSegment.addSourceCode("set").space(1);
        if (this.m_currentIndicatorColumn != null) {
            codeSegment.addSourceCode(this.m_currentIndicatorColumn.getColumnName(needsQuotes, usePassThru)).space(1).addSourceCode("=").space(1).addSourceCode(this.getCurrentIndicatorNoValue()).newLine(1);
        }
        codeSegment.addSourceCode("from").space(1);
        if (visualUploadLibrary != null && uploadSchema.length() > 0) {
            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
        }
        codeSegment.addSourceCode(strWorkClose).space(1).addSourceCode(srcTableAlias);
        codeSegment.newLine(1);
        codeSegment.addSourceCode("where").space(1).addSourceCode(sbWhereClause);
        targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
        if (sLoadTimeColumnName.length() > 0) {
            codeSegment.addCommentLine("Update the load time column");
            targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
            codeSegment.indent(1).addSourceCode("update").space(1).addSourceCode(sTargetDSName).space(1).addSourceCode(tgtTableAlias);
            codeSegment.newLine(1).indent(1);
            codeSegment.addSourceCode("set").space(1);
            codeSegment.addSourceCode(tgtTableAlias).addSourceCode(".").addSourceCode(sLoadTimeColumnName);
            codeSegment.space(1).addSourceCode("=").space(1);
            codeSegment.addSourceCode(srcTableAlias).addSourceCode(".").addSourceCode(tempLoadTime);
            codeSegment.newLine(1);
            codeSegment.addSourceCode("from").space(1);
            if (visualUploadLibrary != null && uploadSchema.length() > 0) {
                codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
            }
            codeSegment.addSourceCode(strWorkClose).space(1).addSourceCode(srcTableAlias);
            codeSegment.newLine(1);
            codeSegment.addSourceCode("where").space(1).addSourceCode(sbWhereClause);
            targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
        }
        codeSegment.unIndent(3).addSourceCode("%end;\n%else %do;\n\n").indent().genPercentPutStatement("No records on target table were closed.").newLine(1).unIndent().addSourceCode("%end;\n");
        srcTableAlias = strWorkType1;
        StringBuffer whereClauseType1 = new StringBuffer();
        if (hasGeneratedKey) {
            whereClauseType1.append(srcTableAlias).append(".").append(tempGenKey).append(" = ");
            whereClauseType1.append(tgtTableAlias).append(".").append(sGeneratedKeyColumnName);
        }
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.addCommentLine("Update type 1 columns");
            codeSegment.addSourceCode("%if &etls_type1cnt gt 0 %then");
            codeSegment.newLine(1);
            codeSegment.addSourceCode("%do;").newLine(2).indent();
            for (int index = 0; index < this.m_mlType1Columns.size(); ++index) {
                IColumn column = (IColumn)this.m_mlType1Columns.get(index);
                String sColumnName = "";
                targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                sColumnName = column.getColumnName(needsQuotes, true);
                codeSegment.indent(1).addSourceCode("update").space(1).addSourceCode(sTargetDSName).space(1).addSourceCode(tgtTableAlias);
                codeSegment.newLine(1).indent(1);
                codeSegment.addSourceCode("set").space(1);
                codeSegment.addSourceCode(tgtTableAlias).addSourceCode(".").addSourceCode(sColumnName);
                codeSegment.space(1).addSourceCode("=").space(1);
                codeSegment.addSourceCode(srcTableAlias).addSourceCode(".").addSourceCode(sColumnName);
                codeSegment.newLine(1);
                codeSegment.addSourceCode("from").space(1);
                if (visualUploadLibrary != null && uploadSchema.length() > 0) {
                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkType1).space(1).addSourceCode(srcTableAlias);
                codeSegment.newLine(1);
                codeSegment.addSourceCode("where").space(1).addSourceCode(whereClauseType1);
                targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
            }
            codeSegment.unIndent(3).addSourceCode("%end;");
            codeSegment.newLine(1).addSourceCode("%else %do;");
            codeSegment.newLine(2).indent();
            codeSegment.genPercentPutStatement("No type 1 updates were made to target table.");
            codeSegment.newLine(1).unIndent(1);
            codeSegment.addSourceCode("%end;");
            codeSegment.newLine(1);
        }
        String selectList = codeSegment.makeColumnList(targetTable, true, "      ", usePassThru, ",", "", needsQuotes, "");
        String colList = codeSegment.makeColumnList(targetTable, false, "      ", usePassThru, ",", "", needsQuotes, "");
        codeSegment.addCommentLine("Insert new matching records");
        codeSegment.addSourceCode("%if &etls_matchcnt gt 0 %then");
        codeSegment.newLine(1);
        codeSegment.addSourceCode("%do;");
        codeSegment.newLine(2).indent();
        targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
        codeSegment.addSourceCode("insert into").space(1).addSourceCode(sTargetDSName);
        codeSegment.newLine(1).indent();
        codeSegment.addSourceCode("( ");
        codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("select ").addSourceCode(selectList).addSourceCode("\n").addSourceCode("from ");
        if (visualUploadLibrary != null && uploadSchema.length() > 0) {
            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
        }
        codeSegment.addSourceCode(strWorkMatch).unIndent();
        targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
        codeSegment.unIndent().addSourceCode("%end;");
        codeSegment.newLine(2);
        codeSegment.addCommentLine("Insert new dimension records");
        codeSegment.addSourceCode("%if &etls_newcnt gt 0 %then");
        codeSegment.newLine(1);
        codeSegment.addSourceCode("%do;");
        codeSegment.newLine(2).indent();
        targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
        codeSegment.addSourceCode("insert into").space(1).addSourceCode(sTargetDSName);
        codeSegment.newLine(1).indent();
        codeSegment.addSourceCode("( ");
        codeSegment.addSourceCode(colList).space(1).addSourceCode(")");
        codeSegment.newLine(2);
        codeSegment.addSourceCode("select").space(1).addSourceCode(selectList);
        codeSegment.newLine(1);
        codeSegment.addSourceCode("from").space(1);
        if (visualUploadLibrary != null && uploadSchema.length() > 0) {
            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
        }
        codeSegment.addSourceCode(strWorkNew).unIndent();
        targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
        codeSegment.unIndent().addSourceCode("%end;");
        codeSegment.newLine(1);
        codeSegment.addSourceCode("%else %do;");
        codeSegment.newLine(2).indent();
        codeSegment.genPercentPutStatement("No new dimension records were added to target table.");
        codeSegment.newLine(1).unIndent();
        codeSegment.addSourceCode("%end;");
        codeSegment.newLine(2);
        targetDBMSType.genExecuteCommit(codeSegment, targetTable, "");
        codeSegment.newLine(1);
        targetDBMSType.genDisconnect(codeSegment, targetTable);
        codeSegment.unIndent(1).addSourceCode("quit;");
        codeSegment.newLine(2);
        return codeSegment;
    }

    protected ICodeSegment cgUpdateVersionNumberNetezza(ICodeSegment codeSegment, boolean usePassThru, String strWorkType1, String strWorkMatch, String strWorkNew) throws MdException, RemoteException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServerException {
        boolean bUseConnectUsing;
        IPhysicalTable targetTable = (IPhysicalTable)this.getDataTargets()[0];
        String sTargetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment, usePassThru);
        IDBMSType targetDBMSType = targetTable.getDBMSType();
        String tgtTableAlias = targetTable.getTableName(codeSegment.isQuoting(), usePassThru);
        boolean needsQuotes = codeSegment.isQuoting();
        ILibrary visualUploadLibrary = this.getUploadLibrary();
        ILibrary library = targetTable.getCodeGenLibrary(codeSegment.getCurrentServer());
        ILibrary uploadLibrary = this.getRunTimeUploadLibrary(usePassThru, codeSegment, library);
        ArrayList<IColumn> keyColumns = new ArrayList<IColumn>();
        keyColumns.add(this.m_generatedKeyColumn);
        String uploadSchema = "";
        String srcTableAlias = strWorkType1;
        String tempCloseDate = "";
        String tempFromDate = "";
        String tempGenKey = "";
        String tempLoadTime = "";
        if (codeSegment.isQuoting()) {
            tempGenKey = DBMSNamesUtil.getQuotedString("ETLS_KEY", usePassThru);
            tempCloseDate = DBMSNamesUtil.getQuotedString("ETLS_CLSDATE", usePassThru);
            tempFromDate = DBMSNamesUtil.getQuotedString("ETLS_FROMDATE", usePassThru);
            tempLoadTime = DBMSNamesUtil.getQuotedString("ETLS_LOADTIME", usePassThru);
        } else {
            tempGenKey = "ETLS_KEY";
            tempCloseDate = "ETLS_CLSDATE";
            tempFromDate = "ETLS_FROMDATE";
            tempLoadTime = "ETLS_LOADTIME";
        }
        String sLoadTimeColumnName = "";
        if (this.getLoadTimeColumn() != null) {
            sLoadTimeColumnName = this.getLoadTimeColumn().getColumnName(codeSegment, usePassThru);
        }
        String sGeneratedKeyColumnName = "";
        boolean hasGeneratedKey = false;
        if (this.m_generatedKeyColumn != null) {
            hasGeneratedKey = true;
            sGeneratedKeyColumnName = this.m_generatedKeyColumn.getColumnName(codeSegment, usePassThru);
        }
        StringBuffer sbWhereClause = new StringBuffer();
        if (hasGeneratedKey) {
            sbWhereClause.append(srcTableAlias).append(".").append(tempGenKey).append(" = ");
            sbWhereClause.append(tgtTableAlias).append(".").append(sGeneratedKeyColumnName);
        } else {
            sbWhereClause.append(this.makeAnEqualJoinWhereClause(keyColumns, usePassThru, "      ", "", tgtTableAlias, codeSegment, false));
        }
        codeSegment.addSourceCode("proc sql").space(1).addSourceCode(this.getSQLOptions()).addSourceCode(";");
        codeSegment.newLine(1);
        codeSegment.addCommentLine("Update type 1 columns");
        if (visualUploadLibrary != null) {
            uploadSchema = uploadLibrary.getDatabaseSchema().getSchemaName();
            uploadSchema = DBMSNamesUtil.getQuotedName(uploadSchema, needsQuotes, needsQuotes, usePassThru);
        }
        if (bUseConnectUsing = this.isUseConnectUsingEnabled()) {
            codeSegment.addSourceCode("connect using " + uploadLibrary.getLibref() + " as " + uploadLibrary.getEngine() + ";\n");
        } else {
            codeSegment.addSourceCode("connect to").space(1).addSourceCode(uploadLibrary.getEngine());
            codeSegment.newLine(1);
            codeSegment.addSourceCode("(");
            codeSegment.newLine(1).indent(1);
            codeSegment.addSourceCode(uploadLibrary.getConnectionOptions());
            codeSegment.newLine(1).unIndent(1).addSourceCode(");");
            codeSegment.newLine(1);
        }
        StringBuffer whereClauseType1 = new StringBuffer();
        if (hasGeneratedKey) {
            whereClauseType1.append(srcTableAlias).append(".").append(tempGenKey).append(" = ");
            whereClauseType1.append(tgtTableAlias).append(".").append(sGeneratedKeyColumnName);
        }
        if (this.m_mlType1Columns != null && this.m_mlType1Columns.size() > 0) {
            codeSegment.addCommentLine("Update type 1 columns");
            codeSegment.addSourceCode("%if &etls_type1cnt gt 0 %then");
            codeSegment.newLine(1);
            codeSegment.addSourceCode("%do;").newLine(2).indent();
            for (int index = 0; index < this.m_mlType1Columns.size(); ++index) {
                IColumn column = (IColumn)this.m_mlType1Columns.get(index);
                String sColumnName = "";
                targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
                sColumnName = column.getColumnName(needsQuotes, true);
                codeSegment.indent(1).addSourceCode("update").space(1).addSourceCode(sTargetDSName).space(1).addSourceCode(tgtTableAlias);
                codeSegment.newLine(1).indent(1);
                codeSegment.addSourceCode("set").space(1);
                codeSegment.addSourceCode(tgtTableAlias).addSourceCode(".").addSourceCode(sColumnName);
                codeSegment.space(1).addSourceCode("=").space(1);
                codeSegment.addSourceCode(srcTableAlias).addSourceCode(".").addSourceCode(sColumnName);
                codeSegment.newLine(1);
                codeSegment.addSourceCode("from").space(1);
                if (visualUploadLibrary != null && uploadSchema.length() > 0) {
                    codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
                }
                codeSegment.addSourceCode(strWorkType1).space(1).addSourceCode(srcTableAlias);
                codeSegment.newLine(1);
                codeSegment.addSourceCode("where").space(1).addSourceCode(whereClauseType1);
                targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
            }
            codeSegment.unIndent(3).addSourceCode("%end;");
            codeSegment.newLine(1).addSourceCode("%else %do;");
            codeSegment.newLine(2).indent();
            codeSegment.genPercentPutStatement("No type 1 updates were made to target table.");
            codeSegment.newLine(1).unIndent(1);
            codeSegment.addSourceCode("%end;");
            codeSegment.newLine(1);
        }
        String selectList = codeSegment.makeColumnList(targetTable, true, "      ", usePassThru, ",", "", needsQuotes, "");
        String colList = codeSegment.makeColumnList(targetTable, false, "      ", usePassThru, ",", "", needsQuotes, "");
        codeSegment.addCommentLine("Insert new matching records");
        codeSegment.addSourceCode("%if &etls_matchcnt gt 0 %then");
        codeSegment.newLine(1);
        codeSegment.addSourceCode("%do;");
        codeSegment.newLine(2).indent();
        targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
        codeSegment.addSourceCode("insert into").space(1).addSourceCode(sTargetDSName);
        codeSegment.newLine(1).indent();
        codeSegment.addSourceCode("( ");
        codeSegment.addSourceCode(colList).addSourceCode(" )\n\n").addSourceCode("select ").addSourceCode(selectList).addSourceCode("\n").addSourceCode("from ");
        if (visualUploadLibrary != null && uploadSchema.length() > 0) {
            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
        }
        codeSegment.addSourceCode(strWorkMatch).unIndent();
        targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
        codeSegment.unIndent().addSourceCode("%end;");
        codeSegment.newLine(2);
        codeSegment.addCommentLine("Insert new dimension records");
        codeSegment.addSourceCode("%if &etls_newcnt gt 0 %then");
        codeSegment.newLine(1);
        codeSegment.addSourceCode("%do;");
        codeSegment.newLine(2).indent();
        targetDBMSType.genExecuteBegin(codeSegment, targetTable, "");
        codeSegment.addSourceCode("insert into").space(1).addSourceCode(sTargetDSName);
        codeSegment.newLine(1).indent();
        codeSegment.addSourceCode("( ");
        codeSegment.addSourceCode(colList).space(1).addSourceCode(")");
        codeSegment.newLine(2);
        codeSegment.addSourceCode("select").space(1).addSourceCode(selectList);
        codeSegment.newLine(1);
        codeSegment.addSourceCode("from").space(1);
        if (visualUploadLibrary != null && uploadSchema.length() > 0) {
            codeSegment.addSourceCode(uploadSchema).addSourceCode(".");
        }
        codeSegment.addSourceCode(strWorkNew).unIndent();
        targetDBMSType.genExecuteEnd(codeSegment, targetTable, "");
        codeSegment.unIndent().addSourceCode("%end;");
        codeSegment.newLine(1);
        codeSegment.addSourceCode("%else %do;");
        codeSegment.newLine(2).indent();
        codeSegment.genPercentPutStatement("No new dimension records were added to target table.");
        codeSegment.newLine(1).unIndent();
        codeSegment.addSourceCode("%end;");
        codeSegment.newLine(2);
        targetDBMSType.genExecuteCommit(codeSegment, targetTable, "");
        codeSegment.newLine(1);
        targetDBMSType.genDisconnect(codeSegment, targetTable);
        codeSegment.unIndent(1).addSourceCode("quit;");
        codeSegment.newLine(2);
        return codeSegment;
    }

    private class SetTrackChangesByVersionNumberUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetTrackChangesByVersionNumberUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setTrackChangesByVersionNumber(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setTrackChangesByVersionNumber(this.m_newValue);
        }
    }

    private class SetTrackChangesByCurrentIndicatorUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetTrackChangesByCurrentIndicatorUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setTrackChangesByCurrentIndicator(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setTrackChangesByCurrentIndicator(this.m_newValue);
        }
    }

    private class GenerateUniqueRetainedKeyUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public GenerateUniqueRetainedKeyUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setGenerateUniqueRetainedKey(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setGenerateUniqueRetainedKey(this.m_newValue);
        }
    }

    private class GenerateRetainedKeyUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public GenerateRetainedKeyUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setGenerateRetainedKeyImpl(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setGenerateRetainedKeyImpl(this.m_newValue);
        }
    }

    private class SetUpdateTableWithMaxKeyUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetUpdateTableWithMaxKeyUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setUpdateTableWithMaxKey(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setUpdateTableWithMaxKey(this.m_newValue);
        }
    }

    private class SetNextKeyValueInGenKeyUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetNextKeyValueInGenKeyUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setNextKeyValueInGenKey(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setNextKeyValueInGenKey(this.m_newValue);
        }
    }

    private class SetMaxKeyColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldColumn;
        private IColumn m_newColumn;

        public SetMaxKeyColumnUndoable(IColumn oldColumn, IColumn newColumn) {
            this.m_oldColumn = oldColumn;
            this.m_newColumn = newColumn;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setMaxKeyColumn(this.m_oldColumn);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setMaxKeyColumn(this.m_newColumn);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldColumn = null;
            this.m_newColumn = null;
        }
    }

    private class SetGenerateMaxKeyCodeUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldValue;
        private boolean m_newValue;

        public SetGenerateMaxKeyCodeUndoable(boolean oldValue, boolean newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setGenerateMaxKeyCode(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setGenerateMaxKeyCode(this.m_newValue);
        }
    }

    private class SetMaxKeyRowSelectorExpressionUndoable
    extends AbstractUndoableEdit {
        private ITextExpression m_oldValue;
        private ITextExpression m_newValue;

        public SetMaxKeyRowSelectorExpressionUndoable(ITextExpression oldValue, ITextExpression newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setMaxKeyRowSelectorExpression(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setMaxKeyRowSelectorExpression(this.m_newValue);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldValue = null;
            this.m_newValue = null;
        }
    }

    private class SetNewRecordGenKeyExpressionUndoable
    extends AbstractUndoableEdit {
        private ITextExpression m_oldValue;
        private ITextExpression m_newValue;

        public SetNewRecordGenKeyExpressionUndoable(ITextExpression oldValue, ITextExpression newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setNewRecordGenKeyExpression(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setNewRecordGenKeyExpression(this.m_newValue);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldValue = null;
            this.m_newValue = null;
        }
    }

    private class SetChangedRecordGenKeyExpressionUndoable
    extends AbstractUndoableEdit {
        private ITextExpression m_oldValue;
        private ITextExpression m_newValue;

        public SetChangedRecordGenKeyExpressionUndoable(ITextExpression oldValue, ITextExpression newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setChangedRecordGenKeyExpression(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setChangedRecordGenKeyExpression(this.m_newValue);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldValue = null;
            this.m_newValue = null;
        }
    }

    private class SetVersionColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldColumn;
        private IColumn m_newColumn;

        public SetVersionColumnUndoable(IColumn oldColumn, IColumn newColumn) {
            this.m_oldColumn = oldColumn;
            this.m_newColumn = newColumn;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setVersionColumn(this.m_oldColumn);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setVersionColumn(this.m_newColumn);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldColumn = null;
            this.m_newColumn = null;
        }
    }

    private class SetGeneratedKeyColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldColumn;
        private IColumn m_newColumn;

        public SetGeneratedKeyColumnUndoable(IColumn oldColumn, IColumn newColumn) {
            this.m_oldColumn = oldColumn;
            this.m_newColumn = newColumn;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setGenerateKeyColumnImpl(this.m_oldColumn);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setGenerateKeyColumnImpl(this.m_newColumn);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldColumn = null;
            this.m_newColumn = null;
        }
    }

    private class SetCurrentIndicatorColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldColumn;
        private IColumn m_newColumn;

        public SetCurrentIndicatorColumnUndoable(IColumn oldColumn, IColumn newColumn) {
            this.m_oldColumn = oldColumn;
            this.m_newColumn = newColumn;
        }

        @Override
        public void undo() {
            super.undo();
            SCDType2TransformModel.this.setCurrentIndicatorColumn(this.m_oldColumn);
        }

        @Override
        public void redo() {
            super.redo();
            SCDType2TransformModel.this.setCurrentIndicatorColumn(this.m_newColumn);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldColumn = null;
            this.m_newColumn = null;
        }
    }
}

