/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.rank;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ISortingTransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.etl.models.job.transforms.common.ISorting;
import com.sas.etl.models.job.transforms.rank.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class RankTransformModel
extends AbstractDataTransform
implements ISortingTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.SASRank";
    private static final String TRANSFORMATION_ROLE = "com.sas.wadmin.transforms.sasran";
    private static final String ARM_DISPLAY_NAME = "Rank";
    public static final String PROCRANK = "PROCRANK";
    private static final String PROPERTY_NAME_DESCENDING = "Descending";
    private static final String PROPERTY_NAME_BYSTATEMENTOPTION = "ByStatementOption";
    private static final String PROPERTY_NAME_TIES = "Ties";
    private static final String PROPERTY_NAME_PROCRANKOPTIONS = "ProcRankOptions";
    private static final String PROPERTY_NAME_FRACTION = "Fraction";
    private static final String PROPERTY_NAME_GROUPS = "Groups";
    private static final String PROPERTY_NAME_NORMAL = "Normal";
    private static final String PROPERTY_NAME_NPLUS1 = "Nplus1";
    private static final String PROPERTY_NAME_PERCENT = "Percent";
    private static final String PROPERTY_NAME_SAVAGE = "Savage";
    public static final String DEFAULT_DESCENDING = "Default (no DESCENDING)";
    public static final String DEFAULT_BYSTATEMENTOPTION = "Default (NOTSORTED)";
    public static final String BY_STATEMENT_SORT_SORTED = "SORTED";
    public static final String BY_STATEMENT_SORT_NOTSORTED = "NOTSORTED";
    public static final String DEFAULT_TIES = "Default (MEAN)";
    public static final String COMPUTE_TIE_VALUE_LOW = "LOW";
    public static final String COMPUTE_TIE_VALUE_HIGH = "HIGH";
    private static final String DEFAULT_PROCRANKOPTIONS = "";
    public static final String DEFAULT_FRACTION = "Default (no Fraction)";
    public static final String COMPUTE_FRACTIONAL_FRACTION = "Fraction";
    private static final String DEFAULT_GROUPS = "";
    public static final String DEFAULT_NORMAL = "Default(no Normal)";
    public static final String COMPUTE_NORMAL_SCORE_BLOM = "BLOM";
    public static final String COMPUTE_NORMAL_SCORE_TUKEY = "TUKEY";
    public static final String COMPUTE_NORMAL_SCORE_VW = "VW";
    public static final String DEFAULT_NPLUS1 = "Default (no NPLUS1)";
    public static final String COMPUTE_NPLUS1_NPLUS1 = "NPLUS1";
    public static final String DEFAULT_PERCENT = "Default (no Percent)";
    public static final String CALCULATE_PERCENTAGE_PERCENT = "Percent";
    public static final String DEFAULT_SAVAGE = "Default (no Savage)";
    public static final String COMPUTE_SAVAGE_SCORE_SAVAGE = "Savage";
    public static final String EVENT_PROCRANKOPTIONS_PROPERTY_CHANGED = "RankTransform:ProcRankOptionsChanged";
    public static final String EVENT_BYSTATEMENTOPTION_PROPERTY_CHANGED = "RankTransform:ByStatementChanged";
    public static final String EVENT_FRACTION_PROPERTY_CHANGED = "RankTransform:ComputeFractionalChanged";
    public static final String EVENT_NPLUS1_PROPERTY_CHANGED = "RankTransform:ComputeNPlus1Changed";
    public static final String EVENT_DESCENDING_PROPERTY_CHANGED = "RankTransform:RankDirectionChanged";
    public static final String EVENT_TIE_PROPERTY_CHANGED = "RankTransform:ComputeTiesChanged";
    public static final String EVENT_GROUPS_PROPERTY_CHANGED = "RankTransform:AssignGroupsChanged";
    public static final String EVENT_SAVAGE_PROPERTY_CHANGED = "RankTransform:ComputeSavageChanged";
    public static final String EVENT_NORMAL_PROPERTY_CHANGED = "RankTransform:ComputeNormalScoreChanged";
    public static final String EVENT_PERCENT_PROPERTY_CHANGED = "RankTransform:CalculatePercentageChanged";
    private ISorting m_order;
    private String m_sDescending = "Default (no DESCENDING)";
    private String m_sByStatementOption = "Default (NOTSORTED)";
    private String m_sTies = "Default (MEAN)";
    private String m_sProcRankOptions = "";
    private String m_sFraction = "Default (no Fraction)";
    private String m_sGroups = "";
    private String m_sNormal = "Default(no Normal)";
    private String m_sNPlus1 = "Default (no NPLUS1)";
    private String m_sPercent = "Default (no Percent)";
    private String m_sSavage = "Default (no Savage)";

    public RankTransformModel(String sID, IModel model) {
        super(sID, model);
        if (this.isNew()) {
            this.m_order = this.getModel().getObjectFactory().createNewSorting(this.getID());
            this.m_order.addNotifyListener(this);
        }
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("RankTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("RankTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMapping addRankMapping(IColumn varColumn, IColumn rankColumn) {
        this.startCompoundUndoable();
        try {
            IMapping mapping = this.getObjectFactory().createNewMapping(this.getID());
            mapping.setName("FeatureMap for " + varColumn.getName());
            mapping.setType(PROCRANK);
            mapping.addSource(varColumn);
            mapping.addTarget(rankColumn);
            this.addMapping(mapping);
            IMapping iMapping = mapping;
            return iMapping;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRankMappings() {
        this.startCompoundUndoable();
        try {
            IMapping[] aMappings = this.getRankMappings();
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                IMapping mapping = aMappings[iMapping];
                this.removeMapping(mapping);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public void removeRankMapping(IColumn varColumn, IColumn rankColumn) {
        IMapping[] aMappings = this.getRankMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            IMapping mapping = aMappings[iMapping];
            if (mapping.getSourceCount() == 0 || mapping.getTargetCount() == 0) {
                return;
            }
            IColumn[] sourceColumns = mapping.getSources();
            IColumn[] targetColumns = mapping.getTargets();
            if (sourceColumns.length <= 0 || targetColumns.length <= 0 || !sourceColumns[0].equals(varColumn) || !targetColumns[0].equals(rankColumn)) continue;
            this.removeMapping(mapping);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustRankMappingToNewSourceTable(ITable table) {
        this.startCompoundUndoable();
        try {
            IMapping[] aMappings = this.getRankMappings();
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                IMapping mapping = aMappings[iMapping];
                IColumn[] sourceColumns = mapping.getSources();
                IColumn sourceColumn = sourceColumns[0];
                IColumn[] newColumns = table.getColumns();
                boolean bColumnExists = false;
                for (int i = 0; i < newColumns.length; ++i) {
                    if (!sourceColumn.getColumnName(true).equals(newColumns[i].getColumnName(true)) || sourceColumn.getType() != newColumns[i].getType()) continue;
                    bColumnExists = true;
                }
                if (bColumnExists) continue;
                this.removeMapping(mapping);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustRankMappingToNewTargetTable(ITable table) {
        this.startCompoundUndoable();
        try {
            IMapping[] aMappings = this.getRankMappings();
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                IMapping mapping = aMappings[iMapping];
                IColumn[] targetColumns = mapping.getTargets();
                IColumn targetColumn = targetColumns[0];
                IColumn[] newColumns = table.getColumns();
                boolean bColumnExists = false;
                for (int i = 0; i < newColumns.length; ++i) {
                    if (!targetColumn.getColumnName(true).equals(newColumns[i].getColumnName(true)) || targetColumn.getType() != newColumns[i].getType()) continue;
                    bColumnExists = true;
                }
                if (bColumnExists) continue;
                this.removeMapping(mapping);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addDefaultSettings() {
        this.addNewWorkTable();
    }

    public IMapping[] getRankMappings() {
        ArrayList<IMapping> lRankMappings = new ArrayList<IMapping>();
        IMapping[] aMappings = this.getMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            IMapping mapping = aMappings[iMapping];
            if (mapping.getType().compareTo(PROCRANK) != 0) continue;
            lRankMappings.add(mapping);
        }
        return lRankMappings.toArray(new IMapping[lRankMappings.size()]);
    }

    @Override
    public ISorting getSortOrder() {
        return this.m_order;
    }

    public void setSortOrder(ISorting sortOrder) {
        if (this.m_order == sortOrder) {
            return;
        }
        if (this.m_order != null) {
            this.addToDeletedObjects(this.m_order);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SortOrderUndoable(this.m_order, sortOrder));
        }
        this.m_order = sortOrder;
        if (this.m_order != null) {
            this.removeFromDeletedObjects(this.m_order);
        }
        this.fireModelChangedEvent("ISortingTransform:SortOrderChanged", sortOrder);
    }

    public IColumn[] getSourceNumericColumns() {
        ITable inputTable;
        ArrayList<IColumn> lSelectedColumns = new ArrayList<IColumn>();
        IDataObject[] aSources = this.getDataSources();
        if (aSources.length > 0 && (inputTable = (ITable)aSources[0]) != null) {
            IColumn[] aColumns = inputTable.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                if (aColumns[iColumn].getType() != 1) continue;
                lSelectedColumns.add(aColumns[iColumn]);
            }
        }
        return lSelectedColumns.toArray(new IColumn[lSelectedColumns.size()]);
    }

    public IColumn[] getTargetNumericColumns() {
        ITable inputTable;
        ArrayList<IColumn> lSelectedColumns = new ArrayList<IColumn>();
        IDataObject[] aTargets = this.getDataTargets();
        if (aTargets.length > 0 && (inputTable = (ITable)aTargets[0]) != null) {
            IColumn[] aColumns = inputTable.getColumns();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                if (aColumns[iColumn].getType() != 1) continue;
                lSelectedColumns.add(aColumns[iColumn]);
            }
        }
        return lSelectedColumns.toArray(new IColumn[lSelectedColumns.size()]);
    }

    public IColumn[] getSelectedVarNumericColumns() {
        ArrayList<IColumn> lSelectedColumns = new ArrayList<IColumn>();
        IMapping[] aMappings = this.getRankMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            IMapping mapping = aMappings[iMapping];
            IColumn[] aVarColumns = mapping.getSources();
            if (aVarColumns.length <= 0) continue;
            lSelectedColumns.add(aVarColumns[0]);
        }
        return lSelectedColumns.toArray(new IColumn[lSelectedColumns.size()]);
    }

    public IColumn[] getSelectedRankNumericColumns() {
        ArrayList<IColumn> lSelectedColumns = new ArrayList<IColumn>();
        IMapping[] aMappings = this.getRankMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            IMapping mapping = aMappings[iMapping];
            IColumn[] aVarColumns = mapping.getTargets();
            if (aVarColumns.length <= 0) continue;
            lSelectedColumns.add(aVarColumns[0]);
        }
        return lSelectedColumns.toArray(new IColumn[lSelectedColumns.size()]);
    }

    @Override
    protected String getClassifierMapType() {
        return "Select";
    }

    @Override
    protected void preRemoveDataSource(IDataObject source) {
        ISorting oISorting = this.getSortOrder();
        ISortColumn[] sortColumns = oISorting.getSortColumns();
        List<IColumn> sourceColumns = Arrays.asList(((ITable)source).getColumns());
        for (int i = 0; i < sortColumns.length; ++i) {
            IColumn column = sortColumns[i].getColumn();
            if (!sourceColumns.contains(column)) continue;
            oISorting.removeSortColumn(sortColumns[i]);
        }
        IMapping[] mappings = this.getRankMappings();
        for (int i = 0; i < mappings.length; ++i) {
            boolean done = false;
            IColumn[] mappingColumns = mappings[i].getSources();
            for (int j = 0; j < mappingColumns.length && !done; ++j) {
                if (!sourceColumns.contains(mappingColumns[j])) continue;
                this.removeMapping(mappings[i]);
                done = true;
            }
        }
        super.preRemoveDataSource(source);
    }

    @Override
    protected void preRemoveDataTarget(IDataObject target) {
        List<IColumn> targetColumns = Arrays.asList(((ITable)target).getColumns());
        IMapping[] mappings = this.getRankMappings();
        for (int i = 0; i < mappings.length; ++i) {
            boolean done = false;
            IColumn[] mappingColumns = mappings[i].getTargets();
            for (int j = 0; j < mappingColumns.length && !done; ++j) {
                if (!targetColumns.contains(mappingColumns[j])) continue;
                this.removeMapping(mappings[i]);
                done = true;
            }
        }
        super.preRemoveDataTarget(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            this.getSortOrder().replaceSortColumns(oldTable, newTable);
            this.adjustRankMappingToNewSourceTable(newTable);
            super.replaceSourceTable(oldTable, newTable, columnsMap);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            this.adjustRankMappingToNewTargetTable(newTable);
            super.replaceTargetTable(oldTable, newTable, columnsMap);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setByStatement(this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_BYSTATEMENTOPTION, DEFAULT_BYSTATEMENTOPTION, 2));
        this.setRankDirection(this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_DESCENDING, DEFAULT_DESCENDING, 2));
        this.setComputeFractional(this.loadPropertyFromOMR(omr, "OPTIONS", "Fraction", DEFAULT_FRACTION, 2));
        this.setAssignGroups(this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_GROUPS, "", 2));
        this.setComputeNormalScore(this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_NORMAL, DEFAULT_NORMAL, 2));
        this.setComputeNPlus1(this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_NPLUS1, DEFAULT_NPLUS1, 2));
        this.setCalculatePercentage(this.loadPropertyFromOMR(omr, "OPTIONS", "Percent", DEFAULT_PERCENT, 2));
        this.setComputeSavage(this.loadPropertyFromOMR(omr, "OPTIONS", "Savage", DEFAULT_SAVAGE, 2));
        this.setComputeTie(this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_TIES, DEFAULT_TIES, 2));
        this.setProcRankOptions(this.loadPropertyFromOMR(omr, "OPTIONS", PROPERTY_NAME_PROCRANKOPTIONS, "", 2));
        Select mdoSelect = (Select)this.getClassifierMapObject(omr);
        OrderByClause mdoOrder = mdoSelect.getOrderByForSelect();
        ISorting sortOrder = null;
        if (mdoOrder != null) {
            sortOrder = (ISorting)omr.acquireObject((Root)mdoOrder);
        }
        this.setSortOrder(sortOrder);
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_BYSTATEMENTOPTION, PROPERTY_NAME_BYSTATEMENTOPTION, PROPERTY_NAME_BYSTATEMENTOPTION, this.getByStatement(), 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_DESCENDING, PROPERTY_NAME_DESCENDING, PROPERTY_NAME_DESCENDING, this.getRankDirection(), 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", "Fraction", "Fraction", "Fraction", this.getComputeFractional(), 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_GROUPS, PROPERTY_NAME_GROUPS, PROPERTY_NAME_GROUPS, this.getAssignGroups(), 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_NORMAL, PROPERTY_NAME_NORMAL, PROPERTY_NAME_NORMAL, this.getComputeNormalScore(), 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_NPLUS1, PROPERTY_NAME_NPLUS1, PROPERTY_NAME_NPLUS1, this.getComputeNPlus1(), 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", "Percent", "Percent", "Percent", this.getCalculatePercentage(), 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", "Savage", "Savage", "Savage", this.getComputeSavage(), 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_TIES, PROPERTY_NAME_TIES, PROPERTY_NAME_TIES, this.getComputeTie(), 12, 2);
        this.savePropertyToOMR(omr, "OPTIONS", PROPERTY_NAME_PROCRANKOPTIONS, PROPERTY_NAME_PROCRANKOPTIONS, PROPERTY_NAME_PROCRANKOPTIONS, this.getProcRankOptions(), 12, 2);
        Select mdoSelect = (Select)this.getClassifierMapObject(omr);
        ISorting sortOrder = this.getSortOrder();
        if (sortOrder != null) {
            sortOrder.saveToOMR(omr);
            OrderByClause mdoOrder = (OrderByClause)omr.acquireOMRObject(sortOrder);
            mdoSelect.setOrderByForSelect(mdoOrder);
        } else {
            mdoSelect.getOrderByForSelects().clear();
        }
        this.setChanged(false);
    }

    public String getRankDirection() {
        return this.m_sDescending;
    }

    public String getProcRankOptions() {
        return this.m_sProcRankOptions;
    }

    public String getAllOptionsForCodegen() {
        StringBuffer sbOptions = new StringBuffer();
        if (this.getRankDirection().trim().length() > 0 && this.getRankDirection().compareToIgnoreCase(DEFAULT_DESCENDING) != 0) {
            sbOptions.append(this.getRankDirection());
            sbOptions.append(" ");
        }
        if (this.getComputeFractional().trim().length() > 0 && this.getComputeFractional().compareToIgnoreCase(DEFAULT_FRACTION) != 0) {
            sbOptions.append(this.getComputeFractional());
            sbOptions.append(" ");
        }
        if (this.getComputeNPlus1().trim().length() > 0 && this.getComputeNPlus1().compareToIgnoreCase(DEFAULT_NPLUS1) != 0) {
            sbOptions.append(this.getComputeNPlus1());
            sbOptions.append(" ");
        }
        if (this.getCalculatePercentage().trim().length() > 0 && this.getCalculatePercentage().compareToIgnoreCase(DEFAULT_PERCENT) != 0) {
            sbOptions.append(this.getCalculatePercentage());
            sbOptions.append(" ");
        }
        if (this.getComputeSavage().trim().length() > 0 && this.getComputeSavage().compareToIgnoreCase(DEFAULT_SAVAGE) != 0) {
            sbOptions.append(this.getComputeSavage());
            sbOptions.append(" ");
        }
        if (this.getComputeTie().trim().length() > 0) {
            if (this.getComputeTie().compareToIgnoreCase(DEFAULT_TIES) != 0) {
                sbOptions.append("\nTies=");
                sbOptions.append(this.getComputeTie());
                sbOptions.append(" ");
            } else {
                sbOptions.append("\nTies=MEAN");
            }
        }
        if (this.getAssignGroups().trim().length() > 0) {
            sbOptions.append("\nGroups=");
            sbOptions.append(this.getAssignGroups());
            sbOptions.append(" ");
        }
        if (this.getProcRankOptions().trim().length() > 0) {
            sbOptions.append("\n");
            sbOptions.append(this.getProcRankOptions());
            sbOptions.append(" ");
        }
        if (this.getComputeNormalScore().trim().length() > 0 && this.getComputeNormalScore().compareToIgnoreCase(DEFAULT_NORMAL) != 0) {
            sbOptions.append("\nNormal=");
            sbOptions.append(this.getComputeNormalScore());
            sbOptions.append(" ");
        }
        if (sbOptions.toString().length() > 0) {
            sbOptions.append("\n");
        }
        return sbOptions.toString();
    }

    public void setAssignGroups(String sGroupValue) {
        if (this.m_sGroups.equals(sGroupValue)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAssignGroupsUndoable(this.m_sGroups, sGroupValue));
        }
        this.m_sGroups = sGroupValue;
        this.fireModelChangedEvent(EVENT_GROUPS_PROPERTY_CHANGED, null);
    }

    public void setProcRankOptions(String sOptions) {
        if (this.m_sProcRankOptions.equals(sOptions)) {
            return;
        }
        if (sOptions == null) {
            throw new NullPointerException("Rank options must not be null");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetProcRankOptionsUndoable(this.m_sProcRankOptions, sOptions));
        }
        this.m_sProcRankOptions = sOptions;
        this.fireModelChangedEvent(EVENT_PROCRANKOPTIONS_PROPERTY_CHANGED, null);
    }

    public String getAssignGroups() {
        return this.m_sGroups;
    }

    public void setRankDirection(String sDirection) {
        if (this.m_sDescending.compareToIgnoreCase(sDirection) == 0) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRankDirectionUndoable(this.m_sDescending, sDirection));
        }
        this.m_sDescending = sDirection;
        this.fireModelChangedEvent(EVENT_DESCENDING_PROPERTY_CHANGED, null);
    }

    public String getComputeFractional() {
        return this.m_sFraction;
    }

    public void setComputeFractional(String sFractional) {
        if (this.m_sFraction.equals(sFractional)) {
            return;
        }
        if (!sFractional.equals(DEFAULT_FRACTION) && !sFractional.equals("Fraction")) {
            throw new IllegalArgumentException("Compute Fractional was not fraction or no fraction");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetComputeFractionalUndoable(this.m_sFraction, sFractional));
        }
        this.m_sFraction = sFractional;
        this.fireModelChangedEvent(EVENT_FRACTION_PROPERTY_CHANGED, null);
    }

    public String getComputeNormalScore() {
        return this.m_sNormal;
    }

    public void setComputeNormalScore(String sNormalScore) {
        if (this.m_sNormal.equals(sNormalScore)) {
            return;
        }
        if (!(sNormalScore.equals(COMPUTE_NORMAL_SCORE_BLOM) || sNormalScore.equals(DEFAULT_NORMAL) || sNormalScore.equals(COMPUTE_NORMAL_SCORE_TUKEY) || sNormalScore.equals(COMPUTE_NORMAL_SCORE_VW))) {
            throw new IllegalArgumentException("Compute Normal Score was not valid");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetComputeNormalScoreUndoable(this.m_sNormal, sNormalScore));
        }
        this.m_sNormal = sNormalScore;
        this.fireModelChangedEvent(EVENT_NORMAL_PROPERTY_CHANGED, null);
    }

    public String getComputeNPlus1() {
        return this.m_sNPlus1;
    }

    public void setComputeNPlus1(String sNPlus1) {
        if (this.m_sNPlus1.equals(sNPlus1)) {
            return;
        }
        if (!sNPlus1.equals(DEFAULT_NPLUS1) && !sNPlus1.equals(COMPUTE_NPLUS1_NPLUS1)) {
            throw new IllegalArgumentException("Compute N Plus1 was not valid");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetComputeNPlus1Undoable(this.m_sNPlus1, sNPlus1));
        }
        this.m_sNPlus1 = sNPlus1;
        this.fireModelChangedEvent(EVENT_NPLUS1_PROPERTY_CHANGED, null);
    }

    public String getCalculatePercentage() {
        return this.m_sPercent;
    }

    public void setCalculatePercentage(String sPercentage) {
        if (this.m_sPercent.equals(sPercentage)) {
            return;
        }
        if (!sPercentage.equals(DEFAULT_PERCENT) && !sPercentage.equals("Percent")) {
            throw new IllegalArgumentException("Calculate percentage value invalid");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCalculatePercentageUndoable(this.m_sPercent, sPercentage));
        }
        this.m_sPercent = sPercentage;
        this.fireModelChangedEvent(EVENT_PERCENT_PROPERTY_CHANGED, null);
    }

    public String getComputeSavage() {
        return this.m_sSavage;
    }

    public void setComputeSavage(String sSavage) {
        if (this.m_sSavage.equals(sSavage)) {
            return;
        }
        if (!sSavage.equals(DEFAULT_SAVAGE) && !sSavage.equals("Savage")) {
            throw new IllegalArgumentException("Compute Savage was not valid");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetComputeSavageUndoable(this.m_sSavage, sSavage));
        }
        this.m_sSavage = sSavage;
        this.fireModelChangedEvent(EVENT_SAVAGE_PROPERTY_CHANGED, null);
    }

    public String getComputeTie() {
        return this.m_sTies;
    }

    public void setComputeTie(String sTie) {
        if (this.m_sTies.equals(sTie)) {
            return;
        }
        if (!(sTie.equals(COMPUTE_TIE_VALUE_LOW) || sTie.equals(COMPUTE_TIE_VALUE_HIGH) || sTie.equals(DEFAULT_TIES))) {
            throw new IllegalArgumentException("Compute tie was not valid");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetComputeTieUndoable(this.m_sTies, sTie));
        }
        this.m_sTies = sTie;
        this.fireModelChangedEvent(EVENT_TIE_PROPERTY_CHANGED, null);
    }

    public String getByStatement() {
        return this.m_sByStatementOption;
    }

    public void setByStatement(String sStatementSorted) {
        if (this.m_sByStatementOption.equals(sStatementSorted)) {
            return;
        }
        if (!sStatementSorted.equals(DEFAULT_BYSTATEMENTOPTION) && !sStatementSorted.equals(BY_STATEMENT_SORT_SORTED)) {
            throw new IllegalArgumentException("By Statement value invalid");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetByStatementUndoable(this.m_sByStatementOption, sStatementSorted));
        }
        this.m_sByStatementOption = sStatementSorted;
        this.fireModelChangedEvent(EVENT_BYSTATEMENTOPTION_PROPERTY_CHANGED, null);
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_order.isChanged();
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IColumn[] aIColumns;
        super.getGeneratedCode(codeSegment);
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        this.genTableDelete(codeSegment, target);
        ITransformTableOptions sourceTableOptions = this.getTableOptionObject(source, true);
        boolean mappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), source, target);
        String mappingStepOutputName = null;
        if (mappingNeeded) {
            ArrayList<IColumn> byVarColumns = new ArrayList<IColumn>(Arrays.asList(this.getSelectedVarNumericColumns()));
            byVarColumns.addAll(Arrays.asList(this.m_order.getColumnObjects()));
            Iterator iterator = byVarColumns.iterator();
            while (iterator.hasNext()) {
                IColumn byVarColumn = (IColumn)iterator.next();
                IMapping[] mappings = this.getOrdinaryMappingsForSourceColumn(byVarColumn);
                for (int iMapping = 0; iMapping < mappings.length; ++iMapping) {
                    IMapping mapping = mappings[iMapping];
                    if (!"ONETOONE".equals(mapping.getType()) || mapping.isMappingRename(codeSegment.isQuoting(), source)) continue;
                    iterator.remove();
                }
            }
            ArrayList<IColumn> lRankColumns = new ArrayList<IColumn>(Arrays.asList(this.getSelectedRankNumericColumns()));
            IColumn[] aIMappedTargetCols = this.getOrdinaryMappedTargetColumns(null);
            Iterator iterator2 = lRankColumns.iterator();
            while (iterator2.hasNext()) {
                IColumn rankedColumn = (IColumn)iterator2.next();
                for (int iMapped = 0; iMapped < aIMappedTargetCols.length; ++iMapped) {
                    if (rankedColumn.getID().compareToIgnoreCase(aIMappedTargetCols[iMapped].getID()) != 0) continue;
                    iterator2.remove();
                }
            }
            mappingStepOutputName = codeSegment.getUniqueWorkTableName(true, 0);
            this.getOrdinaryMappingCode(codeSegment, source, target, mappingStepOutputName, "&SYSLAST", sourceTableOptions.getTableOptions(codeSegment.getCurrentServer()), null, true, true, true, byVarColumns.toArray(new IColumn[byVarColumns.size()]), lRankColumns.toArray(new IColumn[lRankColumns.size()]), false, null, null, null);
        }
        codeSegment.addSourceCode("proc rank data = ");
        codeSegment.addSourceCode(mappingNeeded ? mappingStepOutputName : source.getFullNameQuotedAsNeeded(codeSegment));
        codeSegment.addSourceCode(" \n");
        codeSegment.indent();
        if (!mappingNeeded && sourceTableOptions.getTableOptions(codeSegment.getCurrentServer()).length() > 0) {
            codeSegment.indent().addSourceCode("(" + sourceTableOptions.getTableOptions(codeSegment.getCurrentServer()) + ") \n").unIndent();
        }
        codeSegment.addSourceCode("out = " + target.getFullNameQuotedAsNeeded(codeSegment));
        ITransformTableOptions targetTableOptions = this.getTableOptionObject(target, false);
        if (targetTableOptions.getTableOptions(codeSegment.getCurrentServer()).length() > 0) {
            codeSegment.addSourceCode("\n").indent().addSourceCode(targetTableOptions.getTableOptions(true, codeSegment.getCurrentServer())).unIndent();
        }
        if (this.getAllOptionsForCodegen().trim().length() > 0) {
            codeSegment.addSourceCode("\n").indent().addSourceCode(this.getAllOptionsForCodegen().trim()).unIndent();
        }
        codeSegment.addSourceCode("; \n");
        if (this.getByStatement().compareToIgnoreCase(DEFAULT_BYSTATEMENTOPTION) == 0) {
            this.m_order.setNotSorted(BY_STATEMENT_SORT_NOTSORTED);
        } else {
            this.m_order.setNotSorted("");
        }
        this.m_order.getGeneratedCode(codeSegment, false);
        if (this.getSelectedVarNumericColumns().length > 0) {
            codeSegment.indent();
            codeSegment.addSourceCode("var ");
            aIColumns = this.getSelectedVarNumericColumns();
            codeSegment.addSourceCode(codeSegment.makeColumnList(aIColumns, "   ", codeSegment.isQuoting(), " "));
            codeSegment.addSourceCode("; \n");
            codeSegment.unIndent();
        }
        if (this.getSelectedRankNumericColumns().length > 0) {
            codeSegment.indent();
            codeSegment.addSourceCode("ranks ");
            aIColumns = this.getSelectedRankNumericColumns();
            codeSegment.addSourceCode(codeSegment.makeColumnList(aIColumns, "   ", codeSegment.isQuoting(), " "));
            codeSegment.addSourceCode("; \n");
            codeSegment.unIndent();
        }
        codeSegment.unIndent().addSourceCode("run; \n\n").genRCSetCall("&syserr");
        if (mappingNeeded && !target.isView()) {
            codeSegment.genTableDelete(mappingStepOutputName);
        }
        return codeSegment;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new RankPromptModel(this);
    }

    private class RankPromptModel
    extends BaseDataTransformPromptModel {
        public RankPromptModel(RankTransformModel model) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model.getModel(), model);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(RankPromptModel.class.getResource("res/Options_SASRank_Template.xml"));
            PromptGroupInterface result = this.combinePromptGroups(grp1, grp);
            return result;
        }

        @Override
        protected IModelListener createModelListener() {
            return new RankModelListener(this.getOwner(), this);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            this.setOptionValue(RankTransformModel.PROPERTY_NAME_DESCENDING, (Object)((RankTransformModel)this.getOwner()).getRankDirection());
            this.setOptionValue(RankTransformModel.PROPERTY_NAME_BYSTATEMENTOPTION, (Object)((RankTransformModel)this.getOwner()).getByStatement());
            this.setOptionValue(RankTransformModel.PROPERTY_NAME_TIES, (Object)((RankTransformModel)this.getOwner()).getComputeTie());
            this.setOptionValue(RankTransformModel.PROPERTY_NAME_PROCRANKOPTIONS, (Object)((RankTransformModel)this.getOwner()).getProcRankOptions());
            this.setOptionValue("Fraction", (Object)((RankTransformModel)this.getOwner()).getComputeFractional());
            this.setOptionValue(RankTransformModel.PROPERTY_NAME_GROUPS, (Object)((RankTransformModel)this.getOwner()).getAssignGroups());
            this.setOptionValue(RankTransformModel.PROPERTY_NAME_NORMAL, (Object)((RankTransformModel)this.getOwner()).getComputeNormalScore());
            this.setOptionValue(RankTransformModel.PROPERTY_NAME_NPLUS1, (Object)((RankTransformModel)this.getOwner()).getComputeNPlus1());
            this.setOptionValue("Percent", (Object)((RankTransformModel)this.getOwner()).getCalculatePercentage());
            this.setOptionValue("Savage", (Object)((RankTransformModel)this.getOwner()).getComputeSavage());
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new RankValueChangeListener((RankTransformModel)this.getOwner(), this);
        }

        private class RankModelListener
        extends BaseDataTransformModelListener {
            public RankModelListener(IObject object, IPromptModel promptModel) {
                super(object, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                String type = ev.getType();
                this.getPromptModel().setListeningForChanges(false);
                try {
                    if (RankTransformModel.EVENT_PROCRANKOPTIONS_PROPERTY_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(RankTransformModel.PROPERTY_NAME_PROCRANKOPTIONS, (Object)RankTransformModel.this.getProcRankOptions());
                    } else if (RankTransformModel.EVENT_BYSTATEMENTOPTION_PROPERTY_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(RankTransformModel.PROPERTY_NAME_BYSTATEMENTOPTION, (Object)RankTransformModel.this.getByStatement());
                    } else if (RankTransformModel.EVENT_FRACTION_PROPERTY_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue("Fraction", (Object)RankTransformModel.this.getComputeFractional());
                    } else if (RankTransformModel.EVENT_NPLUS1_PROPERTY_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(RankTransformModel.PROPERTY_NAME_NPLUS1, (Object)RankTransformModel.this.getComputeNPlus1());
                    } else if (RankTransformModel.EVENT_DESCENDING_PROPERTY_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(RankTransformModel.PROPERTY_NAME_DESCENDING, (Object)RankTransformModel.this.getRankDirection());
                    } else if (RankTransformModel.EVENT_TIE_PROPERTY_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(RankTransformModel.PROPERTY_NAME_TIES, (Object)RankTransformModel.this.getComputeTie());
                    } else if (RankTransformModel.EVENT_GROUPS_PROPERTY_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(RankTransformModel.PROPERTY_NAME_GROUPS, (Object)RankTransformModel.this.getAssignGroups());
                    } else if (RankTransformModel.EVENT_SAVAGE_PROPERTY_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue("Savage", (Object)RankTransformModel.this.getComputeSavage());
                    } else if (RankTransformModel.EVENT_NORMAL_PROPERTY_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue(RankTransformModel.PROPERTY_NAME_NORMAL, (Object)RankTransformModel.this.getComputeNormalScore());
                    } else if (RankTransformModel.EVENT_PERCENT_PROPERTY_CHANGED.equals(type)) {
                        this.m_promptModel.setOptionValue("Percent", (Object)RankTransformModel.this.getCalculatePercentage());
                    }
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }

        private class RankValueChangeListener
        extends BaseDataTransformValueChangedListener {
            public RankValueChangeListener(RankTransformModel owner, IPromptModel promptModel) {
                super(owner, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    if (RankTransformModel.PROPERTY_NAME_DESCENDING.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        RankTransformModel.this.setRankDirection(value.toString());
                    } else if (RankTransformModel.PROPERTY_NAME_BYSTATEMENTOPTION.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        RankTransformModel.this.setByStatement(value.toString());
                    } else if (RankTransformModel.PROPERTY_NAME_TIES.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        RankTransformModel.this.setComputeTie(value.toString());
                    } else if (RankTransformModel.PROPERTY_NAME_PROCRANKOPTIONS.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        RankTransformModel.this.setProcRankOptions(value.toString());
                    } else if ("Fraction".equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        RankTransformModel.this.setComputeFractional(value.toString());
                    } else if (RankTransformModel.PROPERTY_NAME_GROUPS.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        RankTransformModel.this.setAssignGroups(value.toString());
                    } else if (RankTransformModel.PROPERTY_NAME_NORMAL.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        RankTransformModel.this.setComputeNormalScore(value.toString());
                    } else if (RankTransformModel.PROPERTY_NAME_NPLUS1.equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        RankTransformModel.this.setComputeNPlus1(value.toString());
                    } else if ("Percent".equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        RankTransformModel.this.setCalculatePercentage(value.toString());
                    } else if ("Savage".equals(def.getPromptName())) {
                        Object value = this.m_model.getOptionValue(def.getPromptName());
                        if (value == null) {
                            value = "";
                        }
                        RankTransformModel.this.setComputeSavage(value.toString());
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }

    private class SortOrderUndoable
    extends AbstractUndoableEdit {
        private ISorting m_oldValue;
        private ISorting m_newValue;

        public SortOrderUndoable(ISorting oldValue, ISorting newValue) {
            this.m_oldValue = oldValue;
            this.m_newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            RankTransformModel.this.setSortOrder(this.m_oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            RankTransformModel.this.setSortOrder(this.m_newValue);
        }
    }

    private class SetByStatementUndoable
    extends AbstractUndoableEdit {
        private String m_oldByStatement;
        private String m_newByStatement;

        public SetByStatementUndoable(String oldByStatement, String newByStatement) {
            this.m_oldByStatement = oldByStatement;
            this.m_newByStatement = newByStatement;
        }

        @Override
        public void undo() {
            super.undo();
            RankTransformModel.this.setByStatement(this.m_oldByStatement);
        }

        @Override
        public void redo() {
            super.redo();
            RankTransformModel.this.setByStatement(this.m_newByStatement);
        }
    }

    private class SetComputeTieUndoable
    extends AbstractUndoableEdit {
        private String m_oldComputeTie;
        private String m_newComputeTie;

        public SetComputeTieUndoable(String oldComputeTie, String newComputeTie) {
            this.m_oldComputeTie = oldComputeTie;
            this.m_newComputeTie = newComputeTie;
        }

        @Override
        public void undo() {
            super.undo();
            RankTransformModel.this.setComputeTie(this.m_oldComputeTie);
        }

        @Override
        public void redo() {
            super.redo();
            RankTransformModel.this.setComputeTie(this.m_newComputeTie);
        }
    }

    private class SetComputeSavageUndoable
    extends AbstractUndoableEdit {
        private String m_oldComputeSavage;
        private String m_newComputeSavage;

        public SetComputeSavageUndoable(String oldComputeSavage, String newComputeSavage) {
            this.m_oldComputeSavage = oldComputeSavage;
            this.m_newComputeSavage = newComputeSavage;
        }

        @Override
        public void undo() {
            super.undo();
            RankTransformModel.this.setComputeSavage(this.m_oldComputeSavage);
        }

        @Override
        public void redo() {
            super.redo();
            RankTransformModel.this.setComputeSavage(this.m_newComputeSavage);
        }
    }

    private class SetComputeNPlus1Undoable
    extends AbstractUndoableEdit {
        private String m_oldComputeNPlus1;
        private String m_newComputeNPlus1;

        public SetComputeNPlus1Undoable(String oldComputeNPlus1, String newComputeNPlus1) {
            this.m_oldComputeNPlus1 = oldComputeNPlus1;
            this.m_newComputeNPlus1 = newComputeNPlus1;
        }

        @Override
        public void undo() {
            super.undo();
            RankTransformModel.this.setComputeNPlus1(this.m_oldComputeNPlus1);
        }

        @Override
        public void redo() {
            super.redo();
            RankTransformModel.this.setComputeNPlus1(this.m_newComputeNPlus1);
        }
    }

    private class SetComputeNormalScoreUndoable
    extends AbstractUndoableEdit {
        private String m_oldComputeNormalScore;
        private String m_newComputeNormalScore;

        public SetComputeNormalScoreUndoable(String oldComputeNormalScore, String newComputeNormalScore) {
            this.m_oldComputeNormalScore = oldComputeNormalScore;
            this.m_newComputeNormalScore = newComputeNormalScore;
        }

        @Override
        public void undo() {
            super.undo();
            RankTransformModel.this.setComputeNormalScore(this.m_oldComputeNormalScore);
        }

        @Override
        public void redo() {
            super.redo();
            RankTransformModel.this.setComputeNormalScore(this.m_newComputeNormalScore);
        }
    }

    private class SetComputeFractionalUndoable
    extends AbstractUndoableEdit {
        private String m_oldComputeFractional;
        private String m_newComputeFractional;

        public SetComputeFractionalUndoable(String oldComputeFractional, String newComputeFractional) {
            this.m_oldComputeFractional = oldComputeFractional;
            this.m_newComputeFractional = newComputeFractional;
        }

        @Override
        public void undo() {
            super.undo();
            RankTransformModel.this.setComputeFractional(this.m_oldComputeFractional);
        }

        @Override
        public void redo() {
            super.redo();
            RankTransformModel.this.setComputeFractional(this.m_newComputeFractional);
        }
    }

    private class SetCalculatePercentageUndoable
    extends AbstractUndoableEdit {
        private String m_oldCalculatePercentage;
        private String m_newCalculatePercentage;

        public SetCalculatePercentageUndoable(String oldCalculatePercentage, String newCalculatePercentage) {
            this.m_oldCalculatePercentage = oldCalculatePercentage;
            this.m_newCalculatePercentage = newCalculatePercentage;
        }

        @Override
        public void undo() {
            super.undo();
            RankTransformModel.this.setCalculatePercentage(this.m_oldCalculatePercentage);
        }

        @Override
        public void redo() {
            super.redo();
            RankTransformModel.this.setCalculatePercentage(this.m_newCalculatePercentage);
        }
    }

    private class SetProcRankOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldProcRankOptions;
        private String m_newProcRankOptions;

        public SetProcRankOptionsUndoable(String oldProcRankOptions, String newProcRankOptions) {
            this.m_oldProcRankOptions = oldProcRankOptions;
            this.m_newProcRankOptions = newProcRankOptions;
        }

        @Override
        public void undo() {
            super.undo();
            RankTransformModel.this.setProcRankOptions(this.m_oldProcRankOptions);
        }

        @Override
        public void redo() {
            super.redo();
            RankTransformModel.this.setProcRankOptions(this.m_newProcRankOptions);
        }
    }

    private class SetRankDirectionUndoable
    extends AbstractUndoableEdit {
        private String m_oldDirection;
        private String m_newDirection;

        public SetRankDirectionUndoable(String oldDirection, String newDirection) {
            this.m_oldDirection = oldDirection;
            this.m_newDirection = newDirection;
        }

        @Override
        public void undo() {
            super.undo();
            RankTransformModel.this.setRankDirection(this.m_oldDirection);
        }

        @Override
        public void redo() {
            super.redo();
            RankTransformModel.this.setRankDirection(this.m_newDirection);
        }
    }

    private class SetAssignGroupsUndoable
    extends AbstractUndoableEdit {
        private String m_oldGroups;
        private String m_newGroups;

        public SetAssignGroupsUndoable(String oldGroups, String newGroups) {
            this.m_oldGroups = oldGroups;
            this.m_newGroups = newGroups;
        }

        @Override
        public void undo() {
            super.undo();
            RankTransformModel.this.setAssignGroups(this.m_oldGroups);
        }

        @Override
        public void redo() {
            super.redo();
            RankTransformModel.this.setAssignGroups(this.m_newGroups);
        }
    }
}

