/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.queues.impl.MSMQQueueCodegen;
import com.sas.etl.models.job.transforms.queues.impl.MSMQWriterTransformModel;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.SASCodeGeneration;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class MSMQQueueWriterCodegen
extends MSMQQueueCodegen {
    public static final String MSMQQWriterCodegen_GlobalDefinitions_notrans = "Global definitions";
    public static final String MSMQQWriterCodegen_DataType_notrans = "Set up message queue data types";
    public static final String MSMQQWriterCodegen_SendAttachment_notrans = "Send the attachment";
    public static final String MSMQQWriterCodegen_SendText_notrans = "Send the text";
    public static final String MSMQQWriterCodegen_SendFile_notrans = "Send the file";
    public static final String MSMQQWriterCodegen_SendTable_notrans = "Send the table";
    public static final String MSMQQWriterCodegen_SendFailed_notrans = "Send failed";
    public static final String MSMQQWriterCodegen_BuildMap_notrans = "Build the map";
    public static final String MSMQQWriterCodegen_BuildMapFailed_notrans = "The map failed";
    public static final String MSMQQWriterCodegen_LetStatements_notrans = "initialize the queue option values";
    public static final String MSMQQWriterCodegen_DebugTurnedOn_notrans = "Debug mode turned on";
    public static final String MSMQQWriterCodegen_NoColumns_exception_txt = "The table has no columns to send";
    public static final String MSMQQWriterCodegen_NoFileSpecified_msg_txt = "A file to read from must be specified when a file is to be sent to queue";
    private static SASCodeGeneration m_attrib;
    private static SASCodeGeneration m_attribVal;

    protected ICodeSegment getGeneratedCode(ICodeSegment oICodeSegment, MSMQWriterTransformModel oMSMQWriterTransformModel) throws CodegenException, RemoteException, MdException, BadLibraryDefinitionException, ServerException, BadServerDefinitionException {
        if (oMSMQWriterTransformModel.isFileMessage()) {
            MSMQQueueWriterCodegen.BuildSendFileCode(oICodeSegment, oMSMQWriterTransformModel);
        } else if (oMSMQWriterTransformModel.isTableMessage()) {
            MSMQQueueWriterCodegen.buildTableSend(oICodeSegment, oMSMQWriterTransformModel);
        } else {
            MSMQQueueWriterCodegen.buildTextMsgSend(oICodeSegment, oMSMQWriterTransformModel);
        }
        oICodeSegment.genCodeConditionCheck(oICodeSegment, "DIS_CSUCCESSFUL", oMSMQWriterTransformModel, null);
        oICodeSegment.genCodeConditionCheck(oICodeSegment, "DIS_CWARNINGS", oMSMQWriterTransformModel, null);
        oICodeSegment.genCodeConditionCheck(oICodeSegment, "DIS_CERRORS", oMSMQWriterTransformModel, null);
        return oICodeSegment;
    }

    public static void buildTextMap(ICodeSegment oICodeSegment, MSMQWriterTransformModel model, String mapName) throws MdException, RemoteException {
        oICodeSegment.addSectionComment(MSMQQWriterCodegen_BuildMap_notrans);
        String storage = "REGISTRY";
        if (model.isMapStoreDefined()) {
            storage = model.getMapStore();
        }
        oICodeSegment.addSourceCode("call setmap( '");
        oICodeSegment.addSourceCode(mapName);
        oICodeSegment.addSourceCode("', '");
        oICodeSegment.addSourceCode(storage);
        oICodeSegment.addSourceCode("', etls_rc, ");
        oICodeSegment.addSourceCode("'CHAR,,");
        int val = model.getMessageLength();
        if (val == 0) {
            val = 256;
        }
        oICodeSegment.addSourceCode(String.valueOf(val));
        oICodeSegment.addSourceCode("' );\n");
        MSMQQueueWriterCodegen.BuildErrorHandling(oICodeSegment, MSMQQWriterCodegen_BuildMapFailed_notrans, "map ");
        oICodeSegment.addSourceCode("\n");
    }

    public static void buildTableMap(ICodeSegment cgReq, MSMQWriterTransformModel model, String mapName) throws MdException, RemoteException {
        List columnList = model.buildMessageColumnsList(model.getSourceTable().getColumns());
        if (columnList == null) {
            throw new MdException(MSMQQWriterCodegen_NoColumns_exception_txt);
        }
        if (columnList.size() == 0) {
            throw new MdException(MSMQQWriterCodegen_NoColumns_exception_txt);
        }
        cgReq.addSectionComment(MSMQQWriterCodegen_BuildMap_notrans);
        String storage = "REGISTRY";
        if (model.isMapStoreDefined()) {
            storage = model.getMapStore();
        }
        cgReq.addSourceCode("call setmap( '");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("', '");
        cgReq.addSourceCode(storage);
        cgReq.addSourceCode("', etls_rc, \n");
        cgReq.indent();
        MSMQQueueWriterCodegen.buildColumnFormats(cgReq, columnList);
        cgReq.addSourceCode(" );\n");
        cgReq.unIndent();
        MSMQQueueWriterCodegen.BuildErrorHandling(cgReq, MSMQQWriterCodegen_BuildMapFailed_notrans, "map ");
        cgReq.addSourceCode("\n");
    }

    public static void buildTableSend(ICodeSegment cgReq, MSMQWriterTransformModel model) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException {
        boolean bNeedQuotes = cgReq.isQuoting();
        IPhysicalTable sourceTable = model.getSourceTable();
        String sourceTableName = sourceTable.getFullNameQuotedAsNeeded(cgReq);
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        cgReq.addSourceCode("set ").addSourceCode(sourceTableName).addSourceCode(" ").addSourceCode(model.getTableOptionObject(sourceTable, true).getTableOptions(true, cgReq.getCurrentServer())).addSourceCode(" end=etls_last;\n");
        cgReq.addSourceCode("length etls_queue  $ 200;\n");
        cgReq.addSourceCode("etls_queue = '").addSourceCode(model.getMessageQueue().getMessageQueueName()).addSourceCode("';\n");
        cgReq.addSectionComment(MSMQQWriterCodegen_DataType_notrans);
        MSMQQueueWriterCodegen.buildDeclarations(cgReq, model);
        cgReq.addSourceCode("length etls_msg $ 200;\n");
        cgReq.addSourceCode("length etls_qid 8;\n");
        cgReq.addSourceCode("length etls_tid 8;\n");
        if (model.isTransaction()) {
            cgReq.addSourceCode("length etls_transid 8;\n");
        }
        StringBuffer s_retain = new StringBuffer();
        s_retain.append("retain etls_qid etls_tid");
        if (model.isTransaction()) {
            s_retain.append(" etls_transid");
        }
        s_retain.append(";\n");
        cgReq.addSourceCode("length etls_rc 8;\n\n");
        cgReq.addSourceCode(s_retain.toString());
        cgReq.addSourceCode("if _n_ = 1 then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent();
        MSMQQueueWriterCodegen.buildInit(cgReq);
        MSMQQueueWriterCodegen.buildOpen(cgReq, "DELIVERY", "", model);
        if (model.isQueuePropertiesTurnedOn()) {
            MSMQQueueWriterCodegen.buildVerifyQueueProperties(cgReq, model);
        }
        cgReq.addSectionComment(MSMQQWriterCodegen_LetStatements_notrans);
        ArrayList parameterList = new ArrayList();
        MSMQQueueWriterCodegen.buildMacroValues(model, parameterList, cgReq);
        cgReq.addSourceCode("\n");
        int pSize = parameterList.size();
        int scSize = pSize - 1;
        int k = 0;
        if (pSize > 0) {
            cgReq.addSourceCode("retain ");
            for (int i = 0; i < pSize; ++i) {
                cgReq.addSourceCode("etls_").addSourceCode(((String)parameterList.get(i)).toLowerCase());
                if (i == scSize) {
                    cgReq.addSourceCode(";\n");
                    break;
                }
                cgReq.addSourceCode(" ");
                if (++k != 2) continue;
                cgReq.addSourceCode("\n");
                k = 0;
            }
        }
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        if (model.isTransaction()) {
            MSMQQueueWriterCodegen.buildBeginTransaction(cgReq);
            m_attrib.addSourceCode("TRANSACTION").addSourceCode(",");
            m_attribVal.addSourceCode("etls_transid").addSourceCode(",");
        }
        String mapName = cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("etls_map='");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("';\n\n");
        MSMQQueueWriterCodegen.buildTableMap(cgReq, model, mapName);
        cgReq.unIndent();
        cgReq.addSourceCode("end;/* if _n_ = 1 */\n");
        MSMQQueueWriterCodegen.buildAttributeList(parameterList, false, m_attrib, m_attribVal);
        m_attrib.addSourceCode("MAP");
        m_attribVal.addSourceCode("\"");
        m_attribVal.addSourceCode(mapName);
        m_attribVal.addSourceCode("\"").addSourceCode(",");
        cgReq.addSectionComment(MSMQQWriterCodegen_SendTable_notrans);
        List columnList = model.buildMessageColumnsList(model.getSourceTable().getColumns());
        cgReq.addSourceCode("call sendmessage( etls_qid, etls_rc,\n");
        cgReq.indent().addSourceCode("'");
        cgReq.addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource()).addSourceCode(" \n");
        int sz = columnList.size();
        int j = 0;
        for (int i = 0; i < sz; ++i) {
            String[] sArrayQueueFormat = (String[])columnList.get(i);
            String sName = sArrayQueueFormat[0];
            if (bNeedQuotes) {
                cgReq.addSourceCode("\"");
            }
            cgReq.addSourceCode(sName);
            if (bNeedQuotes) {
                cgReq.addSourceCode("\"");
                cgReq.addSourceCode("n");
            }
            if (i < sz - 1) {
                cgReq.addSourceCode(", ");
            }
            if (++j != 2) continue;
            cgReq.addSourceCode("\n");
            j = 0;
        }
        cgReq.addSourceCode(");\n");
        cgReq.unIndent();
        MSMQQueueWriterCodegen.BuildErrorHandling(cgReq, MSMQQWriterCodegen_SendFailed_notrans, "send message", true);
        cgReq.addSourceCode("if (etls_last) then\n");
        cgReq.addSourceCode("do;\n");
        cgReq.indent();
        if (model.isTransaction()) {
            MSMQQueueWriterCodegen.buildCommitTransaction(cgReq, false);
        }
        cgReq.addSourceCode("link term;\n");
        cgReq.unIndent();
        cgReq.addSourceCode("end; /* if (etls_last) */\n");
        cgReq.addSourceCode("return;\n");
        cgReq.addSectionComment("Terminate routine");
        cgReq.addSourceCode("term:\n");
        cgReq.indent();
        if (model.isTransaction()) {
            MSMQQueueWriterCodegen.buildFreeTransaction(cgReq);
        }
        MSMQQueueWriterCodegen.buildTerm(cgReq, model.isDebug());
        cgReq.unIndent();
        cgReq.addSourceCode("return; ");
        cgReq.addCommentLine("End of terminate routine");
        cgReq.unIndent();
        cgReq.addSourceCode("run;\n");
    }

    protected static void buildDeclarations(ICodeSegment cgReq, MSMQWriterTransformModel model) {
        cgReq.addSourceCode("length etls_mqdebug $ 10;\n");
        if (model.isDebug()) {
            cgReq.addSourceCode("etls_mqdebug=\"YES\";\n");
        } else {
            cgReq.addSourceCode("etls_mqdebug=\"NO\";\n");
        }
    }

    public static void buildTextMsgSend(ICodeSegment cgReq, MSMQWriterTransformModel model) throws MdException, RemoteException {
        model.textMessageToMacroVariable(cgReq);
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        cgReq.addSourceCode("length etls_queue  $ 200;\n");
        cgReq.addSourceCode("etls_queue = '").addSourceCode(model.getMessageQueue().getMessageQueueName().trim()).addSourceCode("';\n");
        cgReq.addSectionComment(MSMQQWriterCodegen_DataType_notrans);
        MSMQQueueWriterCodegen.buildDeclarations(cgReq, model);
        cgReq.addSourceCode("length etls_msg $ 200;\n");
        cgReq.addSourceCode("length etls_qid 8;\n");
        cgReq.addSourceCode("length etls_tid 8;\n");
        cgReq.addSourceCode("length etls_rc 8;\n");
        if (model.isTransaction()) {
            cgReq.addSourceCode("length etls_transid 8;\n");
        }
        cgReq.addSourceCode("\n");
        MSMQQueueWriterCodegen.buildInit(cgReq);
        MSMQQueueWriterCodegen.buildOpen(cgReq, "DELIVERY", "", model);
        if (model.isQueuePropertiesTurnedOn()) {
            MSMQQueueWriterCodegen.buildVerifyQueueProperties(cgReq, model);
        }
        cgReq.addSectionComment(MSMQQWriterCodegen_LetStatements_notrans);
        ArrayList parameterList = new ArrayList();
        MSMQQueueWriterCodegen.buildMacroValues(model, parameterList, cgReq);
        cgReq.addSourceCode("\n");
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        if (model.isTransaction()) {
            MSMQQueueWriterCodegen.buildBeginTransaction(cgReq);
            m_attrib.addSourceCode("TRANSACTION").addSourceCode(",").addSourceCode(" ");
            m_attribVal.addSourceCode("etls_transid").addSourceCode(",").addSourceCode(" ");
        }
        String mapName = cgReq.getUniqueWorkTableName();
        cgReq.addSourceCode("etls_map='");
        cgReq.addSourceCode(mapName);
        cgReq.addSourceCode("';\n\n");
        MSMQQueueWriterCodegen.buildTextMap(cgReq, model, mapName);
        MSMQQueueWriterCodegen.buildAttributeList(parameterList, false, m_attrib, m_attribVal);
        m_attrib.addSourceCode("MAP");
        m_attribVal.addSourceCode("\"");
        m_attribVal.addSourceCode(mapName);
        m_attribVal.addSourceCode("\"").addSourceCode(",");
        cgReq.addSectionComment(MSMQQWriterCodegen_SendText_notrans);
        cgReq.addSourceCode("call sendmessage( etls_qid, etls_rc,\n");
        cgReq.indent();
        cgReq.addSourceCode("'").addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource()).addSourceCode(" \"&etls_msg\");\n");
        cgReq.unIndent();
        MSMQQueueWriterCodegen.BuildErrorHandling(cgReq, MSMQQWriterCodegen_SendFailed_notrans, "send message");
        cgReq.addSourceCode("\n");
        if (model.isTransaction()) {
            MSMQQueueWriterCodegen.buildCommitTransaction(cgReq);
        }
        MSMQQueueWriterCodegen.buildTerm(cgReq, model.isDebug());
        cgReq.unIndent().addSourceCode("run;\n");
    }

    public static void BuildSendFileCode(ICodeSegment cgReq, MSMQWriterTransformModel model) throws MdException, RemoteException {
        String sFileName = model.getFileName();
        cgReq.addSourceCode("filename etls_fr '").addSourceCode(sFileName.trim()).addSourceCode("';\n");
        cgReq.addSourceCode("%rcSet(&sysrc);\n");
        cgReq.addSourceCode("data _null_;\n");
        cgReq.indent();
        cgReq.addSectionComment(MSMQQWriterCodegen_GlobalDefinitions_notrans);
        cgReq.addSourceCode("length etls_queue  $ 200;\n");
        cgReq.addSourceCode("etls_queue = '").addSourceCode(model.getMessageQueue().getMessageQueueName().trim()).addSourceCode("';\n");
        cgReq.addSectionComment(MSMQQWriterCodegen_DataType_notrans);
        MSMQQueueWriterCodegen.buildDeclarations(cgReq, model);
        cgReq.addSourceCode("length etls_msg $ 200;\n");
        cgReq.addSourceCode("length etls_qid 8;\n");
        cgReq.addSourceCode("length etls_tid 8;\n");
        cgReq.addSourceCode("length etls_rc 8;\n\n");
        MSMQQueueWriterCodegen.buildInit(cgReq);
        MSMQQueueWriterCodegen.buildOpen(cgReq, "DELIVERY", "", model);
        if (model.isQueuePropertiesTurnedOn()) {
            MSMQQueueWriterCodegen.buildVerifyQueueProperties(cgReq, model);
        }
        cgReq.addSectionComment(MSMQQWriterCodegen_SendAttachment_notrans);
        cgReq.addSourceCode("length etls_alist $ 80;\n");
        cgReq.addSourceCode("etls_alist = 'external_bin, fileref, etls_fr';\n");
        cgReq.addSectionComment(MSMQQWriterCodegen_LetStatements_notrans);
        ArrayList parameterList = new ArrayList();
        MSMQQueueWriterCodegen.buildMacroValues(model, parameterList, cgReq);
        cgReq.addSourceCode("\n");
        m_attribVal = new SASCodeGeneration();
        m_attrib = new SASCodeGeneration();
        MSMQQueueWriterCodegen.buildAttributeList(parameterList, false, m_attrib, m_attribVal);
        m_attrib.addSourceCode("ATTACHLIST");
        cgReq.addSectionComment(MSMQQWriterCodegen_SendFile_notrans);
        cgReq.addSourceCode("call sendmessage( etls_qid, etls_rc,\n");
        cgReq.indent();
        cgReq.addSourceCode("'").addSourceCode(m_attrib.getSource()).addSourceCode("',\n");
        cgReq.addSourceCode(m_attribVal.getSource()).addSourceCode("etls_alist);\n");
        cgReq.unIndent();
        MSMQQueueWriterCodegen.BuildErrorHandling(cgReq, MSMQQWriterCodegen_SendFailed_notrans, "send message");
        cgReq.addSourceCode("\n");
        MSMQQueueWriterCodegen.buildTerm(cgReq, model.isDebug());
        cgReq.unIndent();
        cgReq.unIndent().addSourceCode("run;\n");
    }
}

