/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.transforms.queues.impl.MQPO;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MQMD
extends MQPO {
    public static final String MQMD_Comment_notrans = "Manipulates message descriptor parameters to be used on a subsequent MQPUT, MQPUT1 or MQGET call";
    public static final String MQMD_Failedwithreasoncode_notrans = "MQMD: failed with reason code:";
    private String m_action = "GEN";
    protected static String REPORT = "REPORT";
    protected static String MSGTYPE = "MSGTYPE";
    protected static String EXPIRY = "EXPIRY";
    protected static String FEEDBACK = "FEEDBACK";
    protected static String ENCODING = "ENCODING";
    protected static String CODEDCHARSETID = "CODEDCHARSETID";
    protected static String FORMAT = "FORMAT";
    protected static String PRIORITY = "PRIORITY";
    protected static String PERSISTENCE = "PERSISTENCE";
    protected static String MSGID = "MSGID";
    protected static String CORRELID = "CORRELID";
    protected static String BACKOUTCOUNT = "BACKOUTCOUNT";
    protected static String REPLYTOQ = "REPLYTOQ";
    protected static String REPLYTOQMGR = "REPLYTOQMGR";
    protected static String USERIDENTIFIER = "USERIDENTIFIER";
    protected static String ACCOUNTINGTOKEN = "ACCOUNTINGTOKEN";
    protected static String APPLIDENTITYDATA = "APPLIDENTITYDATA";
    protected static String PUTAPPLTYPE = "PUTAPPLTYPE";
    protected static String PUTAPPLNAME = "PUTAPPLNAME";
    protected static String PUTDATE = "PUTDATE";
    protected static String PUTTIME = "PUTTIME";
    protected static String APPLORIGINDATA = "APPLORIGINDATA";
    protected static String GROUPID = "GROUPID";
    protected static String MSGSEQNUMBER = "MSGSEQNUMBER";
    protected static String OFFSET = "OFFSET";
    protected static String MSGFLAGS = "MSGFLAGS";
    protected static String NONE = "NONE";
    protected static String PASS_CORREL_ID = "PASS_CORREL_ID";
    protected static String PASS_MSG_ID = "PASS_MSG_ID";
    protected static String COA = "COA";
    protected static String COA_WITH_DATA = "COA_WITH_DATA";
    protected static String COA_WITH_FULL_DATA = "COA_WITH_FULL_DATA";
    protected static String COD = "COD";
    protected static String COD_WITH_DATA = "COD_WITH_DATA";
    protected static String COD_WITH_FULL_DATA = "COD_WITH_FULL_DATA";
    protected static String EXPIRATION = "EXPIRATION";
    protected static String EXPIRATION_WITH_DATA = "EXPIRATION_WITH_DATA";
    protected static String EXPIRATION_WITH_FULL_DATA = "EXPIRATION_WITH_FULL_DATA";
    protected static String EXCEPTION = "EXCEPTION";
    protected static String EXCEPTION_WITH_DATA = "EXCEPTION_WITH_DATA";
    protected static String EXCEPTION_WITH_FULL_DATA = "EXCEPTION_WITH_FULL_DATA";
    protected static String DISCARD_MSG = "DISCARD_MSG";
    protected static String PAN = "PAN";
    protected static String NAN = "NAN";

    public MQMD(ICodeSegment cgReq, boolean bQueueWriter, HashMap hmUserInput) throws MdException, RemoteException {
        super(cgReq, bQueueWriter, hmUserInput);
        this.initializeParameters();
        this.initializeOptions();
        this.createParameters();
        this.createReportOptions();
    }

    private void createParameters() {
        this.addParameter(REPORT, true, 80);
        this.addParameter(MSGTYPE, false);
        this.addParameter(EXPIRY, false);
        this.addParameter(FEEDBACK, false);
        this.addParameter(ENCODING, false);
        this.addParameter(CODEDCHARSETID, false);
        this.addParameter(FORMAT, true, 8);
        this.addParameter(PRIORITY, false);
        this.addParameter(PERSISTENCE, true, 28);
        this.addParameter(MSGID, true, 48);
        this.addParameter(CORRELID, true, 48);
        this.addParameter(BACKOUTCOUNT, false);
        this.addParameter(REPLYTOQ, true, 48);
        this.addParameter(REPLYTOQMGR, true, 100);
        this.addParameter(USERIDENTIFIER, true, 12);
        this.addParameter(ACCOUNTINGTOKEN, true, 64);
        this.addParameter(APPLIDENTITYDATA, true, 32);
        this.addParameter(PUTAPPLTYPE, false);
        this.addParameter(PUTAPPLNAME, true, 28);
        this.addParameter(PUTDATE, true, 8);
        this.addParameter(PUTTIME, true, 8);
        this.addParameter(APPLORIGINDATA, true, 4);
        this.addParameter(GROUPID, true, 48);
        this.addParameter(MSGSEQNUMBER, false);
        this.addParameter(OFFSET, false);
        this.addParameter(MSGFLAGS, false);
    }

    private void createReportOptions() {
        Boolean oBoolean = new Boolean(false);
        this.m_hmOptions.put(NONE, oBoolean);
        this.m_hmOptions.put(PASS_CORREL_ID, oBoolean);
        this.m_hmOptions.put(PASS_MSG_ID, oBoolean);
        this.m_hmOptions.put(COA, oBoolean);
        this.m_hmOptions.put(COA_WITH_DATA, oBoolean);
        this.m_hmOptions.put(COA_WITH_FULL_DATA, oBoolean);
        this.m_hmOptions.put(EXPIRATION, oBoolean);
        this.m_hmOptions.put(EXPIRATION_WITH_DATA, oBoolean);
        this.m_hmOptions.put(EXPIRATION_WITH_FULL_DATA, oBoolean);
        this.m_hmOptions.put(EXCEPTION, oBoolean);
        this.m_hmOptions.put(EXCEPTION_WITH_DATA, oBoolean);
        this.m_hmOptions.put(EXCEPTION_WITH_FULL_DATA, oBoolean);
        this.m_hmOptions.put(DISCARD_MSG, oBoolean);
        this.m_hmOptions.put(PAN, oBoolean);
        this.m_hmOptions.put(NAN, oBoolean);
    }

    protected void readFromTransformationInput() {
        this.readFromTransformationInput(this.m_hmParms, this.m_hmUserInput, true);
        this.readFromTransformationInput(this.m_hmOptions, this.m_hmUserInput, false);
    }

    public void generateLengthStatements() {
        this.addBlankLine();
        this.generateLengthStatements(this.m_hmParms, this.m_Version);
        if (this.m_Version.length() == 0) {
            this.addBlankLine();
            this.addRBComment("SASVAR_MESSAGEDESCRIPTOR_HANDLE");
            this.addLengthStatement("etls_hmd", true, "8");
        }
    }

    public void generateAssignmentStatements() {
        this.addBlankLine();
        this.assignVariable("SASVAR_GENERATE_ACTION", "etls_gen_" + this.getClassName() + this.m_Version, this.m_action, true);
        String sOptions = this.getValuesForOptionsParameter();
        if (sOptions.length() > 0) {
            String sCurrValue = this.getParameterValue(REPORT);
            if (sCurrValue.length() > 0) {
                this.setValue(REPORT, sCurrValue + "," + sOptions);
            } else {
                this.setValue(REPORT, sOptions);
            }
        }
        if (this.countParameters() > 0) {
            this.generateParmsStatements();
            this.generateValuesStatements();
        }
    }

    public void generateFunctionCall() {
        this.addBlankLine();
        this.m_cg.addCommentLine(MQMD_Comment_notrans);
        this.buildFunctionCall(this.getFunctionParms());
        this.addFailCondition(MQMD_Failedwithreasoncode_notrans);
    }

    protected void setAction(String sAction) {
        this.m_action = sAction;
        if (sAction.compareToIgnoreCase("INQ") == 0) {
            this.m_sPrefix = "etls_";
        } else if (sAction.compareToIgnoreCase("SET") == 0) {
            this.m_sPrefix = "etls_";
        }
    }

    protected List getFunctionParms() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("etls_hmd");
        list.add("etls_gen_" + this.getClassName() + this.m_Version);
        list.add("etls_qrc");
        if (this.countParameters() > 0) {
            list.add("etls_parms" + this.m_Version);
            list.add(this.m_sValueParms);
        }
        return list;
    }
}

