/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IDirectory;
import com.sas.etl.models.data.IFile;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IMessageQueue;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BasePromptModel;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.Workspace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.Level;
import org.xml.sax.SAXException;

public abstract class CommonQueueTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.queues.IBMWSQWriter";
    private static final String TRANSFORMATION_ROLE = "IBMWSQWriter:HIDE";
    protected static final String COMMA = ",";
    protected static final String YES = "YES";
    protected static final String QUOTE = "\"";
    private boolean m_reader;
    private IPromptModel m_messageOptionModel;
    public static final String MS_MQ = "MSMQ";
    public static final String IBM_WS_MQ = "IBMWSMQ";
    private String m_MQSystem = "IBMWSMQ";
    protected static final String QOPTIONS_SET = "QOPTIONS_SET";
    protected static final String QOPTIONS_SET_ROLE = "QOPTIONS_SET";
    protected static final String QTYPE = "QTYPE";
    private String m_msgType_Text_Table_File = "TEXT";
    public static final String FILE = "FILE";
    public static final String TABLE = "TABLE";
    public static final String TEXT = "TEXT";
    protected static final String FNAME = "FNAME";
    private String m_fileName;
    protected static final String STOREDTEXT = "STOREDTEXT";
    private String m_textContent;
    protected static final String MSGLEN = "MSGLEN";
    private int m_messageLength;
    protected static final String MACROVARIABLE = "MACROVARIABLE";
    private String m_macroVariable = "etls_qms";
    protected static final String DIRECTORY = "DIRECTORY";
    private static String sPrefix = "ETLSQ_";
    private Map m_mapPropertySetsCA = new HashMap();
    private static final String CUSTOMASSOCIATION = "CustomAssociation";
    public static final String QUEUE = "queue";
    public static final String QUEUE_MESSAGE_TYPE = "ETLS_QCOL_TYPE";
    public static final String QUEUE_MESSAGE_LENGTH = "ETLS_QCOL_LENGTH";
    public static final String QUEUE_MESSAGE_FORMAT = "ETLS_QCOL_FORMAT";
    public static final String CHAR = "CHAR";
    public static final String SHORT = "SHORT";
    public static final String LONG = "LONG";
    public static final String DOUBLE = "DOUBLE";
    public static final String ETLS_MESSAGE_MACRO_VARIABLE = "etls_msg";
    public static final String QUEUE_TYPE_CHANGED = "QueueTransformModel:QueueTypeChanged";
    public static final String MSG_LENGTH_CHANGED = "QueueTransformModel:MessageLengthChanged";
    public static final String STORED_TEXT_CHANGED = "QueueTransformModel:StoredTextChanged";
    public static final String FILE_NAME_CHANGED = "QueueTransformModel:FileNameChanged";
    public static final String MACRO_VARIABLE_CHANGED = "QueueTransformModel:MacroVariableChanged";
    public static final String COLUMN_FORMAT_CHANGED = "QueueTransformModel:ColumnFormatChanged";
    public static final String COLUMN_FORMAT_ADDED = "QueueTransformModel:ColumnFormatAdded";
    public static final String SASFILEEXTENSION = ".sas7bdat";
    protected HashMap m_hmUserInput;
    protected static final String EMQ_TEXTOPTION = "etls_text";
    protected static final String EMQ_TABLEOPTION = "etls_table";
    protected static final String EMQ_FILEOPTION = "etls_file";
    protected static final String EMQ_DELIMITER = ";";
    private boolean m_bTransaction;
    private boolean m_bDepth;
    private boolean m_bOpenMode;
    private boolean m_bOpenAttr;
    private boolean m_bMsgId;
    private boolean m_bDebug;
    private boolean m_bMapStore;
    private boolean m_bQueueProps;
    private String m_sTransaction;
    private String m_sDepth;
    private String m_sOpenMode;
    private String m_sOpenAttr;
    private String m_sMsgId;
    private String m_sMapStore;
    private String m_listenToChangesOnThisTable;
    private static final char[] HexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public CommonQueueTransformModel(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getSource() == this.getConnectedSourceOrTargetTable() && ev.getType() == 1) {
            this.fireModelChangedEvent(QUEUE_TYPE_CHANGED, null);
        }
        super.notify(ev);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.deleteFromOMR(omr);
        if (this.m_messageOptionModel != null) {
            this.m_messageOptionModel.deleteFromOMR(omr);
        }
    }

    @Override
    protected boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoSourcesMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoTargetsMeanIncomplete() {
        return false;
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get("PropertySet");
        lAssociations.add(CUSTOMASSOCIATION);
        map.put("PropertySet", lAssociations);
        return map;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.isWriter() && this.getMessageQueue() == null) {
            lReasons.add(RB.getStringResource("CommonQueueTransformModel.ReasonIncomplete.NoTargetQueue.txt"));
        } else if (this.isReader() && this.getMessageQueue() == null) {
            lReasons.add(RB.getStringResource("CommonQueueTransformModel.ReasonIncomplete.NoSourceQueue.txt"));
        }
        if (this.isReader() && this.isTableMessage() && this.getTargetTable() == null) {
            lReasons.add(RB.getStringResource("CommonQueueTransformModel.ReasonIncomplete.NoTargetTable.txt"));
        } else if (this.isWriter() && this.isTableMessage() && this.getSourceTable() == null) {
            lReasons.add(RB.getStringResource("CommonQueueTransformModel.ReasonIncomplete.NoSourceTable.txt"));
        }
        if (this.isReader() && this.isTableMessage() && this.getTargetTable() != null && this.getTargetTable().getColumnCount() == 0) {
            lReasons.add(RB.getStringResource("CommonQueueTransformModel.ReasonIncomplete.NoColumnsInTable.txt"));
        } else if (this.isWriter() && this.isTableMessage() && this.getSourceTable() != null && this.getSourceTable().getColumnCount() == 0) {
            lReasons.add(RB.getStringResource("CommonQueueTransformModel.ReasonIncomplete.NoColumnsInTable.txt"));
        }
        if (this.isReader() && this.isFileMessage() && this.getFileName().length() <= 0) {
            lReasons.add(RB.getStringResource("CommonQueueTransformModel.ReasonIncomplete.NoTargetFile.txt"));
        } else if (this.isWriter() && this.isFileMessage() && this.getFileName().length() <= 0) {
            lReasons.add(RB.getStringResource("CommonQueueTransformModel.ReasonIncomplete.NoSourceFile.txt"));
        }
        return lReasons;
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    public boolean isComplete() {
        boolean bTable = true;
        boolean bFile = true;
        if (this.isTableMessage()) {
            if (this.isReader()) {
                if (this.getTargetTable() == null) {
                    bTable = false;
                } else if (this.getTargetTable().getColumnCount() == 0) {
                    bTable = false;
                }
            } else if (this.getSourceTable() == null) {
                bTable = false;
            } else if (this.getSourceTable().getColumnCount() == 0) {
                bTable = false;
            }
            if (this.getConnectedSourceOrTargetTable() != null && (this.m_listenToChangesOnThisTable == null || this.m_listenToChangesOnThisTable.compareTo(this.getConnectedSourceOrTargetTable().getID()) != 0)) {
                this.getConnectedSourceOrTargetTable().addNotifyListener(this);
                this.m_listenToChangesOnThisTable = this.getConnectedSourceOrTargetTable().getID();
            }
        }
        if (this.isFileMessage() && this.getFileName().length() <= 0) {
            bFile = false;
        }
        return super.isComplete() && this.getMessageQueue() != null && bTable && bFile;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        this.loadQueueFromOMR(omr, mdoStep);
        this.loadColumnFormatsFromOMR(omr);
        AssociationList lTransformations = mdoStep.getTransformations();
        ClassifierMap classifierMap = null;
        if (lTransformations.size() > 0) {
            classifierMap = (ClassifierMap)lTransformations.get(0);
            this.setQueueType(this.loadStringOptionFromOMR(omr, (Root)classifierMap, "QOPTIONS_SET", QTYPE, ""));
            this.setMessageLength(this.loadIntOptionFromOMR(omr, (Root)classifierMap, "QOPTIONS_SET", MSGLEN, 256));
            this.setTextContent(this.loadStringOptionFromOMR(omr, (Root)classifierMap, "QOPTIONS_SET", STOREDTEXT, ""));
            this.setFileName(this.loadStringOptionFromOMR(omr, (Root)classifierMap, "QOPTIONS_SET", FNAME, ""));
            this.setMacroVariable(this.loadStringOptionFromOMR(omr, (Root)classifierMap, "QOPTIONS_SET", MACROVARIABLE, ""));
        }
        try {
            IPromptModel optionModel = this.getMessageOptionModel();
            optionModel.loadFromOMR(omr);
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        catch (ServerConnectionException e) {
            throw new MdException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new MdException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MdException((Throwable)e);
        }
        catch (SAXException e) {
            throw new MdException((Throwable)e);
        }
        catch (IOException e) {
            throw new MdException((Throwable)e);
        }
        this.setChanged(false);
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_messageOptionModel != null && this.m_messageOptionModel.isChanged();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        this.saveQueuesToOMR(omr, mdoStep);
        this.saveColumnFormatsToOMR(omr, mdoStep);
        AssociationList lTransformations = mdoStep.getTransformations();
        ClassifierMap classifierMap = null;
        if (lTransformations.size() > 0) {
            classifierMap = (ClassifierMap)lTransformations.get(0);
            this.saveStringOptionToOMR(omr, (Root)classifierMap, "QOPTIONS_SET", QTYPE, this.getQueueType());
            this.saveIntOptionToOMR(omr, (Root)classifierMap, "QOPTIONS_SET", MSGLEN, this.getMessageLength());
            this.saveStringOptionToOMR(omr, (Root)classifierMap, "QOPTIONS_SET", STOREDTEXT, this.getTextContent());
            this.saveStringOptionToOMR(omr, (Root)classifierMap, "QOPTIONS_SET", FNAME, this.getFileName());
            this.saveStringOptionToOMR(omr, (Root)classifierMap, "QOPTIONS_SET", MACROVARIABLE, this.getMacroVariable());
        }
        if (this.m_messageOptionModel != null) {
            this.m_messageOptionModel.saveToOMR(omr);
        }
        this.setChanged(false);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        try {
            this.getMessageOptionModel().updateIDs(mapIDs);
            this.updateMQColumnFormatIds(mapIDs);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateMQColumnFormatIds(Map mapIDs) {
        Collection values = this.m_mapPropertySetsCA.values();
        MQColumnFormats[] aMQColumnFormats = new MQColumnFormats[values.size()];
        values.toArray(aMQColumnFormats);
        this.m_mapPropertySetsCA.clear();
        for (int iColumnFormat = 0; iColumnFormat < aMQColumnFormats.length; ++iColumnFormat) {
            MQColumnFormats mqColumnFormat = aMQColumnFormats[iColumnFormat];
            MQColumnFormats oMQColumnFormats = aMQColumnFormats[iColumnFormat];
            if (mapIDs.containsKey(oMQColumnFormats.getID())) {
                oMQColumnFormats.updateIDs(mapIDs);
            }
            if (mapIDs.containsKey(oMQColumnFormats.getColumnFQID())) {
                oMQColumnFormats.setColumnFQID((String)mapIDs.get(oMQColumnFormats.getColumnFQID()));
            }
            if (mapIDs.containsKey(oMQColumnFormats.getCustomAssociationFQID())) {
                mqColumnFormat.setCustomAssociationFQID((String)mapIDs.get(oMQColumnFormats.getCustomAssociationFQID()));
            }
            if (mapIDs.containsKey(oMQColumnFormats.getFormatFQID())) {
                mqColumnFormat.setFormatFQID((String)mapIDs.get(oMQColumnFormats.getFormatFQID()));
            }
            if (mapIDs.containsKey(oMQColumnFormats.getLengthFQID())) {
                mqColumnFormat.setLengthFQID((String)mapIDs.get(oMQColumnFormats.getLengthFQID()));
            }
            if (mapIDs.containsKey(oMQColumnFormats.getTypeFQID())) {
                mqColumnFormat.setTypeFQID((String)mapIDs.get(oMQColumnFormats.getTypeFQID()));
            }
            this.m_mapPropertySetsCA.put(oMQColumnFormats.getColumnFQID(), oMQColumnFormats);
        }
    }

    protected void saveStringOptionToOMR(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sName, String sValue) throws MdException, RemoteException {
        this.savePropertyToOMR(omr, mdoAnchor, sSetRole, sName, sName, "OPTION", sValue, 12, 0);
    }

    protected void saveIntOptionToOMR(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sName, int iValue) throws MdException, RemoteException {
        this.savePropertyToOMR(omr, mdoAnchor, sSetRole, sName, sName, "OPTION", Integer.toString(iValue), 4, 0);
    }

    protected void saveBooleanOptionToOMR(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sName, boolean bValue) throws MdException, RemoteException {
        this.savePropertyToOMR(omr, mdoAnchor, sSetRole, sName, sName, "OPTION", Boolean.toString(bValue), 16, 0);
    }

    public void saveQueuesToOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
        Transformation transformation;
        int iQueue;
        IDataObject[] dataTargets = this.getDataTargets();
        IDataObject[] dataSources = this.getDataSources();
        mdoStep.getSourceTransformations(false).clear();
        mdoStep.getTargetTransformations(false).clear();
        for (iQueue = 0; iQueue < dataTargets.length; ++iQueue) {
            if (dataTargets[iQueue].getOMRType() != "Transformation") continue;
            transformation = (Transformation)omr.acquireOMRObject(dataTargets[iQueue].getID(), "Transformation");
            mdoStep.getSourceTransformations(false).add((Object)transformation);
        }
        for (iQueue = 0; iQueue < dataSources.length; ++iQueue) {
            if (dataSources[iQueue].getOMRType() != "Transformation") continue;
            transformation = (Transformation)omr.acquireOMRObject(dataSources[iQueue].getID(), "Transformation");
            mdoStep.getTargetTransformations(false).add((Object)transformation);
        }
    }

    private void loadQueueFromOMR(OMRAdapter omr, TransformationStep mdoStep) throws RemoteException, MdException {
        int i;
        IDataObject[] aIDataObject;
        Transformation mdoTransformation;
        AssociationList lTransformations = mdoStep.getTargetTransformations();
        if (!lTransformations.isEmpty()) {
            mdoTransformation = (Transformation)lTransformations.get(0);
            IDataObject source = (IDataObject)omr.acquireObject((Root)mdoTransformation);
            aIDataObject = this.getDataSources();
            boolean bContainsSource = false;
            for (i = 0; i < aIDataObject.length; ++i) {
                if (aIDataObject[i].getID() != source.getID()) continue;
                bContainsSource = true;
            }
            if (!bContainsSource) {
                this.addDataSource(source);
            }
        }
        if (!(lTransformations = mdoStep.getSourceTransformations()).isEmpty()) {
            mdoTransformation = (Transformation)lTransformations.get(0);
            IDataObject target = (IDataObject)omr.acquireObject((Root)mdoTransformation);
            aIDataObject = this.getDataTargets();
            boolean bContainstarget = false;
            for (i = 0; i < aIDataObject.length; ++i) {
                if (aIDataObject[i].getID() != target.getID()) continue;
                bContainstarget = true;
            }
            if (!bContainstarget) {
                this.addDataTarget(target);
            }
        }
    }

    protected String loadStringOptionFromOMR(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sPropertyName, String sDefaultValue) throws MdException, RemoteException {
        return this.loadPropertyFromOMR(omr, mdoAnchor, sSetRole, sPropertyName, sDefaultValue, 0);
    }

    protected int loadIntOptionFromOMR(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sPropertyName, int iDefaultValue) throws MdException, RemoteException {
        String sValue = this.loadPropertyFromOMR(omr, mdoAnchor, sSetRole, sPropertyName, null, 0);
        if (sValue != null) {
            try {
                return Integer.parseInt(sValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return iDefaultValue;
    }

    protected boolean loadBooleanOptionFromOMR(OMRAdapter omr, Root mdoAnchor, String sSetRole, String sPropertyName, boolean bDefaultValue) throws MdException, RemoteException {
        String sValue = this.loadPropertyFromOMR(omr, mdoAnchor, sSetRole, sPropertyName, null, 0);
        if (sValue != null) {
            return Boolean.valueOf(sValue);
        }
        return bDefaultValue;
    }

    public IMessageQueue getMessageQueue() {
        int iQueue;
        IDataObject[] dataTargets = this.getDataTargets();
        IDataObject[] dataSources = this.getDataSources();
        for (iQueue = 0; iQueue < dataTargets.length; ++iQueue) {
            if (dataTargets[iQueue].getOMRType() != "Transformation") continue;
            return (IMessageQueue)dataTargets[iQueue];
        }
        for (iQueue = 0; iQueue < dataSources.length; ++iQueue) {
            if (dataSources[iQueue].getOMRType() != "Transformation") continue;
            return (IMessageQueue)dataSources[iQueue];
        }
        return null;
    }

    public String getQueueType() {
        return this.m_msgType_Text_Table_File;
    }

    public void setQueueType(String sQueueType) {
        if (this.m_msgType_Text_Table_File.equals(sQueueType)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetQueueTypeUndoable(this.m_msgType_Text_Table_File, sQueueType));
        }
        this.m_msgType_Text_Table_File = sQueueType;
        this.fireModelChangedEvent(QUEUE_TYPE_CHANGED, null);
    }

    public void setQueueTypeAsText() {
        this.setQueueType(TEXT);
    }

    public void setQueueTypeAsTable() {
        this.setQueueType(TABLE);
    }

    public void setQueueTypeAsFile() {
        this.setQueueType(FILE);
    }

    public boolean isTextMessage() {
        return this.getQueueType().compareToIgnoreCase(TEXT) == 0;
    }

    public boolean isTableMessage() {
        return this.getQueueType().compareToIgnoreCase(TABLE) == 0;
    }

    public boolean isFileMessage() {
        return this.getQueueType().compareToIgnoreCase(FILE) == 0;
    }

    public void setMessageLength(int iMsg_Length) {
        if (iMsg_Length == 0) {
            this.m_messageLength = 256;
            return;
        }
        if (this.m_messageLength == iMsg_Length) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMessageLengthUndoable(this.m_messageLength, iMsg_Length));
        }
        this.m_messageLength = iMsg_Length;
        this.fireModelChangedEvent(MSG_LENGTH_CHANGED, null);
    }

    public int getMessageLength() {
        if (this.m_messageLength == 0) {
            this.m_messageLength = 256;
        }
        return this.m_messageLength;
    }

    public void setTextContent(String sText) {
        if (this.m_textContent == null) {
            this.m_textContent = "";
        }
        if (this.m_textContent.equals(sText)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTextContentUndoable(this.m_textContent, sText));
        }
        this.m_textContent = sText;
        this.fireModelChangedEvent(STORED_TEXT_CHANGED, null);
    }

    public String getTextContent() {
        if (this.m_textContent == null) {
            return "";
        }
        return this.m_textContent;
    }

    public void setMacroVariable(String sMacroVariable) {
        if (this.m_macroVariable == null) {
            this.m_macroVariable = "";
        }
        if (this.m_macroVariable.equals(sMacroVariable)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMacroVariableUndoable(this.m_macroVariable, sMacroVariable));
        }
        this.m_macroVariable = sMacroVariable;
        this.fireModelChangedEvent(MACRO_VARIABLE_CHANGED, null);
    }

    public String getMacroVariable() {
        return this.m_macroVariable;
    }

    public void setFileName(String sFilename) {
        if (this.m_fileName == null) {
            this.m_fileName = "";
        }
        if (this.m_fileName.equals(sFilename)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFileNameUndoable(this.m_fileName, sFilename));
        }
        this.m_fileName = sFilename;
        this.fireModelChangedEvent(FILE_NAME_CHANGED, null);
    }

    public String getFileName() {
        if (this.m_fileName == null) {
            return "";
        }
        return this.m_fileName;
    }

    public void setReader(boolean bReader) {
        this.m_reader = bReader;
    }

    public boolean isReader() {
        return this.m_reader;
    }

    public boolean isWriter() {
        return !this.m_reader;
    }

    public void setMQSystem(String sMQSystem) {
        this.m_MQSystem = sMQSystem;
    }

    public String getMQSystem() {
        return this.m_MQSystem;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_messageOptionModel != null) {
            this.m_messageOptionModel.dispose();
            this.m_messageOptionModel = null;
        }
    }

    public final IPromptModel getMessageOptionModel() throws RemoteException, MdException, ServiceException, ServerConnectionException, ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        if (this.m_messageOptionModel == null) {
            this.m_messageOptionModel = this.createMessageOptionModel();
        }
        this.m_messageOptionModel.setSaveValuesAsStrings(true);
        return this.m_messageOptionModel;
    }

    public IPromptDefinitionValue[] getNameValuePairsFromPromptModel() throws RemoteException, ServiceException, ServerConnectionException, FileNotFoundException, MdException, ParserConfigurationException, SAXException, IOException {
        IPromptModel promptModel = this.getMessageOptionModel();
        return promptModel.getPromptDefinitionValues();
    }

    public final IPromptDefinitionValue[] getPromptDefinitionValues() throws RemoteException, MdException, ServiceException, ServerConnectionException, ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        return this.getMessageOptionModel().getPromptDefinitionValues();
    }

    protected IPromptModel createMessageOptionModel() throws RemoteException, MdException, ServiceException, ServerConnectionException, ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        return new BasePromptModel(this.getModel(), this);
    }

    public void loadOptions() {
        this.m_hmUserInput = new HashMap();
        try {
            this.m_hmUserInput = this.loadPromptValuesToHashMap(this.m_hmUserInput);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (ServerConnectionException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_hmUserInput.put("etls_message_length", Integer.toString(this.getMessageLength()));
        this.m_hmUserInput.put("etls_filename", this.getFileName());
        this.m_hmUserInput.put(EMQ_FILEOPTION, this.isFileMessage());
        this.m_hmUserInput.put(EMQ_TABLEOPTION, this.isTableMessage());
        this.m_hmUserInput.put(EMQ_TEXTOPTION, this.isTextMessage());
        if (this.getMessageQueue() != null) {
            IMessageQueue messageQueue = this.getMessageQueue();
            this.m_hmUserInput.put("etls_queuename", messageQueue.getMessageQueueName());
            this.m_hmUserInput.put("etls_queuemanagername", messageQueue.getMQManagerName());
        }
        if (this.isWriter()) {
            this.m_hmUserInput.put("etls_text_message", this.getTextContent());
        } else {
            this.m_hmUserInput.put("etls_macroname", this.getMacroVariable());
        }
    }

    public HashMap getOptions() {
        return this.m_hmUserInput;
    }

    private void addOption(HashMap hashMap, String sName, String sValue) {
        hashMap.put(sName.toUpperCase(), sValue);
        Workspace.getDefaultLogger().debug((Object)("Name = " + sName + "   Value = " + sValue));
    }

    public HashMap loadPromptValuesToHashMap(HashMap hashMap) throws RemoteException, ServiceException, ServerConnectionException, FileNotFoundException, MdException, ParserConfigurationException, SAXException, IOException {
        IPromptDefinitionValue[] promptValues = this.getPromptDefinitionValues();
        for (int iPrompts = 0; iPrompts < promptValues.length; ++iPrompts) {
            String sValue = "";
            if (promptValues[iPrompts].getValue() != null && promptValues[iPrompts].getName().toUpperCase().equals("ADDLOPTIONS")) {
                this.doProcessAddlOptions(hashMap, promptValues[iPrompts].getValue().toString());
                continue;
            }
            if (promptValues[iPrompts].getValue() != null) {
                sValue = promptValues[iPrompts].getValue().toString();
            }
            String sDefaultValue = "";
            if (promptValues[iPrompts].isDefaultValueSet()) {
                sDefaultValue = promptValues[iPrompts].getDefaultValue().toString();
            }
            if (sValue.compareTo(sDefaultValue) == 0) continue;
            this.addOption(hashMap, promptValues[iPrompts].getName(), sValue);
        }
        return hashMap;
    }

    private void doProcessAddlOptions(HashMap hashMap, String sAddlOptions) {
        StringTokenizer st = new StringTokenizer(sAddlOptions, EMQ_DELIMITER);
        ArrayList<String> alNameValue = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            alNameValue.add(st.nextToken());
        }
        for (int iAddlOption = 0; iAddlOption < alNameValue.size(); ++iAddlOption) {
            String sNameValue = (String)alNameValue.get(iAddlOption);
            StringTokenizer st2 = new StringTokenizer(sNameValue, "=");
            int iCounter = 0;
            String sName = "";
            String sValue = "";
            while (st2.hasMoreTokens()) {
                if (iCounter == 0) {
                    sName = st2.nextToken();
                    sName = sName.trim();
                } else if (iCounter == 1) {
                    sValue = st2.nextToken();
                    this.addOption(hashMap, sName, sValue);
                } else {
                    sValue = st2.nextToken();
                }
                ++iCounter;
            }
        }
    }

    public IPhysicalTable getSourceTable() {
        if (this.getSourceTables().length > 0) {
            ITable oSource = this.getSourceTables()[0];
            return (IPhysicalTable)oSource;
        }
        return null;
    }

    public boolean hasSourceTable() {
        return this.getSourceTable() != null;
    }

    public IPhysicalTable getTargetTable() {
        if (this.getTargetTables().length > 0) {
            ITable oTarget = this.getTargetTables()[0];
            return (IPhysicalTable)oTarget;
        }
        return null;
    }

    public boolean hasTargetTable() {
        return this.getTargetTable() != null;
    }

    public IPhysicalTable getConnectedSourceOrTargetTable() {
        if (!this.isReader()) {
            return this.getSourceTable();
        }
        return this.getTargetTable();
    }

    public String getFileCorrespondingToTable(IPhysicalTable oPhysicalTable) {
        ILibrary library = oPhysicalTable.getLibrary();
        if (library == null) {
            return null;
        }
        IDirectory[] oDirectories = library.getDirectories();
        if (oDirectories.length > 0) {
            String sDirectory = oDirectories[0].getDirectoryName();
            String sFilename = oPhysicalTable.getSASTableName();
            StringBuffer sbPath = new StringBuffer();
            sbPath.append(sDirectory);
            if (sDirectory.indexOf("\\") >= 0) {
                sbPath.append("\\");
            } else {
                sbPath.append("/");
            }
            sbPath.append(sFilename);
            sbPath.append(SASFILEEXTENSION);
            return sbPath.toString();
        }
        IFile[] oFiles = library.getFiles();
        if (oFiles.length > 0) {
            return oFiles[0].getFileName();
        }
        return null;
    }

    public void saveColumnFormatsToOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
        Collection values = this.m_mapPropertySetsCA.values();
        MQColumnFormats[] aMQColumnFormats = new MQColumnFormats[values.size()];
        values.toArray(aMQColumnFormats);
        IPhysicalTable oITable = this.getConnectedSourceOrTargetTable();
        IColumn[] aIColumns = null;
        if (oITable != null) {
            aIColumns = this.getConnectedSourceOrTargetTable().getColumns();
        }
        if (oITable == null || aIColumns.length == 0) {
            for (int iColumnFormat = 0; iColumnFormat < aMQColumnFormats.length; ++iColumnFormat) {
                this.deleteMQColumnFormat(aMQColumnFormats[iColumnFormat], omr);
            }
            return;
        }
        HashMap<String, String> m_mapColumns = new HashMap<String, String>();
        for (int iColumn = 0; iColumn < aIColumns.length; ++iColumn) {
            m_mapColumns.put(aIColumns[iColumn].getID(), "");
        }
        for (int iColumnFormat = 0; iColumnFormat < aMQColumnFormats.length; ++iColumnFormat) {
            MQColumnFormats mqColumnFormat = aMQColumnFormats[iColumnFormat];
            if (!m_mapColumns.containsKey(aMQColumnFormats[iColumnFormat].getColumnFQID())) {
                this.deleteMQColumnFormat(aMQColumnFormats[iColumnFormat], omr);
                continue;
            }
            if (!mqColumnFormat.isChanged()) continue;
            mqColumnFormat.modifyMetadata(omr, mdoStep);
        }
    }

    public void deleteMQColumnFormat(MQColumnFormats oMQColumnFormat, OMRAdapter omr) throws RemoteException, MdException {
        if (oMQColumnFormat.getID() != null) {
            omr.deleteOMRObject(oMQColumnFormat.getTypeFQID(), "Property");
        }
        if (oMQColumnFormat.getID() != null) {
            omr.deleteOMRObject(oMQColumnFormat.getLengthFQID(), "Property");
        }
        if (oMQColumnFormat.getID() != null) {
            omr.deleteOMRObject(oMQColumnFormat.getFormatFQID(), "Property");
        }
        if (oMQColumnFormat.getID() != null) {
            omr.deleteOMRObject(oMQColumnFormat.getCustomAssociationFQID(), CUSTOMASSOCIATION);
        }
        if (oMQColumnFormat.getID() != null) {
            omr.deleteOMRObject(oMQColumnFormat.getID(), "PropertySet");
            this.getModel().removeObject(oMQColumnFormat);
        }
        this.m_mapPropertySetsCA.remove(oMQColumnFormat);
    }

    public void loadColumnFormatsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        AssociationList lSets = omr.acquireOMRObject(this).getPropertySets();
        for (int iSet = 0; iSet < lSets.size(); ++iSet) {
            PropertySet mdoSet = (PropertySet)lSets.get(iSet);
            if (mdoSet.getSetRole().compareToIgnoreCase(QUEUE) != 0) continue;
            MQColumnFormats m_MQColumnFormats = new MQColumnFormats(mdoSet.getFQID(), this.getModel());
            m_MQColumnFormats.setPropertySetName(mdoSet.getName());
            AssociationList lProperties = mdoSet.getSetProperties();
            for (int iProperties = 0; iProperties < lProperties.size(); ++iProperties) {
                Property property = (Property)lProperties.get(iProperties);
                if (property.getName().compareTo(QUEUE_MESSAGE_TYPE) == 0) {
                    m_MQColumnFormats.setTypeFQID(property.getFQID());
                    m_MQColumnFormats.setTypeValue(property.getDefaultValue());
                    continue;
                }
                if (property.getName().compareTo(QUEUE_MESSAGE_LENGTH) == 0) {
                    m_MQColumnFormats.setLengthFQID(property.getFQID());
                    m_MQColumnFormats.setLengthValue(property.getDefaultValue());
                    continue;
                }
                if (property.getName().compareTo(QUEUE_MESSAGE_FORMAT) != 0) continue;
                m_MQColumnFormats.setFormatFQID(property.getFQID());
                m_MQColumnFormats.setFormatValue(property.getDefaultValue());
            }
            AssociationList lCustomAssociations = mdoSet.getCustomAssociations();
            if (lCustomAssociations.size() <= 0) continue;
            CustomAssociation oCustomAssociation = (CustomAssociation)lCustomAssociations.get(0);
            m_MQColumnFormats.setCustomAssociationFQID(oCustomAssociation.getFQID());
            m_MQColumnFormats.setCustomAssociationName(oCustomAssociation.getName());
            AssociationList lAssociatedObjects = oCustomAssociation.getAssociatedObjects();
            if (lAssociatedObjects == null || lAssociatedObjects.size() <= 0 || !(lAssociatedObjects.get(0) instanceof Column)) continue;
            Column oColumn = (Column)lAssociatedObjects.get(0);
            m_MQColumnFormats.setColumnFQID(oColumn.getFQID());
            this.addColumnFormatToMap(m_MQColumnFormats, false);
        }
    }

    public void setColumnFormat(String sKey, MQColumnFormats mqColumnFormats) {
        MQColumnFormats m_mqColumnFormats = null;
        if (this.m_mapPropertySetsCA.containsKey(sKey) && (m_mqColumnFormats = (MQColumnFormats)this.m_mapPropertySetsCA.get(sKey)).equals(mqColumnFormats)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetColumnFormatUndoable(m_mqColumnFormats, mqColumnFormats));
        }
        this.m_mapPropertySetsCA.put(sKey, mqColumnFormats);
        this.fireModelChangedEvent(COLUMN_FORMAT_CHANGED, null);
    }

    public List buildMessageColumnsList(IColumn[] aIColumn) {
        ArrayList<String[]> messageList = new ArrayList<String[]>(aIColumn.length);
        for (int i = 0; i < aIColumn.length; ++i) {
            int iType = aIColumn[i].getType();
            String sType = iType == 0 ? "C" : (iType == 1 ? "N" : "?");
            String[] sFormats = this.getColumnMessageFormats(aIColumn[i]);
            ModelLogger.getDefaultLogger().log(Level.INFO.intLevel(), (Object)(aIColumn[i].getName() + "  " + sFormats[2] + "   " + sFormats[1] + "   " + sFormats[0]));
            messageList.add(i, new String[]{aIColumn[i].getName(), sFormats[2], sFormats[1], sFormats[0], aIColumn[i].getFormat(), aIColumn[i].getInformat(), sType});
        }
        return messageList;
    }

    public String[] getColumnMessageFormats(IColumn oColumn) {
        MQColumnFormats m_MQColumnFormats = (MQColumnFormats)this.m_mapPropertySetsCA.get(oColumn.getID());
        String[] queueColumnFormats = new String[]{"", "", "", ""};
        if (m_MQColumnFormats == null) {
            queueColumnFormats[0] = CHAR;
            queueColumnFormats[1] = Integer.toString(oColumn.getLength());
            queueColumnFormats[2] = queueColumnFormats[0] + ",," + queueColumnFormats[1];
            this.addColumnFormats(oColumn, queueColumnFormats[0], queueColumnFormats[1], queueColumnFormats[2]);
        } else {
            queueColumnFormats[0] = m_MQColumnFormats.getTypeValue();
            queueColumnFormats[1] = m_MQColumnFormats.getLengthValue();
            queueColumnFormats[2] = m_MQColumnFormats.getFormatValue();
        }
        return queueColumnFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnMessageFormats(String sColumnFQID, String[] newQueueColumnFormats) {
        MQColumnFormats m_MQColumnFormats = (MQColumnFormats)this.m_mapPropertySetsCA.get(sColumnFQID);
        if (m_MQColumnFormats == null) {
            return;
        }
        String[] oldQueueColumnFormats = new String[]{"", "", "", ""};
        oldQueueColumnFormats[0] = m_MQColumnFormats.getTypeValue();
        oldQueueColumnFormats[1] = m_MQColumnFormats.getLengthValue();
        oldQueueColumnFormats[2] = m_MQColumnFormats.getFormatValue();
        oldQueueColumnFormats[3] = sColumnFQID;
        this.startCompoundUndoable();
        try {
            if (oldQueueColumnFormats[0].compareTo(newQueueColumnFormats[0]) != 0) {
                m_MQColumnFormats.setTypeValue(newQueueColumnFormats[0]);
            }
            if (oldQueueColumnFormats[1].compareTo(newQueueColumnFormats[1]) != 0) {
                m_MQColumnFormats.setLengthValue(newQueueColumnFormats[1]);
            }
            if (oldQueueColumnFormats[2].compareTo(newQueueColumnFormats[2]) != 0) {
                m_MQColumnFormats.setFormatValue(newQueueColumnFormats[2]);
            }
            if (this.isColumnFormatSame(newQueueColumnFormats, oldQueueColumnFormats)) {
                return;
            }
            m_MQColumnFormats.setTypeValue(newQueueColumnFormats[0]);
            m_MQColumnFormats.setLengthValue(newQueueColumnFormats[1]);
            m_MQColumnFormats.setFormatValue(newQueueColumnFormats[2]);
            newQueueColumnFormats[3] = sColumnFQID;
            this.setChanged(true);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private boolean isColumnFormatSame(String[] newVal, String[] oldVal) {
        for (int i = 0; i < 3; ++i) {
            if (newVal[i].compareTo(oldVal[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public void addColumnFormats(IColumn oColumn, String sType, String sLength, String sFormat) {
        MQColumnFormats m_MQColumnFormats = new MQColumnFormats(this.createIDForNewObject(), this.getModel());
        m_MQColumnFormats.createPropertyIds();
        m_MQColumnFormats.setPropertySetName(oColumn.getName());
        m_MQColumnFormats.setCustomAssociationName(oColumn.getName());
        m_MQColumnFormats.setColumnFQID(oColumn.getID());
        m_MQColumnFormats.setTypeValue(sType);
        m_MQColumnFormats.setLengthValue(sLength);
        m_MQColumnFormats.setFormatValue(sFormat);
        this.addColumnFormatToMap(m_MQColumnFormats, true);
        this.fireModelChangedEvent(COLUMN_FORMAT_CHANGED, null);
    }

    public void addColumnFormatToMap(MQColumnFormats mqColumnFormats, boolean bChanged) {
        mqColumnFormats.setChanged(bChanged);
        this.m_mapPropertySetsCA.put(mqColumnFormats.getColumnFQID(), mqColumnFormats);
    }

    public boolean hasAllQueueColumnFormats(ITable oTable) {
        boolean bExistProperties = true;
        IColumn[] aIColumns = oTable.getColumns();
        for (int iColumn = 0; iColumn < aIColumns.length && (bExistProperties = this.hasColumnFormats(aIColumns[iColumn])); ++iColumn) {
        }
        return bExistProperties;
    }

    public boolean hasColumnFormats(IColumn oColumn) {
        return this.m_mapPropertySetsCA.containsKey(oColumn.getID());
    }

    public static String escapeMacroValue(String string) {
        if (!string.startsWith("%str(")) {
            string = string.replaceAll("%", "%%").replaceAll("'", "%'").replaceAll(QUOTE, "%\"").replaceAll("[(]", "%(").replaceAll("[)]", "%)");
        }
        return string;
    }

    public static void textMessageToMacroVariable(CommonQueueTransformModel model, ICodeSegment cgReq) {
        String messageContent = model.getTextContent().toString();
        boolean bHasMacroVar = false;
        if (messageContent.indexOf("&") >= 0) {
            bHasMacroVar = true;
        }
        int iLength = messageContent.length();
        int iSplitLength = 80;
        int iNum = iLength / iSplitLength + 1;
        int startPosn = 0;
        int endPosn = iSplitLength;
        cgReq.addSourceCode("%let ");
        cgReq.addSourceCode(ETLS_MESSAGE_MACRO_VARIABLE);
        cgReq.addSourceCode("=;\n");
        for (int i = 0; i < iNum; ++i) {
            if (endPosn > iLength) {
                endPosn = iLength;
            }
            cgReq.addSourceCode("%let etls_tmp");
            cgReq.addSourceCode(Integer.toString(i));
            cgReq.addSourceCode("=");
            cgReq.addSourceCode("%nrstr(");
            String sThisLine = CommonQueueTransformModel.escapeMacroValue(messageContent.substring(startPosn, endPosn));
            cgReq.addSourceCode(sThisLine);
            cgReq.addSourceCode(");\n");
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(ETLS_MESSAGE_MACRO_VARIABLE);
            cgReq.addSourceCode("=&");
            cgReq.addSourceCode(ETLS_MESSAGE_MACRO_VARIABLE);
            cgReq.addSourceCode("&etls_tmp");
            cgReq.addSourceCode(Integer.toString(i));
            cgReq.addSourceCode(";\n\n");
            endPosn = (startPosn += iSplitLength) + iSplitLength;
        }
        if (bHasMacroVar) {
            cgReq.addSourceCode("data _null_;\n");
            cgReq.addSourceCode("etls_m01=resolve(\"&etls_msg\");\n");
            cgReq.addSourceCode("call symput('etls_msg', etls_m01);\n");
            cgReq.addSourceCode("run;\n");
        }
    }

    public static final String toHexString(long value, int len, char pad) {
        StringBuffer sb = new StringBuffer(Long.toHexString(value));
        int npad = len - sb.length();
        while (npad-- > 0) {
            sb.insert(0, pad);
        }
        return new String(sb);
    }

    public static final String toHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(HexChars[bytes[i] >> 4 & 0xF]);
            sb.append(HexChars[bytes[i] & 0xF]);
        }
        return new String(sb);
    }

    public static final String toHexString(String sToConvert) {
        return CommonQueueTransformModel.toHexString(sToConvert.getBytes());
    }

    public static final String toHexString(String sToConvert, int iLength) {
        StringBuffer sb = new StringBuffer(sToConvert);
        if (sb.length() > iLength) {
            return CommonQueueTransformModel.toHexString(sb.substring(0, iLength).getBytes());
        }
        for (int i = sb.length(); i < iLength; ++i) {
            sb.append(" ");
        }
        return CommonQueueTransformModel.toHexString(sb.toString().getBytes());
    }

    public void setMSMQPromptValuesToModel(HashMap hmPromptValues) {
        String val = hmPromptValues.get("TRANSACTION").toString();
        if (val.compareToIgnoreCase(YES) == 0) {
            this.setTransaction(val);
            this.m_bTransaction = true;
        } else {
            this.setTransaction(val);
            this.m_bTransaction = false;
        }
        val = "";
        if (hmPromptValues.get("LIMIT_READ") != null) {
            val = hmPromptValues.get("LIMIT_READ").toString();
        }
        if (val.length() > 0) {
            this.setDepth(val);
            this.m_bDepth = true;
        }
        if ((val = hmPromptValues.get("OPENMODE").toString()).length() > 0) {
            this.setOpenMode(val);
            this.m_bOpenMode = true;
        } else {
            this.setOpenMode(val);
            this.m_bOpenMode = false;
        }
        val = hmPromptValues.get("OPENATTR").toString();
        if (val.length() > 0) {
            this.setOpenAttr(val);
            this.m_bOpenAttr = true;
        } else {
            this.setOpenAttr(val);
            this.m_bOpenAttr = false;
        }
        val = "";
        if (this.isReader()) {
            val = hmPromptValues.get("MSGID").toString();
        }
        if (val.length() > 0) {
            this.setMsgId(val);
            this.m_bMsgId = true;
        } else {
            this.setMsgId(val);
            this.m_bMsgId = false;
        }
        val = hmPromptValues.get("MQDEBUG").toString();
        if (val.compareToIgnoreCase(YES) == 0) {
            this.setDebug(true);
        } else {
            this.setDebug(false);
        }
        val = hmPromptValues.get("QUEUEPROP").toString();
        this.m_bQueueProps = val.compareToIgnoreCase(YES) == 0;
        val = hmPromptValues.get("MAPSTORE").toString();
        if (val.length() > 0) {
            this.setMapStore(val);
            this.m_bMapStore = true;
        } else {
            this.setMapStore(val);
            this.m_bMapStore = false;
        }
    }

    public boolean isTransaction() {
        return this.m_bTransaction;
    }

    public boolean isQueuePropertiesTurnedOn() {
        return this.m_bQueueProps;
    }

    public String getMapStore() {
        return this.m_sMapStore;
    }

    public void setMapStore(String map) {
        this.m_sMapStore = map;
    }

    public boolean isMapStoreDefined() {
        return this.m_bMapStore;
    }

    public String getTransaction() {
        return this.m_sTransaction;
    }

    public void setTransaction(String val) {
        this.m_sTransaction = val;
    }

    public boolean isMsgId() {
        return this.m_bMsgId;
    }

    public String getMsgId() {
        return this.m_sMsgId;
    }

    public void setMsgId(String val) {
        this.m_sMsgId = val;
    }

    public boolean isDepth() {
        return this.m_bDepth;
    }

    public String getDepth() {
        return this.m_sDepth;
    }

    public void setDepth(String val) {
        this.m_sDepth = val;
    }

    public boolean isOpenMode() {
        return this.m_bOpenMode;
    }

    public String getOpenMode() {
        return this.m_sOpenMode;
    }

    public void setOpenMode(String val) {
        this.m_sOpenMode = val;
    }

    public boolean isDebug() {
        return this.m_bDebug;
    }

    public void setDebug(boolean val) {
        this.m_bDebug = val;
    }

    public boolean isOpenAttr() {
        return this.m_bOpenAttr;
    }

    public String getOpenAttr() {
        return this.m_sOpenAttr;
    }

    public void setOpenAttr(String val) {
        this.m_sOpenAttr = val;
    }

    public void textMessageToMacroVariable(ICodeSegment cgReq) {
        String messageContent = this.getTextContent().toString();
        boolean bHasMacroVar = false;
        if (messageContent.indexOf("&") >= 0) {
            bHasMacroVar = true;
        }
        int iLength = messageContent.length();
        int iSplitLength = 80;
        int iNum = iLength / iSplitLength + 1;
        int startPosn = 0;
        int endPosn = iSplitLength;
        cgReq.addSourceCode("%let ");
        cgReq.addSourceCode(ETLS_MESSAGE_MACRO_VARIABLE);
        cgReq.addSourceCode("=;\n");
        for (int i = 0; i < iNum; ++i) {
            if (endPosn > iLength) {
                endPosn = iLength;
            }
            cgReq.addSourceCode("%let etls_tmp");
            cgReq.addSourceCode(Integer.toString(i));
            cgReq.addSourceCode("=");
            cgReq.addSourceCode("%nrstr(");
            String sThisLine = CommonQueueTransformModel.escapeMacroValue(messageContent.substring(startPosn, endPosn));
            cgReq.addSourceCode(sThisLine);
            cgReq.addSourceCode(");\n");
            cgReq.addSourceCode("%let ");
            cgReq.addSourceCode(ETLS_MESSAGE_MACRO_VARIABLE);
            cgReq.addSourceCode("=&");
            cgReq.addSourceCode(ETLS_MESSAGE_MACRO_VARIABLE);
            cgReq.addSourceCode("&etls_tmp");
            cgReq.addSourceCode(Integer.toString(i));
            cgReq.addSourceCode(";\n\n");
            endPosn = (startPosn += iSplitLength) + iSplitLength;
        }
        if (bHasMacroVar) {
            cgReq.addSourceCode("data _null_;\n");
            cgReq.addSourceCode("etls_m01=resolve(\"&etls_msg\");\n");
            cgReq.addSourceCode("call symput('etls_msg', etls_m01);\n");
            cgReq.addSourceCode("run;\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            this.replaceTableForMessageQueues(oldTable, newTable);
            super.replaceTargetTable(oldTable, newTable, columnsMap);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            this.replaceTableForMessageQueues(oldTable, newTable);
            super.replaceSourceTable(oldTable, newTable, columnsMap);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void replaceTableForMessageQueues(ITable oldTable, ITable newTable) {
        HashMap<String, MQColumnFormats> hmNewColumnFormats = new HashMap<String, MQColumnFormats>();
        IColumn[] aNewTableColumns = newTable.getColumns();
        for (int i = 0; i < aNewTableColumns.length; ++i) {
            IColumn columnFromNewTable = aNewTableColumns[i];
            IColumn columnFromOldTable = this.getColumnFromOldTable(columnFromNewTable, oldTable);
            MQColumnFormats columnFormat = null;
            if (columnFromOldTable != null && (columnFormat = (MQColumnFormats)this.m_mapPropertySetsCA.get(columnFromOldTable.getID())) != null) {
                columnFormat.setColumnFQID(columnFromNewTable.getID());
                columnFormat.setChanged(true);
            }
            if (columnFormat == null) {
                columnFormat = this.createNewColumnFormats(aNewTableColumns[i]);
            }
            hmNewColumnFormats.put(columnFromNewTable.getID(), columnFormat);
        }
        this.m_mapPropertySetsCA.clear();
        this.m_mapPropertySetsCA = hmNewColumnFormats;
    }

    private IColumn getColumnFromOldTable(IColumn newColumn, IDataObject oldTable) {
        IPhysicalTable oTable = null;
        if (!(oldTable instanceof IPhysicalTable)) {
            return null;
        }
        oTable = (IPhysicalTable)oldTable;
        IColumn[] aColumns = oTable.getColumns();
        for (int i = 0; i < aColumns.length; ++i) {
            if (aColumns[i] == null || newColumn == null || aColumns[i].getName().compareToIgnoreCase(newColumn.getName()) != 0 || aColumns[i].getType() != newColumn.getType()) continue;
            return aColumns[i];
        }
        return null;
    }

    public MQColumnFormats createNewColumnFormats(IColumn oColumn) {
        String sType = CHAR;
        String sLength = Integer.toString(oColumn.getLength());
        String sFormat = sType + ",," + sLength;
        MQColumnFormats m_MQColumnFormats = new MQColumnFormats(this.createIDForNewObject(), this.getModel());
        m_MQColumnFormats.createPropertyIds();
        m_MQColumnFormats.setPropertySetName(oColumn.getName());
        m_MQColumnFormats.setCustomAssociationName(oColumn.getName());
        m_MQColumnFormats.setColumnFQID(oColumn.getID());
        m_MQColumnFormats.setTypeValue(sType);
        m_MQColumnFormats.setLengthValue(sLength);
        m_MQColumnFormats.setFormatValue(sFormat);
        this.addColumnFormatToMap(m_MQColumnFormats, true);
        this.fireModelChangedEvent(COLUMN_FORMAT_CHANGED, null);
        return m_MQColumnFormats;
    }

    public class MQColumnFormats
    extends AbstractPersistableObject {
        private String m_sPropertySetName;
        private String m_sColumnFQID;
        private String m_sTypeValue;
        private String m_sLengthValue;
        private String m_sFormatValue;
        private String m_sTypeFQID;
        private String m_sLengthFQID;
        private String m_sFormatFQID;
        private String m_sCustomAssociationFQID;
        private String m_sCustomAssociationName;
        private boolean m_bModified;
        public static final String MESSAGE_TYPE_CHANGED = "QueueTransformModel:MessageTypeChanged";
        public static final String MESSAGE_LENGTH_CHANGED = "QueueTransformModel:MessageLengthChanged";
        public static final String MESSAGE_FORMAT_CHANGED = "QueueTransformModel:MessageFormatChanged";

        public MQColumnFormats(String sPropertySetFQID, IModel model) {
            super(sPropertySetFQID, model);
            this.m_bModified = false;
        }

        @Override
        public void setChanged(boolean bChanged) {
            super.setChanged(bChanged);
        }

        @Override
        protected String getDefaultName() {
            return "MQColumnFormats";
        }

        @Override
        public boolean isChanged() {
            return super.isChanged();
        }

        @Override
        public String toString() {
            return "";
        }

        public void modifyMetadata(OMRAdapter omr, TransformationStep mdoStep) throws RemoteException, MdException {
            PropertySet mdoPropertySet = (PropertySet)omr.acquireOMRObject(this.getID(), "PropertySet");
            mdoPropertySet.setName(this.getPropertySetName());
            mdoPropertySet.setSetRole(CommonQueueTransformModel.QUEUE);
            Property mdoProperty1 = (Property)omr.acquireOMRObject(this.getTypeFQID(), "Property");
            mdoProperty1.setName(this.getTypeName());
            mdoProperty1.setDefaultValue(this.getTypeValue());
            if (mdoProperty1.isNewObject()) {
                mdoPropertySet.getSetProperties(false).add((Object)mdoProperty1);
            }
            Property mdoProperty2 = (Property)omr.acquireOMRObject(this.getLengthFQID(), "Property");
            mdoProperty2.setName(this.getLengthName());
            mdoProperty2.setDefaultValue(this.getLengthValue());
            if (mdoProperty2.isNewObject()) {
                mdoPropertySet.getSetProperties(false).add((Object)mdoProperty2);
            }
            Property mdoProperty3 = (Property)omr.acquireOMRObject(this.getFormatFQID(), "Property");
            mdoProperty3.setName(this.getFormatName());
            mdoProperty3.setDefaultValue(this.getFormatValue());
            if (mdoProperty3.isNewObject()) {
                mdoPropertySet.getSetProperties(false).add((Object)mdoProperty3);
            }
            Column column = (Column)omr.acquireOMRObject(this.getColumnFQID(), "Column");
            CustomAssociation oCustomAssociation = (CustomAssociation)omr.acquireOMRObject(this.getCustomAssociationFQID(), CommonQueueTransformModel.CUSTOMASSOCIATION);
            oCustomAssociation.setName(this.getCustomAssociationName());
            if (oCustomAssociation.isNewObject()) {
                mdoPropertySet.getCustomAssociations(false).add((Object)oCustomAssociation);
            }
            oCustomAssociation.getAssociatedObjects(false).clear();
            oCustomAssociation.getAssociatedObjects(false).add((Object)column);
            if (mdoPropertySet.isNewObject()) {
                mdoStep.getPropertySets().add((Object)mdoPropertySet);
            }
            this.setChanged(false);
        }

        public void createPropertyIds() {
            if (this.getTypeFQID() == null || this.getTypeFQID().length() == 0) {
                this.setTypeFQID(this.createIDForNewObject());
                this.setModified(true);
            }
            if (this.getFormatFQID() == null || this.getFormatFQID().length() == 0) {
                this.setFormatFQID(this.createIDForNewObject());
                this.setModified(true);
            }
            if (this.getLengthFQID() == null || this.getLengthFQID().length() == 0) {
                this.setLengthFQID(this.createIDForNewObject());
                this.setModified(true);
            }
            if (this.getCustomAssociationFQID() == null || this.getCustomAssociationFQID().length() == 0) {
                this.setCustomAssociationFQID(this.createIDForNewObject());
                this.setModified(true);
                this.setChanged(true);
            }
        }

        public String getColumnFQID() {
            if (this.m_sColumnFQID == null || this.m_sColumnFQID.length() == 0) {
                this.setColumnFQID(this.createIDForNewObject());
                this.setModified(true);
            }
            return this.m_sColumnFQID;
        }

        public void setColumnFQID(String columnFQID) {
            this.m_sColumnFQID = columnFQID;
        }

        public String getFormatFQID() {
            if (this.m_sFormatFQID == null || this.m_sFormatFQID.length() == 0) {
                this.setFormatFQID(this.createIDForNewObject());
                this.setModified(true);
            }
            return this.m_sFormatFQID;
        }

        public void setFormatFQID(String formatFQID) {
            this.m_sFormatFQID = formatFQID;
        }

        public String getLengthFQID() {
            if (this.m_sLengthFQID == null || this.m_sLengthFQID.length() == 0) {
                this.setLengthFQID(this.createIDForNewObject());
                this.setModified(true);
            }
            return this.m_sLengthFQID;
        }

        public void setLengthFQID(String lengthFQID) {
            this.m_sLengthFQID = lengthFQID;
        }

        public String getTypeFQID() {
            if (this.m_sTypeFQID == null || this.m_sTypeFQID.length() == 0) {
                this.setTypeFQID(this.createIDForNewObject());
                this.setModified(true);
            }
            return this.m_sTypeFQID;
        }

        public void setTypeFQID(String typeFQID) {
            this.m_sTypeFQID = typeFQID;
        }

        public String getFormatValue() {
            return this.m_sFormatValue;
        }

        public void setTypeValue(String sTypeValue) {
            if (this.m_sTypeValue == null) {
                this.m_sTypeValue = sTypeValue;
                return;
            }
            if (this.m_sTypeValue.equals(sTypeValue)) {
                return;
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetTypeValueUndoable(this.m_sTypeValue, sTypeValue));
            }
            this.m_sTypeValue = sTypeValue;
            this.fireModelChangedEvent(MESSAGE_TYPE_CHANGED, null);
        }

        public void setLengthValue(String sLengthValue) {
            if (this.m_sLengthValue == null) {
                this.m_sLengthValue = sLengthValue;
                return;
            }
            if (this.m_sLengthValue.equals(sLengthValue)) {
                return;
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetLengthValueUndoable(this.m_sLengthValue, sLengthValue));
            }
            this.m_sLengthValue = sLengthValue;
            this.fireModelChangedEvent("QueueTransformModel:MessageLengthChanged", null);
        }

        public void setFormatValue(String sFormatValue) {
            if (this.m_sFormatValue == null) {
                this.m_sFormatValue = sFormatValue;
                return;
            }
            if (this.m_sFormatValue.equals(sFormatValue)) {
                return;
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetFormatValueUndoable(this.m_sFormatValue, sFormatValue));
            }
            this.m_sFormatValue = sFormatValue;
            this.fireModelChangedEvent(MESSAGE_FORMAT_CHANGED, null);
        }

        public String getLengthValue() {
            return this.m_sLengthValue;
        }

        public String getPropertySetName() {
            return this.m_sPropertySetName;
        }

        public void setPropertySetName(String propertySetName) {
            this.m_sPropertySetName = propertySetName.indexOf(sPrefix) >= 0 ? propertySetName : sPrefix + propertySetName;
        }

        public String getTypeValue() {
            return this.m_sTypeValue;
        }

        public String getTypeName() {
            return CommonQueueTransformModel.QUEUE_MESSAGE_TYPE;
        }

        public String getLengthName() {
            return CommonQueueTransformModel.QUEUE_MESSAGE_LENGTH;
        }

        public String getFormatName() {
            return CommonQueueTransformModel.QUEUE_MESSAGE_FORMAT;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof MQColumnFormats)) {
                return false;
            }
            MQColumnFormats mqColumnFormats = (MQColumnFormats)obj;
            return mqColumnFormats.getTypeValue().equals(this.getTypeValue()) && mqColumnFormats.getLengthValue().equals(this.getLengthValue()) && mqColumnFormats.getFormatValue().equals(this.getFormatValue());
        }

        @Override
        public int hashcode() {
            return super.hashCode();
        }

        @Override
        public String getOMRType() {
            return "PropertySet";
        }

        public boolean isModified() {
            return this.m_bModified;
        }

        public void setModified(boolean modified) {
            this.m_bModified = modified;
        }

        public String getCustomAssociationFQID() {
            return this.m_sCustomAssociationFQID;
        }

        public void setCustomAssociationFQID(String customAssociationFQID) {
            this.m_sCustomAssociationFQID = customAssociationFQID;
        }

        public String getCustomAssociationName() {
            return this.m_sCustomAssociationName;
        }

        public void setCustomAssociationName(String customAssociationName) {
            this.m_sCustomAssociationName = customAssociationName.indexOf(sPrefix) >= 0 ? customAssociationName : sPrefix + customAssociationName;
        }

        private class SetFormatValueUndoable
        extends AbstractUndoableEdit {
            private String m_oldFormatValue;
            private String m_newFormatValue;

            public SetFormatValueUndoable(String oldFormatValue, String newFormatValue) {
                this.m_oldFormatValue = oldFormatValue;
                this.m_newFormatValue = newFormatValue;
            }

            @Override
            public void undo() {
                super.undo();
                MQColumnFormats.this.setFormatValue(this.m_oldFormatValue);
            }

            @Override
            public void redo() {
                super.redo();
                MQColumnFormats.this.setFormatValue(this.m_newFormatValue);
            }
        }

        private class SetLengthValueUndoable
        extends AbstractUndoableEdit {
            private String m_oldLengthValue;
            private String m_newLengthValue;

            public SetLengthValueUndoable(String oldLengthValue, String newLengthValue) {
                this.m_oldLengthValue = oldLengthValue;
                this.m_newLengthValue = newLengthValue;
            }

            @Override
            public void undo() {
                super.undo();
                MQColumnFormats.this.setLengthValue(this.m_oldLengthValue);
            }

            @Override
            public void redo() {
                super.redo();
                MQColumnFormats.this.setLengthValue(this.m_newLengthValue);
            }
        }

        private class SetTypeValueUndoable
        extends AbstractUndoableEdit {
            private String m_oldTypeValue;
            private String m_newTypeValue;

            public SetTypeValueUndoable(String oldTypeValue, String newTypeValue) {
                this.m_oldTypeValue = oldTypeValue;
                this.m_newTypeValue = newTypeValue;
            }

            @Override
            public void undo() {
                super.undo();
                MQColumnFormats.this.setTypeValue(this.m_oldTypeValue);
            }

            @Override
            public void redo() {
                super.redo();
                MQColumnFormats.this.setTypeValue(this.m_newTypeValue);
            }
        }
    }

    private class SetMacroVariableUndoable
    extends AbstractUndoableEdit {
        private String m_oldMacroVariable;
        private String m_newMacroVariable;

        public SetMacroVariableUndoable(String oldMacroVariable, String newMacroVariable) {
            this.m_oldMacroVariable = oldMacroVariable;
            this.m_newMacroVariable = newMacroVariable;
        }

        @Override
        public void undo() {
            super.undo();
            CommonQueueTransformModel.this.setMacroVariable(this.m_oldMacroVariable);
        }

        @Override
        public void redo() {
            super.redo();
            CommonQueueTransformModel.this.setMacroVariable(this.m_newMacroVariable);
        }
    }

    private class SetFileNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldFileName;
        private String m_newFileName;

        public SetFileNameUndoable(String oldFileName, String newFileName) {
            this.m_oldFileName = oldFileName;
            this.m_newFileName = newFileName;
        }

        @Override
        public void undo() {
            super.undo();
            CommonQueueTransformModel.this.setFileName(this.m_oldFileName);
        }

        @Override
        public void redo() {
            super.redo();
            CommonQueueTransformModel.this.setFileName(this.m_newFileName);
        }
    }

    private class SetTextContentUndoable
    extends AbstractUndoableEdit {
        private String m_oldTextContent;
        private String m_newTextContent;

        public SetTextContentUndoable(String oldTextContent, String newTextContent) {
            this.m_oldTextContent = oldTextContent;
            this.m_newTextContent = newTextContent;
        }

        @Override
        public void undo() {
            super.undo();
            CommonQueueTransformModel.this.setTextContent(this.m_oldTextContent);
        }

        @Override
        public void redo() {
            super.redo();
            CommonQueueTransformModel.this.setTextContent(this.m_newTextContent);
        }
    }

    private class SetMessageLengthUndoable
    extends AbstractUndoableEdit {
        private int m_oldMessageLength;
        private int m_newMessageLength;

        public SetMessageLengthUndoable(int oldMessageLength, int newMessageLength) {
            this.m_oldMessageLength = oldMessageLength;
            this.m_newMessageLength = newMessageLength;
        }

        @Override
        public void undo() {
            super.undo();
            CommonQueueTransformModel.this.setMessageLength(this.m_oldMessageLength);
        }

        @Override
        public void redo() {
            super.redo();
            CommonQueueTransformModel.this.setMessageLength(this.m_newMessageLength);
        }
    }

    private class SetQueueTypeUndoable
    extends AbstractUndoableEdit {
        private String m_oldQueueType;
        private String m_newQueueType;

        public SetQueueTypeUndoable(String oldQueueType, String newQueueType) {
            this.m_oldQueueType = oldQueueType;
            this.m_newQueueType = newQueueType;
        }

        @Override
        public void undo() {
            super.undo();
            CommonQueueTransformModel.this.setQueueType(this.m_oldQueueType);
        }

        @Override
        public void redo() {
            super.redo();
            CommonQueueTransformModel.this.setQueueType(this.m_newQueueType);
        }
    }

    private class SetColumnFormatUndoable
    extends AbstractUndoableEdit {
        private MQColumnFormats m_oldColumnFormat;
        private MQColumnFormats m_newColumnFormat;

        public SetColumnFormatUndoable(MQColumnFormats oldColumnFormat, MQColumnFormats newColumnFormat) {
            this.m_oldColumnFormat = oldColumnFormat;
            this.m_newColumnFormat = newColumnFormat;
        }

        @Override
        public void undo() {
            super.undo();
            CommonQueueTransformModel.this.setColumnFormat(this.m_oldColumnFormat.getColumnFQID(), this.m_oldColumnFormat);
        }

        @Override
        public void redo() {
            super.redo();
            CommonQueueTransformModel.this.setColumnFormat(this.m_newColumnFormat.getColumnFQID(), this.m_newColumnFormat);
        }
    }

    private class SetColumnFormatValuesUndoable
    extends AbstractUndoableEdit {
        private String m_sColumnFQID;
        private String[] m_oldColumnFormat;
        private String[] m_newColumnFormat;

        public SetColumnFormatValuesUndoable(String sColumnFQID, String[] newColumnFormat, String[] oldColumnFormat) {
            this.m_sColumnFQID = sColumnFQID;
            this.m_oldColumnFormat = oldColumnFormat;
            this.m_newColumnFormat = newColumnFormat;
        }

        @Override
        public void undo() {
            super.undo();
            CommonQueueTransformModel.this.setColumnMessageFormats(this.m_sColumnFQID, this.m_oldColumnFormat);
        }

        @Override
        public void redo() {
            super.redo();
            CommonQueueTransformModel.this.setColumnMessageFormats(this.m_sColumnFQID, this.m_newColumnFormat);
        }
    }
}

