/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.miningresults.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IRelationalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.miningresults.IMiningResult;
import com.sas.etl.models.job.transforms.miningresults.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MiningResult;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class MiningResultsTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.MiningResults";
    private static final String TRANSFORMATION_ROLE = "com.sas.wadmin.visuals.MiningResults";
    private static final String ARM_DISPLAY_NAME = "ModelScoring";
    private static final String GEN_MODEL_KEY = "Generated ModelKey Column";
    private static final String GEN_DATE_TIME = "Generated DateTime Column";
    private static final String GEN_DATE = "Generated Date Column";
    public static final String MINING_RESULT_CHANGED = "MiningResultTransformModel:MiningResultChanged";
    private static final String MiningResults_OPTIONS = "ModelScoring";
    private static final String CM_NAME = "ModelScoring";
    private IMiningResult m_oMiningResult;
    private IPhysicalTable m_generatedTable;

    public MiningResultsTransformModel(String sID, IModel model) {
        super(sID, model);
    }

    public static String getTransformTypeID() {
        return "com.sas.wadmin.visuals.MiningResults";
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.wadmin.visuals.MiningResults";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.wadmin.visuals.MiningResults";
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("MiningResultsTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("MiningResultsTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return "ModelScoring";
    }

    @Override
    public void addDefaultSettings() {
        this.addNewWorkTable();
    }

    @Override
    public boolean isChanged() {
        return super.isChanged();
    }

    @Override
    public ITable[] getTargetTables() {
        if (this.m_oMiningResult == null) {
            return new ITable[0];
        }
        IRelationalTable miningTable = this.m_oMiningResult.getInputTable();
        if (miningTable != null) {
            return new ITable[]{miningTable};
        }
        return new ITable[0];
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.getMiningResult() != null;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.getMiningResult() == null) {
            lReasons.add(RB.getStringResource("MiningResultsTransformModel.ReasonIncomplete.NoMiningResultSelected.txt"));
        }
        return lReasons;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        if (this.m_generatedTable != null) {
            this.getDeletedObjects().add(this.m_generatedTable);
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        mdoCM.setTransformRole("ModelScoring");
        AssociationList lSourceSpecifications = mdoCM.getSourceSpecifications();
        lSourceSpecifications.clear();
        if (this.m_oMiningResult != null) {
            this.m_oMiningResult.saveToOMR(omr);
            MiningResult mdoResult = (MiningResult)omr.acquireOMRObject(this.m_oMiningResult);
            lSourceSpecifications.add(mdoResult);
        }
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        AssociationList lSourceSpecs = mdoCM.getSourceSpecifications();
        for (int iSource = 0; iSource < lSourceSpecs.size(); ++iSource) {
            if (!(lSourceSpecs.get(iSource) instanceof MiningResult)) continue;
            this.m_oMiningResult = (IMiningResult)omr.acquireObject((Root)lSourceSpecs.get(iSource));
            this.m_oMiningResult.loadFromOMR(omr);
        }
        this.setChanged(false);
    }

    private IColumn findColumnInList(List lColumns, IColumn oColumn) {
        int nColumns = lColumns.size();
        for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
            IColumn oRequiredColumn = (IColumn)lColumns.get(iColumn);
            if (!oColumn.getColumnName(false).equals(oRequiredColumn.getColumnName(false)) || oColumn.getType() != oRequiredColumn.getType() || oColumn.getLength() != oRequiredColumn.getLength()) continue;
            return oRequiredColumn;
        }
        return null;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        if (this.getMiningResult() == null) {
            return codeSegment;
        }
        if (!this.getMiningResult().getSourceCodeType().equalsIgnoreCase("SAS Program")) {
            IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
            IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
            String sourceCode = null;
            IRelationalTable mappingTarget = null;
            IMiningResult miningResult = this.getMiningResult();
            mappingTarget = miningResult.getInputTable();
            sourceCode = miningResult.getSourceCode();
            ArrayList<IColumn> lMapSourceColumns = new ArrayList<IColumn>();
            IColumn[] aSourceColumns = source.getColumns();
            ArrayList<IColumn> lTargetColumns = new ArrayList<IColumn>();
            lTargetColumns.addAll(Arrays.asList(target.getColumns()));
            ArrayList<IColumn> lRequiredSourceColumns = new ArrayList<IColumn>();
            lRequiredSourceColumns.addAll(Arrays.asList(mappingTarget.getColumns()));
            for (int iSourceColumn = 0; iSourceColumn < source.getColumnCount(); ++iSourceColumn) {
                IColumn oRequiredColumn;
                IColumn sourceColumn = aSourceColumns[iSourceColumn];
                IColumn oTargetColumn = this.findColumnInList(lTargetColumns, sourceColumn);
                if (oTargetColumn == null || (oRequiredColumn = this.findColumnInList(lRequiredSourceColumns, sourceColumn)) != null) continue;
                lMapSourceColumns.add(oTargetColumn);
            }
            boolean bMappingNeeded = false;
            String mappingStepOutputName = "";
            if (source != null && mappingTarget != null) {
                bMappingNeeded = this.isMappingNeeded(codeSegment.isQuoting(), source, mappingTarget, null, true);
            }
            if (bMappingNeeded) {
                mappingStepOutputName = codeSegment.getUniqueWorkTableName(true, 0);
                this.getOrdinaryMappingCode(codeSegment, source, mappingTarget, mappingStepOutputName, "&SYSLAST", this.getTableOptionObject(source, true).getTableOptions(codeSegment.getCurrentServer()), null, true, true, true, lMapSourceColumns.toArray(new IColumn[lMapSourceColumns.size()]), null, false, null, null, null);
            }
            IColumn[] columns = target.getColumns();
            String keepColumns = codeSegment.makeColumnList(columns, "   ", codeSegment.isQuoting(), " ");
            StringBuffer extraColumnsList = new StringBuffer();
            for (int iColumn = 0; iColumn < columns.length; ++iColumn) {
                IColumn column = columns[iColumn];
                String colName = column.getName();
                String colDesc = column.getDescription();
                if (colDesc.equals(GEN_MODEL_KEY)) {
                    String sKeyForCodeGen = miningResult.getModelKey();
                    if (sKeyForCodeGen == null || sKeyForCodeGen.length() == 0) {
                        sKeyForCodeGen = miningResult.getKey();
                    }
                    if (sKeyForCodeGen == null || sKeyForCodeGen.length() <= 0) continue;
                    extraColumnsList.append("length ").append(colName).append(" $").append(Integer.toString(column.getLength())).append(";\n");
                    extraColumnsList.append(colName).append(" = \"").append(sKeyForCodeGen).append("\";\n");
                    continue;
                }
                if (colDesc.equals(GEN_DATE_TIME)) {
                    extraColumnsList.append(colName).append(" = ").append("datetime();\n");
                    continue;
                }
                if (!colDesc.equals(GEN_DATE)) continue;
                extraColumnsList.append(colName).append(" = ").append("date();\n");
            }
            this.genTableDelete(codeSegment, target);
            codeSegment.addSourceCode("data ").addSourceCode(target.getFullNameQuotedAsNeeded(codeSegment)).addSourceCode("\n").addSourceCode("        (keep = ").addSourceCode(keepColumns);
            String targetTableOptions = this.getTableOptionObject(target, false).getTableOptions(codeSegment.getCurrentServer());
            if (targetTableOptions.length() > 0) {
                codeSegment.addSourceCode("\n").addSourceCode("         ").addSourceCode(targetTableOptions);
            }
            codeSegment.addSourceCode(") \n");
            if (target.isView()) {
                codeSegment.addSourceCode("    / view = ").addSourceCode(target.getFullNameQuotedAsNeeded(codeSegment));
            }
            codeSegment.addSourceCode("; \n\n");
            codeSegment.addSourceCode("set &SYSLAST");
            ITransformTableOptions sourceTableOptionsObject = this.getTableOptionObject(source, true);
            if (sourceTableOptionsObject.getTableOptions(codeSegment.getCurrentServer()).length() > 0) {
                codeSegment.addSourceCode(" ").addSourceCode(sourceTableOptionsObject.getTableOptions(true, codeSegment.getCurrentServer()));
            }
            codeSegment.addSourceCode("; \n\n");
            codeSegment.addSourceCode(extraColumnsList.toString()).addSourceCode("\n");
            if (miningResult.getSourceCode() != null) {
                codeSegment.addSourceCode(miningResult.getSourceCode());
            }
            codeSegment.unIndent().addSourceCode("\n").addSourceCode("run; \n\n");
            if (bMappingNeeded && !target.isView()) {
                codeSegment.genTableDelete(mappingStepOutputName);
            }
        } else {
            IPhysicalTable target;
            IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
            if (source != null) {
                codeSegment.addSourceCode("%let _INPUT = ").addSourceCode(source.getFullNameQuotedAsNeeded(codeSegment)).addSourceCode(";\n");
            }
            if ((target = (IPhysicalTable)this.getDataTargets()[0]) != null) {
                codeSegment.addSourceCode("%let _OUTPUT = ").addSourceCode(target.getFullNameQuotedAsNeeded(codeSegment)).addSourceCode(";\n\n");
            }
            if (this.getMiningResult().getSourceCode() != null) {
                codeSegment.addSourceCode(this.getMiningResult().getSourceCode());
            }
        }
        codeSegment.genRCSetCall("&syserr");
        return codeSegment;
    }

    public IMiningResult getMiningResult() {
        return this.m_oMiningResult;
    }

    public void setMiningResult(IMiningResult miningResult) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new ChangeMiningResultUndoable(miningResult));
        }
        this.m_oMiningResult = miningResult;
        this.fireModelChangedEvent(MINING_RESULT_CHANGED, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            this.removeDataTarget(oldTable);
            this.addDataTarget(newTable);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public ITable createGeneratedColumnsTable(String sModelKey) {
        IPhysicalTable oTable = this.getModel().getObjectFactory().createNewPhysicalTable(this.getID());
        oTable.setName("Generated Columns");
        IColumn oDate = this.getModel().getObjectFactory().createNewColumn(this.getID());
        oDate.setLength(8);
        oDate.setName("Date");
        oDate.setDescription(GEN_DATE);
        oDate.setType(1);
        oDate.setFormat("MMDDYY10.");
        IColumn oDateTime = this.getModel().getObjectFactory().createNewColumn(this.getID());
        oDateTime.setLength(8);
        oDateTime.setName("DateTime");
        oDateTime.setDescription(GEN_DATE_TIME);
        oDateTime.setType(1);
        oDateTime.setFormat("DATETIME20.");
        IColumn oModelKey = this.getModel().getObjectFactory().createNewColumn(this.getID());
        oModelKey.setLength(36);
        oModelKey.setName("ModelKey");
        oModelKey.setDescription(GEN_MODEL_KEY);
        oModelKey.setType(0);
        oModelKey.setFormat("$36.");
        oTable.addColumn(oDate);
        oTable.addColumn(oDateTime);
        oTable.addColumn(oModelKey);
        this.m_generatedTable = oTable;
        return oTable;
    }

    private class ChangeMiningResultUndoable
    extends AbstractUndoableEdit {
        private IMiningResult m_oldMiningResult;
        private IMiningResult m_newMiningResult;

        public ChangeMiningResultUndoable(IMiningResult MiningResult2) {
            this.m_oldMiningResult = MiningResultsTransformModel.this.getMiningResult();
            this.m_newMiningResult = MiningResult2;
        }

        @Override
        public void undo() {
            super.undo();
            MiningResultsTransformModel.this.setMiningResult(this.m_oldMiningResult);
        }

        @Override
        public void redo() {
            super.redo();
            MiningResultsTransformModel.this.setMiningResult(this.m_newMiningResult);
        }

        @Override
        public void die() {
            this.m_newMiningResult = null;
            this.m_oldMiningResult = null;
        }
    }
}

