/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.lookup;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingRule;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.lookup.LookupCodegen;
import com.sas.etl.models.job.transforms.lookup.LookupMapping;
import com.sas.etl.models.job.transforms.lookup.LookupPortDescriptionModel;
import com.sas.etl.models.job.transforms.lookup.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.PromptDataProvider;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.PrototypeProperty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class LookupTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.lookup.Lookup";
    private static final String TRANSFORMATION_ROLE = "com.sas.wadmin.transforms.lookup.Lookup";
    private static final String ARM_DISPLAY_NAME = "Lookup";
    private static final String SOURCE_TABLE = "SourceTable";
    private static final String TARGET_TABLE = "TargetTable";
    private static final String ERROR_TABLE = "ErrorTable";
    private static final String EXCEPTION_TABLE = "ExceptionTable";
    private static final String ERROR_LIMIT_OPTION = "Error Limit";
    private static final String ERROR_LIMIT_ACTION_OPTION = "Error Limit Action";
    private static final String TECHNIQUE_OPTION = "Lookup Technique";
    public static final String ERROR_LIMIT_ACTION_ABORTJOB = "Abort_the_job";
    public static final String ERROR_LIMIT_ACTION_ABORTSTEP = "Abort_the_step";
    public static final String ERROR_LIMIT_ACTION_IGNORE = "Ignore_all_remaining_errors";
    public static final String TECHNIQUE_HASH_TABLE = "HASH_TABLE";
    public static final String TECHNIQUE_SET_KEY = "SET_KEY";
    public static final String DEFAULT_TECHNIQUE = "HASH_TABLE";
    public static final String LOOKUP_MAPPINGS_CHANGED = "LookupTransform:LookupMappingChanged";
    public static final String ERROR_LIMIT_CHANGED = "LookupTransform:ErrorLimitChanged";
    public static final String ERROR_LIMIT_ACTION_CHANGED = "LookupTransform:ErrorLimitActionChanged";
    public static final String TECHNIQUE_OPTION_CHANGED = "LookupTransform:ErrorLimitActionChanged";
    private static final int SOURCE_PORT = 0;
    private static final int TARGET_PORT = 0;
    private static final int ERROR_PORT = 1;
    private static final int EXCEPTION_PORT = 2;
    private List m_lInputPortDescriptions = new ArrayList();
    private List m_lOutputPortDescriptions = new ArrayList();
    private IPhysicalTable m_sourceTable;
    private IPhysicalTable m_targetTable;
    private IPhysicalTable m_errorTable;
    private IPhysicalTable m_exceptionTable;
    private int m_iErrorLimit = -1;
    private String m_sLookupTechnique = "HASH_TABLE";
    private String m_sErrorLimitAction = "Abort_the_job";
    private ITransformTableOptions m_srcTransformTableOptions;
    private ITransformTableOptions m_targetTransformTableOptions;
    private ITransformTableOptions m_errorTransformTableOptions;
    private ITransformTableOptions m_excTransformTableOptions;

    public LookupTransformModel(String sID, IModel model) {
        super(sID, model);
        this.addDefaultOutputPorts();
    }

    @Override
    public void addDefaultSettings() {
        boolean bUndoSupported = this.isUndoSupported();
        this.getModel().setUndoSupported(false);
        try {
            this.addInput();
            this.addInput();
        }
        finally {
            this.getModel().setUndoSupported(bUndoSupported);
        }
        this.m_targetTable = this.addNewWorkTable();
    }

    private void addDefaultOutputPorts() {
        LookupPortDescriptionModel targetPortDesc = new LookupPortDescriptionModel();
        targetPortDesc.setName(RB.getStringResource("LookupTransformModel.OutputPortName.txt"));
        targetPortDesc.setTooltipText(RB.getStringResource("LookupTransformModel.OutputPortText.txt"));
        this.m_lOutputPortDescriptions.add(targetPortDesc);
        LookupPortDescriptionModel errorPortDesc = new LookupPortDescriptionModel();
        errorPortDesc.setName(RB.getStringResource("LookupTransformModel.ErrorPortName.txt"));
        errorPortDesc.setTooltipText(RB.getStringResource("LookupTransformModel.ErrorPortText.txt"));
        this.m_lOutputPortDescriptions.add(errorPortDesc);
        LookupPortDescriptionModel exceptionPortDesc = new LookupPortDescriptionModel();
        exceptionPortDesc.setName(RB.getStringResource("LookupTransformModel.ExceptionPortName.txt"));
        exceptionPortDesc.setTooltipText(RB.getStringResource("LookupTransformModel.ExceptionPortText.txt"));
        this.m_lOutputPortDescriptions.add(exceptionPortDesc);
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("LookupTranformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("LookupTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    public LookupPortDescriptionModel[] getInputPortDescriptions() {
        return this.m_lInputPortDescriptions.toArray(new LookupPortDescriptionModel[this.m_lInputPortDescriptions.size()]);
    }

    public List getInputPortDescriptionList() {
        return this.m_lInputPortDescriptions;
    }

    public LookupPortDescriptionModel[] getOutputPortDescriptions() {
        return this.m_lOutputPortDescriptions.toArray(new LookupPortDescriptionModel[this.m_lOutputPortDescriptions.size()]);
    }

    public List getOutputPortDescriptionList() {
        return this.m_lOutputPortDescriptions;
    }

    @Override
    public int getMaximumDataSourceCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaximumDataTargetCount() {
        return 3;
    }

    @Override
    public void addDataSource(int iSource, IDataObject source) {
    }

    private void addDataSource(LookupPortDescriptionModel portDesc, IDataObject source) {
        if (portDesc != null && portDesc.getObject() != source) {
            portDesc.setObject(source);
            this.addDataSourceImpl(source);
        }
    }

    private void addDataSourceImpl(IDataObject source) {
        if (!source.containsInConsumerTransforms(this)) {
            source.addConsumerTransform(this);
            source.addNotifyListener(this);
        }
    }

    @Override
    public void removeDataSource(IDataObject source) {
    }

    private void removeDataSource(LookupPortDescriptionModel portDesc, IDataObject source) {
        if (portDesc != null && portDesc.getObject() == source) {
            portDesc.setObject(null);
            this.removeDataSourceImpl(source);
        }
    }

    private void removeDataSourceImpl(IDataObject source) {
        if (source.containsInConsumerTransforms(this) && !this.isSourceAttachedToMultipleInputPorts(source)) {
            source.removeConsumerTransform(this);
            source.removeNotifyListener(this);
            if (!this.getModel().isUndoing()) {
                this.removeSourceTableFromMappings((ITable)source);
            }
        }
    }

    @Override
    public IDataObject[] getDataSources() {
        List lSources = this.getDataSourceList();
        return lSources.toArray(new IDataObject[lSources.size()]);
    }

    @Override
    public List getDataSourceList() {
        LinkedHashSet<IPhysicalTable> sourceSet = new LinkedHashSet<IPhysicalTable>();
        if (this.m_sourceTable != null) {
            sourceSet.add(this.m_sourceTable);
        }
        sourceSet.addAll(this.getUniqueLookupTables());
        return new ArrayList(sourceSet);
    }

    @Override
    public boolean containsInDataSources(IDataObject source) {
        return this.getDataSourceList().contains(source);
    }

    @Override
    public int getDataSourcesCount() {
        return this.getDataSourceList().size();
    }

    @Override
    public void addDataTarget(int iTarget, IDataObject target) {
    }

    private void addDataTarget(LookupPortDescriptionModel portDesc, IDataObject target) {
        if (portDesc != null && portDesc.getObject() != target) {
            portDesc.setObject(target);
            this.addDataTargetImpl(target);
        }
    }

    private void addDataTargetImpl(IDataObject target) {
        if (!target.containsInProducerTransforms(this)) {
            target.addProducerTransform(this);
            target.addNotifyListener(this);
            if (target instanceof IWorkTable) {
                this.removeFromDeletedObjects(target);
                this.updateTargetLibrary((IWorkTable)target);
            }
        }
    }

    @Override
    public void removeDataTarget(IDataObject target) {
    }

    private void removeDataTarget(LookupPortDescriptionModel portDesc, IDataObject target) {
        if (portDesc != null && portDesc.getObject() == target) {
            portDesc.setObject(null);
            this.removeDataTargetImpl(target);
        }
    }

    private void removeDataTargetImpl(IDataObject target) {
        if (target.containsInProducerTransforms(this) && !this.isTargetAttachedToMultipleOutputPorts(target)) {
            target.removeProducerTransform(this);
            target.removeNotifyListener(this);
            if (!this.getModel().isUndoing()) {
                this.removeTargetTableFromMappings((ITable)target);
            }
            if (target instanceof IWorkTable) {
                this.addToDeletedObjects(target);
            }
        }
    }

    @Override
    public IDataObject[] getDataTargets() {
        List lTargets = this.getDataTargetList();
        return lTargets.toArray(new IDataObject[lTargets.size()]);
    }

    @Override
    public List getDataTargetList() {
        LinkedHashSet<IPhysicalTable> targetSet = new LinkedHashSet<IPhysicalTable>(3);
        if (this.m_targetTable != null) {
            targetSet.add(this.m_targetTable);
        }
        if (this.m_errorTable != null) {
            targetSet.add(this.m_errorTable);
        }
        if (this.m_exceptionTable != null) {
            targetSet.add(this.m_exceptionTable);
        }
        return new ArrayList(targetSet);
    }

    @Override
    public boolean containsInDataTargets(IDataObject target) {
        return this.getDataTargetList().contains(target);
    }

    @Override
    public int getDataTargetsCount() {
        return this.getDataTargetList().size();
    }

    private boolean isSourceAttachedToMultipleInputPorts(IDataObject source) {
        if (source == null) {
            return false;
        }
        int iCount = 0;
        if (this.m_sourceTable == source) {
            ++iCount;
        }
        List lLookupTables = this.getLookupTables();
        for (int iLookupTable = 0; iLookupTable < lLookupTables.size(); ++iLookupTable) {
            if (source != lLookupTables.get(iLookupTable)) continue;
            ++iCount;
        }
        return iCount > 1;
    }

    private boolean isTargetAttachedToMultipleOutputPorts(IDataObject target) {
        if (target == null) {
            return false;
        }
        int iCount = 0;
        if (this.m_targetTable == target) {
            ++iCount;
        }
        if (this.m_errorTable == target) {
            ++iCount;
        }
        if (this.m_exceptionTable == target) {
            ++iCount;
        }
        return iCount > 1;
    }

    @Override
    public ITransformTableOptions[] getTableOptionObjects() {
        ArrayList<ITransformTableOptions> tOptions = new ArrayList<ITransformTableOptions>();
        tOptions.addAll(Arrays.asList(super.getTableOptionObjects()));
        List maps = this.getLookupMappings();
        for (int i = 0; i < maps.size(); ++i) {
            LookupMapping map = (LookupMapping)maps.get(i);
            if (map.getTransformTableOption() == null) continue;
            tOptions.add(map.getTransformTableOption());
        }
        return tOptions.toArray(new ITransformTableOptions[tOptions.size()]);
    }

    public ITransformTableOptions getSourceTableOptions() {
        return this.m_srcTransformTableOptions;
    }

    public ITransformTableOptions getTargetTableOptions() {
        return this.m_targetTransformTableOptions;
    }

    public ITransformTableOptions getErrorTableOptions() {
        return this.m_errorTransformTableOptions;
    }

    public ITransformTableOptions getExceptionTableOptions() {
        return this.m_excTransformTableOptions;
    }

    public void setSourceTable(IPhysicalTable newSourceTable) {
        this.setSourceTable(newSourceTable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceTable(IPhysicalTable newSourceTable, boolean createOptions) {
        if (this.m_sourceTable == null ? newSourceTable == null : this.m_sourceTable.equals(newSourceTable)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IPhysicalTable oldSourceTable = this.m_sourceTable;
            this.m_sourceTable = newSourceTable;
            LookupPortDescriptionModel portDesc = (LookupPortDescriptionModel)this.m_lInputPortDescriptions.get(0);
            if (createOptions) {
                this.setSourceTableOptions(oldSourceTable, newSourceTable);
            }
            if (oldSourceTable != null) {
                this.removeDataSource(portDesc, oldSourceTable);
                this.fireModelChangedEvent("DataTransform.DataSourceRemoved", oldSourceTable, new Integer(1));
            }
            if (newSourceTable != null) {
                this.addDataSource(portDesc, (IDataObject)newSourceTable);
                this.fireModelChangedEvent("DataTransform.DataSourceAdded", newSourceTable, new Integer(1));
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetSourceTableUndoable(newSourceTable, oldSourceTable));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSourceTableOptions(IPhysicalTable oldSourceTable, IPhysicalTable newSourceTable) {
        this.startCompoundUndoable();
        try {
            if (oldSourceTable != null) {
                this.removeTransformTableOption(this.getTableOptionObject(oldSourceTable, true));
                this.m_srcTransformTableOptions = null;
            }
            if (newSourceTable != null) {
                ITransformTableOptions src = this.createTransformTableOption(this.m_sourceTable, true);
                src.setDisplayName(RB.getStringResource("LookupTransformModel.OptionNameSource.txt"));
                this.addTransformTableOption(src);
                this.m_srcTransformTableOptions = src;
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getSourceTable() {
        return this.m_sourceTable;
    }

    @Override
    public ITable[] getSourceTables() {
        if (this.m_sourceTable != null) {
            return new ITable[]{this.m_sourceTable};
        }
        return new ITable[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLookupTable(int iPortIndex, IPhysicalTable lookupTable) {
        this.startCompoundUndoable();
        try {
            LookupPortDescriptionModel portDesc = (LookupPortDescriptionModel)this.m_lInputPortDescriptions.get(iPortIndex);
            LookupMapping lookupMapping = (LookupMapping)portDesc.getObject();
            lookupMapping.setLookupTable(lookupTable);
            this.addDataSourceImpl(lookupTable);
            this.fireModelChangedEvent("DataTransform.DataSourceAdded", lookupTable, new Integer(iPortIndex + 1));
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new AddLookupTableUndoable(iPortIndex, lookupTable));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLookupTable(int iPortIndex) {
        this.startCompoundUndoable();
        try {
            LookupPortDescriptionModel portDesc = (LookupPortDescriptionModel)this.m_lInputPortDescriptions.get(iPortIndex);
            LookupMapping lookupMapping = (LookupMapping)portDesc.getObject();
            IPhysicalTable lookupTable = lookupMapping.getLookupTable();
            this.removeDataSourceImpl(lookupTable);
            lookupMapping.setLookupTable(null);
            this.fireModelChangedEvent("DataTransform.DataSourceRemoved", lookupTable, new Integer(iPortIndex + 1));
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new RemoveLookupTableUndoable(iPortIndex, lookupTable));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceLookupTable(int iPortIndex, IPhysicalTable newLookupTable) {
        this.startCompoundUndoable();
        try {
            LookupPortDescriptionModel portDesc = (LookupPortDescriptionModel)this.m_lInputPortDescriptions.get(iPortIndex);
            LookupMapping lookupMapping = (LookupMapping)portDesc.getObject();
            IPhysicalTable oldLookupTable = lookupMapping.getLookupTable();
            this.removeDataSourceImpl(oldLookupTable);
            this.fireModelChangedEvent("DataTransform.DataSourceRemoved", oldLookupTable, new Integer(iPortIndex + 1));
            lookupMapping.setLookupTable(newLookupTable);
            this.addDataSourceImpl(newLookupTable);
            this.fireModelChangedEvent("DataTransform.DataSourceAdded", newLookupTable, new Integer(iPortIndex + 1));
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new ChangeLookupTableUndoable(iPortIndex, oldLookupTable, newLookupTable));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public List getLookupTables() {
        List lLookupMappings = this.getLookupMappings();
        ArrayList<IPhysicalTable> lLookupTables = new ArrayList<IPhysicalTable>(lLookupMappings.size());
        for (int iMapping = 0; iMapping < lLookupMappings.size(); ++iMapping) {
            LookupMapping lookupMapping = (LookupMapping)lLookupMappings.get(iMapping);
            lLookupTables.add(lookupMapping.getLookupTable());
        }
        return lLookupTables;
    }

    public List getUniqueLookupTables() {
        List lLookupMappings = this.getLookupMappings();
        LinkedHashSet<IPhysicalTable> lookupTableSet = new LinkedHashSet<IPhysicalTable>(lLookupMappings.size());
        for (int iMapping = 0; iMapping < lLookupMappings.size(); ++iMapping) {
            LookupMapping lookupMapping = (LookupMapping)lLookupMappings.get(iMapping);
            lookupTableSet.add(lookupMapping.getLookupTable());
        }
        return new ArrayList(lookupTableSet);
    }

    public List getLookupMappings() {
        ArrayList lLookupMappings = new ArrayList(this.getAllLookupMappings());
        Iterator iter = lLookupMappings.iterator();
        while (iter.hasNext()) {
            LookupMapping lookupMapping = (LookupMapping)iter.next();
            if (lookupMapping.getLookupTable() != null) continue;
            iter.remove();
        }
        return lLookupMappings;
    }

    public List getAllLookupMappings() {
        ArrayList<IMapping> lLookupMappings = new ArrayList<IMapping>();
        List lMappings = this.getMappingsList();
        if (lMappings == null) {
            return lLookupMappings;
        }
        for (int i = 0; i < lMappings.size(); ++i) {
            IMapping mapping = (IMapping)lMappings.get(i);
            if (!(mapping instanceof LookupMapping)) continue;
            lLookupMappings.add(mapping);
        }
        return lLookupMappings;
    }

    public List getLookupKeyColumns(int i) {
        ArrayList<IColumn> lKeyColumns = new ArrayList<IColumn>();
        LookupMapping lkpMapping_i = (LookupMapping)this.getLookupMappings().get(i);
        List<IMapping> lLkpKeyMaps = Arrays.asList(lkpMapping_i.getKeyMappings().getMappings());
        for (int j = 0; j < lLkpKeyMaps.size(); ++j) {
            if (lLkpKeyMaps.get(j).getTargets().length == 0) continue;
            lKeyColumns.add(lLkpKeyMaps.get(j).getTargets()[0]);
        }
        return lKeyColumns;
    }

    public void setTargetTable(IPhysicalTable newTargetTable) {
        this.setTargetTable(newTargetTable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetTable(IPhysicalTable newTargetTable, boolean createOptions) {
        if (this.m_targetTable == null ? newTargetTable == null : this.m_targetTable.equals(newTargetTable)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IPhysicalTable oldTargetTable = this.m_targetTable;
            this.m_targetTable = newTargetTable;
            LookupPortDescriptionModel portDesc = (LookupPortDescriptionModel)this.m_lOutputPortDescriptions.get(0);
            if (oldTargetTable != null) {
                this.removeDataTarget(portDesc, oldTargetTable);
                this.fireModelChangedEvent("DataTransform.DataTargetRemoved", oldTargetTable, new Integer(1));
                this.removeTransformTableOption(this.getTableOptionObject(oldTargetTable, false));
                this.m_targetTransformTableOptions = null;
            }
            if (newTargetTable != null) {
                this.addDataTarget(portDesc, (IDataObject)newTargetTable);
                this.fireModelChangedEvent("DataTransform.DataTargetAdded", newTargetTable, new Integer(1));
                if (createOptions) {
                    ITransformTableOptions target = this.createTransformTableOption(newTargetTable, false);
                    target.setDisplayName(RB.getStringResource("LookupTransformModel.OptionNameTarget.txt"));
                    this.addTransformTableOption(target);
                    this.m_targetTransformTableOptions = target;
                }
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetTargetTableUndoable(newTargetTable, oldTargetTable));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getTargetTable() {
        return this.m_targetTable;
    }

    @Override
    public ITable[] getTargetTables() {
        if (this.m_targetTable != null) {
            return new ITable[]{this.m_targetTable};
        }
        return new ITable[0];
    }

    @Override
    public IWorkTable[] getWorkTables() {
        ArrayList<IPhysicalTable> lWorkTables = new ArrayList<IPhysicalTable>();
        if (this.m_targetTable instanceof IWorkTable) {
            lWorkTables.add(this.m_targetTable);
        }
        if (this.m_errorTable instanceof IWorkTable) {
            lWorkTables.add(this.m_errorTable);
        }
        if (this.m_exceptionTable instanceof IWorkTable) {
            lWorkTables.add(this.m_exceptionTable);
        }
        return lWorkTables.toArray(new IWorkTable[lWorkTables.size()]);
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return this.m_targetTable == null;
    }

    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            IWorkTable workTable = this.getObjectFactory().createNewWorkTable(this.getID());
            workTable.setName(this.getName());
            this.setTargetTable(workTable);
            IWorkTable iWorkTable = workTable;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public void setErrorTable(IPhysicalTable newErrorTable) {
        this.setErrorTable(newErrorTable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorTable(IPhysicalTable newErrorTable, boolean createOptions) {
        if (this.m_errorTable == null ? newErrorTable == null : this.m_errorTable.equals(newErrorTable)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IPhysicalTable oldErrorTable = this.m_errorTable;
            this.m_errorTable = newErrorTable;
            LookupPortDescriptionModel portDesc = (LookupPortDescriptionModel)this.m_lOutputPortDescriptions.get(1);
            if (oldErrorTable != null) {
                this.removeDataTarget(portDesc, oldErrorTable);
                this.fireModelChangedEvent("DataTransform.DataTargetRemoved", oldErrorTable, new Integer(2));
                this.removeTransformTableOption(this.getTableOptionObject(oldErrorTable, false));
                this.m_errorTransformTableOptions = null;
            }
            if (newErrorTable != null) {
                this.addDataTarget(portDesc, (IDataObject)newErrorTable);
                this.fireModelChangedEvent("DataTransform.DataTargetAdded", newErrorTable, new Integer(2));
                if (createOptions) {
                    ITransformTableOptions err = this.createTransformTableOption(newErrorTable, false);
                    err.setDisplayName(RB.getStringResource("LookupTransformModel.OptionNameError.txt"));
                    this.addTransformTableOption(err);
                    this.m_errorTransformTableOptions = err;
                }
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetErrorTableUndoable(newErrorTable, oldErrorTable));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getErrorTable() {
        return this.m_errorTable;
    }

    public void setExceptionTable(IPhysicalTable newExceptionTable) {
        this.setExceptionTable(newExceptionTable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionTable(IPhysicalTable newExceptionTable, boolean createOptions) {
        if (this.m_exceptionTable == null ? newExceptionTable == null : this.m_exceptionTable.equals(newExceptionTable)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IPhysicalTable oldExceptionTable = this.m_exceptionTable;
            this.m_exceptionTable = newExceptionTable;
            LookupPortDescriptionModel portDesc = (LookupPortDescriptionModel)this.m_lOutputPortDescriptions.get(2);
            if (oldExceptionTable != null) {
                this.removeDataTarget(portDesc, oldExceptionTable);
                this.fireModelChangedEvent("DataTransform.DataTargetRemoved", oldExceptionTable, new Integer(3));
                this.removeTransformTableOption(this.getTableOptionObject(oldExceptionTable, false));
                this.m_excTransformTableOptions = null;
            }
            if (newExceptionTable != null) {
                this.addDataTarget(portDesc, (IDataObject)newExceptionTable);
                this.fireModelChangedEvent("DataTransform.DataTargetAdded", newExceptionTable, new Integer(3));
                if (createOptions) {
                    ITransformTableOptions exc = this.createTransformTableOption(newExceptionTable, false);
                    exc.setDisplayName(RB.getStringResource("LookupTransformModel.OptionNameException.txt"));
                    this.addTransformTableOption(exc);
                    this.m_excTransformTableOptions = exc;
                }
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetExceptionTableUndoable(newExceptionTable, oldExceptionTable));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getExceptionTable() {
        return this.m_exceptionTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            boolean bCaseSensitive = this.isQuotingNeeded() || newTable.isQuoted();
            for (int i = 0; i < portIndexes.length; ++i) {
                IColumn newColumn;
                IColumn[] aColumns;
                int iMap;
                IColumn[] aNewColumns;
                int iPortIndex = portIndexes[i] - 1;
                if (iPortIndex == 0) {
                    IMapping mapping;
                    int iMap2;
                    ArrayList<IMapping> lChangedMappings = new ArrayList<IMapping>();
                    IMapping[] aMappings = this.getMappings();
                    aNewColumns = newTable.getColumns();
                    for (iMap2 = 0; iMap2 < aMappings.length; ++iMap2) {
                        mapping = aMappings[iMap2];
                        IColumn[] aColumns2 = mapping.getSources();
                        block5: for (int iColumn = 0; iColumn < aColumns2.length; ++iColumn) {
                            IColumn column = aColumns2[iColumn];
                            if (columnsMap != null && (IColumn)columnsMap.get(aColumns2[iColumn]) != null) {
                                mapping.replaceSourceColumn(column, (IColumn)columnsMap.get(aColumns2[iColumn]));
                                lChangedMappings.add(mapping);
                                continue;
                            }
                            if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                            for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                                IColumn newColumn2 = aNewColumns[iNewColumn];
                                if (!column.equalsName(newColumn2, bCaseSensitive) || column.getLength() < newColumn2.getLength() || column.getType() != newColumn2.getType()) continue;
                                mapping.replaceSourceColumn(column, newColumn2);
                                lChangedMappings.add(mapping);
                                continue block5;
                            }
                        }
                    }
                    for (iMap2 = 0; iMap2 < aMappings.length; ++iMap2) {
                        mapping = aMappings[iMap2];
                        if (lChangedMappings.contains(mapping) || !"ONETOONE".equals(mapping.getType())) continue;
                        this.removeMapping(mapping);
                    }
                    lChangedMappings = new ArrayList();
                    List lLookupMappings = this.getLookupMappings();
                    for (int iLookup = 0; iLookup < lLookupMappings.size(); ++iLookup) {
                        IMapping mapping2;
                        int iMap3;
                        LookupMapping lookupMapping = (LookupMapping)lLookupMappings.get(iLookup);
                        aMappings = lookupMapping.getKeyMappings().getMappings();
                        for (iMap3 = 0; iMap3 < aMappings.length; ++iMap3) {
                            mapping2 = aMappings[iMap3];
                            IColumn[] aColumns3 = mapping2.getSources();
                            block10: for (int iColumn = 0; iColumn < aColumns3.length; ++iColumn) {
                                IColumn column = aColumns3[iColumn];
                                if (columnsMap != null && (IColumn)columnsMap.get(aColumns3[iColumn]) != null) {
                                    mapping2.replaceSourceColumn(column, (IColumn)columnsMap.get(aColumns3[iColumn]));
                                    lChangedMappings.add(mapping2);
                                    continue;
                                }
                                if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                                for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                                    IColumn newColumn3 = aNewColumns[iNewColumn];
                                    if (!column.equalsName(newColumn3, bCaseSensitive) || column.getLength() < newColumn3.getLength() || column.getType() != newColumn3.getType()) continue;
                                    mapping2.replaceSourceColumn(column, newColumn3);
                                    lChangedMappings.add(mapping2);
                                    continue block10;
                                }
                            }
                        }
                        for (iMap3 = 0; iMap3 < aMappings.length; ++iMap3) {
                            mapping2 = aMappings[iMap3];
                            if (lChangedMappings.contains(mapping2)) continue;
                            lookupMapping.getKeyMappings().removeMapping(mapping2);
                        }
                    }
                    this.setSourceTable((IPhysicalTable)newTable);
                    continue;
                }
                LookupPortDescriptionModel portDesc = (LookupPortDescriptionModel)this.m_lInputPortDescriptions.get(iPortIndex);
                LookupMapping lookupMapping = (LookupMapping)portDesc.getObject();
                aNewColumns = newTable.getColumns();
                ArrayList<IMapping> lChangedMappings = new ArrayList<IMapping>();
                IMapping[] aMappings = lookupMapping.getKeyMappings().getMappings();
                for (iMap = 0; iMap < aMappings.length; ++iMap) {
                    IMapping mapping = aMappings[iMap];
                    aColumns = mapping.getTargets();
                    block14: for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                        IColumn column = aColumns[iColumn];
                        if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                            mapping.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                            lChangedMappings.add(mapping);
                            continue;
                        }
                        if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                        for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                            newColumn = aNewColumns[iNewColumn];
                            if (!column.equalsName(newColumn, bCaseSensitive) || column.getLength() < newColumn.getLength() || column.getType() != newColumn.getType()) continue;
                            mapping.replaceTargetColumn(column, newColumn);
                            lChangedMappings.add(mapping);
                            continue block14;
                        }
                    }
                }
                for (iMap = 0; iMap < aMappings.length; ++iMap) {
                    IMapping mapping = aMappings[iMap];
                    if (lChangedMappings.contains(mapping)) continue;
                    lookupMapping.getKeyMappings().removeMapping(mapping);
                }
                lChangedMappings = new ArrayList();
                aMappings = lookupMapping.getDataMappings().getMappings();
                for (iMap = 0; iMap < aMappings.length; ++iMap) {
                    IMapping mapping = aMappings[iMap];
                    aColumns = mapping.getSources();
                    block18: for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                        IColumn column = aColumns[iColumn];
                        if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                            mapping.replaceSourceColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                            lChangedMappings.add(mapping);
                            continue;
                        }
                        if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                        for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                            newColumn = aNewColumns[iNewColumn];
                            if (!column.equalsName(newColumn, bCaseSensitive) || column.getLength() < newColumn.getLength() || column.getType() != newColumn.getType()) continue;
                            mapping.replaceSourceColumn(column, newColumn);
                            lChangedMappings.add(mapping);
                            continue block18;
                        }
                    }
                }
                for (iMap = 0; iMap < aMappings.length; ++iMap) {
                    IMapping mapping = aMappings[iMap];
                    if (lChangedMappings.contains(mapping)) continue;
                    lookupMapping.getDataMappings().removeMapping(mapping);
                }
                this.replaceLookupTable(iPortIndex, (IPhysicalTable)newTable);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            if (oldTable == this.m_targetTable) {
                IMapping mapping;
                int iMap;
                boolean bCaseSensitive = this.isQuotingNeeded() || newTable.isQuoted();
                ArrayList<IMapping> lChangedMappings = new ArrayList<IMapping>();
                IMapping[] aMappings = this.getMappings();
                IColumn[] aNewColumns = newTable.getColumns();
                for (iMap = 0; iMap < aMappings.length; ++iMap) {
                    mapping = aMappings[iMap];
                    IColumn[] aColumns = mapping.getTargets();
                    block4: for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                        IColumn column = aColumns[iColumn];
                        if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                            mapping.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                            lChangedMappings.add(mapping);
                            continue;
                        }
                        if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                        for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                            IColumn newColumn = aNewColumns[iNewColumn];
                            if (!column.equalsName(newColumn, bCaseSensitive) || column.getLength() < newColumn.getLength() || column.getType() != newColumn.getType()) continue;
                            mapping.replaceTargetColumn(column, newColumn);
                            lChangedMappings.add(mapping);
                            continue block4;
                        }
                    }
                }
                for (iMap = 0; iMap < aMappings.length; ++iMap) {
                    mapping = aMappings[iMap];
                    if (lChangedMappings.contains(mapping) || !"ONETOONE".equals(mapping.getType())) continue;
                    this.removeMapping(mapping);
                }
                lChangedMappings = new ArrayList();
                List lLookupMappings = this.getLookupMappings();
                for (int iLookup = 0; iLookup < lLookupMappings.size(); ++iLookup) {
                    IMapping mapping2;
                    int iMap2;
                    LookupMapping lookupMapping = (LookupMapping)lLookupMappings.get(iLookup);
                    aMappings = lookupMapping.getDataMappings().getMappings();
                    for (iMap2 = 0; iMap2 < aMappings.length; ++iMap2) {
                        mapping2 = aMappings[iMap2];
                        IColumn[] aColumns = mapping2.getTargets();
                        block9: for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                            IColumn column = aColumns[iColumn];
                            if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                                mapping2.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                                lookupMapping.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                                lChangedMappings.add(mapping2);
                                continue;
                            }
                            if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                            for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                                IColumn newColumn = aNewColumns[iNewColumn];
                                if (!column.equalsName(newColumn, bCaseSensitive) || column.getLength() < newColumn.getLength() || column.getType() != newColumn.getType()) continue;
                                mapping2.replaceTargetColumn(column, newColumn);
                                lookupMapping.replaceTargetColumn(column, newColumn);
                                lChangedMappings.add(mapping2);
                                continue block9;
                            }
                        }
                    }
                    for (iMap2 = 0; iMap2 < aMappings.length; ++iMap2) {
                        mapping2 = aMappings[iMap2];
                        if (lChangedMappings.contains(mapping2)) continue;
                        lookupMapping.getDataMappings().removeMapping(mapping2);
                    }
                }
                this.setTargetTable((IPhysicalTable)newTable);
            } else if (oldTable == this.m_errorTable) {
                this.setErrorTable((IPhysicalTable)newTable);
            } else if (oldTable == this.m_exceptionTable) {
                this.setExceptionTable((IPhysicalTable)newTable);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new cLookupTransformModel();
    }

    private LookupMapping createLookupMapping() {
        LookupMapping lookupMapping = this.getModel().getObjectFactory().createNewLookupMapping(this.getID());
        lookupMapping.setLookupModel(this);
        lookupMapping.addNotifyListener(this);
        try {
            boolean bUndoSupported = this.isUndoSupported();
            this.getModel().setUndoSupported(false);
            try {
                lookupMapping.loadConditionActionSetTemplatesFromOMR();
            }
            finally {
                this.getModel().setUndoSupported(bUndoSupported);
            }
            lookupMapping.addConditions(LookupMapping.loadDefaultConditions());
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return lookupMapping;
    }

    @Override
    public boolean isAddInputAvailable() {
        return true;
    }

    @Override
    public boolean isDeleteInputAvailable() {
        int iInputPortCount = this.m_lInputPortDescriptions.size();
        if (iInputPortCount <= 2) {
            return false;
        }
        for (int iPort = 1; iPort < iInputPortCount; ++iPort) {
            LookupPortDescriptionModel port = (LookupPortDescriptionModel)this.m_lInputPortDescriptions.get(iPort);
            if (!port.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addInput() {
        this.startCompoundUndoable();
        try {
            LookupPortDescriptionModel portDesc = new LookupPortDescriptionModel();
            if (this.m_lInputPortDescriptions.isEmpty()) {
                portDesc.setName(RB.getStringResource("LookupTransformModel.InputPortName.txt"));
                portDesc.setTooltipText(RB.getStringResource("LookupTransformModel.InputPortText.txt"));
            } else {
                portDesc.setName(RB.getStringResource("LookupTransformModel.LookupPortName.txt"));
                portDesc.setTooltipText(RB.getStringResource("LookupTransformModel.LookupPortText.txt"));
                LookupMapping lookupMapping = this.createLookupMapping();
                this.addMapping(lookupMapping);
                portDesc.setObject(lookupMapping);
            }
            int iPortIndex = this.m_lInputPortDescriptions.size();
            this.addInput(iPortIndex, portDesc);
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new AddInputUndoable(iPortIndex, portDesc));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void addInput(int iPortIndex, LookupPortDescriptionModel portDesc) {
        this.m_lInputPortDescriptions.add(iPortIndex, portDesc);
        this.fireModelChangedEvent("DataTransform.InputAdded", portDesc, new Integer(iPortIndex + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteInput() {
        this.startCompoundUndoable();
        try {
            int start;
            for (int iPortIndex = start = this.m_lInputPortDescriptions.size() - 1; iPortIndex > 0; --iPortIndex) {
                LookupPortDescriptionModel portDesc = (LookupPortDescriptionModel)this.m_lInputPortDescriptions.get(iPortIndex);
                if (!portDesc.isEmpty()) continue;
                LookupMapping lookupMapping = (LookupMapping)portDesc.getObject();
                this.removeMapping(lookupMapping);
                this.deleteInput(portDesc, iPortIndex);
                if (this.isUndoSupported()) {
                    this.undoableEditHappened(new DeleteInputUndoable(iPortIndex, portDesc));
                }
                break;
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void deleteInput(LookupPortDescriptionModel portDesc, int iPortIndex) {
        this.m_lInputPortDescriptions.remove(iPortIndex);
        if (iPortIndex == -1) {
            this.fireModelChangedEvent("DataTransform.InputRemoved", portDesc);
        } else {
            this.fireModelChangedEvent("DataTransform.InputRemoved", portDesc, new Integer(iPortIndex + 1));
        }
    }

    public int[] findInSourcePorts(IPhysicalTable table) {
        ArrayList<Integer> lPorts = new ArrayList<Integer>();
        for (int iPort = 0; iPort < this.m_lInputPortDescriptions.size(); ++iPort) {
            LookupPortDescriptionModel portDesc = (LookupPortDescriptionModel)this.m_lInputPortDescriptions.get(iPort);
            IObject portObject = portDesc.getObject();
            IPhysicalTable sourceTable = null;
            if (portObject instanceof IPhysicalTable) {
                sourceTable = (IPhysicalTable)portObject;
            } else if (portObject instanceof LookupMapping) {
                sourceTable = ((LookupMapping)portObject).getLookupTable();
            }
            if (sourceTable != table) continue;
            lPorts.add(new Integer(iPort));
        }
        int[] iaPorts = new int[lPorts.size()];
        for (int i = 0; i < lPorts.size(); ++i) {
            iaPorts[i] = (Integer)lPorts.get(i);
        }
        return iaPorts;
    }

    public int[] findInTargetPorts(IPhysicalTable table) {
        ArrayList<Integer> lPorts = new ArrayList<Integer>();
        for (int iPort = 0; iPort < this.m_lOutputPortDescriptions.size(); ++iPort) {
            LookupPortDescriptionModel portDesc = (LookupPortDescriptionModel)this.m_lOutputPortDescriptions.get(iPort);
            IPhysicalTable targetTable = (IPhysicalTable)portDesc.getObject();
            if (targetTable == null || !targetTable.equals(table)) continue;
            lPorts.add(new Integer(iPort));
        }
        int[] iaPorts = new int[lPorts.size()];
        for (int i = 0; i < lPorts.size(); ++i) {
            iaPorts[i] = (Integer)lPorts.get(i);
        }
        return iaPorts;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.m_sourceTable != null && this.m_targetTable != null && !this.getLookupTables().isEmpty();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (!this.getDataSourceList().isEmpty() && this.m_sourceTable == null) {
            lReasons.add(RB.getStringResource("LookupTransformModel.ReasonIncomplete.NoSource.txt"));
        }
        if (!this.getDataSourceList().isEmpty() && this.getLookupTables().isEmpty()) {
            lReasons.add(RB.getStringResource("LookupTransformModel.ReasonIncomplete.NoLookups.txt"));
        }
        if (!this.getDataTargetList().isEmpty() && this.m_targetTable == null) {
            lReasons.add(RB.getStringResource("LookupTransformModel.ReasonIncomplete.NoTarget.txt"));
        }
        return lReasons;
    }

    @Override
    public boolean doesMappingExistOnAllTargetTables() {
        if (this.m_targetTable != null) {
            IColumn[] columns = this.m_targetTable.getColumns();
            for (int iColumn = 0; iColumn < columns.length; ++iColumn) {
                IMapping map = this.getOrdinaryMappingsForTargetColumn(columns[iColumn]);
                if (map == null) continue;
                return true;
            }
        }
        List lLookupMappings = this.getLookupMappings();
        for (int i = 0; i < lLookupMappings.size(); ++i) {
            LookupMapping lkpMapping_i = (LookupMapping)this.getLookupMappings().get(i);
            List<IMapping> lLkpDataMaps = Arrays.asList(lkpMapping_i.getDataMappings().getMappings());
            for (int j = 0; j < lLkpDataMaps.size(); ++j) {
                IMapping lkpToTarMapping_j = lLkpDataMaps.get(j);
                if (lkpToTarMapping_j.getTargets().length == 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMappingAllowed(IColumn[] aSources, IColumn[] aTargets) {
        if (this.areAnyTargetColumnsMappedToLookupTable(aTargets)) {
            return false;
        }
        return super.isMappingAllowed(aSources, aTargets);
    }

    @Override
    public String getReasonMappingIsNotAllowed(IColumn[] aSources, IColumn[] aTargets) {
        if (this.areAnyTargetColumnsMappedToLookupTable(aTargets)) {
            return RB.getStringResource("LookupTransformModel.ReasonNotAllowed.MappingAlreadyExists.txt");
        }
        return super.getReasonMappingIsNotAllowed(aSources, aTargets);
    }

    private boolean areAnyTargetColumnsMappedToLookupTable(IColumn[] aColumns) {
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            IColumn column = aColumns[iColumn];
            List lLookupMappings = this.getLookupMappings();
            for (int iMapping = 0; iMapping < lLookupMappings.size(); ++iMapping) {
                LookupMapping lookupMapping = (LookupMapping)lLookupMappings.get(iMapping);
                if (!lookupMapping.isTargetColumnMappedToLookupTable(column)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSourceColumnFromMappings(IColumn column) {
        this.startCompoundUndoable();
        try {
            IMapping[] aMappings = this.getMappings();
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                IMapping mapping = aMappings[iMapping];
                if (mapping instanceof LookupMapping) {
                    IMappingsContainer keyMappingsContainer = ((LookupMapping)mapping).getKeyMappings();
                    IMapping[] aKeyMappings = keyMappingsContainer.getMappings();
                    for (int iKeyMapping = 0; iKeyMapping < aKeyMappings.length; ++iKeyMapping) {
                        IMapping keyMapping = aKeyMappings[iKeyMapping];
                        if (!keyMapping.containsInSources(column)) continue;
                        keyMappingsContainer.removeMapping(keyMapping);
                    }
                    continue;
                }
                if (!mapping.containsInSources(column)) continue;
                mapping.removeSource(column);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTargetColumnFromMappings(IColumn column) {
        this.startCompoundUndoable();
        try {
            IMapping[] aMappings = this.getMappings();
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                IMapping mapping = aMappings[iMapping];
                if (mapping instanceof LookupMapping) {
                    IMappingsContainer dataMappingsContainer = ((LookupMapping)mapping).getDataMappings();
                    IMapping[] aDataMappings = dataMappingsContainer.getMappings();
                    for (int iDataMapping = 0; iDataMapping < aDataMappings.length; ++iDataMapping) {
                        IMapping dataMapping = aDataMappings[iDataMapping];
                        if (!dataMapping.containsInTargets(column)) continue;
                        dataMappingsContainer.removeMapping(dataMapping);
                    }
                    continue;
                }
                if (!mapping.containsInTargets(column)) continue;
                if (mapping.getType() == "ONETOONE") {
                    this.removeMapping(mapping);
                    continue;
                }
                mapping.removeTarget(column);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void mapColumns(IMappingRule[] aRules) {
        if (this.m_sourceTable != null && this.m_targetTable != null) {
            this.mapColumns(this.m_sourceTable, this.m_targetTable, aRules);
        }
    }

    @Override
    public void mapColumns(ITable tblSource, ITable tblTarget, IMappingRule[] aRules) {
        if (tblSource == this.m_sourceTable && tblTarget == this.m_targetTable) {
            this.mapColumns(tblSource.getColumns(), tblTarget.getColumns(), aRules);
        }
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        if (aSourceTables.length == 1 && aSourceTables[0] == this.m_sourceTable) {
            super.propagateColumnsToTargetTables(aSourceTables, aTargetTables, eNonWorkTableHandling);
        }
    }

    @Override
    public void propagateColumnsToSourceTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        if (aSourceTables.length == 1 && aSourceTables[0] == this.m_sourceTable) {
            super.propagateColumnsToSourceTables(aSourceTables, aTargetTables, eNonWorkTableHandling);
        }
    }

    public static String getTransformTypeID() {
        return "com.sas.wadmin.transforms.lookup.Lookup";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.wadmin.transforms.lookup.Lookup";
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.wadmin.transforms.lookup.Lookup";
    }

    public void setErrorLimit(int iErrorLimit) {
        if (this.m_iErrorLimit == iErrorLimit) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetErrorLimitUndoable(this.m_iErrorLimit, iErrorLimit));
        }
        this.m_iErrorLimit = iErrorLimit;
        this.fireModelChangedEvent(ERROR_LIMIT_CHANGED, null);
    }

    public int getErrorLimit() {
        return this.m_iErrorLimit;
    }

    public String getLookupTechnique() {
        return this.m_sLookupTechnique;
    }

    public void setLookupTechnique(String value) {
        if (this.m_sLookupTechnique == value) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLookupTechniqueUndoable(this.m_sLookupTechnique, value));
        }
        this.m_sLookupTechnique = value;
        this.fireModelChangedEvent("LookupTransform:ErrorLimitActionChanged", null);
    }

    public void setErrorLimitAction(String sErrorLimitAction) {
        if (sErrorLimitAction == null) {
            throw new NullPointerException("error limit action must not be null");
        }
        if (sErrorLimitAction.equals(this.m_sErrorLimitAction)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetErrorLimitActionUndoable(this.m_sErrorLimitAction, sErrorLimitAction));
        }
        this.m_sErrorLimitAction = sErrorLimitAction;
        this.fireModelChangedEvent("LookupTransform:ErrorLimitActionChanged", null);
    }

    public String getErrorLimitAction() {
        return this.m_sErrorLimitAction;
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getSource() instanceof LookupMapping && ev.getType() == 1) {
            this.fireModelChangedEvent(LOOKUP_MAPPINGS_CHANGED, null);
        }
        super.notify(ev);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        TransformationStep mdTS = (TransformationStep)omr.acquireOMRObject(this);
        Prototype mdPFDPrototype = (Prototype)mdTS.getUsingPrototype();
        if (mdPFDPrototype != null) {
            AssociationList lPrototypeProperties = mdPFDPrototype.getPrototypeProperties();
            while (!lPrototypeProperties.isEmpty()) {
                PrototypeProperty mdProtoProp = (PrototypeProperty)lPrototypeProperties.get(0);
                mdProtoProp.delete();
            }
            mdPFDPrototype.delete();
        }
        this.saveIntOptionToOMR(omr, ERROR_LIMIT_OPTION, this.m_iErrorLimit);
        this.saveStringOptionToOMR(omr, ERROR_LIMIT_ACTION_OPTION, this.m_sErrorLimitAction);
        this.saveStringOptionToOMR(omr, TECHNIQUE_OPTION, this.m_sLookupTechnique);
        if (this.m_sourceTable != null) {
            this.saveCustomListToOMR(omr, SOURCE_TABLE, new IPhysicalTable[]{this.m_sourceTable});
        } else {
            this.saveCustomListToOMR(omr, SOURCE_TABLE, new IPhysicalTable[0]);
        }
        if (this.m_targetTable != null) {
            this.saveCustomListToOMR(omr, TARGET_TABLE, new IPhysicalTable[]{this.m_targetTable});
        } else {
            this.saveCustomListToOMR(omr, TARGET_TABLE, new IPhysicalTable[0]);
        }
        if (this.m_errorTable != null) {
            this.saveCustomListToOMR(omr, ERROR_TABLE, new IPhysicalTable[]{this.m_errorTable});
        } else {
            this.saveCustomListToOMR(omr, ERROR_TABLE, new IPhysicalTable[0]);
        }
        if (this.m_exceptionTable != null) {
            this.saveCustomListToOMR(omr, EXCEPTION_TABLE, new IPhysicalTable[]{this.m_exceptionTable});
        } else {
            this.saveCustomListToOMR(omr, EXCEPTION_TABLE, new IPhysicalTable[0]);
        }
        List lLookupMappings = this.getLookupMappings();
        for (int i = 0; i < lLookupMappings.size(); ++i) {
            ((LookupMapping)lLookupMappings.get(i)).saveToOMR(omr);
        }
        this.setChanged(false);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssoc = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssoc == null) {
            lAssoc = new ArrayList<String>();
        }
        lAssoc.add("UsingPrototype");
        map.put(this.getOMRType(), lAssoc);
        return map;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        TransformationStep mdTS = (TransformationStep)omr.acquireOMRObject(this);
        Prototype mdPFDPrototype = (Prototype)mdTS.getUsingPrototype();
        if (mdPFDPrototype != null) {
            this.loadOldStyleLookup(omr);
            this.loadPortDescriptions();
        } else {
            IPersistableObject[] aExceptionTable;
            IPersistableObject[] aErrorTable;
            String sErrorLimitActionOld;
            int iErrorLimit = this.loadIntOptionFromOMR(omr, ERROR_LIMIT_OPTION, -1);
            String sErrorLimitAction = sErrorLimitActionOld = this.loadStringOptionFromOMR(omr, ERROR_LIMIT_ACTION_OPTION, ERROR_LIMIT_ACTION_ABORTJOB);
            if (sErrorLimitActionOld.equalsIgnoreCase("Abort the step")) {
                sErrorLimitAction = ERROR_LIMIT_ACTION_ABORTSTEP;
            } else if (sErrorLimitActionOld.equalsIgnoreCase("Ignore all remaining errors")) {
                sErrorLimitAction = ERROR_LIMIT_ACTION_IGNORE;
            } else if (sErrorLimitActionOld.equalsIgnoreCase("Abort the job")) {
                sErrorLimitAction = ERROR_LIMIT_ACTION_ABORTJOB;
            }
            String sLookupTechnique = this.loadStringOptionFromOMR(omr, TECHNIQUE_OPTION, "HASH_TABLE");
            this.setErrorLimit(iErrorLimit);
            this.setErrorLimitAction(sErrorLimitAction);
            this.setLookupTechnique(sLookupTechnique);
            ClassifierMap mdCM = this.getClassifierMapObject(omr);
            this.loadPortDescriptions();
            IPersistableObject[] aSourceTable = this.loadCustomListFromOMR(omr, SOURCE_TABLE);
            if (aSourceTable.length > 0) {
                ITransformTableOptions opts = this.findTransformTableOptionsFromOMR(omr, (IPhysicalTable)aSourceTable[0]);
                if (opts != null) {
                    this.setSourceTable((IPhysicalTable)aSourceTable[0], false);
                    this.addTransformTableOption(opts);
                    this.m_srcTransformTableOptions = opts;
                } else {
                    this.setSourceTable((IPhysicalTable)aSourceTable[0]);
                }
            }
            AssociationList lFeatureMaps = mdCM.getFeatureMaps();
            for (int i = 0; i < lFeatureMaps.size(); ++i) {
                FeatureMap mdFM = (FeatureMap)lFeatureMaps.get(i);
                if (!mdFM.getName().equals("LOOKUP")) continue;
                LookupMapping lookupMapping = (LookupMapping)omr.acquireObject((Root)mdFM);
                lookupMapping.addNotifyListener(this);
                lookupMapping.setLookupModel(this);
                IPhysicalTable lookupTable = lookupMapping.getLookupTable();
                if (lookupTable == null) continue;
                this.addDataSourceImpl(lookupTable);
            }
            IPersistableObject[] aTargetTable = this.loadCustomListFromOMR(omr, TARGET_TABLE);
            if (aTargetTable.length > 0) {
                ITransformTableOptions opts = this.findTransformTableOptionsFromOMR(omr, (IPhysicalTable)aTargetTable[0]);
                if (opts != null) {
                    this.setTargetTable((IPhysicalTable)aTargetTable[0], false);
                    this.addTransformTableOption(opts);
                    this.m_targetTransformTableOptions = opts;
                } else {
                    this.setTargetTable((IPhysicalTable)aTargetTable[0]);
                }
            }
            if ((aErrorTable = this.loadCustomListFromOMR(omr, ERROR_TABLE)).length > 0) {
                ITransformTableOptions opts = this.findTransformTableOptionsFromOMR(omr, (IPhysicalTable)aErrorTable[0]);
                if (opts != null) {
                    this.setErrorTable((IPhysicalTable)aErrorTable[0], false);
                    this.addTransformTableOption(opts);
                    this.m_errorTransformTableOptions = opts;
                } else {
                    this.setErrorTable((IPhysicalTable)aErrorTable[0]);
                }
            }
            if ((aExceptionTable = this.loadCustomListFromOMR(omr, EXCEPTION_TABLE)).length > 0) {
                ITransformTableOptions opts = this.findTransformTableOptionsFromOMR(omr, (IPhysicalTable)aExceptionTable[0]);
                if (opts != null) {
                    this.setExceptionTable((IPhysicalTable)aExceptionTable[0], false);
                    this.addTransformTableOption(opts);
                    this.m_excTransformTableOptions = opts;
                } else {
                    this.setExceptionTable((IPhysicalTable)aExceptionTable[0]);
                }
            }
        }
        this.setChanged(false);
    }

    protected void loadPortDescriptions() {
        this.m_lInputPortDescriptions.clear();
        LookupPortDescriptionModel sourcePortDesc = new LookupPortDescriptionModel();
        sourcePortDesc.setName(RB.getStringResource("LookupTransformModel.InputPortName.txt"));
        sourcePortDesc.setTooltipText(RB.getStringResource("LookupTransformModel.InputPortText.txt"));
        if (this.m_sourceTable != null) {
            sourcePortDesc.setObject(this.m_sourceTable);
        }
        this.m_lInputPortDescriptions.add(sourcePortDesc);
        String sLookupPortName = RB.getStringResource("LookupTransformModel.LookupPortName.txt");
        String sLookupPortText = RB.getStringResource("LookupTransformModel.LookupPortText.txt");
        List lLookupMappings = this.getAllLookupMappings();
        if (!lLookupMappings.isEmpty()) {
            for (int i = 0; i < lLookupMappings.size(); ++i) {
                LookupMapping lookupMapping = (LookupMapping)lLookupMappings.get(i);
                LookupPortDescriptionModel lookupPortDesc = new LookupPortDescriptionModel();
                lookupPortDesc.setName(sLookupPortName);
                lookupPortDesc.setTooltipText(sLookupPortText);
                lookupPortDesc.setObject(lookupMapping);
                this.m_lInputPortDescriptions.add(lookupPortDesc);
            }
        } else {
            LookupPortDescriptionModel lookupPortDesc = new LookupPortDescriptionModel();
            lookupPortDesc.setName(sLookupPortName);
            lookupPortDesc.setTooltipText(sLookupPortText);
            this.m_lInputPortDescriptions.add(lookupPortDesc);
        }
        LookupPortDescriptionModel targetPortDesc = (LookupPortDescriptionModel)this.m_lOutputPortDescriptions.get(0);
        if (this.m_targetTable != null) {
            targetPortDesc.setObject(this.m_targetTable);
        }
        LookupPortDescriptionModel errorPortDesc = (LookupPortDescriptionModel)this.m_lOutputPortDescriptions.get(1);
        if (this.m_errorTable != null) {
            errorPortDesc.setObject(this.m_errorTable);
        }
        LookupPortDescriptionModel exceptionPortDesc = (LookupPortDescriptionModel)this.m_lOutputPortDescriptions.get(2);
        if (this.m_exceptionTable != null) {
            exceptionPortDesc.setObject(this.m_exceptionTable);
        }
    }

    private void loadOldStyleLookup(OMRAdapter omr) throws MdException, RemoteException {
        AssociationList lAssocProps;
        String sErrorLimitActionOld;
        String LOOKUP_OPTIONS = "Lookup Options";
        boolean SOURCE_TABLE_INDEX = false;
        boolean FIRST_LOOKUP_TABLE_INDEX = true;
        int LAST_LOOKUP_TABLE_INDEX = 99;
        int TARGET_TABLE_INDEX = 100;
        int ERROR_TABLE_INDEX = 101;
        int EXCEPTION_TABLE_INDEX = 102;
        int fFlags = 98;
        String sErrorLimit = this.loadPropertyFromOMR(omr, "Lookup Options", ERROR_LIMIT_OPTION, "-1", fFlags);
        String sErrorLimitAction = sErrorLimitActionOld = this.loadPropertyFromOMR(omr, "Lookup Options", ERROR_LIMIT_ACTION_OPTION, ERROR_LIMIT_ACTION_ABORTJOB, fFlags);
        if (sErrorLimitActionOld.equalsIgnoreCase("Abort the step")) {
            sErrorLimitAction = ERROR_LIMIT_ACTION_ABORTSTEP;
        } else if (sErrorLimitActionOld.equalsIgnoreCase("Ignore all remaining errors")) {
            sErrorLimitAction = ERROR_LIMIT_ACTION_IGNORE;
        } else if (sErrorLimitActionOld.equalsIgnoreCase("Abort the job")) {
            sErrorLimitAction = ERROR_LIMIT_ACTION_ABORTJOB;
        }
        int iErrorLimit = -1;
        if (sErrorLimit != null) {
            try {
                iErrorLimit = Integer.parseInt(sErrorLimit);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setErrorLimit(iErrorLimit);
        this.setErrorLimitAction(sErrorLimitAction);
        this.setLookupTechnique("HASH_TABLE");
        TransformationStep mdTS = (TransformationStep)omr.acquireOMRObject(this);
        Prototype mdPFDPrototype = (Prototype)mdTS.getUsingPrototype();
        if (mdPFDPrototype != null && !(lAssocProps = mdPFDPrototype.getPrototypeProperties()).isEmpty()) {
            PhysicalTable mdExceptionTable;
            PhysicalTable mdErrorTable;
            AssociationProperty mdAssocProp = (AssociationProperty)lAssocProps.get(0);
            PhysicalTable mdSourceTable = (PhysicalTable)mdAssocProp.getUsingPrototype();
            if (mdSourceTable != null) {
                IPhysicalTable oldSourceTable = this.getSourceTable();
                this.m_sourceTable = (IPhysicalTable)omr.acquireObject((Root)mdSourceTable);
                this.addDataSourceImpl(this.m_sourceTable);
                this.setSourceTableOptions(oldSourceTable, this.m_sourceTable);
            }
            for (int i = 1; i <= 99; ++i) {
                AssociationList lSpecSourceTransforms;
                mdAssocProp = (AssociationProperty)lAssocProps.get(i);
                PhysicalTable mdLookupTable = (PhysicalTable)mdAssocProp.getUsingPrototype();
                if (mdLookupTable == null || (lSpecSourceTransforms = mdAssocProp.getSpecSourceTransformations()).isEmpty()) continue;
                FeatureMap mdLookupMap = (FeatureMap)lSpecSourceTransforms.get(0);
                LookupMapping lookupMapping = (LookupMapping)omr.acquireObject((Root)mdLookupMap);
                lookupMapping.addNotifyListener(this);
                lookupMapping.setLookupModel(this);
                IPhysicalTable lookupTable = (IPhysicalTable)omr.acquireObject((Root)mdLookupTable);
                lookupMapping.setLookupTable(lookupTable);
                lookupMapping.setChanged(true);
                this.addDataSourceImpl(lookupTable);
            }
            mdAssocProp = (AssociationProperty)lAssocProps.get(100);
            PhysicalTable mdTargetTable = (PhysicalTable)mdAssocProp.getUsingPrototype();
            if (mdTargetTable != null) {
                this.setTargetTable((IPhysicalTable)omr.acquireObject((Root)mdTargetTable));
            }
            if ((mdErrorTable = (PhysicalTable)(mdAssocProp = (AssociationProperty)lAssocProps.get(101)).getUsingPrototype()) != null) {
                this.setErrorTable((IPhysicalTable)omr.acquireObject((Root)mdErrorTable));
            }
            if ((mdExceptionTable = (PhysicalTable)(mdAssocProp = (AssociationProperty)lAssocProps.get(102)).getUsingPrototype()) != null) {
                this.setExceptionTable((IPhysicalTable)omr.acquireObject((Root)mdExceptionTable));
            }
        }
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        LookupCodegen cg = new LookupCodegen(this);
        cg.getGeneratedCode(codeSegment);
        return codeSegment;
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings()) {
            return true;
        }
        return !this.createLookupColumnMapWithLengths().isEmpty();
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        HashMap dups = this.createLookupColumnMapWithLengths();
        Iterator iter = dups.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            sb.append(type);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        if (dups.size() == 1) {
            warnings.add(MessageFormat.format(RB.getStringResource("LookupTransformModel.DuplicateLookupColumnsDifferentLengths.One.txt"), sb.toString()));
        } else if (dups.size() > 1) {
            warnings.add(MessageFormat.format(RB.getStringResource("LookupTransformModel.DuplicateLookupColumnsDifferentLengths.Multiple.txt"), sb.toString()));
        }
        return warnings;
    }

    public HashMap createLookupColumnMapWithLengths() {
        HashMap<String, Integer> hmAllLookupColumns = new HashMap<String, Integer>();
        HashMap<String, Integer> hmMultipleLengths = new HashMap<String, Integer>();
        int num = this.getLookupTables().size();
        for (int j = 0; j < num; ++j) {
            List cols = this.getLookupKeyColumns(j);
            for (int k = 0; k < cols.size(); ++k) {
                IColumn col = (IColumn)cols.get(k);
                String colName = col.getName();
                Integer len = new Integer(col.getLength());
                if (hmAllLookupColumns.containsKey(colName)) {
                    Integer oldLen = (Integer)hmAllLookupColumns.get(colName);
                    if (len <= oldLen) continue;
                    hmAllLookupColumns.put(colName, len);
                    hmMultipleLengths.put(colName, len);
                    continue;
                }
                hmAllLookupColumns.put(colName, len);
            }
        }
        return hmMultipleLengths;
    }

    protected class cLookupTransformModel
    extends BaseDataTransformPromptModel
    implements IPromptModel {
        public cLookupTransformModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(LookupTransformModel.this.getModel(), LookupTransformModel.this);
        }

        @Override
        public PromptDataProvider createDataProvider() throws ServiceException, RemoteException, MdException, ServerConnectionException {
            return null;
        }
    }

    private class SetLookupTechniqueUndoable
    extends AbstractUndoableEdit {
        private String m_sOldLookupTechnique;
        private String m_sNewLookupTechnique;

        public SetLookupTechniqueUndoable(String sOldLookupTechnique, String sNewLookupTechnique) {
            this.m_sOldLookupTechnique = sOldLookupTechnique;
            this.m_sNewLookupTechnique = sNewLookupTechnique;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.setLookupTechnique(this.m_sOldLookupTechnique);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.setLookupTechnique(this.m_sNewLookupTechnique);
        }

        @Override
        public void die() {
            super.die();
            this.m_sOldLookupTechnique = null;
            this.m_sNewLookupTechnique = null;
        }
    }

    private class SetErrorLimitActionUndoable
    extends AbstractUndoableEdit {
        private String m_sOldErrorLimitAction;
        private String m_sNewErrorLimitAction;

        public SetErrorLimitActionUndoable(String sOldErrorLimitAction, String sNewErrorLimitAction) {
            this.m_sOldErrorLimitAction = sOldErrorLimitAction;
            this.m_sNewErrorLimitAction = sNewErrorLimitAction;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.setErrorLimitAction(this.m_sOldErrorLimitAction);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.setErrorLimitAction(this.m_sNewErrorLimitAction);
        }

        @Override
        public void die() {
            super.die();
            this.m_sOldErrorLimitAction = null;
            this.m_sNewErrorLimitAction = null;
        }
    }

    private class SetErrorLimitUndoable
    extends AbstractUndoableEdit {
        private int m_iOldErrorLimit;
        private int m_iNewErrorLimit;

        public SetErrorLimitUndoable(int iOldErrorLimit, int iNewErrorLimit) {
            this.m_iOldErrorLimit = iOldErrorLimit;
            this.m_iNewErrorLimit = iNewErrorLimit;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.setErrorLimit(this.m_iOldErrorLimit);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.setErrorLimit(this.m_iNewErrorLimit);
        }
    }

    private class DeleteInputUndoable
    extends AbstractUndoableEdit {
        int m_iPortIndex;
        LookupPortDescriptionModel m_portDesc;

        public DeleteInputUndoable(int iPortIndex, LookupPortDescriptionModel portDesc) {
            this.m_iPortIndex = iPortIndex;
            this.m_portDesc = portDesc;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.addInput(this.m_iPortIndex, this.m_portDesc);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.deleteInput(this.m_portDesc, this.m_iPortIndex);
        }

        @Override
        public void die() {
            super.die();
            this.m_portDesc = null;
        }
    }

    private class AddInputUndoable
    extends AbstractUndoableEdit {
        int m_iPortIndex;
        LookupPortDescriptionModel m_portDesc;

        public AddInputUndoable(int iPortIndex, LookupPortDescriptionModel portDesc) {
            this.m_iPortIndex = iPortIndex;
            this.m_portDesc = portDesc;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.deleteInput(this.m_portDesc, this.m_iPortIndex);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.addInput(this.m_iPortIndex, this.m_portDesc);
        }

        @Override
        public void die() {
            super.die();
            this.m_portDesc = null;
        }
    }

    private class SetExceptionTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newExceptionTable;
        private IPhysicalTable m_oldExceptionTable;

        public SetExceptionTableUndoable(IPhysicalTable newExceptionTable, IPhysicalTable oldExceptionTable) {
            this.m_newExceptionTable = newExceptionTable;
            this.m_oldExceptionTable = oldExceptionTable;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.setExceptionTable(this.m_oldExceptionTable);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.setExceptionTable(this.m_newExceptionTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_newExceptionTable = null;
            this.m_oldExceptionTable = null;
        }
    }

    private class SetErrorTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newErrorTable;
        private IPhysicalTable m_oldErrorTable;

        public SetErrorTableUndoable(IPhysicalTable newErrorTable, IPhysicalTable oldErrorTable) {
            this.m_newErrorTable = newErrorTable;
            this.m_oldErrorTable = oldErrorTable;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.setErrorTable(this.m_oldErrorTable);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.setErrorTable(this.m_newErrorTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_newErrorTable = null;
            this.m_oldErrorTable = null;
        }
    }

    private class SetTargetTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newTargetTable;
        private IPhysicalTable m_oldTargetTable;

        public SetTargetTableUndoable(IPhysicalTable newTargetTable, IPhysicalTable oldTargetTable) {
            this.m_newTargetTable = newTargetTable;
            this.m_oldTargetTable = oldTargetTable;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.setTargetTable(this.m_oldTargetTable);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.setTargetTable(this.m_newTargetTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_newTargetTable = null;
            this.m_oldTargetTable = null;
        }
    }

    private class ChangeLookupTableUndoable
    extends AbstractUndoableEdit {
        private int m_iPortIndex;
        private IPhysicalTable m_oldLookupTable;
        private IPhysicalTable m_newLookupTable;

        public ChangeLookupTableUndoable(int iPortIndex, IPhysicalTable oldLookupTable, IPhysicalTable newLookupTable) {
            this.m_iPortIndex = iPortIndex;
            this.m_oldLookupTable = oldLookupTable;
            this.m_newLookupTable = newLookupTable;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.replaceLookupTable(this.m_iPortIndex, this.m_oldLookupTable);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.replaceLookupTable(this.m_iPortIndex, this.m_newLookupTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldLookupTable = null;
            this.m_newLookupTable = null;
        }
    }

    private class RemoveLookupTableUndoable
    extends AbstractUndoableEdit {
        private int m_iPortIndex;
        private IPhysicalTable m_lookupTable;

        public RemoveLookupTableUndoable(int iPortIndex, IPhysicalTable lookupTable) {
            this.m_iPortIndex = iPortIndex;
            this.m_lookupTable = lookupTable;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.addLookupTable(this.m_iPortIndex, this.m_lookupTable);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.removeLookupTable(this.m_iPortIndex);
        }

        @Override
        public void die() {
            super.die();
            this.m_lookupTable = null;
        }
    }

    private class AddLookupTableUndoable
    extends AbstractUndoableEdit {
        private int m_iPortIndex;
        private IPhysicalTable m_lookupTable;

        public AddLookupTableUndoable(int iPortIndex, IPhysicalTable lookupTable) {
            this.m_iPortIndex = iPortIndex;
            this.m_lookupTable = lookupTable;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.removeLookupTable(this.m_iPortIndex);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.addLookupTable(this.m_iPortIndex, this.m_lookupTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_lookupTable = null;
        }
    }

    private class SetSourceTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newSourceTable;
        private IPhysicalTable m_oldSourceTable;

        public SetSourceTableUndoable(IPhysicalTable newSourceTable, IPhysicalTable oldSourceTable) {
            this.m_newSourceTable = newSourceTable;
            this.m_oldSourceTable = oldSourceTable;
        }

        @Override
        public void undo() {
            super.undo();
            LookupTransformModel.this.setSourceTable(this.m_oldSourceTable);
        }

        @Override
        public void redo() {
            super.redo();
            LookupTransformModel.this.setSourceTable(this.m_newSourceTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_newSourceTable = null;
            this.m_oldSourceTable = null;
        }
    }
}

