/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.lookup;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IObjectFactory;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.BaseObject;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingRule;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.DefaultMappingRules;
import com.sas.etl.models.job.transforms.lookup.LookupMapping;
import com.sas.etl.models.job.transforms.lookup.RB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;

public class LookupMappingsContainer
extends BaseObject
implements IMappingsContainer {
    public static final String KEY_TYPE = "lookup key";
    public static final String DATA_TYPE = "lookup data";
    private LookupMapping m_lookupMapping;
    private List m_lMappings;
    private boolean m_bIncludedInMapping;
    private boolean m_bIncludedInPropagation;
    private String m_sType;

    public LookupMappingsContainer(String sID, IModel model, LookupMapping lookupMapping, String sType) {
        super(sID, model);
        this.addNotifyListener(lookupMapping);
        this.m_lookupMapping = lookupMapping;
        this.m_sType = sType;
        this.m_lMappings = new ArrayList();
    }

    @Override
    public boolean isMappingAllowed(IColumn[] aSources, IColumn[] aTargets) {
        if (aSources.length != 1 || aTargets.length != 1 || this.isExpressionNeeded(aSources[0], aTargets[0])) {
            return false;
        }
        return !this.m_lookupMapping.isTargetColumnMappedToSourceTable(aTargets[0]);
    }

    @Override
    public String getReasonMappingIsNotAllowed(IColumn[] aSources, IColumn[] aTargets) {
        if (aSources.length != 1 || aTargets.length != 1 || this.isExpressionNeeded(aSources[0], aTargets[0])) {
            return RB.getStringResource("LookupMappingsContainer.ReasonNotAllowed.NoExpressions.txt");
        }
        if (this.m_lookupMapping.isTargetColumnMappedToSourceTable(aTargets[0])) {
            return RB.getStringResource("LookupMappingsContainer.ReasonNotAllowed.MappingAlreadyExists.txt");
        }
        return null;
    }

    @Override
    public IMapping addMapping(IColumn[] aSources, IColumn[] aTargets) {
        return this.addMapping(aSources, aTargets, this.m_sType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMapping addMapping(IColumn[] aSourceColumns, IColumn[] aTargetColumns, String sType, IExpression oExpression) {
        this.startCompoundUndoable();
        try {
            IMapping mapping = this.getObjectFactory().createNewMapping(this.getID());
            mapping.setName(aTargetColumns.length == 1 ? aTargetColumns[0].getName() : "newmapping");
            mapping.setType(this.m_sType);
            mapping.setExpression(oExpression);
            for (int iSourceColumn = 0; iSourceColumn < aSourceColumns.length; ++iSourceColumn) {
                mapping.addSource(aSourceColumns[iSourceColumn]);
            }
            for (int iTargetColumn = 0; iTargetColumn < aTargetColumns.length; ++iTargetColumn) {
                mapping.addTarget(aTargetColumns[iTargetColumn]);
            }
            this.addMapping(mapping);
            IMapping iMapping = mapping;
            return iMapping;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addMapping(IMapping mapping) {
        this.addMapping(this.m_lMappings.size(), mapping);
    }

    @Override
    public void addMapping(int iMapping, IMapping mapping) {
        this.m_lookupMapping.removeFromDeletedObjects(mapping);
        this.m_lMappings.add(iMapping, mapping);
        this.fireModelChangedEvent("MappingsContainer:MappingAdded", mapping);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddMappingUndoable(iMapping, mapping));
        }
        mapping.addNotifyListener(this);
    }

    @Override
    public boolean containsMapping(IMapping mapping) {
        return this.m_lMappings.contains(mapping);
    }

    @Override
    public IColumn[] getColumnsExcludedFromMapping() {
        return new IColumn[0];
    }

    @Override
    public IColumn[] getColumnsExcludedFromPropagation() {
        return new IColumn[0];
    }

    @Override
    public List getListOfColumnsExcludedFromMapping() {
        return new ArrayList(0);
    }

    @Override
    public List getListOfColumnsExcludedFromPropagation() {
        return new ArrayList(0);
    }

    @Override
    public IMapping[] getMappings() {
        List lMappings = this.getMappingsList();
        return lMappings.toArray(new IMapping[lMappings.size()]);
    }

    @Override
    public List getMappingsList() {
        return this.m_lMappings;
    }

    @Override
    public IMapping[] getOrdinaryMappings() {
        return this.getMappings();
    }

    @Override
    public IMapping[] getOrdinaryMappingsForSourceColumn(IColumn source) {
        ArrayList<IMapping> lMappings = new ArrayList<IMapping>();
        for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)this.m_lMappings.get(iMapping);
            if (!mapping.containsInSources(source)) continue;
            lMappings.add(mapping);
        }
        return lMappings.toArray(new IMapping[lMappings.size()]);
    }

    @Override
    public IMapping getOrdinaryMappingsForTargetColumn(IColumn target) {
        for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)this.m_lMappings.get(iMapping);
            if (!mapping.containsInTargets(target)) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public ITable[] getSourceTables() {
        IPhysicalTable sourceTable = KEY_TYPE.equals(this.m_sType) ? this.m_lookupMapping.getSourceTable() : this.m_lookupMapping.getLookupTable();
        if (sourceTable != null) {
            return new ITable[]{sourceTable};
        }
        return new ITable[0];
    }

    @Override
    public IMapping[] getSpecialMappings() {
        ArrayList<IMapping> lMappings = new ArrayList<IMapping>();
        for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)this.m_lMappings.get(iMapping);
            if (!mapping.isSpecial()) continue;
            lMappings.add(mapping);
        }
        return lMappings.toArray(new IMapping[lMappings.size()]);
    }

    @Override
    public ITable[] getTargetTables() {
        if (DATA_TYPE.equals(this.m_sType)) {
            return new ITable[]{this.m_lookupMapping.getTargetTable()};
        }
        return new ITable[]{this.m_lookupMapping.getLookupTable()};
    }

    @Override
    public boolean isIncludedInMapping() {
        return this.m_bIncludedInMapping;
    }

    @Override
    public boolean isIncludedInPropagation() {
        return this.m_bIncludedInPropagation;
    }

    @Override
    public void mapColumns() {
        this.mapColumns(DefaultMappingRules.getRules());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapColumns(IMappingRule[] aRules) {
        this.startCompoundUndoable();
        try {
            ITable[] aSourceTables = this.getSourceTables();
            ITable[] aTargetTables = this.getTargetTables();
            for (int iDataTarget = 0; iDataTarget < aTargetTables.length; ++iDataTarget) {
                ITable tblTarget = aTargetTables[iDataTarget];
                for (int iDataSource = 0; iDataSource < aSourceTables.length; ++iDataSource) {
                    ITable tblSource = aSourceTables[iDataSource];
                    this.mapColumns(tblSource, tblTarget, aRules);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void mapColumns(ITable tblSource, ITable tblTarget) {
        this.mapColumns(tblSource, tblTarget, DefaultMappingRules.getRules());
    }

    @Override
    public void mapColumns(IColumn[] aSources, IColumn[] aTargets) {
        this.mapColumns(aSources, aTargets, DefaultMappingRules.getRules());
    }

    @Override
    public void mapColumns(ITable tblSource, ITable tblTarget, IMappingRule[] aRules) {
        this.mapColumns(tblSource.getColumns(), tblTarget.getColumns(), aRules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapColumns(IColumn[] aSources, IColumn[] aTargets, IMappingRule[] aRules) {
        this.startCompoundUndoable();
        try {
            IColumn[] aOneSource = new IColumn[1];
            IColumn[] aOneTarget = new IColumn[1];
            List lExcludedTargetColumns = this.getListOfColumnsExcludedFromMapping();
            ArrayList<IColumn> lSources = new ArrayList<IColumn>(Arrays.asList(aSources));
            lSources.removeAll(this.getSourceColumnsExcludedFromMapping());
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                IColumn tgt = aTargets[iTarget];
                if (lExcludedTargetColumns.contains(tgt)) continue;
                aOneTarget[0] = tgt;
                boolean bUnmapped = !this.existsTargetMapping(tgt);
                for (int iSource = 0; iSource < lSources.size() && bUnmapped; ++iSource) {
                    IColumn src;
                    aOneSource[0] = src = (IColumn)lSources.get(iSource);
                    if (!this.isMappingAllowed(aOneSource, aOneTarget)) continue;
                    for (int iRule = 0; iRule < aRules.length && bUnmapped; ++iRule) {
                        if (!aRules[iRule].canMap(src, tgt)) continue;
                        String sExpression = aRules[iRule].getExpressionText();
                        if (sExpression != null && sExpression.length() > 0) {
                            ITextExpression expression = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
                            expression.setText(sExpression, new IObject[]{src, src.getTable()});
                            this.addMapping(aOneSource, aOneTarget, "DERIVED", expression);
                        } else {
                            this.addMapping(aOneSource, aOneTarget, "ONETOONE", null);
                        }
                        bUnmapped = false;
                        lSources.remove(src);
                    }
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IColumn[] propagateColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns) {
        throw new UnsupportedOperationException("This container does not support propagation to source columns.");
    }

    @Override
    public IColumn[] propagateColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns, int eNonWorkTableHandling) {
        throw new UnsupportedOperationException("This container does not support propagation to source columns.");
    }

    @Override
    public void propagateColumnsToSourceTables() {
        throw new UnsupportedOperationException("This container does not support propagation to source columns.");
    }

    @Override
    public void propagateColumnsToSourceTables(int eNonWorkTableHandling) {
        throw new UnsupportedOperationException("This container does not support propagation to source columns.");
    }

    @Override
    public void propagateColumnsToSourceTables(ITable[] aSourceTables, ITable[] aTargetTables) {
        throw new UnsupportedOperationException("This container does not support propagation to source columns.");
    }

    @Override
    public void propagateColumnsToSourceTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        throw new UnsupportedOperationException("This container does not support propagation to source columns.");
    }

    @Override
    public IColumn[] propagateColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget) {
        return this.propagateColumnsToTargetTable(aSourceColumns, tblTarget, 0);
    }

    @Override
    public IColumn[] propagateColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget, int eNonWorkTableHandling) {
        if (!(tblTarget instanceof IWorkTable)) {
            if (eNonWorkTableHandling == 2) {
                return new IColumn[0];
            }
            if (eNonWorkTableHandling == 1) {
                this.mapColumns(tblTarget.getColumns(), aSourceColumns);
                return new IColumn[0];
            }
        }
        return this.propagateColumnsImpl(aSourceColumns, tblTarget, true);
    }

    @Override
    public void propagateColumnsToTargetTables() {
        this.propagateColumnsToTargetTables(0);
    }

    @Override
    public void propagateColumnsToTargetTables(int eNonWorkTableHandling) {
        this.propagateColumnsToTargetTables(this.getSourceTables(), this.getTargetTables(), eNonWorkTableHandling);
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables) {
        this.propagateColumnsToTargetTables(aSourceTables, aTargetTables, 0);
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        this.propagateColumnsImpl(aSourceTables, aTargetTables, eNonWorkTableHandling, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void propagateColumnsImpl(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling, boolean bForward) {
        this.startCompoundUndoable();
        try {
            int iTargetTable = 0;
            while (iTargetTable < aTargetTables.length) {
                block8: {
                    int iSourceTable;
                    ITable tblTarget;
                    block9: {
                        block7: {
                            tblTarget = aTargetTables[iTargetTable];
                            if (tblTarget instanceof IWorkTable) break block7;
                            if (eNonWorkTableHandling == 2) break block8;
                            if (eNonWorkTableHandling != 1) break block7;
                            break block9;
                        }
                        for (iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                            this.propagateColumnsImpl(aSourceTables[iSourceTable].getColumns(), tblTarget, bForward);
                        }
                        break block8;
                    }
                    for (iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                        if (bForward) {
                            this.mapColumns(aSourceTables[iSourceTable], tblTarget);
                            continue;
                        }
                        this.mapColumns(tblTarget, aSourceTables[iSourceTable]);
                    }
                }
                ++iTargetTable;
            }
            return;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IColumn[] propagateColumnsImpl(IColumn[] aSourceColumns, ITable tblTarget, boolean bForward) {
        IObjectFactory factory = this.getObjectFactory();
        IColumn[] aSource = new IColumn[1];
        IColumn[] aTarget = new IColumn[1];
        this.startCompoundUndoable();
        try {
            ArrayList<IColumn> lTargetColumns = new ArrayList<IColumn>();
            ArrayList<IColumn> lNewTargetColumns = new ArrayList<IColumn>();
            lTargetColumns.addAll(Arrays.asList(tblTarget.getColumns()));
            boolean bCaseSensitive = tblTarget.isCaseSensitive();
            for (int iColumn = 0; iColumn < aSourceColumns.length; ++iColumn) {
                IColumn colSource = aSourceColumns[iColumn];
                if (this.doesNameExistInColumns(colSource.getName(), lTargetColumns, bCaseSensitive)) continue;
                IColumn colTarget = factory.createNewColumn(tblTarget.getID());
                aSourceColumns[iColumn].copy(colTarget);
                tblTarget.addColumn(colTarget);
                lTargetColumns.add(colTarget);
                lNewTargetColumns.add(colTarget);
                aSource[0] = colSource;
                aTarget[0] = colTarget;
                if (bForward) {
                    this.addMapping(aSource, aTarget, "ONETOONE", null);
                    continue;
                }
                this.addMapping(aTarget, aSource, "ONETOONE", null);
            }
            IColumn[] iColumnArray = lNewTargetColumns.toArray(new IColumn[lNewTargetColumns.size()]);
            return iColumnArray;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getType() == 1 && ev.getSource() instanceof IMapping) {
            IMapping mapping = (IMapping)ev.getSource();
            if (mapping.isReplacing()) {
                this.fireModelChangedEvent("MappingsContainer:MappingChanged", ev.getSource());
            } else if (mapping.getTargetCount() == 0) {
                this.removeMapping(mapping);
            } else if (mapping.getSourceCount() == 0) {
                this.removeMapping(mapping);
            } else {
                this.fireModelChangedEvent("MappingsContainer:MappingChanged", ev.getSource());
            }
        } else {
            super.notify(ev);
        }
    }

    @Override
    public void removeMapping(IMapping mapping) {
        this.m_lookupMapping.addToDeletedObjects(mapping);
        int iMapping = this.m_lMappings.indexOf(mapping);
        this.m_lMappings.remove(iMapping);
        this.fireModelChangedEvent("MappingsContainer:MappingRemoved", mapping);
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new RemoveMappingUndoable(iMapping, mapping));
        }
        mapping.removeNotifyListener(this);
    }

    public void removeMappings() {
        for (int i = this.m_lMappings.size() - 1; i >= 0; --i) {
            this.removeMapping((IMapping)this.m_lMappings.get(i));
        }
    }

    @Override
    public void setIncludedInMapping(boolean bIncluded) {
        if (this.m_bIncludedInMapping == bIncluded) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIncludedInMappingUndoable(this.m_bIncludedInMapping, bIncluded));
        }
        this.m_bIncludedInMapping = bIncluded;
        this.fireModelChangedEvent("MappingsContainer:IncludeInMappingsChanged", null);
    }

    @Override
    public void setIncludedInPropagation(boolean bIncluded) {
        if (this.m_bIncludedInPropagation == bIncluded) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIncludedInPropagationUndoable(this.m_bIncludedInPropagation, bIncluded));
        }
        this.m_bIncludedInPropagation = bIncluded;
        this.fireModelChangedEvent("MappingsContainer:IncludeInPropagationChanged", null);
    }

    @Override
    public IColumn[] updateMappedColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns) {
        return this.updateMappedColumnsImpl(aTargetColumns, tblSource, false);
    }

    @Override
    public IColumn[] updateMappedColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget) {
        return this.updateMappedColumnsImpl(aSourceColumns, tblTarget, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IColumn[] updateMappedColumnsImpl(IColumn[] aSourceColumns, ITable tblTarget, boolean bForward) {
        this.startCompoundUndoable();
        try {
            List<IColumn> lSourceColumns = Arrays.asList(aSourceColumns);
            List<IColumn> lTargetColumns = Arrays.asList(tblTarget.getColumns());
            ArrayList<IColumn> lUpdatedColumns = new ArrayList<IColumn>();
            boolean bCaseSensitive = tblTarget.isCaseSensitive();
            for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
                boolean bEqual;
                IColumn[] aTargets;
                IMapping mapping = (IMapping)this.m_lMappings.get(iMapping);
                if (!DATA_TYPE.equals(mapping.getType())) continue;
                IColumn[] aSources = bForward ? mapping.getSources() : mapping.getTargets();
                IColumn[] iColumnArray = aTargets = bForward ? mapping.getTargets() : mapping.getSources();
                if (aSources.length != 1 || aTargets.length != 1 || !lSourceColumns.contains(aSources[0]) || !tblTarget.containsColumn(aTargets[0])) continue;
                boolean bl = bEqual = bCaseSensitive ? aSources[0].getName().equals(aTargets[0].getName()) : aSources[0].getName().equalsIgnoreCase(aTargets[0].getName());
                if (!bEqual && this.doesNameExistInColumns(aSources[0].getName(), lTargetColumns, bCaseSensitive)) continue;
                aSources[0].deepCopy(aTargets[0]);
                lUpdatedColumns.add(aTargets[0]);
            }
            IColumn[] iColumnArray = lUpdatedColumns.toArray(new IColumn[lUpdatedColumns.size()]);
            return iColumnArray;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public void updateMapping(IMapping mapping) {
        int nSources = mapping.getSourceCount();
        int nTargets = mapping.getTargetCount();
        if (nTargets == 0) {
            this.removeMapping(mapping);
        } else if (mapping.getExpression() != null) {
            mapping.setType("DERIVED");
        } else if (nSources == 0) {
            this.removeMapping(mapping);
        } else if (nSources > 1 || nTargets > 1) {
            mapping.setType("DERIVED");
        } else if (this.isExpressionNeeded(mapping.getSources()[0], mapping.getTargets()[0])) {
            mapping.setType("DERIVED");
        } else {
            mapping.setType("ONETOONE");
        }
    }

    private List getSourceColumnsExcludedFromMapping() {
        ArrayList lColumns = new ArrayList();
        ITable[] aTables = this.getSourceTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            IDataTransform[] aProducers = aTables[iTable].getProducerTransforms();
            for (int iProducer = 0; iProducer < aProducers.length; ++iProducer) {
                lColumns.addAll(aProducers[iProducer].getListOfColumnsExcludedFromMapping());
            }
        }
        return lColumns;
    }

    private boolean existsTargetMapping(IColumn colTarget) {
        return this.findTargetMapping(colTarget) != null;
    }

    protected IMapping findTargetMapping(IColumn colTarget) {
        for (int iMapping = 0; iMapping < this.m_lMappings.size(); ++iMapping) {
            IMapping mapping = (IMapping)this.m_lMappings.get(iMapping);
            IColumn[] aTargets = mapping.getTargets();
            if (aTargets.length != 1 || aTargets[0] != colTarget) continue;
            return mapping;
        }
        return null;
    }

    public final boolean isQuotingNeeded() {
        ArrayList<ITable> tables = new ArrayList<ITable>(Arrays.asList(this.getSourceTables()));
        tables.addAll(Arrays.asList(this.getTargetTables()));
        int tableSize = tables.size();
        for (int i = 0; i < tableSize; ++i) {
            ITable table;
            IDataObject dObject = (IDataObject)tables.get(i);
            if (!(dObject instanceof ITable) || !(table = (ITable)dObject).isQuoted()) continue;
            return true;
        }
        return false;
    }

    private boolean doesNameExistInColumns(String sName, List lColumns, boolean bCaseSensitive) {
        for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
            boolean bEquals;
            IColumn column = (IColumn)lColumns.get(iColumn);
            String sColumnName = column.getName();
            boolean bl = bEquals = bCaseSensitive ? sColumnName.equals(sName) : sColumnName.equalsIgnoreCase(sName);
            if (!bEquals) continue;
            return true;
        }
        return false;
    }

    protected boolean isExpressionNeeded(IColumn source, IColumn target) {
        return source.getType() != target.getType();
    }

    private class SetIncludedInMappingUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldIncludedInMapping;
        private boolean m_newIncludedInMapping;

        public SetIncludedInMappingUndoable(boolean oldIncludedInMapping, boolean newIncludedInMapping) {
            this.m_oldIncludedInMapping = oldIncludedInMapping;
            this.m_newIncludedInMapping = newIncludedInMapping;
        }

        @Override
        public void undo() {
            super.undo();
            LookupMappingsContainer.this.setIncludedInMapping(this.m_oldIncludedInMapping);
        }

        @Override
        public void redo() {
            super.redo();
            LookupMappingsContainer.this.setIncludedInMapping(this.m_newIncludedInMapping);
        }
    }

    private class SetIncludedInPropagationUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldIncludedInPropagation;
        private boolean m_newIncludedInPropagation;

        public SetIncludedInPropagationUndoable(boolean oldIncludedInPropagation, boolean newIncludedInPropagation) {
            this.m_oldIncludedInPropagation = oldIncludedInPropagation;
            this.m_newIncludedInPropagation = newIncludedInPropagation;
        }

        @Override
        public void undo() {
            super.undo();
            LookupMappingsContainer.this.setIncludedInPropagation(this.m_oldIncludedInPropagation);
        }

        @Override
        public void redo() {
            super.redo();
            LookupMappingsContainer.this.setIncludedInPropagation(this.m_newIncludedInPropagation);
        }
    }

    private class RemoveMappingUndoable
    extends AbstractUndoableEdit {
        private int m_iMapping;
        private IMapping m_mapping;

        public RemoveMappingUndoable(int iMapping, IMapping mapping) {
            this.m_iMapping = iMapping;
            this.m_mapping = mapping;
        }

        @Override
        public void undo() {
            super.undo();
            LookupMappingsContainer.this.addMapping(this.m_iMapping, this.m_mapping);
        }

        @Override
        public void redo() {
            super.redo();
            LookupMappingsContainer.this.removeMapping(this.m_mapping);
        }

        @Override
        public void die() {
            this.m_mapping = null;
        }
    }

    private class AddMappingUndoable
    extends AbstractUndoableEdit {
        private int m_iMapping;
        private IMapping m_mapping;

        public AddMappingUndoable(int iMapping, IMapping mapping) {
            this.m_iMapping = iMapping;
            this.m_mapping = mapping;
        }

        @Override
        public void undo() {
            super.undo();
            LookupMappingsContainer.this.removeMapping(this.m_mapping);
        }

        @Override
        public void redo() {
            super.redo();
            LookupMappingsContainer.this.addMapping(this.m_iMapping, this.m_mapping);
        }

        @Override
        public void die() {
            this.m_mapping = null;
        }
    }
}

