/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.hpa;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.SASHDATType;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.hpa.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IHadoopServer;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SASHadoopDataLoaderTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "SASHadoopDataLoader";
    private static final String TRANSFORMATION_ROLE = "SASHadoopDataLoader";
    private static final String ARM_DISPLAY_NAME = "SAS Data in HDFS Loader";
    private static final String BLOCKSIZE = "BLOCKSIZE";
    private static final String COPIES = "COPIES";
    private static final String REPLACE = "REPLACE";
    private static final String LOGUPDATE = "LOGUPDATE";
    public static final String BLOCKSIZE_CHANGED = "LASRClusterStageTransformModel:BlockSizeChanged";
    public static final String COPIES_CHANGED = "LASRClusterStageTransformModel:CopiesChanged";
    public static final String REPLACE_CHANGED = "LASRClusterStageTransformModel:ReplaceChanged";
    public static final String LOGUPDATE_CHANGED = "LASRClusterStageTransformModel:LogUpdateChanged";
    private static final String LIBRARY_PATH = "PATH";
    private String m_sFileBlockSize;
    private int m_iCopies;
    private boolean m_bReplace;
    private boolean m_bLog;

    public SASHadoopDataLoaderTransformModel(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getDefaultName() {
        return RB.getStringResource("SASHadoopDataLoader.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("SASHadoopDataLoader.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getTransformRole() {
        return "SASHadoopDataLoader";
    }

    @Override
    protected String getTransformClass() {
        return "SASHadoopDataLoader";
    }

    @Override
    public boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    public static String getTransformTypeID() {
        return "SASHadoopDataLoader";
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    public String getFileBlockSize() {
        return this.m_sFileBlockSize;
    }

    public void setFileBlockSize(String blockSize) {
        if (blockSize == null && this.m_sFileBlockSize == null) {
            return;
        }
        if (blockSize != null && blockSize.equals(this.m_sFileBlockSize)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFileBlockSizeUndoable(this.m_sFileBlockSize, blockSize));
        }
        this.m_sFileBlockSize = blockSize;
        this.fireModelChangedEvent(BLOCKSIZE_CHANGED, null);
    }

    public int getCopies() {
        return this.m_iCopies;
    }

    public void setCopies(int copies) {
        if (copies == this.m_iCopies) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCopiesUndoable(this.m_iCopies, copies));
        }
        this.m_iCopies = copies;
        this.fireModelChangedEvent(BLOCKSIZE_CHANGED, null);
    }

    public boolean isReplace() {
        return this.m_bReplace;
    }

    public void setReplace(boolean replace) {
        if (replace == this.m_bReplace) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetReplaceUndoable(this.m_bReplace, replace));
        }
        this.m_bReplace = replace;
        this.fireModelChangedEvent(REPLACE_CHANGED, null);
    }

    public boolean isLog() {
        return this.m_bLog;
    }

    public void setLog(boolean log) {
        if (log == this.m_bLog) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLogUndoable(this.m_bLog, log));
        }
        this.m_bLog = log;
        this.fireModelChangedEvent(LOGUPDATE_CHANGED, null);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.saveStringOptionToOMR(omr, BLOCKSIZE, this.m_sFileBlockSize);
        this.saveIntOptionToOMR(omr, COPIES, this.m_iCopies);
        this.saveBooleanOptionToOMR(omr, REPLACE, this.m_bReplace);
        this.saveBooleanOptionToOMR(omr, LOGUPDATE, this.m_bLog);
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setFileBlockSize(this.loadStringOptionFromOMR(omr, BLOCKSIZE, ""));
        this.setCopies(this.loadIntOptionFromOMR(omr, COPIES, 2));
        this.setReplace(this.loadBooleanOptionFromOMR(omr, REPLACE, false));
        this.setLog(this.loadBooleanOptionFromOMR(omr, LOGUPDATE, false));
        this.setChanged(false);
    }

    public IHadoopServer getHadoopServer() {
        IServer server;
        IPhysicalTable table;
        if (this.getDataTargetsCount() > 0 && (table = (IPhysicalTable)this.getDataTargets()[0]).getDBMSType() instanceof SASHDATType && (server = table.getDatabaseServer()) instanceof IHadoopServer) {
            return (IHadoopServer)server;
        }
        return null;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        IPhysicalTable target = (IPhysicalTable)this.getDataTargets()[0];
        IProperty path = target.getLibraryForUseInJob().findOption(LIBRARY_PATH);
        codeSegment.addSourceCode("data " + target.getFullNameQuotedAsNeeded(codeSegment));
        ITransformTableOptions targetOptions = this.getTableOptionObject(target, false);
        String targetTableOptions = targetOptions.getTableOptions(codeSegment.getCurrentServer());
        if (targetTableOptions != null && targetTableOptions.length() > 0) {
            codeSegment.indent().addSourceCode("(" + targetTableOptions + "); \n").unIndent();
        } else {
            codeSegment.addSourceCode("; \n");
        }
        codeSegment.indent().addSourceCode("set " + source.getFullNameQuotedAsNeeded(codeSegment));
        ITransformTableOptions sourceOptions = this.getTableOptionObject(source, true);
        String sourceTableOptions = sourceOptions.getTableOptions(codeSegment.getCurrentServer());
        if (sourceTableOptions != null && sourceTableOptions.length() > 0) {
            codeSegment.indent().addSourceCode("(" + sourceTableOptions + "); \n").unIndent();
        } else {
            codeSegment.addSourceCode("; \n");
        }
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;\n");
        return codeSegment;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && ((IPhysicalTable)this.getDataTargets()[0]).getDBMSType() instanceof SASHDATType;
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        if (this.getDataTargetsCount() > 0 && !(((IPhysicalTable)this.getDataTargets()[0]).getDBMSType() instanceof SASHDATType)) {
            reasons.add(RB.getStringResource("SASHadoopDataLoader.TargetTableError.txt"));
        }
        return reasons;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new OptionModel();
    }

    private class SetLogUndoable
    extends AbstractUndoableEdit {
        private boolean m_old;
        private boolean m_new;

        public SetLogUndoable(boolean bOld, boolean bNew) {
            this.m_old = bOld;
            this.m_new = bNew;
        }

        @Override
        public void undo() {
            super.undo();
            SASHadoopDataLoaderTransformModel.this.setLog(this.m_old);
        }

        @Override
        public void redo() {
            super.redo();
            SASHadoopDataLoaderTransformModel.this.setLog(this.m_new);
        }
    }

    private class SetReplaceUndoable
    extends AbstractUndoableEdit {
        private boolean m_old;
        private boolean m_new;

        public SetReplaceUndoable(boolean bOld, boolean bNew) {
            this.m_old = bOld;
            this.m_new = bNew;
        }

        @Override
        public void undo() {
            super.undo();
            SASHadoopDataLoaderTransformModel.this.setReplace(this.m_old);
        }

        @Override
        public void redo() {
            super.redo();
            SASHadoopDataLoaderTransformModel.this.setReplace(this.m_new);
        }
    }

    private class SetCopiesUndoable
    extends AbstractUndoableEdit {
        private int m_old;
        private int m_new;

        public SetCopiesUndoable(int iOld, int iNew) {
            this.m_old = iOld;
            this.m_new = iNew;
        }

        @Override
        public void undo() {
            super.undo();
            SASHadoopDataLoaderTransformModel.this.setCopies(this.m_old);
        }

        @Override
        public void redo() {
            super.redo();
            SASHadoopDataLoaderTransformModel.this.setCopies(this.m_new);
        }
    }

    private class SetFileBlockSizeUndoable
    extends AbstractUndoableEdit {
        private String m_old;
        private String m_new;

        public SetFileBlockSizeUndoable(String sOld, String sNew) {
            this.m_old = sOld;
            this.m_new = sNew;
        }

        @Override
        public void undo() {
            super.undo();
            SASHadoopDataLoaderTransformModel.this.setFileBlockSize(this.m_old);
        }

        @Override
        public void redo() {
            super.redo();
            SASHadoopDataLoaderTransformModel.this.setFileBlockSize(this.m_new);
        }
    }

    protected class OptionModel
    extends BaseDataTransformPromptModel
    implements IPromptModel {
        public OptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(SASHadoopDataLoaderTransformModel.this.getModel(), SASHadoopDataLoaderTransformModel.this);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
            this.setOptionValue(SASHadoopDataLoaderTransformModel.BLOCKSIZE, (Object)SASHadoopDataLoaderTransformModel.this.getFileBlockSize());
            this.setOptionValue(SASHadoopDataLoaderTransformModel.COPIES, (Object)SASHadoopDataLoaderTransformModel.this.getCopies());
            this.setOptionValue(SASHadoopDataLoaderTransformModel.REPLACE, (Object)(SASHadoopDataLoaderTransformModel.this.isReplace() ? "YES" : "NO"));
            this.setOptionValue(SASHadoopDataLoaderTransformModel.LOGUPDATE, (Object)(SASHadoopDataLoaderTransformModel.this.isLog() ? "YES" : "NO"));
        }

        @Override
        protected IModelListener createModelListener() {
            return new PromptModelListener();
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new PromptChangeListener();
        }

        private class PromptChangeListener
        extends BaseDataTransformValueChangedListener {
            public PromptChangeListener() {
                super(SASHadoopDataLoaderTransformModel.this, (IPromptModel)OptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (optionName.equals(SASHadoopDataLoaderTransformModel.BLOCKSIZE)) {
                        SASHadoopDataLoaderTransformModel.this.setFileBlockSize(value.toString());
                    } else if (optionName.equals(SASHadoopDataLoaderTransformModel.COPIES)) {
                        SASHadoopDataLoaderTransformModel.this.setCopies(Integer.parseInt(value.toString()));
                    } else if (optionName.equals(SASHadoopDataLoaderTransformModel.REPLACE)) {
                        SASHadoopDataLoaderTransformModel.this.setReplace(value.equals("YES"));
                    } else if (optionName.equals(SASHadoopDataLoaderTransformModel.LOGUPDATE)) {
                        SASHadoopDataLoaderTransformModel.this.setLog(value.equals("YES"));
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }

        private class PromptModelListener
        extends BaseDataTransformModelListener {
            public PromptModelListener() {
                super(SASHadoopDataLoaderTransformModel.this, OptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (type.equals(SASHadoopDataLoaderTransformModel.BLOCKSIZE_CHANGED)) {
                        OptionModel.this.setOptionValue(SASHadoopDataLoaderTransformModel.BLOCKSIZE, (Object)SASHadoopDataLoaderTransformModel.this.getFileBlockSize());
                    } else if (type.equals(SASHadoopDataLoaderTransformModel.COPIES_CHANGED)) {
                        OptionModel.this.setOptionValue(SASHadoopDataLoaderTransformModel.COPIES, (Object)SASHadoopDataLoaderTransformModel.this.getCopies());
                    } else if (type.equals(SASHadoopDataLoaderTransformModel.REPLACE_CHANGED)) {
                        OptionModel.this.setOptionValue(SASHadoopDataLoaderTransformModel.REPLACE, (Object)(SASHadoopDataLoaderTransformModel.this.isReplace() ? "YES" : "NO"));
                    } else if (type.equals(SASHadoopDataLoaderTransformModel.LOGUPDATE_CHANGED)) {
                        OptionModel.this.setOptionValue(SASHadoopDataLoaderTransformModel.LOGUPDATE, (Object)(SASHadoopDataLoaderTransformModel.this.isLog() ? "YES" : "NO"));
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }
    }
}

