/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.hpa;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.SASIOLAType;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.hpa.LASRLoaderTransformModel;
import com.sas.etl.models.job.transforms.hpa.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ILASRServer;
import com.sas.etl.models.other.IServer;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class LASRUnloaderTransformModel
extends AbstractDataTransform {
    private static final String TRANSFORMATION_CLASS = "LASRUnloader";
    private static final String TRANSFORMATION_ROLE = "LASRUnloader";
    private static final String ARM_DISPLAY_NAME = "SAS LASR Analytic Server Unloader";
    private static final String ADDITIONAL_PROC_OPTIONS = "ADDITIONAL_PROC_OPTIONS";
    private static final String ADDITIONAL_PROC_OPTIONS_CHANGED = "LasrLoaderTransformModel:ADDITIONAL_PROC_OPTIONS_CHANGED";
    private String m_additionalProcOpts;

    public LASRUnloaderTransformModel(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getDefaultName() {
        return RB.getStringResource("LASRUnloaderTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("LASRUnloaderTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getTransformRole() {
        return "LASRUnloader";
    }

    @Override
    protected String getTransformClass() {
        return "LASRUnloader";
    }

    public static String getTransformTypeID() {
        return "LASRUnloader";
    }

    public String getAdditionalProcOptions() {
        return this.m_additionalProcOpts;
    }

    public void setAdditionalProcOptions(String opts) {
        if (ObjectComparator.isEqual(opts, this.m_additionalProcOpts)) {
            return;
        }
        String old = this.m_additionalProcOpts;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAdditionalProcOptionsUndoable(this.m_additionalProcOpts, opts));
        }
        this.m_additionalProcOpts = opts;
        this.fireModelChangedEvent(ADDITIONAL_PROC_OPTIONS_CHANGED, this.m_additionalProcOpts, old);
    }

    @Override
    public boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    public boolean doesNoTargetsMeanIncomplete() {
        return false;
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.saveStringOptionToOMR(omr, ADDITIONAL_PROC_OPTIONS, this.getAdditionalProcOptions());
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setAdditionalProcOptions(this.loadStringOptionFromOMR(omr, ADDITIONAL_PROC_OPTIONS, null));
        this.setChanged(false);
    }

    public ILASRServer getLASRServer() {
        IServer server;
        IPhysicalTable table;
        if (this.getDataSourcesCount() > 0 && (table = (IPhysicalTable)this.getDataSources()[0]).getDBMSType() instanceof SASIOLAType && (server = table.getDatabaseServer()) instanceof ILASRServer) {
            return (ILASRServer)server;
        }
        return null;
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        IPhysicalTable source = (IPhysicalTable)this.getDataSources()[0];
        String tag = ((SASIOLAType)source.getDBMSType()).getTag(source);
        codeSegment.addSourceCode("proc lasr port = ").addSourceCode(Integer.toString(this.getLASRServer().getPort()));
        String add = this.getAdditionalProcOptions();
        if (add != null && add.length() > 0) {
            codeSegment.addSourceCode(" ").addSourceCode(add);
        }
        codeSegment.addSourceCode(";");
        codeSegment.newLine();
        codeSegment.indent();
        codeSegment.addSourceCode("remove " + (tag != null && tag.length() > 0 ? tag + "." : "") + source.getTableName());
        ITransformTableOptions sourceOptions = this.getTableOptionObject(source, true);
        String sourceTableOptions = sourceOptions.getTableOptions(codeSegment.getCurrentServer());
        if (sourceTableOptions != null && sourceTableOptions.length() > 0) {
            codeSegment.indent().addSourceCode("(" + sourceTableOptions + ") \n").unIndent();
        }
        codeSegment.addSourceCode(";");
        codeSegment.newLine();
        codeSegment.addSourceCode("performance host=\"" + this.getLASRServer().getHost() + "\";");
        codeSegment.newLine();
        codeSegment.unIndent();
        codeSegment.addSourceCode("run;");
        codeSegment.newLine();
        return codeSegment;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && ((IPhysicalTable)this.getDataSources()[0]).getDBMSType() instanceof SASIOLAType;
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        if (this.getDataSourcesCount() > 0 && !(((IPhysicalTable)this.getDataSources()[0]).getDBMSType() instanceof SASIOLAType)) {
            reasons.add(RB.getStringResource("LASRUnloaderTransformModel.SourceTableError.txt"));
        }
        return reasons;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new OptionModel();
    }

    private class SetAdditionalProcOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_old;
        private String m_new;

        public SetAdditionalProcOptionsUndoable(String sOld, String sNew) {
            this.m_old = sOld;
            this.m_new = sNew;
        }

        @Override
        public void undo() {
            super.undo();
            LASRUnloaderTransformModel.this.setAdditionalProcOptions(this.m_old);
        }

        @Override
        public void redo() {
            super.redo();
            LASRUnloaderTransformModel.this.setAdditionalProcOptions(this.m_new);
        }
    }

    protected class OptionModel
    extends BaseDataTransformPromptModel
    implements IPromptModel {
        public OptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(LASRUnloaderTransformModel.this.getModel(), LASRUnloaderTransformModel.this);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(LASRLoaderTransformModel.class.getResource("res/Options_LASR_Unloader_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
            this.setOptionValue(LASRUnloaderTransformModel.ADDITIONAL_PROC_OPTIONS, (Object)LASRUnloaderTransformModel.this.getAdditionalProcOptions());
        }

        @Override
        protected IModelListener createModelListener() {
            return new PromptModelListener();
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new PromptChangeListener();
        }

        private class PromptChangeListener
        extends BaseDataTransformValueChangedListener {
            public PromptChangeListener() {
                super(LASRUnloaderTransformModel.this, (IPromptModel)OptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (LASRUnloaderTransformModel.ADDITIONAL_PROC_OPTIONS.equals(optionName)) {
                        LASRUnloaderTransformModel.this.setAdditionalProcOptions(value != null ? value.toString() : null);
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }

        private class PromptModelListener
        extends BaseDataTransformModelListener {
            public PromptModelListener() {
                super(LASRUnloaderTransformModel.this, OptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (LASRUnloaderTransformModel.ADDITIONAL_PROC_OPTIONS_CHANGED.equals(type)) {
                        OptionModel.this.setOptionValue(LASRUnloaderTransformModel.ADDITIONAL_PROC_OPTIONS, ev.getData());
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }
    }
}

