/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.fork.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.fork.IParameterMapping;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import java.rmi.RemoteException;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseParameterMapping
extends AbstractPersistableObject
implements IParameterMapping {
    private IColumn m_srcColumn;
    private String m_sTransformationID;
    private boolean m_bIsRowNumber = false;
    public static final String ROW_NUMBER_COLUMN = "_n_";

    public BaseParameterMapping(String sId, IModel model) {
        super(sId, model);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        omr.deleteOMRObject(this.m_sTransformationID, "Transformation");
        Property prop = (Property)omr.acquireOMRObject(this);
        PropertyType propType = prop.getOwningType();
        if (propType != null) {
            omr.deleteOMRObject(propType.getFQID(), propType.getCMetadataType());
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        this.m_sTransformationID = this.updateSubordinateID(this.m_sTransformationID, mapIDs);
    }

    @Override
    public boolean isRowNumber() {
        return this.m_bIsRowNumber;
    }

    @Override
    public void setIsRowNumber(boolean isRowNumber) {
        if (this.m_bIsRowNumber == isRowNumber) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIsRowNumberUndoable(this.m_bIsRowNumber, isRowNumber));
        }
        this.m_bIsRowNumber = isRowNumber;
        this.fireModelChangedEvent("IParameterMapping:SourceColumnChanged", this.m_srcColumn);
    }

    @Override
    public void setSourceColumn(IColumn sourceColumn) {
        if (this.m_srcColumn == sourceColumn) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSourceColumnUndoable(this.m_srcColumn, sourceColumn));
        }
        this.m_srcColumn = sourceColumn;
        this.fireModelChangedEvent("IParameterMapping:SourceColumnChanged", this.m_srcColumn);
    }

    @Override
    public IColumn getSourceColumn() {
        return this.m_srcColumn;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "Property";
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Property prop = (Property)omr.acquireOMRObject(this);
        String name = this.getName();
        if (name.startsWith("OPTION.")) {
            this.setName(name.substring(7));
        }
        AssociationList lstTrans = prop.getSpecTargetTransformations();
        this.m_sTransformationID = null;
        if (ROW_NUMBER_COLUMN.equals(prop.getDefaultValue())) {
            this.setIsRowNumber(true);
        } else {
            IColumn sourceColumn = null;
            if (!lstTrans.isEmpty()) {
                Transformation trans = (Transformation)lstTrans.get(0);
                this.m_sTransformationID = trans.getFQID();
                AssociationList columns = trans.getSourceSpecifications();
                if (!columns.isEmpty()) {
                    sourceColumn = (IColumn)omr.acquireObject((Root)columns.get(0));
                }
            }
            this.setSourceColumn(sourceColumn);
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws RemoteException, MdException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Property prop = (Property)omr.acquireOMRObject(this);
        prop.setPropertyName(this.getName());
        prop.setPropertyRole(this.getName());
        if (this.isRowNumber()) {
            prop.setDefaultValue(ROW_NUMBER_COLUMN);
            if (this.m_sTransformationID != null && this.isNewObjectID(this.m_sTransformationID)) {
                omr.deleteOMRObject(this.m_sTransformationID, "Transformation");
            }
        } else {
            prop.setDefaultValue(this.getName());
            if (this.m_sTransformationID == null) {
                this.m_sTransformationID = this.createIDForNewObject();
            }
            Transformation trans = (Transformation)omr.acquireOMRObject(this.m_sTransformationID, "Transformation");
            trans.setName(this.getName());
            trans.setTransformRole(this.getName());
            AssociationList specTargets = prop.getSpecTargetTransformations(false);
            specTargets.clear();
            specTargets.add(trans);
            AssociationList sourceSpecs = trans.getSourceSpecifications(false);
            sourceSpecs.clear();
            IColumn column = this.getSourceColumn();
            if (column != null) {
                sourceSpecs.add(omr.acquireOMRObject(column));
            }
        }
        this.setChanged(false);
    }

    private class SetIsRowNumberUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldRowNumber;
        private boolean m_newRowNumber;

        public SetIsRowNumberUndoable(boolean oldRowNumber, boolean newRowNumber) {
            this.m_oldRowNumber = oldRowNumber;
            this.m_newRowNumber = newRowNumber;
        }

        @Override
        public void undo() {
            BaseParameterMapping.this.setIsRowNumber(this.m_oldRowNumber);
        }

        @Override
        public void redo() {
            BaseParameterMapping.this.setIsRowNumber(this.m_newRowNumber);
        }
    }

    private class SetSourceColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldColumn;
        private IColumn m_newColumn;

        public SetSourceColumnUndoable(IColumn oldColumn, IColumn newColumn) {
            this.m_oldColumn = oldColumn;
            this.m_newColumn = newColumn;
        }

        @Override
        public void undo() {
            BaseParameterMapping.this.setSourceColumn(this.m_oldColumn);
        }

        @Override
        public void redo() {
            BaseParameterMapping.this.setSourceColumn(this.m_newColumn);
        }
    }
}

