/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.facttable;

import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.DBMSNamesUtil;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.dataValidation.ValidationUtil;
import com.sas.etl.models.job.transforms.facttable.FactTableTransformModel;
import com.sas.etl.models.job.transforms.facttable.IFactTableMapping;
import com.sas.etl.models.job.transforms.facttable.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FactTableCodegen {
    private static FactTableTransformModel m_oFTTModel;
    protected static String moveAction;
    protected static String abortAction;
    private static final String MACRO_NAME = "etls_factTableLookup";
    private static final String MOVE = "MOVE";
    private static final String ABORT = "ABORT";
    private static final String NONE = "NONE";
    private static final String WORK_FMT_TABLE = "work.etls_fmtData";
    private static final String WORK_EXCEPTIONS_TABLE = "work.etls_Exceptions";
    private static final String NUMERIC = "N";
    private static final String CHARACTER = "C";
    private static final String INFMT = "I";

    public FactTableCodegen(FactTableTransformModel model) {
        m_oFTTModel = model;
    }

    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws BadLibraryDefinitionException, CodegenException, RemoteException, BadServerDefinitionException, ServerException, MdException {
        IPhysicalTable sourceTable = m_oFTTModel.getSourceTable();
        IPhysicalTable targetTable = m_oFTTModel.getTargetTable();
        String targetDSName = targetTable.getFullNameQuotedAsNeeded(codeSegment);
        String errorDSName = m_oFTTModel.getErrorTableName();
        boolean needExceptionTable = ValidationUtil.isExceptionTableNeeded(m_oFTTModel);
        List<IFactTableMapping> lFactTableLkups = Arrays.asList(m_oFTTModel.getFactTableMappings());
        ArrayList<IColumn> ignoreColumnsList = new ArrayList<IColumn>();
        boolean abort = false;
        boolean move = false;
        for (int i = 0; i < lFactTableLkups.size(); ++i) {
            IFactTableMapping FTLkup_i = lFactTableLkups.get(i);
            IColumn targetColumn = FTLkup_i.getTargetColumn();
            ignoreColumnsList.add(targetColumn);
            String action = FTLkup_i.getAction();
            if (action.equals(moveAction)) {
                move = true;
                continue;
            }
            if (!action.equals(abortAction)) continue;
            abort = true;
        }
        if (lFactTableLkups.size() <= 0) {
            codeSegment.addCommentLine(RB.getStringResource("FactTableCodegen.NoLookups.comment.txt"));
            String mappingStepOutputName = "";
            boolean bIsMappingStepNeeded = m_oFTTModel.isMappingNeeded(codeSegment.isQuoting(), sourceTable, targetTable, null, true);
            if (bIsMappingStepNeeded) {
                mappingStepOutputName = codeSegment.getUniqueWorkTableName(true, 0);
                m_oFTTModel.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, mappingStepOutputName, "&SYSLAST", "", m_oFTTModel.getTableOptionObject(targetTable, false).getTableOptions(codeSegment.getCurrentServer()), true, true, true, ignoreColumnsList.toArray(new IColumn[ignoreColumnsList.size()]), null, false, null, null, null);
            }
            codeSegment.addSourceCode("data " + targetDSName + ";\n").indent().addSourceCode("set &SYSLAST; \n").unIndent().addSourceCode("run; \n").genRCSetCall("&syserr");
            if (bIsMappingStepNeeded && !targetTable.isView()) {
                codeSegment.genTableDelete(mappingStepOutputName);
            }
            return codeSegment;
        }
        String keepList = "keep = " + codeSegment.makeColumnList(sourceTable, false, "                ", false, " ", "", codeSegment.isQuoting(), "");
        codeSegment.addSourceCode("%macro etls_factTableLookup; \n\n").indent().addSourceCode("%let etls_sourceTable = &SYSLAST; \n\n");
        ValidationUtil.genMakeReportMacro(m_oFTTModel, codeSegment, sourceTable, false);
        ValidationUtil.genAbortJobMacro(codeSegment, abort);
        if (!targetTable.getTableName().equals(sourceTable.getTableName())) {
            codeSegment.genTableDelete(targetTable);
        }
        ValidationUtil.setupErrorTable(codeSegment, errorDSName, move);
        this.genFormats(codeSegment, lFactTableLkups);
        codeSegment.addSourceCode("%let m_excp = 0;\n");
        if (abort) {
            codeSegment.addSourceCode("%let m_abort = 0; \n");
        }
        codeSegment.addSourceCode("\n");
        boolean bIsMappingStepNeeded = m_oFTTModel.isMappingNeeded(codeSegment.isQuoting(), sourceTable, targetTable, ignoreColumnsList);
        ITransformTableOptions oSourceTableOptions = m_oFTTModel.getTableOptionObject(sourceTable, true);
        String sSourceTableOptions = "";
        if (oSourceTableOptions != null) {
            sSourceTableOptions = oSourceTableOptions.getTableOptions(true, codeSegment.getCurrentServer());
        }
        ITransformTableOptions oTargetTableOptions = m_oFTTModel.getTableOptionObject(targetTable, false);
        String sTargetTableOptions = "";
        if (oTargetTableOptions != null) {
            sTargetTableOptions = oTargetTableOptions.getTableOptions(true, codeSegment.getCurrentServer());
        }
        codeSegment.addSectionComment(RB.getStringResource("FactTableCodegen.BeginLookups.comment.txt")).addSourceCode("data ").addSourceCode(targetDSName);
        if (needExceptionTable) {
            StringBuffer exceptionColumns = new StringBuffer("x_row x_naturalKey x_surrogateKey x_nkValue x_action");
            codeSegment.addSourceCode("\n").indent().addSourceCode("     (drop = ").addSourceCode(exceptionColumns).addSourceCode(")").unIndent().addSourceCode("\n").addSourceCode("     work.etls_Exceptions \n").indent().addSourceCode("     (keep = ").addSourceCode(exceptionColumns).addSourceCode(")").unIndent();
        }
        if (move) {
            codeSegment.addSourceCode("\n").addSourceCode("     work.etls_Errors\n").indent().addSourceCode("     (" + keepList + ")").unIndent();
        }
        codeSegment.addSourceCode("; \n\n");
        codeSegment.indent().addSourceCode("set &etls_sourceTable" + sSourceTableOptions + " end = eof;\n\n");
        if (needExceptionTable) {
            codeSegment.addCommentLine(RB.getStringResource("FactTableCodegen.ETLExceptionsColumns.comment.txt"));
            this.genExcpColumns(codeSegment);
            codeSegment.addSourceCode("x_row = _n_;\n\n");
        }
        if (move) {
            codeSegment.addSourceCode("i_move = 0;\n");
        }
        if (abort) {
            codeSegment.addSourceCode("retain i_abort 0; \n");
        }
        codeSegment.addSourceCode("retain i_excp 0; \n\n");
        this.genCreateFactKey(codeSegment, lFactTableLkups, targetDSName, needExceptionTable);
        ValidationUtil.genExceptionHandling(codeSegment, targetDSName, "work.etls_Errors", move, abort);
        codeSegment.unIndent().addSourceCode("\n").addSourceCode("run; \n\n").genRCSetCall("&syserr");
        if (move) {
            ValidationUtil.genUpdateErrorTable(codeSegment, "work.etls_Errors", errorDSName);
            codeSegment.genTableDelete("work.etls_Errors");
        }
        if (abort) {
            codeSegment.addSourceCode("%abortJob; \n\n");
        }
        if (needExceptionTable) {
            codeSegment.addSourceCode("%makeReport; \n\n");
        }
        String mappingStepOutputName = "";
        if (bIsMappingStepNeeded) {
            mappingStepOutputName = codeSegment.getUniqueWorkTableName(true, 0);
            m_oFTTModel.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, mappingStepOutputName, targetDSName, "", "", true, true, true, ignoreColumnsList.toArray(new IColumn[ignoreColumnsList.size()]), null, false, null, null, null);
            codeSegment.addSourceCode("data " + targetDSName + sTargetTableOptions + "; \n").indent().addSourceCode("set " + mappingStepOutputName + "; \n").unIndent().addSourceCode("run; \n\n");
            if (!targetTable.isView()) {
                codeSegment.genTableDelete(mappingStepOutputName);
            }
        }
        codeSegment.addSourceCode("%goto endMacro; \n\n").unIndent().addSourceCode("%error: \n").indent().addSourceCode("%let sysrc = 9999; \n").genRCSetCall("&sysrc").unIndent().addSourceCode("%endMacro: \n");
        codeSegment.addSourceCode("%mend etls_factTableLookup;\n\n").addSourceCode("%etls_factTableLookup;\n\n");
        return codeSegment;
    }

    private void genExcpColumns(ICodeSegment codeSegment) {
        codeSegment.addSourceCode("attrib x_row          length=8   label=\"").addSourceCode(RB.getStringResource("FactTableCodegen.RowNumber.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_naturalKey   length=$50 label=\"").addSourceCode(RB.getStringResource("FactTableCodegen.NaturalKey.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_surrogateKey length=$50 label=\"").addSourceCode(RB.getStringResource("FactTableCodegen.SurrogateKey.txt")).addSourceCode("\";\n").addSourceCode("attrib x_nkValue      length=$50 label=\"").addSourceCode(RB.getStringResource("FactTableCodegen.NaturalKeyValue.label.txt")).addSourceCode("\";\n").addSourceCode("attrib x_action       length=$50  label=\"").addSourceCode(RB.getStringResource("FactTableCodegen.ActionTaken.label.txt")).addSourceCode("\";\n\n");
    }

    private void genFormats(ICodeSegment codeSegment, List lFactTableRecords) throws BadLibraryDefinitionException, CodegenException {
        for (int i = 0; i < lFactTableRecords.size(); ++i) {
            IColumn startColumn;
            IFactTableMapping oFTMapping = (IFactTableMapping)lFactTableRecords.get(i);
            IColumn sourceColumn = oFTMapping.getSourceColumn();
            int colLength = 32;
            if (sourceColumn.getType() == 0) {
                colLength = sourceColumn.getLength();
            }
            if ((startColumn = oFTMapping.getTranslationSourceColumn()) == null) {
                throw new CodegenException(RB.getStringResource("FactTableCodegen.NoFromColumn.message.txt"), (IObject)m_oFTTModel);
            }
            IColumn labelColumn = oFTMapping.getTranslationTargetColumn();
            if (labelColumn == null) {
                throw new CodegenException(RB.getStringResource("FactTableCodegen.NoToColumn.message.txt="), (IObject)m_oFTTModel);
            }
            IPhysicalTable lookupTable = (IPhysicalTable)startColumn.getTable();
            if (lookupTable == null) {
                throw new CodegenException(RB.getStringResource("FactTableCodegen.NoLookupTable.message.txt"), (IObject)m_oFTTModel);
            }
            String tableName = lookupTable.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), false, false, false, "");
            String unquotedTableName = tableName.replaceAll("\"", "\"\"");
            String libRef = DBMSNamesUtil.getLibrefPart(tableName);
            tableName = DBMSNamesUtil.getTableNamePart(tableName);
            try {
                lookupTable.genAccessPath(codeSegment, null);
            }
            catch (MdException e) {
                throw new CodegenException((Exception)((Object)e), (IObject)lookupTable);
            }
            catch (BadLibraryDefinitionException e) {
                throw new CodegenException(e, (IObject)lookupTable);
            }
            catch (BadServerDefinitionException e) {
                throw new CodegenException(e, (IObject)lookupTable);
            }
            catch (RemoteException e) {
                throw new CodegenException(e, (IObject)lookupTable);
            }
            catch (ServerException e) {
                throw new CodegenException(e, (IObject)lookupTable);
            }
            String startColumnType = startColumn.getType() == 0 ? CHARACTER : NUMERIC;
            String labelColumnType = labelColumn.getType() == 0 ? CHARACTER : NUMERIC;
            String formatType = labelColumnType.equals(NUMERIC) ? INFMT : startColumnType;
            String startColumnName = startColumn.getColumnName(false);
            String labelColumnName = labelColumn.getColumnName(false);
            String unquotedStartColumnName = startColumnName.replaceAll("\"", "\"\"");
            String unquotedLabelColumnName = labelColumnName.replaceAll("\"", "\"\"");
            boolean bLkpNeedQuotes = lookupTable.isQuoted();
            boolean bNeedValidVarnameReset = false;
            if (bLkpNeedQuotes) {
                startColumnName = DBMSNamesUtil.getQuotedString(startColumnName, false);
                labelColumnName = DBMSNamesUtil.getQuotedString(labelColumnName, false);
                tableName = libRef + "." + DBMSNamesUtil.getQuotedString(tableName, false);
                if (!codeSegment.isQuoting()) {
                    if (this.isQuotingNeededForTargetColumns(codeSegment, lFactTableRecords)) {
                        codeSegment.setQuoting(true);
                        codeSegment.genValidvarnameOptionAny(false);
                    } else {
                        codeSegment.genValidvarnameOptionAny(true);
                        bNeedValidVarnameReset = true;
                    }
                }
            } else {
                tableName = libRef + "." + tableName;
            }
            String originalUnquotedTableName = unquotedTableName;
            String formatName = "_" + String.valueOf(i).trim() + "FMT";
            codeSegment.addSectionComment(MessageFormat.format(RB.getStringResource("FactTableCodegen.CreateFormatSection.comment.txt"), unquotedTableName));
            codeSegment.addSourceCode("data _null_; \n\n").indent().addSourceCode("dsid = open(\"" + unquotedTableName + "\"); \n").addSourceCode("call symput(\"etls_dsid\", compress(put(dsid, 10.))); \n\n").addSourceCode("if (dsid gt 0) then \n").addSourceCode("do; ").addCommentLine(RB.getStringResource("FactTableCodegen.TableOpened.comment.txt")).addSourceCode(" \n").indent().addSourceCode("varnum = varnum(dsid, \"").addSourceCode(unquotedStartColumnName).addSourceCode("\"); \n").addSourceCode("call symput(\"etls_startVar\", compress(put(varnum, 10.))); \n").addSourceCode("varnum = varnum(dsid, \"").addSourceCode(unquotedLabelColumnName).addSourceCode("\"); \n").addSourceCode("call symput(\"etls_labelVar\", compress(put(varnum, 10.))); \n").addSourceCode("call symput(\"etls_anyRecords\", put(attrn(dsid, \"ANY\"), 1.)); \n").addSourceCode("dsid = close(dsid); \n\n").unIndent().addSourceCode("end; ").addCommentLine(RB.getStringResource("FactTableCodegen.TableOpened.comment.txt")).addSourceCode(" \n").unIndent().addSourceCode("run; \n\n").addSourceCode("%if (&etls_dsid eq 0) %then \n").addSourceCode("%do; \n").indent().genPercentPutStatement(RB.getStringResource("FactTableCodegen.TableNotOpened.comment.sasmacro.notrans"), "ERROR%QUOTE(:)").addSourceCode("%goto error; \n").unIndent().addSourceCode("%end; \n\n").addSourceCode("%if (&etls_startVar eq 0) %then \n").addSourceCode("%do; \n").indent().genPercentPutStatement(MessageFormat.format(RB.getStringResource("FactTableCodegen.NoStartColumn.sasmacro.notrans"), unquotedStartColumnName, originalUnquotedTableName), "ERROR%QUOTE(:)").addSourceCode("%goto error; \n").unIndent().addSourceCode("%end; \n\n").addSourceCode("%if (&etls_labelVar eq 0) %then \n").addSourceCode("%do; \n").indent().genPercentPutStatement(MessageFormat.format(RB.getStringResource("FactTableCodegen.NoLabelColumn.sasmacro.notrans"), unquotedLabelColumnName, originalUnquotedTableName), "ERROR%QUOTE(:)").addSourceCode("%goto error; \n").unIndent().addSourceCode("%end; \n\n").addSourceCode("%if (&etls_anyRecords eq 0) %then \n").addSourceCode("%do; \n").indent().genPercentPutStatement(MessageFormat.format(RB.getStringResource("FactTableCodegen.NoRecords.sasmacro.notrans"), originalUnquotedTableName), "ERROR%QUOTE(:)").addSourceCode("%goto error; \n").unIndent().addSourceCode("%end; \n\n").addCommentLine(RB.getStringResource("FactTableCodegen.MakeFormat.comment.txt")).addSourceCode("data ").addSourceCode(WORK_FMT_TABLE).addSourceCode(" (keep = fmtName start label type hlo default); \n\n").indent().addSourceCode("length label ");
            if (formatType.equals(INFMT)) {
                codeSegment.addSourceCode("8");
            } else {
                codeSegment.addSourceCode("$32");
            }
            codeSegment.addSourceCode("\n").addSourceCode("       start ");
            if (startColumnType.equals(NUMERIC) && !formatType.equals(INFMT)) {
                codeSegment.addSourceCode("8");
            } else {
                codeSegment.addSourceCode("$32");
            }
            codeSegment.addSourceCode("; \n\n").addSourceCode("set " + tableName + " end = eof; \n\n");
            if (startColumnType.equals(NUMERIC) && formatType.equals(INFMT)) {
                codeSegment.addSourceCode("start = left(put(").addSourceCode(startColumnName).addSourceCode(",32.)); \n");
            } else {
                codeSegment.addSourceCode("start = ").addSourceCode(startColumnName).addSourceCode("; \n");
            }
            codeSegment.addSourceCode("label = ").addSourceCode(labelColumnName).addSourceCode("; \n").addSourceCode("fmtName = \"").addSourceCode(formatName).addSourceCode("\"; \n").addSourceCode("type = \"").addSourceCode(formatType).addSourceCode("\"; \n").addSourceCode("default = ").addSourceCode(String.valueOf(colLength)).addSourceCode("; \n\n").addSourceCode("output; \n\n").addSourceCode("if eof then \n").addSourceCode("do; \n").indent().addSourceCode("start = ");
            if (startColumnType.equals(NUMERIC) && !formatType.equals(INFMT)) {
                codeSegment.addSourceCode("-9999999");
            } else {
                codeSegment.addSourceCode("\"-9999999\"");
            }
            codeSegment.addSourceCode("; \n").addSourceCode("hlo = \"O\"; \n");
            if (formatType.equals(INFMT)) {
                codeSegment.addSourceCode("label = -1; \n");
            } else {
                codeSegment.addSourceCode("label = \"-1\"; \n");
            }
            codeSegment.addSourceCode("output; \n").unIndent().addSourceCode("end; \n\n").unIndent().addSourceCode("run; \n\n").addSourceCode("%if (&syserr gt 4) %then \n").indent().addSourceCode("%goto error; \n\n").unIndent().addCommentLine(RB.getStringResource("FactTableCodegen.DeleteDups.comment.txt")).addSourceCode("proc sort data = ").addSourceCode(WORK_FMT_TABLE).addSourceCode(" nodupkey; \n").indent().addSourceCode("by start; \n").unIndent().addSourceCode("run; \n\n").addSourceCode("%if (&syserr gt 4) %then \n").indent().addSourceCode("%goto error; \n\n").unIndent().addCommentLine(RB.getStringResource("FactTableCodegen.CreateFormat.comment.txt")).addSourceCode("proc format cntlin = ").addSourceCode(WORK_FMT_TABLE).addSourceCode(" library = work; \n").addSourceCode("run; \n\n").addSourceCode("%if (&syserr gt 4) %then \n").indent().addSourceCode("%goto error; \n\n").unIndent().genTableDelete(WORK_FMT_TABLE);
            if (!bNeedValidVarnameReset) continue;
            codeSegment.genValidvarnameOptionReset();
        }
    }

    private boolean isQuotingNeededForTargetColumns(ICodeSegment codeSegment, List lFactTableRecords) {
        for (int i = 0; i < lFactTableRecords.size(); ++i) {
            IFactTableMapping factTableRecord_i = (IFactTableMapping)lFactTableRecords.get(i);
            IColumn targetColumn = factTableRecord_i.getTargetColumn();
            if (targetColumn == null || targetColumn.isColumnNameValidSASV7()) continue;
            return true;
        }
        return false;
    }

    private void genCreateFactKey(ICodeSegment codeSegment, List lFactTableRecords, String targetDSName, boolean needExceptionTable) throws CodegenException, MdException {
        for (int i = 0; i < lFactTableRecords.size(); ++i) {
            IFactTableMapping factTableRecord_i = (IFactTableMapping)lFactTableRecords.get(i);
            IColumn sourceColumn = factTableRecord_i.getSourceColumn();
            if (sourceColumn == null) {
                throw new CodegenException(RB.getStringResource("FactTableCodegen.NoFromColumn.message.txt"), (IObject)m_oFTTModel);
            }
            String sourceColumnName = sourceColumn.getColumnName(codeSegment);
            String unquotedSourceColumnName = sourceColumn.getColumnName(false).replaceAll("\"", "\"\"");
            IColumn targetColumn = factTableRecord_i.getTargetColumn();
            if (targetColumn == null) {
                throw new CodegenException(RB.getStringResource("FactTableCodegen.NoToColumn.message.txt"), (IObject)m_oFTTModel);
            }
            String targetColumnName = targetColumn.getColumnName(codeSegment);
            String unquotedTargetColumnName = targetColumn.getColumnName(false).replaceAll("\"", "\"\"");
            String action = factTableRecord_i.getAction();
            String strActionToDisplay = RB.getStringResource("FactTableCodegen.Action.None.txt");
            String actionFlag = NONE;
            if (action.equals(moveAction)) {
                actionFlag = MOVE;
                strActionToDisplay = RB.getStringResource("FactTableCodegen.Action.MoveRowToErrorTable.txt");
            } else if (action.equals(abortAction)) {
                actionFlag = ABORT;
                strActionToDisplay = RB.getStringResource("FactTableCodegen.Action.AbortJob.txt");
            }
            String sourceType = sourceColumn.getType() == 0 ? CHARACTER : NUMERIC;
            String targetType = targetColumn.getType() == 0 ? CHARACTER : NUMERIC;
            String formatType = targetType.equals(NUMERIC) ? INFMT : sourceType;
            String formatName = "_" + String.valueOf(i).trim() + "FMT.";
            if (formatType.equalsIgnoreCase(CHARACTER)) {
                formatName = "$" + formatName;
            }
            codeSegment.addSectionComment(RB.getStringResource("FactTableCodegen.CreateSurrogateKey.comment.txt"));
            String nkValueName = "etls_nkValue" + String.valueOf(i);
            if (sourceType.equals(CHARACTER)) {
                String sourceLength = String.valueOf(sourceColumn.getLength()).trim();
                codeSegment.addSourceCode("length ").addSourceCode(nkValueName).addSourceCode(" $").addSourceCode(sourceLength).addSourceCode("; \n");
            }
            codeSegment.addSourceCode(nkValueName).addSourceCode(" = ").addSourceCode(sourceColumnName).addSourceCode("; \n");
            codeSegment.addSourceCode("drop ").addSourceCode(nkValueName).addSourceCode("; \n\n");
            if (formatType.equals(INFMT)) {
                codeSegment.addSourceCode(targetColumnName).addSourceCode(" = input(");
                if (sourceType.equals(NUMERIC)) {
                    codeSegment.addSourceCode("left(put(").addSourceCode(nkValueName).addSourceCode(",32.))");
                } else {
                    codeSegment.addSourceCode(nkValueName);
                }
                codeSegment.addSourceCode(", ").addSourceCode(formatName).addSourceCode("); \n\n").addSourceCode("if ((").addSourceCode(targetColumnName).addSourceCode(" eq -1) or \n").addSourceCode("    (").addSourceCode(targetColumnName).addSourceCode(" eq .)) then \n");
            } else {
                codeSegment.addSourceCode(targetColumnName).addSourceCode(" = put(").addSourceCode(nkValueName).addSourceCode(", ").addSourceCode(formatName).addSourceCode("); \n\n").addSourceCode("if (").addSourceCode(targetColumnName).addSourceCode(" eq ");
                if (targetType.equals(NUMERIC)) {
                    codeSegment.addSourceCode("-1");
                } else {
                    codeSegment.addSourceCode("\"-1\"");
                }
                codeSegment.addSourceCode(") then \n");
            }
            codeSegment.addSourceCode("do; ").addCommentLine(RB.getStringResource("FactTableCodegen.UnknownValue.comment.txt")).addSourceCode("\n").indent().addSourceCode("i_excp = 1; \n");
            if (needExceptionTable) {
                codeSegment.addSourceCode("\n").addSourceCode("x_naturalKey = \"").addSourceCode(unquotedSourceColumnName).addSourceCode("\"; \n").addSourceCode("x_surrogateKey = \"").addSourceCode(unquotedTargetColumnName).addSourceCode("\"; \n");
                if (sourceType.equals(NUMERIC)) {
                    codeSegment.addSourceCode("x_nkValue = left(put(").addSourceCode(nkValueName).addSourceCode(",32.)); \n");
                } else {
                    codeSegment.addSourceCode("x_nkValue = ").addSourceCode(nkValueName).addSourceCode("; \n");
                }
                codeSegment.addSourceCode("x_action = \"").addSourceCode(strActionToDisplay).addSourceCode("\"; \n").addSourceCode("output ").addSourceCode(WORK_EXCEPTIONS_TABLE).addSourceCode("; \n\n");
            }
            if (actionFlag.equals(MOVE)) {
                codeSegment.addSourceCode("i_move = 1; \n\n");
            } else if (actionFlag.equals(ABORT)) {
                codeSegment.addSourceCode("i_abort = 1; \n\n");
            } else {
                codeSegment.addSourceCode(targetColumnName).addSourceCode(" = ");
                if (targetType.equals(NUMERIC) && sourceType.equals(CHARACTER)) {
                    codeSegment.addSourceCode("input(").addSourceCode(nkValueName).addSourceCode(", ?? 32.)");
                } else if (targetType.equals(CHARACTER) && sourceType.equals(NUMERIC)) {
                    codeSegment.addSourceCode("left(put(").addSourceCode(nkValueName).addSourceCode(",32.))");
                } else {
                    codeSegment.addSourceCode(nkValueName);
                }
                codeSegment.addSourceCode("; \n\n");
            }
            codeSegment.unIndent().addSourceCode("end; ").addCommentLine(RB.getStringResource("FactTableCodegen.UnknownValue.comment.txt")).addSourceCode("\n");
        }
    }

    static {
        moveAction = "Move row to error table";
        abortAction = "Abort job";
    }
}

