/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.edmflow.mapping.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.edmflow.IEDMFlowColumn;
import com.sas.etl.models.data.edmflow.IEDMFlowTable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.transforms.edmflow.mapping.IEDMFlowMapping;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;

public class EDMFlowMapping
extends BaseMapping
implements IEDMFlowMapping {
    private IEDMFlowTable m_edmFlowTable;
    private List<IEDMFlowColumn> m_EDMFlowColumns = new ArrayList<IEDMFlowColumn>();

    public EDMFlowMapping(String sID, IModel model) {
        super(sID, model);
        this.setType("EDMFlow");
    }

    @Override
    public String getType() {
        return "EDMFlow";
    }

    @Override
    public boolean isOrdinary() {
        return false;
    }

    @Override
    public IColumn[] getTargets() {
        return new IColumn[0];
    }

    @Override
    public int getTargetCount() {
        return this.m_EDMFlowColumns.size();
    }

    @Override
    public void addTarget(IColumn column) {
    }

    @Override
    public void addTarget(int iTarget, IColumn column) {
    }

    @Override
    public void addTargetEDMFlowColumn(IEDMFlowColumn column) {
        this.addTargetEDMFlowColumn(this.m_EDMFlowColumns.size(), column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTargetEDMFlowColumn(int iTarget, IEDMFlowColumn column) {
        this.startCompoundUndoable();
        try {
            this.m_EDMFlowColumns.add(iTarget, column);
            this.fireModelChangedEvent("Mapping:TargetColumnAdded", column);
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new AddTargetUndoable(iTarget, column));
            }
            if (this.isAutoType()) {
                this.updateType();
            }
            String expText = "";
            ITextExpression expression = (ITextExpression)this.getExpression();
            if (expression == null) {
                expression = this.getModel().getObjectFactory().createNewTextExpression(this.getID());
                this.setExpression(expression);
                expText = this.getColumnExpression(column);
            } else {
                expText = expText + "::" + this.getColumnExpression(column);
            }
            expression.setText(expText, new IObject[0]);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private String getColumnExpression(IEDMFlowColumn column) {
        return column.getTable().getID() + '.' + column.getID();
    }

    @Override
    public void clearTargets() {
        IEDMFlowColumn[] targets = this.getTargetsOfEDMFlowColumn();
        this.startCompoundUndoable();
        try {
            for (int i = 0; i < targets.length; ++i) {
                this.removeTargetEDMFlowColumn(targets[i]);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void replaceTargetColumn(IColumn oldColumn, IColumn newColumn) {
    }

    @Override
    public void removeTarget(IColumn column) {
    }

    @Override
    protected boolean isSourceAndTargetComplete() {
        return this.getSourceCount() == 1 && this.getTargetCount() == 1;
    }

    @Override
    protected boolean isExpressionNeeded() {
        return false;
    }

    @Override
    public boolean containsInTargets(IColumn column) {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public List<String> getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        return lReasons;
    }

    @Override
    public String getWarning() {
        IEDMFlowColumn edmColumn = this.getTargetOfEDMFlowColumn();
        IColumn sourceColumn = this.getSource();
        return null;
    }

    @Override
    public boolean hasWarnings() {
        return this.getWarning() != null;
    }

    @Override
    public List getWarnings() {
        ArrayList<String> lst = new ArrayList<String>();
        String warn = this.getWarning();
        if (warn != null) {
            lst.add(warn);
        }
        return lst;
    }

    @Override
    public boolean isDead() {
        return this.getSourceCount() == 0 || this.getTargetsOfEDMFlowColumn().length == 0;
    }

    @Override
    protected void saveTargetsToOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
    }

    @Override
    public void setEDMFlowTable(IEDMFlowTable table) {
        if (this.m_edmFlowTable == table) {
            return;
        }
        this.m_edmFlowTable = table;
        this.loadEDMFlowColumns();
    }

    private IEDMFlowColumn findEDMColumn(String text) {
        if (this.m_edmFlowTable != null && text != null && text.length() > 0) {
            for (IEDMFlowColumn c : this.m_edmFlowTable.getColumns()) {
                if (!ObjectComparator.isEqual(this.getColumnExpression(c), text)) continue;
                return c;
            }
        }
        return null;
    }

    private void loadEDMFlowColumns() {
        for (IEDMFlowColumn c : this.getTargetsOfEDMFlowColumn()) {
            this.removeTargetEDMFlowColumn(c);
        }
        ITextExpression expression = (ITextExpression)this.getExpression();
        if (expression != null) {
            String[] columnSplit;
            String expText = expression.getTokenizedText();
            for (String c : columnSplit = expText.split("::")) {
                IEDMFlowColumn column = this.findEDMColumn(c);
                if (column == null) continue;
                this.addTargetEDMFlowColumn(column);
            }
        }
    }

    @Override
    protected void loadExpressionFromOMR(OMRAdapter omr, FeatureMap mdoFM) throws RemoteException, MdException {
        super.loadExpressionFromOMR(omr, mdoFM);
        this.loadEDMFlowColumns();
    }

    @Override
    public void dump(PrintStream strm) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getID());
        sb.append(":");
        sb.append("ONETOONE".equals(this.getType()) ? "1to1" : ("DERIVED".equals(this.getType()) ? "Derived" : this.getType()));
        sb.append(":");
        for (int iSource = 0; iSource < this.getSourceCount(); ++iSource) {
            IColumn source = this.getSources()[iSource];
            sb.append(source + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("->");
        for (int iTarget = 0; iTarget < this.m_EDMFlowColumns.size(); ++iTarget) {
            IEDMFlowColumn target = this.m_EDMFlowColumns.get(iTarget);
            sb.append(target.getName() + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        strm.println(sb.toString());
    }

    @Override
    public boolean isMappingNeeded(boolean quoting, ITable sourceTable) {
        return true;
    }

    @Override
    public boolean isMappingRename(boolean quoting, ITable sourceTable) {
        return false;
    }

    @Override
    public IColumn getSource() {
        return this.getSourceCount() > 0 ? this.getSources()[0] : null;
    }

    @Override
    public IEDMFlowColumn getTargetOfEDMFlowColumn() {
        return !this.m_EDMFlowColumns.isEmpty() ? this.m_EDMFlowColumns.get(0) : null;
    }

    @Override
    public IEDMFlowColumn[] getTargetsOfEDMFlowColumn() {
        return this.m_EDMFlowColumns.toArray(new IEDMFlowColumn[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTargetEDMFlowColumn(IEDMFlowColumn column) {
        block9: {
            if (!this.m_EDMFlowColumns.contains(column)) {
                return;
            }
            this.startCompoundUndoable();
            try {
                ITextExpression expression;
                int iTarget = this.m_EDMFlowColumns.indexOf(column);
                this.m_EDMFlowColumns.remove(iTarget);
                this.fireModelChangedEvent("Mapping:TargetColumnRemoved", column);
                if (this.isUndoSupported()) {
                    this.undoableEditHappened(new RemoveTargetUndoable(iTarget, column));
                }
                if (this.isAutoType()) {
                    this.updateType();
                }
                if ((expression = (ITextExpression)this.getExpression()) == null) break block9;
                String expText = this.getColumnExpression(column);
                try {
                    String existingText = expression.getText(null, false);
                    existingText = existingText.replaceAll(expText + "::", "");
                    if (existingText == null || existingText.length() == 0 || ObjectComparator.isEqual(existingText, "::")) {
                        this.setExpression(null);
                        break block9;
                    }
                    expression.setText(existingText, new IObject[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    @Override
    public boolean containsInTargets(IEDMFlowColumn column) {
        return this.m_EDMFlowColumns.contains(column);
    }

    @Override
    public int indexInTargets(IEDMFlowColumn column) {
        return this.m_EDMFlowColumns.indexOf(column);
    }

    private class RemoveTargetUndoable
    extends AbstractUndoableEdit {
        private int m_iTarget;
        private IEDMFlowColumn m_column;

        public RemoveTargetUndoable(int iTarget, IEDMFlowColumn column) {
            this.m_iTarget = iTarget;
            this.m_column = column;
        }

        @Override
        public void undo() {
            super.undo();
            EDMFlowMapping.this.addTargetEDMFlowColumn(this.m_iTarget, this.m_column);
        }

        @Override
        public void redo() {
            super.redo();
            EDMFlowMapping.this.removeTargetEDMFlowColumn(this.m_column);
        }

        @Override
        public void die() {
            super.die();
            this.m_column = null;
        }
    }

    private class AddTargetUndoable
    extends AbstractUndoableEdit {
        private int m_iTarget;
        private IEDMFlowColumn m_column;

        public AddTargetUndoable(int iTarget, IEDMFlowColumn column) {
            this.m_iTarget = iTarget;
            this.m_column = column;
        }

        @Override
        public void undo() {
            super.undo();
            EDMFlowMapping.this.removeTargetEDMFlowColumn(this.m_column);
        }

        @Override
        public void redo() {
            super.redo();
            EDMFlowMapping.this.addTargetEDMFlowColumn(this.m_iTarget, this.m_column);
        }

        @Override
        public void die() {
            super.die();
            this.m_column = null;
        }
    }
}

