/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.dataloader;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.impl.AbstractDataObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.dataloader.IDirective;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.etl.DirectiveInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.net.URI;
import java.rmi.RemoteException;

public class BaseDirective
extends AbstractDataObject
implements IDirective {
    private String externalId;
    private URI restExecutionURL;

    public BaseDirective(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getPublicType() {
        return "Directive.DL";
    }

    @Override
    public String getOMRType() {
        return "Transformation";
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public URI getRestExecutionUrl() {
        return this.restExecutionURL;
    }

    @Override
    public void setRestExecutionUrl(URI value) {
        this.restExecutionURL = value;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        ChildServerInterface child = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            child = server.newChild(true);
            String key = this.getID() + "/" + "Transformation";
            DirectiveInterface directive = (DirectiveInterface)child.fetch(key, false);
            this.setExternalId(directive.getInternalIdentity());
            this.setRestExecutionUrl(directive.getExecutionURIByPath());
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        finally {
            try {
                if (child != null) {
                    child.destroy();
                }
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
        }
        this.setChanged(false);
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return null;
    }
}

