/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.dataValidation;

import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.dataValidation.RB;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ValidationUtil {
    public static final String ERROR_TABLE_OPTION = "ErrorTable";
    public static final String WORK_ERROR_TABLE = "work.etls_Errors";
    public static final String WORK_EXCEPTIONS_TABLE = "work.etls_Exceptions";
    public static final String WORK_DUPS_TABLE = "work.etls_Dups";
    public static final String WORK_SOURCE_TABLE = "work.etls_Source";
    public static final String WORK_FMT_TABLE = "work.etls_fmtData";
    public static final String YES = "YES";

    private ValidationUtil() {
    }

    public static void genAbortJobMacro(ICodeSegment codeSegment, boolean abort) {
        if (abort) {
            codeSegment.addSourceCode("%macro abortJob; \n").indent();
            ValidationUtil.genAbortJob(codeSegment, abort);
            codeSegment.unIndent().addSourceCode("%mend abortJob; \n\n");
        }
    }

    public static void genAbortJob(ICodeSegment codeSegment, boolean abort) {
        ValidationUtil.genAbortJob(codeSegment, abort, false);
    }

    public static void genAbortJob(ICodeSegment codeSegment, boolean abort, boolean needExcption) {
        if (abort) {
            codeSegment.addCommentLine(RB.getStringResource("ValidationUtil.AbortJob.comment.txt")).addSourceCode("%if (&m_abort eq 1) %then \n").addSourceCode("%do; \n").indent().addSourceCode("%makeReport; \n\n");
            if (needExcption) {
                codeSegment.addSourceCode("proc datasets library=work nolist nowarn memtype=(data view);\n").addSourceCode("delete etls_exceptions;\n").addSourceCode("quit;\n\n");
            }
            codeSegment.genPercentPutStatement(RB.getStringResource("ValidationUtil.Abort.comment.sasmacro.notrans"), "ERROR%QUOTE(:)");
            codeSegment.addSourceCode(codeSegment.getAbortJobCode("8000")).unIndent().addSourceCode("%end;\n");
        }
    }

    public static void setupErrorTable(ICodeSegment codeSegment, String errorDSName, boolean move) {
        if (errorDSName.length() == 0) {
            return;
        }
        if (move && errorDSName.indexOf("&") >= 0) {
            codeSegment.addCommentLine(RB.getStringResource("ValidationUtil.ETLSource.comment.txt")).addSourceCode("data _null_;\n").indent();
            if (errorDSName.toUpperCase().indexOf("&DATETIME") >= 0) {
                codeSegment.addSourceCode("call symput(\"DATETIME\", translate(put(\"&etls_stepStartTime\"dt, datetime13.), \"_\", \":\")); \n");
            } else if (errorDSName.toUpperCase().indexOf("&DATE") >= 0) {
                codeSegment.addSourceCode("call symput(\"DATE\", put(datepart(\"&etls_stepStartTime\"dt), date7.)); \n");
            } else if (errorDSName.toUpperCase().indexOf("&TIME") >= 0) {
                codeSegment.addSourceCode("call symput(\"TIME\", left(trim(translate(put(timepart(\"&etls_stepStartTime\"dt), time5.), \"_\", \":\")))); \n");
            }
            codeSegment.unIndent().addSourceCode("run; \n\n");
        }
    }

    public static void genExceptionHandling(ICodeSegment codeSegment, String targetDSName, String tempErrorTable, boolean move, boolean abort) {
        if (move) {
            codeSegment.addCommentLine(RB.getStringResource("ValidationUtil.MoveToError.comment.txt")).addSourceCode("if (i_move) then \n").indent().addSourceCode("output " + tempErrorTable + ";\n").unIndent().addCommentLine(RB.getStringResource("ValidationUtil.MoveToOutput.comment.txt")).addSourceCode("else \n").indent().addSourceCode("output " + targetDSName + ";\n\n").unIndent();
        } else {
            codeSegment.addSourceCode("output " + targetDSName + ";\n\n");
        }
        codeSegment.addSourceCode("if eof then \n").addSourceCode("do; \n").indent().addCommentLine(RB.getStringResource("ValidationUtil.CreateFlags.comment.txt")).addSourceCode("call symput(\"m_excp\", put(i_excp, 1.));\n");
        if (abort) {
            codeSegment.addSourceCode("call symput(\"m_abort\", put(i_abort, 1.));\n");
        }
        codeSegment.unIndent().addSourceCode("end; \n");
    }

    public static void genUpdateErrorTable(ICodeSegment codeSegment, String tempErrorTable, String errorDSName) {
        if (errorDSName.length() == 0) {
            return;
        }
        String justTempErrorTable = tempErrorTable;
        if (tempErrorTable.indexOf("(") > 0) {
            justTempErrorTable = tempErrorTable.substring(0, tempErrorTable.indexOf("(") - 1);
        }
        codeSegment.addCommentLine(RB.getStringResource("ValidationUtil.AddRunTime.comment.txt")).addSourceCode("data " + justTempErrorTable + "; \n").indent().addSourceCode("set " + justTempErrorTable + "; \n").addSourceCode("format ETL_Error_JobRunTime datetime16.; \n").addSourceCode("ETL_Error_JobRunTime = \"&etls_stepStartTime\"dt; \n").unIndent().addSourceCode("run; \n\n").addCommentLine(RB.getStringResource("ValidationUtil.UpdateErrors.comment.txt")).addSourceCode("proc append base = " + errorDSName + "\n").addSourceCode("            data = " + tempErrorTable + " force; \n").addSourceCode("run; \n\n");
    }

    public static void genMakeReportMacro(AbstractDataTransform m_TransformModel, ICodeSegment codeSegment, IPhysicalTable sourceTable, boolean replaceExceptionsTable) throws BadLibraryDefinitionException, CodegenException {
        ValidationUtil.genMakeReportMacro(m_TransformModel, codeSegment, sourceTable, replaceExceptionsTable, WORK_EXCEPTIONS_TABLE, false, false);
    }

    public static void genMakeReportMacro(AbstractDataTransform m_TransformModel, ICodeSegment codeSegment, IPhysicalTable sourceTable, boolean replaceExceptionsTable, String excpReportTableName, boolean needReport, boolean priorExcp) throws BadLibraryDefinitionException, CodegenException {
        if (!ValidationUtil.isExceptionTableNeeded(m_TransformModel)) {
            return;
        }
        codeSegment.addCommentLine(RB.getStringResource("ValidationUtil.MakeReport.comment.txt")).addSourceCode("%macro makeReport; \n\n").indent();
        codeSegment.addSourceCode("%if (&m_excp eq 1) %then \n").addSourceCode("%do; \n").indent();
        String dateFormat = m_TransformModel.getJob().isUsingNLSDateFormat() ? "nldatmap." : "datetime.";
        List lConditionActionSets = m_TransformModel.getConditionActionSetsList();
        if (lConditionActionSets == null || lConditionActionSets.isEmpty()) {
            ValidationUtil.genProcPrint(codeSegment, sourceTable, dateFormat, excpReportTableName);
        } else {
            for (int i = 0; i < lConditionActionSets.size(); ++i) {
                IConditionActionSet t = (IConditionActionSet)lConditionActionSets.get(i);
                List lActions = null;
                lActions = t.getActionList();
                for (int j = 0; j < lActions.size(); ++j) {
                    IConditionAction action = (IConditionAction)lActions.get(j);
                    if (action.getUniqueIdentifier().equalsIgnoreCase("DIS_EMAILREPORT") || action.getUniqueIdentifier().equalsIgnoreCase("DIS_SAVEREPORT") || action.getUniqueIdentifier().equalsIgnoreCase("DIS_SAVETABLE")) {
                        StringBuffer optionString = new StringBuffer("");
                        List optionList = action.getActionPropertiesList();
                        for (int k = 0; k < optionList.size(); ++k) {
                            IProperty optionProp = (IProperty)optionList.get(k);
                            optionString.append(optionProp.getDefaultValue());
                            if (k == optionList.size() - 1) continue;
                            optionString.append(", ");
                        }
                        if (action.getUniqueIdentifier().equalsIgnoreCase("DIS_EMAILREPORT") || action.getUniqueIdentifier().equalsIgnoreCase("DIS_SAVEREPORT")) {
                            if (action.getUniqueIdentifier().equalsIgnoreCase("DIS_EMAILREPORT")) {
                                codeSegment.addCommentLine(RB.getStringResource("ValidationUtil.EmailReport.comment.txt")).addSourceCode("filename report email \"" + optionString.toString() + "\" subject= \"" + RB.getStringResource("ValidationUtil.EmailSubject.txt") + "\"; \n\n");
                            } else {
                                codeSegment.addCommentLine(RB.getStringResource("ValidationUtil.SaveReport.comment.txt")).addSourceCode("filename report \"" + optionString.toString() + "\"; \n\n");
                            }
                            codeSegment.addSourceCode("proc printto print = report new; \n").addSourceCode("run; \n\n");
                            ValidationUtil.genProcPrint(codeSegment, sourceTable, dateFormat);
                            codeSegment.addSourceCode("proc printto; \n").addSourceCode("run; \n\n").addSourceCode("filename report; \n\n");
                            continue;
                        }
                        if (!action.getUniqueIdentifier().equalsIgnoreCase("DIS_SAVETABLE")) continue;
                        if (replaceExceptionsTable) {
                            codeSegment.genTableDelete(optionString.toString());
                        }
                        codeSegment.addCommentLine(RB.getStringResource("ValidationUtil.SaveTable.comment.txt")).addSourceCode("data " + excpReportTableName + "; \n").addSourceCode("%if not %sysfunc(exist(" + optionString.toString() + ")) %then \n").addSourceCode("%do;\n").indent().addSourceCode("attrib x_datetime format = ").addSourceCode(dateFormat).addSourceCode(" label = \"" + RB.getStringResource("ValidationUtil.DateTimeLabel.txt") + "\"; \n").unIndent().addSourceCode("%end;\n").indent().addSourceCode("x_datetime = datetime(); \n").addSourceCode("set " + excpReportTableName + "; \n").unIndent().addSourceCode("run; \n\n");
                        if (needReport) {
                            ValidationUtil.genProcPrint(codeSegment, sourceTable, dateFormat);
                        }
                        codeSegment.addSourceCode("proc append base = " + optionString.toString() + "\n").addSourceCode("            data = " + excpReportTableName);
                        if (priorExcp) {
                            codeSegment.addSourceCode("(SORTEDBY=_NULL_ drop=x_custom_name x_custom_value x_custom_rule)");
                        } else {
                            codeSegment.addSourceCode("(SORTEDBY=_NULL_) \n");
                        }
                        codeSegment.addSourceCode(" force; \n").addSourceCode("run; \n\n");
                        continue;
                    }
                    codeSegment.addSourceCode("\n").addSourceCode(action.getActionMacroCall(m_TransformModel.getJob().isUsingNLSDateFormat(), codeSegment));
                }
            }
        }
        codeSegment.unIndent().addSourceCode("%end; \n\n").unIndent().addSourceCode("%mend makeReport; \n\n");
    }

    public static void genProcPrint(ICodeSegment codeSegment, IPhysicalTable sourceTable, String dateFormat) throws BadLibraryDefinitionException, CodegenException {
        ValidationUtil.genProcPrint(codeSegment, sourceTable, dateFormat, WORK_EXCEPTIONS_TABLE);
    }

    public static void genProcPrint(ICodeSegment codeSegment, IPhysicalTable sourceTable, String dateFormat, String excpReportName) throws BadLibraryDefinitionException, CodegenException {
        codeSegment.addSourceCode("options nodate; \n\n").addSourceCode("proc sort data = " + excpReportName + "; \n").indent().addSourceCode("by x_row; \n").unIndent().addSourceCode("run; \n\n").addSourceCode("proc print data = " + excpReportName + " noobs label; \n").indent().addSourceCode("title1 \"").addSourceCode(RB.getStringResource("ValidationUtil.GenProcPrint.title.txt") + " " + sourceTable.getFullNameQuotedAsNeeded(codeSegment.getCurrentServer(), false, false, false, "") + "\"; \n").addSourceCode("title2 \"%sysfunc(datetime(),").addSourceCode(dateFormat).addSourceCode(")\"; \n").unIndent().addSourceCode("run; \n\n").addSourceCode("options date; \n\n");
    }

    public static boolean isExceptionTableNeeded(AbstractDataTransform m_TransformModel) {
        List lConditionActionSets = m_TransformModel.getConditionActionSetsList();
        if (lConditionActionSets == null || lConditionActionSets.size() <= 0) {
            return true;
        }
        for (int i = 0; i < lConditionActionSets.size(); ++i) {
            IConditionActionSet set = (IConditionActionSet)lConditionActionSets.get(i);
            List lActions = set.getActionList();
            for (int j = 0; j < lActions.size(); ++j) {
                IConditionAction action = (IConditionAction)lActions.get(j);
                if (!action.getUniqueIdentifier().equalsIgnoreCase("DIS_NOREPORT")) continue;
                return false;
            }
        }
        return true;
    }

    public static String genKeepStatement(AbstractDataTransform model, String keepRenCols, ICodeSegment codeSegment) {
        List<IColumn> lColumns = Arrays.asList(model.getOrdinaryMappedTargetColumns(null));
        if (keepRenCols.compareToIgnoreCase(YES) == 0) {
            int i;
            HashMap<String, IColumn> mapOfColumns = new HashMap<String, IColumn>();
            IColumn[] lTargetColumns = model.getOrdinaryMappedTargetColumns(null);
            IColumn[] lSourceColumns = model.getOrdinaryMappedSourceColumns(null);
            for (i = 0; i < lTargetColumns.length; ++i) {
                mapOfColumns.put(lTargetColumns[i].getColumnName(false), lTargetColumns[i]);
            }
            for (i = 0; i < lSourceColumns.length; ++i) {
                mapOfColumns.put(lSourceColumns[i].getColumnName(false), lSourceColumns[i]);
            }
            lColumns = new ArrayList(mapOfColumns.values());
        }
        String keepStatement = "keep = " + codeSegment.makeColumnList(lColumns, false, "                ", false, " ", "", codeSegment.isQuoting(), "", false);
        return keepStatement;
    }

    public static String getExceptionTableName(AbstractDataTransform m_TransformModel) {
        List lConditionActionSets = m_TransformModel.getConditionActionSetsList();
        String eName = "";
        int i = 0;
        if (i < lConditionActionSets.size()) {
            IConditionActionSet set = (IConditionActionSet)lConditionActionSets.get(i);
            List lActions = set.getActionList();
            block0: for (int j = 0; j < lActions.size(); ++j) {
                IConditionAction action = (IConditionAction)lActions.get(j);
                if (!action.getUniqueIdentifier().equalsIgnoreCase("DIS_SAVETABLE")) continue;
                StringBuffer optionString = new StringBuffer("");
                List optionList = action.getActionPropertiesList();
                for (int k = 0; k < optionList.size(); ++k) {
                    IProperty optionProp = (IProperty)optionList.get(k);
                    optionString.append(optionProp.getDefaultValue());
                    if (optionString != null) {
                        eName = optionString.toString();
                    }
                    if (eName != "") continue block0;
                }
            }
            return eName;
        }
        return null;
    }
}

