/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.dataValidation;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.job.transforms.dataValidation.DataValidationTransformModel;
import com.sas.etl.models.job.transforms.dataValidation.RB;
import com.sas.etl.models.job.transforms.dataValidation.TempColumn;
import com.sas.workspace.TransformUtil;

public class DataValidationUtil {
    public static IPhysicalTable createErrorWorkTable(DataValidationTransformModel m_transform) {
        IWorkTable errorTable = m_transform.getModel().getObjectFactory().createNewWorkTable(m_transform.getID());
        errorTable.setName(RB.getStringResource("DataValidationUtil.ErrorTableName.txt"));
        errorTable.setSASTableName(TransformUtil.createWorkTableName());
        DataValidationUtil.addDefaultErrorColumns(m_transform, errorTable);
        return errorTable;
    }

    public static IPhysicalTable createExceptionWorkTable(DataValidationTransformModel m_transform) {
        IWorkTable exceptionTable = m_transform.getModel().getObjectFactory().createNewWorkTable(m_transform.getID());
        exceptionTable.setName(RB.getStringResource("DataValidationUtil.ExceptionTableName.txt"));
        exceptionTable.setSASTableName(TransformUtil.createWorkTableName());
        DataValidationUtil.addDefaultExceptionColumns(m_transform, exceptionTable);
        return exceptionTable;
    }

    private static void addDefaultErrorColumns(DataValidationTransformModel m_transform, IPhysicalTable errorTable) {
        IPhysicalTable sourceTable = m_transform.getSourceTable();
        if (sourceTable != null) {
            IColumn[] aSourceColumns = sourceTable.getColumns();
            for (int i = 0; i < aSourceColumns.length; ++i) {
                DataValidationUtil.copyColumn(m_transform, errorTable, aSourceColumns[i]);
            }
        }
    }

    public static IColumn copyColumn(DataValidationTransformModel m_transform, IPhysicalTable errorTable, IColumn column) {
        IColumn newColumn = m_transform.getModel().getObjectFactory().createNewColumn(errorTable.getID());
        column.copy(newColumn);
        errorTable.addColumn(newColumn);
        m_transform.mapColumns(new IColumn[]{column}, new IColumn[]{newColumn});
        return newColumn;
    }

    private static void addDefaultExceptionColumns(DataValidationTransformModel m_transform, IPhysicalTable exceptionTable) {
        for (TempColumn t : m_transform.getExceptionTableStructure().getColumns()) {
            DataValidationUtil.addTempColumnToTable(m_transform, t, exceptionTable);
        }
    }

    public static IColumn createColumn(DataValidationTransformModel m_transform, TempColumn tempColumn, IPhysicalTable table) {
        IColumn newColumn = m_transform.getModel().getObjectFactory().createNewColumn(table.getID());
        tempColumn.setColumnAttributes(newColumn);
        return newColumn;
    }

    public static IColumn addTempColumnToTable(DataValidationTransformModel m_transform, TempColumn tempColumn, IPhysicalTable table) {
        IColumn column = DataValidationUtil.createColumn(m_transform, tempColumn, table);
        table.addColumn(column);
        return column;
    }
}

