/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.conditional.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICheckpointRestart;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.job.impl.AbstractTransform;
import com.sas.etl.models.job.impl.CheckpointRestart;
import com.sas.etl.models.job.impl.CodeGenerationEnvironment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.etl.models.job.transforms.conditional.impl.ConditionalEndTransformModel;
import com.sas.etl.models.job.transforms.conditional.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseTransformValueChangedListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ConditionalStartTransformModel
extends AbstractTransform {
    public static final String TRANSFORMATION_ROLE = "CONDITIONALSTART";
    public static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.control.ConditionalStart";
    private static final String ARM_DISPLAY_NAME = "ConditionalStart";
    private static final String USER_MACRO_NAME = "USERMACRONAME";
    private static final String USER_MACRO_NAME_CHANGED = "ConditionalStartTransformModel:UserMacroNameChanged";
    private static final String CONDITION_CHANGED = "ConditionalStartTransformModel:ConditionChanged";
    private static final String CONDITION_DEFINED = "ConditionalStartTransformModel:ConditionDefined";
    private String m_sUserMacroName;
    private String m_sCondition;

    public ConditionalStartTransformModel(String sID, IModel model) {
        super(sID, model);
        WorkspaceFile file = Workspace.getWorkspace().getAppDefaultsFile();
        this.m_sUserMacroName = file.getPropertyString("Workspace.DefaultUserMacroName", "");
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    public String getDefaultName() {
        return RB.getStringResource("ConditionalStartTransformModel.Name.txt");
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("ConditionalStartTransformModel.DisplayType.txt");
    }

    @Override
    public ICodeSegment getRuntimeStatistics(ICodeSegment codeSegment) throws CodegenException {
        return codeSegment;
    }

    @Override
    public ICodeSegment getRuntimeStatisticsComplete(ICodeSegment codeSegment) throws CodegenException {
        return codeSegment;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.hasConditionalEnd() && this.hasConditionDefined();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (!this.hasConditionalEnd()) {
            lReasons.add(RB.getStringResource("ConditionalCodegen.NoLoopEndFound.txt"));
        }
        if (!this.hasConditionDefined()) {
            lReasons.add(RB.getStringResource("ConditionalCodegen.NoConditionDefined.txt"));
        }
        return lReasons;
    }

    protected ITransform[] getInnerSteps() {
        ITransform trans;
        ArrayList<ITransform> steps = new ArrayList<ITransform>();
        IJob job = this.getJob();
        ITransform[] arrTransforms = job.getControlOrderedTransformsAndOthers();
        List<ITransform> transforms = Arrays.asList(arrTransforms);
        int index = transforms.indexOf(this);
        ConditionalEndTransformModel condEnd = this.getConditionalEnd();
        for (int i = index + 1; i < arrTransforms.length && condEnd != (trans = arrTransforms[i]); ++i) {
            steps.add(trans);
        }
        return steps.toArray(new ITransform[steps.size()]);
    }

    @Override
    protected ICheckpointRestart createNewCheckpointRestart() {
        CheckpointRestart cs = new CheckpointRestart(this);
        cs.setCPRStepSuffix(CodeGenerationEnvironment.createWorkTableName(0));
        return cs;
    }

    protected boolean hasConditionalEnd() {
        return this.getConditionalEnd() != null;
    }

    protected boolean hasConditionDefined() {
        return this.getCondition() != null && this.getCondition().length() > 0;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged();
    }

    protected ConditionalEndTransformModel getConditionalEnd() {
        IJob job = this.getJob();
        if (job != null) {
            List<ITransform> transforms = Arrays.asList(job.getControlOrderedTransformsAndOthers());
            int index = transforms.indexOf(this);
            int loopsCnt = 0;
            for (int i = index + 1; i < transforms.size(); ++i) {
                ITransform trans = transforms.get(i);
                if (trans instanceof ConditionalStartTransformModel) {
                    ++loopsCnt;
                }
                if (!(trans instanceof ConditionalEndTransformModel)) continue;
                if (loopsCnt > 0) {
                    --loopsCnt;
                    continue;
                }
                return (ConditionalEndTransformModel)trans;
            }
        }
        return null;
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    public String getCondition() {
        return this.m_sCondition;
    }

    public void setCondition(String condition) {
        if (this.m_sCondition != null && this.m_sCondition.equals(condition)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetConditionUndoable(this.m_sCondition, condition));
        }
        this.m_sCondition = condition;
        this.fireModelChangedEvent(CONDITION_CHANGED, condition);
    }

    public String getMacroName() {
        return this.m_sUserMacroName;
    }

    public void setMacroName(String name) {
        if (this.m_sUserMacroName == name) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMacroNameUndoable(this.m_sUserMacroName, name));
        }
        this.m_sUserMacroName = name;
        this.fireModelChangedEvent(USER_MACRO_NAME_CHANGED, name);
    }

    public String getExitMacroLabel() {
        return "exit" + this.getMacroName();
    }

    @Override
    public void setJob(IJob job) {
        IJob oldJob = this.getJob();
        if (oldJob != null) {
            oldJob.removeNotifyListener(this);
        }
        super.setJob(job);
        if (job != null) {
            job.addNotifyListener(this);
        }
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.saveStringOptionToOMR(omr, USER_MACRO_NAME, this.getMacroName());
        this.saveStringOptionToOMR(omr, CONDITION_DEFINED, this.getCondition());
        this.setChanged(false);
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean validateCode) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ITransform transform;
        int i;
        super.getGeneratedCode(codeSegment, validateCode);
        if (this.getMacroName() != null && this.getMacroName().length() > 0) {
            this.setMacroName(this.getMacroName());
        } else {
            this.setMacroName("etls_condition" + CodeGenerationEnvironment.createWorkTableName(0));
        }
        codeSegment.addSourceCode("%macro ").addSourceCode(this.getMacroName()).addSourceCode(";").newLine().indent().addSourceCode("%local etls_conditionTrue;").newLine();
        codeSegment.addSourceCode("%let etls_conditionTrue = %eval(").addSourceCode(this.getCondition()).addSourceCode(");").newLine().addSourceCode("%if (&etls_conditionTrue=0) %then").newLine().addSourceCode("%do;").newLine().indent().addSourceCode("%put ").addSourceCode(RB.getStringResource("ConditionalStartTransformModel.FlowDidNotExecute.txt")).addSourceCode(" ").addSourceCode(this.getCondition()).addSourceCode(";").newLine().addSourceCode("%goto ").addSourceCode(this.getExitMacroLabel()).addSourceCode(";").newLine().unIndent().addSourceCode("%end;").newLine().addSourceCode("%else").newLine().addSourceCode("%do;").newLine().indent().addSourceCode("%put ").addSourceCode(RB.getStringResource("ConditionalStartTransformModel.FlowDidExecute.txt")).addSourceCode(" ").addSourceCode(this.getCondition()).addSourceCode(";").newLine().unIndent().addSourceCode("%end;").newLine().unIndent();
        ITransform[] innerSteps = this.getInnerSteps();
        if (!this.hasConditionalEnd()) {
            throw new CodegenException(RB.getStringResource("ConditionalIFCodegen.NoConditionalEndFound.txt"), (IObject)this);
        }
        for (i = 0; i < innerSteps.length; ++i) {
            transform = innerSteps[i];
            IModel mdl = innerSteps[i].getModel();
            String sID = innerSteps[i].getID();
            JobTransformModel jtm = new JobTransformModel(sID, mdl);
            if (this.getJob().getTransformsToSkipList().contains(transform)) continue;
            ICodeSegment newCodeSegment = codeSegment.createNewCodeSegment(transform);
            transform.getCompleteCode(newCodeSegment);
            this.getJob().addTransformsToSkipCodeGeneration(transform);
        }
        for (i = 0; i < innerSteps.length; ++i) {
            transform = innerSteps[i];
            if (this.getJob().getTransformsToSkipList().contains(transform)) continue;
            this.getJob().addTransformsToSkipCodeGeneration(transform);
        }
        codeSegment.addSourceCode("%" + this.getExitMacroLabel() + ":").newLine().addSourceCode("%mend " + this.getMacroName() + ";").newLine(2).addSourceCode("%" + this.getMacroName() + ";").newLine(1);
        return codeSegment;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        try {
            this.setMacroName(this.loadStringOptionFromOMR(omr, USER_MACRO_NAME, this.getMacroName()));
            this.setCondition(this.loadStringOptionFromOMR(omr, CONDITION_DEFINED, this.getCondition()));
        }
        catch (IOException e) {
            throw new MdException((Throwable)e);
        }
        this.setChanged(false);
    }

    @Override
    public void notify(NotifyEvent ev) {
        ModelEvent modelEv = ev.getModelEvent();
        if (modelEv != null) {
            IObject obj = modelEv.getModelObject();
            if (USER_MACRO_NAME_CHANGED.equals(modelEv.getType())) {
                this.setMacroName(this.getMacroName());
                this.fireModelChangedEvent(USER_MACRO_NAME_CHANGED, this);
            } else if (CONDITION_CHANGED.equals(modelEv.getType())) {
                this.setCondition(this.getCondition());
                this.fireModelChangedEvent(CONDITION_CHANGED, this);
            }
            if (obj == this.getJob() && ("Job:TransformAdded".equals(modelEv.getType()) || "Job:TransformRemoved".equals(modelEv.getType()) || "Job:TransformAddedToExecutionOrder".equals(modelEv.getType()) || "Job:TransformRemovedFromExecutionOrder".equals(modelEv.getType()))) {
                this.fireModelChangedEvent("ITransform:TransformChanged", this);
            }
        }
        super.notify(ev);
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        ConditionalStartTransformPromptModel model = new ConditionalStartTransformPromptModel(this.getModel(), this);
        model.setOptionDefaultValue(USER_MACRO_NAME, (Object)this.m_sUserMacroName);
        return model;
    }

    private class SetConditionUndoable
    extends AbstractUndoableEdit {
        private String m_oldCondition;
        private String m_newCondition;

        public SetConditionUndoable(String oldCondition, String newCondition) {
            this.m_oldCondition = oldCondition;
            this.m_newCondition = newCondition;
        }

        @Override
        public void undo() {
            super.undo();
            ConditionalStartTransformModel.this.setCondition(this.m_oldCondition);
        }

        @Override
        public void redo() {
            super.redo();
            ConditionalStartTransformModel.this.setCondition(this.m_newCondition);
        }
    }

    private class SetMacroNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldName;
        private String m_newName;

        public SetMacroNameUndoable(String oldName, String newName) {
            this.m_oldName = oldName;
            this.m_newName = newName;
        }

        @Override
        public void undo() {
            super.undo();
            ConditionalStartTransformModel.this.setMacroName(this.m_oldName);
        }

        @Override
        public void redo() {
            super.redo();
            ConditionalStartTransformModel.this.setMacroName(this.m_newName);
        }
    }

    public class ConditionalStartTransformPromptModel
    extends BaseTransformPromptModel
    implements IPromptModel {
        public ConditionalStartTransformPromptModel(IModel model, ConditionalStartTransformModel owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model, owner);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(ConditionalStartTransformPromptModel.class.getResource("res/ConditionalIf_Options_Template.xml"));
            PromptGroupInterface combined = this.combinePromptGroups(grp1, grp);
            this.setTransformPromptGroup(combined);
            return combined;
        }

        @Override
        protected IModelListener createModelListener() {
            return new ConditionalStartTransformModelListener((ConditionalStartTransformModel)this.getOwner(), this);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            this.setOptionValue(ConditionalStartTransformModel.USER_MACRO_NAME, (Object)((ConditionalStartTransformModel)this.getOwner()).getMacroName());
        }

        @Override
        protected IPromptValueChangeListener createChangeListener() {
            return new ConditionalStartPromptValueChangeListener((ConditionalStartTransformModel)this.getOwner(), this);
        }

        private class ConditionalStartTransformModelListener
        extends BaseDataTransformModelListener {
            public ConditionalStartTransformModelListener(ConditionalStartTransformModel transform, IPromptModel prompt) {
                super(transform, prompt);
            }

            @Override
            public void modelChanged(ModelEvent ev) {
                block9: {
                    if (ev.getModelObject() != this.getModelObject()) {
                        return;
                    }
                    super.modelChanged(ev);
                    String type = ev.getType();
                    try {
                        if (!type.equals(ConditionalStartTransformModel.USER_MACRO_NAME_CHANGED)) break block9;
                        this.getPromptModel().setListeningForChanges(false);
                        try {
                            this.m_promptModel.setOptionValue(ConditionalStartTransformModel.USER_MACRO_NAME, (Object)ConditionalStartTransformModel.this.getMacroName());
                        }
                        finally {
                            this.getPromptModel().setListeningForChanges(true);
                        }
                    }
                    catch (ServerConnectionException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                    }
                    catch (ServiceException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                    }
                    catch (RemoteException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                    }
                    catch (MdException exc) {
                        ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                    }
                }
            }
        }

        private class ConditionalStartPromptValueChangeListener
        extends BaseTransformValueChangedListener {
            public ConditionalStartPromptValueChangeListener(ConditionalStartTransformModel transform, IPromptModel promptModel) {
                super(transform, promptModel);
            }

            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    if (def.getPromptName().equals(ConditionalStartTransformModel.USER_MACRO_NAME)) {
                        ConditionalStartTransformModel.this.setMacroName(event.getNewValue() != null ? event.getNewValue().toString() : null);
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }
    }
}

