/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.comparetables.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.comparetables.ICompareTables;
import com.sas.etl.models.job.transforms.comparetables.ICompareTablesTransformModel;
import com.sas.etl.models.job.transforms.comparetables.impl.CompareTables;
import com.sas.etl.models.job.transforms.comparetables.impl.CompareTablesPortDescriptionModel;
import com.sas.etl.models.job.transforms.comparetables.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CompareTablesTransformModel
extends AbstractDataTransform
implements ICompareTablesTransformModel {
    private static final String TRANSFORMATION_CLASS = "job.transforms.CompareTablesTransformModel";
    private static final String TRANSFORMATION_ROLE = "job.transforms.CompareTablesTransformModel";
    private static final String ARM_DISPLAY_NAME = "CompareTables";
    private static final String OPTIONS_TRUE = "YES";
    private static final String OPTIONS_FALSE = "NO";
    private static final int SOURCE_PORT = 0;
    private static final int COMPARISON_PORT = 1;
    private static final int CHANGED_RCDS_PORT = 0;
    private static final int NEW_RCDS_PORT = 1;
    private static final int UNCHANGED_RCDS_PORT = 2;
    private static final int MISSING_RCDS_PORT = 3;
    private List<CompareTablesPortDescriptionModel> m_lInputPortDescriptions;
    private List<CompareTablesPortDescriptionModel> m_lOutputPortDescriptions;
    private ICompareTables m_oCompareTable;

    public CompareTablesTransformModel(String sid, IModel model) {
        super(sid, model);
        this.m_oCompareTable = new CompareTables(model.createIDForNewObject(this.getID()), model, this);
        this.m_oCompareTable.addNotifyListener(this);
        this.m_lInputPortDescriptions = new ArrayList<CompareTablesPortDescriptionModel>();
        this.m_lOutputPortDescriptions = new ArrayList<CompareTablesPortDescriptionModel>();
        this.addDefaultInputPorts();
        this.addDefaultOutputPorts();
    }

    @Override
    public ICompareTables getCompareTablesObject() {
        return this.m_oCompareTable;
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.addNewWorkTable();
        this.addNewWorkTable();
        this.addNewWorkTable();
        this.addNewWorkTable();
    }

    private void addDefaultInputPorts() {
        CompareTablesPortDescriptionModel sourceTable = new CompareTablesPortDescriptionModel();
        sourceTable.setName(RB.getStringResource("CompareTablesTransformModel.InputPortName.txt"));
        sourceTable.setTooltipText(RB.getStringResource("CompareTablesTransformModel.InputPortText.txt"));
        this.m_lInputPortDescriptions.add(sourceTable);
        CompareTablesPortDescriptionModel compareTable = new CompareTablesPortDescriptionModel();
        compareTable.setName(RB.getStringResource("CompareTablesTransformModel.ComparisonPortName.txt"));
        compareTable.setTooltipText(RB.getStringResource("CompareTablesTransformModel.ComparisonPortText.txt"));
        this.m_lInputPortDescriptions.add(compareTable);
    }

    private void addDefaultOutputPorts() {
        CompareTablesPortDescriptionModel changedRecords = new CompareTablesPortDescriptionModel();
        changedRecords.setName(RB.getStringResource("CompareTablesTransformModel.ChangedRecordsPortName.txt"));
        changedRecords.setTooltipText(RB.getStringResource("CompareTablesTransformModel.ChangedRecordsPortText.txt"));
        this.m_lOutputPortDescriptions.add(changedRecords);
        CompareTablesPortDescriptionModel newRecords = new CompareTablesPortDescriptionModel();
        newRecords.setName(RB.getStringResource("CompareTablesTransformModel.NewRecordsPortName.txt"));
        newRecords.setTooltipText(RB.getStringResource("CompareTablesTransformModel.NewRecordsPortText.txt"));
        this.m_lOutputPortDescriptions.add(newRecords);
        CompareTablesPortDescriptionModel unchangedRecords = new CompareTablesPortDescriptionModel();
        unchangedRecords.setName(RB.getStringResource("CompareTablesTransformModel.UnchangedRecordsPortName.txt"));
        unchangedRecords.setTooltipText(RB.getStringResource("CompareTablesTransformModel.UnchangedRecordsPortText.txt"));
        this.m_lOutputPortDescriptions.add(unchangedRecords);
        CompareTablesPortDescriptionModel missingRecords = new CompareTablesPortDescriptionModel();
        missingRecords.setName(RB.getStringResource("CompareTablesTransformModel.MissingRecordsPortName.txt"));
        missingRecords.setTooltipText(RB.getStringResource("CompareTablesTransformModel.MissingRecordsPortText.txt"));
        this.m_lOutputPortDescriptions.add(missingRecords);
    }

    @Override
    public void addDataSource(int iSource, IDataObject source) {
    }

    private void addDataSource(CompareTablesPortDescriptionModel portDesc, IDataObject source) {
        if (portDesc != null && portDesc.getObject() != source) {
            portDesc.setObject(source);
            this.addDataSourceImpl(source);
        }
    }

    private void addDataSourceImpl(IDataObject source) {
        if (!source.containsInConsumerTransforms(this)) {
            source.addConsumerTransform(this);
            source.addNotifyListener(this);
            if (!this.getModel().isUndoing()) {
                this.postAddTransformTableOption(source, true);
            }
        }
    }

    @Override
    public void removeDataSource(IDataObject source) {
    }

    private void removeDataSource(CompareTablesPortDescriptionModel portDesc, IDataObject source) {
        if (portDesc != null && portDesc.getObject() == source) {
            portDesc.setObject(null);
            this.removeDataSourceImpl(source);
        }
    }

    private void removeDataSourceImpl(IDataObject source) {
        if (source.containsInConsumerTransforms(this) && !this.isSourceAttachedToMultipleInputPorts(source)) {
            source.removeConsumerTransform(this);
            source.removeNotifyListener(this);
            if (!this.getModel().isUndoing()) {
                this.removeSourceTableFromMappings((ITable)source);
                this.preRemoveTransformTableOptions(source, true);
            }
        }
    }

    @Override
    public IDataObject[] getDataSources() {
        List lSources = this.getDataSourceList();
        return lSources.toArray(new IDataObject[lSources.size()]);
    }

    @Override
    public List getDataSourceList() {
        ArrayList<IPhysicalTable> lDataSources = new ArrayList<IPhysicalTable>();
        if (this.m_oCompareTable != null) {
            if (this.m_oCompareTable.getSourceTable() != null) {
                lDataSources.add(this.m_oCompareTable.getSourceTable());
            }
            if (this.m_oCompareTable.getComparisonTable() != null) {
                lDataSources.add(this.m_oCompareTable.getComparisonTable());
            }
        }
        return lDataSources;
    }

    @Override
    public boolean containsInDataSources(IDataObject source) {
        return this.getDataSourceList().contains(source);
    }

    @Override
    public int getDataSourcesCount() {
        return this.getDataSourceList().size();
    }

    private boolean isSourceAttachedToMultipleInputPorts(IDataObject source) {
        if (source == null) {
            return false;
        }
        int iCount = 0;
        if (this.m_oCompareTable.getSourceTable() == source) {
            ++iCount;
        }
        if (this.m_oCompareTable.getComparisonTable() == source) {
            ++iCount;
        }
        return iCount > 1;
    }

    @Override
    public void addDataTarget(IDataObject target) {
    }

    @Override
    public void addDataTarget(int iTarget, IDataObject target) {
    }

    private void addDataTarget(CompareTablesPortDescriptionModel portDesc, IDataObject target) {
        if (portDesc != null && portDesc.getObject() != target) {
            portDesc.setObject(target);
            this.addDataTargetImpl(target);
        }
    }

    private void addDataTargetImpl(IDataObject target) {
        if (!target.containsInProducerTransforms(this)) {
            target.addProducerTransform(this);
            target.addNotifyListener(this);
            if (target instanceof IWorkTable) {
                this.removeFromDeletedObjects(target);
                this.updateTargetLibrary((IWorkTable)target);
            }
            if (!this.getModel().isUndoing()) {
                this.postAddTransformTableOption(target, false);
            }
        }
    }

    @Override
    public IDataObject[] getDataTargets() {
        return this.getDataTargetList().toArray(new IDataObject[this.getDataTargetsCount()]);
    }

    @Override
    public List getDataTargetList() {
        ArrayList<IPhysicalTable> lDataTargets = new ArrayList<IPhysicalTable>();
        if (this.m_oCompareTable != null) {
            if (this.m_oCompareTable.getChangedRcdsTable() != null) {
                lDataTargets.add(this.m_oCompareTable.getChangedRcdsTable());
            }
            if (this.m_oCompareTable.getNewRcdsTable() != null) {
                lDataTargets.add(this.m_oCompareTable.getNewRcdsTable());
            }
            if (this.m_oCompareTable.getUnchangedRcdsTable() != null) {
                lDataTargets.add(this.m_oCompareTable.getUnchangedRcdsTable());
            }
            if (this.m_oCompareTable.getMissingRcdsTable() != null) {
                lDataTargets.add(this.m_oCompareTable.getMissingRcdsTable());
            }
        }
        return lDataTargets;
    }

    @Override
    public boolean containsInDataTargets(IDataObject target) {
        return this.getDataTargetList().contains(target);
    }

    @Override
    public int getDataTargetsCount() {
        return this.getDataTargetList().size();
    }

    private boolean isTargetAttachedToMultipleOutputPorts(IDataObject target) {
        if (target == null) {
            return false;
        }
        int iCount = 0;
        if (this.m_oCompareTable.getChangedRcdsTable() == target) {
            ++iCount;
        }
        if (this.m_oCompareTable.getNewRcdsTable() == target) {
            ++iCount;
        }
        if (this.m_oCompareTable.getUnchangedRcdsTable() == target) {
            ++iCount;
        }
        if (this.m_oCompareTable.getMissingRcdsTable() == target) {
            ++iCount;
        }
        return iCount > 1;
    }

    @Override
    public void removeDataTarget(IDataObject target) {
    }

    private void removeDataTarget(CompareTablesPortDescriptionModel portDesc, IDataObject target) {
        if (portDesc != null && portDesc.getObject() == target) {
            portDesc.setObject(null);
            this.removeDataTargetImpl(target);
        }
    }

    private void removeDataTargetImpl(IDataObject target) {
        if (target.containsInProducerTransforms(this) && !this.isTargetAttachedToMultipleOutputPorts(target)) {
            target.removeProducerTransform(this);
            target.removeNotifyListener(this);
            if (!this.getModel().isUndoing()) {
                this.removeTargetTableFromMappings((ITable)target);
                this.preRemoveTransformTableOptions(target, false);
            }
            if (target instanceof IWorkTable) {
                this.addToDeletedObjects(target);
            }
        }
    }

    @Override
    public boolean isDataTargetsAllowed() {
        int index = this.findFirstEmptyPort();
        return index > -1;
    }

    @Override
    public boolean isDataSourcesAllowed() {
        return this.m_oCompareTable.getComparisonTable() == null || this.m_oCompareTable.getSourceTable() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceTable(IPhysicalTable source) {
        if (this.m_oCompareTable.getSourceTable() == null ? source == null : this.m_oCompareTable.getSourceTable().equals(source)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IPhysicalTable oldSourceTable = this.m_oCompareTable.getSourceTable();
            this.m_oCompareTable.setSourceTable(source);
            CompareTablesPortDescriptionModel portDesc = this.m_lInputPortDescriptions.get(0);
            if (oldSourceTable != null) {
                this.removeDataSource(portDesc, oldSourceTable);
                this.fireModelChangedEvent("DataTransform.DataSourceRemoved", oldSourceTable, new Integer(1));
            }
            if (this.m_oCompareTable.getSourceTable() != null) {
                this.addDataSource(portDesc, (IDataObject)source);
                this.fireModelChangedEvent("DataTransform.DataSourceAdded", source, new Integer(1));
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetSourceTableUndoable(source, oldSourceTable));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getSourceTable() {
        return this.m_oCompareTable.getSourceTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComparisonTable(IPhysicalTable source, boolean isReplace) {
        if (this.m_oCompareTable.getComparisonTable() == null ? source == null : this.m_oCompareTable.getComparisonTable().equals(source)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IPhysicalTable oldComparisonTable = this.m_oCompareTable.getComparisonTable();
            this.m_oCompareTable.setComparisonTable(source, isReplace);
            CompareTablesPortDescriptionModel portDesc = this.m_lInputPortDescriptions.get(1);
            if (oldComparisonTable != null) {
                this.removeDataSource(portDesc, oldComparisonTable);
                this.fireModelChangedEvent("DataTransform.DataSourceRemoved", oldComparisonTable, new Integer(2));
            }
            if (source != null) {
                this.addDataSource(portDesc, (IDataObject)source);
                this.fireModelChangedEvent("DataTransform.DataSourceAdded", source, new Integer(2));
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetComparisonTableUndoable(source, oldComparisonTable, isReplace));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public IPhysicalTable getComparisonTable() {
        return this.m_oCompareTable.getComparisonTable();
    }

    @Override
    public ITable[] getSourceTables() {
        if (this.m_oCompareTable != null && this.m_oCompareTable.getSourceTable() != null) {
            return new ITable[]{this.m_oCompareTable.getSourceTable()};
        }
        return new ITable[0];
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        ArrayList<ITable> aTargets = new ArrayList<ITable>();
        for (int i = 0; i < aTargetTables.length; ++i) {
            if (aTargetTables[i] == this.m_oCompareTable.getMissingRcdsTable()) continue;
            aTargets.add(aTargetTables[i]);
        }
        ArrayList<ITable> aSources = new ArrayList<ITable>();
        for (int i = 0; i < aSourceTables.length; ++i) {
            if (aSourceTables[i] == this.m_oCompareTable.getComparisonTable()) continue;
            aSources.add(aSourceTables[i]);
        }
        if (aSources.size() > 0 && aTargets.size() > 0) {
            super.propagateColumnsToTargetTables(aSources.toArray(new ITable[aSources.size()]), aTargets.toArray(new ITable[aTargets.size()]), eNonWorkTableHandling);
        }
    }

    @Override
    public ITable[] getTargetTables() {
        ArrayList<IPhysicalTable> lDataTargets = new ArrayList<IPhysicalTable>();
        if (this.m_oCompareTable != null) {
            if (this.m_oCompareTable.getChangedRcdsTable() != null) {
                lDataTargets.add(this.m_oCompareTable.getChangedRcdsTable());
            }
            if (this.m_oCompareTable.getNewRcdsTable() != null) {
                lDataTargets.add(this.m_oCompareTable.getNewRcdsTable());
            }
            if (this.m_oCompareTable.getUnchangedRcdsTable() != null) {
                lDataTargets.add(this.m_oCompareTable.getUnchangedRcdsTable());
            }
        }
        return lDataTargets.toArray(new ITable[lDataTargets.size()]);
    }

    public IPhysicalTable getTargetTable(int portIndex) {
        if (portIndex == 0) {
            return this.m_oCompareTable.getChangedRcdsTable();
        }
        if (portIndex == 1) {
            return this.m_oCompareTable.getNewRcdsTable();
        }
        if (portIndex == 2) {
            return this.m_oCompareTable.getUnchangedRcdsTable();
        }
        if (portIndex == 3) {
            return this.m_oCompareTable.getMissingRcdsTable();
        }
        return null;
    }

    public void setTargetTable(IPhysicalTable target) {
        for (int i = 0; i < this.m_lOutputPortDescriptions.size(); ++i) {
            CompareTablesPortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(i);
            if (!portDesc.isEmpty()) continue;
            this.setTargetTable(target, i);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetTable(IPhysicalTable target, int portIndex) {
        IPhysicalTable oldTarget = null;
        if (portIndex == 0) {
            oldTarget = this.m_oCompareTable.getChangedRcdsTable();
        } else if (portIndex == 1) {
            oldTarget = this.m_oCompareTable.getNewRcdsTable();
        } else if (portIndex == 2) {
            oldTarget = this.m_oCompareTable.getUnchangedRcdsTable();
        } else if (portIndex == 3) {
            oldTarget = this.m_oCompareTable.getMissingRcdsTable();
        }
        if (oldTarget == null ? target == null : oldTarget.equals(target)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (portIndex == 0) {
                this.m_oCompareTable.setChangedRcdsTable(target);
            } else if (portIndex == 1) {
                this.m_oCompareTable.setNewRcdsTable(target);
            } else if (portIndex == 2) {
                this.m_oCompareTable.setUnchangedRcdsTable(target);
            } else if (portIndex == 3) {
                this.m_oCompareTable.setMissingRcdsTable(target);
            }
            CompareTablesPortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(portIndex);
            if (oldTarget != null) {
                this.removeDataTarget(portDesc, oldTarget);
                this.fireModelChangedEvent("DataTransform.DataTargetRemoved", oldTarget, new Integer(portIndex + 1));
            }
            if (target != null) {
                this.addDataTarget(portDesc, (IDataObject)target);
                this.fireModelChangedEvent("DataTransform.DataTargetAdded", target, new Integer(portIndex + 1));
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetTargetTableUndoable(target, oldTarget, portIndex));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            int port = this.findFirstEmptyPort();
            if (port == -1) {
                IWorkTable iWorkTable = null;
                return iWorkTable;
            }
            IWorkTable tbl = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
            this.setTargetTable(tbl);
            String name = tbl.getName();
            if (port == 0) {
                name = RB.getStringResource("CompareTablesTransformModel.NewWorkTableChangedName.txt");
            } else if (port == 1) {
                name = RB.getStringResource("CompareTablesTransformModel.NewWorkTableNewName.txt");
            } else if (port == 2) {
                name = RB.getStringResource("CompareTablesTransformModel.NewWorkTableUnChangedName.txt");
            } else if (port == 3) {
                name = RB.getStringResource("CompareTablesTransformModel.NewWorkTableMissingName.txt");
                this.addColumnsToMissingTable();
            }
            tbl.setName(name);
            IWorkTable iWorkTable = tbl;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumnsToMissingTable() {
        IPhysicalTable oMissingTbl = null;
        if (this.m_oCompareTable != null) {
            oMissingTbl = this.m_oCompareTable.getMissingRcdsTable();
        }
        if (oMissingTbl != null && oMissingTbl instanceof IWorkTable) {
            this.startCompoundUndoable();
            try {
                int i;
                for (i = oMissingTbl.getColumnCount() - 1; i >= 0; --i) {
                    oMissingTbl.removeColumn(oMissingTbl.getColumns()[i]);
                }
                for (i = 0; i < this.m_oCompareTable.getMatchKeyMappings().length; ++i) {
                    IColumn newCol = this.getModel().getObjectFactory().createNewColumn(this.getID());
                    IMapping map = this.m_oCompareTable.getMatchKeyMappings()[i];
                    if (map.getTargetCount() <= 0) continue;
                    IColumn col = map.getTargets()[0];
                    col.copy(newCol);
                    oMissingTbl.addColumn(newCol);
                }
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    private int findFirstEmptyPort() {
        int port = -1;
        for (int i = 0; i < this.m_lOutputPortDescriptions.size(); ++i) {
            CompareTablesPortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(i);
            if (!portDesc.isEmpty()) continue;
            return i;
        }
        return port;
    }

    public static String getTransformTypeID() {
        return "job.transforms.CompareTablesTransformModel";
    }

    @Override
    protected String getTransformClass() {
        return "job.transforms.CompareTablesTransformModel";
    }

    @Override
    protected String getTransformRole() {
        return "job.transforms.CompareTablesTransformModel";
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("CompareTablesTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("CompareTablesTransformModel.Name.txt");
    }

    public CompareTablesPortDescriptionModel[] getInputPortDescriptions() {
        return this.m_lInputPortDescriptions.toArray(new CompareTablesPortDescriptionModel[this.m_lInputPortDescriptions.size()]);
    }

    public List<CompareTablesPortDescriptionModel> getInputPortDescriptionList() {
        return this.m_lInputPortDescriptions;
    }

    public CompareTablesPortDescriptionModel[] getOutputPortDescriptions() {
        return this.m_lOutputPortDescriptions.toArray(new CompareTablesPortDescriptionModel[this.m_lOutputPortDescriptions.size()]);
    }

    public List<CompareTablesPortDescriptionModel> getOutputPortDescriptionList() {
        return this.m_lOutputPortDescriptions;
    }

    public int[] findInSourcePorts(IPhysicalTable table) {
        ArrayList<Integer> lPorts = new ArrayList<Integer>();
        for (int iPort = 0; iPort < this.m_lInputPortDescriptions.size(); ++iPort) {
            CompareTablesPortDescriptionModel portDesc = this.m_lInputPortDescriptions.get(iPort);
            IObject object = portDesc.getObject();
            if (object != table) continue;
            lPorts.add(new Integer(iPort));
        }
        int[] iaPorts = new int[lPorts.size()];
        for (int i = 0; i < lPorts.size(); ++i) {
            iaPorts[i] = (Integer)lPorts.get(i);
        }
        return iaPorts;
    }

    public int[] findInTargetPorts(IPhysicalTable table) {
        ArrayList<Integer> lPorts = new ArrayList<Integer>();
        for (int iPort = 0; iPort < this.m_lOutputPortDescriptions.size(); ++iPort) {
            CompareTablesPortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(iPort);
            IObject targetTable = portDesc.getObject();
            if (targetTable != table) continue;
            lPorts.add(new Integer(iPort));
        }
        int[] iaPorts = new int[lPorts.size()];
        for (int i = 0; i < lPorts.size(); ++i) {
            iaPorts[i] = (Integer)lPorts.get(i);
        }
        return iaPorts;
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        for (int i = 0; i < this.m_lOutputPortDescriptions.size(); ++i) {
            CompareTablesPortDescriptionModel portDesc = this.m_lOutputPortDescriptions.get(i);
            if (!portDesc.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_oCompareTable.isChanged();
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && (this.isUsingUserWrittenCode() || this.m_oCompareTable.isComplete() && this.isMissingRcdTblComplete());
    }

    private boolean isMissingRcdTblComplete() {
        if (this.m_oCompareTable != null && this.m_oCompareTable.getMissingRcdsTable() != null) {
            IPhysicalTable oMissingTbl = this.m_oCompareTable.getMissingRcdsTable();
            for (int i = 0; i < this.m_oCompareTable.getMatchKeyMappings().length; ++i) {
                IColumn compareColumn;
                IColumn column;
                IMapping map = this.m_oCompareTable.getMatchKeyMappings()[i];
                if (map.getTargetCount() <= 0 || (column = oMissingTbl.getColumnWithMatchingName((compareColumn = map.getTargets()[0]).getName())) != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (!this.isUsingUserWrittenCode() && !this.m_oCompareTable.isComplete()) {
            lReasons.addAll(this.m_oCompareTable.getReasonsIncomplete());
        }
        if (!this.isMissingRcdTblComplete()) {
            lReasons.add(RB.getStringResource("CompareTables.ReasonIncomplete.IncompleteMissingRcdsTable.msg.txt"));
        }
        return lReasons;
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings()) {
            return true;
        }
        return this.m_oCompareTable.hasWarnings();
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        warnings.addAll(this.m_oCompareTable.getWarnings());
        return warnings;
    }

    @Override
    public void notify(NotifyEvent ev) {
        ModelEvent event;
        if (ev.getType() == 1 && ev.getSource() == this.m_oCompareTable) {
            this.fireModelChangedEvent("ITransform:TransformChanged", this.m_oCompareTable);
        }
        IObject source = (IObject)ev.getSource();
        if (ev.getType() == 1 && source instanceof IMapping && (event = ev.getModelEvent()) != null) {
            IMapping map = (IMapping)source;
            if (event.getType().equals("Mapping:TargetColumnAdded") && map.getType().equals("MatchKey")) {
                this.addColumnsToMissingTable();
            }
        }
        super.notify(ev);
    }

    @Override
    protected int getMaximumDataSourceCount() {
        return 2;
    }

    @Override
    protected int getMaximumDataTargetCount() {
        return 4;
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new cCompareTablesOptionModel(this);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        if (!this.m_oCompareTable.isChanged()) {
            this.m_oCompareTable.setChanged(true);
        }
        TransformationStep step = (TransformationStep)omr.acquireOMRObject(this);
        AssociationList lCustAssoc = step.getCustomAssociations(false);
        lCustAssoc.clear();
        super.saveToOMR(omr);
        if (this.m_oCompareTable != null) {
            this.m_oCompareTable.saveToOMR(omr);
        }
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.m_oCompareTable != null) {
            this.m_oCompareTable.loadFromOMR(omr);
        }
        this.loadTables();
        super.loadFromOMR(omr);
        if (this.m_oCompareTable != null) {
            this.m_oCompareTable.setUseDataHashStep(this.loadBooleanOptionFromOMR(omr, "DataHash", true));
            this.m_oCompareTable.setHashInternalTableSize(this.loadIntOptionFromOMR(omr, "HashExp", 10));
            this.m_oCompareTable.setCompareToDigestColumn(this.loadBooleanOptionFromOMR(omr, "CompareDigest", false));
            this.m_oCompareTable.setChangeDigestVersion(this.loadStringOptionFromOMR(omr, "ChangeDigestVersion", "V2_1"));
        }
        this.setChanged(false);
    }

    private void loadTables() {
        if (this.m_oCompareTable == null) {
            return;
        }
        this.addDataSource(this.m_lInputPortDescriptions.get(0), (IDataObject)this.m_oCompareTable.getSourceTable());
        this.addDataSource(this.m_lInputPortDescriptions.get(1), (IDataObject)this.m_oCompareTable.getComparisonTable());
        this.addDataTarget(this.m_lOutputPortDescriptions.get(0), (IDataObject)this.m_oCompareTable.getChangedRcdsTable());
        this.addDataTarget(this.m_lOutputPortDescriptions.get(1), (IDataObject)this.m_oCompareTable.getNewRcdsTable());
        this.addDataTarget(this.m_lOutputPortDescriptions.get(2), (IDataObject)this.m_oCompareTable.getUnchangedRcdsTable());
        this.addDataTarget(this.m_lOutputPortDescriptions.get(3), (IDataObject)this.m_oCompareTable.getMissingRcdsTable());
    }

    @Override
    public void delete() {
        if (this.m_oCompareTable != null) {
            this.m_oCompareTable.removeNotifyListener(this);
            this.m_oCompareTable.delete();
        }
        super.delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_oCompareTable != null) {
            this.m_oCompareTable.delete();
        }
        super.deleteFromOMR(omr);
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment);
        this.m_oCompareTable.getGeneratedCode(codeSegment);
        return codeSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            boolean bCaseSensitive = this.isQuotingNeeded() || newTable.isQuoted();
            for (int i = 0; i < portIndexes.length; ++i) {
                IColumn[] aColumns;
                int iMap;
                int iNewColumn;
                int iPortIndex = portIndexes[i] - 1;
                if (iPortIndex == 0) {
                    IColumn newColumn;
                    boolean bFoundColumn;
                    IColumn column;
                    int iColumn;
                    IColumn[] aColumns2;
                    IMapping mapping;
                    int iMap2;
                    ArrayList<IMapping> lChangedMappings = new ArrayList<IMapping>();
                    IMapping[] aMappings = this.getMappings();
                    IColumn[] aNewColumns = newTable.getColumns();
                    for (iMap2 = 0; iMap2 < aMappings.length; ++iMap2) {
                        mapping = aMappings[iMap2];
                        aColumns2 = mapping.getSources();
                        block5: for (iColumn = 0; iColumn < aColumns2.length; ++iColumn) {
                            column = aColumns2[iColumn];
                            if (columnsMap != null && (IColumn)columnsMap.get(aColumns2[iColumn]) != null) {
                                mapping.replaceSourceColumn(column, (IColumn)columnsMap.get(aColumns2[iColumn]));
                                lChangedMappings.add(mapping);
                                continue;
                            }
                            if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                            for (iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                                IColumn newColumn2 = aNewColumns[iNewColumn];
                                if (!column.equalsName(newColumn2, bCaseSensitive) || column.getLength() < newColumn2.getLength() || column.getType() != newColumn2.getType()) continue;
                                mapping.replaceSourceColumn(column, newColumn2);
                                lChangedMappings.add(mapping);
                                continue block5;
                            }
                        }
                    }
                    for (iMap2 = 0; iMap2 < aMappings.length; ++iMap2) {
                        mapping = aMappings[iMap2];
                        if (lChangedMappings.contains(mapping) || !"ONETOONE".equals(mapping.getType())) continue;
                        this.removeMapping(mapping);
                    }
                    aMappings = this.m_oCompareTable.getMatchKeyMappings();
                    aNewColumns = newTable.getColumns();
                    for (iMap2 = 0; iMap2 < aMappings.length; ++iMap2) {
                        mapping = aMappings[iMap2];
                        aColumns2 = mapping.getSources();
                        for (iColumn = 0; iColumn < aColumns2.length; ++iColumn) {
                            column = aColumns2[iColumn];
                            if (columnsMap != null && (IColumn)columnsMap.get(aColumns2[iColumn]) != null) {
                                mapping.replaceSourceColumn(column, (IColumn)columnsMap.get(aColumns2[iColumn]));
                                continue;
                            }
                            if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                            bFoundColumn = false;
                            for (int iNewColumn2 = 0; iNewColumn2 < aNewColumns.length; ++iNewColumn2) {
                                newColumn = aNewColumns[iNewColumn2];
                                if (!column.equalsName(newColumn, bCaseSensitive) || column.getType() != newColumn.getType()) continue;
                                mapping.replaceSourceColumn(column, newColumn);
                                bFoundColumn = true;
                                break;
                            }
                            if (bFoundColumn) continue;
                            this.m_oCompareTable.removeMatchKeyMapping(mapping);
                        }
                    }
                    aMappings = this.m_oCompareTable.getCompareColumnsMappings();
                    aNewColumns = newTable.getColumns();
                    for (iMap2 = 0; iMap2 < aMappings.length; ++iMap2) {
                        mapping = aMappings[iMap2];
                        aColumns2 = mapping.getSources();
                        for (iColumn = 0; iColumn < aColumns2.length; ++iColumn) {
                            column = aColumns2[iColumn];
                            if (columnsMap != null && (IColumn)columnsMap.get(aColumns2[iColumn]) != null) {
                                mapping.replaceSourceColumn(column, (IColumn)columnsMap.get(aColumns2[iColumn]));
                                continue;
                            }
                            if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                            bFoundColumn = false;
                            for (int iNewColumn3 = 0; iNewColumn3 < aNewColumns.length; ++iNewColumn3) {
                                newColumn = aNewColumns[iNewColumn3];
                                if (!column.equalsName(newColumn, bCaseSensitive) || column.getType() != newColumn.getType()) continue;
                                mapping.replaceSourceColumn(column, newColumn);
                                bFoundColumn = true;
                                break;
                            }
                            if (bFoundColumn) continue;
                            this.m_oCompareTable.removeCompareColumnsMapping(mapping);
                        }
                    }
                    this.setSourceTable((IPhysicalTable)newTable);
                    continue;
                }
                if (iPortIndex != 1) continue;
                IMapping[] aMappings = this.m_oCompareTable.getMatchKeyMappings();
                IColumn[] aNewColumns = newTable.getColumns();
                for (iMap = 0; iMap < aMappings.length; ++iMap) {
                    IMapping mapping = aMappings[iMap];
                    aColumns = mapping.getTargets();
                    for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                        IColumn column = aColumns[iColumn];
                        if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                            mapping.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                            continue;
                        }
                        if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                        boolean bFoundColumn = false;
                        for (iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                            IColumn newColumn = aNewColumns[iNewColumn];
                            if (!column.equalsName(newColumn, bCaseSensitive) || column.getType() != newColumn.getType()) continue;
                            mapping.replaceTargetColumn(column, newColumn);
                            bFoundColumn = true;
                            break;
                        }
                        if (bFoundColumn) continue;
                        mapping.removeTarget(column);
                    }
                }
                aMappings = this.m_oCompareTable.getCompareColumnsMappings();
                aNewColumns = newTable.getColumns();
                for (iMap = 0; iMap < aMappings.length; ++iMap) {
                    IMapping mapping = aMappings[iMap];
                    aColumns = mapping.getTargets();
                    for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                        IColumn column = aColumns[iColumn];
                        if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                            mapping.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                            continue;
                        }
                        if (!Arrays.asList(oldTable.getColumns()).contains(column)) continue;
                        boolean bFoundColumn = false;
                        for (iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                            IColumn newColumn = aNewColumns[iNewColumn];
                            if (!column.equalsName(newColumn, bCaseSensitive) || column.getType() != newColumn.getType()) continue;
                            mapping.replaceTargetColumn(column, newColumn);
                            bFoundColumn = true;
                            break;
                        }
                        if (bFoundColumn) continue;
                        mapping.removeTarget(column);
                    }
                }
                this.setComparisonTable((IPhysicalTable)newTable, true);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            IMapping mapping;
            int iMap;
            ArrayList<IMapping> lChangedMappings = new ArrayList<IMapping>();
            IMapping[] aMappings = this.getTargetTableMapping(oldTable);
            IColumn[] aNewColumns = newTable.getColumns();
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                IColumn[] aColumns = mapping.getTargets();
                block4: for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                    IColumn column = aColumns[iColumn];
                    if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                        mapping.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                        lChangedMappings.add(mapping);
                        continue;
                    }
                    if (Arrays.asList(oldTable.getColumns()).indexOf(column) == -1) continue;
                    for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                        IColumn newColumn = aNewColumns[iNewColumn];
                        if (!column.getName().equals(newColumn.getName()) || column.getLength() < newColumn.getLength() || column.getType() != newColumn.getType()) continue;
                        mapping.replaceTargetColumn(column, newColumn);
                        lChangedMappings.add(mapping);
                        continue block4;
                    }
                }
            }
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                if (lChangedMappings.indexOf(mapping) != -1 || mapping.getType() != "ONETOONE") continue;
                this.removeMapping(mapping);
            }
            if (oldTable == this.m_oCompareTable.getChangedRcdsTable()) {
                this.setTargetTable((IPhysicalTable)newTable, 0);
            } else if (oldTable == this.m_oCompareTable.getNewRcdsTable()) {
                this.setTargetTable((IPhysicalTable)newTable, 1);
            } else if (oldTable == this.m_oCompareTable.getUnchangedRcdsTable()) {
                this.setTargetTable((IPhysicalTable)newTable, 2);
            } else if (oldTable == this.m_oCompareTable.getMissingRcdsTable()) {
                this.setTargetTable((IPhysicalTable)newTable, 3);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private IMapping[] getTargetTableMapping(ITable table) {
        ArrayList<IMapping> lMappings = new ArrayList<IMapping>();
        IColumn[] aCols = table.getColumns();
        for (int index = 0; index < aCols.length; ++index) {
            IMapping mapping = this.getOrdinaryMappingsForTargetColumn(aCols[index]);
            if (mapping == null) continue;
            lMappings.add(mapping);
        }
        return lMappings.toArray(new IMapping[lMappings.size()]);
    }

    private class SetTargetTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newTargetTable;
        private IPhysicalTable m_oldTargetTable;
        private int m_iPort;

        public SetTargetTableUndoable(IPhysicalTable newTargetTable, IPhysicalTable oldTargetTable, int portIndex) {
            this.m_newTargetTable = newTargetTable;
            this.m_oldTargetTable = oldTargetTable;
            this.m_iPort = portIndex;
        }

        @Override
        public void undo() {
            super.undo();
            CompareTablesTransformModel.this.setTargetTable(this.m_oldTargetTable, this.m_iPort);
        }

        @Override
        public void redo() {
            super.redo();
            CompareTablesTransformModel.this.setTargetTable(this.m_newTargetTable, this.m_iPort);
        }

        @Override
        public void die() {
            super.die();
            this.m_newTargetTable = null;
            this.m_oldTargetTable = null;
        }
    }

    private class SetComparisonTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newComparisonTable;
        private IPhysicalTable m_oldComparisonTable;
        private boolean m_isReplace;

        public SetComparisonTableUndoable(IPhysicalTable newComparisonTable, IPhysicalTable oldComparisonTable, boolean isReplace) {
            this.m_newComparisonTable = newComparisonTable;
            this.m_oldComparisonTable = oldComparisonTable;
            this.m_isReplace = isReplace;
        }

        @Override
        public void undo() {
            super.undo();
            CompareTablesTransformModel.this.setComparisonTable(this.m_oldComparisonTable, this.m_isReplace);
        }

        @Override
        public void redo() {
            super.redo();
            CompareTablesTransformModel.this.setComparisonTable(this.m_newComparisonTable, this.m_isReplace);
        }

        @Override
        public void die() {
            super.die();
            this.m_newComparisonTable = null;
            this.m_oldComparisonTable = null;
        }
    }

    private class SetSourceTableUndoable
    extends AbstractUndoableEdit {
        private IPhysicalTable m_newSourceTable;
        private IPhysicalTable m_oldSourceTable;

        public SetSourceTableUndoable(IPhysicalTable newSourceTable, IPhysicalTable oldSourceTable) {
            this.m_newSourceTable = newSourceTable;
            this.m_oldSourceTable = oldSourceTable;
        }

        @Override
        public void undo() {
            super.undo();
            CompareTablesTransformModel.this.setSourceTable(this.m_oldSourceTable);
        }

        @Override
        public void redo() {
            super.redo();
            CompareTablesTransformModel.this.setSourceTable(this.m_newSourceTable);
        }

        @Override
        public void die() {
            super.die();
            this.m_newSourceTable = null;
            this.m_oldSourceTable = null;
        }
    }

    protected class cCompareTablesOptionModel
    extends BaseDataTransformPromptModel {
        public cCompareTablesOptionModel(CompareTablesTransformModel model) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model.getModel(), model);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(cCompareTablesOptionModel.class.getResource("res/Options_CompareTables_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServiceException, ServerConnectionException {
            super.setValuesFromModel();
            CompareTablesTransformModel transform = (CompareTablesTransformModel)this.getOwner();
            ICompareTables compare = transform.getCompareTablesObject();
            if (compare != null) {
                this.setOptionValue("DataHash", (Object)(compare.useDataHashStep() ? CompareTablesTransformModel.OPTIONS_TRUE : CompareTablesTransformModel.OPTIONS_FALSE));
                this.setOptionValue("HashExp", (Object)compare.getHashInternalTableSize());
                this.setOptionValue("ChangeDigestVersion", (Object)compare.getChangeDigestVersion());
            }
        }

        @Override
        protected IModelListener createModelListener() {
            return new cCompareTablesModelChangeListener();
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new CompareTablesTransformValueChangedListener((CompareTablesTransformModel)this.getOwner(), this);
        }

        private class CompareTablesTransformValueChangedListener
        extends BaseDataTransformValueChangedListener {
            public CompareTablesTransformValueChangedListener(CompareTablesTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    ICompareTables compare;
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if ((compare = CompareTablesTransformModel.this.getCompareTablesObject()) != null) {
                        if (optionName.equals("DataHash")) {
                            compare.setUseDataHashStep(value.equals(CompareTablesTransformModel.OPTIONS_TRUE));
                        } else if (optionName.equals("HashExp")) {
                            compare.setHashInternalTableSize(new Integer(value.toString()));
                        } else if (optionName.equals("ChangeDigestVersion")) {
                            compare.setChangeDigestVersion(value.toString());
                        }
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                    CompareTablesTransformModel.this.getPromptModel().setListeningForChanges(true);
                    cCompareTablesOptionModel.this.setChanged(true);
                }
            }
        }

        private class cCompareTablesModelChangeListener
        extends BaseDataTransformModelListener {
            public cCompareTablesModelChangeListener() {
                super(cCompareTablesOptionModel.this.getOwner(), cCompareTablesOptionModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    ICompareTables compare = CompareTablesTransformModel.this.getCompareTablesObject();
                    if (compare != null) {
                        if (type.equals("CompareTablesTransformModel:UseHashObjectChanged")) {
                            cCompareTablesOptionModel.this.setOptionValue("DataHash", (Object)(compare.useDataHashStep() ? CompareTablesTransformModel.OPTIONS_TRUE : CompareTablesTransformModel.OPTIONS_FALSE));
                        } else if (type.equals("CompareTablesTransformModel:HashExpChanged")) {
                            cCompareTablesOptionModel.this.setOptionValue("HashExp", (Object)compare.getHashInternalTableSize());
                        } else if (type.equals("CompareTables:ChangeDigestVersionChanged")) {
                            cCompareTablesOptionModel.this.setOptionValue("ChangeDigestVersion", (Object)compare.getChangeDigestVersion());
                        }
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }
    }
}

