/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.comparetables.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.BaseObject;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.comparetables.ICompareTables;
import com.sas.etl.models.job.transforms.comparetables.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class CompareTables
extends BaseObject
implements ICompareTables {
    private static final String SOURCE_TABLE = "SourceTable";
    private static final String COMPARISON_TABLE = "ComparisonTable";
    public static final String CHANGED_RCDS_TABLE = "ChangedRcdsTable";
    public static final String NEW_RCDS_TABLE = "NewRcdsTable";
    private static final String UNCHANGED_RCDS_TABLE = "UnchangedRcdsTable";
    private static final String MISSING_RCDS_TABLE = "MissingRcdsTable";
    private static final String MATCH_KEY_MAPS = "MatchKeyMaps";
    private static final String COMPARE_COLUMNS_MAPS = "CompareKeyMaps";
    private static final String COMPARE_DIGEST_COLUMN = "CompareDigestColumn";
    public static final String SOURCE_DIGEST_NAME = "source_digest";
    public static final String COMPARE_DIGEST_NAME = "compare_digest";
    public static final String CMP_HASH_REF = "hct";
    public static final String WORK_COMPARE = "work.etls_compare_digest";
    public static final String WORK_MISSING_RECORDS = "work.etls_missing_records";
    private static final String NOT_REQUESTED_COMMENT = "/* - TARGET TABLE NOT REQUESTED - */";
    public static final int DEFAULT_HASH_INTERNAL_TABLE_SIZE = 10;
    public static final String DEFAULT_CHANGE_DIGEST_VERSION = "V2_1";
    private ModelList m_lMatchKey;
    private ModelList m_lCompareColumns;
    private IColumn m_oDigestColumn;
    private boolean m_bCompareToDigest;
    private boolean m_bUseDataHashStep;
    private int m_iHashInternalTableSize;
    private IDataTransform m_oOwner;
    private String m_sChangeDigestVersion;
    private IPhysicalTable m_oSourceTable;
    private IPhysicalTable m_oComparisonTable;
    private IPhysicalTable m_oChangedRcdsTable;
    private IPhysicalTable m_oNewRcdsTable;
    private IPhysicalTable m_oUnchangedRcdsTable;
    private IPhysicalTable m_oMissingRcdsTable;
    protected static Map m_hTargetTableNames;
    protected static Map m_hTargetTablesTemp;

    public CompareTables(String sid, IModel model, IDataTransform owner) {
        super(sid, model);
        this.m_oOwner = owner;
        this.m_bCompareToDigest = false;
        this.m_bUseDataHashStep = true;
        this.m_iHashInternalTableSize = 10;
        this.m_lMatchKey = new ModelList((AbstractPersistableObject)((Object)owner), new String[]{"CompareTables:MatchKeyMappingAdded", "CompareTables:MatchKeyMappingRemoved", "CompareTables:MatchKeyMappingMoved"}, 3, IMapping.class);
        this.m_lMatchKey.setOwnerNotified(true);
        this.m_lCompareColumns = new ModelList((AbstractPersistableObject)((Object)owner), new String[]{"CompareTables:CompareColumnsMappingAdded", "CompareTables:CompareColumnsMappinRemoved", "CompareTables:CompareColumnsMappinMoved"}, 3, IMapping.class);
        this.m_lCompareColumns.setOwnerNotified(true);
        this.m_sChangeDigestVersion = DEFAULT_CHANGE_DIGEST_VERSION;
    }

    @Override
    public IMapping createNewCompareColumnsMapping() {
        IMapping map = this.getModel().getObjectFactory().createNewMapping(this.getID());
        map.setType("CompareColumns");
        return map;
    }

    @Override
    public IMapping createNewMatchKeyMapping() {
        IMapping map = this.getModel().getObjectFactory().createNewMapping(this.getID());
        map.setType("MatchKey");
        return map;
    }

    @Override
    public void setCompareToDigestColumn(boolean compareToDigest) {
        if (this.m_bCompareToDigest == compareToDigest) {
            return;
        }
        this.m_bCompareToDigest = compareToDigest;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCompareToDigestColumnUndoable(this.m_bCompareToDigest));
        }
        this.fireModelChangedEvent("CompareTables:CompareToDigestChanged", null);
    }

    @Override
    public boolean compareToDigestColumn() {
        return this.m_bCompareToDigest;
    }

    @Override
    public IColumn getDigestColumn() {
        return this.m_oDigestColumn;
    }

    @Override
    public void setDigestColumn(IColumn column) {
        if (this.m_oDigestColumn == column) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDigestColumnUndoable(this.m_oDigestColumn, column));
        }
        this.m_oDigestColumn = column;
        this.fireModelChangedEvent("CompareTables:CompareToDigestColumnChanged", null);
    }

    @Override
    public String getChangeDigestVersion() {
        return this.m_sChangeDigestVersion;
    }

    @Override
    public void setChangeDigestVersion(String sOption) {
        if (this.m_sChangeDigestVersion.equalsIgnoreCase(sOption)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetChangeDigestVersionUndoable(this.m_sChangeDigestVersion, sOption));
        }
        this.m_sChangeDigestVersion = sOption;
        this.fireModelChangedEvent("CompareTables:ChangeDigestVersionChanged", this.m_sChangeDigestVersion);
    }

    @Override
    public IMapping[] getMatchKeyMappings() {
        return (IMapping[])this.m_lMatchKey.toArray(new IMapping[this.m_lMatchKey.size()]);
    }

    @Override
    public ModelList getMatchKeyMappingsList() {
        return this.m_lMatchKey;
    }

    @Override
    public IMapping addNewMatchKeyMapping(IColumn sourceColumn, boolean useMapping) {
        IColumn compareColumn = this.findMatchCompareColumn(sourceColumn, useMapping);
        IMapping newMap = this.addNewMatchKeyMapping(sourceColumn, compareColumn);
        return newMap;
    }

    @Override
    public IMapping addNewMatchKeyMapping(IColumn sourceColumn, IColumn compareColumn) {
        IMapping matchKeyMap = this.createNewMatchKeyMapping();
        if (sourceColumn != null) {
            matchKeyMap.addSource(sourceColumn);
        }
        if (compareColumn != null) {
            matchKeyMap.addTarget(compareColumn);
        }
        this.m_lMatchKey.add(matchKeyMap);
        return matchKeyMap;
    }

    @Override
    public void removeMatchKeyMapping(IMapping map) {
        if (this.m_lMatchKey.contains(map)) {
            this.m_lMatchKey.remove(map);
        }
    }

    @Override
    public void moveMatchKeyMapping(IMapping map, int iTo) {
        this.m_lMatchKey.move(map, iTo);
    }

    @Override
    public IColumn findMatchCompareColumn(IColumn sourceColumn, boolean useMapping) {
        if (this.m_oComparisonTable != null) {
            int i;
            if (useMapping) {
                IMapping[] maps = this.getCompareTableMappings();
                for (i = 0; i < maps.length; ++i) {
                    if (maps[i].getSourceCount() <= 0 || sourceColumn != maps[i].getSources()[0] || maps[i].getTargetCount() <= 0) continue;
                    return maps[i].getTargets()[0];
                }
            }
            IColumn[] columns = this.m_oComparisonTable.getColumns();
            for (i = 0; i < columns.length; ++i) {
                if (!columns[i].getColumnName(false).equalsIgnoreCase(sourceColumn.getColumnName(false)) || columns[i].getType() != sourceColumn.getType()) continue;
                return columns[i];
            }
        }
        return null;
    }

    private IMapping[] getCompareTableMappings() {
        ArrayList<IMapping> lMappings = new ArrayList<IMapping>();
        IColumn[] aCols = this.m_oComparisonTable.getColumns();
        for (int index = 0; index < aCols.length; ++index) {
            IMapping mapping = this.m_oOwner.getOrdinaryMappingsForTargetColumn(aCols[index]);
            if (mapping == null) continue;
            lMappings.add(mapping);
        }
        return lMappings.toArray(new IMapping[lMappings.size()]);
    }

    @Override
    public IMapping[] getCompareColumnsMappings() {
        return (IMapping[])this.m_lCompareColumns.toArray(new IMapping[this.m_lCompareColumns.size()]);
    }

    @Override
    public ModelList getCompareColumnsMappingsList() {
        return this.m_lCompareColumns;
    }

    @Override
    public IMapping addNewCompareColumnsMapping(IColumn sourceColumn, boolean useMapping) {
        IColumn compareColumn = this.findMatchCompareColumn(sourceColumn, useMapping);
        return this.addNewCompareColumnsMapping(sourceColumn, compareColumn);
    }

    @Override
    public IMapping addNewCompareColumnsMapping(IColumn sourceColumn, IColumn compareColumn) {
        IMapping compareColumnsMap = this.createNewCompareColumnsMapping();
        if (sourceColumn != null) {
            compareColumnsMap.addSource(sourceColumn);
        }
        if (compareColumn != null) {
            compareColumnsMap.addTarget(compareColumn);
        }
        this.m_lCompareColumns.add(compareColumnsMap);
        return compareColumnsMap;
    }

    @Override
    public void removeCompareColumnsMapping(IMapping map) {
        if (this.m_lCompareColumns.contains(map)) {
            this.m_lCompareColumns.remove(map);
        }
    }

    @Override
    public void moveCompareColumnsMapping(IMapping map, int iTo) {
        this.m_lCompareColumns.move(map, iTo);
    }

    @Override
    public IPhysicalTable getSourceTable() {
        return this.m_oSourceTable;
    }

    @Override
    public void setSourceTable(IPhysicalTable source) {
        if (this.m_oSourceTable == source) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (source == null) {
                this.m_lCompareColumns.clear();
                this.m_lMatchKey.clear();
            }
            this.m_oSourceTable = source;
        }
        finally {
            this.endCompoundUndoable();
        }
        this.fireModelChangedEvent("CompareTables:SourceTableChanged", null);
    }

    @Override
    public IPhysicalTable getComparisonTable() {
        return this.m_oComparisonTable;
    }

    @Override
    public void setComparisonTable(IPhysicalTable comparisonTable) {
        this.setComparisonTable(comparisonTable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComparisonTable(IPhysicalTable comparisonTable, boolean isReplace) {
        if (this.m_oComparisonTable == comparisonTable) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.m_oComparisonTable != null && !isReplace) {
                IMapping map;
                int i;
                for (i = 0; i < this.m_lMatchKey.size(); ++i) {
                    map = (IMapping)this.m_lMatchKey.get(i);
                    map.clearTargets();
                }
                for (i = 0; i < this.m_lCompareColumns.size(); ++i) {
                    map = (IMapping)this.m_lCompareColumns.get(i);
                    map.clearTargets();
                }
                if (this.m_oDigestColumn != null) {
                    this.setDigestColumn(null);
                }
            }
            this.m_oComparisonTable = comparisonTable;
        }
        finally {
            this.endCompoundUndoable();
        }
        this.fireModelChangedEvent("CompareTables:ComparisonTableChanged", null);
    }

    @Override
    public IPhysicalTable getChangedRcdsTable() {
        return this.m_oChangedRcdsTable;
    }

    @Override
    public void setChangedRcdsTable(IPhysicalTable changedRcdsTable) {
        if (this.m_oChangedRcdsTable == changedRcdsTable) {
            return;
        }
        this.m_oChangedRcdsTable = changedRcdsTable;
        this.fireModelChangedEvent("CompareTables:TargetChangedRecordsTableChanged", null);
    }

    @Override
    public IPhysicalTable getNewRcdsTable() {
        return this.m_oNewRcdsTable;
    }

    @Override
    public void setNewRcdsTable(IPhysicalTable newRcdsTable) {
        if (this.m_oNewRcdsTable == newRcdsTable) {
            return;
        }
        this.m_oNewRcdsTable = newRcdsTable;
        this.fireModelChangedEvent("CompareTables:TargetNewRecordsTableChanged", null);
    }

    @Override
    public IPhysicalTable getUnchangedRcdsTable() {
        return this.m_oUnchangedRcdsTable;
    }

    @Override
    public void setUnchangedRcdsTable(IPhysicalTable unchangedRcdsTable) {
        if (this.m_oUnchangedRcdsTable == unchangedRcdsTable) {
            return;
        }
        this.m_oUnchangedRcdsTable = unchangedRcdsTable;
        this.fireModelChangedEvent("CompareTables:TargetUnchangedRecordsTableChanged", null);
    }

    @Override
    public IPhysicalTable getMissingRcdsTable() {
        return this.m_oMissingRcdsTable;
    }

    @Override
    public void setMissingRcdsTable(IPhysicalTable missingRcdsTable) {
        if (this.m_oMissingRcdsTable == missingRcdsTable) {
            return;
        }
        this.m_oMissingRcdsTable = missingRcdsTable;
        this.fireModelChangedEvent("CompareTables:TargetMissingRecordsTableChanged", null);
    }

    @Override
    public boolean useDataHashStep() {
        return this.m_bUseDataHashStep;
    }

    @Override
    public void setUseDataHashStep(boolean bUseDataHashStep) {
        if (this.m_bUseDataHashStep == bUseDataHashStep) {
            return;
        }
        this.m_bUseDataHashStep = bUseDataHashStep;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseDataHashStepUndoable(this.m_bUseDataHashStep));
        }
        this.fireModelChangedEvent("CompareTables:DataHashPropertyChanged", null);
    }

    @Override
    public int getHashInternalTableSize() {
        return this.m_iHashInternalTableSize;
    }

    @Override
    public void setHashInternalTableSize(int size) {
        if (this.m_iHashInternalTableSize == size) {
            return;
        }
        if (size < 0 || size > 20) {
            throw new IllegalArgumentException("The hash internal table size is outside the required range");
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetHashInternalTableSizeUndoable(this.m_iHashInternalTableSize, size));
        }
        this.m_iHashInternalTableSize = size;
        this.fireModelChangedEvent("CompareTablesTransformModel:HashExpChanged", null);
    }

    @Override
    public IDataTransform getOwner() {
        return this.m_oOwner;
    }

    @Override
    public void setOwner(IDataTransform owner) {
        if (this.m_oOwner == owner) {
            return;
        }
        this.m_oOwner = owner;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_lMatchKey.isChanged() || this.m_lCompareColumns.isChanged();
    }

    @Override
    public boolean isComplete() {
        boolean bMissingDigest = true;
        if (this.m_bCompareToDigest && this.m_oDigestColumn == null) {
            bMissingDigest = false;
        }
        boolean bAtLeastOneMatchKey = true;
        if (this.m_lMatchKey.size() == 0) {
            bAtLeastOneMatchKey = false;
        }
        boolean bAtLeastOneCompareColumns = true;
        if (!this.m_bCompareToDigest && this.m_lCompareColumns.size() == 0) {
            bAtLeastOneCompareColumns = false;
        }
        return super.isComplete() && this.m_oSourceTable != null && this.m_oComparisonTable != null && bMissingDigest && bAtLeastOneMatchKey && bAtLeastOneCompareColumns && this.isKeyMappingsComplete() && this.isCompareColumnsComplete();
    }

    private boolean isKeyMappingsComplete() {
        for (int i = 0; i < this.m_lMatchKey.size(); ++i) {
            IMapping keyMap = (IMapping)this.m_lMatchKey.get(i);
            if (keyMap.getSourceCount() == 1 && keyMap.getTargetCount() == 1) continue;
            return false;
        }
        return true;
    }

    private boolean isCompareColumnsComplete() {
        if (!this.compareToDigestColumn()) {
            for (int i = 0; i < this.m_lCompareColumns.size(); ++i) {
                IMapping map = (IMapping)this.m_lCompareColumns.get(i);
                if (map.getSourceCount() == 1 && map.getTargetCount() == 1) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasWarnings() {
        if (super.hasWarnings()) {
            return true;
        }
        String warning = this.getWarning();
        return warning != null && warning.length() > 0;
    }

    private String getWarning() {
        for (int i = 0; i < this.m_lMatchKey.size(); ++i) {
            IMapping map = (IMapping)this.m_lMatchKey.get(i);
            if (map.getSourceCount() < 1 || map.getTargetCount() < 1 || map.getSourceCount() != 1 && map.getTargetCount() != 1) continue;
            IColumn sourceColumn = map.getSources()[0];
            IColumn targetColumn = map.getTargets()[0];
            if (sourceColumn.getType() != 0) continue;
            if (targetColumn.getType() != 0) continue;
            if (sourceColumn.getLength() > targetColumn.getLength()) {
                return MessageFormat.format(RB.getStringResource("CompareTables.Warnings.LargerSourceColumnLength.msg.txt"), sourceColumn.getName(), targetColumn.getName());
            }
            if (sourceColumn.getLength() >= targetColumn.getLength()) continue;
            return MessageFormat.format(RB.getStringResource("CompareTables.Warnings.LargerCompareColumnLength.msg.txt"), sourceColumn.getName(), targetColumn.getName());
        }
        return null;
    }

    @Override
    public List getWarnings() {
        List warnings = super.getWarnings();
        String warning = this.getWarning();
        if (warning != null && warning.length() > 0) {
            warnings.add(warning);
        }
        return warnings;
    }

    private boolean isMissingRcdsTableUpdate() {
        if (this.m_oMissingRcdsTable == null) {
            return false;
        }
        return this.m_oMissingRcdsTable.getColumnCount() > this.m_lMatchKey.size();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.m_oComparisonTable == null) {
            lReasons.add(RB.getStringResource("CompareTables.ReasonIncomplete.NoComparisonTable.msg.txt"));
        }
        if (this.m_lMatchKey.size() == 0) {
            lReasons.add(RB.getStringResource("CompareTables.ReasonIncomplete.NoNaturalKeys.msg.txt"));
        }
        if (!this.isKeyMappingsComplete()) {
            lReasons.add(RB.getStringResource("CompareTables.ReasonIncomplete.IncompletMatchKeyMap.msg.txt"));
        }
        if (!this.m_bCompareToDigest && this.m_lCompareColumns.size() == 0) {
            lReasons.add(RB.getStringResource("CompareTables.ReasonIncomplete.NoCompareColumns.msg.txt"));
        }
        if (!this.isCompareColumnsComplete()) {
            lReasons.add(RB.getStringResource("CompareTables.ReasonIncomplete.IncompleteCompareColumnsMap.msg.txt"));
        }
        if (this.m_bCompareToDigest && this.m_oDigestColumn == null) {
            lReasons.add(RB.getStringResource("CompareTables.ReasonIncomplete.NoDigestColumn.msg.txt"));
        }
        return lReasons;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        String name;
        IMapping map;
        int i;
        if (!this.isChanged()) {
            return;
        }
        if (this.m_oOwner == null) {
            return;
        }
        if (this.m_oSourceTable != null) {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, SOURCE_TABLE, new IPhysicalTable[]{this.m_oSourceTable});
        } else {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, SOURCE_TABLE, new IPhysicalTable[0]);
        }
        if (this.m_oComparisonTable != null) {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, COMPARISON_TABLE, new IPhysicalTable[]{this.m_oComparisonTable});
        } else {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, COMPARISON_TABLE, new IPhysicalTable[0]);
        }
        if (this.m_oChangedRcdsTable != null) {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, CHANGED_RCDS_TABLE, new IPhysicalTable[]{this.m_oChangedRcdsTable});
        } else {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, CHANGED_RCDS_TABLE, new IPhysicalTable[0]);
        }
        if (this.m_oNewRcdsTable != null) {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, NEW_RCDS_TABLE, new IPhysicalTable[]{this.m_oNewRcdsTable});
        } else {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, NEW_RCDS_TABLE, new IPhysicalTable[0]);
        }
        if (this.m_oUnchangedRcdsTable != null) {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, UNCHANGED_RCDS_TABLE, new IPhysicalTable[]{this.m_oUnchangedRcdsTable});
        } else {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, UNCHANGED_RCDS_TABLE, new IPhysicalTable[0]);
        }
        if (this.m_oMissingRcdsTable != null) {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, MISSING_RCDS_TABLE, new IPhysicalTable[]{this.m_oMissingRcdsTable});
        } else {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, MISSING_RCDS_TABLE, new IPhysicalTable[0]);
        }
        for (i = 0; i < this.m_lMatchKey.size(); ++i) {
            map = (IMapping)this.m_lMatchKey.get(i);
            name = "";
            if (map.getSourceCount() == 1) {
                name = map.getSources()[0].getName();
            }
            map.setName("MatchKeyMap:" + name);
            map.saveToOMR(omr);
        }
        ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, MATCH_KEY_MAPS, this.getMatchKeyMappings());
        for (i = 0; i < this.m_lCompareColumns.size(); ++i) {
            map = (IMapping)this.m_lCompareColumns.get(i);
            name = "";
            if (map.getSourceCount() == 1) {
                name = map.getSources()[0].getName();
            }
            map.setName("CompareMap:" + name);
            map.saveToOMR(omr);
        }
        ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, COMPARE_COLUMNS_MAPS, this.getCompareColumnsMappings());
        if (this.m_oDigestColumn != null) {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, COMPARE_DIGEST_COLUMN, new IColumn[]{this.m_oDigestColumn});
        } else {
            ((AbstractPersistableObject)((Object)this.m_oOwner)).saveCustomListToOMR(omr, COMPARE_DIGEST_COLUMN, new IColumn[0]);
        }
        ((AbstractPersistableObject)((Object)this.m_oOwner)).saveBooleanOptionToOMR(omr, "DataHash", this.useDataHashStep());
        ((AbstractPersistableObject)((Object)this.m_oOwner)).saveIntOptionToOMR(omr, "HashExp", this.getHashInternalTableSize());
        ((AbstractPersistableObject)((Object)this.m_oOwner)).saveBooleanOptionToOMR(omr, "CompareDigest", this.compareToDigestColumn());
        ((AbstractPersistableObject)((Object)this.m_oOwner)).saveStringOptionToOMR(omr, "ChangeDigestVersion", this.getChangeDigestVersion());
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] aMissingRcdsTable;
        IPersistableObject[] aUnchangedRcdsTable;
        IPersistableObject[] aNewRcdsTable;
        IPersistableObject[] aChangedRcdsTable;
        IPersistableObject[] aComparisonTable;
        if (this.m_oOwner == null) {
            return;
        }
        IPersistableObject[] aSourceTable = ((AbstractPersistableObject)((Object)this.m_oOwner)).loadCustomListFromOMR(omr, SOURCE_TABLE);
        if (aSourceTable.length > 0) {
            this.setSourceTable((IPhysicalTable)aSourceTable[0]);
        }
        if ((aComparisonTable = ((AbstractPersistableObject)((Object)this.m_oOwner)).loadCustomListFromOMR(omr, COMPARISON_TABLE)).length > 0) {
            this.setComparisonTable((IPhysicalTable)aComparisonTable[0]);
        }
        if ((aChangedRcdsTable = ((AbstractPersistableObject)((Object)this.m_oOwner)).loadCustomListFromOMR(omr, CHANGED_RCDS_TABLE)).length > 0) {
            this.setChangedRcdsTable((IPhysicalTable)aChangedRcdsTable[0]);
        }
        if ((aNewRcdsTable = ((AbstractPersistableObject)((Object)this.m_oOwner)).loadCustomListFromOMR(omr, NEW_RCDS_TABLE)).length > 0) {
            this.setNewRcdsTable((IPhysicalTable)aNewRcdsTable[0]);
        }
        if ((aUnchangedRcdsTable = ((AbstractPersistableObject)((Object)this.m_oOwner)).loadCustomListFromOMR(omr, UNCHANGED_RCDS_TABLE)).length > 0) {
            this.setUnchangedRcdsTable((IPhysicalTable)aUnchangedRcdsTable[0]);
        }
        if ((aMissingRcdsTable = ((AbstractPersistableObject)((Object)this.m_oOwner)).loadCustomListFromOMR(omr, MISSING_RCDS_TABLE)).length > 0) {
            this.setMissingRcdsTable((IPhysicalTable)aMissingRcdsTable[0]);
        }
        this.m_lMatchKey.clear();
        IPersistableObject[] aMatchKeyMaps = ((AbstractPersistableObject)((Object)this.m_oOwner)).loadCustomListFromOMR(omr, MATCH_KEY_MAPS);
        for (int i = 0; i < aMatchKeyMaps.length; ++i) {
            this.m_lMatchKey.add((IMapping)aMatchKeyMaps[i]);
        }
        this.m_lCompareColumns.clear();
        IPersistableObject[] aCompareColumnsMaps = ((AbstractPersistableObject)((Object)this.m_oOwner)).loadCustomListFromOMR(omr, COMPARE_COLUMNS_MAPS);
        for (int i = 0; i < aCompareColumnsMaps.length; ++i) {
            this.m_lCompareColumns.add((IMapping)aCompareColumnsMaps[i]);
        }
        IPersistableObject[] aDigestColumns = ((AbstractPersistableObject)((Object)this.m_oOwner)).loadCustomListFromOMR(omr, COMPARE_DIGEST_COLUMN);
        if (aDigestColumns.length > 0) {
            this.setDigestColumn((IColumn)aDigestColumns[0]);
        }
        this.setUseDataHashStep(((AbstractPersistableObject)((Object)this.m_oOwner)).loadBooleanOptionFromOMR(omr, "DataHash", true));
        this.setHashInternalTableSize(((AbstractPersistableObject)((Object)this.m_oOwner)).loadIntOptionFromOMR(omr, "HashExp", 10));
        this.setCompareToDigestColumn(((AbstractPersistableObject)((Object)this.m_oOwner)).loadBooleanOptionFromOMR(omr, "CompareDigest", false));
        this.setChangeDigestVersion(((AbstractPersistableObject)((Object)this.m_oOwner)).loadStringOptionFromOMR(omr, "HashExp", DEFAULT_CHANGE_DIGEST_VERSION));
        this.setChanged(false);
    }

    @Override
    public void delete() {
        this.m_lMatchKey.delete();
        this.m_lCompareColumns.delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        this.m_lMatchKey.deleteFromOMR(omr);
        this.m_lCompareColumns.deleteFromOMR(omr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IPhysicalTable target;
        int i;
        IPhysicalTable sourceTable = this.getSourceTable();
        AbstractDataTransform transform = (AbstractDataTransform)this.getOwner();
        int numTargets = transform.getDataTargetsCount();
        List lDataTargets = transform.getDataTargetList();
        IPhysicalTable[] targetTables = new IPhysicalTable[numTargets];
        IPhysicalTable[] tempTargetTables = new IPhysicalTable[numTargets];
        ArrayList<IPhysicalTable> lDeleteTempTargetTables = new ArrayList<IPhysicalTable>();
        boolean[] targetMapNeeded = new boolean[numTargets];
        m_hTargetTableNames = new HashMap();
        m_hTargetTablesTemp = new HashMap();
        String sTargetTableType = "";
        String sTargetTableName = "";
        boolean bTargetTableTemp = false;
        boolean bMissingRcdsTableUpdate = this.isMissingRcdsTableUpdate();
        for (i = 0; i < numTargets; ++i) {
            targetTables[i] = target = (IPhysicalTable)lDataTargets.get(i);
            if (target.equals(this.m_oChangedRcdsTable)) {
                sTargetTableType = CHANGED_RCDS_TABLE;
            } else if (target.equals(this.m_oUnchangedRcdsTable)) {
                sTargetTableType = UNCHANGED_RCDS_TABLE;
            } else if (target.equals(this.m_oNewRcdsTable)) {
                sTargetTableType = NEW_RCDS_TABLE;
            } else if (target.equals(this.m_oMissingRcdsTable)) {
                sTargetTableType = MISSING_RCDS_TABLE;
            }
            if (target.equals(this.m_oMissingRcdsTable)) {
                targetMapNeeded[i] = false;
            } else if (!target.equals(this.m_oMissingRcdsTable)) {
                targetMapNeeded[i] = transform.isMappingNeeded(codeSegment.isQuoting(), sourceTable, target);
            }
            if (targetMapNeeded[i] || target.equals(this.m_oMissingRcdsTable) && bMissingRcdsTableUpdate) {
                boolean bUndoSupported = this.getModel().isUndoSupported();
                this.getModel().setUndoSupported(false);
                try {
                    bTargetTableTemp = true;
                    tempTargetTables[i] = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
                    tempTargetTables[i].setSASTableName(codeSegment.getUniqueWorkTableName());
                    this.getModel().removeObject(tempTargetTables[i]);
                    tempTargetTables[i].dispose();
                    lDeleteTempTargetTables.add(tempTargetTables[i]);
                }
                finally {
                    this.getModel().setUndoSupported(bUndoSupported);
                }
            } else {
                tempTargetTables[i] = target;
            }
            sTargetTableName = tempTargetTables[i].getFullNameQuotedAsNeeded(codeSegment);
            m_hTargetTableNames.put(sTargetTableType, sTargetTableName);
            m_hTargetTablesTemp.put(sTargetTableType, bTargetTableTemp);
        }
        codeSegment.addSectionComment("Delete pre-existing tables");
        transform.genTableDelete(codeSegment, Arrays.asList(targetTables));
        transform.genTableDelete(codeSegment, lDeleteTempTargetTables);
        codeSegment.genTableDelete(WORK_COMPARE);
        if (this.useDataHashStep() && this.m_oMissingRcdsTable != null) {
            codeSegment.genTableDelete(WORK_MISSING_RECORDS);
        }
        this.generateCompareDigestTable(codeSegment, this.compareToDigestColumn());
        if (this.useDataHashStep()) {
            this.generateHashLookup(codeSegment, m_hTargetTableNames, m_hTargetTablesTemp);
        } else if (!this.useDataHashStep()) {
            this.generateMergeLookup(codeSegment, m_hTargetTableNames, m_hTargetTablesTemp);
        }
        this.generateUpdateMissingRcdsTable(codeSegment, bMissingRcdsTableUpdate, m_hTargetTableNames);
        codeSegment.genTableDelete(WORK_COMPARE);
        for (i = 0; i < targetTables.length; ++i) {
            target = (IPhysicalTable)lDataTargets.get(i);
            boolean isMapGenerated = targetMapNeeded[i];
            if (!isMapGenerated) continue;
            String sTargetOptions = "";
            ITransformTableOptions oTableOptions = transform.getTableOptionObject(target, false);
            if (oTableOptions != null) {
                sTargetOptions = oTableOptions.getTableOptions(codeSegment.getCurrentServer());
            }
            transform.getOrdinaryMappingCode(codeSegment, sourceTable, target, target.getFullNameQuotedAsNeeded(codeSegment), tempTargetTables[i].getFullNameQuotedAsNeeded(codeSegment), "", sTargetOptions, false, true, true);
            tempTargetTables[i].genTableDelete(codeSegment);
            tempTargetTables[i].delete();
        }
        return codeSegment;
    }

    private ICodeSegment generateHashLookup(ICodeSegment codeSegment, Map targetTableNames, Map targetTablesTemp) throws RemoteException, MdException, BadLibraryDefinitionException {
        String sMissingRecordsTableOptions;
        ITransformTableOptions missingRecordsTableOptions;
        String sDefineKeyList;
        String sDefineKeyListTemp;
        IDataTransform transform = this.getOwner();
        String sChangedRcdsTable = "";
        boolean bChangedRcdsTableTemp = false;
        String sNewRcdsTable = "";
        boolean bNewRcdsTableTemp = false;
        String sUnchangedRcdsTable = "";
        boolean bUnchangedRcdsTableTemp = false;
        String sMissingRcdsTable = "";
        boolean bMissingRcdsTableTemp = false;
        if (this.m_oChangedRcdsTable != null) {
            sChangedRcdsTable = (String)targetTableNames.get(CHANGED_RCDS_TABLE);
            bChangedRcdsTableTemp = (Boolean)targetTablesTemp.get(CHANGED_RCDS_TABLE);
        }
        if (this.m_oNewRcdsTable != null) {
            sNewRcdsTable = (String)targetTableNames.get(NEW_RCDS_TABLE);
            bNewRcdsTableTemp = (Boolean)targetTablesTemp.get(NEW_RCDS_TABLE);
        }
        if (this.m_oUnchangedRcdsTable != null) {
            sUnchangedRcdsTable = (String)targetTableNames.get(UNCHANGED_RCDS_TABLE);
            bUnchangedRcdsTableTemp = (Boolean)targetTablesTemp.get(UNCHANGED_RCDS_TABLE);
        }
        if (this.m_oMissingRcdsTable != null) {
            sMissingRcdsTable = (String)targetTableNames.get(MISSING_RCDS_TABLE);
            bMissingRcdsTableTemp = (Boolean)targetTablesTemp.get(MISSING_RCDS_TABLE);
        }
        if ((sDefineKeyListTemp = codeSegment.makeColumnList(this.getColumnList(this.getMatchKeyMappings(), true), " ", true, ",").trim()).endsWith("\"n")) {
            String firstTempList = sDefineKeyListTemp.substring(0, sDefineKeyListTemp.length() - 1);
            sDefineKeyList = firstTempList.replace("\"n,", "\",");
        } else {
            sDefineKeyList = sDefineKeyListTemp;
        }
        String sDefineDataList = sDefineKeyList + ", " + '\"' + COMPARE_DIGEST_NAME + '\"';
        String sHashExp = Integer.toString(this.getHashInternalTableSize());
        codeSegment.addCommentLine("source/compare lookup: hash lookup method").addSourceCode("data ");
        if (this.m_oChangedRcdsTable != null) {
            codeSegment.newLine().space(5).addSourceCode(sChangedRcdsTable);
            if (!bChangedRcdsTableTemp) {
                codeSegment.addSourceCode(transform.getTableOptionObject(this.m_oChangedRcdsTable, false).getTableOptions(true, null, codeSegment.getCurrentServer()));
            }
        }
        if (this.m_oNewRcdsTable != null) {
            codeSegment.newLine().space(5).addSourceCode(sNewRcdsTable);
            if (!bNewRcdsTableTemp) {
                codeSegment.addSourceCode(transform.getTableOptionObject(this.m_oNewRcdsTable, false).getTableOptions(true, null, codeSegment.getCurrentServer()));
            }
        }
        if (this.m_oUnchangedRcdsTable != null) {
            codeSegment.newLine().space(5).addSourceCode(sUnchangedRcdsTable);
            if (!bUnchangedRcdsTableTemp) {
                codeSegment.addSourceCode(transform.getTableOptionObject(this.m_oUnchangedRcdsTable, false).getTableOptions(true, null, codeSegment.getCurrentServer()));
            }
        }
        codeSegment.addSourceCode(";").newLine();
        codeSegment.newLine().indent().addSourceCode("length source_digest $ 32;").newLine(2);
        if (this.m_oMissingRcdsTable == null) {
            codeSegment.addSourceCode("drop source_digest compare_digest;");
        } else if (this.m_oMissingRcdsTable != null) {
            codeSegment.addSourceCode("drop source_digest compare_digest rc;");
        }
        codeSegment.newLine(2).addSourceCode("if 0 then").newLine().indent().addSourceCode("set work.etls_compare_digest;").newLine(2).unIndent().addSourceCode("if _N_ eq 1 then").newLine().addSourceCode("do;").newLine().indent().addSourceCode("declare hash hct(dataset: 'work.etls_compare_digest', hashexp: " + sHashExp + ");").newLine().indent(4).space().addSourceCode("hct.defineKey(" + sDefineKeyList + ");").newLine().space().addSourceCode("hct.defineData(" + sDefineDataList + ");").newLine().space().addSourceCode("hct.defineDone();").newLine().unIndent(5).addSourceCode("end;").newLine(2).addSourceCode("set ").addSourceCode(this.m_oSourceTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(transform.getTableOptionObject(this.m_oSourceTable, true).getTableOptions(true, null, null, codeSegment.getCurrentServer())).addSourceCode(" end = eof;").newLine(2);
        this.generateDigest(codeSegment, true);
        codeSegment.newLine().addCommentLine("source/compare match").addSourceCode("if hct.find() eq 0 then").newLine().addSourceCode("do;").newLine().indent().addCommentLine("source/compare match: Unchanged records").addSourceCode("if source_digest eq compare_digest then").newLine().indent();
        if (this.m_oUnchangedRcdsTable != null) {
            codeSegment.addSourceCode("output " + sUnchangedRcdsTable + ";");
        } else {
            codeSegment.addSourceCode("/* - TARGET TABLE NOT REQUESTED - */;");
        }
        codeSegment.newLine(2).unIndent().addCommentLine("source/compare match: Changed records").addSourceCode("else if source_digest ne compare_digest then").newLine().indent();
        if (this.m_oChangedRcdsTable != null) {
            codeSegment.addSourceCode("output " + sChangedRcdsTable + ";");
        } else {
            codeSegment.addSourceCode("/* - TARGET TABLE NOT REQUESTED - */;");
        }
        codeSegment.newLine(2).unIndent().addCommentLine("remove found key + data").addSourceCode("hct.remove();").newLine().unIndent().addSourceCode("end;").newLine().addCommentLine("source table: New records").addSourceCode("else if hct.find() ne 0 then").newLine().indent();
        if (this.m_oNewRcdsTable != null) {
            codeSegment.addSourceCode("output " + sNewRcdsTable + ";");
        } else {
            codeSegment.addSourceCode("/* - TARGET TABLE NOT REQUESTED - */;");
        }
        codeSegment.unIndent();
        if (this.m_oMissingRcdsTable != null) {
            String sMissingRecordsTableOptions2;
            ITransformTableOptions missingRecordsTableOptions2;
            StringBuffer sbRenameList = new StringBuffer();
            sbRenameList.append("rename = (");
            Integer iRenameCount = 0;
            Boolean bRenameRequired = false;
            IMapping[] aMatchKeyMappings = this.getMatchKeyMappings();
            for (int i = 0; i < aMatchKeyMappings.length; ++i) {
                IColumn sourceMatchKey = aMatchKeyMappings[i].getSources()[0];
                IColumn compareMatchKey = aMatchKeyMappings[i].getTargets()[0];
                if (sourceMatchKey.getColumnName(false).equalsIgnoreCase(compareMatchKey.getColumnName(false))) continue;
                String sSourceMatchKey = sourceMatchKey.getColumnName(codeSegment.isQuoting());
                String sCompareMatchKey = compareMatchKey.getColumnName(codeSegment.isQuoting());
                if ((iRenameCount = Integer.valueOf(iRenameCount + 1)) == 1) {
                    bRenameRequired = true;
                    sbRenameList.append(sSourceMatchKey + " = " + sCompareMatchKey);
                    continue;
                }
                if (iRenameCount <= 1) continue;
                sbRenameList.append(" " + sSourceMatchKey + " = " + sCompareMatchKey);
            }
            sbRenameList.append(")");
            StringBuffer sbMissingRecordsTableOptions = new StringBuffer();
            sbMissingRecordsTableOptions.append("(drop = compare_digest");
            if (bRenameRequired.booleanValue()) {
                sbMissingRecordsTableOptions.append(" " + sbRenameList.toString().trim());
            }
            if (!bMissingRcdsTableTemp && (missingRecordsTableOptions2 = transform.getTableOptionObject(this.m_oMissingRcdsTable, false)) != null && (sMissingRecordsTableOptions2 = missingRecordsTableOptions2.getTableOptions(codeSegment.getCurrentServer())) != null && sMissingRecordsTableOptions2.length() > 0) {
                sbMissingRecordsTableOptions.append(" " + sMissingRecordsTableOptions2);
            }
            sbMissingRecordsTableOptions.append(")");
            codeSegment.newLine(2).addCommentLine("Missing records").addSourceCode("if eof then").newLine().indent().addSourceCode("rc = hct.output(dataset: '" + sMissingRcdsTable + sbMissingRecordsTableOptions.toString().trim() + "');").newLine(2).unIndent(2).addSourceCode("run;").newLine().newLine();
        } else if (this.m_oMissingRcdsTable == null) {
            codeSegment.unIndent(2).newLine(2).addSourceCode("run;").newLine().genRCSetCall("&syscc").newLine();
        }
        StringBuffer sbMissingRecordsTableOptions = new StringBuffer();
        sbMissingRecordsTableOptions.append("(");
        if (!bMissingRcdsTableTemp && (missingRecordsTableOptions = transform.getTableOptionObject(this.m_oMissingRcdsTable, false)) != null && (sMissingRecordsTableOptions = missingRecordsTableOptions.getTableOptions(codeSegment.getCurrentServer())) != null && sMissingRecordsTableOptions.length() > 0) {
            sbMissingRecordsTableOptions.append(" " + sMissingRecordsTableOptions);
        }
        sbMissingRecordsTableOptions.append(")");
        if (sMissingRcdsTable != null && !sMissingRcdsTable.isEmpty()) {
            codeSegment.newLine().addCommentLine("Macro to create missings table from compare").addSourceCode("%macro checkds;").newLine().indent().addSourceCode("%if %sysfunc(exist(" + sMissingRcdsTable + ")) %then %do;").newLine().addCommentLine("Do nothing if table exists").addSourceCode("%end;").newLine(1).addSourceCode("%else %do;").newLine().addCommentLine("If missings table does not exist, create it with all of the unmatched records from compare table.").newLine().indent().addSourceCode("data " + sMissingRcdsTable + sbMissingRecordsTableOptions.toString().trim() + ";").newLine().indent().addSourceCode("set " + this.m_oComparisonTable.getFullNameQuotedAsNeeded(codeSegment, false) + ";").newLine().unIndent().addSourceCode("run;").newLine().unIndent().addSourceCode("%end;").newLine().addSourceCode("%mend checkds;").newLine().addSourceCode("%checkds;").newLine().newLine();
        }
        return codeSegment;
    }

    private ICodeSegment generateMergeLookup(ICodeSegment codeSegment, Map targetTableNames, Map targetTablesTemp) throws RemoteException, MdException, BadLibraryDefinitionException {
        IDataTransform transform = this.getOwner();
        String sChangedRcdsTable = "";
        boolean bChangedRcdsTableTemp = false;
        String sNewRcdsTable = "";
        boolean bNewRcdsTableTemp = false;
        String sUnchangedRcdsTable = "";
        boolean bUnchangedRcdsTableTemp = false;
        String sMissingRcdsTable = "";
        boolean bMissingRcdsTableTemp = false;
        if (this.m_oChangedRcdsTable != null) {
            sChangedRcdsTable = (String)targetTableNames.get(CHANGED_RCDS_TABLE);
            bChangedRcdsTableTemp = (Boolean)targetTablesTemp.get(CHANGED_RCDS_TABLE);
        }
        if (this.m_oNewRcdsTable != null) {
            sNewRcdsTable = (String)targetTableNames.get(NEW_RCDS_TABLE);
            bNewRcdsTableTemp = (Boolean)targetTablesTemp.get(NEW_RCDS_TABLE);
        }
        if (this.m_oUnchangedRcdsTable != null) {
            sUnchangedRcdsTable = (String)targetTableNames.get(UNCHANGED_RCDS_TABLE);
            bUnchangedRcdsTableTemp = (Boolean)targetTablesTemp.get(UNCHANGED_RCDS_TABLE);
        }
        if (this.m_oMissingRcdsTable != null) {
            sMissingRcdsTable = (String)targetTableNames.get(MISSING_RCDS_TABLE);
            bMissingRcdsTableTemp = (Boolean)targetTablesTemp.get(MISSING_RCDS_TABLE);
        }
        String sByCols = codeSegment.makeColumnList(this.getColumnList(this.getMatchKeyMappings(), true), " ", false, " ").trim();
        String sAdditionalTableOptions = "";
        codeSegment.addCommentLine("source/compare lookup: merge lookup method").addSourceCode("data ");
        if (this.m_oChangedRcdsTable != null) {
            codeSegment.newLine().space(5).addSourceCode(sChangedRcdsTable);
            if (!bChangedRcdsTableTemp) {
                codeSegment.addSourceCode(transform.getTableOptionObject(this.m_oChangedRcdsTable, false).getTableOptions(true, null, codeSegment.getCurrentServer()));
            }
        }
        if (this.m_oNewRcdsTable != null) {
            codeSegment.newLine().space(5).addSourceCode(sNewRcdsTable);
            if (!bNewRcdsTableTemp) {
                codeSegment.addSourceCode(transform.getTableOptionObject(this.m_oNewRcdsTable, false).getTableOptions(true, null, codeSegment.getCurrentServer()));
            }
        }
        if (this.m_oUnchangedRcdsTable != null) {
            codeSegment.newLine().space(5).addSourceCode(sUnchangedRcdsTable);
            if (!bUnchangedRcdsTableTemp) {
                codeSegment.addSourceCode(transform.getTableOptionObject(this.m_oUnchangedRcdsTable, false).getTableOptions(true, null, codeSegment.getCurrentServer()));
            }
        }
        if (this.m_oMissingRcdsTable != null) {
            StringBuffer sbRenameList = new StringBuffer();
            sbRenameList.append("rename = (");
            Integer iRenameCount = 0;
            Boolean bRenameRequired = false;
            IMapping[] aMatchKeyMappings = this.getMatchKeyMappings();
            for (int i = 0; i < aMatchKeyMappings.length; ++i) {
                IColumn sourceMatchKey = aMatchKeyMappings[i].getSources()[0];
                IColumn compareMatchKey = aMatchKeyMappings[i].getTargets()[0];
                if (sourceMatchKey.getColumnName(false).equalsIgnoreCase(compareMatchKey.getColumnName(false))) continue;
                String sSourceMatchKey = sourceMatchKey.getColumnName(codeSegment.isQuoting());
                String sCompareMatchKey = compareMatchKey.getColumnName(codeSegment.isQuoting());
                if ((iRenameCount = Integer.valueOf(iRenameCount + 1)) == 1) {
                    bRenameRequired = true;
                    sbRenameList.append(sSourceMatchKey + " = " + sCompareMatchKey);
                    continue;
                }
                if (iRenameCount <= 1) continue;
                sbRenameList.append(" " + sSourceMatchKey + " = " + sCompareMatchKey);
            }
            sbRenameList.append(")");
            codeSegment.newLine().space(5).addSourceCode(sMissingRcdsTable);
            if (bMissingRcdsTableTemp) {
                if (bRenameRequired.booleanValue()) {
                    codeSegment.addSourceCode("(" + sbRenameList.toString().trim() + " keep = " + sByCols + ")");
                } else if (!bRenameRequired.booleanValue()) {
                    codeSegment.addSourceCode("(keep = " + sByCols + ")");
                }
            } else if (!bMissingRcdsTableTemp) {
                if (bRenameRequired.booleanValue()) {
                    sAdditionalTableOptions = sbRenameList.toString().trim() + " keep = " + sByCols;
                } else if (!bRenameRequired.booleanValue()) {
                    sAdditionalTableOptions = "keep = " + sByCols;
                }
                codeSegment.addSourceCode(transform.getTableOptionObject(this.m_oMissingRcdsTable, false).getTableOptions(true, null, sAdditionalTableOptions, codeSegment.getCurrentServer()));
            }
        }
        sAdditionalTableOptions = "in = inSOURCE";
        codeSegment.addSourceCode(";").newLine();
        codeSegment.newLine().indent().addSourceCode("length source_digest $ 32;").newLine(2).addSourceCode("drop source_digest compare_digest;").newLine(2).addCommentLine("merge source and compare tables").addSourceCode("merge ").addSourceCode(this.m_oSourceTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(transform.getTableOptionObject(this.m_oSourceTable, true).getTableOptions(true, null, sAdditionalTableOptions, codeSegment.getCurrentServer())).newLine().indent(2).addSourceCode("work.etls_compare_digest(in = inCOMPARE);").newLine().unIndent(2).addSourceCode("by " + sByCols + ";").newLine(2);
        this.generateDigest(codeSegment, true);
        codeSegment.newLine().addCommentLine("source/compare match").addSourceCode("if inSOURCE and inCOMPARE then").newLine().addSourceCode("do;").newLine().indent().addCommentLine("source/compare match: no change detected").addSourceCode("if source_digest eq compare_digest then").newLine().indent();
        if (this.m_oUnchangedRcdsTable != null) {
            codeSegment.addSourceCode("output " + sUnchangedRcdsTable + ";");
        } else {
            codeSegment.addSourceCode("/* - TARGET TABLE NOT REQUESTED - */;");
        }
        codeSegment.newLine(2).unIndent().addCommentLine("source/compare match: change detected").addSourceCode("else if source_digest ne compare_digest then").newLine().indent();
        if (this.m_oChangedRcdsTable != null) {
            codeSegment.addSourceCode("output " + sChangedRcdsTable + ";");
        } else {
            codeSegment.addSourceCode("/* - TARGET TABLE NOT REQUESTED - */;");
        }
        codeSegment.newLine(2).unIndent(2).addSourceCode("end;").newLine().addCommentLine("source table: new records").addSourceCode("else if inSOURCE and not inCOMPARE then").newLine().indent();
        if (this.m_oNewRcdsTable != null) {
            codeSegment.addSourceCode("output " + sNewRcdsTable + ";");
        } else {
            codeSegment.addSourceCode("/* - TARGET TABLE NOT REQUESTED - */;");
        }
        codeSegment.newLine(2).unIndent().addCommentLine("compare table: no match").addSourceCode("else if inCOMPARE and not inSOURCE then").newLine().indent();
        if (this.m_oMissingRcdsTable != null) {
            codeSegment.addSourceCode("output " + sMissingRcdsTable + ";");
        } else {
            codeSegment.addSourceCode("/* - TARGET TABLE NOT REQUESTED - */;");
        }
        codeSegment.newLine(2).unIndent(2).addSourceCode("run;").newLine().genRCSetCall("&syscc");
        return codeSegment;
    }

    public ICodeSegment generateDigest(ICodeSegment codeSegment, boolean sourceDigest) throws RemoteException, MdException {
        StringBuffer sbDigest = new StringBuffer();
        if (this.getChangeDigestVersion().equalsIgnoreCase(DEFAULT_CHANGE_DIGEST_VERSION)) {
            if (sourceDigest) {
                sbDigest.append("source_digest = put(md5(catq(' ', ");
                sbDigest.append(codeSegment.makeColumnList(this.getColumnList(this.getCompareColumnsMappings(), true), " ", false, ",").trim());
            } else {
                sbDigest.append("compare_digest = put(md5(catq(' ', ");
                sbDigest.append(codeSegment.makeColumnList(this.getColumnList(this.getCompareColumnsMappings(), false), " ", false, ",").trim());
            }
            sbDigest.append(")), $hex32.);");
            codeSegment.addCommentLine("create digest - version 2.1");
        } else if (this.getChangeDigestVersion().equalsIgnoreCase("V2_2")) {
            if (sourceDigest) {
                sbDigest.append("source_digest = put(md5(catq(' ', ");
            } else {
                sbDigest.append("compare_digest = put(md5(catq(' ', ");
            }
            List lColumns = this.getColumnList(this.getCompareColumnsMappings(), false);
            int maxLineLength = 60;
            for (int i = 0; i < lColumns.size(); ++i) {
                IColumn col = (IColumn)lColumns.get(i);
                String colName = col.getColumnName(codeSegment);
                if (sbDigest.length() + colName.length() + 16 > maxLineLength) {
                    sbDigest.append("\n      ");
                    maxLineLength += 60;
                }
                if (col.getType() == 1) {
                    colName = "put(" + col.getColumnName(codeSegment) + ",ieee8.)";
                }
                if (i + 1 != lColumns.size()) {
                    sbDigest.append(colName + ',');
                    continue;
                }
                sbDigest.append(colName);
                sbDigest.append(")),$hex32.);");
            }
            codeSegment.addCommentLine("create digest - version 2.2");
        }
        codeSegment.addSourceCode(sbDigest).newLine();
        return codeSegment;
    }

    private ICodeSegment generateCompareDigestTable(ICodeSegment codeSegment, boolean compareToDigest) throws RemoteException, MdException, CodegenException, BadLibraryDefinitionException {
        IDataTransform transform = this.getOwner();
        codeSegment.addCommentLine("create compare digest data set");
        String sSourceMatchKeyCols = codeSegment.makeColumnList(this.getColumnList(this.getMatchKeyMappings(), true), " ", false, " ").trim();
        String sCompareMatchKeyCols = codeSegment.makeColumnList(this.getColumnList(this.getMatchKeyMappings(), false), " ", false, " ").trim();
        StringBuffer sbRenameList = new StringBuffer();
        sbRenameList.append("rename = (");
        Integer iRenameCount = 0;
        Boolean bRenameRequired = false;
        IMapping[] aMatchKeyMappings = this.getMatchKeyMappings();
        for (int i = 0; i < aMatchKeyMappings.length; ++i) {
            IColumn sourceMatchKey = aMatchKeyMappings[i].getSources()[0];
            IColumn compareMatchKey = aMatchKeyMappings[i].getTargets()[0];
            if (sourceMatchKey.getColumnName(false).equalsIgnoreCase(compareMatchKey.getColumnName(false))) continue;
            String sSourceMatchKey = sourceMatchKey.getColumnName(codeSegment.isQuoting());
            String sCompareMatchKey = compareMatchKey.getColumnName(codeSegment.isQuoting());
            if ((iRenameCount = Integer.valueOf(iRenameCount + 1)) == 1) {
                bRenameRequired = true;
                sbRenameList.append(sCompareMatchKey + " = " + sSourceMatchKey);
                continue;
            }
            if (iRenameCount <= 1) continue;
            sbRenameList.append(" " + sCompareMatchKey + " = " + sSourceMatchKey);
        }
        sbRenameList.append(")");
        if (compareToDigest) {
            String sKeepList = sCompareMatchKeyCols + " " + this.getDigestColumn().getName().trim();
            String sDigestColumn = this.getDigestColumn().getName().trim();
            String sAdditionalTableOptions = "";
            if (bRenameRequired.booleanValue()) {
                sAdditionalTableOptions = sbRenameList.toString().trim() + " keep = " + sKeepList;
            } else if (!bRenameRequired.booleanValue()) {
                sAdditionalTableOptions = "keep = " + sKeepList;
            }
            codeSegment.addSourceCode("data work.etls_compare_digest;").newLine(2).indent().addSourceCode("set ").addSourceCode(this.m_oComparisonTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(transform.getTableOptionObject(this.m_oComparisonTable, true).getTableOptions(true, null, sAdditionalTableOptions, codeSegment.getCurrentServer()) + ";").newLine(2).addSourceCode("rename " + sDigestColumn + " = " + COMPARE_DIGEST_NAME + ";").newLine();
        } else {
            String sKeepList1 = sSourceMatchKeyCols + " " + COMPARE_DIGEST_NAME;
            String sCompareCols = codeSegment.makeColumnList(this.getColumnList(this.getCompareColumnsMappings(), false), " ", false, " ").trim();
            String sKeepList2 = sCompareMatchKeyCols + " " + sCompareCols;
            String sAdditionalTableOptions = "";
            if (bRenameRequired.booleanValue()) {
                sAdditionalTableOptions = sbRenameList.toString().trim() + " keep = " + sKeepList2;
            } else if (!bRenameRequired.booleanValue()) {
                sAdditionalTableOptions = "keep = " + sKeepList2;
            }
            codeSegment.addSourceCode("data work.etls_compare_digest(keep = " + sKeepList1 + ");").newLine(2).indent().addSourceCode("length compare_digest $ 32;").newLine(2).addSourceCode("set ").addSourceCode(this.m_oComparisonTable.getFullNameQuotedAsNeeded(codeSegment, false)).addSourceCode(transform.getTableOptionObject(this.m_oComparisonTable, true).getTableOptions(true, null, sAdditionalTableOptions, codeSegment.getCurrentServer()) + ";").newLine(2);
            this.generateDigest(codeSegment, false);
        }
        codeSegment.newLine().unIndent().addSourceCode("run;").newLine(2);
        return codeSegment;
    }

    protected ICodeSegment generateUpdateMissingRcdsTable(ICodeSegment codeSegment, boolean isMissingRcdsTableUpdate, Map targetTableNames) throws CodegenException, BadLibraryDefinitionException, RemoteException, MdException, BadServerDefinitionException, ServerException {
        if (this.isMissingRcdsTableUpdate()) {
            this.m_oMissingRcdsTable.getDBMSType().create(codeSegment, this.m_oMissingRcdsTable, false, true, true, true, "", this.getOwner());
            String sMissingRcdsTableName = this.m_oMissingRcdsTable.getFullNameQuotedAsNeeded(codeSegment);
            String sMissingRcdsTempTableName = "";
            sMissingRcdsTempTableName = (String)targetTableNames.get(MISSING_RCDS_TABLE);
            codeSegment.addCommentLine("update missing records table").addSourceCode("proc append base = ").addSourceCode(sMissingRcdsTableName).addSourceCode(this.getOwner().getTableOptionObject(this.m_oChangedRcdsTable, false).getTableOptions(true, null, codeSegment.getCurrentServer())).newLine().space(12).addSourceCode("data = ").addSourceCode(sMissingRcdsTempTableName).addSourceCode(" force nowarn;").newLine().addSourceCode("run;").newLine().addSourceCode("%rcSet(&syscc);").newLine().unIndent().newLine(2);
        }
        return codeSegment;
    }

    public List getColumnList(IMapping[] mappings, boolean getSources) throws MdException, RemoteException {
        ArrayList<IColumn> columnList = new ArrayList<IColumn>();
        for (int i = 0; i < mappings.length; ++i) {
            int j;
            IColumn[] columns;
            IMapping map = mappings[i];
            if (getSources) {
                columns = map.getSources();
                for (j = 0; j < columns.length; ++j) {
                    columnList.add(columns[j]);
                }
                continue;
            }
            columns = map.getTargets();
            for (j = 0; j < columns.length; ++j) {
                columnList.add(columns[j]);
            }
        }
        return columnList;
    }

    private class SetChangeDigestVersionUndoable
    extends AbstractUndoableEdit {
        private String m_sOldOption;
        private String m_sNewOption;

        public SetChangeDigestVersionUndoable(String oldOption, String newOption) {
            this.m_sOldOption = oldOption;
            this.m_sNewOption = newOption;
        }

        @Override
        public void undo() {
            super.undo();
            CompareTables.this.setChangeDigestVersion(this.m_sOldOption);
        }

        @Override
        public void redo() {
            super.redo();
            CompareTables.this.setChangeDigestVersion(this.m_sNewOption);
        }
    }

    private class SetHashInternalTableSizeUndoable
    extends AbstractUndoableEdit {
        private int m_oldSize;
        private int m_newSize;

        public SetHashInternalTableSizeUndoable(int oldSize, int newSize) {
            this.m_oldSize = oldSize;
            this.m_newSize = newSize;
        }

        @Override
        public void undo() {
            super.undo();
            CompareTables.this.setHashInternalTableSize(this.m_oldSize);
        }

        @Override
        public void redo() {
            super.redo();
            CompareTables.this.setHashInternalTableSize(this.m_newSize);
        }
    }

    private class SetUseDataHashStepUndoable
    extends AbstractUndoableEdit {
        private boolean m_bValue;

        public SetUseDataHashStepUndoable(boolean value) {
            this.m_bValue = value;
        }

        @Override
        public void undo() {
            super.undo();
            CompareTables.this.setUseDataHashStep(!this.m_bValue);
        }

        @Override
        public void redo() {
            super.redo();
            CompareTables.this.setUseDataHashStep(this.m_bValue);
        }
    }

    private class SetDigestColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldColumn;
        private IColumn m_newColumn;

        public SetDigestColumnUndoable(IColumn oldColumn, IColumn newColumn) {
            this.m_oldColumn = oldColumn;
            this.m_newColumn = newColumn;
        }

        @Override
        public void undo() {
            super.undo();
            CompareTables.this.setDigestColumn(this.m_oldColumn);
        }

        @Override
        public void redo() {
            super.redo();
            CompareTables.this.setDigestColumn(this.m_newColumn);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldColumn = null;
            this.m_newColumn = null;
        }
    }

    private class SetCompareToDigestColumnUndoable
    extends AbstractUndoableEdit {
        private boolean m_bNewValue;

        public SetCompareToDigestColumnUndoable(boolean bNewValue) {
            this.m_bNewValue = bNewValue;
        }

        @Override
        public void undo() {
            super.undo();
            CompareTables.this.setCompareToDigestColumn(!this.m_bNewValue);
        }

        @Override
        public void redo() {
            super.redo();
            CompareTables.this.setCompareToDigestColumn(this.m_bNewValue);
        }
    }
}

