/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.common.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.job.transforms.common.ISQLSortingColumn;
import com.sas.etl.models.job.transforms.common.impl.BaseSortColumn;
import javax.swing.undo.AbstractUndoableEdit;

public class SQLSortingColumn
extends BaseSortColumn
implements ISQLSortingColumn {
    private int m_reference;

    public SQLSortingColumn(String sID, IModel model) {
        super(sID, model);
        this.m_reference = 0;
    }

    public SQLSortingColumn(String sID, IModel model, IColumn column) {
        super(sID, model, column);
    }

    @Override
    public void setColumnReference(int iColumnReference) {
        if (this.m_reference == iColumnReference) {
            return;
        }
        if (iColumnReference != 0 && iColumnReference != 1) {
            throw new IllegalArgumentException("Invalid reference order specified for column: " + iColumnReference);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetColumnReferenceUndoable(this.m_reference, iColumnReference));
        }
        this.m_reference = iColumnReference;
        this.fireModelChangedEvent("SortingColumn:ReferenceChanged", null);
    }

    @Override
    public int getColumnReference() {
        return this.m_reference;
    }

    private class SetColumnReferenceUndoable
    extends AbstractUndoableEdit {
        private int m_oldReference;
        private int m_newReference;

        public SetColumnReferenceUndoable(int oldReference, int newReference) {
            this.m_oldReference = oldReference;
            this.m_newReference = newReference;
        }

        @Override
        public void undo() {
            super.undo();
            SQLSortingColumn.this.setColumnReference(this.m_oldReference);
        }

        @Override
        public void redo() {
            super.redo();
            SQLSortingColumn.this.setColumnReference(this.m_newReference);
        }
    }
}

