/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.common.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.common.IOrderBy;
import com.sas.etl.models.job.transforms.common.ISQLSortingColumn;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.etl.models.job.transforms.common.impl.AbstractSQLSorting;
import com.sas.etl.models.job.transforms.common.impl.BaseSorting;
import com.sas.etl.models.job.transforms.common.impl.RB;
import com.sas.etl.models.job.transforms.sql.impl.ClauseType;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import java.rmi.RemoteException;
import java.util.List;

public class OrderBy
extends AbstractSQLSorting
implements IOrderBy {
    public OrderBy(String sID, IModel model) {
        super(sID, model);
        this.setSyntaxType(2);
    }

    @Override
    public String getDefaultName() {
        return "Order by";
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        if (this.size() == 0) {
            reasons.add(RB.getStringResource("OrderBy.ReasonIncomplete.NoOrderByColumn.txt"));
        }
        return reasons;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.ORDERBY;
    }

    @Override
    protected void saveAdditionalProperties(OMRAdapter omr, ISortColumn sortColumn, BaseSorting.PropertySetTracker tracker, List lSetProperties) throws MdException, RemoteException {
        String sPropertyID = tracker != null ? (String)tracker.m_lPropertyIDs.get(2) : this.createIDForNewObject();
        Property mdoProp = (Property)omr.acquireOMRObject(sPropertyID, "Property");
        mdoProp.setName("SortOrder");
        mdoProp.setPropertyName("SortOrder");
        mdoProp.setPropertyRole("SortOrder");
        mdoProp.setDefaultValue(sortColumn.getDirection());
        mdoProp.setUseValueOnly(1);
        lSetProperties.add(mdoProp);
    }

    @Override
    protected void loadAdditionalProperties(OMRAdapter omr, BaseSorting.PropertySetTracker tracker, ISQLSortingColumn sortColumn, List lSetProperties) throws MdException, RemoteException {
        String sDirection = "ascending";
        for (int i = 0; i < lSetProperties.size(); ++i) {
            Property mdoProp = (Property)lSetProperties.get(i);
            String role = mdoProp.getPropertyRole();
            if (!role.equalsIgnoreCase("SortOrder")) continue;
            tracker.m_lPropertyIDs.add(mdoProp.getFQID());
            sDirection = mdoProp.getDefaultValue();
        }
        if (sDirection.equals("asc")) {
            sDirection = "ascending";
        } else if (sDirection.equals("desc")) {
            sDirection = "descending";
        }
        if (sortColumn != null) {
            sortColumn.setDirection(sDirection);
        }
    }
}

