/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.common.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.common.IGroupBy;
import com.sas.etl.models.job.transforms.common.ISQLSortingColumn;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.etl.models.job.transforms.common.impl.AbstractSQLSorting;
import com.sas.etl.models.job.transforms.common.impl.BaseSorting;
import com.sas.etl.models.job.transforms.common.impl.RB;
import com.sas.etl.models.job.transforms.sql.impl.ClauseType;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.List;

public class GroupBy
extends AbstractSQLSorting
implements IGroupBy {
    public GroupBy(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getDefaultName() {
        return "Group by";
    }

    @Override
    public List getReasonsIncomplete() {
        List reasons = super.getReasonsIncomplete();
        if (this.size() == 0) {
            reasons.add(RB.getStringResource("GroupBy.ReasonIncomplete.NoGroupByColumn.txt"));
        }
        return reasons;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.GROUPBY;
    }

    @Override
    public String getOMRType() {
        return "GroupByClause";
    }

    @Override
    protected void saveAdditionalProperties(OMRAdapter omr, ISortColumn sortColumn, BaseSorting.PropertySetTracker tracker, List lSetProperties) throws MdException, RemoteException {
    }

    @Override
    protected void loadAdditionalProperties(OMRAdapter omr, BaseSorting.PropertySetTracker tracker, ISQLSortingColumn sortColumn, List lSetProperties) throws MdException, RemoteException {
    }

    @Override
    public StringBuffer getCode(boolean quoting, boolean passthru) {
        StringBuffer code = new StringBuffer();
        if (this.size() == 0) {
            return code;
        }
        String desc = this.getDescription();
        if (desc.length() > 0) {
            code.append("/* ").append(desc).append(" */\n");
        }
        code.append("group by\n");
        for (int i = 0; i < this.size(); ++i) {
            ISortColumn sortColumn = (ISortColumn)this.getSortColumnList().get(i);
            IColumn column = sortColumn.getColumn();
            code.append("   ").append(this.getCodeGeneratedColumnName(column, quoting, passthru));
            if (i != this.size() - 1) {
                code.append(",");
            }
            code.append("\n");
        }
        return code;
    }
}

