/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.common.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.transforms.common.IPortFactory;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.etl.models.job.transforms.common.ITransformTemplate;
import com.sas.etl.models.job.transforms.common.impl.DefaultPortFactory;
import com.sas.etl.models.job.transforms.common.impl.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Prototype;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import org.apache.commons.lang.ArrayUtils;

public class BaseTransformTemplate
extends AbstractPersistableObject
implements ITransformTemplate {
    private static final String SOURCE_MINIMUM = "SourceMinimum";
    private static final String SOURCE_MAXIMUM = "SourceMaximum";
    private static final String TARGET_MINIMUM = "TargetMinimum";
    private static final String TARGET_MAXIMUM = "TargetMaximum";
    private List<ITransformPort<?>> m_lstSourcePorts = new ArrayList();
    private List<ITransformPort<?>> m_lstTargetPorts = new ArrayList();
    private int m_sourceMinimum = 0;
    private int m_sourceMaximum = Integer.MAX_VALUE;
    private int m_targetMinimum = 0;
    private int m_targetMaximum = Integer.MAX_VALUE;
    private IPortFactory m_factory;
    private static final String DEFAULT_NAME = "PFDTEMPLATE";

    public BaseTransformTemplate(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void setPortFactory(IPortFactory factory) {
        this.m_factory = factory;
    }

    @Override
    public IPortFactory getPortFactory() {
        if (this.m_factory == null) {
            return new DefaultPortFactory();
        }
        return this.m_factory;
    }

    @Override
    public String getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get("Prototype");
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
        }
        lAssociations.add("PrototypeProperties");
        map.put("Prototype", lAssociations);
        lAssociations = new ArrayList();
        lAssociations.add("UsingPrototype");
        map.put("AssociationProperty", lAssociations);
        return map;
    }

    @Override
    public int getSourcePortCount() {
        return this.m_lstSourcePorts.size();
    }

    public int getSourceCount() {
        int i = 0;
        for (ITransformPort<?> port : this.getSourcePorts()) {
            if (port.getObject() == null) continue;
            ++i;
        }
        return i;
    }

    public int getTargetCount() {
        int i = 0;
        for (ITransformPort<?> port : this.getTargetPorts()) {
            if (port.getObject() == null) continue;
            ++i;
        }
        return i;
    }

    @Override
    public int getTargetPortCount() {
        return this.m_lstTargetPorts.size();
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "Prototype";
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.isSourcePortsComplete() && this.isTargetPortsComplete() && this.getSourceCount() >= this.getSourceMinimum() && this.getTargetCount() >= this.getTargetMinimum();
    }

    @Override
    public boolean isSourcePortsComplete() {
        for (ITransformPort<?> port : this.getSourcePorts()) {
            if (port.isComplete()) continue;
            return false;
        }
        return true;
    }

    private IColumn[] getAllSourceColumns() {
        ArrayList<IColumn> cs = new ArrayList<IColumn>();
        for (ITransformPort<?> p : this.getSourcePorts()) {
            if (!(p.getObject() instanceof ITable)) continue;
            cs.addAll(Arrays.asList(((ITable)p.getObject()).getColumns()));
        }
        return cs.toArray(new IColumn[cs.size()]);
    }

    @Override
    public boolean isTargetPortsComplete() {
        for (ITransformPort<?> port : this.getTargetPorts()) {
            if (port.isComplete(this.getAllSourceColumns())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getReasonsIncomplete() {
        List lst = super.getReasonsIncomplete();
        for (ITransformPort<?> port : this.getSourcePorts()) {
            lst.addAll(port.getReasonsIncomplete());
        }
        for (ITransformPort<?> port : this.getTargetPorts()) {
            lst.addAll(port.getReasonsIncomplete(this.getAllSourceColumns()));
        }
        if (this.getSourceCount() < this.getSourceMinimum()) {
            lst.add(MessageFormat.format(RB.getStringResource("BaseTransformTemplate.MinSource.error.txt"), new Integer(this.getSourceMinimum())));
        }
        if (this.getTargetCount() < this.getTargetMinimum()) {
            lst.add(MessageFormat.format(RB.getStringResource("BaseTransformTemplate.MinTarget.error.txt"), new Integer(this.getTargetMinimum())));
        }
        return lst;
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        for (ITransformPort<?> port : this.getAllPorts()) {
            if (!port.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete() {
        for (ITransformPort<?> port : this.getAllPorts()) {
            port.delete();
        }
        super.delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.deleteFromOMR(omr);
        for (ITransformPort<?> port : this.getAllPorts()) {
            port.deleteFromOMR(omr);
        }
    }

    @Override
    public int[] findInSourcePorts(IObject obj) {
        ArrayList<Integer> ind = new ArrayList<Integer>();
        List<ITransformPort<?>> ports = this.getSourcePorts();
        for (int i = 0; i < ports.size(); ++i) {
            if (ports.get(i).getObject() != obj) continue;
            ind.add(i);
        }
        return ArrayUtils.toPrimitive((Integer[])ind.toArray(new Integer[ind.size()]));
    }

    @Override
    public int[] findInTargetPorts(IObject obj) {
        ArrayList<Integer> ind = new ArrayList<Integer>();
        List<ITransformPort<?>> ports = this.getTargetPorts();
        for (int i = 0; i < ports.size(); ++i) {
            if (ports.get(i).getObject() != obj) continue;
            ind.add(i);
        }
        return ArrayUtils.toPrimitive((Integer[])ind.toArray(new Integer[ind.size()]));
    }

    @Override
    public int getNumberTimesObjectUsedInTargets(IObject object) {
        int cnt = 0;
        if (object != null) {
            List<ITransformPort<?>> ports = this.getTargetPorts();
            for (int i = 0; i < ports.size(); ++i) {
                if (ports.get(i).getObject() != object) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    @Override
    public int getNumberTimesObjectUsedInSources(IObject object) {
        int cnt = 0;
        if (object != null) {
            List<ITransformPort<?>> ports = this.getSourcePorts();
            for (int i = 0; i < ports.size(); ++i) {
                if (ports.get(i).getObject() != object) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    @Override
    public void addSourcePort(ITransformPort<?> port) {
        this.addSourcePort(this.m_lstSourcePorts.size(), port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSourcePort(int index, ITransformPort<?> port) {
        if (this.m_lstSourcePorts.contains(port)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new AddSourcePortUndoable(port));
            }
            this.m_lstSourcePorts.add(index, port);
            int max = port.getMaximum();
            if (max == 0) {
                max = Integer.MAX_VALUE;
            }
            port.setAsInputTemplate(true);
            this.setSourceMaximum(max);
            this.setSourceMinimum(port.getMinimum());
            port.setOwningTemplate(this);
            this.removeFromDeletedObjects(port);
            port.addNotifyListener(this);
            this.fireModelChangedEvent("ITransformTemplate:SourcePortAdded", port, new Integer(index));
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void removeSourcePort(ITransformPort<?> port) {
        if (!this.m_lstSourcePorts.contains(port)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new RemoveSourcePortUndoable(port));
            }
            this.fireModelChangedEvent("ITransformTemplate:SourcePortRemoved", port);
            this.m_lstSourcePorts.remove(port);
            this.addToDeletedObjects(port);
            port.removeNotifyListener(this);
            this.fireModelChangedEvent("ITransformTemplate:SourcePortRemoved", port);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public List<ITransformPort<?>> getSourcePorts() {
        return this.m_lstSourcePorts;
    }

    @Override
    public ITransformPort<?> findSourcePort(String partnerName) {
        for (ITransformPort<?> p : this.getSourcePorts()) {
            if (!ObjectComparator.isEqual(p.getPartnerName(), partnerName)) continue;
            return p;
        }
        return null;
    }

    @Override
    public void addTargetPort(ITransformPort<?> port) {
        this.addTargetPort(this.m_lstTargetPorts.size(), port);
    }

    @Override
    public void addTargetPort(int index, ITransformPort<?> port) {
        if (this.m_lstTargetPorts.contains(port)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new AddTargetPortUndoable(port));
            }
            this.m_lstTargetPorts.add(index, port);
            port.setAsInputTemplate(false);
            port.setOwningTemplate(this);
            this.removeFromDeletedObjects(port);
            port.addNotifyListener(this);
            this.fireModelChangedEvent("ITransformTemplate:TargetPortAdded", port, new Integer(index));
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public int getPortIndex(ITransformPort<?> port) {
        if (port.isInputTemplate()) {
            return this.m_lstSourcePorts.indexOf(port);
        }
        return this.m_lstTargetPorts.indexOf(port);
    }

    @Override
    public void removeTargetPort(ITransformPort<?> port) {
        if (!this.m_lstTargetPorts.contains(port)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            this.fireModelChangedEvent("ITransformTemplate:TargetPortRemoved", port);
            this.m_lstTargetPorts.remove(port);
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new RemoveTargetPortUndoable(port));
            }
            this.addToDeletedObjects(port);
            port.removeNotifyListener(this);
            this.fireModelChangedEvent("ITransformTemplate:TargetPortRemoved", port);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public List<ITransformPort<?>> getTargetPorts() {
        return this.m_lstTargetPorts;
    }

    @Override
    public ITransformPort<?> findTargetPort(String partnerName) {
        for (ITransformPort<?> p : this.getTargetPorts()) {
            if (!ObjectComparator.isEqual(p.getPartnerName(), partnerName)) continue;
            return p;
        }
        return null;
    }

    @Override
    public void setSourceMinimum(int min) {
        if (this.m_sourceMinimum == min) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSourceMinimumUndoable(this.m_sourceMinimum, min));
        }
        this.m_sourceMinimum = min;
        this.fireModelChangedEvent("ITransformTemplate:SourceMinimumChanged", null);
    }

    @Override
    public int getSourceMinimum() {
        return this.m_sourceMinimum;
    }

    @Override
    public void setSourceMaximum(int max) {
        if (this.m_sourceMaximum == max) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSourceMaximumUndoable(this.m_sourceMaximum, max));
        }
        this.m_sourceMaximum = max;
        this.fireModelChangedEvent("ITransformTemplate:SourceMaximumChanged", null);
    }

    @Override
    public int getSourceMaximum() {
        return this.m_sourceMaximum;
    }

    @Override
    public void setTargetMinimum(int min) {
        if (this.m_targetMinimum == min) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTargetMinimumUndoable(this.m_targetMinimum, min));
        }
        this.m_targetMinimum = min;
        this.fireModelChangedEvent("ITransformTemplate:TargetMinimumChanged", null);
    }

    @Override
    public int getTargetMinimum() {
        return this.m_targetMinimum;
    }

    @Override
    public void setTargetMaximum(int max) {
        if (this.m_targetMaximum == max) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTargetMaximumUndoable(this.m_targetMaximum, max));
        }
        this.m_targetMaximum = max;
        this.fireModelChangedEvent("ITransformTemplate:TargetMaximumChanged", null);
    }

    @Override
    public int getTargetMaximum() {
        return this.m_targetMaximum;
    }

    private List<ITransformPort<?>> getAllPorts() {
        ArrayList templates = new ArrayList();
        templates.addAll(this.getSourcePorts());
        templates.addAll(this.getTargetPorts());
        return templates;
    }

    @Override
    public List<ITransformPort<?>> getPorts() {
        return this.getAllPorts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITransformTemplate copy(ITransformTemplate newTemplate) {
        this.startCompoundUndoable();
        try {
            for (ITransformPort<?> port : this.getAllPorts()) {
                if (port.isInputTemplate()) {
                    newTemplate.addSourcePort(port.copy(newTemplate.getID()));
                    continue;
                }
                newTemplate.addTargetPort(port.copy(newTemplate.getID()));
            }
            newTemplate.setSourceMaximum(this.getSourceMaximum());
            newTemplate.setSourceMinimum(this.getSourceMinimum());
            newTemplate.setTargetMaximum(this.getTargetMaximum());
            newTemplate.setTargetMinimum(this.getTargetMinimum());
            ITransformTemplate iTransformTemplate = newTemplate;
            return iTransformTemplate;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public int getOptionalPortCount(boolean sourcePorts) {
        int cnt = 0;
        for (ITransformPort<?> port : sourcePorts ? this.getSourcePorts() : this.getTargetPorts()) {
            if (!port.isOptional()) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public boolean canPortBeRemoved(boolean sourcePorts) {
        return this.getPortToRemove(sourcePorts) != null;
    }

    @Override
    public ITransformPort<?> getPortToRemove(boolean sourcePorts) {
        for (ITransformPort<?> port : sourcePorts ? this.getSourcePorts() : this.getTargetPorts()) {
            if (!port.isOptional()) continue;
            return port;
        }
        return null;
    }

    @Override
    public boolean canPortBeAdded(boolean sourcePorts) {
        List<ITransformPort<?>> ports = sourcePorts ? this.getSourcePorts() : this.getTargetPorts();
        int max = sourcePorts ? this.getSourceMaximum() : this.getTargetMaximum();
        return ports.size() < max;
    }

    @Override
    public ITransformTemplate updateDisplayedPorts() {
        return this.updateDisplayedPorts(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITransformTemplate updateDisplayedPorts(boolean useTableCheck) {
        this.startCompoundUndoable();
        try {
            for (ITransformPort<?> sourcePort : this.getSourcePorts()) {
                if (!sourcePort.isOptional()) continue;
                if (useTableCheck && sourcePort.getObject() == null) {
                    this.removeSourcePort(sourcePort);
                    continue;
                }
                if (useTableCheck) continue;
                this.removeSourcePort(sourcePort);
            }
            for (ITransformPort<?> targetPort : this.getTargetPorts()) {
                if (!targetPort.isOptional()) continue;
                if (useTableCheck && targetPort.getObject() == null) {
                    this.removeTargetPort(targetPort);
                    continue;
                }
                if (useTableCheck) continue;
                this.removeTargetPort(targetPort);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITransformTemplate cleanPorts() {
        this.startCompoundUndoable();
        try {
            int srcMax = this.getSourceMaximum();
            List<ITransformPort<?>> sourcePorts = this.getSourcePorts();
            for (int i = sourcePorts.size(); i > srcMax; --i) {
                this.removeSourcePort(sourcePorts.get(i - 1));
            }
            int tarMax = this.getTargetMaximum();
            List<ITransformPort<?>> targetPorts = this.getTargetPorts();
            for (int i = targetPorts.size(); i > tarMax; --i) {
                this.removeTargetPort(targetPorts.get(i - 1));
            }
        }
        finally {
            this.endCompoundUndoable();
        }
        return this;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Prototype proto = (Prototype)omr.acquireOMRObject(this);
        this.setSourceMinimum(this.loadIntOptionFromOMR(omr, SOURCE_MINIMUM, 0));
        this.setSourceMaximum(this.loadIntOptionFromOMR(omr, SOURCE_MAXIMUM, Integer.MAX_VALUE));
        this.setTargetMinimum(this.loadIntOptionFromOMR(omr, TARGET_MINIMUM, 0));
        this.setTargetMaximum(this.loadIntOptionFromOMR(omr, TARGET_MAXIMUM, Integer.MAX_VALUE));
        AssociationList props = proto.getPrototypeProperties();
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            Object t = props.get(i);
            if (!(t instanceof AssociationProperty)) continue;
            AssociationProperty associationProp = (AssociationProperty)props.get(i);
            ITransformPort<?> port = this.getPortFactory().createPort(this.getModel(), associationProp.getFQID(), associationProp.getPartnerName());
            port.setOwningTemplate(this);
            port.loadFromOMR(omr);
            if (port.isInputTemplate()) {
                this.addSourcePort(port);
                continue;
            }
            this.addTargetPort(port);
        }
        this.cleanPorts();
        this.setChanged(false);
    }

    @Override
    public ITransformPort<?> getNextAvailablePort(boolean isSource) {
        for (ITransformPort<?> port : isSource ? this.getSourcePorts() : this.getTargetPorts()) {
            if (port.getObject() != null) continue;
            return port;
        }
        return null;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Prototype proto = (Prototype)omr.acquireOMRObject(this);
        this.saveIntOptionToOMR(omr, SOURCE_MINIMUM, this.getSourceMinimum());
        this.saveIntOptionToOMR(omr, SOURCE_MAXIMUM, this.getSourceMaximum());
        this.saveIntOptionToOMR(omr, TARGET_MINIMUM, this.getTargetMinimum());
        this.saveIntOptionToOMR(omr, TARGET_MAXIMUM, this.getTargetMaximum());
        AssociationList props = proto.getPrototypeProperties(false);
        props.clear();
        for (ITransformPort<?> port : this.getAllPorts()) {
            port.saveToOMR(omr);
            props.add(omr.acquireOMRObject(port));
        }
        this.setChanged(false);
    }

    private class RemoveTargetPortUndoable
    extends AbstractUndoableEdit {
        private ITransformPort<?> m_port;

        public RemoveTargetPortUndoable(ITransformPort<?> port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformTemplate.this.addTargetPort(this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformTemplate.this.removeTargetPort(this.m_port);
        }
    }

    private class RemoveSourcePortUndoable
    extends AbstractUndoableEdit {
        private ITransformPort<?> m_port;

        public RemoveSourcePortUndoable(ITransformPort<?> port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformTemplate.this.addSourcePort(this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformTemplate.this.removeSourcePort(this.m_port);
        }
    }

    private class AddTargetPortUndoable
    extends AbstractUndoableEdit {
        private ITransformPort<?> m_port;

        public AddTargetPortUndoable(ITransformPort<?> port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformTemplate.this.removeTargetPort(this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformTemplate.this.addTargetPort(this.m_port);
        }
    }

    private class AddSourcePortUndoable
    extends AbstractUndoableEdit {
        private ITransformPort<?> m_port;

        public AddSourcePortUndoable(ITransformPort<?> port) {
            this.m_port = port;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformTemplate.this.removeSourcePort(this.m_port);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformTemplate.this.addSourcePort(this.m_port);
        }
    }

    private class SetTargetMinimumUndoable
    extends AbstractUndoableEdit {
        private int m_oldTargetMinimum;
        private int m_newTargetMinimum;

        public SetTargetMinimumUndoable(int oldTargetMinimum, int newTargetMinimum) {
            this.m_oldTargetMinimum = oldTargetMinimum;
            this.m_newTargetMinimum = newTargetMinimum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformTemplate.this.setTargetMinimum(this.m_oldTargetMinimum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformTemplate.this.setTargetMinimum(this.m_newTargetMinimum);
        }
    }

    private class SetTargetMaximumUndoable
    extends AbstractUndoableEdit {
        private int m_oldTargetMaximum;
        private int m_newTargetMaximum;

        public SetTargetMaximumUndoable(int oldTargetMaximum, int newTargetMaximum) {
            this.m_oldTargetMaximum = oldTargetMaximum;
            this.m_newTargetMaximum = newTargetMaximum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformTemplate.this.setTargetMaximum(this.m_oldTargetMaximum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformTemplate.this.setTargetMaximum(this.m_newTargetMaximum);
        }
    }

    private class SetSourceMinimumUndoable
    extends AbstractUndoableEdit {
        private int m_oldSourceMinimum;
        private int m_newSourceMinimum;

        public SetSourceMinimumUndoable(int oldSourceMinimum, int newSourceMinimum) {
            this.m_oldSourceMinimum = oldSourceMinimum;
            this.m_newSourceMinimum = newSourceMinimum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformTemplate.this.setSourceMinimum(this.m_oldSourceMinimum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformTemplate.this.setSourceMinimum(this.m_newSourceMinimum);
        }
    }

    private class SetSourceMaximumUndoable
    extends AbstractUndoableEdit {
        private int m_oldSourceMaximum;
        private int m_newSourceMaximum;

        public SetSourceMaximumUndoable(int oldSourceMaximum, int newSourceMaximum) {
            this.m_oldSourceMaximum = oldSourceMaximum;
            this.m_newSourceMaximum = newSourceMaximum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformTemplate.this.setSourceMaximum(this.m_oldSourceMaximum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformTemplate.this.setSourceMaximum(this.m_newSourceMaximum);
        }
    }
}

