/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.common.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IGeneratedTable;
import com.sas.etl.models.data.IGeneratedTableColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.BaseTransformTableOptions;
import com.sas.etl.models.job.transforms.common.ITransformPort;
import com.sas.etl.models.job.transforms.common.ITransformTemplate;
import com.sas.etl.models.job.transforms.common.impl.RB;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AssociationProperty;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import org.apache.commons.lang.StringUtils;

public class BaseTransformPort<T>
extends AbstractPersistableObject
implements ITransformPort<T> {
    private T m_dataObject = null;
    private boolean m_bInput = true;
    private String m_strPartnerName = "DEFAULT";
    private int m_intMinimum = 1;
    private int m_intMaximum = 1;
    private boolean m_bOptional = false;
    private ITransformTemplate m_owningTemplate;
    private boolean m_bInUndoOrRedo = false;
    private ITransformTableOptions m_tableOption;
    private Map<String, IProperty> m_properties = new HashMap<String, IProperty>();
    private String[] m_objectTypes = new String[]{"PhysicalTable", "WorkTable"};
    private String m_objectName = RB.getStringResource("Table.txt");
    private IGeneratedTable<? extends IGeneratedTableColumn> m_generatedTable;
    private boolean m_includeSourceColumns = true;
    private boolean m_canPropagateColumns = true;

    public BaseTransformPort(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public boolean canIncludeSourceColumns() {
        return this.m_includeSourceColumns;
    }

    @Override
    public void setCanIncludeSourceColumns(boolean includeSourceColumns) {
        this.m_includeSourceColumns = includeSourceColumns;
    }

    public void setCanPropagateColumns(boolean canProp) {
        this.m_canPropagateColumns = canProp;
    }

    @Override
    public boolean canPropagateColumns() {
        return this.m_canPropagateColumns;
    }

    @Override
    public void setGeneratedTable(IGeneratedTable<? extends IGeneratedTableColumn> table) {
        if (this.m_generatedTable == table) {
            return;
        }
        this.m_generatedTable = table;
        this.fireModelChangedEvent("ITransformPort:GeneratedTableChanged", this.m_generatedTable);
    }

    @Override
    public IGeneratedTable<? extends IGeneratedTableColumn> getGeneratedTable() {
        return this.m_generatedTable;
    }

    @Override
    public void setOwningTemplate(ITransformTemplate template) {
        this.m_owningTemplate = template;
        ITransformTableOptions tableOptions = this.getTransformTableOption();
        if (tableOptions != null) {
            tableOptions.setDisplayName(this.getOptionDisplayName());
        }
    }

    @Override
    public ITransformTemplate getOwningTemplate() {
        return this.m_owningTemplate;
    }

    @Override
    public int getPortIndex() {
        if (this.m_owningTemplate != null) {
            return this.isInputTemplate() ? this.m_owningTemplate.getSourcePorts().indexOf(this) : this.m_owningTemplate.getTargetPorts().indexOf(this);
        }
        return -1;
    }

    @Override
    public boolean isComplete(IColumn[] columns) {
        return super.isComplete() && (this.isOptional() || this.getObject() != null);
    }

    @Override
    public List getReasonsIncomplete(IColumn[] columns) {
        List lst = super.getReasonsIncomplete();
        if (!this.isOptional() && this.getObject() == null) {
            String type = this.isInputTemplate() ? RB.getStringResource("BaseTransformPort.Source.txt") : RB.getStringResource("BaseTransformPort.Target.txt");
            lst.add(MessageFormat.format(RB.getStringResource("BaseTransformPort.PortMissingObject.txt"), type, this.getDisplayString(), this.getObjectName()));
        }
        return lst;
    }

    @Override
    public void setObjectName(String name) {
        this.m_objectName = name;
    }

    @Override
    public String getObjectName() {
        return this.m_objectName;
    }

    @Override
    public void setObjectTypes(String[] types) {
        this.m_objectTypes = types;
    }

    @Override
    public String[] getObjectTypes() {
        return this.m_objectTypes;
    }

    private String getDisplayString() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getName();
        }
        return s;
    }

    @Override
    public String getDefaultName() {
        return MessageFormat.format(RB.getStringResource("BaseTransformPort.DefaultName.txt"), RB.getStringResource("Table.txt"));
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociation = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociation == null) {
            lAssociation = new ArrayList<String>();
        }
        lAssociation.add("UsingPrototype");
        map.put(this.getOMRType(), lAssociation);
        return map;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "AssociationProperty";
    }

    @Override
    public boolean isOptional() {
        return this.m_bOptional;
    }

    @Override
    public void setOptional(boolean optional) {
        if (this.m_bOptional == optional) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetOptionalUndoable(this.m_bOptional, optional));
        }
        this.m_bOptional = optional;
        this.fireModelChangedEvent("ITransformPort:OptionalChanged", this.m_bOptional);
    }

    @Override
    public boolean isInUndoOrRedo() {
        return this.m_bInUndoOrRedo;
    }

    @Override
    public T getObject() {
        return this.m_dataObject;
    }

    @Override
    public void setObject(T dataObject) {
        this.setObject(dataObject, true);
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getSource() == this.getObject()) {
            this.fireModelChangedEvent("ITransformPort:PortChanged", ev.getSource());
        } else {
            super.notify(ev);
        }
    }

    public void setObject(T dataObject, boolean createOptions) {
        if (this.m_dataObject == dataObject) {
            return;
        }
        if (this.m_dataObject instanceof IObject) {
            ((IObject)this.m_dataObject).removeNotifyListener(this);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetObjectUndoable(this.m_dataObject, dataObject));
        }
        T oldObject = this.m_dataObject;
        this.m_dataObject = dataObject;
        if (this.m_dataObject instanceof IObject) {
            ((IObject)this.m_dataObject).addNotifyListener(this);
        }
        if (createOptions && dataObject instanceof IPhysicalTable) {
            this.setTransformTableOption(this.m_dataObject != null ? this.createTransformTableOption((IPhysicalTable)this.m_dataObject) : null);
        }
        this.fireModelChangedEvent("ITransformPort:TableChanged", dataObject, oldObject);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_tableOption != null) {
            this.m_tableOption.updateIDs(mapIDs);
        }
        for (IProperty property : this.getProperties()) {
            property.updateIDs(mapIDs);
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_tableOption != null) {
            this.m_tableOption.deleteFromOMR(omr);
        }
        for (IProperty property : this.getProperties()) {
            property.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void delete() {
        if (this.m_tableOption != null) {
            this.m_tableOption.delete();
        }
        for (IProperty property : this.getProperties()) {
            property.delete();
        }
        super.delete();
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_tableOption != null && this.m_tableOption.isChanged();
    }

    @Override
    public void dispose() {
        if (this.m_tableOption != null) {
            this.m_tableOption.dispose();
        }
        super.dispose();
    }

    protected ITransformTableOptions createTransformTableOption(IPhysicalTable table) {
        BaseTransformTableOptions optionSet = new BaseTransformTableOptions(this.createIDForNewObject(), this.getModel());
        optionSet.setOptionTable(table);
        optionSet.setAccessTypeInput(this.isInputTemplate());
        optionSet.setOwner(this);
        optionSet.setDisplayName(this.getOptionDisplayName());
        return optionSet;
    }

    @Override
    public ITransformTableOptions getTransformTableOption() {
        return this.m_tableOption;
    }

    public void setTransformTableOption(ITransformTableOptions tableOptions) {
        if (tableOptions == this.m_tableOption) {
            return;
        }
        if (this.m_tableOption != null) {
            this.addToDeletedObjects(this.m_tableOption);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTransformTableOptionUndoable(this.m_tableOption, tableOptions));
        }
        this.m_tableOption = tableOptions;
        if (this.m_tableOption != null) {
            this.removeFromDeletedObjects(this.m_tableOption);
            this.m_tableOption.setOwner(this);
        }
        this.fireModelChangedEvent("DataTransform.TransformTableOptionAddded", this.m_tableOption);
    }

    @Override
    public boolean isInputTemplate() {
        return this.m_bInput;
    }

    @Override
    public void setAsInputTemplate(boolean input) {
        if (this.m_bInput == input) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetInputUndoable(this.m_bInput, input));
        }
        this.m_bInput = input;
        this.fireModelChangedEvent("ITransformPort:InputChanged", null);
    }

    @Override
    public int getMinimum() {
        return this.m_intMinimum;
    }

    @Override
    public void setMinimum(int min) {
        if (this.m_intMinimum == min) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMinimumUndoable(this.m_intMinimum, min));
        }
        this.m_intMinimum = min;
        this.fireModelChangedEvent("ITransformPort:MinimumChanged", null);
    }

    @Override
    public int getMaximum() {
        return this.m_intMaximum;
    }

    @Override
    public void setMaximum(int max) {
        if (this.m_intMaximum == max) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMinimumUndoable(this.m_intMaximum, max));
        }
        this.m_intMaximum = max;
        this.fireModelChangedEvent("ITransformPort:MaximumChanged", this.m_intMaximum);
    }

    @Override
    public void setPartnerName(String partnerName) {
        if (StringUtils.equals((String)this.m_strPartnerName, (String)partnerName)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPartnerNameUndoable(this.m_strPartnerName, partnerName));
        }
        this.m_strPartnerName = partnerName;
        this.fireModelChangedEvent("ITransformPort:PartnerNameChanged", this.m_strPartnerName);
    }

    @Override
    public String getPartnerName() {
        return this.m_strPartnerName;
    }

    public boolean equals(ITransformPort<T> port) {
        boolean equals = false;
        if (port != null) {
            return port.getMaximum() == this.getMaximum() && port.getMinimum() == this.getMinimum() && port.isOptional() == this.isOptional() && port.isInputTemplate() == this.isInputTemplate() && ObjectComparator.isEqual(port.getName(), this.getName()) && ObjectComparator.isEqual(port.getPartnerName(), this.getPartnerName()) && port.getObject() == this.getObject();
        }
        return equals;
    }

    @Override
    public int hashcode() {
        return super.hashCode();
    }

    @Override
    public ITransformPort<T> copy(String containerId) {
        ITransformPort<?> port = this.getOwningTemplate().getPortFactory().createNewPort(this.getModel(), containerId, this.getPartnerName());
        port.setName(this.getName());
        port.setDescription(this.getDescription());
        port.setObject(this.getObject());
        port.setPartnerName(this.getPartnerName());
        port.setMinimum(this.getMinimum());
        port.setMaximum(this.getMaximum());
        port.setAsInputTemplate(this.isInputTemplate());
        port.setOptional(this.isOptional());
        return port;
    }

    @Override
    public ITransformPort<T> copySimpleAttributes(ITransformPort<T> portToCopy) {
        this.startCompoundUndoable();
        try {
            this.setName(portToCopy.getName());
            this.setDescription(portToCopy.getDescription());
            this.setPartnerName(portToCopy.getPartnerName());
            this.setMinimum(portToCopy.getMinimum());
            this.setMaximum(portToCopy.getMaximum());
            this.setAsInputTemplate(portToCopy.isInputTemplate());
            this.setOptional(portToCopy.isOptional());
        }
        finally {
            this.endCompoundUndoable();
        }
        return this;
    }

    private String getOptionDisplayName() {
        return this.getName();
    }

    protected boolean loadTransformTableOptionsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Root mdAnchor = omr.acquireOMRObject(this);
        boolean changed = false;
        AssociationList propertySets = mdAnchor.getPropertySets();
        for (int i = 0; i < propertySets.size(); ++i) {
            PropertySet pSet = (PropertySet)propertySets.get(i);
            if (!"TransformTableOptions".equals(pSet.getSetRole())) continue;
            BaseTransformTableOptions transformOpts = new BaseTransformTableOptions(pSet.getFQID(), this.getModel());
            if (this.getObject() == transformOpts.loadAssociatedObject(omr, pSet.getFQID())) {
                transformOpts.setOwner(this);
                transformOpts.loadFromOMR(omr);
                transformOpts.setDisplayName(this.getOptionDisplayName());
                this.setTransformTableOption(transformOpts);
                continue;
            }
            this.addToDeletedObjects(transformOpts);
            changed = true;
        }
        return changed;
    }

    protected ITransformTableOptions findTransformTableOptionsFromOMR(OMRAdapter omr, IPhysicalTable table) throws MdException, RemoteException {
        if (table == null) {
            return null;
        }
        Root mdAnchor = omr.acquireOMRObject(this);
        AssociationList propertySets = mdAnchor.getPropertySets();
        for (int i = 0; i < propertySets.size(); ++i) {
            BaseTransformTableOptions transformOpts;
            IPhysicalTable associatedtable;
            PropertySet pSet = (PropertySet)propertySets.get(i);
            if (!"TransformTableOptions".equals(pSet.getSetRole()) || (associatedtable = (transformOpts = new BaseTransformTableOptions(pSet.getFQID(), this.getModel())).loadAssociatedObject(omr, pSet.getFQID())) != table) continue;
            transformOpts.setOwner(this);
            transformOpts.loadFromOMR(omr);
            return transformOpts;
        }
        return null;
    }

    @Override
    public void addProperty(IProperty property) {
        if (this.m_properties.containsKey(property.getPropertyName())) {
            return;
        }
        this.removeFromDeletedObjects(property);
        this.m_properties.put(property.getPropertyName(), property);
    }

    public void removeProperty(IProperty property) {
        if (!this.m_properties.containsKey(property.getPropertyName())) {
            return;
        }
        this.m_properties.remove(property.getPropertyName());
        this.addToDeletedObjects(property);
    }

    public IProperty[] getProperties() {
        return this.m_properties.values().toArray(new IProperty[this.m_properties.size()]);
    }

    @Override
    public IProperty getProperty(String name) {
        return this.m_properties.get(name);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IPersistableObject[] properties;
        super.loadFromOMR(omr);
        AssociationProperty associationProperty = (AssociationProperty)omr.acquireOMRObject(this);
        for (IPersistableObject property : properties = this.loadCustomListFromOMR(omr, "PROPERTIES")) {
            if (!(property instanceof IProperty)) continue;
            property.loadFromOMR(omr);
            this.addProperty((IProperty)property);
        }
        this.setPartnerName(associationProperty.getPartnerName());
        this.setAsInputTemplate(associationProperty.getMetadataType().equals("INPUT"));
        Root mdObj = associationProperty.getUsingPrototype();
        IOMRPersistable modelObject = null;
        if (mdObj != null) {
            modelObject = omr.acquireObject(mdObj);
        }
        this.setObject(modelObject, false);
        this.setMinimum(associationProperty.getMinimum());
        this.setMaximum(associationProperty.getMaximum());
        this.setOptional(associationProperty.getIsRequired() == 0);
        boolean changed = this.loadTransformTableOptionsFromOMR(omr);
        if (modelObject != null && this.getTransformTableOption() == null && modelObject instanceof IPhysicalTable) {
            this.setTransformTableOption(this.createTransformTableOption((IPhysicalTable)modelObject));
        }
        this.setChanged(changed);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        AssociationProperty associationProperty = (AssociationProperty)omr.acquireOMRObject(this);
        for (IProperty property : this.getProperties()) {
            property.saveToOMR(omr);
        }
        this.saveCustomListToOMR(omr, "PROPERTIES", this.getProperties());
        associationProperty.setName(this.getName());
        associationProperty.setPartnerName(this.getPartnerName());
        associationProperty.setMetadataType(this.isInputTemplate() ? "INPUT" : "OUTPUT");
        associationProperty.setAssociationName(this.isInputTemplate() ? "ClassifierSources" : "ClassifierTargets");
        T modelObject = this.getObject();
        if (modelObject != null) {
            associationProperty.setUsingPrototype(omr.acquireOMRObject((IOMRPersistable)modelObject));
        } else {
            associationProperty.getUsingPrototypes().clear();
        }
        associationProperty.setMinimum(this.getMinimum());
        associationProperty.setMaximum(this.getMaximum());
        associationProperty.setIsVisible(1);
        associationProperty.setIsRequired(this.isOptional() ? 0 : 1);
        this.saveTransformTableOptions(omr);
        this.setChanged(false);
    }

    protected void saveTransformTableOptions(OMRAdapter omr) throws MdException, RemoteException {
        ITransformTableOptions opts = this.getTransformTableOption();
        if (opts != null) {
            opts.saveToOMR(omr);
        }
    }

    private class SetTransformTableOptionUndoable
    extends AbstractUndoableEdit {
        private ITransformTableOptions m_oldObject;
        private ITransformTableOptions m_newObject;

        public SetTransformTableOptionUndoable(ITransformTableOptions oldObject, ITransformTableOptions newObject) {
            this.m_oldObject = oldObject;
            this.m_newObject = newObject;
        }

        @Override
        public void undo() {
            BaseTransformPort.this.m_bInUndoOrRedo = true;
            try {
                super.undo();
                BaseTransformPort.this.setTransformTableOption(this.m_oldObject);
            }
            finally {
                BaseTransformPort.this.m_bInUndoOrRedo = false;
            }
        }

        @Override
        public void redo() {
            BaseTransformPort.this.m_bInUndoOrRedo = true;
            try {
                super.redo();
                BaseTransformPort.this.setTransformTableOption(this.m_newObject);
            }
            finally {
                BaseTransformPort.this.m_bInUndoOrRedo = false;
            }
        }

        @Override
        public void die() {
            this.m_newObject = null;
            this.m_oldObject = null;
            super.die();
        }
    }

    private class SetObjectUndoable
    extends AbstractUndoableEdit {
        private T m_oldTable;
        private T m_newTable;

        public SetObjectUndoable(T oldTable, T newTable) {
            this.m_oldTable = oldTable;
            this.m_newTable = newTable;
        }

        @Override
        public void undo() {
            BaseTransformPort.this.m_bInUndoOrRedo = true;
            try {
                super.undo();
                BaseTransformPort.this.setObject(this.m_oldTable);
            }
            finally {
                BaseTransformPort.this.m_bInUndoOrRedo = false;
            }
        }

        @Override
        public void redo() {
            BaseTransformPort.this.m_bInUndoOrRedo = true;
            try {
                super.redo();
                BaseTransformPort.this.setObject(this.m_newTable);
            }
            finally {
                BaseTransformPort.this.m_bInUndoOrRedo = false;
            }
        }
    }

    private class SetMaximumUndoable
    extends AbstractUndoableEdit {
        private int m_oldMaximum;
        private int m_newMaximum;

        public SetMaximumUndoable(int oldMaximum, int newMaximum) {
            this.m_oldMaximum = oldMaximum;
            this.m_newMaximum = newMaximum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformPort.this.setMaximum(this.m_oldMaximum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformPort.this.setMaximum(this.m_newMaximum);
        }
    }

    private class SetMinimumUndoable
    extends AbstractUndoableEdit {
        private int m_oldMinimum;
        private int m_newMinimum;

        public SetMinimumUndoable(int oldMinimum, int newMinimum) {
            this.m_oldMinimum = oldMinimum;
            this.m_newMinimum = newMinimum;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformPort.this.setMinimum(this.m_oldMinimum);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformPort.this.setMinimum(this.m_newMinimum);
        }
    }

    private class SetInputUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldInput;
        private boolean m_newInput;

        public SetInputUndoable(boolean oldInput, boolean newInput) {
            this.m_oldInput = oldInput;
            this.m_newInput = newInput;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformPort.this.setAsInputTemplate(this.m_oldInput);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformPort.this.setAsInputTemplate(this.m_newInput);
        }
    }

    private class SetOptionalUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldOptional;
        private boolean m_newOptional;

        public SetOptionalUndoable(boolean oldOptional, boolean newOptional) {
            this.m_oldOptional = oldOptional;
            this.m_newOptional = newOptional;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformPort.this.setOptional(this.m_oldOptional);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformPort.this.setOptional(this.m_newOptional);
        }
    }

    private class SetPartnerNameUndoable
    extends AbstractUndoableEdit {
        private String m_oldPartnerName;
        private String m_newPartnerName;

        public SetPartnerNameUndoable(String oldPartnerName, String newPartnerName) {
            this.m_oldPartnerName = oldPartnerName;
            this.m_newPartnerName = newPartnerName;
        }

        @Override
        public void undo() {
            super.undo();
            BaseTransformPort.this.setPartnerName(this.m_oldPartnerName);
        }

        @Override
        public void redo() {
            super.redo();
            BaseTransformPort.this.setPartnerName(this.m_newPartnerName);
        }
    }
}

