/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.common.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.etl.models.job.transforms.common.ISorting;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.QueryClause;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseSorting
extends AbstractPersistableObject
implements ISorting {
    protected static final String PROPERTY_SET_NAME = "ColumnProperties";
    protected static final String PROPERTY_NAME_SORT_ORDER = "SortOrder";
    private List m_lSortColumns = new ModelList(this, new String[]{"Sorting:ColumnAdded", "Sorting:ColumnRemoved"}, 0, ISortColumn.class);
    private String m_sNotSortedOption;
    private int m_iSyntaxType = 1;
    protected List m_lPropertySetTrackers = new ArrayList();
    private HashMap m_hmLocationToRememberedColumns = new HashMap();
    protected boolean m_bChangedDuringLoad = false;

    public BaseSorting(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getDefaultName() {
        return "Order By Clause";
    }

    @Override
    public ISortColumn[] getSortColumns() {
        return this.m_lSortColumns.toArray(new ISortColumn[this.m_lSortColumns.size()]);
    }

    @Override
    public List getSortColumnList() {
        return this.m_lSortColumns;
    }

    @Override
    public ISortColumn createSortColumn(IColumn column) {
        return this.getModel().getObjectFactory().createNewSortColumn(this.getID(), column);
    }

    @Override
    public void addSortColumn(ISortColumn sortColumn) {
        this.addSortColumn(this.m_lSortColumns.size(), sortColumn);
    }

    @Override
    public void addSortColumn(int index, ISortColumn sortColumn) {
        this.m_lSortColumns.add(index, sortColumn);
        IColumn col = sortColumn.getColumn();
        if (col != null) {
            col.addNotifyListener(this);
        }
    }

    @Override
    public void removeSortColumn(ISortColumn sortColumn) {
        IColumn col = sortColumn.getColumn();
        if (col != null) {
            col.removeNotifyListener(this);
        }
        this.m_lSortColumns.remove(sortColumn);
    }

    @Override
    public void removeAllSortColumns() {
        ISortColumn[] aISortColumn = this.getSortColumns();
        for (int i = 0; i < aISortColumn.length; ++i) {
            this.removeSortColumn(aISortColumn[i]);
        }
    }

    @Override
    public boolean containsSortColumn(ISortColumn sortColumn) {
        return this.m_lSortColumns.contains(sortColumn);
    }

    @Override
    public int indexOfSortColumn(ISortColumn sortColumn) {
        return this.m_lSortColumns.indexOf(sortColumn);
    }

    @Override
    public boolean containsColumn(IColumn column) {
        for (int i = 0; i < this.m_lSortColumns.size(); ++i) {
            ISortColumn sortColumn = (ISortColumn)this.m_lSortColumns.get(i);
            if (!sortColumn.containsColumn(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ISortColumn getSortColumnContainingColumn(IColumn column) {
        for (int i = 0; i < this.m_lSortColumns.size(); ++i) {
            ISortColumn sortColumn = (ISortColumn)this.m_lSortColumns.get(i);
            if (sortColumn.getColumn() != column) continue;
            return sortColumn;
        }
        return null;
    }

    @Override
    public boolean containsRememberedColumn(IColumn column) {
        String sName = this.getRememberedName(column);
        return this.m_hmLocationToRememberedColumns.containsKey(sName);
    }

    private String getRememberedName(IColumn column) {
        return column.getName() + " " + column.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSortColumns(ITable oldTable, ITable newTable) {
        if (oldTable == null) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IColumn[] oldColumns = oldTable.getColumns();
            IColumn[] newColumns = null;
            if (newTable != null) {
                newColumns = newTable.getColumns();
            }
            block3: for (int i = 0; i < oldColumns.length; ++i) {
                if (!this.containsColumn(oldColumns[i])) continue;
                if (newColumns == null) {
                    this.replaceSortColumn(oldColumns[i], null);
                    continue;
                }
                for (int j = 0; j < newColumns.length; ++j) {
                    if (!newColumns[j].getColumnName(true).equals(oldColumns[i].getColumnName(true)) || newColumns[j].getType() != oldColumns[i].getType()) continue;
                    this.replaceSortColumn(oldColumns[i], newColumns[j]);
                    continue block3;
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSortColumn(IColumn oldColumn, IColumn newColumn) {
        this.startCompoundUndoable();
        try {
            if (oldColumn == null) {
                if (newColumn != null && this.containsRememberedColumn(newColumn)) {
                    String sName = this.getRememberedName(newColumn);
                    Object rememberedAttrs = this.m_hmLocationToRememberedColumns.get(sName);
                    ISortColumn sortColumn = this.createSortColumn(newColumn);
                    this.setRememberedAttributesToNewSortColumn(rememberedAttrs, sortColumn);
                    this.addSortColumnToRememberedLocation(rememberedAttrs, sortColumn);
                    this.m_hmLocationToRememberedColumns.remove(sName);
                }
            } else if (this.containsColumn(oldColumn)) {
                ISortColumn oldSortColumn = this.getSortColumnContainingColumn(oldColumn);
                String sName = this.getRememberedName(oldColumn);
                if (newColumn == null) {
                    Object rememberedAttrs = this.createRememberedAttributesObject();
                    this.setOldSortColumnAttributesInRememberedObject(rememberedAttrs, oldSortColumn);
                    this.m_hmLocationToRememberedColumns.put(sName, rememberedAttrs);
                    this.removeSortColumn(oldSortColumn);
                } else {
                    oldSortColumn.setColumn(newColumn);
                    this.m_hmLocationToRememberedColumns.remove(sName);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected Object createRememberedAttributesObject() {
        return new RememberedSortColumnAttributes();
    }

    protected void setRememberedAttributesToNewSortColumn(Object rememberedAttrs, ISortColumn sortColumn) {
        sortColumn.setDirection(((RememberedSortColumnAttributes)rememberedAttrs).getDirection());
    }

    protected void addSortColumnToRememberedLocation(Object rememberedAttrs, ISortColumn sortColumn) {
        this.addSortColumn(((RememberedSortColumnAttributes)rememberedAttrs).getLocation(), sortColumn);
    }

    protected void setOldSortColumnAttributesInRememberedObject(Object rememberedAttrs, ISortColumn oldSortColumn) {
        RememberedSortColumnAttributes attrs = (RememberedSortColumnAttributes)rememberedAttrs;
        attrs.setLocation(this.getSortColumnList().indexOf(oldSortColumn));
        attrs.setDirection(oldSortColumn.getDirection());
    }

    @Override
    public void replaceSortColumns(IColumn[] newColumns, String tableName) {
        for (int j = 0; j < this.m_lSortColumns.size(); ++j) {
            boolean found = false;
            ISortColumn oldSortColumn = (ISortColumn)this.m_lSortColumns.get(j);
            for (int i = 0; i < newColumns.length; ++i) {
                IColumn newCol = newColumns[i];
                if (!oldSortColumn.getColumn().getColumnName(true).equals(newColumns[i].getColumnName(true))) continue;
                this.removeSortColumn(oldSortColumn);
                newCol.getTable();
                ISortColumn newSortCol = this.createSortColumn(newCol);
                newSortCol.setDirection(oldSortColumn.getDirection());
                this.replaceAdditionalProperties(oldSortColumn, newSortCol);
                this.addSortColumn(j, newSortCol);
                found = true;
                break;
            }
            if (found) continue;
            this.removeSortColumn(oldSortColumn);
        }
    }

    protected void replaceAdditionalProperties(ISortColumn oldSortColumn, ISortColumn newSortColumn) {
    }

    @Override
    public void notify(NotifyEvent ev) {
        IColumn column;
        if (ev.getType() == 0 && this.containsColumn(column = (IColumn)ev.getSource())) {
            ISortColumn sortColumn = this.getSortColumnContainingColumn(column);
            this.removeSortColumn(sortColumn);
        }
        super.notify(ev);
    }

    @Override
    public int size() {
        return this.m_lSortColumns.size();
    }

    @Override
    public IColumn[] getColumnObjects() {
        IColumn[] aCols = new IColumn[this.m_lSortColumns.size()];
        for (int i = 0; i < this.m_lSortColumns.size(); ++i) {
            ISortColumn sortColumn = (ISortColumn)this.m_lSortColumns.get(i);
            aCols[i] = sortColumn.getColumn();
        }
        return aCols;
    }

    @Override
    public void setNotSorted(String sNotSorted) {
        this.m_sNotSortedOption = sNotSorted;
    }

    @Override
    public String getNotSorted() {
        return this.m_sNotSortedOption;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.hasSortColumnsChanged();
    }

    private boolean hasSortColumnsChanged() {
        for (int iColumn = 0; iColumn < this.m_lSortColumns.size(); ++iColumn) {
            ISortColumn sortColumn = (ISortColumn)this.m_lSortColumns.get(iColumn);
            if (!sortColumn.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.size() > 0;
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment parentSegment, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeSegment codeSegment = parentSegment.createNewCodeSegment(this);
        if (this.size() == 0) {
            return codeSegment;
        }
        codeSegment.addSourceCode(this.getCode(codeSegment.isQuoting(), passthru));
        return codeSegment;
    }

    @Override
    public StringBuffer getCode(boolean quoting, boolean passthru) {
        StringBuffer code = new StringBuffer();
        if (this.size() == 0) {
            return code;
        }
        if (this.getSyntaxType() == 2) {
            String desc = this.getDescription();
            if (desc.length() > 0) {
                code.append("/* ").append(desc).append(" */\n");
            }
            code.append("order by\n");
            for (int i = 0; i < this.size(); ++i) {
                ISortColumn sortColumn = (ISortColumn)this.m_lSortColumns.get(i);
                IColumn column = sortColumn.getColumn();
                code.append("   ").append(this.getCodeGeneratedColumnName(column, quoting, passthru));
                String sDirection = sortColumn.getDirection();
                if ("descending".equals(sDirection)) {
                    code.append(" ").append("desc");
                }
                if (i == this.size() - 1) continue;
                code.append(",");
                code.append("\n");
            }
            code.append("\n");
        } else {
            code.append("by\n");
            for (int i = 0; i < this.size(); ++i) {
                ISortColumn sortColumn = (ISortColumn)this.m_lSortColumns.get(i);
                IColumn column = sortColumn.getColumn();
                String sDirection = sortColumn.getDirection();
                if (sDirection.equalsIgnoreCase("descending")) {
                    code.append("descending").append(" ");
                }
                code.append("   ").append(column.getColumnName(quoting));
                code.append("\n");
            }
            String notSortedOpt = this.getNotSorted();
            if (notSortedOpt != null) {
                code.append(this.getNotSorted());
            }
            code.append(";\n");
        }
        return code;
    }

    protected String getCodeGeneratedColumnName(IColumn column, boolean quoting, boolean passthru) {
        return column.getColumnName(quoting, passthru);
    }

    @Override
    public int getSyntaxType() {
        return this.m_iSyntaxType;
    }

    @Override
    public void setSyntaxType(int iSyntaxType) {
        this.m_iSyntaxType = iSyntaxType;
    }

    @Override
    public String getOMRType() {
        return "OrderByClause";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        ISortColumn sortColumn;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        QueryClause mdoClause = (QueryClause)omr.acquireOMRObject(this);
        AssociationList lPropertySets = mdoClause.getPropertySets(false);
        lPropertySets.clear();
        List lOldPropertyTrackers = this.m_lPropertySetTrackers;
        this.m_lPropertySetTrackers = new ArrayList();
        AssociationList lColumns = mdoClause.getColumns(false);
        lColumns.clear();
        for (int iColumn = 0; iColumn < this.m_lSortColumns.size(); ++iColumn) {
            sortColumn = (ISortColumn)this.m_lSortColumns.get(iColumn);
            IColumn column = sortColumn.getColumn();
            if (column == null) continue;
            lColumns.add(omr.acquireOMRObject(column));
            this.savePropertiesToOMR(omr, (List)lPropertySets, sortColumn, lOldPropertyTrackers);
            column.saveToOMR(omr);
        }
        this.deletePropertiesFromOMR(omr, lOldPropertyTrackers);
        for (int i = 0; i < this.m_lSortColumns.size(); ++i) {
            sortColumn = (ISortColumn)this.m_lSortColumns.get(i);
            sortColumn.setChanged(false);
        }
        this.setChanged(false);
    }

    protected void savePropertiesToOMR(OMRAdapter omr, List lPropertySets, ISortColumn sortColumn, List lPropertyTrackers) throws MdException, RemoteException {
        String sPropSetID = this.createIDForNewObject();
        String sCustAssocID = this.createIDForNewObject();
        PropertySetTracker tracker = null;
        if (!lPropertyTrackers.isEmpty()) {
            tracker = (PropertySetTracker)lPropertyTrackers.remove(0);
            sPropSetID = tracker.m_sPropertySetID;
            sCustAssocID = tracker.m_sCustomAssocID;
        }
        PropertySet mdoPropSet = (PropertySet)omr.acquireOMRObject(sPropSetID, "PropertySet");
        mdoPropSet.setName(PROPERTY_SET_NAME);
        mdoPropSet.setSetRole(PROPERTY_SET_NAME);
        lPropertySets.add(mdoPropSet);
        AssociationList lCustAssoc = mdoPropSet.getCustomAssociations();
        lCustAssoc.clear();
        CustomAssociation mdoCA = (CustomAssociation)omr.acquireOMRObject(sCustAssocID, "CustomAssociation");
        mdoCA.setName(PROPERTY_NAME_SORT_ORDER);
        mdoCA.setPartnerName("SortOrderPartner");
        mdoCA.setisOwned(0);
        AssociationList lObjects = mdoCA.getAssociatedObjects();
        lObjects.clear();
        lObjects.add(omr.acquireOMRObject(sortColumn.getColumn()));
        lCustAssoc.add(mdoCA);
        AssociationList lSetProps = mdoPropSet.getSetProperties(false);
        lSetProps.clear();
        String sPropID = tracker != null ? (String)tracker.m_lPropertyIDs.get(0) : this.createIDForNewObject();
        Property mdoProp = (Property)omr.acquireOMRObject(sPropID, "Property");
        mdoProp.setName(PROPERTY_NAME_SORT_ORDER);
        mdoProp.setPropertyName(PROPERTY_NAME_SORT_ORDER);
        mdoProp.setPropertyRole(PROPERTY_NAME_SORT_ORDER);
        mdoProp.setDefaultValue(sortColumn.getDirection());
        lSetProps.add(mdoProp);
    }

    protected void deletePropertiesFromOMR(OMRAdapter omr, List lOldPropertyTrackers) throws MdException, RemoteException {
        while (!lOldPropertyTrackers.isEmpty()) {
            PropertySetTracker tracker = (PropertySetTracker)lOldPropertyTrackers.remove(0);
            if (tracker.m_sPropertySetID != null) {
                omr.deleteOMRObject(tracker.m_sPropertySetID, "PropertySet");
            }
            if (tracker.m_sHolderID != null) {
                omr.deleteOMRObject(tracker.m_sHolderID, "Transformation");
            }
            if (tracker.m_sCustomAssocID != null) {
                omr.deleteOMRObject(tracker.m_sCustomAssocID, "CustomAssociation");
            }
            for (int i = 0; i < tracker.m_lPropertyIDs.size(); ++i) {
                omr.deleteOMRObject((String)tracker.m_lPropertyIDs.get(i), "Property");
            }
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.m_bChangedDuringLoad = false;
        QueryClause mdoClause = (QueryClause)omr.acquireOMRObject(this);
        this.loadSortColumnsFromOMR(omr, mdoClause);
        this.loadPropertiesFromOMR(omr, mdoClause);
        for (int i = 0; i < this.m_lSortColumns.size(); ++i) {
            ISortColumn sortColumn = (ISortColumn)this.m_lSortColumns.get(i);
            sortColumn.setChanged(false);
        }
        this.setChanged(this.m_bChangedDuringLoad);
    }

    protected void loadSortColumnsFromOMR(OMRAdapter omr, QueryClause mdoOrderBy) throws MdException, RemoteException {
        AssociationList lColumns = mdoOrderBy.getColumns();
        for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
            Column mdoColumn = (Column)lColumns.get(iColumn);
            IColumn column = (IColumn)omr.acquireObject((Root)mdoColumn);
            ISortColumn sortColumn = this.createSortColumn(column);
            this.addSortColumn(sortColumn);
        }
    }

    protected void loadPropertiesFromOMR(OMRAdapter omr, QueryClause mdoOrderBy) throws MdException, RemoteException {
        AssociationList lPropSets = mdoOrderBy.getPropertySets();
        for (int i = 0; i < lPropSets.size(); ++i) {
            Property prop;
            AssociationList lSetProps;
            PropertySet mdoPropSet = (PropertySet)lPropSets.get(i);
            PropertySetTracker tracker = new PropertySetTracker(mdoPropSet.getFQID());
            this.m_lPropertySetTrackers.add(tracker);
            if (!mdoPropSet.getSetRole().equalsIgnoreCase(PROPERTY_SET_NAME)) continue;
            ISortColumn sortColumn = null;
            AssociationList lCustAssocs = mdoPropSet.getCustomAssociations();
            if (!lCustAssocs.isEmpty()) {
                CustomAssociation custAssoc = (CustomAssociation)lCustAssocs.get(0);
                tracker.m_sCustomAssocID = custAssoc.getFQID();
                AssociationList lObjects = custAssoc.getAssociatedObjects();
                if (!lObjects.isEmpty()) {
                    Column mdoCol = (Column)lObjects.get(0);
                    IColumn column = (IColumn)omr.acquireObject((Root)mdoCol);
                    sortColumn = this.getSortColumnContainingColumn(column);
                }
            }
            if ((lSetProps = mdoPropSet.getSetProperties()).isEmpty() || !(prop = (Property)lSetProps.get(0)).getPropertyRole().equalsIgnoreCase(PROPERTY_NAME_SORT_ORDER)) continue;
            tracker.m_lPropertyIDs.add(prop.getFQID());
            if (sortColumn == null) continue;
            sortColumn.setDirection(prop.getDefaultValue());
        }
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        super.deleteFromOMR(omr);
        while (!this.m_lPropertySetTrackers.isEmpty()) {
            PropertySetTracker tracker = (PropertySetTracker)this.m_lPropertySetTrackers.remove(0);
            if (tracker.m_sPropertySetID != null) {
                omr.deleteOMRObject(tracker.m_sPropertySetID, "PropertySet");
            }
            if (tracker.m_sHolderID != null) {
                omr.deleteOMRObject(tracker.m_sHolderID, "Transformation");
            }
            if (tracker.m_sCustomAssocID != null) {
                omr.deleteOMRObject(tracker.m_sCustomAssocID, "CustomAssociation");
            }
            for (int i = 0; i < tracker.m_lPropertyIDs.size(); ++i) {
                omr.deleteOMRObject((String)tracker.m_lPropertyIDs.get(i), "Property");
            }
        }
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        for (int i = 0; i < this.m_lPropertySetTrackers.size(); ++i) {
            PropertySetTracker tracker = (PropertySetTracker)this.m_lPropertySetTrackers.get(i);
            tracker.m_sPropertySetID = this.updateSubordinateID(tracker.m_sPropertySetID, mapIDs);
            tracker.m_sCustomAssocID = this.updateSubordinateID(tracker.m_sCustomAssocID, mapIDs);
            tracker.m_sHolderID = this.updateSubordinateID(tracker.m_sHolderID, mapIDs);
            for (int j = 0; j < tracker.m_lPropertyIDs.size(); ++j) {
                String sPropertyID = (String)tracker.m_lPropertyIDs.get(j);
                sPropertyID = this.updateSubordinateID(sPropertyID, mapIDs);
                tracker.m_lPropertyIDs.set(j, sPropertyID);
            }
        }
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get("OrderByClause");
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
        }
        lAssociations.add("Columns");
        lAssociations.add("PropertySets");
        map.put("OrderByClause", lAssociations);
        return map;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    private class RememberedSortColumnAttributes {
        private int m_iLocation;
        private String m_sDirection;

        private RememberedSortColumnAttributes() {
        }

        public void setLocation(int iLocation) {
            this.m_iLocation = iLocation;
        }

        public int getLocation() {
            return this.m_iLocation;
        }

        public void setDirection(String sDirection) {
            this.m_sDirection = sDirection;
        }

        public String getDirection() {
            return this.m_sDirection;
        }
    }

    protected static class PropertySetTracker {
        public String m_sPropertySetID;
        public String m_sCustomAssocID;
        public String m_sHolderID;
        public List m_lPropertyIDs;

        public PropertySetTracker(String sFQID) {
            this.m_sPropertySetID = sFQID;
            this.m_lPropertyIDs = new ArrayList();
        }
    }
}

