/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.common.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.transforms.common.ISQLSortingColumn;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.etl.models.job.transforms.common.impl.BaseSorting;
import com.sas.etl.models.job.transforms.common.impl.SQLSortingColumn;
import com.sas.etl.models.job.transforms.sql.IAliasColumn;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.ISubqueryTargetTable;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.QueryClause;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class AbstractSQLSorting
extends BaseSorting
implements IClause {
    private IQuery m_parentQuery;
    protected static final String PROPERTY_NAME_DISPLAY_INTEGER = "DisplayInteger";
    protected static final String PROPERTY_NAME_COLUMN = "Column";
    protected static final String VALUE_YES = "YES";
    protected static final String VALUE_NO = "NO";
    protected static final String CUSTOMASSOCSOURCENAME = "QuerySourceTable";
    private List m_lCleanUpPropertySetFQIDs = new ArrayList();
    private List m_lCleanUpPropertyFQIDs = new ArrayList();

    public AbstractSQLSorting(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public void setParentQuery(IQuery query) {
        this.m_parentQuery = query;
    }

    @Override
    public IQuery getParentQuery() {
        return this.m_parentQuery;
    }

    @Override
    public ISortColumn createSortColumn(IColumn column) {
        return this.getModel().getObjectFactory().createNewSQLSortingColumn(this.getID(), column);
    }

    @Override
    protected void replaceAdditionalProperties(ISortColumn oldSortColumn, ISortColumn newSortColumn) {
        ((ISQLSortingColumn)newSortColumn).setColumnReference(((SQLSortingColumn)oldSortColumn).getColumnReference());
    }

    @Override
    protected Object createRememberedAttributesObject() {
        return new RememberedSQLSortColumnAttributes();
    }

    @Override
    protected void setRememberedAttributesToNewSortColumn(Object rememberedAttrs, ISortColumn sortColumn) {
        sortColumn.setDirection(((RememberedSQLSortColumnAttributes)rememberedAttrs).getDirection());
        if (sortColumn instanceof ISQLSortingColumn) {
            ((ISQLSortingColumn)sortColumn).setColumnReference(((RememberedSQLSortColumnAttributes)rememberedAttrs).getReference());
        }
    }

    @Override
    protected void setOldSortColumnAttributesInRememberedObject(Object rememberedAttrs, ISortColumn oldSortColumn) {
        RememberedSQLSortColumnAttributes attrs = (RememberedSQLSortColumnAttributes)rememberedAttrs;
        attrs.setLocation(this.getSortColumnList().indexOf(oldSortColumn));
        attrs.setDirection(oldSortColumn.getDirection());
        if (oldSortColumn instanceof ISQLSortingColumn) {
            attrs.setReference(((ISQLSortingColumn)oldSortColumn).getColumnReference());
        }
    }

    @Override
    protected void addSortColumnToRememberedLocation(Object rememberedAttrs, ISortColumn sortColumn) {
        this.addSortColumn(((RememberedSQLSortColumnAttributes)rememberedAttrs).getLocation(), sortColumn);
    }

    @Override
    public void removeSQLSource(ISQLSource source) {
        if (source == null) {
            return;
        }
        ITable sourceTable = null;
        if (source instanceof ISubquery) {
            sourceTable = ((ISubquery)source).getAliasTable();
        } else if (source instanceof ISourceTable) {
            sourceTable = (ITable)((Object)source);
        } else {
            return;
        }
        ISortColumn[] alSortCols = this.getSortColumns();
        for (int i = 0; i < alSortCols.length; ++i) {
            ITable table;
            ISortColumn sortColumn = alSortCols[i];
            IColumn column = sortColumn.getColumn();
            if (column == null || (table = column.getTable()) != sourceTable) continue;
            this.replaceSortColumn(column, null);
        }
    }

    @Override
    public void addSQLSource(ISQLSource source) {
        if (source instanceof ISourceTable) {
            IColumn[] aCols = ((ISourceTable)source).getColumns();
            for (int iCol = 0; iCol < aCols.length; ++iCol) {
                if (!this.containsRememberedColumn(aCols[iCol])) continue;
                this.replaceSortColumn(null, aCols[iCol]);
            }
        }
    }

    @Override
    protected void savePropertiesToOMR(OMRAdapter omr, List lPropertySets, ISortColumn sortColumn, List lPropertyTrackers) throws MdException, RemoteException {
        IAliasTable table;
        String sPropSetID = this.createIDForNewObject();
        String sHolderID = this.createIDForNewObject();
        String sCustAssocID = this.createIDForNewObject();
        BaseSorting.PropertySetTracker tracker = null;
        if (!lPropertyTrackers.isEmpty()) {
            tracker = (BaseSorting.PropertySetTracker)lPropertyTrackers.remove(0);
            sPropSetID = tracker.m_sPropertySetID;
            sHolderID = tracker.m_sHolderID;
            if (tracker.m_sCustomAssocID != null) {
                sCustAssocID = tracker.m_sCustomAssocID;
            }
        }
        PropertySet mdoPropSet = (PropertySet)omr.acquireOMRObject(sPropSetID, "PropertySet");
        mdoPropSet.setName("ColumnProperties");
        mdoPropSet.setSetRole("ColumnProperties");
        lPropertySets.add(mdoPropSet);
        AssociationList lSetProps = mdoPropSet.getSetProperties(false);
        lSetProps.clear();
        String sPropID = tracker != null ? (String)tracker.m_lPropertyIDs.get(0) : this.createIDForNewObject();
        Property mdoProp = (Property)omr.acquireOMRObject(sPropID, "Property");
        mdoProp.setName(PROPERTY_NAME_DISPLAY_INTEGER);
        mdoProp.setPropertyName(PROPERTY_NAME_DISPLAY_INTEGER);
        mdoProp.setPropertyRole(PROPERTY_NAME_DISPLAY_INTEGER);
        mdoProp.setDefaultValue(((ISQLSortingColumn)sortColumn).getColumnReference() == 0 ? VALUE_NO : VALUE_YES);
        mdoProp.setUseValueOnly(1);
        lSetProps.add(mdoProp);
        sPropID = tracker != null ? (String)tracker.m_lPropertyIDs.get(1) : this.createIDForNewObject();
        Property mdoProp2 = (Property)omr.acquireOMRObject(sPropID, "Property");
        mdoProp2.setName(PROPERTY_NAME_COLUMN);
        mdoProp2.setPropertyName(PROPERTY_NAME_COLUMN);
        mdoProp2.setPropertyRole(PROPERTY_NAME_COLUMN);
        mdoProp2.setDefaultValue(PROPERTY_NAME_COLUMN);
        mdoProp2.setUseValueOnly(1);
        lSetProps.add(mdoProp2);
        Transformation mdoTransform = (Transformation)omr.acquireOMRObject(sHolderID, "Transformation");
        mdoTransform.setName(PROPERTY_NAME_COLUMN);
        mdoTransform.setTransformRole(PROPERTY_NAME_COLUMN);
        mdoProp2.getSpecTargetTransformations().add((Object)mdoTransform);
        AssociationList lObjects = mdoTransform.getSourceSpecifications(false);
        lObjects.clear();
        lObjects.add(omr.acquireOMRObject(sortColumn.getColumn()));
        AssociationList lCustAssoc = mdoPropSet.getCustomAssociations(false);
        lCustAssoc.clear();
        IColumn column = sortColumn.getColumn();
        if (column instanceof IAliasColumn && (table = (IAliasTable)column.getTable()) != null) {
            CustomAssociation mdoCA = (CustomAssociation)omr.acquireOMRObject(sCustAssocID, "CustomAssociation");
            mdoCA.setName(CUSTOMASSOCSOURCENAME);
            mdoCA.setPartnerName("QuerySourceTablePartner");
            mdoCA.setisOwned(0);
            AssociationList lAssocObjects = mdoCA.getAssociatedObjects(false);
            lAssocObjects.clear();
            lAssocObjects.add(omr.acquireOMRObject(table));
            lCustAssoc.add(mdoCA);
        }
        this.saveAdditionalProperties(omr, sortColumn, tracker, (List)lSetProps);
    }

    protected abstract void saveAdditionalProperties(OMRAdapter var1, ISortColumn var2, BaseSorting.PropertySetTracker var3, List var4) throws MdException, RemoteException;

    @Override
    protected void loadSortColumnsFromOMR(OMRAdapter omr, QueryClause mdoClause) throws MdException, RemoteException {
        if (this.m_parentQuery == null) {
            super.loadSortColumnsFromOMR(omr, mdoClause);
        }
    }

    @Override
    protected void loadPropertiesFromOMR(OMRAdapter omr, QueryClause mdoClause) throws MdException, RemoteException {
        AssociationList lPropSets = mdoClause.getPropertySets();
        AssociationList lMetadataColumns = mdoClause.getColumns();
        HashMap<String, Integer> mapColumnIndexes = new HashMap<String, Integer>();
        for (int i = 0; i < lMetadataColumns.size(); ++i) {
            mapColumnIndexes.put(((Root)lMetadataColumns.get(i)).getFQID(), i);
        }
        Vector<ISortColumn> lSortColumns = new Vector<ISortColumn>();
        lSortColumns.setSize(lMetadataColumns.size());
        ArrayList<PropertySet> lPropertySets = new ArrayList<PropertySet>();
        for (int i = 0; i < lPropSets.size(); ++i) {
            boolean isCleanUpRequired = false;
            Column mdoColumn = null;
            PropertySet mdoPropSet = (PropertySet)lPropSets.get(i);
            if (!mdoPropSet.getSetRole().equalsIgnoreCase("ColumnProperties")) continue;
            AssociationList lSetProps = mdoPropSet.getSetProperties();
            for (int j = 0; j < lSetProps.size(); ++j) {
                Property mdoProp = (Property)lSetProps.get(j);
                if (isCleanUpRequired) {
                    this.m_lCleanUpPropertyFQIDs.add(mdoProp.getFQID());
                    continue;
                }
                String role = mdoProp.getPropertyRole();
                if (role.equalsIgnoreCase(PROPERTY_NAME_COLUMN) || mdoProp.getPropertyName().equalsIgnoreCase(PROPERTY_NAME_COLUMN)) {
                    AssociationList lTransforms = mdoProp.getSpecTargetTransformations();
                    if (lTransforms.isEmpty()) {
                        isCleanUpRequired = true;
                    } else {
                        Transformation mdoHolder = (Transformation)lTransforms.get(0);
                        AssociationList lObjects = mdoHolder.getSourceSpecifications();
                        if (lObjects.isEmpty()) {
                            isCleanUpRequired = true;
                        } else {
                            mdoColumn = (Column)lObjects.get(0);
                            if (mdoColumn == null) {
                                isCleanUpRequired = true;
                            }
                        }
                    }
                }
                if (!isCleanUpRequired || j <= 0) continue;
                for (int k = j; k >= 0; --k) {
                    this.m_lCleanUpPropertyFQIDs.add(((Property)lSetProps.get(k)).getFQID());
                }
            }
            if (!isCleanUpRequired && mdoColumn != null) {
                lPropertySets.add(mdoPropSet);
                continue;
            }
            this.m_lCleanUpPropertySetFQIDs.add(mdoPropSet.getFQID());
        }
        boolean b_useOrderFromColumnsList = true;
        if (lPropertySets.size() != lMetadataColumns.size()) {
            b_useOrderFromColumnsList = false;
        }
        for (int i = 0; i < lPropertySets.size(); ++i) {
            ISortColumn sortColumn = null;
            int iColumnReference = 0;
            PropertySet mdoPropSet = (PropertySet)lPropertySets.get(i);
            BaseSorting.PropertySetTracker tracker = new BaseSorting.PropertySetTracker(mdoPropSet.getFQID());
            this.m_lPropertySetTrackers.add(tracker);
            AssociationList lSetProps = mdoPropSet.getSetProperties();
            for (int j = 0; j < lSetProps.size(); ++j) {
                IQuery query;
                ITable table;
                Property mdoProp = (Property)lSetProps.get(j);
                String role = mdoProp.getPropertyRole();
                if (role.equalsIgnoreCase(PROPERTY_NAME_DISPLAY_INTEGER)) {
                    tracker.m_lPropertyIDs.add(mdoProp.getFQID());
                    String sValue = mdoProp.getDefaultValue();
                    iColumnReference = sValue.equalsIgnoreCase(VALUE_YES) ? 1 : 0;
                    continue;
                }
                if (!role.equalsIgnoreCase(PROPERTY_NAME_COLUMN) && !mdoProp.getPropertyName().equalsIgnoreCase(PROPERTY_NAME_COLUMN)) continue;
                tracker.m_lPropertyIDs.add(mdoProp.getFQID());
                AssociationList lTransforms = mdoProp.getSpecTargetTransformations();
                if (lTransforms.isEmpty()) continue;
                Transformation mdoHolder = (Transformation)lTransforms.get(0);
                tracker.m_sHolderID = mdoHolder.getFQID();
                AssociationList lObjects = mdoHolder.getSourceSpecifications();
                if (lObjects.isEmpty()) continue;
                IColumn column = null;
                Column mdoColumn = (Column)lObjects.get(0);
                DataTable mdoTable = mdoColumn.getTable();
                if (mdoTable instanceof QueryTable && !((table = (ITable)omr.acquireObject((Root)mdoTable)) instanceof ISubqueryTargetTable)) {
                    this.m_bChangedDuringLoad = true;
                    IColumn[] aColumns = table.getColumns();
                    String sName = mdoColumn.getSASColumnName();
                    for (int index = 0; index < aColumns.length; ++index) {
                        if (!sName.equalsIgnoreCase(aColumns[index].getColumnName(false))) continue;
                        column = aColumns[index];
                        break;
                    }
                }
                if (column == null) {
                    column = (IColumn)omr.acquireObject((Root)mdoColumn);
                }
                if ((query = this.getParentQuery()) != null && !(column instanceof IAliasColumn)) {
                    IAliasColumn aliasColumn;
                    ITable table2 = column.getTable();
                    if (table2 instanceof ISubqueryTargetTable) {
                        IAliasTable aliasTable;
                        IQuery subquery = ((ISubqueryTargetTable)table2).getParentQuery();
                        if (subquery != null && (aliasColumn = (aliasTable = ((ISubquery)subquery).getAliasTable()).findAlaisedColumnContainingColumn(column)) != null) {
                            column = aliasColumn;
                        }
                    } else {
                        ITable queryTable;
                        ISourceTable[] alSrcTbls = query.findQuerySourceTables(table2);
                        if (alSrcTbls.length == 1) {
                            IAliasColumn aliasColumn2 = alSrcTbls[0].findAlaisedColumnContainingColumn(column);
                            if (aliasColumn2 != null) {
                                column = aliasColumn2;
                            }
                        } else if (alSrcTbls.length > 1 && (queryTable = this.findQueryTableCustomAssocation(omr, (Root)mdoPropSet, tracker)) instanceof ISourceTable && (aliasColumn = ((ISourceTable)queryTable).findAlaisedColumnContainingColumn(column)) != null) {
                            column = aliasColumn;
                        }
                    }
                }
                if (column == null || (sortColumn = (ISQLSortingColumn)this.findSortColumnFromColumn(column)) != null) continue;
                sortColumn = (ISQLSortingColumn)this.createSortColumn(column);
                if (column instanceof IAliasColumn) {
                    column = ((IAliasColumn)column).getAliasedColumn();
                }
                int index = (Integer)mapColumnIndexes.get(column.getID());
                if (sortColumn == null) continue;
                if (b_useOrderFromColumnsList) {
                    lSortColumns.set(index, sortColumn);
                    continue;
                }
                lSortColumns.add(sortColumn);
            }
            if (sortColumn == null) continue;
            sortColumn.setColumnReference(iColumnReference);
            this.loadAdditionalProperties(omr, tracker, (ISQLSortingColumn)sortColumn, (List)lSetProps);
        }
        for (ISortColumn sortColumn : lSortColumns) {
            if (sortColumn == null) continue;
            this.addSortColumn(sortColumn);
        }
        if (this.m_lCleanUpPropertyFQIDs.size() > 0) {
            ModelLogger.getDefaultLogger().debug((Object)"Loading: Property clean up required");
            boolean bSupported = this.isUndoSupported();
            this.getModel().setUndoSupported(true);
            this.undoableEditHappened(new SetCleanUpRequiredUndoable());
            this.getModel().setUndoSupported(bSupported);
        }
    }

    private ITable findQueryTableCustomAssocation(OMRAdapter omr, Root mdoAnchor, BaseSorting.PropertySetTracker tracker) throws MdException, RemoteException {
        List lCustAssocs = this.findAllCustomAssociations(omr, mdoAnchor, CUSTOMASSOCSOURCENAME);
        if (lCustAssocs.size() > 0) {
            CustomAssociation ca = (CustomAssociation)lCustAssocs.get(0);
            tracker.m_sCustomAssocID = ca.getFQID();
            AssociationList lObjects = ca.getAssociatedObjects(false);
            IPersistableObject[] aObjects = new IPersistableObject[]{(IPersistableObject)omr.acquireObject((Root)lObjects.get(0))};
            if (aObjects[0] instanceof ITable) {
                return (ITable)aObjects[0];
            }
        }
        return null;
    }

    protected abstract void loadAdditionalProperties(OMRAdapter var1, BaseSorting.PropertySetTracker var2, ISQLSortingColumn var3, List var4) throws MdException, RemoteException;

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        int i;
        if (this.isNew()) {
            return;
        }
        super.deleteFromOMR(omr);
        for (i = 0; i < this.m_lCleanUpPropertySetFQIDs.size(); ++i) {
            omr.deleteOMRObject((String)this.m_lCleanUpPropertySetFQIDs.get(i), "PropertySet");
        }
        for (i = 0; i < this.m_lCleanUpPropertyFQIDs.size(); ++i) {
            omr.deleteOMRObject((String)this.m_lCleanUpPropertyFQIDs.get(i), "Property");
        }
    }

    @Override
    protected String getCodeGeneratedColumnName(IColumn column, boolean quoting, boolean passthru) {
        ISQLSortingColumn srtColumn = (ISQLSortingColumn)this.getSortColumnContainingColumn(column);
        IQuery query = this.getParentQuery();
        if (column == null) {
            return "";
        }
        if (column.getTable() == null) {
            return "";
        }
        if (srtColumn.getColumnReference() == 0) {
            if (query != null) {
                if (query.getTargetTable() == column.getTable()) {
                    return column.getColumnName(quoting, passthru);
                }
                if (column instanceof IAliasColumn) {
                    return ((IAliasColumn)column).getFullColumnName(quoting, passthru, query);
                }
                return column.getFullColumnName(quoting, passthru);
            }
            return column.getColumnName(quoting, passthru);
        }
        int index = Arrays.asList(column.getTable().getColumns()).indexOf(column);
        if (index > -1) {
            return Integer.toString(index + 1);
        }
        return column.getColumnName(quoting, passthru);
    }

    protected ISortColumn findSortColumnFromColumn(IColumn column) {
        List lSortCols = this.getSortColumnList();
        for (int i = 0; i < lSortCols.size(); ++i) {
            ISortColumn sortColumn = (ISortColumn)lSortCols.get(i);
            if (sortColumn == null || !sortColumn.containsColumn(column) || !(sortColumn instanceof ISQLSortingColumn)) continue;
            return sortColumn;
        }
        return null;
    }

    private class SetCleanUpRequiredUndoable
    extends AbstractUndoableEdit {
        @Override
        public void undo() {
            super.undo();
        }

        @Override
        public void redo() {
            super.redo();
        }
    }

    private class RememberedSQLSortColumnAttributes {
        private int m_iLocation;
        private String m_sDirection;
        private int m_iReference;

        private RememberedSQLSortColumnAttributes() {
        }

        public void setLocation(int iLocation) {
            this.m_iLocation = iLocation;
        }

        public int getLocation() {
            return this.m_iLocation;
        }

        public void setDirection(String sDirection) {
            this.m_sDirection = sDirection;
        }

        public String getDirection() {
            return this.m_sDirection;
        }

        public void setReference(int iReference) {
            this.m_iReference = iReference;
        }

        public int getReference() {
            return this.m_iReference;
        }
    }
}

