/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.cas.loader;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObjectFactory;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.CASType;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.cas.loader.RB;
import com.sas.etl.models.job.transforms.common.IGroupBy;
import com.sas.etl.models.job.transforms.common.IOrderBy;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.etl.models.job.transforms.common.impl.SQLSortingColumn;
import com.sas.etl.models.job.transforms.splitter.IRowSelector;
import com.sas.etl.models.job.transforms.splitter.IRowSelectorTransform;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseDataTransformPromptModel;
import com.sas.etl.models.prompts.impl.BaseDataTransformValueChangedListener;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.GroupByClause;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OrderByClause;
import com.sas.metadata.remote.Select;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.xml.sax.SAXException;

public class CASLoaderTransformModel
extends AbstractDataTransform
implements IRowSelectorTransform {
    public static final String TRANSFORMATION_CLASS = "com.sas.etl.models.job.transforms.cas.loader.CASLoaderTransformModel";
    public static final String TRANSFORMATION_ROLE = "com.sas.etl.models.job.transforms.cas.loader.CASLoaderTransformModel";
    private static final String ARM_DISPLAY_NAME = "CASLoaderTransformModel";
    private static final String OPTION_LOAD_TYPE = "Option.LoadType";
    private static final String OPTION_SOURCE_CASLIB = "Option.CASDATA.SourceLib";
    private static final String OPTION_SOURCE_CASLIB_TYPE = "Option.CASDATA.SourceLibType";
    private static final String OPTION_SOURCE_FILE = "Option.CASDATA.SourceFile";
    private static final String OPTION_REPLACE_TYPE = "Option.ReplaceType";
    private static final String OPTION_EXTERNAL_FILE = "Option.ExternalFile";
    private static final String OPTION_EXTERNAL_FILE_TYPE = "Option.ExternalFileType";
    public static final String SOURCE_TYPE_CASDATA = "CASDATA";
    public static final String SOURCE_TYPE_DATA = "DATA";
    public static final String SOURCE_TYPE_FILE = "FILE";
    public static final String OPTION_NAME_CASLIB = "CASLIB";
    public static final String OPTION_NAME_LABEL = "LABEL";
    public static final String OPTION_NAME_PROMOTE = "PROMOTE";
    public static final String OPTION_NAME_COMPRESS = "COMPRESS";
    public static final String OPTION_NAME_COPIES = "COPIES";
    public static final String OPTION_NAME_DUPLICATE = "DUPLICATE";
    public static final String OPTION_VALUE_YES = "YES";
    public static final String OPTION_PERSIST_TARGET = "Option.PersistTarget";
    private static final String PROMPT_SAVE_TABLE = "SAVETABLE";
    private static final String PROMPT_ADDITIONAL_SAVE_OPTIONS = "ADDITIONAL_SAVE_OPTIONS";
    public static final String OPTION_IMPORT_OPTIONS = "Option.ImportOptions";
    public static final String OPTION_DATA_SOURCE_OPTIONS = "Option.DataSourceOptions";
    private static final String PROMPT_IMPORT_OPTIONS = "IMPORTOPTIONS";
    private static final String PROMPT_DATA_SOURCE_OPTIONS = "DATASOURCEOPTIONS";
    private static final String PROMPT_LOAD_STATEMENT_OPTIONS = "LOAD_STATEMENT_OPTIONS";
    public static final String LOAD_TYPE_CHANGED = "CASLoaderTransformModel:LoadStyleChanged";
    public static final String CAS_LIBRARY_CHANGED = "CASLoaderTransformModel:CASLibraryChanged";
    public static final String CAS_LIBRARY_TYPE_CHANGED = "CASLoaderTransformModel:CASLibraryTypeChanged";
    public static final String CAS_SOURCE_CHANGED = "CASLoaderTransformModel:CASSourceChanged";
    public static final String EXTERNAL_FILE_CHANGED = "CASLoaderTransformModel:ExternalFileChanged";
    public static final String EXTERNAL_FILE_TYPE_CHANGED = "CASLoaderTransformModel:ExternalFileTypeChanged";
    public static final String PERSIST_TARGET_CHANGED = "CASLoaderTransformModel:PersistTargetChanged";
    public static final String REPLACE_TYPE_CHANGED = "CASLoaderTransformModel:ReplaceTypeChanged";
    public static final String IMPORT_OPTIONS_CHANGED = "CASLoaderTransformModel:ImportOptionsChanged";
    public static final String DATA_SOURCE_OPTIONS_CHANGED = "CASLoaderTransformModel:DataSourceOptionsChanged";
    public static final String SAVE_OPTIONS_CHANGED = "CASLoaderTransformModel:SaveOptionsChanged";
    private static final String ORDER_BY_CHANGED = "CASLoaderTransformModel:OrderByChanged";
    private static final String GROUP_BY_CHANGED = "CASLoaderTransformModel:GroupByChanged";
    private static final String ROW_SELECTOR_CHANGED = "CASLoaderTransformModel:RowSelectorChanged";
    public static final String LOAD_STMT_OPTIONS_CHANGED = "CASLoaderTransformModel:LoadStmtOptionsChanged";
    public static final String FILE_TYPE_AUTO = "AUTO";
    public static final String FILE_TYPE_BASESAS = "BASESAS";
    public static final String FILE_TYPE_CSV = "CSV";
    public static final String FILE_TYPE_DTA = "DTA";
    public static final String FILE_TYPE_EXCEL = "EXCEL";
    public static final String FILE_TYPE_FMT = "FMT";
    public static final String FILE_TYPE_HDAT = "HDAT";
    public static final String FILE_TYPE_JMP = "JMP";
    public static final String FILE_TYPE_SPSS = "SPSS";
    public static final String FILE_TYPE_XLS = "XLS";
    public static final String FILE_TYPE_NONFILE = "NONFILE";
    public static final String REPLACE_TYPE_NONE = "NONE";
    public static final String REPLACE_TYPE_REPLACE = "REPLACE";
    public static final String REPLACE_TYPE_APPEND = "APPEND";
    public String loadType = "CASDATA";
    public static final String CAS_LIBRARY = "CAS.LIBRARY";
    public static final String CAS_SOURCE = "CAS.SOURCE";
    public static final String EXISTING_SESSREF = "&_SESSREF_.";
    public static final String FILE_TYPE_BASESAS_EXTENSION = "sas7bdat";
    private String inCasLib;
    private String inCasLibType;
    private String casSource;
    private String externalFile;
    private String externalFileType;
    private String replaceType;
    private boolean bPersistTargetTable;
    private String importOptions;
    private String dataSourceOptions;
    private String saveOptions;
    private String loadStmtOptions;
    private ModelList m_lRowSels;
    private IGroupBy m_groupBy = this.getModel().getObjectFactory().createNewSQLGroupBy(this.getID());
    private IOrderBy m_orderBy = this.getModel().getObjectFactory().createNewSQLOrderBy(this.getID());

    public CASLoaderTransformModel(String sID, IModel model) {
        super(sID, model);
        this.m_lRowSels = new cRowSelectorList(this, new String[]{"RowSelector:RowSelectorAdded", "RowSelector:RowSelectorRemoved"}, 3, IRowSelector.class);
        if (this.isNew()) {
            IRowSelector rowSel = this.getModel().getObjectFactory().createNewRowSelector(this.getID());
            this.m_lRowSels.add(rowSel);
        }
        this.setExternalFileType(FILE_TYPE_AUTO);
        this.setPersistTarget(true);
        this.setReplaceType(REPLACE_TYPE_NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postAddDataSource(IDataObject source) {
        this.startCompoundUndoable();
        try {
            super.postAddDataSource(source);
            if (!SOURCE_TYPE_DATA.equals(this.getLoadType())) {
                this.setLoadType(SOURCE_TYPE_DATA);
            }
            this.updateRowSelectorTarget();
            IRowSelector rowSelector = this.getRowSelector();
            if (rowSelector != null) {
                rowSelector.setTable((ITable)source);
                IColumn[] aCols = ((ITable)source).getColumns();
                for (int index = 0; index < aCols.length; ++index) {
                    ITextExpression expr = rowSelector.getExpression();
                    if (expr == null) continue;
                    expr.replaceColumn(null, aCols[index]);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected void postAddDataTarget(IDataObject target) {
        super.postAddDataTarget(target);
        this.updateRowSelectorTarget();
    }

    private void updateRowSelectorTarget() {
        IRowSelector rowSelector = this.getRowSelector();
        if (null != rowSelector) {
            if (SOURCE_TYPE_CASDATA.equals(this.getLoadType())) {
                rowSelector.setTable(this.getTargetTable());
            } else if (SOURCE_TYPE_DATA.equals(this.getLoadType())) {
                rowSelector.setTable(this.getSourceTable());
            }
        }
    }

    @Override
    protected void postRemoveDataTarget(IDataObject target) {
        super.postRemoveDataTarget(target);
        this.updateRowSelectorTarget();
    }

    public String[] getExternalFileTypes() {
        return new String[]{FILE_TYPE_AUTO, FILE_TYPE_BASESAS, FILE_TYPE_CSV, FILE_TYPE_DTA, FILE_TYPE_EXCEL, FILE_TYPE_FMT, FILE_TYPE_HDAT, FILE_TYPE_JMP, FILE_TYPE_SPSS, FILE_TYPE_XLS};
    }

    public String[] getFileTypes() {
        return new String[]{FILE_TYPE_AUTO, FILE_TYPE_BASESAS, FILE_TYPE_CSV, FILE_TYPE_DTA, FILE_TYPE_EXCEL, FILE_TYPE_FMT, FILE_TYPE_HDAT, FILE_TYPE_JMP, FILE_TYPE_SPSS, FILE_TYPE_XLS, FILE_TYPE_NONFILE};
    }

    private void fixReplaceType() {
        IPhysicalTable table;
        if (!SOURCE_TYPE_DATA.equals(this.getLoadType()) && REPLACE_TYPE_APPEND.equals(this.getReplaceType())) {
            this.setReplaceType(REPLACE_TYPE_NONE);
        } else if (StringUtils.isEmpty((String)this.getReplaceType())) {
            this.setReplaceType(REPLACE_TYPE_NONE);
        }
        if (!SOURCE_TYPE_DATA.equals(this.getLoadType()) && null != (table = this.getSourceTable())) {
            this.removeDataSource(table);
        }
    }

    public void setLoadType(String value) {
        if (StringUtils.equals((String)this.loadType, (String)value)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLoadStyleUndoable(this.loadType, value));
        }
        this.loadType = value;
        this.fireModelChangedEvent(LOAD_TYPE_CHANGED, value);
        this.updateRowSelectorTarget();
        this.fixReplaceType();
    }

    public String getLoadType() {
        return this.loadType;
    }

    public void setPersistTarget(boolean value) {
        if (this.bPersistTargetTable == value) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPersistTargetUndoable(this.bPersistTargetTable, value));
        }
        this.bPersistTargetTable = value;
        this.fireModelChangedEvent(PERSIST_TARGET_CHANGED, this.bPersistTargetTable);
    }

    public boolean getPersistTarget() {
        return this.bPersistTargetTable;
    }

    public void setExternalFile(String value) {
        if (StringUtils.equals((String)this.externalFile, (String)value)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetExternalFileUndoable(this.externalFile, value));
        }
        this.externalFile = value;
        this.fireModelChangedEvent(EXTERNAL_FILE_CHANGED, value);
    }

    public String getExternalFile() {
        return this.externalFile;
    }

    public void setExternalFileType(String value) {
        if (StringUtils.equals((String)this.externalFileType, (String)value)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetExternalFileTypeUndoable(this.externalFileType, value));
        }
        this.externalFileType = value;
        this.fireModelChangedEvent(EXTERNAL_FILE_TYPE_CHANGED, value);
    }

    public String getExternalFileType() {
        return this.externalFileType;
    }

    public void setReplaceType(String value) {
        if (StringUtils.equals((String)this.replaceType, (String)value)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetReplaceTypeUndoable(this.replaceType, value));
        }
        this.replaceType = value;
        this.fireModelChangedEvent(REPLACE_TYPE_CHANGED, value);
        this.fixReplaceType();
    }

    public String getReplaceType() {
        return this.replaceType;
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("CASLoaderTransformModel.Name.txt");
    }

    @Override
    public boolean isComplete() {
        boolean complete = super.isComplete();
        if (complete) {
            boolean isValidSource = true;
            if (this.getAreAnySourcesCASTables()) {
                isValidSource = false;
            }
            boolean isValidTarget = this.getAreAnyTargetsCASTables();
            boolean isSourceSelected = this.getLoadType().equalsIgnoreCase(SOURCE_TYPE_CASDATA) && this.isCasSourceSelected() || this.getLoadType().equalsIgnoreCase(SOURCE_TYPE_DATA) && this.isTableSourceSelected() || this.getLoadType().equalsIgnoreCase(SOURCE_TYPE_FILE) && this.isFileSourceSelected();
            complete = isValidSource && isValidTarget && isSourceSelected;
        }
        return complete;
    }

    public boolean getAreAnySourcesCASTables() {
        ITable[] tables;
        for (ITable table : tables = this.getSourceTables()) {
            if (table instanceof IPhysicalTable) {
                if (!(((IPhysicalTable)table).getDBMSType() instanceof CASType)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected boolean doesNoSourcesMeanIncomplete() {
        return false;
    }

    @Override
    protected boolean doesNoMappingsMeanIncomplete() {
        return false;
    }

    @Override
    public List getReasonsIncomplete() {
        List lst = super.getReasonsIncomplete();
        if (this.getAreAnySourcesCASTables()) {
            lst.add(RB.getStringResource("CASLoaderTransformModel.SourceCASTables.txt"));
        }
        if (!this.getAreAnyTargetsCASTables()) {
            lst.add(RB.getStringResource("CASLoaderTransformModel.NoCASTables.txt"));
        }
        if (this.getLoadType().equalsIgnoreCase(SOURCE_TYPE_CASDATA) && !this.isCasSourceSelected()) {
            lst.add(RB.getStringResource("CASLoaderTransformModel.NoCASSource.txt"));
        }
        if (this.getLoadType().equalsIgnoreCase(SOURCE_TYPE_DATA) && !this.isTableSourceSelected()) {
            lst.add(RB.getStringResource("CASLoaderTransformModel.NoTableSource.txt"));
        }
        if (this.getLoadType().equalsIgnoreCase(SOURCE_TYPE_FILE) && !this.isFileSourceSelected()) {
            lst.add(RB.getStringResource("CASLoaderTransformModel.NoFileSource.txt"));
        }
        return lst;
    }

    public boolean getAreAnyTargetsCASTables() {
        ITable[] tables;
        for (ITable table : tables = this.getTargetTables()) {
            if (table instanceof IPhysicalTable) {
                if (!(((IPhysicalTable)table).getDBMSType() instanceof CASType)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("CASLoaderTransformModel.Name.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.etl.models.job.transforms.cas.loader.CASLoaderTransformModel";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.etl.models.job.transforms.cas.loader.CASLoaderTransformModel";
    }

    public static String getTransformTypeID() {
        return "com.sas.etl.models.job.transforms.cas.loader.CASLoaderTransformModel";
    }

    public String getInCasLib() {
        return this.inCasLib;
    }

    public void setInCasLib(String casLibrary) {
        if (StringUtils.equalsIgnoreCase((String)this.inCasLib, (String)casLibrary)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCASLibraryUndoable(this.inCasLib, casLibrary));
        }
        this.inCasLib = casLibrary;
        this.fireModelChangedEvent(CAS_LIBRARY_CHANGED, casLibrary);
    }

    public String getInCasLibType() {
        return this.inCasLibType;
    }

    public void setInCasLibType(String inCasLibType) {
        if (StringUtils.equalsIgnoreCase((String)this.inCasLibType, (String)inCasLibType)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCASLibraryTypeUndoable(this.inCasLibType, inCasLibType));
        }
        this.inCasLibType = inCasLibType;
        this.fireModelChangedEvent(CAS_LIBRARY_TYPE_CHANGED, inCasLibType);
    }

    public String getCasSource() {
        return this.casSource;
    }

    public void setCasSource(String casSource) {
        if (StringUtils.equalsIgnoreCase((String)this.casSource, (String)casSource)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCASSourceUndoable(this.casSource, casSource));
        }
        this.casSource = casSource;
        this.fireModelChangedEvent(CAS_SOURCE_CHANGED, casSource);
    }

    public String getImportOptions() {
        return this.importOptions;
    }

    public void setImportOptions(String importOptions) {
        if (StringUtils.equalsIgnoreCase((String)this.importOptions, (String)importOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetImportOptionsUndoable(this.importOptions, importOptions));
        }
        this.importOptions = importOptions;
        this.fireModelChangedEvent(IMPORT_OPTIONS_CHANGED, importOptions);
    }

    public String getDataSourceOptions() {
        return this.dataSourceOptions;
    }

    public void setDataSourceOptions(String dataSourceOptions) {
        if (StringUtils.equalsIgnoreCase((String)this.dataSourceOptions, (String)dataSourceOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDataSourceOptionsUndoable(this.dataSourceOptions, dataSourceOptions));
        }
        this.dataSourceOptions = dataSourceOptions;
        this.fireModelChangedEvent(DATA_SOURCE_OPTIONS_CHANGED, dataSourceOptions);
    }

    public String getAdditionalSaveOptions() {
        return this.saveOptions;
    }

    public void setAdditionalSaveOptions(String saveOptions) {
        if (StringUtils.equalsIgnoreCase((String)this.saveOptions, (String)saveOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSaveOptionsUndoable(this.saveOptions, saveOptions));
        }
        this.saveOptions = saveOptions;
        this.fireModelChangedEvent(SAVE_OPTIONS_CHANGED, saveOptions);
    }

    public String getLoadStatementOptions() {
        return this.loadStmtOptions;
    }

    public void setLoadStatementOptions(String loadStmtOptions) {
        if (StringUtils.equalsIgnoreCase((String)this.loadStmtOptions, (String)loadStmtOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLoadOptionsUndoable(this.loadStmtOptions, loadStmtOptions));
        }
        this.loadStmtOptions = loadStmtOptions;
        this.fireModelChangedEvent(LOAD_STMT_OPTIONS_CHANGED, loadStmtOptions);
    }

    public IPhysicalTable getTargetTable() {
        return this.getTargetTables() != null && this.getTargetTables().length > 0 ? (IPhysicalTable)this.getTargetTables()[0] : null;
    }

    public String getTargetTableName(IPhysicalTable target) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        String tagOption;
        StringBuffer targetTableName = new StringBuffer();
        if (target.getDBMSType() instanceof CASType && StringUtils.isNotEmpty((String)(tagOption = ((CASType)target.getDBMSType()).getTag(target.getLibraryForUseInJob())))) {
            targetTableName.append(tagOption).append(".");
        }
        targetTableName.append(target.getDBMSTableName(false));
        return targetTableName.toString();
    }

    public String getQuotedIdentifier(String identifier) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        StringBuffer quotedIdentifier = new StringBuffer();
        if (identifier.contains("'")) {
            quotedIdentifier.append("\"").append(identifier.trim()).append("\"");
        } else {
            quotedIdentifier.append("'").append(identifier.trim()).append("'");
        }
        return quotedIdentifier.toString();
    }

    public IPhysicalTable getSourceTable() {
        return this.getSourceTables() != null && this.getSourceTables().length > 0 ? (IPhysicalTable)this.getSourceTables()[0] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean validate) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment, validate);
        IPhysicalTable target = this.getTargetTable();
        String targetTableName = this.getTargetTableName(target);
        String quotedTargetTableName = this.getQuotedIdentifier(targetTableName);
        String host = target.getDatabaseServer().getHost();
        int port = target.getDatabaseServer().getPort();
        String replaceType = this.getReplaceType();
        boolean isPersistTarget = this.getPersistTarget();
        IProperty outCasLibProp = target.getLibraryForUseInJob().findOption(OPTION_NAME_CASLIB);
        String outCasLib = "";
        if (outCasLibProp != null) {
            outCasLib = outCasLibProp.getDefaultValue();
        }
        String groupByColumns = "";
        String orderByColumns = "";
        if (this.getLoadType().equalsIgnoreCase(SOURCE_TYPE_CASDATA) || this.getLoadType().equalsIgnoreCase(SOURCE_TYPE_DATA)) {
            IOrderBy orderByClause;
            IGroupBy groupByClause = this.getGroupBy();
            if (groupByClause != null) {
                IColumn[] aGroupByCols = groupByClause.getColumnObjects();
                StringBuffer cols = new StringBuffer();
                for (int i = 0; i < aGroupByCols.length; ++i) {
                    cols.append(this.getQuotedIdentifier(aGroupByCols[i].getName())).append(" ");
                }
                groupByColumns = cols.toString().trim();
            }
            if (StringUtils.isNotEmpty((String)groupByColumns) && (orderByClause = this.getOrderBy()) != null) {
                int iOldType = orderByClause.getSyntaxType();
                orderByClause.setSyntaxType(2);
                try {
                    IColumn[] aOrderByCols = orderByClause.getColumnObjects();
                    StringBuffer cols = new StringBuffer();
                    for (int i = 0; i < aOrderByCols.length; ++i) {
                        cols.append(this.getQuotedIdentifier(aOrderByCols[i].getName())).append(" ");
                    }
                    orderByColumns = cols.toString().trim();
                }
                finally {
                    orderByClause.setSyntaxType(iOldType);
                }
            }
        }
        String labelOption = target.getDescription();
        String promoteOption = "";
        String compressOption = "";
        String copiesOption = "";
        String duplicateOption = "";
        boolean isPromoteOption = false;
        boolean isCompressOption = false;
        boolean isDuplicateOption = false;
        int numCopiesOption = 0;
        ITransformTableOptions targetOptions = this.getTableOptionObject(target, false);
        if (targetOptions != null) {
            Object copies;
            promoteOption = targetOptions.getOptionModel().findDefinition(OPTION_NAME_PROMOTE).getValue().toString();
            if (promoteOption.equalsIgnoreCase(OPTION_VALUE_YES)) {
                isPromoteOption = true;
            }
            if ((compressOption = targetOptions.getOptionModel().findDefinition(OPTION_NAME_COMPRESS).getValue().toString()).equalsIgnoreCase(OPTION_VALUE_YES)) {
                isCompressOption = true;
            }
            if ((duplicateOption = targetOptions.getOptionModel().findDefinition(OPTION_NAME_DUPLICATE).getValue().toString()).equalsIgnoreCase(OPTION_VALUE_YES)) {
                isDuplicateOption = true;
            }
            if ((copies = targetOptions.getOptionModel().findDefinition(OPTION_NAME_COPIES).getValue()) != null) {
                copiesOption = targetOptions.getOptionModel().findDefinition(OPTION_NAME_COPIES).getValue().toString();
            }
            if (NumberUtils.isNumber((String)copiesOption)) {
                numCopiesOption = Integer.parseInt(copiesOption);
            }
        }
        String sessRef = "";
        boolean isSessref = target.getLibraryForUseInJob().isSessref(target.getLibraryForUseInJob());
        if (!isPromoteOption && isSessref) {
            sessRef = StringUtils.upperCase((String)target.getLibraryForUseInJob().getSessref(target.getLibraryForUseInJob()));
        } else {
            sessRef = codeSegment.getCasSessRefUnique();
            codeSegment.addCommentLine("Save CAS session reference");
            codeSegment.genSaveCasSessionRef();
            codeSegment.addCommentLine("Create CAS session");
            codeSegment.genCreateCasSession(sessRef, host, port);
        }
        if (replaceType.equalsIgnoreCase(REPLACE_TYPE_REPLACE)) {
            codeSegment.addCommentLine("Replace target table requested: Drop session table");
            codeSegment.genCasutilDropTable(sessRef, quotedTargetTableName, outCasLib, true);
            if (isPromoteOption) {
                codeSegment.addCommentLine("Replace target table requested: Drop global table");
                codeSegment.genCasutilDropTable(sessRef, quotedTargetTableName, outCasLib, true);
            }
        }
        if (this.getLoadType().equalsIgnoreCase(SOURCE_TYPE_CASDATA)) {
            this.genCasutilLoadCasData(codeSegment, outCasLib, sessRef, quotedTargetTableName, labelOption, numCopiesOption, isPromoteOption, groupByColumns, orderByColumns);
        } else if (this.getLoadType().equalsIgnoreCase(SOURCE_TYPE_DATA)) {
            this.genCasutilLoadData(codeSegment, outCasLib, sessRef, quotedTargetTableName, labelOption, isPromoteOption, isCompressOption, isDuplicateOption, numCopiesOption, replaceType, groupByColumns, orderByColumns);
        } else if (this.getLoadType().equalsIgnoreCase(SOURCE_TYPE_FILE)) {
            this.genCasutilLoadFile(codeSegment, outCasLib, sessRef, quotedTargetTableName, labelOption, isPromoteOption, numCopiesOption);
        }
        if (isPersistTarget) {
            this.genCasutilSaveCasData(codeSegment, outCasLib, outCasLib, sessRef, quotedTargetTableName, replaceType);
        }
        if (isPromoteOption || !isSessref) {
            codeSegment.addCommentLine("Terminate CAS session");
            codeSegment.genTerminateCasSession(sessRef);
            codeSegment.addCommentLine("Re-set CAS session reference");
            codeSegment.genResetCasSessionRef();
        }
        return codeSegment;
    }

    private ICodeSegment genCasutilLoadCasData(ICodeSegment codeSegment, String outCasLib, String sessRef, String quotedTargetTableName, String labelOption, int numCopiesOption, boolean isPromoteOption, String groupByColumns, String orderByColumns) throws RemoteException, MdException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServerException {
        ITextExpression textExpression;
        String casSource = this.getCasSource();
        String quotedCasSource = this.getQuotedIdentifier(casSource);
        String inCasLib = this.getInCasLib();
        String importOptions = this.getImportOptions();
        String dataSourceOptions = this.getDataSourceOptions();
        String loadStmtOptions = this.getLoadStatementOptions();
        String whereClause = "";
        IRowSelector rowSelector = this.getRowSelector();
        if (rowSelector != null && (textExpression = rowSelector.getExpression()) != null) {
            textExpression.setUseSQLSyntax(false);
            String expression = textExpression.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting());
            if (StringUtils.isNotEmpty((String)expression)) {
                whereClause = expression.trim().replaceAll("\"", "\"\"");
            }
        }
        IPhysicalTable target = this.getTargetTable();
        String vars = this.getCasutilVarsOption(target, 4, 7);
        codeSegment.addCommentLine("PROC CASUTIL: LOAD CASDATA");
        codeSegment.addSourceCode("proc casutil incaslib=\"").addSourceCode(inCasLib).addSourceCode("\"").addSourceCode(" outcaslib=\"").addSourceCode(outCasLib).addSourceCode("\"").addSourceCode(" sessref=").addSourceCode(sessRef).addSourceCode(";").newLine().indent(4).space(1).addSourceCode("load casdata=").addSourceCode(quotedCasSource).newLine().space(1).addSourceCode("casout=").addSourceCode(quotedTargetTableName);
        if (!this.externalFileType.equalsIgnoreCase(FILE_TYPE_NONFILE)) {
            codeSegment.newLine().space(1).addSourceCode("importoptions=(filetype=\"").addSourceCode(this.externalFileType).addSourceCode("\"");
            if (StringUtils.isNotEmpty((String)importOptions)) {
                codeSegment.addSourceCode(",").space(1).addSourceCode(importOptions);
            }
            codeSegment.addSourceCode(")");
        }
        if (StringUtils.isNotEmpty((String)dataSourceOptions)) {
            codeSegment.newLine().space(1).addSourceCode("datasourceoptions=(").addSourceCode(dataSourceOptions).addSourceCode(")");
        }
        if (numCopiesOption > 0) {
            codeSegment.newLine().space(1).addSourceCode("copies=" + String.valueOf(numCopiesOption));
        }
        if (isPromoteOption) {
            codeSegment.newLine().space(1).addSourceCode("promote");
        }
        if (StringUtils.isNotEmpty((String)labelOption)) {
            codeSegment.newLine().space(1).addSourceCode("label=\"").addSourceCode(labelOption).addSourceCode("\"");
        }
        if (StringUtils.isNotEmpty((String)groupByColumns)) {
            codeSegment.newLine().space(1).addSourceCode("groupby=(").addSourceCode(groupByColumns).addSourceCode(")");
            if (StringUtils.isNotEmpty((String)orderByColumns)) {
                codeSegment.newLine().space(1).addSourceCode("orderby=(").addSourceCode(orderByColumns).addSourceCode(")");
            }
        }
        if (StringUtils.isNotEmpty((String)whereClause)) {
            codeSegment.newLine().space(1).addSourceCode("where=\"").addSourceCode(whereClause).addSourceCode("\"");
        }
        if (StringUtils.isNotEmpty((String)vars) && !this.getExternalFileType().equalsIgnoreCase(FILE_TYPE_BASESAS) && !this.isBaseSASFile()) {
            codeSegment.newLine().space(1).addSourceCode("vars=(").addSourceCode(vars).addSourceCode(")");
        }
        if (StringUtils.isNotEmpty((String)loadStmtOptions)) {
            codeSegment.newLine().space(1).addSourceCode(loadStmtOptions);
        }
        codeSegment.addSourceCode(";").unIndent(4).newLine().addSourceCode("quit;").newLine(2);
        return codeSegment;
    }

    private ICodeSegment genCasutilLoadData(ICodeSegment codeSegment, String outCasLib, String sessRef, String quotedTargetTableName, String labelOption, boolean isPromoteOption, boolean isCompressOption, boolean isDuplicateOption, int numCopiesOption, String replaceType, String groupByColumns, String orderByColumns) throws RemoteException, MdException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServerException {
        ITextExpression textExpression;
        IPhysicalTable source = this.getSourceTable();
        String sourceTableName = source.getFullNameQuotedAsNeeded(codeSegment);
        String dataSourceOptions = this.getDataSourceOptions();
        String whereClause = "";
        String loadStmtOptions = this.getLoadStatementOptions();
        IPhysicalTable target = this.getTargetTable();
        List<IColumn> targetColumns = Arrays.asList(target.getColumns());
        String targetKeepList = codeSegment.makeColumnList(targetColumns, "           ", codeSegment.isQuoting());
        IRowSelector rowSelector = this.getRowSelector();
        if (rowSelector != null && (textExpression = rowSelector.getExpression()) != null) {
            textExpression.setUseSQLSyntax(false);
            String expression = textExpression.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting());
            if (StringUtils.isNotEmpty((String)expression)) {
                StringBuffer code = new StringBuffer();
                code.append("where=(").append(expression).append(")");
                whereClause = code.toString().trim();
            }
        }
        codeSegment.addCommentLine("PROC CASUTIL: LOAD DATA");
        codeSegment.addSourceCode("proc casutil outcaslib=\"").addSourceCode(outCasLib).addSourceCode("\"").addSourceCode(" sessref=").addSourceCode(sessRef).addSourceCode(";").newLine().indent(4).space(1).addSourceCode("load data=").addSourceCode(sourceTableName).addSourceCode("(keep=").addSourceCode(targetKeepList);
        if (StringUtils.isNotEmpty((String)whereClause)) {
            codeSegment.space(1).addSourceCode(whereClause);
        }
        codeSegment.addSourceCode(")");
        codeSegment.newLine().space(1).addSourceCode("casout=").addSourceCode(quotedTargetTableName);
        if (StringUtils.isNotEmpty((String)dataSourceOptions)) {
            codeSegment.newLine().space(1).addSourceCode("datasourceoptions=(").addSourceCode(dataSourceOptions).addSourceCode(")");
        }
        if (isDuplicateOption) {
            codeSegment.newLine().space(1).addSourceCode("repeat");
        }
        if (numCopiesOption > 0) {
            codeSegment.newLine().space(1).addSourceCode("copies=" + String.valueOf(numCopiesOption));
        }
        if (isCompressOption) {
            codeSegment.newLine().space(1).addSourceCode("compress");
        }
        if (replaceType.equalsIgnoreCase(REPLACE_TYPE_APPEND)) {
            codeSegment.newLine().space(1).addSourceCode("append");
        }
        if (isPromoteOption && !replaceType.equalsIgnoreCase(REPLACE_TYPE_APPEND)) {
            codeSegment.newLine().space(1).addSourceCode("promote");
        }
        if (StringUtils.isNotEmpty((String)labelOption)) {
            codeSegment.newLine().space(1).addSourceCode("label=\"").addSourceCode(labelOption).addSourceCode("\"");
        }
        if (StringUtils.isNotEmpty((String)groupByColumns) && !isDuplicateOption) {
            codeSegment.newLine().space(1).addSourceCode("groupby=(").addSourceCode(groupByColumns).addSourceCode(")");
            if (StringUtils.isNotEmpty((String)orderByColumns)) {
                codeSegment.newLine().space(1).addSourceCode("orderby=(").addSourceCode(orderByColumns).addSourceCode(")");
            }
        }
        if (StringUtils.isNotEmpty((String)loadStmtOptions)) {
            codeSegment.newLine().space(1).addSourceCode(loadStmtOptions);
        }
        codeSegment.addSourceCode(";").unIndent(4).newLine().addSourceCode("quit;").newLine(2);
        return codeSegment;
    }

    private ICodeSegment genCasutilLoadFile(ICodeSegment codeSegment, String outCasLib, String sessRef, String quotedTargetTableName, String labelOption, boolean isPromoteOption, int numCopiesOption) throws RemoteException, MdException, CodegenException, BadLibraryDefinitionException, BadServerDefinitionException, ServerException {
        String externalFile = this.getExternalFile();
        String quotedExternalFile = this.getQuotedIdentifier(externalFile);
        String externalFileType = this.getExternalFileType();
        String importOptions = this.getImportOptions();
        String loadStmtOptions = this.getLoadStatementOptions();
        codeSegment.addCommentLine("PROC CASUTIL: LOAD FILE");
        codeSegment.addSourceCode("proc casutil outcaslib=\"").addSourceCode(outCasLib).addSourceCode("\"").addSourceCode(" sessref=").addSourceCode(sessRef).addSourceCode(";").newLine().indent(4).space(1).addSourceCode("load file=").addSourceCode(quotedExternalFile).newLine().space(1).addSourceCode("casout=").addSourceCode(quotedTargetTableName).newLine().space(1).addSourceCode("importoptions=(filetype=\"").addSourceCode(externalFileType).addSourceCode("\"");
        if (StringUtils.isNotEmpty((String)importOptions)) {
            codeSegment.addSourceCode(",").space(1).addSourceCode(importOptions);
        }
        codeSegment.addSourceCode(")");
        if (numCopiesOption > 0) {
            codeSegment.newLine().space(1).addSourceCode("copies=" + String.valueOf(numCopiesOption));
        }
        if (isPromoteOption) {
            codeSegment.newLine().space(1).addSourceCode("promote");
        }
        if (StringUtils.isNotEmpty((String)labelOption)) {
            codeSegment.newLine().space(1).addSourceCode("label=\"").addSourceCode(labelOption).addSourceCode("\"");
        }
        if (StringUtils.isNotEmpty((String)loadStmtOptions)) {
            codeSegment.newLine().space(1).addSourceCode(loadStmtOptions);
        }
        codeSegment.addSourceCode(";").unIndent(4).newLine().addSourceCode("quit;").newLine(2);
        return codeSegment;
    }

    private ICodeSegment genCasutilSaveCasData(ICodeSegment codeSegment, String inCasLib, String outCasLib, String sessRef, String quotedTargetTableName, String replaceType) throws RemoteException, MdException, CodegenException, BadLibraryDefinitionException {
        String additionalSaveOpts;
        codeSegment.addCommentLine("PROC CASUTIL: SAVE CASDATA");
        codeSegment.addSourceCode("proc casutil incaslib=\"").addSourceCode(inCasLib).addSourceCode("\"").addSourceCode(" outcaslib=\"").addSourceCode(outCasLib).addSourceCode("\"").addSourceCode(" sessref=").addSourceCode(sessRef).addSourceCode(";").newLine().indent(4).space(1).addSourceCode("save casdata=").addSourceCode(quotedTargetTableName);
        if (replaceType.equalsIgnoreCase(REPLACE_TYPE_REPLACE) || replaceType.equalsIgnoreCase(REPLACE_TYPE_APPEND)) {
            codeSegment.newLine().space(1).addSourceCode("replace");
        }
        if (StringUtils.isNotEmpty((String)(additionalSaveOpts = this.getAdditionalSaveOptions()))) {
            codeSegment.newLine().space(1).addSourceCode(additionalSaveOpts);
        }
        codeSegment.addSourceCode(";");
        codeSegment.newLine().unIndent(4).addSourceCode("quit;").newLine(2);
        return codeSegment;
    }

    @Override
    protected String getClassifierMapType() {
        return "Select";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataTarget(IDataObject target) {
        this.startCompoundUndoable();
        try {
            List orderByList;
            List groupList;
            SQLSortingColumn col;
            super.removeDataTarget(target);
            if (this.getGroupBy().getSortColumnList().size() > 0 && (col = (SQLSortingColumn)(groupList = this.getGroupBy().getSortColumnList()).get(0)).getColumn().getTable().equals(target)) {
                for (int i = 0; i < groupList.size(); ++i) {
                    this.getGroupBy().removeSortColumn((ISortColumn)groupList.get(i));
                }
            }
            if (this.getOrderBy().getSortColumnList().size() > 0 && (col = (SQLSortingColumn)(orderByList = this.getOrderBy().getSortColumnList()).get(0)).getColumn().getTable().equals(target)) {
                for (int j = 0; j < orderByList.size(); ++j) {
                    this.getOrderBy().removeSortColumn((ISortColumn)orderByList.get(j));
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setLoadType(this.loadStringOptionFromOMR(omr, OPTION_LOAD_TYPE, SOURCE_TYPE_CASDATA));
        this.setInCasLib(this.loadStringOptionFromOMR(omr, OPTION_SOURCE_CASLIB, null));
        this.setInCasLibType(this.loadStringOptionFromOMR(omr, OPTION_SOURCE_CASLIB_TYPE, null));
        this.setCasSource(this.loadStringOptionFromOMR(omr, OPTION_SOURCE_FILE, null));
        this.setReplaceType(this.loadStringOptionFromOMR(omr, OPTION_REPLACE_TYPE, REPLACE_TYPE_NONE));
        this.setImportOptions(this.loadStringOptionFromOMR(omr, PROMPT_IMPORT_OPTIONS, null));
        this.setDataSourceOptions(this.loadStringOptionFromOMR(omr, PROMPT_DATA_SOURCE_OPTIONS, null));
        this.setPersistTarget(this.loadBooleanOptionFromOMR(omr, PROMPT_SAVE_TABLE, true));
        this.setAdditionalSaveOptions(this.loadStringOptionFromOMR(omr, PROMPT_ADDITIONAL_SAVE_OPTIONS, null));
        this.setLoadStatementOptions(this.loadStringOptionFromOMR(omr, PROMPT_LOAD_STATEMENT_OPTIONS, null));
        this.setExternalFile(this.loadStringOptionFromOMR(omr, OPTION_EXTERNAL_FILE, null));
        this.setExternalFileType(this.loadStringOptionFromOMR(omr, OPTION_EXTERNAL_FILE_TYPE, null));
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        AssociationList rows = mdoCM.getAssociatedRowSelectors();
        if (!rows.isEmpty()) {
            this.m_lRowSels.loadFromOMR(omr, (List)rows);
        } else if (this.m_lRowSels.size() == 0) {
            IRowSelector rowSel = this.getModel().getObjectFactory().createNewRowSelector(this.getID());
            this.m_lRowSels.add(rowSel);
        }
        this.updateRowSelectorTarget();
        IObjectFactory factory = this.getModel().getObjectFactory();
        GroupByClause gbc = ((Select)mdoCM).getGroupByForSelect();
        IGroupBy groupBy = null;
        if (gbc != null) {
            groupBy = factory.createSQLGroupBy(gbc.getFQID());
            groupBy.loadFromOMR(omr);
        } else {
            groupBy = this.getModel().getObjectFactory().createNewSQLGroupBy(this.getID());
        }
        this.setGroupBy(groupBy);
        OrderByClause obc = ((Select)mdoCM).getOrderByForSelect();
        IOrderBy orderBy = null;
        if (obc != null) {
            orderBy = factory.createSQLOrderBy(obc.getFQID());
            orderBy.loadFromOMR(omr);
        } else {
            orderBy = this.getModel().getObjectFactory().createNewSQLOrderBy(this.getID());
        }
        this.setOrderBy(orderBy);
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        this.saveStringOptionToOMR(omr, OPTION_LOAD_TYPE, this.getLoadType());
        this.saveStringOptionToOMR(omr, OPTION_SOURCE_CASLIB, this.getInCasLib());
        this.saveStringOptionToOMR(omr, OPTION_SOURCE_CASLIB_TYPE, this.getInCasLibType());
        this.saveStringOptionToOMR(omr, OPTION_SOURCE_FILE, this.getCasSource());
        this.saveStringOptionToOMR(omr, OPTION_REPLACE_TYPE, this.getReplaceType());
        this.saveStringOptionToOMR(omr, PROMPT_IMPORT_OPTIONS, this.getImportOptions());
        this.saveStringOptionToOMR(omr, PROMPT_DATA_SOURCE_OPTIONS, this.getDataSourceOptions());
        this.saveBooleanOptionToOMR(omr, PROMPT_SAVE_TABLE, this.getPersistTarget());
        this.saveStringOptionToOMR(omr, PROMPT_ADDITIONAL_SAVE_OPTIONS, this.getAdditionalSaveOptions());
        this.saveStringOptionToOMR(omr, PROMPT_LOAD_STATEMENT_OPTIONS, this.getLoadStatementOptions());
        this.saveStringOptionToOMR(omr, OPTION_EXTERNAL_FILE, this.getExternalFile());
        this.saveStringOptionToOMR(omr, OPTION_EXTERNAL_FILE_TYPE, this.getExternalFileType());
        Select mdoCM = (Select)this.getClassifierMapObject(omr);
        this.getRowSelector().setClassifierMapID(this.getClassifierMapId());
        this.m_lRowSels.saveToOMR(omr, (List)mdoCM.getAssociatedRowSelectors(false));
        IGroupBy groupBy = this.getGroupBy();
        groupBy.saveToOMR(omr);
        mdoCM.setGroupByForSelect((GroupByClause)omr.acquireOMRObject(groupBy));
        IOrderBy orderBy = this.getOrderBy();
        orderBy.saveToOMR(omr);
        mdoCM.setOrderByForSelect((OrderByClause)omr.acquireOMRObject(orderBy));
        this.setChanged(false);
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        return new CASLoaderPromptModel(this);
    }

    @Override
    public List getRowSelectorList() {
        return this.m_lRowSels;
    }

    @Override
    public IRowSelector[] getRowSelectorObjects() {
        return (IRowSelector[])this.m_lRowSels.toArray(new IRowSelector[this.m_lRowSels.size()]);
    }

    public IGroupBy getGroupBy() {
        return this.m_groupBy;
    }

    public void setGroupBy(IGroupBy newGroupBy) {
        if (newGroupBy == null) {
            throw new IllegalArgumentException("group by object cannot be null");
        }
        if (this.m_groupBy == newGroupBy) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetGroupByUndoable(this.m_groupBy, newGroupBy));
        }
        if (this.m_groupBy != null) {
            this.m_groupBy.removeNotifyListener(this);
        }
        this.m_groupBy = newGroupBy;
        if (this.m_groupBy != null) {
            this.m_groupBy.addNotifyListener(this);
        }
        this.fireModelChangedEvent(GROUP_BY_CHANGED, null);
    }

    public IOrderBy getOrderBy() {
        return this.m_orderBy;
    }

    public void setOrderBy(IOrderBy newOrderBy) {
        if (newOrderBy == null) {
            throw new IllegalArgumentException("order by cannot be null");
        }
        if (this.m_orderBy == newOrderBy) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetOrderByUndoable(this.m_orderBy, newOrderBy));
        }
        if (this.m_orderBy != null) {
            this.m_orderBy.removeNotifyListener(this);
        }
        this.m_orderBy = newOrderBy;
        if (this.m_orderBy != null) {
            this.m_orderBy.addNotifyListener(this);
        }
        this.fireModelChangedEvent(ORDER_BY_CHANGED, null);
    }

    public IRowSelector getRowSelector() {
        if (this.m_lRowSels == null || this.m_lRowSels.isEmpty()) {
            return null;
        }
        return (IRowSelector)this.m_lRowSels.get(0);
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getSource() == this.getRowSelector() && ev.getType() == 1) {
            this.fireModelChangedEvent(ROW_SELECTOR_CHANGED, null);
        }
        if (ev.getSource() == this.m_groupBy && ev.getType() == 1) {
            this.fireModelChangedEvent(GROUP_BY_CHANGED, null);
        }
        if (ev.getSource() == this.m_orderBy && ev.getType() == 1) {
            this.fireModelChangedEvent(ORDER_BY_CHANGED, null);
        }
        super.notify(ev);
    }

    public String getCasutilVarsOption(IPhysicalTable table, int columnsPerLine, int spacesPerLine) throws RemoteException, MdException, BadLibraryDefinitionException, BadServerDefinitionException, CodegenException, ServerException {
        List<IColumn> columnList = Arrays.asList(table.getColumns());
        StringBuffer columnListString = new StringBuffer();
        String spaces = "";
        if (spacesPerLine > 0) {
            spaces = new String(new char[spacesPerLine]).replace('\u0000', ' ');
        }
        boolean isNewLine = false;
        int line = 1;
        for (int i = 0; i < columnList.size(); ++i) {
            String columnName = this.getQuotedIdentifier(columnList.get(i).getColumnName(false));
            columnListString.append("(name=").append(columnName).append(")");
            if (line / columnsPerLine == 1) {
                isNewLine = true;
                line = 1;
            } else {
                isNewLine = false;
                ++line;
            }
            if (!isNewLine) continue;
            columnListString.append("\n");
            if (spacesPerLine <= 0) continue;
            columnListString.append(spaces);
        }
        return columnListString.toString().trim();
    }

    public boolean isCasSourceSelected() {
        return StringUtils.isNotEmpty((String)this.getCasSource());
    }

    public boolean isTableSourceSelected() {
        IPhysicalTable source = this.getSourceTable();
        if (source != null) {
            return StringUtils.isNotEmpty((String)source.getSASTableName());
        }
        return false;
    }

    public boolean isFileSourceSelected() {
        return StringUtils.isNotEmpty((String)this.getExternalFile());
    }

    public boolean isBaseSASFile() {
        String extension;
        boolean baseSASFile = false;
        if (this.isCasSourceSelected() && (extension = FilenameUtils.getExtension((String)this.getCasSource())).equalsIgnoreCase(FILE_TYPE_BASESAS_EXTENSION)) {
            baseSASFile = true;
        }
        return baseSASFile;
    }

    protected String booleanToYesNo(boolean bool) {
        return bool ? OPTION_VALUE_YES : "NO";
    }

    protected boolean yesNoToBoolean(String YesNo) {
        return YesNo.equalsIgnoreCase(OPTION_VALUE_YES);
    }

    private class SetOrderByUndoable
    extends AbstractUndoableEdit {
        private IOrderBy m_oldOrderBySetting;
        private IOrderBy m_newOrderBySetting;

        public SetOrderByUndoable(IOrderBy oldSetting, IOrderBy newSetting) {
            this.m_oldOrderBySetting = oldSetting;
            this.m_newOrderBySetting = newSetting;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setOrderBy(this.m_oldOrderBySetting);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setOrderBy(this.m_newOrderBySetting);
        }
    }

    private class SetGroupByUndoable
    extends AbstractUndoableEdit {
        private IGroupBy m_oldGroupBySetting;
        private IGroupBy m_newGroupBySetting;

        public SetGroupByUndoable(IGroupBy oldGroupBySetting, IGroupBy newGroupBySetting) {
            this.m_oldGroupBySetting = oldGroupBySetting;
            this.m_newGroupBySetting = newGroupBySetting;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setGroupBy(this.m_oldGroupBySetting);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setGroupBy(this.m_newGroupBySetting);
        }
    }

    private class cRowSelectorList
    extends ModelList {
        public cRowSelectorList(AbstractPersistableObject owner, String[] aEventIDs, int ePersistenceType, Class clsAllowedType) {
            super(owner, aEventIDs, ePersistenceType, clsAllowedType);
        }

        @Override
        protected void addImpl(int iObj, Object obj) {
            super.addImpl(iObj, obj);
            IRowSelector rowSel = (IRowSelector)obj;
            rowSel.setClassifierMapID(CASLoaderTransformModel.this.getClassifierMapId());
            rowSel.addNotifyListener(CASLoaderTransformModel.this);
            if (CASLoaderTransformModel.this.getSourceTables().length > 0) {
                rowSel.setTable(CASLoaderTransformModel.this.getSourceTables()[0]);
            }
        }

        @Override
        protected Object removeImpl(int iObject) {
            IRowSelector rowSel = (IRowSelector)super.removeImpl(iObject);
            rowSel.removeNotifyListener(CASLoaderTransformModel.this);
            return rowSel;
        }
    }

    private class SetLoadOptionsUndoable
    extends AbstractUndoableEdit {
        private String oldValue;
        private String newValue;

        public SetLoadOptionsUndoable(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setLoadStatementOptions(this.oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setLoadStatementOptions(this.newValue);
        }
    }

    private class SetSaveOptionsUndoable
    extends AbstractUndoableEdit {
        private String oldValue;
        private String newValue;

        public SetSaveOptionsUndoable(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setAdditionalSaveOptions(this.oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setAdditionalSaveOptions(this.newValue);
        }
    }

    private class SetDataSourceOptionsUndoable
    extends AbstractUndoableEdit {
        private String oldValue;
        private String newValue;

        public SetDataSourceOptionsUndoable(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setDataSourceOptions(this.oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setDataSourceOptions(this.newValue);
        }
    }

    private class SetImportOptionsUndoable
    extends AbstractUndoableEdit {
        private String oldValue;
        private String newValue;

        public SetImportOptionsUndoable(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setImportOptions(this.oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setImportOptions(this.newValue);
        }
    }

    private class SetCASSourceUndoable
    extends AbstractUndoableEdit {
        private String oldValue;
        private String newValue;

        public SetCASSourceUndoable(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setCasSource(this.oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setCasSource(this.newValue);
        }
    }

    private class SetCASLibraryTypeUndoable
    extends AbstractUndoableEdit {
        private String oldValue;
        private String newValue;

        public SetCASLibraryTypeUndoable(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setInCasLibType(this.oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setInCasLibType(this.newValue);
        }
    }

    private class SetCASLibraryUndoable
    extends AbstractUndoableEdit {
        private String oldValue;
        private String newValue;

        public SetCASLibraryUndoable(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setInCasLib(this.oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setInCasLib(this.newValue);
        }
    }

    private class SetPersistTargetUndoable
    extends AbstractUndoableEdit {
        private boolean oldValue;
        private boolean newValue;

        public SetPersistTargetUndoable(boolean oldValue, boolean newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setPersistTarget(this.oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setPersistTarget(this.newValue);
        }
    }

    private class SetExternalFileTypeUndoable
    extends AbstractUndoableEdit {
        private String oldValue;
        private String newValue;

        public SetExternalFileTypeUndoable(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setExternalFileType(this.oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setExternalFileType(this.newValue);
        }
    }

    private class SetExternalFileUndoable
    extends AbstractUndoableEdit {
        private String oldValue;
        private String newValue;

        public SetExternalFileUndoable(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setExternalFile(this.oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setExternalFile(this.newValue);
        }
    }

    private class SetReplaceTypeUndoable
    extends AbstractUndoableEdit {
        private String oldValue;
        private String newValue;

        public SetReplaceTypeUndoable(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setReplaceType(this.oldValue);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setReplaceType(this.newValue);
        }
    }

    private class SetLoadStyleUndoable
    extends AbstractUndoableEdit {
        private String m_oldsLoadStyle;
        private String m_newsLoadStyle;

        public SetLoadStyleUndoable(String oldsStyle, String newsStyle) {
            this.m_oldsLoadStyle = oldsStyle;
            this.m_newsLoadStyle = newsStyle;
        }

        @Override
        public void undo() {
            super.undo();
            CASLoaderTransformModel.this.setLoadType(this.m_oldsLoadStyle);
        }

        @Override
        public void redo() {
            super.redo();
            CASLoaderTransformModel.this.setLoadType(this.m_newsLoadStyle);
        }
    }

    protected class CASLoaderPromptModel
    extends BaseDataTransformPromptModel {
        public CASLoaderPromptModel(CASLoaderTransformModel model) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
            super(model.getModel(), model);
        }

        @Override
        protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
            PromptGroupInterface grp = super.getPromptGroup();
            PromptGroupInterface grp1 = this.createPromptGroup(CASLoaderPromptModel.class.getResource("res/Options_CASLoader_Template.xml"));
            return this.combinePromptGroups(grp1, grp);
        }

        @Override
        protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
            super.setValuesFromModel();
            CASLoaderTransformModel tl = (CASLoaderTransformModel)this.getOwner();
            this.setOptionValue(CASLoaderTransformModel.PROMPT_SAVE_TABLE, (Object)tl.booleanToYesNo(CASLoaderTransformModel.this.getPersistTarget()));
            this.setOptionValue(CASLoaderTransformModel.PROMPT_ADDITIONAL_SAVE_OPTIONS, (Object)tl.getAdditionalSaveOptions());
            this.setOptionValue(CASLoaderTransformModel.PROMPT_DATA_SOURCE_OPTIONS, (Object)tl.getDataSourceOptions());
            this.setOptionValue(CASLoaderTransformModel.PROMPT_IMPORT_OPTIONS, (Object)tl.getImportOptions());
            this.setOptionValue(CASLoaderTransformModel.PROMPT_LOAD_STATEMENT_OPTIONS, (Object)tl.getLoadStatementOptions());
        }

        @Override
        public IPromptValueChangeListener createChangeListener() {
            return new CASLoaderTransformValueChangedListener((CASLoaderTransformModel)this.getOwner(), this);
        }

        private class CASLoaderTransformValueChangedListener
        extends BaseDataTransformValueChangedListener {
            public CASLoaderTransformValueChangedListener(CASLoaderTransformModel transformModel, IPromptModel promptModel) {
                super(transformModel, promptModel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (!this.isListeningForChanges()) {
                    return;
                }
                this.getOwner().getModel().startCompoundUndoable();
                try {
                    super.promptValueChanged(event);
                    PromptDefinitionInterface def = event.getPromptDefinition();
                    String optionName = def.getPromptName();
                    Object value = this.m_model.getOptionValue(def.getPromptName());
                    if (value == null) {
                        value = "";
                    }
                    if (CASLoaderTransformModel.PROMPT_SAVE_TABLE.equals(optionName)) {
                        CASLoaderTransformModel.this.setPersistTarget(CASLoaderTransformModel.this.yesNoToBoolean(value.toString()));
                    } else if (CASLoaderTransformModel.PROMPT_IMPORT_OPTIONS.equals(optionName)) {
                        CASLoaderTransformModel.this.setImportOptions(value.toString());
                    } else if (CASLoaderTransformModel.PROMPT_DATA_SOURCE_OPTIONS.equals(optionName)) {
                        CASLoaderTransformModel.this.setDataSourceOptions(value.toString());
                    } else if (CASLoaderTransformModel.PROMPT_ADDITIONAL_SAVE_OPTIONS.equals(optionName)) {
                        CASLoaderTransformModel.this.setAdditionalSaveOptions(value.toString());
                    } else if (CASLoaderTransformModel.PROMPT_LOAD_STATEMENT_OPTIONS.equals(optionName)) {
                        CASLoaderTransformModel.this.setLoadStatementOptions(value.toString());
                    }
                }
                finally {
                    this.getOwner().getModel().endCompoundUndoable();
                }
            }
        }

        private class CASLoaderModelListener
        extends BaseDataTransformModelListener {
            public CASLoaderModelListener(CASLoaderTransformModel transform) {
                super(transform, CASLoaderPromptModel.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void modelChanged(ModelEvent ev) {
                if (ev.getModelObject() != this.getModelObject()) {
                    return;
                }
                super.modelChanged(ev);
                this.getPromptModel().setListeningForChanges(false);
                String type = ev.getType();
                try {
                    if (CASLoaderTransformModel.PERSIST_TARGET_CHANGED.equals(type)) {
                        CASLoaderPromptModel.this.setOptionValue(CASLoaderTransformModel.PROMPT_SAVE_TABLE, (Object)CASLoaderTransformModel.this.getPersistTarget());
                    } else if (CASLoaderTransformModel.IMPORT_OPTIONS_CHANGED.equals(type)) {
                        CASLoaderPromptModel.this.setOptionValue(CASLoaderTransformModel.PROMPT_IMPORT_OPTIONS, (Object)CASLoaderTransformModel.this.getImportOptions());
                    } else if (CASLoaderTransformModel.DATA_SOURCE_OPTIONS_CHANGED.equals(type)) {
                        CASLoaderPromptModel.this.setOptionValue(CASLoaderTransformModel.PROMPT_DATA_SOURCE_OPTIONS, (Object)CASLoaderTransformModel.this.getDataSourceOptions());
                    } else if (CASLoaderTransformModel.SAVE_OPTIONS_CHANGED.equals(type)) {
                        CASLoaderPromptModel.this.setOptionValue(CASLoaderTransformModel.PROMPT_ADDITIONAL_SAVE_OPTIONS, (Object)CASLoaderTransformModel.this.getAdditionalSaveOptions());
                    } else if (CASLoaderTransformModel.LOAD_STMT_OPTIONS_CHANGED.equals(type)) {
                        CASLoaderPromptModel.this.setOptionValue(CASLoaderTransformModel.PROMPT_LOAD_STATEMENT_OPTIONS, (Object)CASLoaderTransformModel.this.getLoadStatementOptions());
                    }
                }
                catch (RemoteException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
                }
                catch (MdException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
                }
                catch (ServerConnectionException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
                }
                catch (ServiceException exc) {
                    ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
                }
                finally {
                    this.getPromptModel().setListeningForChanges(true);
                }
            }
        }
    }
}

